import binascii
import socket
import ssl


# This certificate was obtained from micropython.org using openssl:
# $ openssl s_client -showcerts -connect micropython.org:443 </dev/null 2>/dev/null
# The certificate is from Let's Encrypt:
# 1 s:C=US, O=Let's Encrypt, CN=R11
#   i:C=US, O=Internet Security Research Group, CN=ISRG Root X1
#   a:PKEY: rsaEncryption, 2048 (bit); sigalg: RSA-SHA256
#   v:NotBefore: Mar 13 00:00:00 2024 GMT; NotAfter: Mar 12 23:59:59 2027 GMT
# Copy PEM content to a file (certmpy.pem) and convert to DER e.g.
# $ openssl x509 -in certmpy.pem -out certmpy.der -outform DER
# Then convert to hex format, eg using binascii.hexlify(data).

ca_cert_chain = binascii.unhexlify(
    b"30820506308202eea0030201020211008a7d3e13d62f30ef2386bd29076b34f8300d06092a864886"
    b"f70d01010b0500304f310b300906035504061302555331293027060355040a1320496e7465726e65"
    b"742053656375726974792052657365617263682047726f7570311530130603550403130c49535247"
    b"20526f6f74205831301e170d3234303331333030303030305a170d3237303331323233353935395a"
    b"3033310b300906035504061302555331163014060355040a130d4c6574277320456e637279707431"
    b"0c300a0603550403130352313130820122300d06092a864886f70d01010105000382010f00308201"
    b"0a0282010100ba87bc5c1b0039cbca0acdd46710f9013ca54ea561cb26ca52fb1501b7b928f5281e"
    b"ed27b324183967090c08ece03ab03b770ebdf3e53954410c4eae41d69974de51dbef7bff58bda8b7"
    b"13f6de31d5f272c9726a0b8374959c4600641499f3b1d922d9cda892aa1c267a3ffeef58057b0895"
    b"81db710f8efbe33109bb09be504d5f8f91763d5a9d9e83f2e9c466b3e106664348188065a037189a"
    b"9b843297b1b2bdc4f815009d2788fbe26317966c9b27674bc4db285e69c279f0495ce02450e1c4bc"
    b"a105ac7b406d00b4c2413fa758b82fc55c9ba5bb099ef1feebb08539fda80aef45c478eb652ac2cf"
    b"5f3cdee35c4d1bf70b272baa0b4277534f796a1d87d90203010001a381f83081f5300e0603551d0f"
    b"0101ff040403020186301d0603551d250416301406082b0601050507030206082b06010505070301"
    b"30120603551d130101ff040830060101ff020100301d0603551d0e04160414c5cf46a4eaf4c3c07a"
    b"6c95c42db05e922f26e3b9301f0603551d2304183016801479b459e67bb6e5e40173800888c81a58"
    b"f6e99b6e303206082b0601050507010104263024302206082b060105050730028616687474703a2f"
    b"2f78312e692e6c656e63722e6f72672f30130603551d20040c300a3008060667810c010201302706"
    b"03551d1f0420301e301ca01aa0188616687474703a2f2f78312e632e6c656e63722e6f72672f300d"
    b"06092a864886f70d01010b050003820201004ee2895d0a031c9038d0f51ff9715cf8c38fb237887a"
    b"6fb0251fedbeb7d886068ee90984cd72bf81f3fccacf5348edbdf66942d4a5113e35c813b2921d05"
    b"5fea2ed4d8f849c3adf599969cef26d8e1b4240b48204dfcd354b4a9c621c8e1361bff77642917b9"
    b"f04bef5deacd79d0bf90bfbe23b290da4aa9483174a9440be1e2f62d8371a4757bd294c10519461c"
    b"b98ff3c47448252a0de5f5db43e2db939bb919b41f2fdf6a0e8f31d3630fbb29dcdd662c3fb01b67"
    b"51f8413ce44db9acb8a49c6663f5ab85231dcc53b6ab71aedcc50171da36ee0a182a32fd09317c8f"
    b"f673e79c9cb54a156a77825acfda8d45fe1f2a6405303e73c2c60cb9d63b634aab4603fe99c04640"
    b"276063df503a0747d8154a9fea471f995a08620cb66c33084dd738ed482d2e0568ae805def4cdcd8"
    b"20415f68f1bb5acde30eb00c31879b43de4943e1c8043fd13c1b87453069a8a9720e79121c31d83e"
    b"2357dda74fa0f01c81d1771f6fd6d2b9a8b3031681394b9f55aed26ae4b3bfeaa5d59f4ba3c9d63b"
    b"72f34af654ab0cfc38f76080df6e35ca75a154e42fbc6e17c91aa537b5a29abaecf4c075464f77a8"
    b"e8595691662d6ede2981d6a697055e6445be2cceea644244b0c34fadf0b4dc03ca999b098295820d"
    b"638a66f91972f8d5b98910e289980935f9a21cbe92732374e99d1fd73b4a9a845810c2f3a7e235ec"
    b"7e3b45ce3046526bc0c0"
)


def main(use_stream=True):
    s = socket.socket()
    ai = socket.getaddrinfo("micropython.org", 443)
    addr = ai[0][-1]
    s.connect(addr)
    s = ssl.wrap_socket(
        s, cert_reqs=ssl.CERT_REQUIRED, cadata=ca_cert_chain, server_hostname="micropython.org"
    )
    s.write(b"GET / HTTP/1.0\r\n\r\n")
    print(s.read(17))
    s.close()


main()
