/* moonshot-keyring-store.c generated by valac 0.28.0, the Vala compiler
 * generated from moonshot-keyring-store.vala, do not modify */

/*
 * Copyright (c) 2011-2014, JANET(UK)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of JANET(UK) nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
*/

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gnome-keyring.h>
#include <stdio.h>


#define TYPE_IIDENTITY_CARD_STORE (iidentity_card_store_get_type ())
#define IIDENTITY_CARD_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IIDENTITY_CARD_STORE, IIdentityCardStore))
#define IS_IIDENTITY_CARD_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IIDENTITY_CARD_STORE))
#define IIDENTITY_CARD_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IIDENTITY_CARD_STORE, IIdentityCardStoreIface))

typedef struct _IIdentityCardStore IIdentityCardStore;
typedef struct _IIdentityCardStoreIface IIdentityCardStoreIface;

#define TYPE_ID_CARD (id_card_get_type ())
#define ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ID_CARD, IdCard))
#define ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ID_CARD, IdCardClass))
#define IS_ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ID_CARD))
#define IS_ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ID_CARD))
#define ID_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ID_CARD, IdCardClass))

typedef struct _IdCard IdCard;
typedef struct _IdCardClass IdCardClass;

#define IIDENTITY_CARD_STORE_TYPE_STORE_TYPE (iidentity_card_store_store_type_get_type ())

#define TYPE_KEYRING_STORE (keyring_store_get_type ())
#define KEYRING_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEYRING_STORE, KeyringStore))
#define KEYRING_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEYRING_STORE, KeyringStoreClass))
#define IS_KEYRING_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEYRING_STORE))
#define IS_KEYRING_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEYRING_STORE))
#define KEYRING_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEYRING_STORE, KeyringStoreClass))

typedef struct _KeyringStore KeyringStore;
typedef struct _KeyringStoreClass KeyringStoreClass;
typedef struct _KeyringStorePrivate KeyringStorePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__gnome_keyring_found_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gnome_keyring_found_free0_ (var), NULL)))
#define _gnome_keyring_attribute_list_free0(var) ((var == NULL) ? NULL : (var = (gnome_keyring_attribute_list_free (var), NULL)))

#define TYPE_TRUST_ANCHOR (trust_anchor_get_type ())
#define TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRUST_ANCHOR, TrustAnchor))
#define TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRUST_ANCHOR, TrustAnchorClass))
#define IS_TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRUST_ANCHOR))
#define IS_TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRUST_ANCHOR))
#define TRUST_ANCHOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRUST_ANCHOR, TrustAnchorClass))

typedef struct _TrustAnchor TrustAnchor;
typedef struct _TrustAnchorClass TrustAnchorClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_RULE (rule_get_type ())
typedef struct _Rule Rule;

typedef enum  {
	IIDENTITY_CARD_STORE_STORE_TYPE_FLAT_FILE,
	IIDENTITY_CARD_STORE_STORE_TYPE_KEYRING
} IIdentityCardStoreStoreType;

struct _IIdentityCardStoreIface {
	GTypeInterface parent_iface;
	void (*add_card) (IIdentityCardStore* self, IdCard* card);
	gboolean (*remove_card) (IIdentityCardStore* self, IdCard* card);
	IdCard* (*update_card) (IIdentityCardStore* self, IdCard* card);
	IIdentityCardStoreStoreType (*get_store_type) (IIdentityCardStore* self);
	GeeLinkedList* (*get_card_list) (IIdentityCardStore* self);
};

struct _KeyringStore {
	GObject parent_instance;
	KeyringStorePrivate * priv;
};

struct _KeyringStoreClass {
	GObjectClass parent_class;
};

struct _KeyringStorePrivate {
	GeeLinkedList* id_card_list;
};

struct _Rule {
	gchar* pattern;
	gchar* always_confirm;
};


static gpointer keyring_store_parent_class = NULL;
static IIdentityCardStoreIface* keyring_store_iidentity_card_store_parent_iface = NULL;

GType id_card_get_type (void) G_GNUC_CONST;
GType iidentity_card_store_store_type_get_type (void) G_GNUC_CONST;
GType iidentity_card_store_get_type (void) G_GNUC_CONST;
GType keyring_store_get_type (void) G_GNUC_CONST;
#define KEYRING_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_KEYRING_STORE, KeyringStorePrivate))
enum  {
	KEYRING_STORE_DUMMY_PROPERTY
};
#define KEYRING_STORE_keyring_store_attribute "Moonshot"
#define KEYRING_STORE_keyring_store_version "1.0"
#define KEYRING_STORE_item_type GNOME_KEYRING_ITEM_GENERIC_SECRET
static void keyring_store_real_add_card (IIdentityCardStore* base, IdCard* card);
void keyring_store_store_id_cards (KeyringStore* self);
static IdCard* keyring_store_real_update_card (IIdentityCardStore* base, IdCard* card);
const gchar* id_card_get_display_name (IdCard* self);
static gboolean keyring_store_real_remove_card (IIdentityCardStore* base, IdCard* card);
static IIdentityCardStoreStoreType keyring_store_real_get_store_type (IIdentityCardStore* base);
static GeeLinkedList* keyring_store_real_get_card_list (IIdentityCardStore* base);
static void keyring_store_clear_keyring (KeyringStore* self);
static void _gnome_keyring_found_free0_ (gpointer var);
static void _g_list_free__gnome_keyring_found_free0_ (GList* self);
static void keyring_store_load_id_cards (KeyringStore* self);
IdCard* id_card_new (void);
IdCard* id_card_construct (GType object_type);
void id_card_set_issuer (IdCard* self, const gchar* value);
void id_card_set_username (IdCard* self, const gchar* value);
void id_card_set_display_name (IdCard* self, const gchar* value);
void id_card_set_services (IdCard* self, gchar** value, int value_length1);
GType trust_anchor_get_type (void) G_GNUC_CONST;
TrustAnchor* id_card_get_trust_anchor (IdCard* self);
void trust_anchor_set_ca_cert (TrustAnchor* self, const gchar* value);
void trust_anchor_set_server_cert (TrustAnchor* self, const gchar* value);
void trust_anchor_set_subject (TrustAnchor* self, const gchar* value);
void trust_anchor_set_subject_alt (TrustAnchor* self, const gchar* value);
GType rule_get_type (void) G_GNUC_CONST;
Rule* rule_dup (const Rule* self);
void rule_free (Rule* self);
void rule_copy (const Rule* self, Rule* dest);
void rule_destroy (Rule* self);
void id_card_set_rules (IdCard* self, Rule* value, int value_length1);
static void _vala_Rule_array_free (Rule* array, gint array_length);
void id_card_set_store_password (IdCard* self, gboolean value);
gboolean id_card_get_store_password (IdCard* self);
void id_card_set_password (IdCard* self, const gchar* value);
Rule* id_card_get_rules (IdCard* self, int* result_length1);
static Rule* _vala_array_dup3 (Rule* self, int length);
gchar** id_card_get_services (IdCard* self, int* result_length1);
static gchar** _vala_array_dup4 (gchar** self, int length);
const gchar* id_card_get_issuer (IdCard* self);
const gchar* id_card_get_username (IdCard* self);
const gchar* trust_anchor_get_ca_cert (TrustAnchor* self);
const gchar* trust_anchor_get_server_cert (TrustAnchor* self);
const gchar* trust_anchor_get_subject (TrustAnchor* self);
const gchar* trust_anchor_get_subject_alt (TrustAnchor* self);
const gchar* id_card_get_password (IdCard* self);
KeyringStore* keyring_store_new (void);
KeyringStore* keyring_store_construct (GType object_type);
static void keyring_store_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void keyring_store_real_add_card (IIdentityCardStore* base, IdCard* card) {
	KeyringStore * self;
	GeeLinkedList* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
#line 41 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	self = (KeyringStore*) base;
#line 41 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	g_return_if_fail (card != NULL);
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp0_ = self->priv->id_card_list;
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp1_ = card;
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 43 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	keyring_store_store_id_cards (self);
#line 209 "moonshot-keyring-store.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	return self ? g_object_ref (self) : NULL;
#line 216 "moonshot-keyring-store.c"
}


static IdCard* keyring_store_real_update_card (IIdentityCardStore* base, IdCard* card) {
	KeyringStore * self;
	IdCard* result = NULL;
	GeeLinkedList* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	GeeLinkedList* _tmp2_ = NULL;
	IdCard* _tmp3_ = NULL;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	self = (KeyringStore*) base;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	g_return_val_if_fail (card != NULL, NULL);
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp0_ = self->priv->id_card_list;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp1_ = card;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp2_ = self->priv->id_card_list;
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp3_ = card;
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, _tmp3_);
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	keyring_store_store_id_cards (self);
#line 245 "moonshot-keyring-store.c"
	{
		GeeLinkedList* _idcard_list = NULL;
		GeeLinkedList* _tmp4_ = NULL;
		GeeLinkedList* _tmp5_ = NULL;
		gint _idcard_size = 0;
		GeeLinkedList* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _idcard_index = 0;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp4_ = self->priv->id_card_list;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_idcard_list = _tmp5_;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp6_ = _idcard_list;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp8_ = _tmp7_;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_idcard_size = _tmp8_;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_idcard_index = -1;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		while (TRUE) {
#line 273 "moonshot-keyring-store.c"
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			IdCard* idcard = NULL;
			GeeLinkedList* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gpointer _tmp14_ = NULL;
			IdCard* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			IdCard* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp9_ = _idcard_index;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_idcard_index = _tmp9_ + 1;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp10_ = _idcard_index;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp11_ = _idcard_size;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			if (!(_tmp10_ < _tmp11_)) {
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				break;
#line 299 "moonshot-keyring-store.c"
			}
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp12_ = _idcard_list;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp13_ = _idcard_index;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			idcard = (IdCard*) _tmp14_;
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp15_ = idcard;
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp16_ = id_card_get_display_name (_tmp15_);
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp17_ = _tmp16_;
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp18_ = card;
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp19_ = id_card_get_display_name (_tmp18_);
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp20_ = _tmp19_;
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			if (g_strcmp0 (_tmp17_, _tmp20_) == 0) {
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				result = idcard;
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_g_object_unref0 (_idcard_list);
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				return result;
#line 329 "moonshot-keyring-store.c"
			}
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_g_object_unref0 (idcard);
#line 333 "moonshot-keyring-store.c"
		}
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_g_object_unref0 (_idcard_list);
#line 337 "moonshot-keyring-store.c"
	}
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	result = NULL;
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	return result;
#line 343 "moonshot-keyring-store.c"
}


static gboolean keyring_store_real_remove_card (IIdentityCardStore* base, IdCard* card) {
	KeyringStore * self;
	gboolean result = FALSE;
	gboolean retval = FALSE;
	GeeLinkedList* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 56 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	self = (KeyringStore*) base;
#line 56 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	g_return_val_if_fail (card != NULL, FALSE);
#line 57 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp0_ = self->priv->id_card_list;
#line 57 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp1_ = card;
#line 57 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp2_ = gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 57 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	retval = _tmp2_;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp3_ = retval;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	if (_tmp3_) {
#line 59 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		keyring_store_store_id_cards (self);
#line 373 "moonshot-keyring-store.c"
	}
#line 60 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	result = retval;
#line 60 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	return result;
#line 379 "moonshot-keyring-store.c"
}


static IIdentityCardStoreStoreType keyring_store_real_get_store_type (IIdentityCardStore* base) {
	KeyringStore * self;
	IIdentityCardStoreStoreType result = 0;
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	self = (KeyringStore*) base;
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	result = IIDENTITY_CARD_STORE_STORE_TYPE_KEYRING;
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	return result;
#line 392 "moonshot-keyring-store.c"
}


static GeeLinkedList* keyring_store_real_get_card_list (IIdentityCardStore* base) {
	KeyringStore * self;
	GeeLinkedList* result = NULL;
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
#line 67 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	self = (KeyringStore*) base;
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp0_ = self->priv->id_card_list;
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	result = _tmp1_;
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	return result;
#line 411 "moonshot-keyring-store.c"
}


static void _gnome_keyring_found_free0_ (gpointer var) {
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	(var == NULL) ? NULL : (var = (gnome_keyring_found_free (var), NULL));
#line 418 "moonshot-keyring-store.c"
}


static void _g_list_free__gnome_keyring_found_free0_ (GList* self) {
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	g_list_foreach (self, (GFunc) _gnome_keyring_found_free0_, NULL);
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	g_list_free (self);
#line 427 "moonshot-keyring-store.c"
}


static void keyring_store_clear_keyring (KeyringStore* self) {
	GnomeKeyringAttributeList* match = NULL;
	GnomeKeyringAttributeList* _tmp0_ = NULL;
	GnomeKeyringAttributeList* _tmp1_ = NULL;
	GList* items = NULL;
	GnomeKeyringAttributeList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
#line 72 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	g_return_if_fail (self != NULL);
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp0_ = gnome_keyring_attribute_list_new ();
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	match = _tmp0_;
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp1_ = match;
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	gnome_keyring_attribute_list_append_string (_tmp1_, KEYRING_STORE_keyring_store_attribute, KEYRING_STORE_keyring_store_version);
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp2_ = match;
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	gnome_keyring_find_items_sync (KEYRING_STORE_item_type, _tmp2_, &_tmp3_);
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	__g_list_free__gnome_keyring_found_free0_0 (items);
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	items = _tmp3_;
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp4_ = items;
#line 459 "moonshot-keyring-store.c"
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		entry_collection = _tmp4_;
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
#line 467 "moonshot-keyring-store.c"
			GnomeKeyringFound* entry = NULL;
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			entry = (GnomeKeyringFound*) entry_it->data;
#line 471 "moonshot-keyring-store.c"
			{
				GnomeKeyringResult _result_ = 0;
				GnomeKeyringFound* _tmp5_ = NULL;
				guint _tmp6_ = 0U;
				GnomeKeyringResult _tmp7_ = 0;
				GnomeKeyringResult _tmp8_ = 0;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp5_ = entry;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp6_ = _tmp5_->item_id;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp7_ = gnome_keyring_item_delete_sync (NULL, (guint32) _tmp6_);
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_result_ = _tmp7_;
#line 79 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp8_ = _result_;
#line 79 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				if (_tmp8_ != GNOME_KEYRING_RESULT_OK) {
#line 490 "moonshot-keyring-store.c"
					FILE* _tmp9_ = NULL;
					GnomeKeyringResult _tmp10_ = 0;
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp9_ = stdout;
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp10_ = _result_;
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					fprintf (_tmp9_, "GnomeKeyring.item_delete_sync() failed. result: %d", (gint) _tmp10_);
#line 499 "moonshot-keyring-store.c"
				}
			}
		}
	}
#line 72 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	__g_list_free__gnome_keyring_found_free0_0 (items);
#line 72 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_gnome_keyring_attribute_list_free0 (match);
#line 508 "moonshot-keyring-store.c"
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1115 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1116 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1116 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1117 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1117 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1118 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _result_;
#line 1118 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 531 "moonshot-keyring-store.c"
}


static void _vala_Rule_array_free (Rule* array, gint array_length) {
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	if (array != NULL) {
#line 538 "moonshot-keyring-store.c"
		int i;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			rule_destroy (&array[i]);
#line 544 "moonshot-keyring-store.c"
		}
	}
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	g_free (array);
#line 549 "moonshot-keyring-store.c"
}


static void keyring_store_load_id_cards (KeyringStore* self) {
	GeeLinkedList* _tmp0_ = NULL;
	GnomeKeyringAttributeList* match = NULL;
	GnomeKeyringAttributeList* _tmp1_ = NULL;
	GnomeKeyringAttributeList* _tmp2_ = NULL;
	GList* items = NULL;
	GnomeKeyringAttributeList* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	g_return_if_fail (self != NULL);
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp0_ = self->priv->id_card_list;
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp1_ = gnome_keyring_attribute_list_new ();
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	match = _tmp1_;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp2_ = match;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	gnome_keyring_attribute_list_append_string (_tmp2_, KEYRING_STORE_keyring_store_attribute, KEYRING_STORE_keyring_store_version);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp3_ = match;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	gnome_keyring_find_items_sync (KEYRING_STORE_item_type, _tmp3_, &_tmp4_);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	__g_list_free__gnome_keyring_found_free0_0 (items);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	items = _tmp4_;
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp5_ = items;
#line 586 "moonshot-keyring-store.c"
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		entry_collection = _tmp5_;
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
#line 594 "moonshot-keyring-store.c"
			GnomeKeyringFound* entry = NULL;
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			entry = (GnomeKeyringFound*) entry_it->data;
#line 598 "moonshot-keyring-store.c"
			{
				IdCard* id_card = NULL;
				IdCard* _tmp6_ = NULL;
				gint i = 0;
				gint rules_patterns_index = 0;
				gint rules_always_confirm_index = 0;
				gchar* store_password = NULL;
				gboolean _tmp76_ = FALSE;
				gint _tmp77_ = 0;
				const gchar* _tmp121_ = NULL;
				IdCard* _tmp130_ = NULL;
				gboolean _tmp131_ = FALSE;
				gboolean _tmp132_ = FALSE;
				GeeLinkedList* _tmp137_ = NULL;
				IdCard* _tmp138_ = NULL;
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp6_ = id_card_new ();
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				id_card = _tmp6_;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				rules_patterns_index = -1;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				rules_always_confirm_index = -1;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				store_password = NULL;
#line 624 "moonshot-keyring-store.c"
				{
					gboolean _tmp7_ = FALSE;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					i = 0;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp7_ = TRUE;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					while (TRUE) {
#line 633 "moonshot-keyring-store.c"
						gint _tmp9_ = 0;
						GnomeKeyringFound* _tmp10_ = NULL;
						GnomeKeyringAttributeList* _tmp11_ = NULL;
						guint _tmp12_ = 0U;
						GnomeKeyringAttribute attribute = {0};
						GnomeKeyringFound* _tmp13_ = NULL;
						GnomeKeyringAttributeList* _tmp14_ = NULL;
						GnomeKeyringAttribute* _tmp15_ = NULL;
						gint _tmp15__length1 = 0;
						gint _tmp16_ = 0;
						GnomeKeyringAttribute _tmp17_ = {0};
						gchar* value = NULL;
						GnomeKeyringAttribute _tmp18_ = {0};
						const gchar* _tmp19_ = NULL;
						gchar* _tmp20_ = NULL;
						GnomeKeyringAttribute _tmp21_ = {0};
						const gchar* _tmp22_ = NULL;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						if (!_tmp7_) {
#line 653 "moonshot-keyring-store.c"
							gint _tmp8_ = 0;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							_tmp8_ = i;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							i = _tmp8_ + 1;
#line 659 "moonshot-keyring-store.c"
						}
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp7_ = FALSE;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp9_ = i;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp10_ = entry;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp11_ = _tmp10_->attributes;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp12_ = _tmp11_->len;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						if (!(((guint) _tmp9_) < _tmp12_)) {
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							break;
#line 675 "moonshot-keyring-store.c"
						}
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp13_ = entry;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp14_ = _tmp13_->attributes;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp15_ = _tmp14_->data;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp15__length1 = -1;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp16_ = i;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp17_ = ((GnomeKeyringAttribute*) _tmp15_)[_tmp16_];
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						attribute = _tmp17_;
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp18_ = attribute;
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp19_ = _tmp18_.value.string;
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp20_ = g_strdup (_tmp19_);
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						value = _tmp20_;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp21_ = attribute;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp22_ = _tmp21_.name;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						if (g_strcmp0 (_tmp22_, "Issuer") == 0) {
#line 705 "moonshot-keyring-store.c"
							IdCard* _tmp23_ = NULL;
							const gchar* _tmp24_ = NULL;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							_tmp23_ = id_card;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							_tmp24_ = value;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							id_card_set_issuer (_tmp23_, _tmp24_);
#line 714 "moonshot-keyring-store.c"
						} else {
							GnomeKeyringAttribute _tmp25_ = {0};
							const gchar* _tmp26_ = NULL;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							_tmp25_ = attribute;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							_tmp26_ = _tmp25_.name;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							if (g_strcmp0 (_tmp26_, "Username") == 0) {
#line 724 "moonshot-keyring-store.c"
								IdCard* _tmp27_ = NULL;
								const gchar* _tmp28_ = NULL;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
								_tmp27_ = id_card;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
								_tmp28_ = value;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
								id_card_set_username (_tmp27_, _tmp28_);
#line 733 "moonshot-keyring-store.c"
							} else {
								GnomeKeyringAttribute _tmp29_ = {0};
								const gchar* _tmp30_ = NULL;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
								_tmp29_ = attribute;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
								_tmp30_ = _tmp29_.name;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
								if (g_strcmp0 (_tmp30_, "DisplayName") == 0) {
#line 743 "moonshot-keyring-store.c"
									IdCard* _tmp31_ = NULL;
									const gchar* _tmp32_ = NULL;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp31_ = id_card;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp32_ = value;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									id_card_set_display_name (_tmp31_, _tmp32_);
#line 752 "moonshot-keyring-store.c"
								} else {
									GnomeKeyringAttribute _tmp33_ = {0};
									const gchar* _tmp34_ = NULL;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp33_ = attribute;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp34_ = _tmp33_.name;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									if (g_strcmp0 (_tmp34_, "Services") == 0) {
#line 762 "moonshot-keyring-store.c"
										IdCard* _tmp35_ = NULL;
										const gchar* _tmp36_ = NULL;
										gchar** _tmp37_ = NULL;
										gchar** _tmp38_ = NULL;
										gchar** _tmp39_ = NULL;
										gint _tmp39__length1 = 0;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										_tmp35_ = id_card;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										_tmp36_ = value;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										_tmp38_ = _tmp37_ = g_strsplit (_tmp36_, ";", 0);
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										_tmp39_ = _tmp38_;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										_tmp39__length1 = _vala_array_length (_tmp37_);
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										id_card_set_services (_tmp35_, _tmp39_, _vala_array_length (_tmp37_));
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										_tmp39_ = (_vala_array_free (_tmp39_, _tmp39__length1, (GDestroyNotify) g_free), NULL);
#line 783 "moonshot-keyring-store.c"
									} else {
										GnomeKeyringAttribute _tmp40_ = {0};
										const gchar* _tmp41_ = NULL;
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										_tmp40_ = attribute;
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										_tmp41_ = _tmp40_.name;
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										if (g_strcmp0 (_tmp41_, "Rules-Pattern") == 0) {
#line 793 "moonshot-keyring-store.c"
											gint _tmp42_ = 0;
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
											_tmp42_ = i;
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
											rules_patterns_index = _tmp42_;
#line 799 "moonshot-keyring-store.c"
										} else {
											GnomeKeyringAttribute _tmp43_ = {0};
											const gchar* _tmp44_ = NULL;
#line 111 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
											_tmp43_ = attribute;
#line 111 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
											_tmp44_ = _tmp43_.name;
#line 111 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
											if (g_strcmp0 (_tmp44_, "Rules-AlwaysConfirm") == 0) {
#line 809 "moonshot-keyring-store.c"
												gint _tmp45_ = 0;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
												_tmp45_ = i;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
												rules_always_confirm_index = _tmp45_;
#line 815 "moonshot-keyring-store.c"
											} else {
												GnomeKeyringAttribute _tmp46_ = {0};
												const gchar* _tmp47_ = NULL;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
												_tmp46_ = attribute;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
												_tmp47_ = _tmp46_.name;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
												if (g_strcmp0 (_tmp47_, "CA-Cert") == 0) {
#line 825 "moonshot-keyring-store.c"
													IdCard* _tmp48_ = NULL;
													TrustAnchor* _tmp49_ = NULL;
													TrustAnchor* _tmp50_ = NULL;
													const gchar* _tmp51_ = NULL;
													gchar* _tmp52_ = NULL;
													gchar* _tmp53_ = NULL;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
													_tmp48_ = id_card;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
													_tmp49_ = id_card_get_trust_anchor (_tmp48_);
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
													_tmp50_ = _tmp49_;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
													_tmp51_ = value;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
													_tmp52_ = string_strip (_tmp51_);
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
													_tmp53_ = _tmp52_;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
													trust_anchor_set_ca_cert (_tmp50_, _tmp53_);
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
													_g_free0 (_tmp53_);
#line 848 "moonshot-keyring-store.c"
												} else {
													GnomeKeyringAttribute _tmp54_ = {0};
													const gchar* _tmp55_ = NULL;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
													_tmp54_ = attribute;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
													_tmp55_ = _tmp54_.name;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
													if (g_strcmp0 (_tmp55_, "Server-Cert") == 0) {
#line 858 "moonshot-keyring-store.c"
														IdCard* _tmp56_ = NULL;
														TrustAnchor* _tmp57_ = NULL;
														TrustAnchor* _tmp58_ = NULL;
														const gchar* _tmp59_ = NULL;
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
														_tmp56_ = id_card;
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
														_tmp57_ = id_card_get_trust_anchor (_tmp56_);
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
														_tmp58_ = _tmp57_;
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
														_tmp59_ = value;
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
														trust_anchor_set_server_cert (_tmp58_, _tmp59_);
#line 873 "moonshot-keyring-store.c"
													} else {
														GnomeKeyringAttribute _tmp60_ = {0};
														const gchar* _tmp61_ = NULL;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
														_tmp60_ = attribute;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
														_tmp61_ = _tmp60_.name;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
														if (g_strcmp0 (_tmp61_, "Subject") == 0) {
#line 883 "moonshot-keyring-store.c"
															IdCard* _tmp62_ = NULL;
															TrustAnchor* _tmp63_ = NULL;
															TrustAnchor* _tmp64_ = NULL;
															const gchar* _tmp65_ = NULL;
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
															_tmp62_ = id_card;
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
															_tmp63_ = id_card_get_trust_anchor (_tmp62_);
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
															_tmp64_ = _tmp63_;
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
															_tmp65_ = value;
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
															trust_anchor_set_subject (_tmp64_, _tmp65_);
#line 898 "moonshot-keyring-store.c"
														} else {
															GnomeKeyringAttribute _tmp66_ = {0};
															const gchar* _tmp67_ = NULL;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
															_tmp66_ = attribute;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
															_tmp67_ = _tmp66_.name;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
															if (g_strcmp0 (_tmp67_, "Subject-Alt") == 0) {
#line 908 "moonshot-keyring-store.c"
																IdCard* _tmp68_ = NULL;
																TrustAnchor* _tmp69_ = NULL;
																TrustAnchor* _tmp70_ = NULL;
																const gchar* _tmp71_ = NULL;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																_tmp68_ = id_card;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																_tmp69_ = id_card_get_trust_anchor (_tmp68_);
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																_tmp70_ = _tmp69_;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																_tmp71_ = value;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																trust_anchor_set_subject_alt (_tmp70_, _tmp71_);
#line 923 "moonshot-keyring-store.c"
															} else {
																GnomeKeyringAttribute _tmp72_ = {0};
																const gchar* _tmp73_ = NULL;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																_tmp72_ = attribute;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																_tmp73_ = _tmp72_.name;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																if (g_strcmp0 (_tmp73_, "StorePassword") == 0) {
#line 933 "moonshot-keyring-store.c"
																	const gchar* _tmp74_ = NULL;
																	gchar* _tmp75_ = NULL;
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																	_tmp74_ = value;
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																	_tmp75_ = g_strdup (_tmp74_);
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																	_g_free0 (store_password);
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																	store_password = _tmp75_;
#line 944 "moonshot-keyring-store.c"
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_g_free0 (value);
#line 958 "moonshot-keyring-store.c"
					}
				}
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp77_ = rules_always_confirm_index;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				if (_tmp77_ != (-1)) {
#line 965 "moonshot-keyring-store.c"
					gint _tmp78_ = 0;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp78_ = rules_patterns_index;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp76_ = _tmp78_ != (-1);
#line 971 "moonshot-keyring-store.c"
				} else {
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp76_ = FALSE;
#line 975 "moonshot-keyring-store.c"
				}
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				if (_tmp76_) {
#line 979 "moonshot-keyring-store.c"
					gchar* rules_patterns_all = NULL;
					GnomeKeyringFound* _tmp79_ = NULL;
					GnomeKeyringAttributeList* _tmp80_ = NULL;
					GnomeKeyringAttribute* _tmp81_ = NULL;
					gint _tmp81__length1 = 0;
					gint _tmp82_ = 0;
					GnomeKeyringAttribute _tmp83_ = {0};
					const gchar* _tmp84_ = NULL;
					gchar* _tmp85_ = NULL;
					gchar* rules_always_confirm_all = NULL;
					GnomeKeyringFound* _tmp86_ = NULL;
					GnomeKeyringAttributeList* _tmp87_ = NULL;
					GnomeKeyringAttribute* _tmp88_ = NULL;
					gint _tmp88__length1 = 0;
					gint _tmp89_ = 0;
					GnomeKeyringAttribute _tmp90_ = {0};
					const gchar* _tmp91_ = NULL;
					gchar* _tmp92_ = NULL;
					gchar** rules_always_confirm = NULL;
					const gchar* _tmp93_ = NULL;
					gchar** _tmp94_ = NULL;
					gchar** _tmp95_ = NULL;
					gint rules_always_confirm_length1 = 0;
					gint _rules_always_confirm_size_ = 0;
					gchar** rules_patterns = NULL;
					const gchar* _tmp96_ = NULL;
					gchar** _tmp97_ = NULL;
					gchar** _tmp98_ = NULL;
					gint rules_patterns_length1 = 0;
					gint _rules_patterns_size_ = 0;
					gchar** _tmp99_ = NULL;
					gint _tmp99__length1 = 0;
					gchar** _tmp100_ = NULL;
					gint _tmp100__length1 = 0;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp79_ = entry;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp80_ = _tmp79_->attributes;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp81_ = _tmp80_->data;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp81__length1 = -1;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp82_ = rules_patterns_index;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp83_ = ((GnomeKeyringAttribute*) _tmp81_)[_tmp82_];
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp84_ = _tmp83_.value.string;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp85_ = g_strdup (_tmp84_);
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					rules_patterns_all = _tmp85_;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp86_ = entry;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp87_ = _tmp86_->attributes;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp88_ = _tmp87_->data;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp88__length1 = -1;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp89_ = rules_always_confirm_index;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp90_ = ((GnomeKeyringAttribute*) _tmp88_)[_tmp89_];
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp91_ = _tmp90_.value.string;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp92_ = g_strdup (_tmp91_);
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					rules_always_confirm_all = _tmp92_;
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp93_ = rules_always_confirm_all;
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp95_ = _tmp94_ = g_strsplit (_tmp93_, ";", 0);
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					rules_always_confirm = _tmp95_;
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					rules_always_confirm_length1 = _vala_array_length (_tmp94_);
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_rules_always_confirm_size_ = rules_always_confirm_length1;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp96_ = rules_patterns_all;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp98_ = _tmp97_ = g_strsplit (_tmp96_, ";", 0);
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					rules_patterns = _tmp98_;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					rules_patterns_length1 = _vala_array_length (_tmp97_);
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_rules_patterns_size_ = rules_patterns_length1;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp99_ = rules_patterns;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp99__length1 = rules_patterns_length1;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp100_ = rules_always_confirm;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp100__length1 = rules_always_confirm_length1;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					if (_tmp99__length1 == _tmp100__length1) {
#line 1080 "moonshot-keyring-store.c"
						Rule* rules = NULL;
						gchar** _tmp101_ = NULL;
						gint _tmp101__length1 = 0;
						Rule* _tmp102_ = NULL;
						gint rules_length1 = 0;
						gint _rules_size_ = 0;
						IdCard* _tmp119_ = NULL;
						Rule* _tmp120_ = NULL;
						gint _tmp120__length1 = 0;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp101_ = rules_patterns;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp101__length1 = rules_patterns_length1;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp102_ = g_new0 (Rule, _tmp101__length1);
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						rules = _tmp102_;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						rules_length1 = _tmp101__length1;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_rules_size_ = rules_length1;
#line 1102 "moonshot-keyring-store.c"
						{
							gint j = 0;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							j = 0;
#line 1107 "moonshot-keyring-store.c"
							{
								gboolean _tmp103_ = FALSE;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
								_tmp103_ = TRUE;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
								while (TRUE) {
#line 1114 "moonshot-keyring-store.c"
									gint _tmp105_ = 0;
									gchar** _tmp106_ = NULL;
									gint _tmp106__length1 = 0;
									Rule* _tmp107_ = NULL;
									gint _tmp107__length1 = 0;
									gint _tmp108_ = 0;
									gchar** _tmp109_ = NULL;
									gint _tmp109__length1 = 0;
									gint _tmp110_ = 0;
									const gchar* _tmp111_ = NULL;
									gchar* _tmp112_ = NULL;
									Rule* _tmp113_ = NULL;
									gint _tmp113__length1 = 0;
									gint _tmp114_ = 0;
									gchar** _tmp115_ = NULL;
									gint _tmp115__length1 = 0;
									gint _tmp116_ = 0;
									const gchar* _tmp117_ = NULL;
									gchar* _tmp118_ = NULL;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									if (!_tmp103_) {
#line 1136 "moonshot-keyring-store.c"
										gint _tmp104_ = 0;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										_tmp104_ = j;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										j = _tmp104_ + 1;
#line 1142 "moonshot-keyring-store.c"
									}
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp103_ = FALSE;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp105_ = j;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp106_ = rules_patterns;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp106__length1 = rules_patterns_length1;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									if (!(_tmp105_ < _tmp106__length1)) {
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										break;
#line 1156 "moonshot-keyring-store.c"
									}
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp107_ = rules;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp107__length1 = rules_length1;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp108_ = j;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp109_ = rules_patterns;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp109__length1 = rules_patterns_length1;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp110_ = j;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp111_ = _tmp109_[_tmp110_];
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp112_ = g_strdup (_tmp111_);
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_g_free0 (_tmp107_[_tmp108_].pattern);
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp107_[_tmp108_].pattern = _tmp112_;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp113_ = rules;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp113__length1 = rules_length1;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp114_ = j;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp115_ = rules_always_confirm;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp115__length1 = rules_always_confirm_length1;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp116_ = j;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp117_ = _tmp115_[_tmp116_];
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp118_ = g_strdup (_tmp117_);
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_g_free0 (_tmp113_[_tmp114_].always_confirm);
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp113_[_tmp114_].always_confirm = _tmp118_;
#line 1198 "moonshot-keyring-store.c"
								}
							}
						}
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp119_ = id_card;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp120_ = rules;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp120__length1 = rules_length1;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						id_card_set_rules (_tmp119_, _tmp120_, _tmp120__length1);
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						rules = (_vala_Rule_array_free (rules, rules_length1), NULL);
#line 1212 "moonshot-keyring-store.c"
					}
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					rules_patterns = (_vala_array_free (rules_patterns, rules_patterns_length1, (GDestroyNotify) g_free), NULL);
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					rules_always_confirm = (_vala_array_free (rules_always_confirm, rules_always_confirm_length1, (GDestroyNotify) g_free), NULL);
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_g_free0 (rules_always_confirm_all);
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_g_free0 (rules_patterns_all);
#line 1222 "moonshot-keyring-store.c"
				}
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp121_ = store_password;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				if (_tmp121_ != NULL) {
#line 1228 "moonshot-keyring-store.c"
					IdCard* _tmp122_ = NULL;
					const gchar* _tmp123_ = NULL;
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp122_ = id_card;
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp123_ = store_password;
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					id_card_set_store_password (_tmp122_, g_strcmp0 (_tmp123_, "yes") == 0);
#line 1237 "moonshot-keyring-store.c"
				} else {
					gboolean _tmp124_ = FALSE;
					GnomeKeyringFound* _tmp125_ = NULL;
					const gchar* _tmp126_ = NULL;
					IdCard* _tmp129_ = NULL;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp125_ = entry;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp126_ = _tmp125_->secret;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					if (_tmp126_ != NULL) {
#line 1249 "moonshot-keyring-store.c"
						GnomeKeyringFound* _tmp127_ = NULL;
						const gchar* _tmp128_ = NULL;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp127_ = entry;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp128_ = _tmp127_->secret;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp124_ = g_strcmp0 (_tmp128_, "") != 0;
#line 1258 "moonshot-keyring-store.c"
					} else {
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp124_ = FALSE;
#line 1262 "moonshot-keyring-store.c"
					}
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp129_ = id_card;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					id_card_set_store_password (_tmp129_, _tmp124_);
#line 1268 "moonshot-keyring-store.c"
				}
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp130_ = id_card;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp131_ = id_card_get_store_password (_tmp130_);
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp132_ = _tmp131_;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				if (_tmp132_) {
#line 1278 "moonshot-keyring-store.c"
					IdCard* _tmp133_ = NULL;
					GnomeKeyringFound* _tmp134_ = NULL;
					const gchar* _tmp135_ = NULL;
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp133_ = id_card;
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp134_ = entry;
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp135_ = _tmp134_->secret;
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					id_card_set_password (_tmp133_, _tmp135_);
#line 1290 "moonshot-keyring-store.c"
				} else {
					IdCard* _tmp136_ = NULL;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp136_ = id_card;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					id_card_set_password (_tmp136_, NULL);
#line 1297 "moonshot-keyring-store.c"
				}
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp137_ = self->priv->id_card_list;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp138_ = id_card;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp137_, _tmp138_);
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_g_free0 (store_password);
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_g_object_unref0 (id_card);
#line 1309 "moonshot-keyring-store.c"
			}
		}
	}
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	__g_list_free__gnome_keyring_found_free0_0 (items);
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_gnome_keyring_attribute_list_free0 (match);
#line 1317 "moonshot-keyring-store.c"
}


static Rule* _vala_array_dup3 (Rule* self, int length) {
	Rule* result;
	int i;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	result = g_new0 (Rule, length);
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	for (i = 0; i < length; i++) {
#line 1328 "moonshot-keyring-store.c"
		Rule _tmp0_ = {0};
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		rule_copy (&self[i], &_tmp0_);
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		result[i] = _tmp0_;
#line 1334 "moonshot-keyring-store.c"
	}
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	return result;
#line 1338 "moonshot-keyring-store.c"
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	result = g_new0 (gchar*, length + 1);
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	for (i = 0; i < length; i++) {
#line 1349 "moonshot-keyring-store.c"
		gchar* _tmp0_ = NULL;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp0_ = g_strdup (self[i]);
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		result[i] = _tmp0_;
#line 1355 "moonshot-keyring-store.c"
	}
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	return result;
#line 1359 "moonshot-keyring-store.c"
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
#line 964 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = separator;
#line 964 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp0_ == NULL) {
#line 965 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		separator = "";
#line 1376 "moonshot-keyring-store.c"
	}
#line 967 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = str_array;
#line 967 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3__length1 = str_array_length1;
#line 967 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 967 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = TRUE;
#line 1386 "moonshot-keyring-store.c"
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
#line 967 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = str_array;
#line 967 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4__length1 = str_array_length1;
#line 967 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp4__length1 > 0;
#line 1396 "moonshot-keyring-store.c"
	}
#line 967 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp2_) {
#line 967 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 1402 "moonshot-keyring-store.c"
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
#line 967 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = str_array;
#line 967 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6__length1 = str_array_length1;
#line 967 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		if (_tmp6__length1 == (-1)) {
#line 1413 "moonshot-keyring-store.c"
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			const gchar* _tmp8_ = NULL;
#line 967 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp7_ = str_array;
#line 967 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp7__length1 = str_array_length1;
#line 967 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp8_ = _tmp7_[0];
#line 967 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp5_ = _tmp8_ != NULL;
#line 1425 "moonshot-keyring-store.c"
		} else {
#line 967 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp5_ = FALSE;
#line 1429 "moonshot-keyring-store.c"
		}
#line 967 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp1_ = _tmp5_;
#line 1433 "moonshot-keyring-store.c"
	}
#line 967 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp1_) {
#line 1437 "moonshot-keyring-store.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gsize _tmp35_ = 0UL;
		const gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		const gchar* res = NULL;
		gsize _tmp40_ = 0UL;
		void* _tmp41_ = NULL;
		void* ptr = NULL;
		const gchar* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		const gchar* _tmp44_ = NULL;
		void* _tmp45_ = NULL;
		const gchar* _tmp62_ = NULL;
#line 969 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		len = (gsize) 1;
#line 1460 "moonshot-keyring-store.c"
		{
			gboolean _tmp9_ = FALSE;
#line 970 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
			i = 0;
#line 970 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp9_ = TRUE;
#line 970 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 1469 "moonshot-keyring-store.c"
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp21_ = 0;
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				const gchar* _tmp24_ = NULL;
				gsize _tmp30_ = 0UL;
#line 970 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				if (!_tmp9_) {
#line 1482 "moonshot-keyring-store.c"
					gint _tmp10_ = 0;
#line 970 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp10_ = i;
#line 970 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					i = _tmp10_ + 1;
#line 1488 "moonshot-keyring-store.c"
				}
#line 970 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp9_ = FALSE;
#line 970 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp13_ = str_array;
#line 970 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp13__length1 = str_array_length1;
#line 970 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				if (_tmp13__length1 != (-1)) {
#line 1498 "moonshot-keyring-store.c"
					gint _tmp14_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
#line 970 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp14_ = i;
#line 970 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp15_ = str_array;
#line 970 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp15__length1 = str_array_length1;
#line 970 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp12_ = _tmp14_ < _tmp15__length1;
#line 1510 "moonshot-keyring-store.c"
				} else {
#line 970 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp12_ = FALSE;
#line 1514 "moonshot-keyring-store.c"
				}
#line 970 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				if (_tmp12_) {
#line 970 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp11_ = TRUE;
#line 1520 "moonshot-keyring-store.c"
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
#line 970 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp17_ = str_array;
#line 970 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp17__length1 = str_array_length1;
#line 970 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					if (_tmp17__length1 == (-1)) {
#line 1531 "moonshot-keyring-store.c"
						gchar** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						gint _tmp19_ = 0;
						const gchar* _tmp20_ = NULL;
#line 970 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp18_ = str_array;
#line 970 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp18__length1 = str_array_length1;
#line 970 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp19_ = i;
#line 970 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp20_ = _tmp18_[_tmp19_];
#line 970 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp16_ = _tmp20_ != NULL;
#line 1546 "moonshot-keyring-store.c"
					} else {
#line 970 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp16_ = FALSE;
#line 1550 "moonshot-keyring-store.c"
					}
#line 970 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp11_ = _tmp16_;
#line 1554 "moonshot-keyring-store.c"
				}
#line 970 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				if (!_tmp11_) {
#line 970 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					break;
#line 1560 "moonshot-keyring-store.c"
				}
#line 971 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp22_ = str_array;
#line 971 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp22__length1 = str_array_length1;
#line 971 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp23_ = i;
#line 971 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp24_ = _tmp22_[_tmp23_];
#line 971 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				if (_tmp24_ != NULL) {
#line 1572 "moonshot-keyring-store.c"
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
#line 971 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp25_ = str_array;
#line 971 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp25__length1 = str_array_length1;
#line 971 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp26_ = i;
#line 971 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp27_ = _tmp25_[_tmp26_];
#line 971 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp28_ = strlen ((const gchar*) _tmp27_);
#line 971 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp29_ = _tmp28_;
#line 971 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp21_ = _tmp29_;
#line 1593 "moonshot-keyring-store.c"
				} else {
#line 971 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp21_ = 0;
#line 1597 "moonshot-keyring-store.c"
				}
#line 971 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp30_ = len;
#line 971 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				len = _tmp30_ + _tmp21_;
#line 1603 "moonshot-keyring-store.c"
			}
		}
#line 973 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp31_ = i;
#line 973 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		if (_tmp31_ == 0) {
#line 1610 "moonshot-keyring-store.c"
			gchar* _tmp32_ = NULL;
#line 974 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp32_ = g_strdup ("");
#line 974 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
			result = _tmp32_;
#line 974 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
			return result;
#line 1618 "moonshot-keyring-store.c"
		}
#line 976 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp33_ = i;
#line 976 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		str_array_length1 = _tmp33_;
#line 976 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp34_ = str_array_length1;
#line 977 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp35_ = len;
#line 977 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp36_ = separator;
#line 977 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp37_ = strlen ((const gchar*) _tmp36_);
#line 977 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp38_ = _tmp37_;
#line 977 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp39_ = i;
#line 977 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
#line 979 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp40_ = len;
#line 979 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp41_ = g_malloc (_tmp40_);
#line 979 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		res = _tmp41_;
#line 980 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp42_ = res;
#line 980 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp43_ = str_array;
#line 980 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp43__length1 = str_array_length1;
#line 980 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp44_ = _tmp43_[0];
#line 980 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
#line 980 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		ptr = _tmp45_;
#line 1656 "moonshot-keyring-store.c"
		{
			gboolean _tmp46_ = FALSE;
#line 981 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
			i = 1;
#line 981 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp46_ = TRUE;
#line 981 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 1665 "moonshot-keyring-store.c"
				gint _tmp48_ = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				void* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				void* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gint _tmp55_ = 0;
				const gchar* _tmp56_ = NULL;
				void* _tmp60_ = NULL;
				void* _tmp61_ = NULL;
#line 981 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				if (!_tmp46_) {
#line 1681 "moonshot-keyring-store.c"
					gint _tmp47_ = 0;
#line 981 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp47_ = i;
#line 981 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					i = _tmp47_ + 1;
#line 1687 "moonshot-keyring-store.c"
				}
#line 981 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp46_ = FALSE;
#line 981 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp48_ = i;
#line 981 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp49_ = str_array;
#line 981 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp49__length1 = str_array_length1;
#line 981 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				if (!(_tmp48_ < _tmp49__length1)) {
#line 981 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					break;
#line 1701 "moonshot-keyring-store.c"
				}
#line 982 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp50_ = ptr;
#line 982 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp51_ = separator;
#line 982 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
#line 982 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				ptr = _tmp52_;
#line 983 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp54_ = str_array;
#line 983 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp54__length1 = str_array_length1;
#line 983 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp55_ = i;
#line 983 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp56_ = _tmp54_[_tmp55_];
#line 983 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				if (_tmp56_ != NULL) {
#line 1721 "moonshot-keyring-store.c"
					gchar** _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp58_ = 0;
					const gchar* _tmp59_ = NULL;
#line 983 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp57_ = str_array;
#line 983 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp57__length1 = str_array_length1;
#line 983 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp58_ = i;
#line 983 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp59_ = _tmp57_[_tmp58_];
#line 983 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp53_ = (const gchar*) _tmp59_;
#line 1736 "moonshot-keyring-store.c"
				} else {
#line 983 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp53_ = "";
#line 1740 "moonshot-keyring-store.c"
				}
#line 983 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp60_ = ptr;
#line 983 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
#line 983 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
				ptr = _tmp61_;
#line 1748 "moonshot-keyring-store.c"
			}
		}
#line 986 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp62_ = res;
#line 986 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		res = NULL;
#line 986 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (gchar*) _tmp62_;
#line 986 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 1759 "moonshot-keyring-store.c"
	} else {
		gchar* _tmp63_ = NULL;
#line 988 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp63_ = g_strdup ("");
#line 988 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp63_;
#line 988 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 1768 "moonshot-keyring-store.c"
	}
}


void keyring_store_store_id_cards (KeyringStore* self) {
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	g_return_if_fail (self != NULL);
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	keyring_store_clear_keyring (self);
#line 1778 "moonshot-keyring-store.c"
	{
		GeeLinkedList* _id_card_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _id_card_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _id_card_index = 0;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp0_ = self->priv->id_card_list;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_id_card_list = _tmp1_;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp2_ = _id_card_list;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp4_ = _tmp3_;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_id_card_size = _tmp4_;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_id_card_index = -1;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		while (TRUE) {
#line 1806 "moonshot-keyring-store.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			IdCard* id_card = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			Rule* rules = NULL;
			IdCard* _tmp11_ = NULL;
			Rule* _tmp12_ = NULL;
			gint _tmp12__length1 = 0;
			Rule* _tmp13_ = NULL;
			gint _tmp13__length1 = 0;
			Rule* _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			gint rules_length1 = 0;
			gint _rules_size_ = 0;
			gchar** services_array = NULL;
			IdCard* _tmp15_ = NULL;
			gchar** _tmp16_ = NULL;
			gint _tmp16__length1 = 0;
			gchar** _tmp17_ = NULL;
			gint _tmp17__length1 = 0;
			gchar** _tmp18_ = NULL;
			gint _tmp18__length1 = 0;
			gint services_array_length1 = 0;
			gint _services_array_size_ = 0;
			gchar** rules_patterns = NULL;
			Rule* _tmp19_ = NULL;
			gint _tmp19__length1 = 0;
			gchar** _tmp20_ = NULL;
			gint rules_patterns_length1 = 0;
			gint _rules_patterns_size_ = 0;
			gchar** rules_always_conf = NULL;
			Rule* _tmp21_ = NULL;
			gint _tmp21__length1 = 0;
			gchar** _tmp22_ = NULL;
			gint rules_always_conf_length1 = 0;
			gint _rules_always_conf_size_ = 0;
			gchar* patterns = NULL;
			gchar** _tmp43_ = NULL;
			gint _tmp43__length1 = 0;
			gchar* _tmp44_ = NULL;
			gchar* always_conf = NULL;
			gchar** _tmp45_ = NULL;
			gint _tmp45__length1 = 0;
			gchar* _tmp46_ = NULL;
			gchar* services = NULL;
			gchar** _tmp47_ = NULL;
			gint _tmp47__length1 = 0;
			gchar* _tmp48_ = NULL;
			GnomeKeyringAttributeList* attributes = NULL;
			GnomeKeyringAttributeList* _tmp49_ = NULL;
			guint32 item_id = 0U;
			GnomeKeyringAttributeList* _tmp50_ = NULL;
			GnomeKeyringAttributeList* _tmp51_ = NULL;
			IdCard* _tmp52_ = NULL;
			const gchar* _tmp53_ = NULL;
			const gchar* _tmp54_ = NULL;
			GnomeKeyringAttributeList* _tmp55_ = NULL;
			IdCard* _tmp56_ = NULL;
			const gchar* _tmp57_ = NULL;
			const gchar* _tmp58_ = NULL;
			GnomeKeyringAttributeList* _tmp59_ = NULL;
			IdCard* _tmp60_ = NULL;
			const gchar* _tmp61_ = NULL;
			const gchar* _tmp62_ = NULL;
			GnomeKeyringAttributeList* _tmp63_ = NULL;
			const gchar* _tmp64_ = NULL;
			GnomeKeyringAttributeList* _tmp65_ = NULL;
			const gchar* _tmp66_ = NULL;
			GnomeKeyringAttributeList* _tmp67_ = NULL;
			const gchar* _tmp68_ = NULL;
			GnomeKeyringAttributeList* _tmp69_ = NULL;
			IdCard* _tmp70_ = NULL;
			TrustAnchor* _tmp71_ = NULL;
			TrustAnchor* _tmp72_ = NULL;
			const gchar* _tmp73_ = NULL;
			const gchar* _tmp74_ = NULL;
			GnomeKeyringAttributeList* _tmp75_ = NULL;
			IdCard* _tmp76_ = NULL;
			TrustAnchor* _tmp77_ = NULL;
			TrustAnchor* _tmp78_ = NULL;
			const gchar* _tmp79_ = NULL;
			const gchar* _tmp80_ = NULL;
			GnomeKeyringAttributeList* _tmp81_ = NULL;
			IdCard* _tmp82_ = NULL;
			TrustAnchor* _tmp83_ = NULL;
			TrustAnchor* _tmp84_ = NULL;
			const gchar* _tmp85_ = NULL;
			const gchar* _tmp86_ = NULL;
			GnomeKeyringAttributeList* _tmp87_ = NULL;
			IdCard* _tmp88_ = NULL;
			TrustAnchor* _tmp89_ = NULL;
			TrustAnchor* _tmp90_ = NULL;
			const gchar* _tmp91_ = NULL;
			const gchar* _tmp92_ = NULL;
			const gchar* _tmp93_ = NULL;
			IdCard* _tmp94_ = NULL;
			gboolean _tmp95_ = FALSE;
			gboolean _tmp96_ = FALSE;
			GnomeKeyringAttributeList* _tmp97_ = NULL;
			const gchar* _tmp98_ = NULL;
			IdCard* _tmp99_ = NULL;
			gboolean _tmp100_ = FALSE;
			gboolean _tmp101_ = FALSE;
			GnomeKeyringResult _result_ = 0;
			IdCard* _tmp105_ = NULL;
			const gchar* _tmp106_ = NULL;
			const gchar* _tmp107_ = NULL;
			GnomeKeyringAttributeList* _tmp108_ = NULL;
			guint32 _tmp109_ = 0U;
			GnomeKeyringResult _tmp110_ = 0;
			GnomeKeyringResult _tmp111_ = 0;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp5_ = _id_card_index;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_id_card_index = _tmp5_ + 1;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp6_ = _id_card_index;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp7_ = _id_card_size;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				break;
#line 1933 "moonshot-keyring-store.c"
			}
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp8_ = _id_card_list;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp9_ = _id_card_index;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			id_card = (IdCard*) _tmp10_;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp11_ = id_card;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp12_ = id_card_get_rules (_tmp11_, &_tmp12__length1);
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp13_ = _tmp12_;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp13__length1 = _tmp12__length1;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp14_ = (_tmp13_ != NULL) ? _vala_array_dup3 (_tmp13_, _tmp13__length1) : ((gpointer) _tmp13_);
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp14__length1 = _tmp13__length1;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			rules = _tmp14_;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			rules_length1 = _tmp14__length1;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_rules_size_ = rules_length1;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp15_ = id_card;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp16_ = id_card_get_services (_tmp15_, &_tmp16__length1);
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp17_ = _tmp16_;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp17__length1 = _tmp16__length1;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp18_ = (_tmp17_ != NULL) ? _vala_array_dup4 (_tmp17_, _tmp17__length1) : ((gpointer) _tmp17_);
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp18__length1 = _tmp17__length1;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			services_array = _tmp18_;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			services_array_length1 = _tmp18__length1;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_services_array_size_ = services_array_length1;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp19_ = rules;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp19__length1 = rules_length1;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp20_ = g_new0 (gchar*, _tmp19__length1 + 1);
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			rules_patterns = _tmp20_;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			rules_patterns_length1 = _tmp19__length1;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_rules_patterns_size_ = rules_patterns_length1;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp21_ = rules;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp21__length1 = rules_length1;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp22_ = g_new0 (gchar*, _tmp21__length1 + 1);
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			rules_always_conf = _tmp22_;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			rules_always_conf_length1 = _tmp21__length1;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_rules_always_conf_size_ = rules_always_conf_length1;
#line 2003 "moonshot-keyring-store.c"
			{
				gint i = 0;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				i = 0;
#line 2008 "moonshot-keyring-store.c"
				{
					gboolean _tmp23_ = FALSE;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp23_ = TRUE;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					while (TRUE) {
#line 2015 "moonshot-keyring-store.c"
						gint _tmp25_ = 0;
						Rule* _tmp26_ = NULL;
						gint _tmp26__length1 = 0;
						gchar** _tmp27_ = NULL;
						gint _tmp27__length1 = 0;
						gint _tmp28_ = 0;
						Rule* _tmp29_ = NULL;
						gint _tmp29__length1 = 0;
						gint _tmp30_ = 0;
						Rule _tmp31_ = {0};
						const gchar* _tmp32_ = NULL;
						gchar* _tmp33_ = NULL;
						gchar* _tmp34_ = NULL;
						gchar** _tmp35_ = NULL;
						gint _tmp35__length1 = 0;
						gint _tmp36_ = 0;
						Rule* _tmp37_ = NULL;
						gint _tmp37__length1 = 0;
						gint _tmp38_ = 0;
						Rule _tmp39_ = {0};
						const gchar* _tmp40_ = NULL;
						gchar* _tmp41_ = NULL;
						gchar* _tmp42_ = NULL;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						if (!_tmp23_) {
#line 2041 "moonshot-keyring-store.c"
							gint _tmp24_ = 0;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							_tmp24_ = i;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							i = _tmp24_ + 1;
#line 2047 "moonshot-keyring-store.c"
						}
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp23_ = FALSE;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp25_ = i;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp26_ = rules;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp26__length1 = rules_length1;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						if (!(_tmp25_ < _tmp26__length1)) {
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							break;
#line 2061 "moonshot-keyring-store.c"
						}
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp27_ = rules_patterns;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp27__length1 = rules_patterns_length1;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp28_ = i;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp29_ = rules;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp29__length1 = rules_length1;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp30_ = i;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp31_ = _tmp29_[_tmp30_];
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp32_ = _tmp31_.pattern;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp33_ = g_strdup (_tmp32_);
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_g_free0 (_tmp27_[_tmp28_]);
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp27_[_tmp28_] = _tmp33_;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp34_ = _tmp27_[_tmp28_];
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp35_ = rules_always_conf;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp35__length1 = rules_always_conf_length1;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp36_ = i;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp37_ = rules;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp37__length1 = rules_length1;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp38_ = i;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp39_ = _tmp37_[_tmp38_];
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp40_ = _tmp39_.always_confirm;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp41_ = g_strdup (_tmp40_);
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_g_free0 (_tmp35_[_tmp36_]);
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp35_[_tmp36_] = _tmp41_;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp42_ = _tmp35_[_tmp36_];
#line 2111 "moonshot-keyring-store.c"
					}
				}
			}
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp43_ = rules_patterns;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp43__length1 = rules_patterns_length1;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp44_ = _vala_g_strjoinv (";", _tmp43_, _tmp43__length1);
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			patterns = _tmp44_;
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp45_ = rules_always_conf;
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp45__length1 = rules_always_conf_length1;
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp46_ = _vala_g_strjoinv (";", _tmp45_, _tmp45__length1);
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			always_conf = _tmp46_;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp47_ = services_array;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp47__length1 = services_array_length1;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp48_ = _vala_g_strjoinv (";", _tmp47_, _tmp47__length1);
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			services = _tmp48_;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp49_ = gnome_keyring_attribute_list_new ();
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			attributes = _tmp49_;
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp50_ = attributes;
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp50_, KEYRING_STORE_keyring_store_attribute, KEYRING_STORE_keyring_store_version);
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp51_ = attributes;
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp52_ = id_card;
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp53_ = id_card_get_issuer (_tmp52_);
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp54_ = _tmp53_;
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp51_, "Issuer", _tmp54_);
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp55_ = attributes;
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp56_ = id_card;
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp57_ = id_card_get_username (_tmp56_);
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp58_ = _tmp57_;
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp55_, "Username", _tmp58_);
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp59_ = attributes;
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp60_ = id_card;
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp61_ = id_card_get_display_name (_tmp60_);
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp62_ = _tmp61_;
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp59_, "DisplayName", _tmp62_);
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp63_ = attributes;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp64_ = services;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp63_, "Services", _tmp64_);
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp65_ = attributes;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp66_ = patterns;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp65_, "Rules-Pattern", _tmp66_);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp67_ = attributes;
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp68_ = always_conf;
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp67_, "Rules-AlwaysConfirm", _tmp68_);
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp69_ = attributes;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp70_ = id_card;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp71_ = id_card_get_trust_anchor (_tmp70_);
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp72_ = _tmp71_;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp73_ = trust_anchor_get_ca_cert (_tmp72_);
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp74_ = _tmp73_;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp69_, "CA-Cert", _tmp74_);
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp75_ = attributes;
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp76_ = id_card;
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp77_ = id_card_get_trust_anchor (_tmp76_);
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp78_ = _tmp77_;
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp79_ = trust_anchor_get_server_cert (_tmp78_);
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp80_ = _tmp79_;
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp75_, "Server-Cert", _tmp80_);
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp81_ = attributes;
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp82_ = id_card;
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp83_ = id_card_get_trust_anchor (_tmp82_);
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp84_ = _tmp83_;
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp85_ = trust_anchor_get_subject (_tmp84_);
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp86_ = _tmp85_;
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp81_, "Subject", _tmp86_);
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp87_ = attributes;
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp88_ = id_card;
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp89_ = id_card_get_trust_anchor (_tmp88_);
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp90_ = _tmp89_;
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp91_ = trust_anchor_get_subject_alt (_tmp90_);
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp92_ = _tmp91_;
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp87_, "Subject-Alt", _tmp92_);
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp94_ = id_card;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp95_ = id_card_get_store_password (_tmp94_);
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp96_ = _tmp95_;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			if (_tmp96_) {
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp93_ = "yes";
#line 2261 "moonshot-keyring-store.c"
			} else {
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp93_ = "no";
#line 2265 "moonshot-keyring-store.c"
			}
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp97_ = attributes;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp97_, "StorePassword", _tmp93_);
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp99_ = id_card;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp100_ = id_card_get_store_password (_tmp99_);
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp101_ = _tmp100_;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			if (_tmp101_) {
#line 2279 "moonshot-keyring-store.c"
				IdCard* _tmp102_ = NULL;
				const gchar* _tmp103_ = NULL;
				const gchar* _tmp104_ = NULL;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp102_ = id_card;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp103_ = id_card_get_password (_tmp102_);
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp104_ = _tmp103_;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp98_ = _tmp104_;
#line 2291 "moonshot-keyring-store.c"
			} else {
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp98_ = "";
#line 2295 "moonshot-keyring-store.c"
			}
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp105_ = id_card;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp106_ = id_card_get_display_name (_tmp105_);
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp107_ = _tmp106_;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp108_ = attributes;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp110_ = gnome_keyring_item_create_sync (NULL, KEYRING_STORE_item_type, _tmp107_, _tmp108_, _tmp98_, TRUE, &_tmp109_);
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			item_id = _tmp109_;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_result_ = _tmp110_;
#line 188 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp111_ = _result_;
#line 188 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			if (_tmp111_ != GNOME_KEYRING_RESULT_OK) {
#line 2315 "moonshot-keyring-store.c"
				FILE* _tmp112_ = NULL;
				GnomeKeyringResult _tmp113_ = 0;
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp112_ = stdout;
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp113_ = _result_;
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				fprintf (_tmp112_, "GnomeKeyring.item_create_sync() failed. result: %d", (gint) _tmp113_);
#line 2324 "moonshot-keyring-store.c"
			}
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_gnome_keyring_attribute_list_free0 (attributes);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_g_free0 (services);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_g_free0 (always_conf);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_g_free0 (patterns);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			rules_always_conf = (_vala_array_free (rules_always_conf, rules_always_conf_length1, (GDestroyNotify) g_free), NULL);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			rules_patterns = (_vala_array_free (rules_patterns, rules_patterns_length1, (GDestroyNotify) g_free), NULL);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			services_array = (_vala_array_free (services_array, services_array_length1, (GDestroyNotify) g_free), NULL);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			rules = (_vala_Rule_array_free (rules, rules_length1), NULL);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_g_object_unref0 (id_card);
#line 2344 "moonshot-keyring-store.c"
		}
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_g_object_unref0 (_id_card_list);
#line 2348 "moonshot-keyring-store.c"
	}
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	keyring_store_load_id_cards (self);
#line 2352 "moonshot-keyring-store.c"
}


KeyringStore* keyring_store_construct (GType object_type) {
	KeyringStore * self = NULL;
	GeeLinkedList* _tmp0_ = NULL;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	self = (KeyringStore*) g_object_new (object_type, NULL);
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp0_ = gee_linked_list_new (TYPE_ID_CARD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_g_object_unref0 (self->priv->id_card_list);
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	self->priv->id_card_list = _tmp0_;
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	keyring_store_load_id_cards (self);
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	return self;
#line 2371 "moonshot-keyring-store.c"
}


KeyringStore* keyring_store_new (void) {
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	return keyring_store_construct (TYPE_KEYRING_STORE);
#line 2378 "moonshot-keyring-store.c"
}


static void keyring_store_class_init (KeyringStoreClass * klass) {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	keyring_store_parent_class = g_type_class_peek_parent (klass);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	g_type_class_add_private (klass, sizeof (KeyringStorePrivate));
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	G_OBJECT_CLASS (klass)->finalize = keyring_store_finalize;
#line 2389 "moonshot-keyring-store.c"
}


static void keyring_store_iidentity_card_store_interface_init (IIdentityCardStoreIface * iface) {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	keyring_store_iidentity_card_store_parent_iface = g_type_interface_peek_parent (iface);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	iface->add_card = (void (*)(IIdentityCardStore*, IdCard*)) keyring_store_real_add_card;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	iface->update_card = (IdCard* (*)(IIdentityCardStore*, IdCard*)) keyring_store_real_update_card;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	iface->remove_card = (gboolean (*)(IIdentityCardStore*, IdCard*)) keyring_store_real_remove_card;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	iface->get_store_type = (IIdentityCardStoreStoreType (*)(IIdentityCardStore*)) keyring_store_real_get_store_type;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	iface->get_card_list = (GeeLinkedList* (*)(IIdentityCardStore*)) keyring_store_real_get_card_list;
#line 2406 "moonshot-keyring-store.c"
}


static void keyring_store_instance_init (KeyringStore * self) {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	self->priv = KEYRING_STORE_GET_PRIVATE (self);
#line 2413 "moonshot-keyring-store.c"
}


static void keyring_store_finalize (GObject* obj) {
	KeyringStore * self;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_KEYRING_STORE, KeyringStore);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_g_object_unref0 (self->priv->id_card_list);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	G_OBJECT_CLASS (keyring_store_parent_class)->finalize (obj);
#line 2425 "moonshot-keyring-store.c"
}


GType keyring_store_get_type (void) {
	static volatile gsize keyring_store_type_id__volatile = 0;
	if (g_once_init_enter (&keyring_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KeyringStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) keyring_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeyringStore), 0, (GInstanceInitFunc) keyring_store_instance_init, NULL };
		static const GInterfaceInfo iidentity_card_store_info = { (GInterfaceInitFunc) keyring_store_iidentity_card_store_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType keyring_store_type_id;
		keyring_store_type_id = g_type_register_static (G_TYPE_OBJECT, "KeyringStore", &g_define_type_info, 0);
		g_type_add_interface_static (keyring_store_type_id, TYPE_IIDENTITY_CARD_STORE, &iidentity_card_store_info);
		g_once_init_leave (&keyring_store_type_id__volatile, keyring_store_type_id);
	}
	return keyring_store_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



