/* $Id: Trna_ext.hpp 499339 2016-04-25 18:08:43Z bollin $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Trna_ext.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: Trna_ext_.hpp


#ifndef OBJECTS_SEQFEAT_TRNA_EXT_HPP
#define OBJECTS_SEQFEAT_TRNA_EXT_HPP


// generated includes
#include <objects/seqfeat/Trna_ext_.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQFEAT_EXPORT CTrna_ext : public CTrna_ext_Base
{
    typedef CTrna_ext_Base Tparent;
public:
    // constructor
    CTrna_ext(void);
    // destructor
    ~CTrna_ext(void);

    static bool ParseDegenerateCodon(CTrna_ext & tRNA, const string & codon);

private:
    // Prohibit copy constructor and assignment operator
    CTrna_ext(const CTrna_ext& value);
    CTrna_ext& operator=(const CTrna_ext& value);

};

/////////////////// CTrna_ext inline methods

// constructor
inline
CTrna_ext::CTrna_ext(void)
{
}


/////////////////// end of CTrna_ext inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_TRNA_EXT_HPP
/* Original file checksum: lines: 86, chars: 2397, CRC32: 32a4a2dd */
