/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2010 Sun Microsystems, Inc.
 */

package org.netbeans.modules.apisupport.project.ui.branding;

import org.netbeans.modules.apisupport.project.spi.BrandingModel;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/**
 *
 * @author S. Aubrecht
 */
public class BrandingEditorPanel extends javax.swing.JPanel {

    private final String title;
    private final BrandingModel model;
    private final AbstractBrandingPanel[] panels;
    private boolean isModified = false;
    private boolean isValid = true;
    private DialogDescriptor descriptor;
    private boolean brandingEnabled = true;

    public BrandingEditorPanel(String title, BrandingModel model) {
        initComponents();
        this.title = title;
        this.model = model;
        panels = new AbstractBrandingPanel[] {
            new BasicBrandingPanel(model),
            new SplashBrandingPanel(model),
            new WindowSystemBrandingPanel(model),
            new ResourceBundleBrandingPanel(model),
            new InternationalizationResourceBundleBrandingPanel(model)
        };
        for( AbstractBrandingPanel panel : panels ) {
            panel.init(this);
            tabbedPane.add(panel.getDisplayName(), panel);
        }
        lblError.setIcon(ImageUtilities.loadImageIcon("org/netbeans/modules/apisupport/project/ui/resources/error.gif", true)); //NOI18N
        lblError.setVisible(false);
        //TODO restrict the functionality of generic resource bundle editor when platform context isn't available
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        tabbedPane = new javax.swing.JTabbedPane();
        lblError = new javax.swing.JLabel();

        setBorder(javax.swing.BorderFactory.createEmptyBorder(10, 10, 10, 10));
        setLayout(new java.awt.BorderLayout(0, 5));
        add(tabbedPane, java.awt.BorderLayout.CENTER);
        tabbedPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BrandingEditorPanel.class, "ACS_BrandingTabs")); // NOI18N
        tabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrandingEditorPanel.class, "ACS_BrandingTabs")); // NOI18N

        add(lblError, java.awt.BorderLayout.SOUTH);
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel lblError;
    private javax.swing.JTabbedPane tabbedPane;
    // End of variables declaration//GEN-END:variables

    public Dialog open() {
        descriptor = new DialogDescriptor(this, title, false, DialogDescriptor.OK_CANCEL_OPTION, null, new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                if( descriptor.getValue() == DialogDescriptor.OK_OPTION ) {
                    doSave();
                }
            }
        });
        Dialog dlg = DialogDisplayer.getDefault().createDialog(descriptor);
        dlg.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BrandingEditorPanel.class, "ACS_BrandingCustomizer")); //NOI18N
        dlg.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrandingEditorPanel.class, "ACS_BrandingCustomizer")); //NOI18N
        dlg.setVisible(true);
        //it's possible to open project properties window while branding editor is opened
        //and switch from application suite to module suite which doesn't support branding
        //so let's prevent saving when in 'module suite' mode
        dlg.addWindowListener(new WindowAdapter() {
            @Override
            public void windowActivated(WindowEvent e) {
                refreshBrandingEnabled();
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
                refreshBrandingEnabled();
            }
        });
        return dlg;
    }

    void setModified() {
        isModified = true;
    }

    boolean isModified() {
        return isModified;
    }

    private void doSave() {
        for( AbstractBrandingPanel panel : panels ) {
            panel.store();
        }
        model.doSave();
        isModified = false;
    }


    void onBrandingValidation() {
        isValid = true;
        String errMessage = null;
        for( AbstractBrandingPanel panel : panels ) {
            isValid &= panel.isBrandingValid();
            String msg = panel.getErrorMessage();
            if( null != msg && null == errMessage )
                errMessage = msg;
        }
        lblError.setText(errMessage);
        lblError.setVisible(!isValid);
        if( null != descriptor )
            descriptor.setValid(isValid && brandingEnabled);
    }

    private void refreshBrandingEnabled() {
        model.reloadProperties();
        model.brandingEnabledRefresh();
        brandingEnabled = model.isBrandingEnabled();
        if( null != descriptor ) {
            descriptor.setValid( isValid && brandingEnabled );
        }
    }
}
