<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/python.d.plugin/tor/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/python.d.plugin/tor/metadata.yaml"
sidebar_label: "Tor"
learn_status: "Published"
learn_rel_path: "Data Collection/VPNs"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Tor


<img src="https://netdata.cloud/img/tor.svg" width="150"/>


Plugin: python.d.plugin
Module: tor

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors Tor bandwidth traffic .

It connects to the Tor control port to collect traffic statistics.

This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

If no configuration is provided the collector will try to connect to 127.0.0.1:9051 to detect a running tor instance.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Tor instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| tor.traffic | read, write | KiB/s |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Required python module

The `stem` python library needs to be installed.


#### Required Tor configuration

Add to /etc/tor/torrc:

ControlPort 9051

For more options please read the manual.



### Configuration

#### File

The configuration file name for this integration is `python.d/tor.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/configure/nodes.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config python.d/tor.conf
```
#### Options

There are 2 sections:

* Global variables
* One or more JOBS that can define multiple different instances to monitor.

The following options can be defined globally: priority, penalty, autodetection_retry, update_every, but can also be defined per JOB to override the global values.

Additionally, the following collapsed table contains all the options that can be configured inside a JOB definition.

Every configuration JOB starts with a `job_name` value which will appear in the dashboard, unless a `name` parameter is specified.


<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Sets the default data collection frequency. | 5 | False |
| priority | Controls the order of charts at the netdata dashboard. | 60000 | False |
| autodetection_retry | Sets the job re-check interval in seconds. | 0 | False |
| penalty | Indicates whether to apply penalty to update_every in case of failures. | yes | False |
| name | Job name. This value will overwrite the `job_name` value. JOBS with the same name are mutually exclusive. Only one of them will be allowed running at any time. This allows autodetection to try several alternatives and pick the one that works. |  | False |
| control_addr | Tor control IP address | 127.0.0.1 | False |
| control_port | Tor control port. Can be either a tcp port, or a path to a socket file. | 9051 | False |
| password | Tor control password |  | False |

</details>

#### Examples

##### Local TCP

A basic TCP configuration. `local_addr` is ommited and will default to `127.0.0.1`

<details><summary>Config</summary>

```yaml
local_tcp:
 name: 'local'
 control_port: 9051
 password: <password> # if required

```
</details>

##### Local socket

A basic local socket configuration

<details><summary>Config</summary>

```yaml
local_socket:
 name: 'local'
 control_port: '/var/run/tor/control'
 password: <password> # if required

```
</details>



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `tor` collector, run the `python.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `python.d.plugin` to debug the collector:

  ```bash
  ./python.d.plugin tor debug trace
  ```


