---
id: fast-element.view
title: View interface
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-element](./fast-element.md) &gt; [View](./fast-element.view.md)

## View interface

Represents a collection of DOM nodes which can be bound to a data source.

<b>Signature:</b>

```typescript
export interface View 
```

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [context](./fast-element.view.context.md) | [ExecutionContext](./fast-element.executioncontext.md) \| null | The execution context the view is running within. |
|  [source](./fast-element.view.source.md) | any \| null | The data that the view is bound to. |

## Methods

|  Method | Description |
|  --- | --- |
|  [bind(source, context)](./fast-element.view.bind.md) | Binds a view's behaviors to its binding source. |
|  [dispose()](./fast-element.view.dispose.md) | Removes the view and unbinds its behaviors, disposing of DOM nodes afterward. Once a view has been disposed, it cannot be inserted or bound again. |
|  [unbind()](./fast-element.view.unbind.md) | Unbinds a view's behaviors from its binding source and context. |
