---
id: fast-foundation.registration
title: Registration variable
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-foundation](./fast-foundation.md) &gt; [Registration](./fast-foundation.registration.md)

## Registration variable

You can use the resulting Registration of any of the factory methods to register with the container.

<b>Signature:</b>

```typescript
Registration: Readonly<{
    instance<T>(key: Key, value: T): Registration<T>;
    singleton<T_1 extends Constructable<{}>>(key: Key, value: T_1): Registration<InstanceType<T_1>>;
    transient<T_2 extends Constructable<{}>>(key: Key, value: T_2): Registration<InstanceType<T_2>>;
    callback<T_3>(key: Key, callback: ResolveCallback<T_3>): Registration<Resolved<T_3>>;
    cachedCallback<T_4>(key: Key, callback: ResolveCallback<T_4>): Registration<Resolved<T_4>>;
    aliasTo<T_5>(originalKey: T_5, aliasKey: Key): Registration<Resolved<T_5>>;
}>
```

## Example


```
class Foo {}
const container = DI.createContainer();
container.register(Registration.instance(Foo, new Foo()));
container.get(Foo);

```
