/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.Hashtable;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.jetspeed.services.statemanager.SessionStateBindingListener;
import org.apache.jetspeed.services.statemanager.StateManagerService;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.core.Event;
import org.chefproject.core.UsageSession;
import org.chefproject.core.User;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.service.EventTrackingService;
import org.chefproject.service.IdService;
import org.chefproject.service.UserDirectoryService;
import org.chefproject.service.generic.GenericUsageSessionService;
import org.chefproject.util.Cache;
import org.chefproject.util.Time;

public abstract class BaseUsageSessionService
extends TurbineBaseService
implements GenericUsageSessionService {
    protected Storage m_storage = null;
    protected StateManagerService m_stateManager = null;
    protected static final String SESSION_USER_KEY = "session.user";
    protected Hashtable m_threadUsers = new Hashtable();
    protected Cache m_cache = null;

    protected abstract Storage newStorage();

    public void init(ServletConfig config) throws InitializationException {
        super.init(config);
        Log.info("chef", this + ".init(ServletConfig)");
    }

    public void init(RunData data) throws InitializationException {
        super.init(data);
        Log.info("chef", this + ".init(RunData)");
    }

    public void init() throws InitializationException {
        super.init();
        this.m_stateManager = (StateManagerService)TurbineServices.getInstance().getService("StateManagerService");
        if (this.m_stateManager == null) {
            throw new InitializationException("TurbineUserDirectory is missing service: StateManagerService");
        }
        this.m_storage = this.newStorage();
        this.m_storage.open();
        this.m_cache = new Cache();
        Log.info("chef", this + ".init()");
    }

    public void shutdown() {
        this.m_cache.clear();
        this.m_cache = null;
        this.m_storage.close();
        this.m_storage = null;
        this.m_stateManager = null;
        Log.info("chef", this + ".shutdown()");
        super.shutdown();
    }

    public boolean loginSessionUser(String id, String pw, String remoteAddress, String userAgent) {
        SessionState state = this.m_stateManager.getCurrentSessionState(GenericUsageSessionService.SERVICE_NAME);
        if (state == null) {
            Log.warn("chef", this + ".loginSessionUser(): no session state");
            return false;
        }
        boolean authenticated = false;
        authenticated = UserDirectoryService.authenticate(id, pw);
        if (!authenticated) {
            return false;
        }
        BaseUsageSession session = null;
        try {
            User user = UserDirectoryService.getUser(id);
            session = new BaseUsageSession(user, remoteAddress, userAgent);
            state.setAttribute(SESSION_USER_KEY, (Object)session);
            this.m_storage.addSession(session);
        }
        catch (IdUnusedException e) {
            return false;
        }
        Event event = EventTrackingService.newEvent("user.login", ((Object)session).toString(), true);
        EventTrackingService.post(event);
        return true;
    }

    public void logoutSessionUser() {
        SessionState state = this.m_stateManager.getCurrentSessionState(GenericUsageSessionService.SERVICE_NAME);
        if (state == null) {
            Log.warn("chef", this + ".logoutSessionUser(): no session state");
            return;
        }
        BaseUsageSession session = (BaseUsageSession)state.getAttribute(SESSION_USER_KEY);
        if (session == null) {
            return;
        }
        state.removeAttribute(SESSION_USER_KEY);
        session.close();
    }

    public void loginThreadUser(String id) {
        if (this.m_stateManager.getCurrentSessionState(GenericUsageSessionService.SERVICE_NAME) != null) {
            return;
        }
        try {
            User user = UserDirectoryService.getUser(id);
            this.m_threadUsers.put(Thread.currentThread(), user);
        }
        catch (IdUnusedException e) {
            Log.warn("chef", this + ".loginThreadUser(): " + e);
        }
    }

    public void logoutThreadUser() {
        this.m_threadUsers.remove(Thread.currentThread());
    }

    public User getSessionUser() {
        SessionState state = this.m_stateManager.getCurrentSessionState(GenericUsageSessionService.SERVICE_NAME);
        if (state != null) {
            User user;
            UsageSession us = (UsageSession)state.getAttribute(SESSION_USER_KEY);
            if (us != null && (user = us.getUser()) != null) {
                return user;
            }
        } else {
            User user = (User)this.m_threadUsers.get(Thread.currentThread());
            if (user != null) {
                return user;
            }
        }
        return UserDirectoryService.getAnonymousUser();
    }

    public UsageSession getSession() {
        SessionState state = this.m_stateManager.getCurrentSessionState(GenericUsageSessionService.SERVICE_NAME);
        if (state != null) {
            UsageSession us = (UsageSession)state.getAttribute(SESSION_USER_KEY);
            return us;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UsageSession getSession(String id) {
        UsageSession rv = this.m_storage.getLocalSession(id);
        if (rv == null && (rv = (UsageSession)this.m_cache.get(id)) == null) {
            Cache cache = this.m_cache;
            synchronized (cache) {
                rv = (UsageSession)this.m_cache.get(id);
                if (rv == null) {
                    rv = this.m_storage.getSession(id);
                    this.m_cache.put(id, rv);
                }
            }
        }
        return rv;
    }

    public boolean isLocalSession(String id) {
        return this.m_storage.getLocalSession(id) != null;
    }

    static {
        SESSION_USER_KEY = SESSION_USER_KEY;
    }

    protected class BaseUsageSession
    implements UsageSession,
    SessionStateBindingListener {
        protected User m_user = null;
        protected String m_id = null;
        protected String m_ip = null;
        protected String m_userAgent = null;
        protected String m_browserId = null;
        protected Time m_start = null;
        protected Time m_end = null;

        public BaseUsageSession(User user, String address, String agent) {
            this.m_id = IdService.getUniqueId();
            this.m_user = user;
            this.m_ip = address;
            this.m_userAgent = agent;
            this.m_end = this.m_start = new Time();
            this.setBrowserId(agent);
        }

        public BaseUsageSession(String id, User user, String address, String agent, Time start, Time end) {
            this.m_id = id;
            this.m_user = user;
            this.m_ip = address;
            this.m_userAgent = agent;
            this.m_start = start;
            this.m_end = end;
            this.setBrowserId(agent);
        }

        protected void setBrowserId(String agent) {
            this.m_browserId = agent.indexOf("Netscape") >= 0 && agent.indexOf("Mac") >= 0 ? "Mac-NetscapeNavigator" : (agent.indexOf("Netscape") >= 0 && agent.indexOf("Windows") >= 0 ? "Win-NetscapeNavigator" : (agent.indexOf("MSIE") >= 0 && agent.indexOf("Mac") >= 0 ? "Mac-InternetExplorer" : (agent.indexOf("MSIE") >= 0 && agent.indexOf("Windows") >= 0 ? "Win-InternetExplorer" : (agent.indexOf("Camino") >= 0 && agent.indexOf("Macintosh") >= 0 ? "Mac-Camino" : (agent.startsWith("Mozilla") && agent.indexOf("Windows") >= 0 ? "Win-Mozilla" : (agent.startsWith("Mozilla") && agent.indexOf("Macintosh") >= 0 ? "Mac-Mozilla" : "UnknownBrowser"))))));
        }

        protected void close() {
            if (!this.isClosed()) {
                this.m_end = new Time();
                BaseUsageSessionService.this.m_storage.closeSession(this);
            }
        }

        public boolean isClosed() {
            return !this.m_end.equals(this.m_start);
        }

        public User getUser() {
            return this.m_user;
        }

        public String getId() {
            return this.m_id;
        }

        public String getIpAddress() {
            return this.m_ip;
        }

        public String getUserAgent() {
            return this.m_userAgent;
        }

        public String getBrowserId() {
            return this.m_browserId;
        }

        public Time getStart() {
            return new Time(this.m_start.getTime());
        }

        public Time getEnd() {
            return new Time(this.m_end.getTime());
        }

        public void valueBound(String sessionStateKey, String attributeName) {
        }

        public void valueUnbound(String sessionStateKey, String attributeName) {
            Event event = EventTrackingService.newEvent("user.logout", null, true);
            EventTrackingService.post(event, this);
            this.close();
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof UsageSession)) {
                throw new ClassCastException();
            }
            if (obj == this) {
                return 0;
            }
            int compare = this.getUser().compareTo(((UsageSession)obj).getUser());
            if (compare == 0) {
                compare = this.getId().compareTo(((UsageSession)obj).getId());
            }
            return compare;
        }

        public String toString() {
            return "[" + (this.m_user == null ? "" : this.m_user.getId()) + " | " + (this.m_id == null ? "" : this.m_id) + " | " + (this.m_ip == null ? "" : this.m_ip) + " | " + (this.m_userAgent == null ? "" : this.m_userAgent) + " ]";
        }
    }

    protected static interface Storage {
        public void open();

        public void close();

        public void addSession(UsageSession var1);

        public UsageSession getSession(String var1);

        public UsageSession getLocalSession(String var1);

        public void closeSession(UsageSession var1);
    }
}

