@ECHO OFF

REM ##########################################################################
REM # File: dktool/dk.cmd                                                    #
REM #                                                                        #
REM # Copyright 2023 Diskuv, Inc.                                            #
REM #                                                                        #
REM # Licensed under the Apache License, Version 2.0 (the "License");        #
REM # you may not use this file except in compliance with the License.       #
REM # You may obtain a copy of the License at                                #
REM #                                                                        #
REM #     http://www.apache.org/licenses/LICENSE-2.0                         #
REM #                                                                        #
REM # Unless required by applicable law or agreed to in writing, software    #
REM # distributed under the License is distributed on an "AS IS" BASIS,      #
REM # WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or        #
REM # implied. See the License for the specific language governing           #
REM # permissions and limitations under the License.                         #
REM #                                                                        #
REM ##########################################################################

REM Recommendation: Place this file in source control.
REM Auto-generated by `./dk dksdk.project.new` of dktool.

REM The canonical way to run this script is: ./dk
REM That works in Powershell on Windows, and in Unix. Copy-and-paste works!

SETLOCAL

REM Coding guidelines
REM 1. Microsoft way of getting around PowerShell permissions:
REM    https://github.com/microsoft/vcpkg/blob/71422c627264daedcbcd46f01f1ed0dcd8460f1b/bootstrap-vcpkg.bat
REM 2. Write goto downward please so code flow is top to bottom.

SET DK_CMAKE_VER=3.25.3
SET DK_NINJA_VER=1.11.1
SET DK_BUILD_TYPE=Release
SET DK_SHARE=%LOCALAPPDATA%\Programs\DkSDK\dktool
SET DK_PROJ_DIR=%~dp0
SET DK_PWD=%CD%

REM -------------- CMAKE --------------

REM Find CMAKE.EXE
where.exe /q cmake.exe >NUL 2>NUL
IF %ERRORLEVEL% neq 0 (
    goto FindDownloadedCMake
)
FOR /F "tokens=* usebackq" %%F IN (`where.exe cmake.exe`) DO (
    SET "DK_CMAKE_EXE=%%F"
)

REM Check if present at <data>/cmake-VER/bin/cmake.exe
:FindDownloadedCMake
IF EXIST %DK_SHARE%\cmake-%DK_CMAKE_VER%-windows-x86_64\bin\cmake.exe (
    SET "DK_CMAKE_EXE=%DK_SHARE%\cmake-%DK_CMAKE_VER%-windows-x86_64\bin\cmake.exe"
    GOTO ValidateCMake
)

REM Download CMAKE.EXE
bitsadmin /transfer dktool-cmake /download /priority FOREGROUND ^
    "https://github.com/Kitware/CMake/releases/download/v%DK_CMAKE_VER%/cmake-%DK_CMAKE_VER%-windows-x86_64.zip" ^
    "%TEMP%\cmake-%DK_CMAKE_VER%-windows-x86_64.zip"
IF %ERRORLEVEL% equ 0 (
    GOTO UnzipCMakeZip
)
REM Try PowerShell 3+ instead
powershell -NoProfile -ExecutionPolicy Bypass -Command ^
    "Invoke-WebRequest https://github.com/Kitware/CMake/releases/download/v%DK_CMAKE_VER%/cmake-%DK_CMAKE_VER%-windows-x86_64.zip -OutFile '%TEMP%\cmake-%DK_CMAKE_VER%-windows-x86_64.zip'"
IF %ERRORLEVEL% neq 0 (
    echo.
    echo.Could not download CMake %DK_CMAKE_VER%. Make sure that PowerShell is installed
    echo.and has not been disabled by a corporate policy.
    echo.
    EXIT /b 1
)

REM Unzip CMAKE.EXE (use PowerShell; could download unzip.exe and sha256sum.exe as well in case corporate policy)
:UnzipCMakeZip
powershell -NoProfile -ExecutionPolicy Bypass -Command ^
    "Expand-Archive '%TEMP%\cmake-%DK_CMAKE_VER%-windows-x86_64.zip' -DestinationPath '%DK_SHARE%'"
IF %ERRORLEVEL% neq 0 (
    echo.
    echo.Could not unzip CMake %DK_CMAKE_VER%. Make sure that PowerShell is installed
    echo.and has not been disabled by a corporate policy.
    echo.
    EXIT /b 1
)
SET "DK_CMAKE_EXE=%DK_SHARE%\cmake-%DK_CMAKE_VER%-windows-x86_64\bin\cmake.exe"

REM Validate cmake.exe
:ValidateCMake
"%DK_CMAKE_EXE%" -version >NUL 2>NUL
if %ERRORLEVEL% neq 0 (
	echo.
	echo.%DK_CMAKE_EXE%
	echo.is not responding to the -version option. Make sure that
	echo.CMake is installed correctly.
	echo.
	exit /b 1
)

REM -------------- NINJA --------------

REM Find NINJA.EXE
where.exe /q ninja.exe >NUL 2>NUL
IF %ERRORLEVEL% neq 0 (
    goto FindDownloadedNinja
)
FOR /F "tokens=* usebackq" %%F IN (`where.exe ninja.exe`) DO (
    SET "DK_NINJA_EXE=%%F"
)

REM Check if present at <data>/ninja-VER/bin/ninja.exe
:FindDownloadedNinja
IF EXIST %DK_SHARE%\ninja-%DK_NINJA_VER%-windows-x86_64\bin\ninja.exe (
    SET "DK_NINJA_EXE=%DK_SHARE%\ninja-%DK_NINJA_VER%-windows-x86_64\bin\ninja.exe"
    GOTO ValidateNinja
)

REM Download NINJA.EXE
bitsadmin /transfer dktool-ninja /download /priority FOREGROUND ^
    "https://github.com/ninja-build/ninja/releases/download/v%DK_NINJA_VER%/ninja-win.zip" ^
    "%TEMP%\ninja-%DK_NINJA_VER%-windows-x86_64.zip"
IF %ERRORLEVEL% equ 0 (
    GOTO UnzipNinjaZip
)
REM Try PowerShell 3+ instead
powershell -NoProfile -ExecutionPolicy Bypass -Command ^
    "Invoke-WebRequest https://github.com/ninja-build/ninja/releases/download/v%DK_NINJA_VER%/ninja-win.zip -OutFile '%TEMP%\ninja-%DK_NINJA_VER%-windows-x86_64.zip'"
IF %ERRORLEVEL% neq 0 (
    echo.
    echo.Could not download Ninja %DK_NINJA_VER%. Make sure that PowerShell is installed
    echo.and has not been disabled by a corporate policy.
    echo.
    EXIT /b 1
)

REM Unzip NINJA.EXE (use PowerShell; could download unzip.exe and sha256sum.exe as well in case corporate policy)
:UnzipNinjaZip
powershell -NoProfile -ExecutionPolicy Bypass -Command ^
    "Expand-Archive '%TEMP%\ninja-%DK_NINJA_VER%-windows-x86_64.zip' -DestinationPath '%DK_SHARE%\ninja-%DK_NINJA_VER%-windows-x86_64\bin'"
IF %ERRORLEVEL% neq 0 (
    echo.
    echo.Could not unzip Ninja %DK_NINJA_VER%. Make sure that PowerShell is installed
    echo.and has not been disabled by a corporate policy.
    echo.
    EXIT /b 1
)
SET "DK_NINJA_EXE=%DK_SHARE%\ninja-%DK_NINJA_VER%-windows-x86_64\bin\ninja.exe"

REM Validate ninja.exe
:ValidateNinja
"%DK_NINJA_EXE%" --version >NUL 2>NUL
if %ERRORLEVEL% neq 0 (
	echo.
	echo.%DK_NINJA_EXE%
	echo.is not responding to the --version option. Make sure that
	echo.Ninja is installed correctly.
	echo.
	exit /b 1
)

REM -------------- DkML PATH ---------
REM We get "git-sh-setup: file not found" in Git for Windows because
REM Command Prompt has the "Path" environment variable, while PowerShell
REM and `with-dkml` use the PATH environment variable. Sadly both
REM can be present in Command Prompt at the same time. Git for Windows
REM (called by FetchContent in CMake) does not comport with what Command
REM Prompt is using. So we let Command Prompt be the source of truth by
REM removing any duplicated PATH twice and resetting to what Command Prompt
REM thinks the PATH is.

SET _DK_PATH=%PATH%
SET PATH=
SET PATH=
SET PATH=%_DK_PATH%
SET _DK_PATH=

REM -------------- Run finder --------------

cd /d %DK_PROJ_DIR%
"%DK_CMAKE_EXE%" -D CMAKE_GENERATOR=Ninja -D "CMAKE_MAKE_PROGRAM=%DK_NINJA_EXE%" -D "DKTOOL_PWD:FILEPATH=%DK_PWD%" -D "DKTOOL_WORKDIR:FILEPATH=%DK_SHARE%\work" -D "DKTOOL_CMDLINE:STRING=%*" -P cmake/FindDkToolScripts.cmake
