/*-----------------------------------------------------------------------------

	ST-Sound ( YM files player library )

	Manage YM file depacking and parsing

-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
* ST-Sound, ATARI-ST Music Emulator
* Copyright (c) 1995-1999 Arnaud Carre ( http://leonard.oxg.free.fr )
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1. Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
* 2. Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the distribution.
*
* THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
* FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
* LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
* SUCH DAMAGE.
*
-----------------------------------------------------------------------------*/

#ifndef __YMLOAD__
#define	__YMLOAD__

#ifdef __cplusplus
extern "C" {
#endif

#ifdef _WIN32
#define PACKED
#pragma pack(push)
#pragma pack(1)
#else
//warning: be sure to the following struct is 1 byte aligned and exactly 22 bytes long. ( FILE header )
#define PACKED __attribute__ ((packed)) // (added by Grzegorz T. Stanczyk)
#endif	// ifdef _WIN32

typedef struct
{
	ymu8	size;
	ymu8	sum;
	char	id[5];
	ymu32	packed;
	ymu32	original;
	ymu8	reserved[5];
	ymu8	level;
	ymu8	name_lenght;
} PACKED lzhHeader_t;


#ifdef _WIN32
#pragma pack(pop)
#endif	// ifdef _WIN32

#ifdef __cplusplus
}
#endif

#endif
