/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.SequencedCollection;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.IvyNodeEviction$EvictionData;
import org.apache.ivy.core.resolve.IvyNodeUsage;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.VisitData;
import org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import org.apache.ivy.plugins.conflict.ConflictManager;
import xsbt.boot.Update;

public final class VisitNode {
    private IvyNode node;
    private VisitNode parent = null;
    private VisitNode root = null;
    private Collection path = null;
    private String parentConf = null;
    private String requestedConf;
    private String rootModuleConf;
    private ResolveData data;
    private Boolean isCircular;
    private IvyNodeUsage usage;

    public VisitNode(ResolveData resolveData, IvyNode ivyNode, String string) {
        this(resolveData, ivyNode, null, string, null, null);
    }

    private VisitNode(ResolveData resolveData, IvyNode ivyNode, VisitNode visitNode, String string, String string2, IvyNodeUsage ivyNodeUsage) {
        Update.checkNotNull(resolveData, "data");
        Update.checkNotNull(ivyNode, "node");
        Update.checkNotNull(string, "rootModuleConf");
        this.data = resolveData;
        this.node = ivyNode;
        this.parent = visitNode;
        this.rootModuleConf = string;
        this.parentConf = string2;
        this.usage = ivyNodeUsage;
        VisitNode visitNode2 = this;
        this.data.register(visitNode2.node.getId(), visitNode2);
    }

    public final IvyNode getNode() {
        return this.node;
    }

    public final String getRequestedConf() {
        return this.requestedConf;
    }

    public final void setRequestedConf(String string) {
        this.requestedConf = string;
    }

    public final VisitNode getParent() {
        return this.parent;
    }

    public final VisitNode getRoot() {
        if (this.root == null) {
            VisitNode visitNode = this;
            this.root = visitNode.node.isRoot() ? visitNode : (visitNode.parent != null ? visitNode.parent.getRoot() : null);
        }
        return this.root;
    }

    public final Collection getPath() {
        if (this.path == null) {
            SequencedCollection<VisitNode> sequencedCollection;
            VisitNode visitNode = this;
            if (visitNode.parent != null) {
                LinkedHashSet<VisitNode> linkedHashSet = new LinkedHashSet<VisitNode>(visitNode.parent.getPath());
                linkedHashSet.add(visitNode);
                sequencedCollection = linkedHashSet;
            } else {
                sequencedCollection = Collections.singletonList(visitNode);
            }
            this.path = sequencedCollection;
        }
        return this.path;
    }

    public final String getParentConf() {
        return this.parentConf;
    }

    public final String getRootModuleConf() {
        return this.rootModuleConf;
    }

    public final boolean isTransitive() {
        if (this.node.isRoot()) {
            return true;
        }
        if (!this.data.isTransitive()) {
            return false;
        }
        VisitNode visitNode = this;
        String string = visitNode.parent.requestedConf;
        if (!(string == null ? true : visitNode.getParentNode().getConfiguration(string).isTransitive())) {
            return false;
        }
        DependencyDescriptor dependencyDescriptor = this.node.getDependencyDescriptor(this.getParentNode());
        if (dependencyDescriptor != null && dependencyDescriptor.isTransitive()) {
            return true;
        }
        return this.node.hasAnyMergedUsageWithTransitiveDependency(this.rootModuleConf);
    }

    public final void useRealNode() {
        IvyNode ivyNode;
        if (this.parent != null && (ivyNode = this.data.getNode(this.node.getId())) != null && ivyNode != this.node) {
            this.node = ivyNode;
        }
    }

    public final boolean loadData(String string, boolean bl) {
        boolean bl2 = this.node.loadData(this.rootModuleConf, this.getParentNode(), this.parentConf, string, bl, this.getUsage());
        if (bl2) {
            this.useRealNode();
            if (this.data.getNode(this.node.getResolvedId()) == null || !this.data.getNode(this.node.getResolvedId()).getId().equals(this.node.getResolvedId())) {
                this.data.register(this.node.getResolvedId(), this);
            }
        }
        return bl2;
    }

    public final Collection getDependencies(String string) {
        Collection collection = this.node.getDependencies(this.rootModuleConf, string, this.requestedConf);
        ArrayList<VisitNode> arrayList = new ArrayList<VisitNode>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            VisitNode visitNode;
            IvyNode ivyNode;
            IvyNode ivyNode2 = ivyNode = (IvyNode)iterator.next();
            String string2 = string;
            VisitNode visitNode2 = visitNode = this;
            arrayList.add(visitNode.traverse(visitNode2, string2, ivyNode2, null));
        }
        return arrayList;
    }

    final VisitNode gotoNode(IvyNode ivyNode) {
        if (!this.node.getModuleId().equals(ivyNode.getModuleId())) {
            throw new IllegalArgumentException("You can't use gotoNode for a node which does not represent the same Module as the one represented by this node.\nCurrent node module id=" + this.node.getModuleId() + " Given node module id=" + ivyNode.getModuleId());
        }
        VisitData visitData = this.data.getVisitData(ivyNode.getId());
        if (visitData != null) {
            Iterator iterator = visitData.getVisitNodes(this.rootModuleConf).iterator();
            while (iterator.hasNext()) {
                VisitNode visitNode = (VisitNode)iterator.next();
                if ((this.parent != null || visitNode.parent != null) && (this.parent == null || !this.parent.node.getId().equals(visitNode.parent.node.getId()))) continue;
                visitNode.parentConf = this.parentConf;
                visitNode.usage = this.getUsage();
                return visitNode;
            }
        }
        return this.traverse(this.parent, this.parentConf, ivyNode, this.getUsage());
    }

    private IvyNodeUsage getUsage() {
        if (this.usage == null) {
            return this.node.getMainUsage();
        }
        return this.usage;
    }

    private VisitNode traverse(VisitNode visitNode, String string, IvyNode ivyNode, IvyNodeUsage ivyNodeUsage) {
        if (this.getPath().contains(ivyNode)) {
            CircularDependencyStrategy circularDependencyStrategy = IvyContext.getContext().getCircularDependencyStrategy();
            ModuleRevisionId moduleRevisionId = ivyNode.getId();
            Collection collection = this.getPath();
            ModuleRevisionId[] moduleRevisionIdArray = new ModuleRevisionId[collection.size() + 1];
            int n = 0;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                VisitNode visitNode2 = (VisitNode)iterator.next();
                moduleRevisionIdArray[n] = visitNode2.node.getId();
                ++n;
            }
            moduleRevisionIdArray[moduleRevisionIdArray.length - 1] = moduleRevisionId;
            circularDependencyStrategy.handleCircularDependency(moduleRevisionIdArray);
        }
        return new VisitNode(this.data, ivyNode, visitNode, this.rootModuleConf, string, ivyNodeUsage);
    }

    public final ModuleRevisionId getResolvedId() {
        return this.node.getResolvedId();
    }

    public final void updateConfsToFetch(Collection collection) {
        this.node.updateConfsToFetch(collection);
    }

    public final ModuleRevisionId getId() {
        return this.node.getId();
    }

    public final boolean isEvicted() {
        return this.node.isEvicted(this.rootModuleConf);
    }

    public final String[] getRealConfs(String string) {
        return this.node.getRealConfs(string);
    }

    public final boolean hasProblem() {
        return this.node.hasProblem();
    }

    public final Configuration getConfiguration(String string) {
        return this.node.getConfiguration(string);
    }

    public final IvyNodeEviction$EvictionData getEvictedData() {
        return this.node.getEvictedData(this.rootModuleConf);
    }

    public final DependencyDescriptor getDependencyDescriptor() {
        return this.node.getDependencyDescriptor(this.getParentNode());
    }

    private IvyNode getParentNode() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.node;
    }

    public final boolean isCircular() {
        if (this.isCircular == null) {
            if (this.parent != null) {
                this.isCircular = Boolean.FALSE;
                Iterator iterator = this.parent.getPath().iterator();
                while (iterator.hasNext()) {
                    VisitNode visitNode = (VisitNode)iterator.next();
                    if (!this.node.getId().getModuleId().equals(visitNode.node.getId().getModuleId())) continue;
                    this.isCircular = Boolean.TRUE;
                    break;
                }
            } else {
                this.isCircular = Boolean.FALSE;
            }
        }
        return this.isCircular;
    }

    public final String[] getConfsToFetch() {
        return this.node.getConfsToFetch();
    }

    public final String[] getRequiredConfigurations(VisitNode visitNode, String string) {
        return this.node.getRequiredConfigurations(visitNode.node, string);
    }

    public final ModuleId getModuleId() {
        return this.node.getModuleId();
    }

    public final Collection getResolvedRevisions(ModuleId moduleId) {
        return this.node.getResolvedRevisions(moduleId, this.rootModuleConf);
    }

    public final void markEvicted(IvyNodeEviction$EvictionData ivyNodeEviction$EvictionData) {
        this.node.markEvicted(ivyNodeEviction$EvictionData);
    }

    public final void markEvicted(VisitNode visitNode, ConflictManager conflictManager, Collection collection) {
        this.node.markEvicted(this.rootModuleConf, visitNode.node, conflictManager, collection);
    }

    public final ModuleDescriptor getDescriptor() {
        return this.node.getDescriptor();
    }

    public final IvyNodeEviction$EvictionData getEvictionDataInRoot(String string, VisitNode visitNode) {
        return this.node.getEvictionDataInRoot(string, visitNode.node);
    }

    public final Collection getEvictedRevisions(ModuleId moduleId) {
        return this.node.getEvictedRevisions(moduleId, this.rootModuleConf);
    }

    public final String toString() {
        return this.node.toString();
    }

    public final boolean isConfRequiredByMergedUsageOnly(String string) {
        return this.node.isConfRequiredByMergedUsageOnly(this.rootModuleConf, string);
    }
}

