/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Original code Copyright (C) 2014-2018 Bernhard Gschaider
    Copyright (C) 2019 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::exprTools::stringEntry

Description
    Creates an expression from a string (removing surrounding quotes)

SourceFiles
    expressionEntryStrings.C

\*---------------------------------------------------------------------------*/

#ifndef exprTools_expressionEntryStrings_H
#define exprTools_expressionEntryStrings_H

#include "expressionEntry.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
namespace exprTools
{

/*---------------------------------------------------------------------------*\
                         Class stringEntry Declaration
\*---------------------------------------------------------------------------*/

struct stringEntry
:
    public exprTools::expressionEntry
{
    //- To string
    static string evaluate(const entry& e)
    {
        return e.get<string>();
    }

    //- To string
    virtual string toExpr(const entry& e) const
    {
        return evaluate(e);
    }
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace exprTools
} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
