/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "../Color.h"

class TestColor : public GTLTest::Case {
  public:
    TestColor() : GTLTest::Case("Color")
    {
    }
    virtual void runTest()
    {
      GTLCore::Color c;
      GTLTEST_CHECK_NEAR_EQUAL(c.red(), 0.0);
      GTLTEST_CHECK_NEAR_EQUAL(c.green(), 0.0);
      GTLTEST_CHECK_NEAR_EQUAL(c.blue(), 0.0);
      GTLTEST_CHECK_NEAR_EQUAL(c.alpha(), 0.0);
      GTLCore::Color c1(0.2,0.4,0.3);
      GTLTEST_CHECK_NEAR_EQUAL(c1.red(), 0.2);
      GTLTEST_CHECK_NEAR_EQUAL(c1.green(), 0.4);
      GTLTEST_CHECK_NEAR_EQUAL(c1.blue(), 0.3);
      GTLTEST_CHECK_NEAR_EQUAL(c1.alpha(), 1.0);
      GTLCore::Color c2(0.3,0.5,0.2,0.5);
      GTLTEST_CHECK_NEAR_EQUAL(c2.red(), 0.3);
      GTLTEST_CHECK_NEAR_EQUAL(c2.green(), 0.5);
      GTLTEST_CHECK_NEAR_EQUAL(c2.blue(), 0.2);
      GTLTEST_CHECK_NEAR_EQUAL(c2.alpha(), 0.5);
      GTLCore::Color c3 = c2;
      GTLTEST_CHECK_NEAR_EQUAL(c3.red(), 0.3);
      GTLTEST_CHECK_NEAR_EQUAL(c3.green(), 0.5);
      GTLTEST_CHECK_NEAR_EQUAL(c3.blue(), 0.2);
      GTLTEST_CHECK_NEAR_EQUAL(c3.alpha(), 0.5);
      GTLTEST_CHECK_EQUAL(c2,c3);
      c3.setRed(0.6);
      GTLTEST_CHECK_NEAR_EQUAL(c2.red(), 0.3);
      GTLTEST_CHECK_NEAR_EQUAL(c3.red(), 0.6);
      c3 = c2;
      c3.setGreen(0.7);
      GTLTEST_CHECK_NEAR_EQUAL(c2.green(), 0.5);
      GTLTEST_CHECK_NEAR_EQUAL(c3.green(), 0.7);
      c3 = c2;
      c3.setBlue(0.1);
      GTLTEST_CHECK_NEAR_EQUAL(c2.blue(), 0.2);
      GTLTEST_CHECK_NEAR_EQUAL(c3.blue(), 0.1);
      c3 = c2;
      c3.setAlpha(0.3);
      GTLTEST_CHECK_NEAR_EQUAL(c2.alpha(), 0.5);
      GTLTEST_CHECK_NEAR_EQUAL(c3.alpha(), 0.3);
    }
};










