/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/* This is a machine generated file - Please DO NOT EDIT !
 * Change RoundingAndPropertyTest instead,
 * and run with "-gengold" argument to regenerate (without copyright header).
 */

/* This file contains the set of result Strings expected from calling inside
 * RoundingAndPropertyTest the method NumberFormat.format() upon the set of
 * double values provided in GoldenDoubleValues.java. It contains three arrays,
 * each containing arrays of unicode values representing the expected string
 * result when calling format() on the corresponding (i.e. same index) double
 * value found in GoldenDoubleValues arrays :
 * - DecimalDigitsLocalizedFormattedValues corresponds to DecimalLocalizationValues,
 *   when using FullLocalizationTestLocale to format.
 * - DecimalGoldenFormattedValues corresponds to DecimalGoldenValues, when used
 *   in the decimal pattern case together with TestLocale.
 * - CurrencyGoldenFormattedValues corresponds to CurrencyGoldenValues. when used
 *   in the currency pattern case together with TestLocale.
 * Please see documentation in RoundingAndPropertyTest.java for more details.
 *
 * This file generated by running RoundingAndPropertyTest with "-gengold" argument.
 */

class GoldenFormattedValues {

    // The formatted values below were generated from golden values
    // listed in GoldenDoubleValues.java, using the following jvm version :
    //   Oracle Corporation Java HotSpot(TM) Server VM 1.8.0-ea
    //   locale for golden double values : en_US
    //   locale for testing digit localization : hi_IN

    // The array of int[] unicode values storing the expected results
    // when experiencing full localization of digits on DecimalLocalizationValues.
    static int[][] DecimalDigitsLocalizedFormattedValues = {
        { 2407, 46, 2407, 2408, 2409 },
        { 2407, 2408, 46, 2407, 2408, 2409 },
        { 2407, 2408, 2409, 46, 2407, 2408, 2409 },
        { 2407, 44, 2408, 2409, 2410, 46, 2407, 2408, 2409 },
        { 2407, 2408, 44, 2409, 2410, 2411, 46, 2407, 2408, 2409 },
        { 2407, 2408, 2409, 44, 2410, 2411, 2412, 46, 2407, 2408, 2409 },
        { 2407, 44, 2408, 2409, 2410, 44, 2411, 2412, 2413, 46, 2407, 2408, 2409 },
        { 2407, 2408, 44, 2409, 2410, 2411, 44, 2412, 2413, 2414, 46, 2407, 2408, 2409 },
        { 2407, 2408, 2409, 44, 2410, 2411, 2412, 44, 2413, 2414, 2415, 46, 2407, 2408, 2409 },
        { 2407, 44, 2408, 2409, 2410, 44, 2411, 2412, 2413, 44, 2414, 2415, 2406, 46, 2407, 2408, 2409 },
        { 2407, 44, 2408, 2409, 2410 },
        { 2407, 44, 2408, 2409, 2410, 46, 2415 },
        { 2407, 44, 2408, 2409, 2410, 46, 2415, 2415 },
        { 2407, 44, 2408, 2409, 2410, 46, 2415, 2415, 2415 },
    };

    // The array of int[] unicode values storing the expected results
    // when calling Decimal.format(double) on the decimal GoldenDoubleValues.
    static int[][] DecimalGoldenFormattedValues = {
        { 48 },
        { 45, 48 },
        { 48 },
        { 48 },
        { 45, 50, 44, 49, 52, 55, 44, 52, 56, 51, 44, 54, 52, 54, 46, 50, 51, 51 },
        { 50, 44, 49, 52, 55, 44, 52, 56, 51, 44, 54, 52, 54, 46, 50, 51, 52 },
        { 45, 50, 44, 49, 52, 55, 44, 52, 56, 51, 44, 54, 52, 56 },
        { 50, 44, 49, 52, 55, 44, 52, 56, 51, 44, 54, 52, 56 },
        { 45, 49, 44, 57, 57, 57, 44, 57, 57, 57, 44, 57, 57, 57, 46, 57, 57, 57 },
        { 50, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48 },
        { 65533 },
        { 8734 },
        { 45, 8734 },
        { 49, 55, 57, 44, 55, 54, 57, 44, 51, 49, 51, 44, 52, 56, 54, 44, 50, 51, 49, 44, 53, 55, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48 },
        { 45, 57, 44, 56, 55, 54, 44, 53, 52, 51, 44, 50, 49, 48, 46, 57, 56, 56 },
        { 57, 44, 56, 55, 54, 44, 53, 52, 51, 44, 50, 49, 48, 46, 57, 56, 56 },
        { 45, 49, 50, 51, 44, 52, 53, 54, 44, 55, 56, 57, 44, 48, 49, 50, 44, 51, 52, 53, 44, 54, 55, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48 },
        { 49, 50, 51, 44, 52, 53, 54, 44, 55, 56, 57, 44, 48, 49, 50, 44, 51, 52, 53, 44, 54, 55, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48 },
        { 49, 46, 49, 50, 51 },
        { 49, 50, 46, 49, 50, 51 },
        { 49, 50, 51, 46, 49, 50, 51 },
        { 49, 44, 50, 51, 52, 46, 49, 50, 51 },
        { 49, 50, 44, 51, 52, 53, 46, 49, 50, 51 },
        { 49, 50, 51, 44, 52, 53, 54, 46, 49, 50, 51 },
        { 49, 44, 50, 51, 52, 44, 53, 54, 55, 46, 49, 50, 51 },
        { 49, 50, 44, 51, 52, 53, 44, 54, 55, 56, 46, 49, 50, 51 },
        { 49, 50, 51, 44, 52, 53, 54, 44, 55, 56, 57, 46, 49, 50, 51 },
        { 49, 44, 50, 51, 52, 44, 53, 54, 55, 44, 56, 57, 48, 46, 49, 50, 51 },
        { 45, 49, 46, 49, 50, 51 },
        { 45, 49, 50, 46, 49, 50, 51 },
        { 45, 49, 50, 51, 46, 49, 50, 51 },
        { 45, 49, 44, 50, 51, 52, 46, 49, 50, 51 },
        { 45, 49, 50, 44, 51, 52, 53, 46, 49, 50, 51 },
        { 45, 49, 50, 51, 44, 52, 53, 54, 46, 49, 50, 51 },
        { 45, 49, 44, 50, 51, 52, 44, 53, 54, 55, 46, 49, 50, 51 },
        { 45, 49, 50, 44, 51, 52, 53, 44, 54, 55, 56, 46, 49, 50, 51 },
        { 45, 49, 50, 51, 44, 52, 53, 54, 44, 55, 56, 57, 46, 49, 50, 51 },
        { 45, 49, 44, 50, 51, 52, 44, 53, 54, 55, 44, 56, 57, 48, 46, 49, 50, 51 },
        { 48, 46, 49 },
        { 48, 46, 49, 50 },
        { 48, 46, 49, 50, 51 },
        { 48, 46, 49, 50, 51 },
        { 49, 48, 46, 49 },
        { 49, 48, 46, 49, 50 },
        { 49, 48, 46, 49, 50, 51 },
        { 49, 48, 46, 49, 50, 51 },
        { 49, 48, 48, 46, 49 },
        { 49, 48, 48, 46, 49, 50 },
        { 49, 48, 48, 46, 49, 50, 51 },
        { 49, 48, 48, 46, 49, 50, 51 },
        { 49, 44, 48, 48, 48, 46, 49 },
        { 49, 44, 48, 48, 48, 46, 49, 50 },
        { 49, 44, 48, 48, 48, 46, 49, 50, 51 },
        { 49, 44, 48, 48, 48, 46, 49, 50, 51 },
        { 49, 48, 44, 48, 48, 48, 46, 49 },
        { 49, 48, 44, 48, 48, 48, 46, 49, 50 },
        { 49, 48, 44, 48, 48, 48, 46, 49, 50, 51 },
        { 49, 48, 44, 48, 48, 48, 46, 49, 50, 51 },
        { 49, 48, 48, 44, 48, 48, 48, 46, 49 },
        { 49, 48, 48, 44, 48, 48, 48, 46, 49, 50 },
        { 49, 48, 48, 44, 48, 48, 48, 46, 49, 50, 51 },
        { 49, 48, 48, 44, 48, 48, 48, 46, 49, 50, 51 },
        { 49, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49 },
        { 49, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50 },
        { 49, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50, 51 },
        { 49, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50, 51 },
        { 49, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49 },
        { 49, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50 },
        { 49, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50, 51 },
        { 49, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50, 51 },
        { 49, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49 },
        { 49, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50 },
        { 49, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50, 51 },
        { 49, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50, 51 },
        { 49, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49 },
        { 49, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50 },
        { 49, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50, 51 },
        { 49, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50, 51 },
        { 45, 48, 46, 49 },
        { 45, 48, 46, 49, 50 },
        { 45, 48, 46, 49, 50, 51 },
        { 45, 48, 46, 49, 50, 51 },
        { 45, 49, 48, 46, 49 },
        { 45, 49, 48, 46, 49, 50 },
        { 45, 49, 48, 46, 49, 50, 51 },
        { 45, 49, 48, 46, 49, 50, 51 },
        { 45, 49, 48, 48, 46, 49 },
        { 45, 49, 48, 48, 46, 49, 50 },
        { 45, 49, 48, 48, 46, 49, 50, 51 },
        { 45, 49, 48, 48, 46, 49, 50, 51 },
        { 45, 49, 44, 48, 48, 48, 46, 49 },
        { 45, 49, 44, 48, 48, 48, 46, 49, 50 },
        { 45, 49, 44, 48, 48, 48, 46, 49, 50, 51 },
        { 45, 49, 44, 48, 48, 48, 46, 49, 50, 51 },
        { 45, 49, 48, 44, 48, 48, 48, 46, 49 },
        { 45, 49, 48, 44, 48, 48, 48, 46, 49, 50 },
        { 45, 49, 48, 44, 48, 48, 48, 46, 49, 50, 51 },
        { 45, 49, 48, 44, 48, 48, 48, 46, 49, 50, 51 },
        { 45, 49, 48, 48, 44, 48, 48, 48, 46, 49 },
        { 45, 49, 48, 48, 44, 48, 48, 48, 46, 49, 50 },
        { 45, 49, 48, 48, 44, 48, 48, 48, 46, 49, 50, 51 },
        { 45, 49, 48, 48, 44, 48, 48, 48, 46, 49, 50, 51 },
        { 45, 49, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49 },
        { 45, 49, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50 },
        { 45, 49, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50, 51 },
        { 45, 49, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50, 51 },
        { 45, 49, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49 },
        { 45, 49, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50 },
        { 45, 49, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50, 51 },
        { 45, 49, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50, 51 },
        { 45, 49, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49 },
        { 45, 49, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50 },
        { 45, 49, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50, 51 },
        { 45, 49, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50, 51 },
        { 45, 49, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49 },
        { 45, 49, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50 },
        { 45, 49, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50, 51 },
        { 45, 49, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50, 51 },
        { 49, 46, 57, 57, 57 },
        { 49, 50, 46, 57, 57, 57 },
        { 49, 50, 51, 46, 57, 57, 57 },
        { 49, 44, 50, 51, 52, 46, 57, 57, 57 },
        { 49, 50, 44, 51, 52, 53, 46, 57, 57, 57 },
        { 49, 50, 51, 44, 52, 53, 54, 46, 57, 57, 57 },
        { 49, 44, 50, 51, 52, 44, 53, 54, 55, 46, 57, 57, 57 },
        { 49, 50, 44, 51, 52, 53, 44, 54, 55, 56, 46, 57, 57, 57 },
        { 49, 50, 51, 44, 52, 53, 54, 44, 55, 56, 57, 46, 57, 57, 57 },
        { 49, 44, 50, 51, 52, 44, 53, 54, 55, 44, 56, 57, 48, 46, 57, 57, 57 },
        { 50 },
        { 49, 51 },
        { 49, 50, 52 },
        { 49, 44, 50, 51, 53 },
        { 49, 50, 44, 51, 52, 54 },
        { 49, 50, 51, 44, 52, 53, 55 },
        { 49, 44, 50, 51, 52, 44, 53, 54, 56 },
        { 49, 50, 44, 51, 52, 53, 44, 54, 55, 57 },
        { 49, 50, 51, 44, 52, 53, 54, 44, 55, 57, 48 },
        { 49, 44, 50, 51, 52, 44, 53, 54, 55, 44, 56, 57, 49 },
        { 45, 49, 46, 57, 57, 57 },
        { 45, 49, 50, 46, 57, 57, 57 },
        { 45, 49, 50, 51, 46, 57, 57, 57 },
        { 45, 49, 44, 50, 51, 52, 46, 57, 57, 57 },
        { 45, 49, 50, 44, 51, 52, 53, 46, 57, 57, 57 },
        { 45, 49, 50, 51, 44, 52, 53, 54, 46, 57, 57, 57 },
        { 45, 49, 44, 50, 51, 52, 44, 53, 54, 55, 46, 57, 57, 57 },
        { 45, 49, 50, 44, 51, 52, 53, 44, 54, 55, 56, 46, 57, 57, 57 },
        { 45, 49, 50, 51, 44, 52, 53, 54, 44, 55, 56, 57, 46, 57, 57, 57 },
        { 45, 49, 44, 50, 51, 52, 44, 53, 54, 55, 44, 56, 57, 48, 46, 57, 57, 57 },
        { 45, 50 },
        { 45, 49, 51 },
        { 45, 49, 50, 52 },
        { 45, 49, 44, 50, 51, 53 },
        { 45, 49, 50, 44, 51, 52, 54 },
        { 45, 49, 50, 51, 44, 52, 53, 55 },
        { 45, 49, 44, 50, 51, 52, 44, 53, 54, 56 },
        { 45, 49, 50, 44, 51, 52, 53, 44, 54, 55, 57 },
        { 45, 49, 50, 51, 44, 52, 53, 54, 44, 55, 57, 48 },
        { 45, 49, 44, 50, 51, 52, 44, 53, 54, 55, 44, 56, 57, 49 },
        { 49, 49, 48 },
        { 49, 44, 49, 48, 48 },
        { 49, 49, 44, 48, 48, 48 },
        { 49, 49, 48, 44, 48, 48, 48 },
        { 49, 44, 49, 48, 48, 44, 48, 48, 48 },
        { 49, 49, 44, 48, 48, 48, 44, 48, 48, 48 },
        { 49, 49, 48, 44, 48, 48, 48, 44, 48, 48, 48 },
        { 49, 44, 49, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48 },
        { 45, 49, 49, 48 },
        { 45, 49, 44, 49, 48, 48 },
        { 45, 49, 49, 44, 48, 48, 48 },
        { 45, 49, 49, 48, 44, 48, 48, 48 },
        { 45, 49, 44, 49, 48, 48, 44, 48, 48, 48 },
        { 45, 49, 49, 44, 48, 48, 48, 44, 48, 48, 48 },
        { 45, 49, 49, 48, 44, 48, 48, 48, 44, 48, 48, 48 },
        { 45, 49, 44, 49, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48 },
        { 50 },
        { 50, 48 },
        { 50, 48, 48 },
        { 50, 44, 48, 48, 48 },
        { 50, 48, 44, 48, 48, 48 },
        { 50, 48, 48, 44, 48, 48, 48 },
        { 50, 44, 48, 48, 48, 44, 48, 48, 48 },
        { 50, 48, 44, 48, 48, 48, 44, 48, 48, 48 },
        { 50, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48 },
        { 50, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48 },
        { 45, 50 },
        { 45, 50, 48 },
        { 45, 50, 48, 48 },
        { 45, 50, 44, 48, 48, 48 },
        { 45, 50, 48, 44, 48, 48, 48 },
        { 45, 50, 48, 48, 44, 48, 48, 48 },
        { 45, 50, 44, 48, 48, 48, 44, 48, 48, 48 },
        { 45, 50, 48, 44, 48, 48, 48, 44, 48, 48, 48 },
        { 45, 50, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48 },
        { 45, 50, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48 },
        { 49, 48 },
        { 49, 48, 48 },
        { 49, 44, 48, 48, 48 },
        { 49, 48, 44, 48, 48, 48 },
        { 49, 48, 48, 44, 48, 48, 48 },
        { 49, 44, 48, 48, 48, 44, 48, 48, 48 },
        { 49, 48, 44, 48, 48, 48, 44, 48, 48, 48 },
        { 49, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48 },
        { 49, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48 },
        { 57, 46, 57, 57, 57 },
        { 57, 57, 46, 57, 57, 57 },
        { 57, 57, 57, 46, 57, 57, 57 },
        { 57, 44, 57, 57, 57, 46, 57, 57, 57 },
        { 57, 57, 44, 57, 57, 57, 46, 57, 57, 57 },
        { 57, 57, 57, 44, 57, 57, 57, 46, 57, 57, 57 },
        { 57, 44, 57, 57, 57, 44, 57, 57, 57, 46, 57, 57, 57 },
        { 57, 57, 44, 57, 57, 57, 44, 57, 57, 57, 46, 57, 57, 57 },
        { 57, 57, 57, 44, 57, 57, 57, 44, 57, 57, 57, 46, 57, 57, 57 },
        { 45, 49, 48 },
        { 45, 49, 48, 48 },
        { 45, 49, 44, 48, 48, 48 },
        { 45, 49, 48, 44, 48, 48, 48 },
        { 45, 49, 48, 48, 44, 48, 48, 48 },
        { 45, 49, 44, 48, 48, 48, 44, 48, 48, 48 },
        { 45, 49, 48, 44, 48, 48, 48, 44, 48, 48, 48 },
        { 45, 49, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48 },
        { 45, 49, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48 },
        { 45, 57, 46, 57, 57, 57 },
        { 45, 57, 57, 46, 57, 57, 57 },
        { 45, 57, 57, 57, 46, 57, 57, 57 },
        { 45, 57, 44, 57, 57, 57, 46, 57, 57, 57 },
        { 45, 57, 57, 44, 57, 57, 57, 46, 57, 57, 57 },
        { 45, 57, 57, 57, 44, 57, 57, 57, 46, 57, 57, 57 },
        { 45, 57, 44, 57, 57, 57, 44, 57, 57, 57, 46, 57, 57, 57 },
        { 45, 57, 57, 44, 57, 57, 57, 44, 57, 57, 57, 46, 57, 57, 57 },
        { 45, 57, 57, 57, 44, 57, 57, 57, 44, 57, 57, 57, 46, 57, 57, 57 },
        { 49 },
        { 49, 50 },
        { 49, 50, 51 },
        { 49, 44, 50, 51, 52 },
        { 49, 50, 44, 51, 52, 53 },
        { 49, 50, 51, 44, 52, 53, 54 },
        { 49, 44, 50, 51, 52, 44, 53, 54, 55 },
        { 49, 50, 44, 51, 52, 53, 44, 54, 55, 56 },
        { 49, 50, 51, 44, 52, 53, 54, 44, 55, 56, 57 },
        { 49, 44, 50, 51, 52, 44, 53, 54, 55, 44, 56, 57, 48 },
        { 45, 49 },
        { 45, 49, 50 },
        { 45, 49, 50, 51 },
        { 45, 49, 44, 50, 51, 52 },
        { 45, 49, 50, 44, 51, 52, 53 },
        { 45, 49, 50, 51, 44, 52, 53, 54 },
        { 45, 49, 44, 50, 51, 52, 44, 53, 54, 55 },
        { 45, 49, 50, 44, 51, 52, 53, 44, 54, 55, 56 },
        { 45, 49, 50, 51, 44, 52, 53, 54, 44, 55, 56, 57 },
        { 45, 49, 44, 50, 51, 52, 44, 53, 54, 55, 44, 56, 57, 48 },
        { 45, 50, 44, 53, 57, 57, 46, 52 },
        { 45, 50, 44, 53, 57, 57, 46, 51, 52 },
        { 45, 50, 44, 53, 57, 57, 46, 51, 51, 52 },
        { 49 },
        { 49 },
        { 49 },
        { 49 },
        { 49 },
        { 49, 46, 48, 48, 49 },
        { 49, 46, 48, 48, 49 },
        { 49, 46, 48, 48, 49 },
        { 49, 46, 48, 48, 49 },
        { 49, 46, 48, 48, 49 },
        { 49, 46, 50, 50, 50 },
        { 49, 46, 50, 50, 50 },
        { 49, 46, 50, 50, 50 },
        { 49, 46, 50, 50, 50 },
        { 49, 46, 50, 50, 50 },
        { 49, 46, 50, 50, 50 },
        { 49, 46, 50, 50, 50 },
        { 49, 46, 50, 50, 50 },
        { 49, 46, 50, 50, 50 },
        { 49, 46, 50, 50, 50 },
        { 49, 46, 50, 50, 50 },
        { 49, 46, 50, 50, 50 },
        { 49, 46, 50, 50, 50 },
        { 49, 46, 50, 50, 50 },
        { 49, 46, 50, 50, 50 },
        { 49, 46, 50, 50, 50 },
        { 49, 46, 50, 50, 50 },
        { 49, 46, 50, 50, 50 },
        { 49, 46, 50, 50, 50 },
        { 49, 46, 50, 50, 50 },
        { 49, 46, 50, 50, 51 },
        { 49, 46, 50, 50, 51 },
        { 49, 46, 50, 50, 51 },
        { 49, 46, 50, 50, 51 },
        { 49, 46, 50, 50, 51 },
        { 49, 46, 50, 50, 51 },
        { 49, 46, 50, 50, 51 },
        { 49, 46, 50, 50, 51 },
        { 49, 46, 50, 50, 51 },
        { 49, 46, 50, 50, 51 },
        { 49, 46, 50, 50, 51 },
        { 49, 46, 50, 50, 51 },
        { 49, 46, 50, 50, 51 },
        { 49, 46, 50, 50, 51 },
        { 49, 46, 50, 50, 51 },
        { 49, 46, 50, 50, 51 },
        { 49, 46, 50, 50, 51 },
        { 49, 46, 50, 50, 51 },
        { 49, 46, 50, 50, 51 },
        { 49, 48, 48, 44, 57, 49, 51, 46, 54, 55, 49 },
        { 49, 57, 57, 44, 57, 57, 57, 46, 57, 57, 57 },
        { 50, 53, 49, 44, 56, 52, 54, 46, 51, 52, 55 },
        { 50, 53, 51, 44, 50, 52, 51, 46, 56, 56, 51 },
        { 51, 54, 53, 44, 48, 52, 53, 46, 56, 53, 51 },
        { 51, 49, 52, 44, 55, 51, 52, 46, 57, 54, 49 },
        { 53, 52, 49, 44, 49, 51, 51, 46, 57, 55, 53 },
        { 56, 53, 56, 44, 51, 55, 50, 46, 49, 50, 51 },
        { 49, 44, 48, 48, 49, 44, 48, 48, 48 },
        { 49, 44, 51, 52, 55, 44, 53, 48, 53, 46, 55, 56, 50 },
        { 51, 44, 51, 53, 56, 44, 56, 52, 52, 46, 49, 57, 55 },
        { 57, 44, 57, 57, 55, 44, 57, 55, 57, 46, 52, 48, 57 },
        { 57, 44, 57, 57, 51, 44, 55, 52, 51, 46, 49, 53, 57 },
        { 57, 44, 57, 51, 56, 44, 54, 55, 49, 46, 57, 48, 57 },
        { 51, 44, 51, 56, 53, 44, 51, 48, 50, 46, 53, 52, 55 },
        { 51, 44, 52, 48, 52, 44, 54, 52, 50, 46, 54, 54, 49 },
        { 51, 44, 52, 51, 49, 44, 50, 56, 48, 46, 48, 56, 55 },
        { 51, 44, 52, 51, 56, 44, 55, 53, 54, 46, 52, 55, 53 },
        { 51, 44, 52, 52, 54, 44, 48, 53, 51, 46, 55, 56, 55 },
        { 51, 44, 52, 53, 55, 44, 57, 49, 55, 46, 53, 49, 51 },
        { 51, 44, 52, 54, 53, 44, 51, 57, 51, 46, 57, 48, 49 },
        { 51, 44, 52, 56, 52, 44, 55, 51, 52, 46, 48, 49, 53 },
        { 51, 44, 52, 57, 50, 44, 48, 51, 49, 46, 51, 50, 55 },
        { 51, 44, 53, 48, 51, 44, 56, 57, 53, 46, 48, 53, 51 },
        { 51, 44, 53, 49, 49, 44, 51, 55, 49, 46, 52, 52, 49 },
        { 51, 44, 53, 49, 56, 44, 54, 54, 56, 46, 55, 53, 51 },
        { 51, 44, 53, 51, 48, 44, 53, 51, 50, 46, 52, 55, 57 },
        { 51, 44, 53, 51, 56, 44, 48, 48, 56, 46, 56, 54, 55 },
        { 51, 44, 53, 52, 53, 44, 51, 48, 54, 46, 49, 55, 57 },
        { 51, 44, 53, 53, 55, 44, 49, 54, 57, 46, 57, 48, 53 },
        { 51, 44, 53, 53, 55, 44, 51, 52, 56, 46, 57, 56, 49 },
        { 51, 44, 53, 54, 52, 44, 54, 52, 54, 46, 50, 57, 51 },
        { 51, 44, 53, 56, 51, 44, 57, 56, 54, 46, 52, 48, 55 },
        { 51, 44, 53, 57, 49, 44, 50, 56, 51, 46, 55, 49, 57 },
        { 51, 44, 54, 48, 51, 44, 49, 52, 55, 46, 52, 52, 53 },
        { 51, 44, 54, 49, 48, 44, 54, 50, 51, 46, 56, 51, 51 },
        { 51, 44, 54, 49, 55, 44, 57, 50, 49, 46, 49, 52, 53 },
        { 51, 44, 54, 50, 57, 44, 55, 56, 52, 46, 56, 55, 49 },
        { 51, 44, 54, 51, 55, 44, 50, 54, 49, 46, 50, 53, 57 },
        { 51, 44, 54, 53, 54, 44, 52, 50, 50, 46, 50, 57, 55 },
        { 51, 44, 54, 53, 54, 44, 54, 48, 49, 46, 51, 55, 51 },
        { 51, 44, 54, 54, 51, 44, 56, 57, 56, 46, 54, 56, 53 },
        { 51, 44, 54, 55, 53, 44, 55, 54, 50, 46, 52, 49, 49 },
        { 51, 44, 54, 56, 51, 44, 50, 51, 56, 46, 55, 57, 57 },
        { 51, 44, 54, 57, 48, 44, 53, 51, 54, 46, 49, 49, 49 },
        { 51, 44, 55, 48, 50, 44, 51, 57, 57, 46, 56, 51, 55 },
        { 51, 44, 55, 48, 57, 44, 56, 55, 54, 46, 50, 50, 53 },
        { 51, 44, 55, 49, 55, 44, 49, 55, 51, 46, 53, 51, 55 },
        { 51, 44, 55, 50, 57, 44, 48, 51, 55, 46, 50, 54, 51 },
        { 51, 44, 55, 51, 54, 44, 53, 49, 51, 46, 54, 53, 49 },
        { 51, 44, 55, 53, 53, 44, 56, 53, 51, 46, 55, 54, 53 },
        { 51, 44, 55, 54, 51, 44, 49, 53, 49, 46, 48, 55, 55 },
        { 51, 44, 55, 55, 53, 44, 48, 49, 52, 46, 56, 48, 51 },
        { 51, 44, 55, 56, 50, 44, 52, 57, 49, 46, 49, 57, 49 },
        { 51, 44, 55, 56, 57, 44, 55, 56, 56, 46, 53, 48, 51 },
        { 51, 44, 56, 48, 49, 44, 54, 53, 50, 46, 50, 50, 57 },
        { 51, 44, 56, 48, 57, 44, 49, 50, 56, 46, 54, 49, 55 },
        { 51, 44, 56, 49, 54, 44, 52, 50, 53, 46, 57, 50, 57 },
        { 51, 44, 56, 50, 56, 44, 50, 56, 57, 46, 54, 53, 53 },
        { 51, 44, 56, 50, 56, 44, 52, 54, 56, 46, 55, 51, 49 },
        { 51, 44, 56, 51, 53, 44, 55, 54, 54, 46, 48, 52, 51 },
        { 51, 44, 56, 53, 53, 44, 49, 48, 54, 46, 49, 53, 55 },
        { 51, 44, 56, 54, 50, 44, 52, 48, 51, 46, 52, 54, 57 },
        { 51, 44, 56, 55, 52, 44, 50, 54, 55, 46, 49, 57, 53 },
        { 51, 44, 56, 56, 49, 44, 55, 52, 51, 46, 53, 56, 51 },
        { 51, 44, 56, 56, 57, 44, 48, 52, 48, 46, 56, 57, 53 },
        { 51, 44, 57, 48, 48, 44, 57, 48, 52, 46, 54, 50, 49 },
        { 51, 44, 57, 48, 56, 44, 51, 56, 49, 46, 48, 48, 57 },
        { 51, 44, 57, 50, 55, 44, 53, 52, 50, 46, 48, 52, 55 },
        { 51, 44, 57, 50, 55, 44, 55, 50, 49, 46, 49, 50, 51 },
        { 51, 44, 57, 51, 53, 44, 48, 49, 56, 46, 52, 51, 53 },
        { 51, 44, 57, 52, 54, 44, 56, 56, 50, 46, 49, 54, 49 },
        { 51, 44, 57, 53, 52, 44, 51, 53, 56, 46, 53, 52, 57 },
        { 51, 44, 57, 54, 49, 44, 54, 53, 53, 46, 56, 54, 49 },
        { 51, 44, 57, 55, 51, 44, 53, 49, 57, 46, 53, 56, 55 },
        { 51, 44, 57, 56, 48, 44, 57, 57, 53, 46, 57, 55, 53 },
        { 51, 44, 57, 56, 56, 44, 50, 57, 51, 46, 50, 56, 55 },
        { 52, 44, 48, 48, 48, 44, 49, 53, 55, 46, 48, 49, 51 },
        { 52, 44, 48, 48, 55, 44, 54, 51, 51, 46, 52, 48, 49 },
        { 52, 44, 48, 50, 54, 44, 57, 55, 51, 46, 53, 49, 53 },
        { 52, 44, 48, 51, 52, 44, 50, 55, 48, 46, 56, 50, 55 },
        { 52, 44, 48, 52, 54, 44, 49, 51, 52, 46, 53, 53, 51 },
        { 52, 44, 48, 53, 51, 44, 54, 49, 48, 46, 57, 52, 49 },
        { 52, 44, 48, 54, 48, 44, 57, 48, 56, 46, 50, 53, 51 },
        { 52, 44, 48, 55, 50, 44, 55, 55, 49, 46, 57, 55, 57 },
        { 52, 44, 48, 56, 48, 44, 50, 52, 56, 46, 51, 54, 55 },
        { 52, 44, 48, 56, 55, 44, 53, 52, 53, 46, 54, 55, 57 },
        { 52, 44, 48, 57, 57, 44, 52, 48, 57, 46, 52, 48, 53 },
        { 52, 44, 48, 57, 57, 44, 53, 56, 56, 46, 52, 56, 49 },
        { 52, 44, 49, 48, 54, 44, 56, 56, 53, 46, 55, 57, 51 },
        { 52, 44, 49, 50, 54, 44, 50, 50, 53, 46, 57, 48, 55 },
        { 52, 44, 49, 51, 51, 44, 53, 50, 51, 46, 50, 49, 57 },
        { 52, 44, 49, 52, 53, 44, 51, 56, 54, 46, 57, 52, 53 },
        { 52, 44, 49, 53, 50, 44, 56, 54, 51, 46, 51, 51, 51 },
        { 52, 44, 49, 54, 48, 44, 49, 54, 48, 46, 54, 52, 53 },
        { 52, 44, 49, 55, 50, 44, 48, 50, 52, 46, 51, 55, 49 },
        { 52, 44, 49, 55, 57, 44, 53, 48, 48, 46, 55, 53, 57 },
        { 52, 44, 49, 57, 56, 44, 54, 54, 49, 46, 55, 57, 55 },
        { 52, 44, 50, 48, 51, 44, 52, 48, 55, 46, 50, 56, 55 },
        { 52, 44, 50, 49, 48, 44, 55, 48, 52, 46, 53, 57, 57 },
        { 52, 44, 50, 49, 51, 44, 52, 51, 53, 46, 52, 57, 55 },
    };

    // The array of int[] unicode values storing the expected results
    // when calling Decimal.format(double) on the currency GoldenDoubleValues.
    static int[][] CurrencyGoldenFormattedValues = {
        { 36, 48, 46, 48, 48 },
        { 40, 36, 48, 46, 48, 48, 41 },
        { 36, 48, 46, 48, 48 },
        { 36, 48, 46, 48, 48 },
        { 40, 36, 50, 44, 49, 52, 55, 44, 52, 56, 51, 44, 54, 52, 54, 46, 50, 51, 41 },
        { 36, 50, 44, 49, 52, 55, 44, 52, 56, 51, 44, 54, 52, 54, 46, 50, 51 },
        { 40, 36, 50, 44, 49, 52, 55, 44, 52, 56, 51, 44, 54, 52, 56, 46, 48, 48, 41 },
        { 36, 50, 44, 49, 52, 55, 44, 52, 56, 51, 44, 54, 52, 56, 46, 48, 48 },
        { 40, 36, 49, 44, 57, 57, 57, 44, 57, 57, 57, 44, 57, 57, 57, 46, 57, 57, 41 },
        { 36, 50, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 48, 48 },
        { 65533 },
        { 36, 8734 },
        { 40, 36, 8734, 41 },
        { 36, 49, 55, 57, 44, 55, 54, 57, 44, 51, 49, 51, 44, 52, 56, 54, 44, 50, 51, 49, 44, 53, 55, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 48, 48 },
        { 40, 36, 57, 44, 56, 55, 54, 44, 53, 52, 51, 44, 50, 49, 48, 46, 57, 57, 41 },
        { 36, 57, 44, 56, 55, 54, 44, 53, 52, 51, 44, 50, 49, 48, 46, 57, 57 },
        { 40, 36, 49, 50, 51, 44, 52, 53, 54, 44, 55, 56, 57, 44, 48, 49, 50, 44, 51, 52, 53, 44, 54, 55, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 48, 48, 41 },
        { 36, 49, 50, 51, 44, 52, 53, 54, 44, 55, 56, 57, 44, 48, 49, 50, 44, 51, 52, 53, 44, 54, 55, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 48, 48 },
        { 36, 49, 46, 49, 50 },
        { 36, 49, 50, 46, 49, 50 },
        { 36, 49, 50, 51, 46, 49, 50 },
        { 36, 49, 44, 50, 51, 52, 46, 49, 50 },
        { 36, 49, 50, 44, 51, 52, 53, 46, 49, 50 },
        { 36, 49, 50, 51, 44, 52, 53, 54, 46, 49, 50 },
        { 36, 49, 44, 50, 51, 52, 44, 53, 54, 55, 46, 49, 50 },
        { 36, 49, 50, 44, 51, 52, 53, 44, 54, 55, 56, 46, 49, 50 },
        { 36, 49, 50, 51, 44, 52, 53, 54, 44, 55, 56, 57, 46, 49, 50 },
        { 36, 49, 44, 50, 51, 52, 44, 53, 54, 55, 44, 56, 57, 48, 46, 49, 50 },
        { 40, 36, 49, 46, 49, 50, 41 },
        { 40, 36, 49, 50, 46, 49, 50, 41 },
        { 40, 36, 49, 50, 51, 46, 49, 50, 41 },
        { 40, 36, 49, 44, 50, 51, 52, 46, 49, 50, 41 },
        { 40, 36, 49, 50, 44, 51, 52, 53, 46, 49, 50, 41 },
        { 40, 36, 49, 50, 51, 44, 52, 53, 54, 46, 49, 50, 41 },
        { 40, 36, 49, 44, 50, 51, 52, 44, 53, 54, 55, 46, 49, 50, 41 },
        { 40, 36, 49, 50, 44, 51, 52, 53, 44, 54, 55, 56, 46, 49, 50, 41 },
        { 40, 36, 49, 50, 51, 44, 52, 53, 54, 44, 55, 56, 57, 46, 49, 50, 41 },
        { 40, 36, 49, 44, 50, 51, 52, 44, 53, 54, 55, 44, 56, 57, 48, 46, 49, 50, 41 },
        { 36, 48, 46, 49, 48 },
        { 36, 48, 46, 49, 50 },
        { 36, 48, 46, 49, 50 },
        { 36, 49, 48, 46, 49, 48 },
        { 36, 49, 48, 46, 49, 50 },
        { 36, 49, 48, 46, 49, 50 },
        { 36, 49, 48, 48, 46, 49, 48 },
        { 36, 49, 48, 48, 46, 49, 50 },
        { 36, 49, 48, 48, 46, 49, 50 },
        { 36, 49, 44, 48, 48, 48, 46, 49, 48 },
        { 36, 49, 44, 48, 48, 48, 46, 49, 50 },
        { 36, 49, 44, 48, 48, 48, 46, 49, 50 },
        { 36, 49, 48, 44, 48, 48, 48, 46, 49, 48 },
        { 36, 49, 48, 44, 48, 48, 48, 46, 49, 50 },
        { 36, 49, 48, 44, 48, 48, 48, 46, 49, 50 },
        { 36, 49, 48, 48, 44, 48, 48, 48, 46, 49, 48 },
        { 36, 49, 48, 48, 44, 48, 48, 48, 46, 49, 50 },
        { 36, 49, 48, 48, 44, 48, 48, 48, 46, 49, 50 },
        { 36, 49, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 48 },
        { 36, 49, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50 },
        { 36, 49, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50 },
        { 36, 49, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 48 },
        { 36, 49, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50 },
        { 36, 49, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50 },
        { 36, 49, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 48 },
        { 36, 49, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50 },
        { 36, 49, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50 },
        { 36, 49, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 48 },
        { 36, 49, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50 },
        { 36, 49, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50 },
        { 40, 36, 48, 46, 49, 48, 41 },
        { 40, 36, 48, 46, 49, 50, 41 },
        { 40, 36, 48, 46, 49, 50, 41 },
        { 40, 36, 49, 48, 46, 49, 48, 41 },
        { 40, 36, 49, 48, 46, 49, 50, 41 },
        { 40, 36, 49, 48, 46, 49, 50, 41 },
        { 40, 36, 49, 48, 48, 46, 49, 48, 41 },
        { 40, 36, 49, 48, 48, 46, 49, 50, 41 },
        { 40, 36, 49, 48, 48, 46, 49, 50, 41 },
        { 40, 36, 49, 44, 48, 48, 48, 46, 49, 48, 41 },
        { 40, 36, 49, 44, 48, 48, 48, 46, 49, 50, 41 },
        { 40, 36, 49, 44, 48, 48, 48, 46, 49, 50, 41 },
        { 40, 36, 49, 48, 44, 48, 48, 48, 46, 49, 48, 41 },
        { 40, 36, 49, 48, 44, 48, 48, 48, 46, 49, 50, 41 },
        { 40, 36, 49, 48, 44, 48, 48, 48, 46, 49, 50, 41 },
        { 40, 36, 49, 48, 48, 44, 48, 48, 48, 46, 49, 48, 41 },
        { 40, 36, 49, 48, 48, 44, 48, 48, 48, 46, 49, 50, 41 },
        { 40, 36, 49, 48, 48, 44, 48, 48, 48, 46, 49, 50, 41 },
        { 40, 36, 49, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 48, 41 },
        { 40, 36, 49, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50, 41 },
        { 40, 36, 49, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50, 41 },
        { 40, 36, 49, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 48, 41 },
        { 40, 36, 49, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50, 41 },
        { 40, 36, 49, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50, 41 },
        { 40, 36, 49, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 48, 41 },
        { 40, 36, 49, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50, 41 },
        { 40, 36, 49, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50, 41 },
        { 40, 36, 49, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 48, 41 },
        { 40, 36, 49, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50, 41 },
        { 40, 36, 49, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 49, 50, 41 },
        { 36, 49, 46, 57, 57 },
        { 36, 49, 50, 46, 57, 57 },
        { 36, 49, 50, 51, 46, 57, 57 },
        { 36, 49, 44, 50, 51, 52, 46, 57, 57 },
        { 36, 49, 50, 44, 51, 52, 53, 46, 57, 57 },
        { 36, 49, 50, 51, 44, 52, 53, 54, 46, 57, 57 },
        { 36, 49, 44, 50, 51, 52, 44, 53, 54, 55, 46, 57, 57 },
        { 36, 49, 50, 44, 51, 52, 53, 44, 54, 55, 56, 46, 57, 57 },
        { 36, 49, 50, 51, 44, 52, 53, 54, 44, 55, 56, 57, 46, 57, 57 },
        { 36, 49, 44, 50, 51, 52, 44, 53, 54, 55, 44, 56, 57, 48, 46, 57, 57 },
        { 36, 50, 46, 48, 48 },
        { 36, 49, 51, 46, 48, 48 },
        { 36, 49, 50, 52, 46, 48, 48 },
        { 36, 49, 44, 50, 51, 53, 46, 48, 48 },
        { 36, 49, 50, 44, 51, 52, 54, 46, 48, 48 },
        { 36, 49, 50, 51, 44, 52, 53, 55, 46, 48, 48 },
        { 36, 49, 44, 50, 51, 52, 44, 53, 54, 56, 46, 48, 48 },
        { 36, 49, 50, 44, 51, 52, 53, 44, 54, 55, 57, 46, 48, 48 },
        { 36, 49, 50, 51, 44, 52, 53, 54, 44, 55, 57, 48, 46, 48, 48 },
        { 36, 49, 44, 50, 51, 52, 44, 53, 54, 55, 44, 56, 57, 49, 46, 48, 48 },
        { 40, 36, 49, 46, 57, 57, 41 },
        { 40, 36, 49, 50, 46, 57, 57, 41 },
        { 40, 36, 49, 50, 51, 46, 57, 57, 41 },
        { 40, 36, 49, 44, 50, 51, 52, 46, 57, 57, 41 },
        { 40, 36, 49, 50, 44, 51, 52, 53, 46, 57, 57, 41 },
        { 40, 36, 49, 50, 51, 44, 52, 53, 54, 46, 57, 57, 41 },
        { 40, 36, 49, 44, 50, 51, 52, 44, 53, 54, 55, 46, 57, 57, 41 },
        { 40, 36, 49, 50, 44, 51, 52, 53, 44, 54, 55, 56, 46, 57, 57, 41 },
        { 40, 36, 49, 50, 51, 44, 52, 53, 54, 44, 55, 56, 57, 46, 57, 57, 41 },
        { 40, 36, 49, 44, 50, 51, 52, 44, 53, 54, 55, 44, 56, 57, 48, 46, 57, 57, 41 },
        { 40, 36, 50, 46, 48, 48, 41 },
        { 40, 36, 49, 51, 46, 48, 48, 41 },
        { 40, 36, 49, 50, 52, 46, 48, 48, 41 },
        { 40, 36, 49, 44, 50, 51, 53, 46, 48, 48, 41 },
        { 40, 36, 49, 50, 44, 51, 52, 54, 46, 48, 48, 41 },
        { 40, 36, 49, 50, 51, 44, 52, 53, 55, 46, 48, 48, 41 },
        { 40, 36, 49, 44, 50, 51, 52, 44, 53, 54, 56, 46, 48, 48, 41 },
        { 40, 36, 49, 50, 44, 51, 52, 53, 44, 54, 55, 57, 46, 48, 48, 41 },
        { 40, 36, 49, 50, 51, 44, 52, 53, 54, 44, 55, 57, 48, 46, 48, 48, 41 },
        { 40, 36, 49, 44, 50, 51, 52, 44, 53, 54, 55, 44, 56, 57, 49, 46, 48, 48, 41 },
        { 36, 49, 49, 48, 46, 48, 48 },
        { 36, 49, 44, 49, 48, 48, 46, 48, 48 },
        { 36, 49, 49, 44, 48, 48, 48, 46, 48, 48 },
        { 36, 49, 49, 48, 44, 48, 48, 48, 46, 48, 48 },
        { 36, 49, 44, 49, 48, 48, 44, 48, 48, 48, 46, 48, 48 },
        { 36, 49, 49, 44, 48, 48, 48, 44, 48, 48, 48, 46, 48, 48 },
        { 36, 49, 49, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 48, 48 },
        { 36, 49, 44, 49, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 48, 48 },
        { 40, 36, 49, 49, 48, 46, 48, 48, 41 },
        { 40, 36, 49, 44, 49, 48, 48, 46, 48, 48, 41 },
        { 40, 36, 49, 49, 44, 48, 48, 48, 46, 48, 48, 41 },
        { 40, 36, 49, 49, 48, 44, 48, 48, 48, 46, 48, 48, 41 },
        { 40, 36, 49, 44, 49, 48, 48, 44, 48, 48, 48, 46, 48, 48, 41 },
        { 40, 36, 49, 49, 44, 48, 48, 48, 44, 48, 48, 48, 46, 48, 48, 41 },
        { 40, 36, 49, 49, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 48, 48, 41 },
        { 40, 36, 49, 44, 49, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 48, 48, 41 },
        { 36, 50, 46, 48, 48 },
        { 36, 50, 48, 46, 48, 48 },
        { 36, 50, 48, 48, 46, 48, 48 },
        { 36, 50, 44, 48, 48, 48, 46, 48, 48 },
        { 36, 50, 48, 44, 48, 48, 48, 46, 48, 48 },
        { 36, 50, 48, 48, 44, 48, 48, 48, 46, 48, 48 },
        { 36, 50, 44, 48, 48, 48, 44, 48, 48, 48, 46, 48, 48 },
        { 36, 50, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 48, 48 },
        { 36, 50, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 48, 48 },
        { 36, 50, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 48, 48 },
        { 40, 36, 50, 46, 48, 48, 41 },
        { 40, 36, 50, 48, 46, 48, 48, 41 },
        { 40, 36, 50, 48, 48, 46, 48, 48, 41 },
        { 40, 36, 50, 44, 48, 48, 48, 46, 48, 48, 41 },
        { 40, 36, 50, 48, 44, 48, 48, 48, 46, 48, 48, 41 },
        { 40, 36, 50, 48, 48, 44, 48, 48, 48, 46, 48, 48, 41 },
        { 40, 36, 50, 44, 48, 48, 48, 44, 48, 48, 48, 46, 48, 48, 41 },
        { 40, 36, 50, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 48, 48, 41 },
        { 40, 36, 50, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 48, 48, 41 },
        { 40, 36, 50, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 48, 48, 41 },
        { 36, 49, 48, 46, 48, 48 },
        { 36, 49, 48, 48, 46, 48, 48 },
        { 36, 49, 44, 48, 48, 48, 46, 48, 48 },
        { 36, 49, 48, 44, 48, 48, 48, 46, 48, 48 },
        { 36, 49, 48, 48, 44, 48, 48, 48, 46, 48, 48 },
        { 36, 49, 44, 48, 48, 48, 44, 48, 48, 48, 46, 48, 48 },
        { 36, 49, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 48, 48 },
        { 36, 49, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 48, 48 },
        { 36, 49, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 48, 48 },
        { 36, 57, 46, 57, 57 },
        { 36, 57, 57, 46, 57, 57 },
        { 36, 57, 57, 57, 46, 57, 57 },
        { 36, 57, 44, 57, 57, 57, 46, 57, 57 },
        { 36, 57, 57, 44, 57, 57, 57, 46, 57, 57 },
        { 36, 57, 57, 57, 44, 57, 57, 57, 46, 57, 57 },
        { 36, 57, 44, 57, 57, 57, 44, 57, 57, 57, 46, 57, 57 },
        { 36, 57, 57, 44, 57, 57, 57, 44, 57, 57, 57, 46, 57, 57 },
        { 36, 57, 57, 57, 44, 57, 57, 57, 44, 57, 57, 57, 46, 57, 57 },
        { 40, 36, 49, 48, 46, 48, 48, 41 },
        { 40, 36, 49, 48, 48, 46, 48, 48, 41 },
        { 40, 36, 49, 44, 48, 48, 48, 46, 48, 48, 41 },
        { 40, 36, 49, 48, 44, 48, 48, 48, 46, 48, 48, 41 },
        { 40, 36, 49, 48, 48, 44, 48, 48, 48, 46, 48, 48, 41 },
        { 40, 36, 49, 44, 48, 48, 48, 44, 48, 48, 48, 46, 48, 48, 41 },
        { 40, 36, 49, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 48, 48, 41 },
        { 40, 36, 49, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 48, 48, 41 },
        { 40, 36, 49, 44, 48, 48, 48, 44, 48, 48, 48, 44, 48, 48, 48, 46, 48, 48, 41 },
        { 40, 36, 57, 46, 57, 57, 41 },
        { 40, 36, 57, 57, 46, 57, 57, 41 },
        { 40, 36, 57, 57, 57, 46, 57, 57, 41 },
        { 40, 36, 57, 44, 57, 57, 57, 46, 57, 57, 41 },
        { 40, 36, 57, 57, 44, 57, 57, 57, 46, 57, 57, 41 },
        { 40, 36, 57, 57, 57, 44, 57, 57, 57, 46, 57, 57, 41 },
        { 40, 36, 57, 44, 57, 57, 57, 44, 57, 57, 57, 46, 57, 57, 41 },
        { 40, 36, 57, 57, 44, 57, 57, 57, 44, 57, 57, 57, 46, 57, 57, 41 },
        { 40, 36, 57, 57, 57, 44, 57, 57, 57, 44, 57, 57, 57, 46, 57, 57, 41 },
        { 36, 49, 46, 48, 48 },
        { 36, 49, 50, 46, 48, 48 },
        { 36, 49, 50, 51, 46, 48, 48 },
        { 36, 49, 44, 50, 51, 52, 46, 48, 48 },
        { 36, 49, 50, 44, 51, 52, 53, 46, 48, 48 },
        { 36, 49, 50, 51, 44, 52, 53, 54, 46, 48, 48 },
        { 36, 49, 44, 50, 51, 52, 44, 53, 54, 55, 46, 48, 48 },
        { 36, 49, 50, 44, 51, 52, 53, 44, 54, 55, 56, 46, 48, 48 },
        { 36, 49, 50, 51, 44, 52, 53, 54, 44, 55, 56, 57, 46, 48, 48 },
        { 36, 49, 44, 50, 51, 52, 44, 53, 54, 55, 44, 56, 57, 48, 46, 48, 48 },
        { 40, 36, 49, 46, 48, 48, 41 },
        { 40, 36, 49, 50, 46, 48, 48, 41 },
        { 40, 36, 49, 50, 51, 46, 48, 48, 41 },
        { 40, 36, 49, 44, 50, 51, 52, 46, 48, 48, 41 },
        { 40, 36, 49, 50, 44, 51, 52, 53, 46, 48, 48, 41 },
        { 40, 36, 49, 50, 51, 44, 52, 53, 54, 46, 48, 48, 41 },
        { 40, 36, 49, 44, 50, 51, 52, 44, 53, 54, 55, 46, 48, 48, 41 },
        { 40, 36, 49, 50, 44, 51, 52, 53, 44, 54, 55, 56, 46, 48, 48, 41 },
        { 40, 36, 49, 50, 51, 44, 52, 53, 54, 44, 55, 56, 57, 46, 48, 48, 41 },
        { 40, 36, 49, 44, 50, 51, 52, 44, 53, 54, 55, 44, 56, 57, 48, 46, 48, 48, 41 },
        { 40, 36, 50, 44, 53, 57, 57, 46, 52, 48, 41 },
        { 40, 36, 50, 44, 53, 57, 57, 46, 51, 52, 41 },
        { 40, 36, 50, 44, 53, 57, 57, 46, 51, 51, 41 },
        { 36, 49, 46, 48, 48 },
        { 36, 49, 46, 48, 48 },
        { 36, 49, 46, 48, 48 },
        { 36, 49, 46, 48, 48 },
        { 36, 49, 46, 48, 48 },
        { 36, 49, 46, 48, 49 },
        { 36, 49, 46, 48, 49 },
        { 36, 49, 46, 48, 49 },
        { 36, 49, 46, 48, 49 },
        { 36, 49, 46, 48, 49 },
        { 36, 49, 46, 50, 50 },
        { 36, 49, 46, 50, 50 },
        { 36, 49, 46, 50, 50 },
        { 36, 49, 46, 50, 50 },
        { 36, 49, 46, 50, 50 },
        { 36, 49, 46, 50, 50 },
        { 36, 49, 46, 50, 50 },
        { 36, 49, 46, 50, 50 },
        { 36, 49, 46, 50, 50 },
        { 36, 49, 46, 50, 50 },
        { 36, 49, 46, 50, 50 },
        { 36, 49, 46, 50, 50 },
        { 36, 49, 46, 50, 50 },
        { 36, 49, 46, 50, 50 },
        { 36, 49, 46, 50, 50 },
        { 36, 49, 46, 50, 50 },
        { 36, 49, 46, 50, 50 },
        { 36, 49, 46, 50, 50 },
        { 36, 49, 46, 50, 50 },
        { 36, 49, 46, 50, 50 },
        { 36, 49, 46, 50, 51 },
        { 36, 49, 46, 50, 51 },
        { 36, 49, 46, 50, 51 },
        { 36, 49, 46, 50, 51 },
        { 36, 49, 46, 50, 51 },
        { 36, 49, 46, 50, 51 },
        { 36, 49, 46, 50, 51 },
        { 36, 49, 46, 50, 51 },
        { 36, 49, 46, 50, 51 },
        { 36, 49, 46, 50, 51 },
        { 36, 49, 46, 50, 51 },
        { 36, 49, 46, 50, 51 },
        { 36, 49, 46, 50, 51 },
        { 36, 49, 46, 50, 51 },
        { 36, 49, 46, 50, 51 },
        { 36, 49, 46, 50, 51 },
        { 36, 49, 46, 50, 51 },
        { 36, 49, 46, 50, 51 },
        { 36, 49, 46, 50, 51 },
        { 36, 49, 46, 50, 51 },
        { 36, 49, 44, 48, 48, 57, 44, 49, 51, 54, 46, 55, 49 },
        { 36, 50, 44, 53, 49, 56, 44, 52, 54, 51, 46, 52, 54 },
        { 36, 50, 44, 53, 51, 50, 44, 52, 51, 56, 46, 56, 51 },
        { 36, 51, 44, 54, 53, 48, 44, 52, 53, 56, 46, 53, 51 },
        { 36, 51, 44, 49, 52, 55, 44, 51, 52, 57, 46, 54, 50 },
        { 36, 53, 44, 52, 49, 49, 44, 51, 51, 57, 46, 55, 53 },
        { 36, 56, 44, 53, 56, 51, 44, 55, 50, 49, 46, 50, 50 },
        { 36, 49, 51, 44, 52, 55, 53, 44, 48, 53, 55, 46, 56, 50 },
        { 36, 51, 51, 44, 53, 56, 56, 44, 52, 52, 49, 46, 57, 56 },
        { 36, 57, 57, 44, 57, 55, 57, 44, 55, 57, 52, 46, 48, 56 },
        { 36, 57, 57, 44, 57, 51, 55, 44, 52, 51, 49, 46, 53, 56 },
        { 36, 57, 57, 44, 51, 56, 54, 44, 55, 49, 57, 46, 48, 56 },
        { 36, 51, 51, 44, 56, 53, 51, 44, 48, 50, 53, 46, 52, 55 },
        { 36, 51, 52, 44, 48, 52, 54, 44, 52, 50, 54, 46, 54, 48 },
        { 36, 51, 52, 44, 51, 49, 50, 44, 56, 48, 48, 46, 56, 55 },
        { 36, 51, 52, 44, 51, 56, 55, 44, 53, 54, 52, 46, 55, 53 },
        { 36, 51, 52, 44, 52, 54, 48, 44, 53, 51, 55, 46, 56, 55 },
        { 36, 51, 52, 44, 53, 55, 57, 44, 49, 55, 53, 46, 49, 50 },
        { 36, 51, 52, 44, 54, 53, 51, 44, 57, 51, 57, 46, 48, 50 },
        { 36, 51, 52, 44, 56, 52, 55, 44, 51, 52, 48, 46, 49, 53 },
        { 36, 51, 52, 44, 57, 50, 48, 44, 51, 49, 51, 46, 50, 55 },
        { 36, 51, 53, 44, 48, 51, 56, 44, 57, 53, 48, 46, 53, 50 },
        { 36, 51, 53, 44, 49, 49, 51, 44, 55, 49, 52, 46, 52, 49 },
        { 36, 51, 53, 44, 49, 56, 54, 44, 54, 56, 55, 46, 53, 51 },
        { 36, 51, 53, 44, 51, 48, 53, 44, 51, 50, 52, 46, 55, 56 },
        { 36, 51, 53, 44, 51, 56, 48, 44, 48, 56, 56, 46, 54, 55 },
        { 36, 51, 53, 44, 52, 53, 51, 44, 48, 54, 49, 46, 55, 57 },
        { 36, 51, 53, 44, 53, 55, 49, 44, 54, 57, 57, 46, 48, 53 },
        { 36, 51, 53, 44, 53, 55, 51, 44, 52, 56, 57, 46, 56, 49 },
        { 36, 51, 53, 44, 54, 52, 54, 44, 52, 54, 50, 46, 57, 51 },
        { 36, 51, 53, 44, 56, 51, 57, 44, 56, 54, 52, 46, 48, 55 },
        { 36, 51, 53, 44, 57, 49, 50, 44, 56, 51, 55, 46, 50, 48 },
        { 36, 51, 54, 44, 48, 51, 49, 44, 52, 55, 52, 46, 52, 53 },
        { 36, 51, 54, 44, 49, 48, 54, 44, 50, 51, 56, 46, 51, 51 },
        { 36, 51, 54, 44, 49, 55, 57, 44, 50, 49, 49, 46, 52, 53 },
        { 36, 51, 54, 44, 50, 57, 55, 44, 56, 52, 56, 46, 55, 48 },
        { 36, 51, 54, 44, 51, 55, 50, 44, 54, 49, 50, 46, 53, 57 },
        { 36, 51, 54, 44, 53, 54, 52, 44, 50, 50, 50, 46, 57, 55 },
        { 36, 51, 54, 44, 53, 54, 54, 44, 48, 49, 51, 46, 55, 51 },
        { 36, 51, 54, 44, 54, 51, 56, 44, 57, 56, 54, 46, 56, 53 },
        { 36, 51, 54, 44, 55, 53, 55, 44, 54, 50, 52, 46, 49, 48 },
        { 36, 51, 54, 44, 56, 51, 50, 44, 51, 56, 55, 46, 57, 57 },
        { 36, 51, 54, 44, 57, 48, 53, 44, 51, 54, 49, 46, 49, 49 },
        { 36, 51, 55, 44, 48, 50, 51, 44, 57, 57, 56, 46, 51, 55 },
        { 36, 51, 55, 44, 48, 57, 56, 44, 55, 54, 50, 46, 50, 53 },
        { 36, 51, 55, 44, 49, 55, 49, 44, 55, 51, 53, 46, 51, 55 },
        { 36, 51, 55, 44, 50, 57, 48, 44, 51, 55, 50, 46, 54, 50 },
        { 36, 51, 55, 44, 51, 54, 53, 44, 49, 51, 54, 46, 53, 50 },
        { 36, 51, 55, 44, 53, 53, 56, 44, 53, 51, 55, 46, 54, 53 },
        { 36, 51, 55, 44, 54, 51, 49, 44, 53, 49, 48, 46, 55, 55 },
        { 36, 51, 55, 44, 55, 53, 48, 44, 49, 52, 56, 46, 48, 50 },
        { 36, 51, 55, 44, 56, 50, 52, 44, 57, 49, 49, 46, 57, 49 },
        { 36, 51, 55, 44, 56, 57, 55, 44, 56, 56, 53, 46, 48, 51 },
        { 36, 51, 56, 44, 48, 49, 54, 44, 53, 50, 50, 46, 50, 56 },
        { 36, 51, 56, 44, 48, 57, 49, 44, 50, 56, 54, 46, 49, 55 },
        { 36, 51, 56, 44, 49, 54, 52, 44, 50, 53, 57, 46, 50, 57 },
        { 36, 51, 56, 44, 50, 56, 50, 44, 56, 57, 54, 46, 53, 53 },
        { 36, 51, 56, 44, 50, 56, 52, 44, 54, 56, 55, 46, 51, 49 },
        { 36, 51, 56, 44, 51, 53, 55, 44, 54, 54, 48, 46, 52, 51 },
        { 36, 51, 56, 44, 53, 53, 49, 44, 48, 54, 49, 46, 53, 55 },
        { 36, 51, 56, 44, 54, 50, 52, 44, 48, 51, 52, 46, 55, 48 },
        { 36, 51, 56, 44, 55, 52, 50, 44, 54, 55, 49, 46, 57, 53 },
        { 36, 51, 56, 44, 56, 49, 55, 44, 52, 51, 53, 46, 56, 51 },
        { 36, 51, 56, 44, 56, 57, 48, 44, 52, 48, 56, 46, 57, 53 },
        { 36, 51, 57, 44, 48, 48, 57, 44, 48, 52, 54, 46, 50, 48 },
        { 36, 51, 57, 44, 48, 56, 51, 44, 56, 49, 48, 46, 48, 57 },
        { 36, 51, 57, 44, 50, 55, 53, 44, 52, 50, 48, 46, 52, 55 },
        { 36, 51, 57, 44, 50, 55, 55, 44, 50, 49, 49, 46, 50, 51 },
        { 36, 51, 57, 44, 51, 53, 48, 44, 49, 56, 52, 46, 51, 53 },
        { 36, 51, 57, 44, 52, 54, 56, 44, 56, 50, 49, 46, 54, 48 },
        { 36, 51, 57, 44, 53, 52, 51, 44, 53, 56, 53, 46, 52, 57 },
        { 36, 51, 57, 44, 54, 49, 54, 44, 53, 53, 56, 46, 54, 49 },
        { 36, 51, 57, 44, 55, 51, 53, 44, 49, 57, 53, 46, 56, 55 },
        { 36, 51, 57, 44, 56, 48, 57, 44, 57, 53, 57, 46, 55, 53 },
        { 36, 51, 57, 44, 56, 56, 50, 44, 57, 51, 50, 46, 56, 55 },
        { 36, 52, 48, 44, 48, 48, 49, 44, 53, 55, 48, 46, 49, 50 },
        { 36, 52, 48, 44, 48, 55, 54, 44, 51, 51, 52, 46, 48, 50 },
        { 36, 52, 48, 44, 50, 54, 57, 44, 55, 51, 53, 46, 49, 53 },
        { 36, 52, 48, 44, 51, 52, 50, 44, 55, 48, 56, 46, 50, 55 },
        { 36, 52, 48, 44, 52, 54, 49, 44, 51, 52, 53, 46, 53, 50 },
        { 36, 52, 48, 44, 53, 51, 54, 44, 49, 48, 57, 46, 52, 49 },
        { 36, 52, 48, 44, 54, 48, 57, 44, 48, 56, 50, 46, 53, 51 },
        { 36, 52, 48, 44, 55, 50, 55, 44, 55, 49, 57, 46, 55, 56 },
        { 36, 52, 48, 44, 56, 48, 50, 44, 52, 56, 51, 46, 54, 55 },
        { 36, 52, 48, 44, 56, 55, 53, 44, 52, 53, 54, 46, 55, 57 },
        { 36, 52, 48, 44, 57, 57, 52, 44, 48, 57, 52, 46, 48, 53 },
        { 36, 52, 48, 44, 57, 57, 53, 44, 56, 56, 52, 46, 56, 49 },
        { 36, 52, 49, 44, 48, 54, 56, 44, 56, 53, 55, 46, 57, 51 },
        { 36, 52, 49, 44, 50, 54, 50, 44, 50, 53, 57, 46, 48, 55 },
        { 36, 52, 49, 44, 51, 51, 53, 44, 50, 51, 50, 46, 50, 48 },
        { 36, 52, 49, 44, 52, 53, 51, 44, 56, 54, 57, 46, 52, 53 },
        { 36, 52, 49, 44, 53, 50, 56, 44, 54, 51, 51, 46, 51, 51 },
        { 36, 52, 49, 44, 54, 48, 49, 44, 54, 48, 54, 46, 52, 53 },
        { 36, 52, 49, 44, 55, 50, 48, 44, 50, 52, 51, 46, 55, 48 },
        { 36, 52, 49, 44, 55, 57, 53, 44, 48, 48, 55, 46, 53, 57 },
        { 36, 52, 49, 44, 57, 56, 54, 44, 54, 49, 55, 46, 57, 55 },
        { 36, 52, 50, 44, 48, 51, 52, 44, 48, 55, 50, 46, 56, 55 },
        { 36, 52, 50, 44, 49, 48, 55, 44, 48, 52, 53, 46, 57, 56 },
        { 36, 52, 50, 44, 49, 51, 52, 44, 51, 53, 52, 46, 57, 56 },
    };

}
