/****************************************************************************
 ControlList.h

 Description:	Lynx Application Programming Interface Header File

 Created: David A. Hoatson, June 2003
	
 Copyright  2003 Lynx Studio Technology, Inc.

 This software contains the valuable TRADE SECRETS and CONFIDENTIAL INFORMATION 
 of Lynx Studio Technology, Inc. The software is protected under copyright 
 laws as an unpublished work of Lynx Studio Technology, Inc.  Notice is 
 for informational purposes only and does not imply publication.  The user 
 of this software may make copies of the software for use with products 
 manufactured by Lynx Studio Technology, Inc. or under license from 
 Lynx Studio Technology, Inc. and for no other use.

 THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
 KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
 PURPOSE.

 Environment: 

 4 spaces per tab

 Revision History
 
 When      Who  Description
 --------- ---  ------------------------------------------------------------
****************************************************************************/

#ifndef _CONTROLLIST_H
#define _CONTROLLIST_H

/////////////////////////////////////////////////////////////////////////////
//      Mixer Line Types
/////////////////////////////////////////////////////////////////////////////
enum
{
  LINE_OUT_1 = 0,
  LINE_OUT_2 = 1,
  LINE_OUT_3 = 2,
  LINE_OUT_4 = 3,
  LINE_OUT_5 = 4,
  LINE_OUT_6 = 5,
  LINE_OUT_7 = 6,
  LINE_OUT_8 = 7,
  LINE_OUT_9 = 8,
  LINE_OUT_10 = 9,
  LINE_OUT_11 = 10,
  LINE_OUT_12 = 11,
  LINE_OUT_13 = 12,
  LINE_OUT_14 = 13,
  LINE_OUT_15 = 14,
  LINE_OUT_16 = 15,
  LINE_OUT_17 = 16,
  LINE_OUT_18 = 17,
  LINE_OUT_19 = 18,
  LINE_OUT_20 = 19,
  LINE_OUT_21 = 20,
  LINE_OUT_22 = 21,
  LINE_OUT_23 = 22,
  LINE_OUT_24 = 23,
  LINE_OUT_25 = 24,
  LINE_OUT_26 = 25,
  LINE_OUT_27 = 26,
  LINE_OUT_28 = 27,
  LINE_OUT_29 = 28,
  LINE_OUT_30 = 29,
  LINE_OUT_31 = 30,
  LINE_OUT_32 = 31,
  LINE_RECORD_0 = 32,
  LINE_RECORD_1 = 33,
  LINE_RECORD_2 = 34,
  LINE_RECORD_3 = 35,
  LINE_RECORD_4 = 36,
  LINE_RECORD_5 = 37,
  LINE_RECORD_6 = 38,
  LINE_RECORD_7 = 39,
  LINE_RECORD_8 = 40,
  LINE_RECORD_9 = 41,
  LINE_RECORD_10 = 42,
  LINE_RECORD_11 = 43,
  LINE_RECORD_12 = 44,
  LINE_RECORD_13 = 45,
  LINE_RECORD_14 = 46,
  LINE_RECORD_15 = 47,
  LINE_ADAPTER = 48,
  LINE_LSTREAM = 49,
  LINE_AURORA = 50,
  LINE_NO_SOURCE = 51,
  LINE_SRC_RECORD_0 = 52,
  LINE_SRC_RECORD_1 = 53,
  LINE_SRC_RECORD_2 = 54,
  LINE_SRC_RECORD_3 = 55,
  LINE_SRC_RECORD_4 = 56,
  LINE_SRC_RECORD_5 = 57,
  LINE_SRC_RECORD_6 = 58,
  LINE_SRC_RECORD_7 = 59,
  LINE_SRC_RECORD_8 = 60,
  LINE_SRC_RECORD_9 = 61,
  LINE_SRC_RECORD_10 = 62,
  LINE_SRC_RECORD_11 = 63,
  LINE_SRC_RECORD_12 = 64,
  LINE_SRC_RECORD_13 = 65,
  LINE_SRC_RECORD_14 = 66,
  LINE_SRC_RECORD_15 = 67,
  LINE_SRC_PLAY_0 = 68,
  LINE_SRC_PLAY_1 = 69,
  LINE_SRC_PLAY_2 = 70,
  LINE_SRC_PLAY_3 = 71,
  LINE_SRC_PLAY_4 = 72,
  LINE_SRC_PLAY_5 = 73,
  LINE_SRC_PLAY_6 = 74,
  LINE_SRC_PLAY_7 = 75,
  LINE_SRC_PLAY_8 = 76,
  LINE_SRC_PLAY_9 = 77,
  LINE_SRC_PLAY_10 = 78,
  LINE_SRC_PLAY_11 = 79,
  LINE_SRC_PLAY_12 = 80,
  LINE_SRC_PLAY_13 = 81,
  LINE_SRC_PLAY_14 = 82,
  LINE_SRC_PLAY_15 = 83,
  LINE_PLAY_0 = 84,
  LINE_PLAY_1 = 85,
  LINE_PLAY_2 = 86,
  LINE_PLAY_3 = 87,
  LINE_PLAY_4 = 88,
  LINE_PLAY_5 = 89,
  LINE_PLAY_6 = 90,
  LINE_PLAY_7 = 91,
  LINE_PLAY_8 = 92,
  LINE_PLAY_9 = 93,
  LINE_PLAY_10 = 94,
  LINE_PLAY_11 = 95,
  LINE_PLAY_12 = 96,
  LINE_PLAY_13 = 97,
  LINE_PLAY_14 = 98,
  LINE_PLAY_15 = 99,
  LINE_PLAYMIX_1 = 100,
  LINE_PLAYMIX_2 = 101,
  LINE_PLAYMIX_3 = 102,
  LINE_PLAYMIX_4 = 103,
  LINE_PLAYMIX_5 = 104,
  LINE_PLAYMIX_6 = 105,
  LINE_PLAYMIX_7 = 106,
  LINE_PLAYMIX_8 = 107,
  LINE_PLAYMIX_9 = 108,
  LINE_PLAYMIX_10 = 109,
  LINE_PLAYMIX_11 = 110,
  LINE_PLAYMIX_12 = 111,
  LINE_PLAYMIX_13 = 112,
  LINE_PLAYMIX_14 = 113,
  LINE_PLAYMIX_15 = 114,
  LINE_PLAYMIX_16 = 115,
  LINE_PLAYMIX_17 = 116,
  LINE_PLAYMIX_18 = 117,
  LINE_PLAYMIX_19 = 118,
  LINE_PLAYMIX_20 = 119,
  LINE_PLAYMIX_21 = 120,
  LINE_PLAYMIX_22 = 121,
  LINE_ANALOGIN_1 = 122,
  LINE_ANALOGIN_2 = 123,
  LINE_ANALOGIN_3 = 124,
  LINE_ANALOGIN_4 = 125,
  LINE_ANALOGIN_5 = 126,
  LINE_ANALOGIN_6 = 127,
  LINE_ANALOGIN_7 = 128,
  LINE_ANALOGIN_8 = 129,
  LINE_ANALOGIN_9 = 130,
  LINE_ANALOGIN_10 = 131,
  LINE_ANALOGIN_11 = 132,
  LINE_ANALOGIN_12 = 133,
  LINE_ANALOGIN_13 = 134,
  LINE_ANALOGIN_14 = 135,
  LINE_ANALOGIN_15 = 136,
  LINE_ANALOGIN_16 = 137,
  LINE_DIGITALIN_1 = 138,
  LINE_DIGITALIN_2 = 139,
  LINE_DIGITALIN_3 = 140,
  LINE_DIGITALIN_4 = 141,
  LINE_DIGITALIN_5 = 142,
  LINE_DIGITALIN_6 = 143,
  LINE_DIGITALIN_7 = 144,
  LINE_DIGITALIN_8 = 145,
  LINE_DIGITALIN_9 = 146,
  LINE_DIGITALIN_10 = 147,
  LINE_DIGITALIN_11 = 148,
  LINE_DIGITALIN_12 = 149,
  LINE_DIGITALIN_13 = 150,
  LINE_DIGITALIN_14 = 151,
  LINE_DIGITALIN_15 = 152,
  LINE_DIGITALIN_16 = 153,
  LINE_ANALOGOUT_1 = 154,
  LINE_ANALOGOUT_2 = 155,
  LINE_ANALOGOUT_3 = 156,
  LINE_ANALOGOUT_4 = 157,
  LINE_ANALOGOUT_5 = 158,
  LINE_ANALOGOUT_6 = 159,
  LINE_ANALOGOUT_7 = 160,
  LINE_ANALOGOUT_8 = 161,
  LINE_ANALOGOUT_9 = 162,
  LINE_ANALOGOUT_10 = 163,
  LINE_ANALOGOUT_11 = 164,
  LINE_ANALOGOUT_12 = 165,
  LINE_ANALOGOUT_13 = 166,
  LINE_ANALOGOUT_14 = 167,
  LINE_ANALOGOUT_15 = 168,
  LINE_ANALOGOUT_16 = 169,
  LINE_DIGITALOUT_1 = 170,
  LINE_DIGITALOUT_2 = 171,
  LINE_DIGITALOUT_3 = 172,
  LINE_DIGITALOUT_4 = 173,
  LINE_DIGITALOUT_5 = 174,
  LINE_DIGITALOUT_6 = 175,
  LINE_DIGITALOUT_7 = 176,
  LINE_DIGITALOUT_8 = 177,
  LINE_DIGITALOUT_9 = 178,
  LINE_DIGITALOUT_10 = 179,
  LINE_DIGITALOUT_11 = 180,
  LINE_DIGITALOUT_12 = 181,
  LINE_DIGITALOUT_13 = 182,
  LINE_DIGITALOUT_14 = 183,
  LINE_DIGITALOUT_15 = 184,
  LINE_DIGITALOUT_16 = 185
};

/////////////////////////////////////////////////////////////////////////////
//      Mixer Control Types
/////////////////////////////////////////////////////////////////////////////
enum
{
  CONTROL_NUMCHANNELS = 0,	// the number of channels this line has
  CONTROL_SOURCE,		// MUX
  CONTROL_SOURCE_LEFT,		// MUX
  CONTROL_SOURCE_RIGHT,		// MUX
  CONTROL_OVERLOAD,		// ULONG
  CONTROL_PEAKMETER,		// ULONG METER
  CONTROL_VOLUME,		// ULONG VOLUME
  CONTROL_MUTE,			// BOOLEAN MUTE
  CONTROL_DITHER,		// BOOLEAN
  CONTROL_MONITOR,		// BOOLEAN
  CONTROL_PHASE,		// BOOLEAN
  CONTROL_DITHER_DEPTH,		// MUX
  CONTROL_OVERRUN_COUNT,	// ULONG
  CONTROL_SAMPLE_COUNT,		// ULONG
  CONTROL_SAMPLE_FORMAT,	// ULONG
  CONTROL_INPUT_SOURCE,		// MUX
  CONTROL_CLOCKSOURCE,		// MUX
  CONTROL_CLOCKRATE,		// ULONG
  CONTROL_CLOCKRATE_SELECT,	// ULONG
  CONTROL_CLOCKRATE_LOCK,	// BOOLEAN
  CONTROL_WIDEWIREIN,		// BOOLEAN
  CONTROL_WIDEWIREOUT,		// BOOLEAN
  CONTROL_SYNCHROLOCK_STATUS,	// ULONG
  CONTROL_AUTOCLOCKSELECT,	// BOOLEAN
  CONTROL_CLOCKSOURCE_PREFERRED,	// MUX
  CONTROL_FREQUENCY_COUNTER_1,	// ULONG
  CONTROL_FREQUENCY_COUNTER_2,	// ULONG
  CONTROL_FREQUENCY_COUNTER_3,	// ULONG
  CONTROL_FREQUENCY_COUNTER_4,	// ULONG
  CONTROL_FREQUENCY_COUNTER_5,	// ULONG
  CONTROL_FREQUENCY_COUNTER_6,	// ULONG
  CONTROL_FREQUENCY_COUNTER_7,	// ULONG
  CONTROL_FREQUENCY_COUNTER_8,	// ULONG
  CONTROL_FREQUENCY_COUNTER_9,	// ULONG
  CONTROL_FREQUENCY_COUNTER_10,	// ULONG
  CONTROL_FREQUENCY_COUNTER_11,	// ULONG
  CONTROL_FREQUENCY_COUNTER_12,	// ULONG
  CONTROL_FREQUENCY_COUNTER_13,	// ULONG
  CONTROL_FREQUENCY_COUNTER_14,	// ULONG
  CONTROL_FREQUENCY_COUNTER_15,	// ULONG
  CONTROL_FREQUENCY_COUNTER_16,	// ULONG
  CONTROL_AES50_STATUS,		// ULONG
  CONTROL_DIGITAL_FORMAT,	// MUX
  CONTROL_SRC_MODE,		// MUX
  CONTROL_SRC_RATIO,		// ULONG
  CONTROL_DIGITALIN_RATE,	// ULONG
  CONTROL_DIGITALIN_MUTE_ON_ERROR,	// BOOLEAN
  CONTROL_DIGITALIN_STATUS,	// ULONG
  CONTROL_DIGITALOUT_STATUS,	// ULONG
  CONTROL_TRIM,			// MUX
  CONTROL_MONITOR_SOURCE,	// MUX
  CONTROL_LEVELS,		// BOOLEAN
  CONTROL_AIN12_TRIM,		// MUX
  CONTROL_AIN34_TRIM,		// MUX
  CONTROL_AIN56_TRIM,		// MUX
  CONTROL_AOUT12_TRIM,		// MUX
  CONTROL_AOUT34_TRIM,		// MUX
  CONTROL_AOUT56_TRIM,		// MUX
  CONTROL_SYNCIN_NTSC,		// BOOLEAN
  CONTROL_DIGITALIN1_STATUS,	// ULONG
  CONTROL_DIGITALIN1_RATE,	// ULONG
  CONTROL_DIO1_SRC_MODE,	// MUX
  CONTROL_DIO1_SRC_RATIO,	// ULONG
  CONTROL_DIGITALIN2_STATUS,	// ULONG
  CONTROL_DIGITALIN2_RATE,	// ULONG
  CONTROL_DIO2_SRC_MODE,	// MUX
  CONTROL_DIO2_SRC_RATIO,	// ULONG
  CONTROL_DIGITALIN3_STATUS,	// ULONG
  CONTROL_DIGITALIN3_RATE,	// ULONG
  CONTROL_DIO3_SRC_MODE,	// MUX
  CONTROL_DIO3_SRC_RATIO,	// ULONG
  CONTROL_DIGITALIN4_STATUS,	// ULONG
  CONTROL_DIGITALIN4_RATE,	// ULONG
  CONTROL_DIO4_SRC_MODE,	// MUX
  CONTROL_DIO4_SRC_RATIO,	// ULONG
  CONTROL_DIGITALIN5_STATUS,	// ULONG
  CONTROL_DIGITALIN5_RATE,	// ULONG
  CONTROL_DIGITALIN5_SRC_ENABLE,	// BOOLEAN
  CONTROL_DIGITALIN5_SRC_RATIO,	// ULONG
  CONTROL_DIO5_SRC_MODE,	// MUX
  CONTROL_DIO5_SRC_RATIO,	// ULONG
  CONTROL_DIGITALIN6_STATUS,	// ULONG
  CONTROL_DIGITALIN6_RATE,	// ULONG
  CONTROL_DIGITALIN6_SRC_ENABLE,	// BOOLEAN
  CONTROL_DIGITALIN6_SRC_RATIO,	// ULONG
  CONTROL_DIO6_SRC_MODE,	// MUX
  CONTROL_DIO6_SRC_RATIO,	// ULONG
  CONTROL_DIGITALIN7_STATUS,	// ULONG
  CONTROL_DIGITALIN7_RATE,	// ULONG
  CONTROL_DIGITALIN7_SRC_ENABLE,	// BOOLEAN
  CONTROL_DIGITALIN7_SRC_RATIO,	// ULONG
  CONTROL_DIO7_SRC_MODE,	// MUX
  CONTROL_DIO7_SRC_RATIO,	// ULONG
  CONTROL_DIGITALIN8_STATUS,	// ULONG
  CONTROL_DIGITALIN8_RATE,	// ULONG
  CONTROL_DIGITALIN8_SRC_ENABLE,	// BOOLEAN
  CONTROL_DIGITALIN8_SRC_RATIO,	// ULONG
  CONTROL_DIO8_SRC_MODE,	// MUX
  CONTROL_DIO8_SRC_RATIO,	// ULONG
  CONTROL_DIGITALOUT1_STATUS,	// ULONG
  CONTROL_DIGITALOUT2_STATUS,	// ULONG
  CONTROL_DIGITALOUT3_STATUS,	// ULONG
  CONTROL_DIGITALOUT4_STATUS,	// ULONG
  CONTROL_DIGITALOUT5_STATUS,	// ULONG
  CONTROL_DIGITALOUT6_STATUS,	// ULONG
  CONTROL_DIGITALOUT7_STATUS,	// ULONG
  CONTROL_DIGITALOUT8_STATUS,	// ULONG
  CONTROL_LTCIN_LOCKED,		// BOOLEAN
  CONTROL_LTCIN_DIRECTION,	// BOOLEAN
  CONTROL_LTCIN_DROPFRAME,	// BOOLEAN
  CONTROL_LTCIN_FRAMERATE,	// ULONG
  CONTROL_LTCIN_POSITION,	// ULONG
  CONTROL_LTCOUT_ENABLE,	// BOOLEAN
  CONTROL_LTCOUT_FRAMERATE,	// MUX
  CONTROL_LTCOUT_DROPFRAME,	// BOOLEAN
  CONTROL_LTCOUT_SYNCSOURCE,	// MUX
  CONTROL_LTCOUT_POSITION,	// ULONG
  CONTROL_LS1_DEVICEID,		// ULONG
  CONTROL_LS1_PCBREV,		// ULONG
  CONTROL_LS1_FIRMWAREREV,	// ULONG
  CONTROL_LS1_OUTSEL,		// MUX
  CONTROL_LS1_LTMODE,		// ULONG
  CONTROL_LS1_ADAT_CLKSRC,	// MUX
  CONTROL_LS1_ADAT_IN1_LOCK,	// BOOLEAN
  CONTROL_LS1_ADAT_IN2_LOCK,	// BOOLEAN
  CONTROL_LS1_ADAT_POSITION,	// ULONG
  CONTROL_LS1_ADAT_CUEPOINT_ENABLE,	// BOOLEAN
  CONTROL_LS1_ADAT_CUEPOINT,	// ULONG
  CONTROL_LS1_AES_CLKSRC,	// MUX
  CONTROL_LS1_AES_WIDEWIRE,	// BOOLEAN
  CONTROL_LS1_D1_FORMAT,	// MUX
  CONTROL_LS1_DI1_SRC_MODE,	// MUX
  CONTROL_LS1_DI1_RATE,		// ULONG
  CONTROL_LS1_DI1_SRC_RATIO,	// ULONG
  CONTROL_LS1_DI1_STATUS,	// ULONG
  CONTROL_LS1_DO1_STATUS,	// ULONG
  CONTROL_LS1_D2_FORMAT,	// MUX
  CONTROL_LS1_DI2_SRC_MODE,	// MUX
  CONTROL_LS1_DI2_RATE,		// ULONG
  CONTROL_LS1_DI2_SRC_RATIO,	// ULONG
  CONTROL_LS1_DI2_STATUS,	// ULONG
  CONTROL_LS1_DO2_STATUS,	// ULONG
  CONTROL_LS1_D3_FORMAT,	// MUX
  CONTROL_LS1_DI3_SRC_MODE,	// MUX
  CONTROL_LS1_DI3_RATE,		// ULONG
  CONTROL_LS1_DI3_SRC_RATIO,	// ULONG
  CONTROL_LS1_DI3_STATUS,	// ULONG
  CONTROL_LS1_DO3_STATUS,	// ULONG
  CONTROL_LS1_D4_FORMAT,	// MUX
  CONTROL_LS1_DI4_SRC_MODE,	// MUX
  CONTROL_LS1_DI4_RATE,		// ULONG
  CONTROL_LS1_DI4_SRC_RATIO,	// ULONG
  CONTROL_LS1_DI4_STATUS,	// ULONG
  CONTROL_LS1_DO4_STATUS,	// ULONG
  CONTROL_LS2_DEVICEID,		// ULONG
  CONTROL_LS2_PCBREV,		// ULONG
  CONTROL_LS2_FIRMWAREREV,	// ULONG
  CONTROL_LS2_OUTSEL,		// MUX
  CONTROL_LS2_LTMODE,		// ULONG
  CONTROL_LS2_ADAT_CLKSRC,	// MUX
  CONTROL_LS2_ADAT_IN1_LOCK,	// BOOLEAN
  CONTROL_LS2_ADAT_IN2_LOCK,	// BOOLEAN
  CONTROL_LS2_ADAT_POSITION,	// ULONG
  CONTROL_LS2_ADAT_CUEPOINT_ENABLE,	// BOOLEAN
  CONTROL_LS2_ADAT_CUEPOINT,	// ULONG
  CONTROL_LS2_AES_CLKSRC,	// MUX
  CONTROL_LS2_AES_WIDEWIRE,	// BOOLEAN
  CONTROL_LS2_D1_FORMAT,	// MUX
  CONTROL_LS2_DI1_SRC_MODE,	// MUX
  CONTROL_LS2_DI1_RATE,		// ULONG
  CONTROL_LS2_DI1_SRC_RATIO,	// ULONG
  CONTROL_LS2_DI1_STATUS,	// ULONG
  CONTROL_LS2_DO1_STATUS,	// ULONG
  CONTROL_LS2_D2_FORMAT,	// MUX
  CONTROL_LS2_DI2_SRC_MODE,	// MUX
  CONTROL_LS2_DI2_RATE,		// ULONG
  CONTROL_LS2_DI2_SRC_RATIO,	// ULONG
  CONTROL_LS2_DI2_STATUS,	// ULONG
  CONTROL_LS2_DO2_STATUS,	// ULONG
  CONTROL_LS2_D3_FORMAT,	// MUX
  CONTROL_LS2_DI3_SRC_MODE,	// MUX
  CONTROL_LS2_DI3_RATE,		// ULONG
  CONTROL_LS2_DI3_SRC_RATIO,	// ULONG
  CONTROL_LS2_DI3_STATUS,	// ULONG
  CONTROL_LS2_DO3_STATUS,	// ULONG
  CONTROL_LS2_D4_FORMAT,	// MUX
  CONTROL_LS2_DI4_SRC_MODE,	// MUX
  CONTROL_LS2_DI4_RATE,		// ULONG
  CONTROL_LS2_DI4_SRC_RATIO,	// ULONG
  CONTROL_LS2_DI4_STATUS,	// ULONG
  CONTROL_LS2_DO4_STATUS,	// ULONG
  CONTROL_FP_ANALOGOUT_SOURCE,	// MUX
  CONTROL_FP_DIGITALOUT_SOURCE,	// MUX
  CONTROL_FP_METER_SOURCE,	// MUX
  CONTROL_LSLOT_OUT_SOURCE,	// MUX
  CONTROL_TRIM_ORIGIN,		// MUX
  CONTROL_FP_TRIM,		// MUX
  CONTROL_TRIM_AIN_1_4,		// MUX
  CONTROL_TRIM_AIN_5_8,		// MUX
  CONTROL_TRIM_AIN_9_12,	// MUX
  CONTROL_TRIM_AIN_13_16,	// MUX
  CONTROL_TRIM_AOUT_1_4,	// MUX
  CONTROL_TRIM_AOUT_5_8,	// MUX
  CONTROL_TRIM_AOUT_9_12,	// MUX
  CONTROL_TRIM_AOUT_13_16,	// MUX
  CONTROL_VOLUMEA,		// ULONG
  CONTROL_MUTEA,		// BOOLEAN MUTE
  CONTROL_SOURCEA,		// MUX
  CONTROL_VOLUMEB,		// ULONG
  CONTROL_MUTEB,		// BOOLEAN MUTE
  CONTROL_SOURCEB,		// MUX
  CONTROL_DITHER_TYPE,		// MUX
  CONTROL_PLAY_DITHER,		// MUX
  CONTROL_RECORD_DITHER,	// MUX
  CONTROL_ADDA_RECALIBRATE,	// BOOLEAN
  CONTROL_AD_RECALIBRATE,	// BOOLEAN
  CONTROL_DA_RECALIBRATE,	// BOOLEAN
  CONTROL_AUTO_RECALIBRATE,	// BOOLEAN
  CONTROL_AIN12_HPF,		// BOOLEAN
  CONTROL_AIN34_HPF,		// BOOLEAN
  CONTROL_AIN56_HPF,		// BOOLEAN
  CONTROL_ADHIPASSFILTER,	// BOOLEAN
  CONTROL_DA_AUTOMUTE,		// BOOLEAN
  CONTROL_DA_DEEMPHASIS,	// BOOLEAN
  CONTROL_CLOCK_CHANGE_IF_ACTIVE,	// BOOLEAN
  CONTROL_SYNCHROLOCK_ENABLE,	// BOOLEAN
  CONTROL_DIGITALIN_SRC_MATCHPHASE,	// BOOLEAN
  CONTROL_SYNCSTART,		// BOOLEAN
  CONTROL_MTC_SOURCE,		// MUX
  CONTROL_LSTREAM_DUAL_INTERNAL,	// BOOLEAN
  CONTROL_MRM_ENABLE,		// BOOLEAN
  CONTROL_GPOUT,		// BOOLEAN
  CONTROL_RESET_DIGITALIO_LOCK,	// BOOLEAN
  CONTROL_MONITOR_OFF_PLAY,	// BOOLEAN
  CONTROL_MONITOR_ON_RECORD,	// BOOLEAN
  CONTROL_DEVICEID,		// ULONG
  CONTROL_PCBREV,		// ULONG
  CONTROL_FIRMWAREREV,		// ULONG
  CONTROL_FIRMWAREDATE,		// ULONG
  CONTROL_MINSOFTWAREREV,	// ULONG
  CONTROL_SERIALNUMBER,		// ULONG
  CONTROL_MFGDATE,		// ULONG
  CONTROL_DRVBUFSIZE_1X,	// ULONG
  CONTROL_DRVBUFSIZE_2X,	// ULONG
  CONTROL_DRVBUFSIZE_4X,	// ULONG
  CONTROL_DRVNUMRECDEVS_1X,	// ULONG
  CONTROL_DRVNUMRECDEVS_2X,	// ULONG
  CONTROL_DRVNUMRECDEVS_4X,	// ULONG
  CONTROL_DRVNUMPLAYDEVS_1X,	// ULONG
  CONTROL_DRVNUMPLAYDEVS_2X,	// ULONG
  CONTROL_DRVNUMPLAYDEVS_4X,	// ULONG
  CONTROL_FAST_SHARED_CONTROLS,	// ULONG
  CONTROL_SLOW_SHARED_CONTROLS,	// ULONG
  CONTROL_MIXER_RESTORE_SCENE,	// ULONG
  CONTROL_MIXER_SAVE_SCENE,	// ULONG
  CONTROL_MIXER_LOCK,		// BOOLEAN
  NUM_CONTROLS			// See Controls.xls
};

#ifdef DEBUG
#define MIXERCONTROLNAMES	\
char *gszControlNames[ NUM_CONTROLS ] = {	\
	"CONTROL_NUMCHANNELS",	\
	"CONTROL_SOURCE", \
	"CONTROL_SOURCE_LEFT", \
	"CONTROL_SOURCE_RIGHT", \
	"CONTROL_OVERLOAD", \
	"CONTROL_PEAKMETER", \
	"CONTROL_VOLUME", \
	"CONTROL_MUTE", \
	"CONTROL_DITHER", \
	"CONTROL_MONITOR", \
	"CONTROL_PHASE", \
	"CONTROL_DITHER_DEPTH", \
	"CONTROL_OVERRUN_COUNT", \
	"CONTROL_SAMPLE_COUNT", \
	"CONTROL_SAMPLE_FORMAT", \
	"CONTROL_INPUT_SOURCE", \
	"CONTROL_CLOCKSOURCE", \
	"CONTROL_CLOCKRATE", \
	"CONTROL_CLOCKRATE_SELECT", \
	"CONTROL_CLOCKRATE_LOCK", \
	"CONTROL_WIDEWIREIN", \
	"CONTROL_WIDEWIREOUT", \
	"CONTROL_SYNCHROLOCK_STATUS", \
	"CONTROL_AUTOCLOCKSELECT", \
	"CONTROL_CLOCKSOURCE_PREFERRED", \
	"CONTROL_FREQUENCY_COUNTER_1", \
	"CONTROL_FREQUENCY_COUNTER_2", \
	"CONTROL_FREQUENCY_COUNTER_3", \
	"CONTROL_FREQUENCY_COUNTER_4", \
	"CONTROL_FREQUENCY_COUNTER_5", \
	"CONTROL_FREQUENCY_COUNTER_6", \
	"CONTROL_FREQUENCY_COUNTER_7", \
	"CONTROL_FREQUENCY_COUNTER_8", \
	"CONTROL_FREQUENCY_COUNTER_9", \
	"CONTROL_FREQUENCY_COUNTER_10", \
	"CONTROL_FREQUENCY_COUNTER_11", \
	"CONTROL_FREQUENCY_COUNTER_12", \
	"CONTROL_FREQUENCY_COUNTER_13", \
	"CONTROL_FREQUENCY_COUNTER_14", \
	"CONTROL_FREQUENCY_COUNTER_15", \
	"CONTROL_FREQUENCY_COUNTER_16", \
	"CONTROL_AES50_STATUS", \
	"CONTROL_DIGITAL_FORMAT", \
	"CONTROL_SRC_MODE", \
	"CONTROL_SRC_RATIO", \
	"CONTROL_DIGITALIN_RATE", \
	"CONTROL_DIGITALIN_MUTE_ON_ERROR", \
	"CONTROL_DIGITALIN_STATUS", \
	"CONTROL_DIGITALOUT_STATUS", \
	"CONTROL_TRIM", \
	"CONTROL_MONITOR_SOURCE", \
	"CONTROL_LEVELS", \
	"CONTROL_AIN12_TRIM", \
	"CONTROL_AIN34_TRIM", \
	"CONTROL_AIN56_TRIM", \
	"CONTROL_AOUT12_TRIM", \
	"CONTROL_AOUT34_TRIM", \
	"CONTROL_AOUT56_TRIM", \
	"CONTROL_SYNCIN_NTSC", \
	"CONTROL_DIGITALIN1_STATUS", \
	"CONTROL_DIGITALIN1_RATE", \
	"CONTROL_DIO1_SRC_MODE", \
	"CONTROL_DIO1_SRC_RATIO", \
	"CONTROL_DIGITALIN2_STATUS", \
	"CONTROL_DIGITALIN2_RATE", \
	"CONTROL_DIO2_SRC_MODE", \
	"CONTROL_DIO2_SRC_RATIO", \
	"CONTROL_DIGITALIN3_STATUS", \
	"CONTROL_DIGITALIN3_RATE", \
	"CONTROL_DIO3_SRC_MODE", \
	"CONTROL_DIO3_SRC_RATIO", \
	"CONTROL_DIGITALIN4_STATUS", \
	"CONTROL_DIGITALIN4_RATE", \
	"CONTROL_DIO4_SRC_MODE", \
	"CONTROL_DIO4_SRC_RATIO", \
	"CONTROL_DIGITALIN5_STATUS", \
	"CONTROL_DIGITALIN5_RATE", \
	"CONTROL_DIGITALIN5_SRC_ENABLE", \
	"CONTROL_DIGITALIN5_SRC_RATIO", \
	"CONTROL_DIO5_SRC_MODE", \
	"CONTROL_DIO5_SRC_RATIO", \
	"CONTROL_DIGITALIN6_STATUS", \
	"CONTROL_DIGITALIN6_RATE", \
	"CONTROL_DIGITALIN6_SRC_ENABLE", \
	"CONTROL_DIGITALIN6_SRC_RATIO", \
	"CONTROL_DIO6_SRC_MODE", \
	"CONTROL_DIO6_SRC_RATIO", \
	"CONTROL_DIGITALIN7_STATUS", \
	"CONTROL_DIGITALIN7_RATE", \
	"CONTROL_DIGITALIN7_SRC_ENABLE", \
	"CONTROL_DIGITALIN7_SRC_RATIO", \
	"CONTROL_DIO7_SRC_MODE", \
	"CONTROL_DIO7_SRC_RATIO", \
	"CONTROL_DIGITALIN8_STATUS", \
	"CONTROL_DIGITALIN8_RATE", \
	"CONTROL_DIGITALIN8_SRC_ENABLE", \
	"CONTROL_DIGITALIN8_SRC_RATIO", \
	"CONTROL_DIO8_SRC_MODE", \
	"CONTROL_DIO8_SRC_RATIO", \
	"CONTROL_DIGITALOUT1_STATUS", \
	"CONTROL_DIGITALOUT2_STATUS", \
	"CONTROL_DIGITALOUT3_STATUS", \
	"CONTROL_DIGITALOUT4_STATUS", \
	"CONTROL_DIGITALOUT5_STATUS", \
	"CONTROL_DIGITALOUT6_STATUS", \
	"CONTROL_DIGITALOUT7_STATUS", \
	"CONTROL_DIGITALOUT8_STATUS", \
	"CONTROL_LTCIN_LOCKED", \
	"CONTROL_LTCIN_DIRECTION", \
	"CONTROL_LTCIN_DROPFRAME", \
	"CONTROL_LTCIN_FRAMERATE", \
	"CONTROL_LTCIN_POSITION", \
	"CONTROL_LTCOUT_ENABLE", \
	"CONTROL_LTCOUT_FRAMERATE", \
	"CONTROL_LTCOUT_DROPFRAME", \
	"CONTROL_LTCOUT_SYNCSOURCE", \
	"CONTROL_LTCOUT_POSITION", \
	"CONTROL_LS1_DEVICEID", \
	"CONTROL_LS1_PCBREV", \
	"CONTROL_LS1_FIRMWAREREV", \
	"CONTROL_LS1_OUTSEL", \
	"CONTROL_LS1_LTMODE", \
	"CONTROL_LS1_ADAT_CLKSRC", \
	"CONTROL_LS1_ADAT_IN1_LOCK", \
	"CONTROL_LS1_ADAT_IN2_LOCK", \
	"CONTROL_LS1_ADAT_POSITION", \
	"CONTROL_LS1_ADAT_CUEPOINT_ENABLE", \
	"CONTROL_LS1_ADAT_CUEPOINT", \
	"CONTROL_LS1_AES_CLKSRC", \
	"CONTROL_LS1_AES_WIDEWIRE", \
	"CONTROL_LS1_D1_FORMAT", \
	"CONTROL_LS1_DI1_SRC_MODE", \
	"CONTROL_LS1_DI1_RATE", \
	"CONTROL_LS1_DI1_SRC_RATIO", \
	"CONTROL_LS1_DI1_STATUS", \
	"CONTROL_LS1_DO1_STATUS", \
	"CONTROL_LS1_D2_FORMAT", \
	"CONTROL_LS1_DI2_SRC_MODE", \
	"CONTROL_LS1_DI2_RATE", \
	"CONTROL_LS1_DI2_SRC_RATIO", \
	"CONTROL_LS1_DI2_STATUS", \
	"CONTROL_LS1_DO2_STATUS", \
	"CONTROL_LS1_D3_FORMAT", \
	"CONTROL_LS1_DI3_SRC_MODE", \
	"CONTROL_LS1_DI3_RATE", \
	"CONTROL_LS1_DI3_SRC_RATIO", \
	"CONTROL_LS1_DI3_STATUS", \
	"CONTROL_LS1_DO3_STATUS", \
	"CONTROL_LS1_D4_FORMAT", \
	"CONTROL_LS1_DI4_SRC_MODE", \
	"CONTROL_LS1_DI4_RATE", \
	"CONTROL_LS1_DI4_SRC_RATIO", \
	"CONTROL_LS1_DI4_STATUS", \
	"CONTROL_LS1_DO4_STATUS", \
	"CONTROL_LS2_DEVICEID", \
	"CONTROL_LS2_PCBREV", \
	"CONTROL_LS2_FIRMWAREREV", \
	"CONTROL_LS2_OUTSEL", \
	"CONTROL_LS2_LTMODE", \
	"CONTROL_LS2_ADAT_CLKSRC", \
	"CONTROL_LS2_ADAT_IN1_LOCK", \
	"CONTROL_LS2_ADAT_IN2_LOCK", \
	"CONTROL_LS2_ADAT_POSITION", \
	"CONTROL_LS2_ADAT_CUEPOINT_ENABLE", \
	"CONTROL_LS2_ADAT_CUEPOINT", \
	"CONTROL_LS2_AES_CLKSRC", \
	"CONTROL_LS2_AES_WIDEWIRE", \
	"CONTROL_LS2_D1_FORMAT", \
	"CONTROL_LS2_DI1_SRC_MODE", \
	"CONTROL_LS2_DI1_RATE", \
	"CONTROL_LS2_DI1_SRC_RATIO", \
	"CONTROL_LS2_DI1_STATUS", \
	"CONTROL_LS2_DO1_STATUS", \
	"CONTROL_LS2_D2_FORMAT", \
	"CONTROL_LS2_DI2_SRC_MODE", \
	"CONTROL_LS2_DI2_RATE", \
	"CONTROL_LS2_DI2_SRC_RATIO", \
	"CONTROL_LS2_DI2_STATUS", \
	"CONTROL_LS2_DO2_STATUS", \
	"CONTROL_LS2_D3_FORMAT", \
	"CONTROL_LS2_DI3_SRC_MODE", \
	"CONTROL_LS2_DI3_RATE", \
	"CONTROL_LS2_DI3_SRC_RATIO", \
	"CONTROL_LS2_DI3_STATUS", \
	"CONTROL_LS2_DO3_STATUS", \
	"CONTROL_LS2_D4_FORMAT", \
	"CONTROL_LS2_DI4_SRC_MODE", \
	"CONTROL_LS2_DI4_RATE", \
	"CONTROL_LS2_DI4_SRC_RATIO", \
	"CONTROL_LS2_DI4_STATUS", \
	"CONTROL_LS2_DO4_STATUS", \
	"CONTROL_FP_ANALOGOUT_SOURCE", \
	"CONTROL_FP_DIGITALOUT_SOURCE", \
	"CONTROL_FP_METER_SOURCE", \
	"CONTROL_LSLOT_OUT_SOURCE", \
	"CONTROL_TRIM_ORIGIN", \
	"CONTROL_FP_TRIM", \
	"CONTROL_TRIM_AIN_1_4", \
	"CONTROL_TRIM_AIN_5_8", \
	"CONTROL_TRIM_AIN_9_12", \
	"CONTROL_TRIM_AIN_13_16", \
	"CONTROL_TRIM_AOUT_1_4", \
	"CONTROL_TRIM_AOUT_5_8", \
	"CONTROL_TRIM_AOUT_9_12", \
	"CONTROL_TRIM_AOUT_13_16", \
	"CONTROL_VOLUMEA", \
	"CONTROL_MUTEA", \
	"CONTROL_SOURCEA", \
	"CONTROL_VOLUMEB", \
	"CONTROL_MUTEB", \
	"CONTROL_SOURCEB", \
	"CONTROL_DITHER_TYPE", \
	"CONTROL_PLAY_DITHER", \
	"CONTROL_RECORD_DITHER", \
	"CONTROL_ADDA_RECALIBRATE", \
	"CONTROL_AD_RECALIBRATE", \
	"CONTROL_DA_RECALIBRATE", \
	"CONTROL_AUTO_RECALIBRATE", \
	"CONTROL_AIN12_HPF", \
	"CONTROL_AIN34_HPF", \
	"CONTROL_AIN56_HPF", \
	"CONTROL_ADHIPASSFILTER", \
	"CONTROL_DA_AUTOMUTE", \
	"CONTROL_DA_DEEMPHASIS", \
	"CONTROL_CLOCK_CHANGE_IF_ACTIVE", \
	"CONTROL_SYNCHROLOCK_ENABLE", \
	"CONTROL_DIGITALIN_SRC_MATCHPHASE", \
	"CONTROL_SYNCSTART", \
	"CONTROL_MTC_SOURCE", \
	"CONTROL_LSTREAM_DUAL_INTERNAL", \
	"CONTROL_MRM_ENABLE", \
	"CONTROL_GPOUT", \
	"CONTROL_RESET_DIGITALIO_LOCK", \
	"CONTROL_MONITOR_OFF_PLAY", \
	"CONTROL_MONITOR_ON_RECORD", \
	"CONTROL_DEVICEID", \
	"CONTROL_PCBREV", \
	"CONTROL_FIRMWAREREV", \
	"CONTROL_FIRMWAREDATE", \
	"CONTROL_MINSOFTWAREREV", \
	"CONTROL_SERIALNUMBER", \
	"CONTROL_MFGDATE", \
	"CONTROL_DRVBUFSIZE_1X", \
	"CONTROL_DRVBUFSIZE_2X", \
	"CONTROL_DRVBUFSIZE_4X", \
	"CONTROL_DRVNUMRECDEVS_1X", \
	"CONTROL_DRVNUMRECDEVS_2X", \
	"CONTROL_DRVNUMRECDEVS_4X", \
	"CONTROL_DRVNUMPLAYDEVS_1X", \
	"CONTROL_DRVNUMPLAYDEVS_2X", \
	"CONTROL_DRVNUMPLAYDEVS_4X", \
	"CONTROL_FAST_SHARED_CONTROLS", \
	"CONTROL_SLOW_SHARED_CONTROLS", \
	"CONTROL_MIXER_RESTORE_SCENE", \
	"CONTROL_MIXER_SAVE_SCENE", \
	"CONTROL_MIXER_LOCK", \
	}
#endif

#endif // _CONTROLLIST_H
