#awesome-c

A curated list of awesome C frameworks, libraries and software.

* [SamyPesse/How-to-Make-a-Computer-Operating-System](https://github.com/SamyPesse/How-to-Make-a-Computer-Operating-System) - How to Make a Computer Operating System in C++
* [bang590/JSPatch](https://github.com/bang590/JSPatch) - JSPatch bridge Objective-C and Javascript using the Objective-C runtime. You can call any Objective-C class and method in JavaScript by just including a small engine. JSPatch is generally used to hotfix iOS App.
* [grpc/grpc](https://github.com/grpc/grpc) - The C based gRPC (C++, Node.js, Python, Ruby, Objective-C, PHP, C#)
* [liuliu/ccv](https://github.com/liuliu/ccv) - C-based/Cached/Core Computer Vision Library, A Modern Computer Vision Library
* [vurtun/nuklear](https://github.com/vurtun/nuklear) - A single-header ANSI C gui library
* [nothings/stb](https://github.com/nothings/stb) - stb single-file public domain libraries for C/C++
* [fogleman/Craft](https://github.com/fogleman/Craft) - A simple Minecraft clone written in C using modern OpenGL (shaders).
* [curl/curl](https://github.com/curl/curl) - A command line tool and library for transferring data with URL syntax, supporting FTP, FTPS, HTTP, HTTPS, GOPHER, TFTP, SCP, SFTP, TELNET, DICT, LDAP, LDAPS, FILE, IMAP, SMTP, POP3, RTSP and RTMP. libcurl offers a myriad of powerful features
* [andlabs/libui](https://github.com/andlabs/libui) - Simple and portable (but not inflexible) GUI library in C that uses the native GUI technologies of each platform it supports.
* [rswier/c4](https://github.com/rswier/c4) - C in four functions
* [orangeduck/Cello](https://github.com/orangeduck/Cello) - Higher level programming in C
* [nodejs/http-parser](https://github.com/nodejs/http-parser) - http request/response parser for c
* [cinder/Cinder](https://github.com/cinder/Cinder) - Cinder is a community-developed, free and open source library for professional-quality creative coding in C++.
* [laruence/yaf](https://github.com/laruence/yaf) - A fast php framework written in c, built in php-ext
* [rui314/8cc](https://github.com/rui314/8cc) - A Small C Compiler
* [xoreaxeaxeax/movfuscator](https://github.com/xoreaxeaxeax/movfuscator) - The single instruction C compiler
* [clibs/clib](https://github.com/clibs/clib) - C package manager-ish
* [redis/hiredis](https://github.com/redis/hiredis) - Minimalistic C client for Redis >= 1.2
* [apple/swift-corelibs-foundation](https://github.com/apple/swift-corelibs-foundation) - The Foundation Project, providing core utilities, internationalization, and OS independence
* [jorisvink/kore](https://github.com/jorisvink/kore) - An easy to use, scalable and secure web application framework for writing web APIs in C.
* [contiki-os/contiki](https://github.com/contiki-os/contiki) - The official git repository for Contiki, the open source OS for the Internet of Things
* [tj/luna](https://github.com/tj/luna) - luna programming language - a small, elegant VM implemented in C
* [grbl/grbl](https://github.com/grbl/grbl) - An open source, embedded, high performance g-code-parser and CNC milling controller written in optimized C that will run on a straight Arduino
* [antirez/sds](https://github.com/antirez/sds) - Simple Dynamic Strings library for C
* [Microsoft/react-native-code-push](https://github.com/Microsoft/react-native-code-push) - React Native module for CodePush
* [pocoproject/poco](https://github.com/pocoproject/poco) - POCO C++ Libraries - Cross-platform C++ libraries with a network/internet focus.
* [shadowsocks/ChinaDNS](https://github.com/shadowsocks/ChinaDNS) - Protect yourself against DNS poisoning in China.
* [phalcon/zephir](https://github.com/phalcon/zephir) - Zephir is a compiled high level language aimed to the creation of C-extensions for PHP
* [cmus/cmus](https://github.com/cmus/cmus) - Small, fast and powerful console music player for Unix-like operating systems.
* [citusdata/citus](https://github.com/citusdata/citus) - Scalable PostgreSQL for real-time workloads
* [sustrik/libmill](https://github.com/sustrik/libmill) - Go-style concurrency in C
* [esnme/ultrajson](https://github.com/esnme/ultrajson) - Ultra fast JSON decoder and encoder written in C with Python bindings
* [mortdeus/legacy-cc](https://github.com/mortdeus/legacy-cc) - The earliest versions of the very first c compiler known to exist in the wild written by the late legend himself dmr.
* [lloyd/yajl](https://github.com/lloyd/yajl) - A fast streaming JSON parsing library in C.
* [attractivechaos/klib](https://github.com/attractivechaos/klib) - A standalone and lightweight C library
* [facebook/libphenom](https://github.com/facebook/libphenom) - An eventing framework for building high performance and high scalability systems in C.
* [lastpass/lastpass-cli](https://github.com/lastpass/lastpass-cli) - LastPass command line interface tool
* [armon/statsite](https://github.com/armon/statsite) - C implementation of statsd
* [vmg/sundown](https://github.com/vmg/sundown) - Standards compliant, fast, secure markdown processing library in C
* [mridgers/clink](https://github.com/mridgers/clink) - Bash's powerful command line editing in cmd.exe
* [collectd/collectd](https://github.com/collectd/collectd) - The system statistics collection daemon. Please send Pull Requests here!
* [cleanflight/cleanflight](https://github.com/cleanflight/cleanflight) - Clean-code version of the baseflight flight controller firmware
* [danielwaterworth/Raphters](https://github.com/danielwaterworth/Raphters) - [DEPRECATED] A web framework for C.
* [srdja/Collections-C](https://github.com/srdja/Collections-C) - A library of generic data structures.
* [brianmario/yajl-ruby](https://github.com/brianmario/yajl-ruby) - A streaming JSON parsing and encoding library for Ruby (C bindings to yajl)
* [akheron/jansson](https://github.com/akheron/jansson) - C library for encoding, decoding and manipulating JSON data
* [waruqi/tbox](https://github.com/waruqi/tbox) - A glib-like multi-platform c library
* [zsaleeba/picoc](https://github.com/zsaleeba/picoc) - A very small C interpreter
* [davidmoreno/onion](https://github.com/davidmoreno/onion) - C library to create simple HTTP servers and Web Applications.
* [Kitware/CMake](https://github.com/Kitware/CMake) - CMake, the cross-platform, open-source build system.
* [ideawu/icomet](https://github.com/ideawu/icomet) - A C1000K comet/push server built with C++, for web and mobile app
* [jakogut/tinyvm](https://github.com/jakogut/tinyvm) - TinyVM is a small, fast, lightweight virtual machine written in pure ANSI C.
* [AtomicGameEngine/AtomicGameEngine](https://github.com/AtomicGameEngine/AtomicGameEngine) - The Atomic Game Engine is a multi-platform 2D and 3D engine driven with C#, JavaScript, TypeScript, and C++ (http://www.AtomicGameEngine.com)
* [taf2/curb](https://github.com/taf2/curb) - Ruby bindings for libcurl
* [orangeduck/mpc](https://github.com/orangeduck/mpc) - A Parser Combinator library for C
* [concurrencykit/ck](https://github.com/concurrencykit/ck) - Concurrency primitives, safe memory reclamation mechanisms and non-blocking (including lock-free) data structures designed to aid in the research, design and implementation of high performance concurrent systems.
* [jgamblin/Mirai-Source-Code](https://github.com/jgamblin/Mirai-Source-Code) - Leaked Mirai Source Code for Research/IoC Development Purposes
* [iiordanov/remote-desktop-clients](https://github.com/iiordanov/remote-desktop-clients) - VNC, RDP, SPICE, and oVirt/RHEV/Proxmox Clients for Android and Blackberry 10
* [chjj/compton](https://github.com/chjj/compton) - A compositor for X11.
* [varnish/Varnish-Cache](https://github.com/varnish/Varnish-Cache) - Moved. New address: https://github.com/varnishcache/varnish-cache/
* [tvheadend/tvheadend](https://github.com/tvheadend/tvheadend) - Tvheadend is a TV streaming server for Linux supporting DVB-S, DVB-S2, DVB-C, DVB-T, ATSC, IPTV,SAT>IP and other formats through the unix pipe as input sources.
* [rvoicilas/inotify-tools](https://github.com/rvoicilas/inotify-tools) -   inotify-tools is a C library and a set of command-line programs for Linux providing a simple interface to inotify.
* [taviso/ctypes.sh](https://github.com/taviso/ctypes.sh) - A foreign function interface for bash.
* [jagt/clumsy](https://github.com/jagt/clumsy) - clumsy makes your network condition on Windows significantly worse, but in a controlled and interactive manner.
* [lexborisov/myhtml](https://github.com/lexborisov/myhtml) - Fast C/C++ HTML 5 Parser. Using threads.
* [slembcke/Chipmunk2D](https://github.com/slembcke/Chipmunk2D) - A fast and lightweight 2D game physics library.
* [tekknolagi/carp](https://github.com/tekknolagi/carp) - "interesting" VM in C. Let's see how this goes.
* [SkillCollege/QrCodeScan](https://github.com/SkillCollege/QrCodeScan) - Android手机客户端二维码扫描
* [json-c/json-c](https://github.com/json-c/json-c) - https://github.com/json-c/json-c is the official code repository for json-c.  See the wiki for release tarballs for download.
* [carp-lang/Carp](https://github.com/carp-lang/Carp) - A statically typed lisp, without a GC, for high performance applications
* [universal-ctags/ctags](https://github.com/universal-ctags/ctags) - A maintained ctags implementation
* [tj/mon](https://github.com/tj/mon) - mon(1) - Simple single-process process monitoring program written in C
* [deanmao/node-chimera](https://github.com/deanmao/node-chimera) - A new kind of headless webkit integration for nodejs; a great alternative to phantomjs.
* [nicklockwood/FastCoding](https://github.com/nicklockwood/FastCoding) - A faster and more flexible binary file format replacement for NSCoding, Property Lists and JSON
* [armon/bloomd](https://github.com/armon/bloomd) - C network daemon for bloom filters
* [troydhanson/uthash](https://github.com/troydhanson/uthash) - C macros for hash tables and more
* [silentbicycle/greatest](https://github.com/silentbicycle/greatest) - A C testing library in 1 file. No dependencies, no dynamic allocation. ISC licensed.
* [cesanta/v7](https://github.com/cesanta/v7) - Embedded JavaScript engine for C/C++
* [usrbinnc/netcat-cpi-kernel-module](https://github.com/usrbinnc/netcat-cpi-kernel-module) - Kernel module edition of the Cycles Per Instruction (2014) album.
* [luke-jr/bfgminer](https://github.com/luke-jr/bfgminer) - Modular ASIC/FPGA miner written in C, featuring overclocking, monitoring, fan speed control and remote interface capabilities.
* [jonashaag/bjoern](https://github.com/jonashaag/bjoern) - A screamingly fast Python WSGI server written in C.
* [haywire/haywire](https://github.com/haywire/haywire) - Haywire is an asynchronous HTTP server framework written in C that's built using the event loop based libuv platform layer that node.js is built on top of.
* [rxi/dyad](https://github.com/rxi/dyad) - Asynchronous networking for C
* [apple/swift-corelibs-libdispatch](https://github.com/apple/swift-corelibs-libdispatch) - The libdispatch Project, (a.k.a. Grand Central Dispatch), for concurrency on multicore hardware
* [laruence/yar](https://github.com/laruence/yar) - Light, concurrent RPC framework for PHP & C
* [Bumblebee-Project/Bumblebee](https://github.com/Bumblebee-Project/Bumblebee) - Bumblebee daemon and client rewritten in C
* [cloudwu/pbc](https://github.com/cloudwu/pbc) - A protocol buffers library for C
* [jimon/osx_app_in_plain_c](https://github.com/jimon/osx_app_in_plain_c) - A simple showcase how to create a simple OS X app in plain C without any Objective-C
* [edenhill/librdkafka](https://github.com/edenhill/librdkafka) - The Apache Kafka C/C++ library
* [riolet/rix](https://github.com/riolet/rix) - Rix language combines the power of C language and the convenience of a high level language
* [ivmai/bdwgc](https://github.com/ivmai/bdwgc) - The Boehm-Demers-Weiser conservative C/C++ Garbage Collector (libgc, bdwgc, boehmgc)
* [citusdata/cstore_fdw](https://github.com/citusdata/cstore_fdw) - Columnar store for analytics with PostgreSQL. Check out the mailing list at https://groups.google.com/forum/#!forum/cstore-users.
* [coturn/coturn](https://github.com/coturn/coturn) - coturn TURN server project
* [tarcieri/cool.io](https://github.com/tarcieri/cool.io) - Simple evented I/O for Ruby (but please check out Celluloid::IO instead)
* [intel-iot-devkit/mraa](https://github.com/intel-iot-devkit/mraa) - Linux Library for low speed IO Communication in C with bindings for C++, Python, Node.js & Java. Supports generic io platforms, as well as Intel Edison, Intel Joule, Raspberry Pi and many more.
* [y123456yz/reading-code-of-nginx-1.9.2](https://github.com/y123456yz/reading-code-of-nginx-1.9.2) - nginx-1.9.2源码通读分析注释，带详尽函数中文分析注释以及相关函数流程调用注释，最全面的nginx源码阅读分析中文注释，持续更新
* [halayli/lthread](https://github.com/halayli/lthread) - lthread, a multicore enabled coroutine library written in C
* [gabriel/yajl-objc](https://github.com/gabriel/yajl-objc) - Objective-C bindings for YAJL (Yet Another JSON Library) C library
* [balde/balde](https://github.com/balde/balde) - A microframework for C based on GLib and bad intentions.
* [udp/json-parser](https://github.com/udp/json-parser) - Very low footprint JSON parser written in portable ANSI C
* [FreeApophis/TrueCrypt](https://github.com/FreeApophis/TrueCrypt) - This repository applies all Versions of the Original TrueCrypt Source Files in order
* [megous/megatools](https://github.com/megous/megatools) - Open-source command line tools and C library (libmega) for accessing Mega.co.nz cloud storage.
* [fragglet/c-algorithms](https://github.com/fragglet/c-algorithms) - A library of common data structures and algorithms written in C.
* [riolet/WAFer](https://github.com/riolet/WAFer) - WAFer is a C language-based software platform for scalable server-side and networking applications. Think node.js for C programmers.
* [solusipse/ureq](https://github.com/solusipse/ureq) - Micro C library for handling HTTP requests on low resource systems.
* [CipherShed/CipherShed](https://github.com/CipherShed/CipherShed) - Main CipherShed Development
* [ketoo/NoahGameFrame](https://github.com/ketoo/NoahGameFrame) - A fast, scalable, distributed game server framework for C++, include actor library, network library,can be used as a  real time multiplayer game engine ( MMO RPG ), which support C#/Lua script/ Unity3d, and plan to support Cocos2dx, FlashAir client access.
* [cloudwu/coroutine](https://github.com/cloudwu/coroutine) - A asymmetric coroutine library for C.
* [veracrypt/VeraCrypt](https://github.com/veracrypt/VeraCrypt) - Disk encryption with strong security based on TrueCrypt
* [openvenues/libpostal](https://github.com/openvenues/libpostal) - A C library for parsing/normalizing street addresses around the world. Powered by statistical NLP and open geo data.
* [drh/lcc](https://github.com/drh/lcc) - The lcc retargetable ANSI C compiler
* [trailofbits/ctf](https://github.com/trailofbits/ctf) - CTF Field Guide
* [FRiCKLE/ngx_cache_purge](https://github.com/FRiCKLE/ngx_cache_purge) - nginx module which adds ability to purge content from FastCGI, proxy, SCGI and uWSGI caches.
* [tatsuhiro-t/spdylay](https://github.com/tatsuhiro-t/spdylay) - The experimental SPDY protocol version 2, 3 and 3.1 implementation in C
* [examplecode/mproxy](https://github.com/examplecode/mproxy) - c 语言实现的一个最小的http代理，支持翻墙
* [premake/premake-core](https://github.com/premake/premake-core) - Premake
* [zeromq/czmq](https://github.com/zeromq/czmq) - High-level C binding for ØMQ
* [h2o/picohttpparser](https://github.com/h2o/picohttpparser) - tiny HTTP parser written in C (used in HTTP::Parser::XS et al.)
* [alibaba/nginx-http-concat](https://github.com/alibaba/nginx-http-concat) - A Nginx module for concatenating files in a given context: CSS and JS files usually
* [orangeduck/Corange](https://github.com/orangeduck/Corange) - Pure C Game Engine
* [jgm/peg-markdown](https://github.com/jgm/peg-markdown) - An implementation of markdown in C, using a PEG grammar
* [HardySimpson/zlog](https://github.com/HardySimpson/zlog) - A reliable, high-performance, thread safe, flexsible, clear-model, pure C logging library.
* [Celtoys/Remotery](https://github.com/Celtoys/Remotery) - Realtime CPU/D3D/OpenGL/CUDA Profiler in a single C file with web browser viewer
* [esnme/ultramysql](https://github.com/esnme/ultramysql) - A fast MySQL driver written in pure C/C++ for Python. Compatible with gevent through monkey patching.
* [opsengine/cpulimit](https://github.com/opsengine/cpulimit) - CPU usage limiter for Linux
* [adobe-flash/crossbridge](https://github.com/adobe-flash/crossbridge) - Welcome to visit the homepage!
* [banister/binding_of_caller](https://github.com/banister/binding_of_caller) - Retrieve the binding of a method's caller in MRI 1.9.2+
* [lpsantil/rt0](https://github.com/lpsantil/rt0) - A minimal C runtime for Linux i386 & x86_64
* [Tribler/self-compile-Android](https://github.com/Tribler/self-compile-Android) - Autonomous smartphone app. Capable of self-compilation, mutation, and viral spreading. World-first proof-of-principle to bypass Internet kill switches.
* [pvaret/rtl8192cu-fixes](https://github.com/pvaret/rtl8192cu-fixes) - Realtek 8192 chipset driver, ported to kernel 3.11.
* [clMathLibraries/clBLAS](https://github.com/clMathLibraries/clBLAS) - a software library containing BLAS functions written in OpenCL
* [andrewrk/libsoundio](https://github.com/andrewrk/libsoundio) - C library for cross-platform real-time audio input and output
* [probablycorey/seriously](https://github.com/probablycorey/seriously) - The Objective-C HTTP library that Apple should have created, seriously.
* [Orc/discount](https://github.com/Orc/discount) - My C implementation of John Gruber's Markdown markup language
* [cbuchner1/CudaMiner](https://github.com/cbuchner1/CudaMiner) - a CUDA accelerated litecoin mining application based on pooler's CPU miner
* [mintomic/mintomic](https://github.com/mintomic/mintomic) - [deprecated] For native C atomics, see Turf instead
* [corosync/corosync](https://github.com/corosync/corosync) - The Corosync Cluster Engine
* [commoncrawl/commoncrawl](https://github.com/commoncrawl/commoncrawl) - CommonCrawl Project Repository
* [ThrowTheSwitch/Unity](https://github.com/ThrowTheSwitch/Unity) - Simple Unit Testing for C
* [civetweb/civetweb](https://github.com/civetweb/civetweb) - Embedded C/C++ web server
* [hillegass/BNRPersistence](https://github.com/hillegass/BNRPersistence) - A set of classes which use Tokyo Cabinet to save and load Objective-C objects
* [vinniefalco/LuaBridge](https://github.com/vinniefalco/LuaBridge) - A lightweight, dependency-free library for binding Lua to C++
* [RJ/ketama](https://github.com/RJ/ketama) - C library for consistent hashing, and langauge bindings
* [moqod/ios-qr-code-encoder](https://github.com/moqod/ios-qr-code-encoder) - This is an Objective-C library that helps to easily convert a UIImage with a QR-code from NSString with just one line of code.
* [zhengshuxin/acl](https://github.com/zhengshuxin/acl) - one advanced C/C++ lib for UNIX and WINDOWS
* [samtools/samtools](https://github.com/samtools/samtools) - Tools (written in C using htslib) for manipulating next-generation sequencing data
* [kgabis/parson](https://github.com/kgabis/parson) - Lightweight JSON library written in C.
* [emweb/wt](https://github.com/emweb/wt) - Wt, C++ Web Toolkit
* [pusher/libPusher](https://github.com/pusher/libPusher) - An Objective-C interface to Pusher
* [dinhviethoa/libetpan](https://github.com/dinhviethoa/libetpan) - Mail Framework for C Language
* [APE-Project/APE_Server](https://github.com/APE-Project/APE_Server) - Ajax Push Engine : Lightweight HTTP Streaming server. Fully written in C language, it provides best performances, making it the faster Comet server to date. APE now support server-side javascript modules through spidermonkey
* [rustyrussell/ccan](https://github.com/rustyrussell/ccan) - The C Code Archive Network
* [olilarkin/wdl-ol](https://github.com/olilarkin/wdl-ol) - Enhanced version of Cockos' IPlug - A simple-to-use C++ framework for developing cross platform audio plugins and targeting multiple plugin APIs with the same code. VST / VST3 / Audiounit / RTAS / AAX (Native) formats supported.
* [armon/hlld](https://github.com/armon/hlld) - C network daemon for HyperLogLogs
* [kbranigan/cJSON](https://github.com/kbranigan/cJSON) - I did not write this code, but I like it.
* [xemul/criu](https://github.com/xemul/criu) - Checkpoint/Restore tool
* [jgarzik/cpuminer](https://github.com/jgarzik/cpuminer) - CPU miner for bitcoin
* [kokke/tiny-AES128-C](https://github.com/kokke/tiny-AES128-C) - Small portable AES128 in C
* [jianfengye/nginx-1.0.14_comment](https://github.com/jianfengye/nginx-1.0.14_comment) - nginx源码中文注释版
* [felixangell/mac](https://github.com/felixangell/mac) - a simple virtual machine implemented in c
* [redbo/cloudfuse](https://github.com/redbo/cloudfuse) - Filesystem (fuse) implemented on Mosso's Cloud Files
* [lotabout/write-a-C-interpreter](https://github.com/lotabout/write-a-C-interpreter) - Write a simple interpreter of C. Inspired by c4 and largely based on it.
* [jserv/facebooc](https://github.com/jserv/facebooc) - Yet another Facebook clone written in C
* [cnlohr/channel3](https://github.com/cnlohr/channel3) - ESP8266 Analog Broadcast Television Interface
* [karlstav/cava](https://github.com/karlstav/cava) - Console-based Audio Visualizer for Alsa
* [fabiensanglard/chocolate_duke3D](https://github.com/fabiensanglard/chocolate_duke3D) - chocolate Duke Nukem,3D
* [rui314/minilisp](https://github.com/rui314/minilisp) - A readable lisp in less than 1k lines of C
* [freebsd/crochet](https://github.com/freebsd/crochet) - Build FreeBSD images for RaspberryPi, BeagleBone, PandaBoard, and others.
* [monitoringartist/zabbix-docker-monitoring](https://github.com/monitoringartist/zabbix-docker-monitoring) - :whale: Docker monitoring of (Kubernetes/Mesos/Marathon/Chronos/LXC/LXD) containers - Docker image, Zabbix template and C module
* [NMSSH/NMSSH](https://github.com/NMSSH/NMSSH) - NMSSH is an Objective-C wrapper for libssh2, with a sweet API.
* [munificent/mark-sweep](https://github.com/munificent/mark-sweep) - A simple mark-sweep garbage collector in C
* [swoole/php-cp](https://github.com/swoole/php-cp) - pdo and redis tcp connect proxy
* [wmutils/core](https://github.com/wmutils/core) - Set of window manipulation tools
* [Snaipe/Criterion](https://github.com/Snaipe/Criterion) - A KISS, non-intrusive cross-platform C unit testing framework
* [dariomanesku/cmftStudio](https://github.com/dariomanesku/cmftStudio) - cmftStudio - GUI counterpart for:
* [emsec/ChameleonMini](https://github.com/emsec/ChameleonMini) - The ChameleonMini is a versatile contactless smartcard emulator compliant to NFC. For further information see the Getting Started Page or the GitHub-Wiki-Tab above.
* [Kazade/kazmath](https://github.com/Kazade/kazmath) - A C math library targeted at games
* [varnishcache/varnish-cache](https://github.com/varnishcache/varnish-cache) - Varnish Cache source code repository
* [Blosc/c-blosc](https://github.com/Blosc/c-blosc) - A blocking, shuffling and loss-less compression library that can be faster than `memcpy()`.
* [openglsuperbible/sb6code](https://github.com/openglsuperbible/sb6code) - Source code for OpenGL SupeBible 6th Edition examples
* [Mzzopublic/C](https://github.com/Mzzopublic/C) - C语言
* [gwaldron/osgearth](https://github.com/gwaldron/osgearth) - A free open source C++ geospatial toolkit.
* [gianlucabertani/Objective-Zip](https://github.com/gianlucabertani/Objective-Zip) - An object-oriented friendly wrapper library for ZLib and MiniZip, in Objective-C for iOS and OS X
* [ganglia/monitor-core](https://github.com/ganglia/monitor-core) - Ganglia Monitoring core
* [smealum/ctrulib](https://github.com/smealum/ctrulib) - C library for writing user mode arm11 code for the 3DS (CTR)
* [miao1007/Openwrt-NetKeeper](https://github.com/miao1007/Openwrt-NetKeeper) - [C/C++] Run Netkeeper on OpenWrt Device
* [cc65/cc65](https://github.com/cc65/cc65) - cc65 - a freeware C compiler for 6502 based systems —
* [xelatihy/yocto-gl](https://github.com/xelatihy/yocto-gl) - A collection of C/C++ single-file libraries for building physically-based graphics applications
* [ands/lightmapper](https://github.com/ands/lightmapper) - A C/C++ single-file library for lightmap baking by using your existing OpenGL renderer
* [gozfree/libraries](https://github.com/gozfree/libraries) - Basic libraries all written in c by gozfree, including network, event, config, log, hash, ipc, rpc, mem,  and so on
* [jgm/cmark](https://github.com/jgm/cmark) - CommonMark parsing and rendering library and program in C
* [DaveGamble/cJSON](https://github.com/DaveGamble/cJSON) - Ultralightweight JSON parser in ANSI C
* [10gen/mongo-c-driver-legacy](https://github.com/10gen/mongo-c-driver-legacy) - C Driver for MongoDB
* [libretro/common-shaders](https://github.com/libretro/common-shaders) - Collection of commonly used Cg shaders. These shaders are usable by either HLSL and/or Cg runtime compilers. The cg2glsl script will translate most of these into GLSL shaders.
* [OpenGLInsights/OpenGLInsightsCode](https://github.com/OpenGLInsights/OpenGLInsightsCode) - Source code for OpenGL Insights
* [lukeweber/webrtc-jingle-client](https://github.com/lukeweber/webrtc-jingle-client) - Webrtc audio + jingle protocol brought to IOS and Android.
* [benhoyt/inih](https://github.com/benhoyt/inih) - Simple .INI file parser in C, good for embedded systems
* [cesanta/slre](https://github.com/cesanta/slre) - Super Light Regexp engine for C/C++
* [mpx/lua-cjson](https://github.com/mpx/lua-cjson) - Lua CJSON is a fast JSON encoding/parsing module for Lua
* [HerculesWS/Hercules](https://github.com/HerculesWS/Hercules) - Hercules is a collaborative software development project revolving around the creation of a robust massively multiplayer online role playing game (MMORPG) server package. Written in C, the program is very versatile and provides NPCs, warps and modifications. The project is jointly managed by a group of volunteers located around the world as well as a tremendous community providing QA and support. Hercules is a continuation of the original Athena project.
* [aterrien/forp-PHP-profiler](https://github.com/aterrien/forp-PHP-profiler) - A PHP profiler written in C. forp is a lightweight PHP extension which provides the full call stack of your script, with CPU and memory usage, in a plain PHP Array or JSON output.
* [notandy/ympd](https://github.com/notandy/ympd) - Standalone MPD Web GUI written in C, utilizing Websockets and Bootstrap/JS
* [DoubleSpout/ccap](https://github.com/DoubleSpout/ccap) - node.js generate captcha using c++ library CImg without install any other lib or software
* [kiibohd/controller](https://github.com/kiibohd/controller) - Kiibohd Controller
* [sustrik/libdill](https://github.com/sustrik/libdill) - Structured concurrency in C
* [Macarse/50AH-code](https://github.com/Macarse/50AH-code) - 50 Android Hacks book source code
* [mobile-web-messaging/MQTTKit](https://github.com/mobile-web-messaging/MQTTKit) - MQTT Objective-C client for iOS
* [bitcraze/crazyflie-firmware](https://github.com/bitcraze/crazyflie-firmware) - The main firmware for the Crazyflie Nano Quadcopter.
* [falconindy/cower](https://github.com/falconindy/cower) - A simple AUR agent with a pretentious name.
* [jserv/amacc](https://github.com/jserv/amacc) - Small C Compiler generating ELF executable for ARM architecture
* [FreddieV4/DailyProgrammerChallenges](https://github.com/FreddieV4/DailyProgrammerChallenges) - External Repo of Challenges from r/dailyprogrammer
* [cesanta/fossa](https://github.com/cesanta/fossa) - Async non-blocking multi-protocol networking library for C/C++
* [oleganza/CoreBitcoin](https://github.com/oleganza/CoreBitcoin) - Awesome Bitcoin toolkit for ObjC and Swift
* [leonindy/camel](https://github.com/leonindy/camel) - camel: soft load balance(slb) midware - control nginx servers by portal and api.
* [symisc/PH7](https://github.com/symisc/PH7) - An Embedded Implementation of PHP (C Library)
* [vurtun/mmx](https://github.com/vurtun/mmx) - single header libraries for C/C++
* [Pithikos/C-Thread-Pool](https://github.com/Pithikos/C-Thread-Pool) - A minimal but powerful thread pool in ANSI C
* [doches/progressbar](https://github.com/doches/progressbar) - An easy-to-use C library for displaying text progress bars.
* [justinmeza/lci](https://github.com/justinmeza/lci) - A LOLCODE interpreter written in C.
* [blechschmidt/massdns](https://github.com/blechschmidt/massdns) - A high-performance DNS stub resolver in C
* [posva/catimg](https://github.com/posva/catimg) - :squirrel: Insanely fast image printing in your terminal
* [SRombauts/SQLiteCpp](https://github.com/SRombauts/SQLiteCpp) - SQLiteC++ (SQLiteCpp) is a smart and easy to use C++ SQLite3 wrapper.
* [msgpack/msgpack-objectivec](https://github.com/msgpack/msgpack-objectivec) - MessagePack serializer implementation for Objective-C / msgpack.org[Objective-C]
* [mongodb/mongo-c-driver](https://github.com/mongodb/mongo-c-driver) - A high-performance MongoDB driver for C
* [jdduke/three_cpp](https://github.com/jdduke/three_cpp) - A port of three.js to C++
* [eleme/corvus](https://github.com/eleme/corvus) - A fast and lightweight Redis Cluster Proxy for Redis 3.0
* [stevedekorte/vertexdb](https://github.com/stevedekorte/vertexdb) - C graph db server using tokyocabinet & libevent
* [rswier/swieros](https://github.com/rswier/swieros) - A tiny hand crafted CPU emulator, C compiler, and Operating System
* [alexfru/SmallerC](https://github.com/alexfru/SmallerC) - Simple C compiler
* [mupen64plus/mupen64plus-core](https://github.com/mupen64plus/mupen64plus-core) - Core module of the Mupen64Plus project
* [distcc/distcc](https://github.com/distcc/distcc) - distributed builds for C, C++ and Objective C
* [Steve132/uraster](https://github.com/Steve132/uraster) - Micro simple Rasterizer in a single C++11 header file.
* [andysworkshop/stm32plus](https://github.com/andysworkshop/stm32plus) - The C++ library for the STM32 F0, F100, F103, F107 and F4 microcontrollers
* [stawel/cheali-charger](https://github.com/stawel/cheali-charger) - cheap lipo charger
* [marssaxman/startc](https://github.com/marssaxman/startc) - minimal freestanding C library for bare-metal i386 development
* [douban/greenify](https://github.com/douban/greenify) - Make blocking C library work with gevent
* [sonsongithub/CoreAR](https://github.com/sonsongithub/CoreAR) - AR(Augmented reality) framework for iOS, based on a visual code like ARToolKit
* [prideout/par](https://github.com/prideout/par) - single-file C libraries from Philip Allan Rideout
* [libtrading/libtrading](https://github.com/libtrading/libtrading) - Libtrading, an ultra low-latency trading connectivity library for C and C++.
* [KingOfBrian/VocalKit](https://github.com/KingOfBrian/VocalKit) - Objective-C shim layer for Speech Recognition
* [paulhoux/Cinder-Samples](https://github.com/paulhoux/Cinder-Samples) - Sample applications for the Cinder framework
* [mbrossard/threadpool](https://github.com/mbrossard/threadpool) - A simple C Thread pool implementation
* [cfengine/core](https://github.com/cfengine/core) - CFEngine Community
* [silentbicycle/theft](https://github.com/silentbicycle/theft) - property-based testing for C
* [jmckaskill/luaffi](https://github.com/jmckaskill/luaffi) - Standalone FFI library for calling C functions from lua. Compatible with the luajit FFI interface.
* [grimfang4/sdl-gpu](https://github.com/grimfang4/sdl-gpu) - A library for high-performance, modern 2D graphics with SDL written in C.
* [wesleykendall/mpitutorial](https://github.com/wesleykendall/mpitutorial) - MPI programming lessons in C and executable code examples
* [CE-Programming/CEmu](https://github.com/CE-Programming/CEmu) - A developer-oriented emulator of the eZ80-based TI-84 Plus CE / TI-83 Premium CE calculators
* [cloudwu/cstring](https://github.com/cloudwu/cstring) - A simple C string lib
* [angel2d/angel2d](https://github.com/angel2d/angel2d) - A cross-platform 2D game prototyping framework based on OpenGL and C++
* [znort987/blockparser](https://github.com/znort987/blockparser) - Simple C++ bitcoin blockchain parser
* [xroche/coffeecatch](https://github.com/xroche/coffeecatch) - CoffeeCatch, a tiny native POSIX signal catcher (especially useful for JNI code on Android/Dalvik)
* [joyent/v8plus](https://github.com/joyent/v8plus) - Node.js native add-ons in C
* [blankwall/MacDBG](https://github.com/blankwall/MacDBG) - Simple easy to use C and python debugging framework for OSX
* [B-Con/crypto-algorithms](https://github.com/B-Con/crypto-algorithms) - Basic implementations of standard cryptography algorithms, like AES and SHA-1.
* [williame/hellepoll](https://github.com/williame/hellepoll) - A blazingly-fast async HTTP server written in C++
* [vlm/asn1c](https://github.com/vlm/asn1c) - The ASN.1 Compiler
* [armon/libart](https://github.com/armon/libart) - Adaptive Radix Trees implemented in C
* [quartzjer/js0n](https://github.com/quartzjer/js0n) - Flexible Zero-Footprint JSON Parser in C
* [chocolate-doom/chocolate-doom](https://github.com/chocolate-doom/chocolate-doom) - Chocolate Doom is a Doom source port that is conservative and historically accurate.
* [RandyGaul/qu3e](https://github.com/RandyGaul/qu3e) - Lightweight and Simple 3D Open Source Physics Engine in C++
* [FreedomBen/rtl8188ce-linux-driver](https://github.com/FreedomBen/rtl8188ce-linux-driver) - This modified version of the RealTek WiFi driver fixes some issues with RealTek cards on Linux.
* [cvxopt/cvxopt](https://github.com/cvxopt/cvxopt) - CVXOPT -- Python Software for Convex Optimization
* [lavoiesl/osx-cpu-temp](https://github.com/lavoiesl/osx-cpu-temp) - Outputs current CPU temperature for OSX
* [leaflabs/libmaple](https://github.com/leaflabs/libmaple) - [INACTIVE] C and C++ library for STM32 ARM Cortex-M3 development boards.
* [benoitc/http-parser](https://github.com/benoitc/http-parser) - HTTP request/response parser for python in C
* [wolkykim/qlibc](https://github.com/wolkykim/qlibc) - qLibc is a simple and powerful C library
* [mozilla-services/ios-sync-client](https://github.com/mozilla-services/ios-sync-client) - A standalone iOS client for Firefox Sync
* [tj90241/cen64](https://github.com/tj90241/cen64) - Cycle-Accurate Nintendo 64 Emulator
* [kablaa/CTF-Workshop](https://github.com/kablaa/CTF-Workshop) - Challenges for Binary Exploitation Workshop
* [pgbovine/CDE](https://github.com/pgbovine/CDE) - CDE: Code, Data, and Environment packaging for Linux
* [lionsoul2014/ip2region](https://github.com/lionsoul2014/ip2region) - 准确率99.9%的ip地址定位库，0.0x毫秒级查询，数据库文件大小只有1.5M，提供了java, php, c, python查询绑定和Binary,B树,内存三种查询算法，妈妈再也不用担心我的ip地址定位！
* [H2CO3/Sparkling](https://github.com/H2CO3/Sparkling) - A lightweight, extensible, C-style scripting language
* [erikd/libsndfile](https://github.com/erikd/libsndfile) - A C library for reading and writing sound files containing sampled audio data..
* [taylor001/crown](https://github.com/taylor001/crown) - The flexible game engine.
* [readium/readium-sdk](https://github.com/readium/readium-sdk) - A C++ ePub renderer SDK of similar capability to Adobe's RMSDK.
* [openresty/lua-upstream-nginx-module](https://github.com/openresty/lua-upstream-nginx-module) - Nginx C module to expose Lua API to ngx_lua for Nginx upstreams
* [morhetz/gruvbox-contrib](https://github.com/morhetz/gruvbox-contrib) - Ports of the gruvbox colorscheme
* [HuoLanguage/huo](https://github.com/HuoLanguage/huo) - interpreted language written in C
* [aurelian/ruby-stemmer](https://github.com/aurelian/ruby-stemmer) - Expose libstemmer_c to Ruby
* [pfultz2/Cloak](https://github.com/pfultz2/Cloak) - A mini-preprocessor library to demostrate the recursive capabilites of the preprocessor
* [pbhogan/scrypt](https://github.com/pbhogan/scrypt) - A Ruby gem with native C extension for the scrypt password hashing algorithm.
* [luohaha/CSpider](https://github.com/luohaha/CSpider) - A scalable and convenient crawler framework in C:).
* [duckythescientist/obfuscatedLife](https://github.com/duckythescientist/obfuscatedLife) - Conway's Game of Life in 9 lines of C
* [samtools/htslib](https://github.com/samtools/htslib) - C library for high-throughput sequencing data formats
* [parallella/pal](https://github.com/parallella/pal) - An optimized C library for math, parallel processing and data movement
* [tonyrog/cl](https://github.com/tonyrog/cl) - OpenCL binding for Erlang
* [docopt/docopt.c](https://github.com/docopt/docopt.c) - C-code generator for docopt language.
* [yosefk/checkedthreads](https://github.com/yosefk/checkedthreads) - checkedthreads: no race condition goes unnoticed! Simple API, automatic load balancing, Valgrind-based checking
* [miohtama/python-Levenshtein](https://github.com/miohtama/python-Levenshtein) - The Levenshtein Python C extension module contains functions for fast computation of Levenshtein distance and string similarity
* [bitcoin-core/secp256k1](https://github.com/bitcoin-core/secp256k1) - Optimized C library for EC operations on curve secp256k1
* [ccxvii/mujs](https://github.com/ccxvii/mujs) - An embeddable Javascript interpreter in C.
* [ZECTBynmo/node-core-audio](https://github.com/ZECTBynmo/node-core-audio) - Bindings for PortAudio giving JavaScript access to sound card samples (mostly unmaintained)
* [Wilfred/babyc](https://github.com/Wilfred/babyc) - A toy C compiler
* [TASVideos/BizHawk](https://github.com/TASVideos/BizHawk) - BizHawk is a A multi-system emulator written in C#.  BizHawk provides nice features for casual gamers such as full screen, and joypad support in addition to full rerecording and debugging tools for all system cores.
* [cxong/tinydir](https://github.com/cxong/tinydir) - Lightweight, portable and easy to integrate C directory and file reader
* [closeio/ciso8601](https://github.com/closeio/ciso8601) - Fast ISO8601 date time parser for Python written in C
* [tatsuhiro-t/wslay](https://github.com/tatsuhiro-t/wslay) - The WebSocket library in C
* [m8rge/cwebsocket](https://github.com/m8rge/cwebsocket) - cWebsocket is lightweight websocket server library
* [linux-can/can-utils](https://github.com/linux-can/can-utils) - Linux-CAN / SocketCAN user space applications
* [grobian/carbon-c-relay](https://github.com/grobian/carbon-c-relay) - Enhanced C implementation of Carbon relay, aggregator and rewriter
* [mevdschee/2048.c](https://github.com/mevdschee/2048.c) - Console version of the game "2048" for GNU/Linux
* [atg/chocolat-public](https://github.com/atg/chocolat-public) - Public bug tracker for the private chocolat project
* [lacker/ikalman](https://github.com/lacker/ikalman) - An iPhone-friendly Kalman filter written in C.
* [jduck/asus-cmd](https://github.com/jduck/asus-cmd) - ASUS Router infosvr UDP Broadcast root Command Execution
* [joan2937/pigpio](https://github.com/joan2937/pigpio) - pigpio is a C library for the Raspberry which allows control of the General Purpose Input Outputs (GPIO).
* [esneider/debug](https://github.com/esneider/debug) - Debugging like a sir (in C)
* [watmough/jwHash](https://github.com/watmough/jwHash) - Simple hash table implementation for C.
* [Lokaltog/candybar](https://github.com/Lokaltog/candybar) - WebKit-based status bar for tiling window managers.
* [udp/lacewing](https://github.com/udp/lacewing) - Cross-platform network I/O library for C/C++
* [mkorenkov/ipad_charge](https://github.com/mkorenkov/ipad_charge) - charge Apple devices under Ubuntu Linux
* [face/MongooseDaemon](https://github.com/face/MongooseDaemon) - An objective-c wrapper for embedding the mongoose http web server in iPhone apps
* [ned14/nedmalloc](https://github.com/ned14/nedmalloc) - An EXTREMELY FAST portable thread caching malloc implementation written in C for multiple threads without lock contention based on dlmalloc. Optimised for x86 and x64. Compatible with C++. Can patch itself into existing binaries on Windows.
* [Fedjmike/mini-c](https://github.com/Fedjmike/mini-c) - Dr Strangehack, or: how to write a self-hosting C compiler in 10 hours
* [couchbaselabs/Android-Couchbase](https://github.com/couchbaselabs/Android-Couchbase) - The android build for humans.
* [cgaebel/pipe](https://github.com/cgaebel/pipe) - A simple thread-safe FIFO in C.
* [agl/critbit](https://github.com/agl/critbit) - Critbit trees in C
* [topameng/CsToLua](https://github.com/topameng/CsToLua) - The fastest unity lua binding solution
* [tanakh/cmdline](https://github.com/tanakh/cmdline) - A Command Line Parser
* [circonus-labs/fq](https://github.com/circonus-labs/fq) - F@#$*&%Q (Message queue that is fast, brokered, in C and gets out of your way)
* [pez2001/razer_chroma_drivers](https://github.com/pez2001/razer_chroma_drivers) - A collection of Linux drivers for Razer Chroma devices, it supports all lighting modes and includes a daemon for advanced effects + gui configuration app
* [commonsguy/cwac-anddown](https://github.com/commonsguy/cwac-anddown) - CWAC AndDown: Markdown Utility Library
* [abstrakraft/cwiid](https://github.com/abstrakraft/cwiid) - Linux Nintendo Wiimote interface
* [WhisperSystems/libsignal-protocol-c](https://github.com/WhisperSystems/libsignal-protocol-c) - Signal Protocol C Library
* [phonegap/phonegap-plugin-fast-canvas](https://github.com/phonegap/phonegap-plugin-fast-canvas) - Fast, 2D, mostly-HTML5-canvas-compatible rendering surface for Android.
* [aws/aws-iot-device-sdk-embedded-C](https://github.com/aws/aws-iot-device-sdk-embedded-C) - SDK for connecting to AWS IoT from a device using embedded C.
* [willemt/raft](https://github.com/willemt/raft) - C implementation of the Raft Consensus protocol, BSD licensed
* [JazzCore/ctrlp-cmatcher](https://github.com/JazzCore/ctrlp-cmatcher) - CtrlP C matching extension
* [hfiref0x/CVE-2015-1701](https://github.com/hfiref0x/CVE-2015-1701) - Win32k LPE vulnerability used in APT attack
* [eudoxia0/magma](https://github.com/eudoxia0/magma) - Extending C with cmacro
* [openglsuperbible/sb7code](https://github.com/openglsuperbible/sb7code) - Source code and supporting material for the 7th Edition of OpenGL SuperBible
* [mofaph/csapp](https://github.com/mofaph/csapp) - Computer Systems: A Programmer's Perspective
* [chaoslawful/ccard-lib](https://github.com/chaoslawful/ccard-lib) - C library for estimating cardinality in streams for which it is infeasible to store all events in memory
* [maxmind/libmaxminddb](https://github.com/maxmind/libmaxminddb) - C library for the MaxMind DB file format
* [CauldronDevelopmentLLC/CAMotics](https://github.com/CauldronDevelopmentLLC/CAMotics) - Open-Source Simulation & Computer Aided Machining - A 3-axis CNC GCode simulator
* [aidansteele/MagicKit](https://github.com/aidansteele/MagicKit) - MagicKit is an Objective-C file identification framework based on libmagic.
* [vmg/clar](https://github.com/vmg/clar) - What tests are made of.
* [ccache/ccache](https://github.com/ccache/ccache) - ccache - a fast compiler cache
* [ScottyBauer/Android_Kernel_CVE_POCs](https://github.com/ScottyBauer/Android_Kernel_CVE_POCs) - A list of my CVE's with POCs
* [pkrumins/node-png](https://github.com/pkrumins/node-png) - A nodejs C++ module that given a buffer with RGB or RGBA values creates a PNG image (in memory).
* [libgdx/fbx-conv](https://github.com/libgdx/fbx-conv) - Command line utility using the FBX SDK to convert FBX/Collada/Obj files to a custom text/binary format for static, keyframed and skinned meshes.
* [dosgo/ngrok-c](https://github.com/dosgo/ngrok-c) - ngrok client for c language,Due to the use of GO ngrok language development, porting to embedded devices some inconvenience, such as openwrt, so use C language rewrite a client. Very mini, the need to support polarssl library.
* [cbsd/cbsd](https://github.com/cbsd/cbsd) - Yet one more wrapper around jail, bhyve and XEN on FreeBSD platform. For more information please visit website
* [wiiudev/libwiiu](https://github.com/wiiudev/libwiiu) - Build system and examples for running C code on the Wii U
* [coova/coova-chilli](https://github.com/coova/coova-chilli) - CoovaChilli is an open-source software access controller for captive portal hotspots.
* [LibVNC/libvncserver](https://github.com/LibVNC/libvncserver) - LibVNCServer/LibVNCClient are cross-platform C libraries that allow you to easily implement VNC server or client functionality in your program.
* [zedshaw/liblcthw](https://github.com/zedshaw/liblcthw) - The library you create when you are done with Learn C The Hard Way
* [stevedekorte/coroutine](https://github.com/stevedekorte/coroutine) - C multiplatform coroutine implementation via ucontext, fibers or setjmp.
* [jbremer/darm](https://github.com/jbremer/darm) - A light-weight and efficient disassembler written in C for the ARMv7 instruction set.
* [cioc/functionalC](https://github.com/cioc/functionalC) - Not because it is good, but because we can...
* [huxingyi/libphone](https://github.com/huxingyi/libphone) - Cross-platform library supports iOS/Android development in C language
* [mikeryan/crackle](https://github.com/mikeryan/crackle) - Crack and decrypt BLE encryption
* [kwgoodman/bottleneck](https://github.com/kwgoodman/bottleneck) - Fast NumPy array functions written in C
* [wdas/partio](https://github.com/wdas/partio) - C++ (with python bindings) library for easily reading/writing/manipulating common animation particle formats such as PDB, BGEO, PTC.   See the discussion group @ http://groups.google.com/group/partio-discuss
* [saelo/cve-2014-0038](https://github.com/saelo/cve-2014-0038) - Linux local root exploit for CVE-2014-0038
* [frida/frida-core](https://github.com/frida/frida-core) - Frida core library intended for static linking into bindings
* [charybdis-ircd/charybdis](https://github.com/charybdis-ircd/charybdis) - Scalable IRCv3.2 server for large, community-oriented networks
* [wangkuiwu/datastructs_and_algorithm](https://github.com/wangkuiwu/datastructs_and_algorithm) - Data struct and algorithm introduction and implementation in C/C++/Java.
* [thvdburgt/KnR-The-C-Programming-Language-Solutions](https://github.com/thvdburgt/KnR-The-C-Programming-Language-Solutions) - My solutions to the exercises in the book "The C Programming Language" (2nd edition) by Brian W. Kernighan and Dennis M. Ritchie, also referred to as K&R.
* [pysam-developers/pysam](https://github.com/pysam-developers/pysam) - Pysam is a python module for reading and manipulating Samfiles. It's a lightweight wrapper of the samtools C-API. Pysam also includes an interface for tabix.
* [limingth/NCCL](https://github.com/limingth/NCCL) - New Concept C Language
* [cnlohr/colorchord](https://github.com/cnlohr/colorchord) - Chromatic Sound to Light Conversion System
* [ChibiOS/ChibiOS](https://github.com/ChibiOS/ChibiOS) - Read only mirror of SVN ChibiOS repository. Official forum http://forum.chibios.org  Bugtracker http://sourceforge.net/projects/chibios
* [acmeism/RosettaCodeData](https://github.com/acmeism/RosettaCodeData) - RosettaCode Data Project
* [antirez/lua-cmsgpack](https://github.com/antirez/lua-cmsgpack) - A self contained Lua MessagePack C implementation.
* [maxmind/geoip-api-c](https://github.com/maxmind/geoip-api-c) - GeoIP Legacy C API
* [kelly/node-i2c](https://github.com/kelly/node-i2c) - Node.js native bindings for i2c-dev. Plays well with Raspberry Pi and Beaglebone.
* [begeekmyfriend/CuckooFilter](https://github.com/begeekmyfriend/CuckooFilter) - Substitute for bloom filter.
* [phonegap/phonegap-plugin-contentsync](https://github.com/phonegap/phonegap-plugin-contentsync) - Download and cache remotely hosted content
* [cesanta/frozen](https://github.com/cesanta/frozen) - JSON parser and generator for C/C++ with scanf/printf like interface. Targeting embedded systems.
* [vincenthz/libjson](https://github.com/vincenthz/libjson) - a JSON parser and printer library in C. easy to integrate with any model.
* [lemire/simdcomp](https://github.com/lemire/simdcomp) - A simple C library for compressing lists of integers using binary packing
* [grahamking/Key-Value-Polyglot](https://github.com/grahamking/Key-Value-Polyglot) - A basic key-value store, repeated in C, Go, Python (basic, gevent, and diesel), Ruby (event machine), Java, Scala, Haskell, and NodeJS.
* [wkoszek/cpu60](https://github.com/wkoszek/cpu60) - Example of CPU simulation in software
* [mkottman/acpi_call](https://github.com/mkottman/acpi_call) - A linux kernel module that enables calls to ACPI methods through /proc/acpi/call. Now with support for Integer, String and Buffer parameters.
* [macmade/ClangKit](https://github.com/macmade/ClangKit) - ClangKit provides an Objective-C frontend to LibClang. Source tokenization, diagnostics and fix-its are actually implemented.
* [citusdata/pg_cron](https://github.com/citusdata/pg_cron) - Run periodic jobs in PostgreSQL
* [agl/curve25519-donna](https://github.com/agl/curve25519-donna) - Implementations of a fast Elliptic-curve Diffie-Hellman primitive
* [abiggerhammer/hammer](https://github.com/abiggerhammer/hammer) - Parser combinators for binary formats, in C. Yes, in C. What? Don't look at me like that.
* [martincohen/Punity](https://github.com/martincohen/Punity) - A tiny game engine in C.
* [libtom/libtommath](https://github.com/libtom/libtommath) - LibTomMath is a free open source portable number theoretic multiple-precision integer library written entirely in C.
* [gcesarmza/curl-android-ios](https://github.com/gcesarmza/curl-android-ios) - Static libcurl to be used in Android and iOS apps. Build scripts included. No Android source required
* [darius/ichbins](https://github.com/darius/ichbins) - A tiny self-hosting Lisp-to-C compiler
* [armink/EasyLogger](https://github.com/armink/EasyLogger) - A ultra-lightweight(ROM<1.6K, RAM<0.3k), high-performance C/C++ log library. | 一款超轻量级(ROM<1.6K, RAM<0.3k)、高性能的 C/C++ 日志库
* [andikleen/snappy-c](https://github.com/andikleen/snappy-c) - C port of the snappy compressor
* [benmills/robotskirt](https://github.com/benmills/robotskirt) - A node wrapper for the awesome C markdown parser, sundown.
* [lp/ObjCHiredis](https://github.com/lp/ObjCHiredis) - Hiredis with Objective-C Interface
* [zedshaw/learn-c-the-hard-way-lectures](https://github.com/zedshaw/learn-c-the-hard-way-lectures) - All of the code from Learn C The Hard Way, each project, plus the presentation slides used in the videos.
* [wukezhan/air](https://github.com/wukezhan/air) - a high performance, lightweight framework for php5 & php7 written in c 🚀🚀🚀
* [mtodd/geoip](https://github.com/mtodd/geoip) - Ruby C binding to Maxmind GeoIP Library
* [HBehrens/obj2opengl](https://github.com/HBehrens/obj2opengl) - script to convert 3D models of OBJ files to C/C++ float arrays (vertices, faces, texture) compatible with OpenGL ES glDrawArrays compatible with iPhone/iPad
* [graphitemaster/lambdapp](https://github.com/graphitemaster/lambdapp) - Anonymous functions in C
* [programmingthomas/ObjectiveGumbo](https://github.com/programmingthomas/ObjectiveGumbo) - An Objective-C wrapper with utility functions around Gumbo for easy HTML5 parsing in Cocoa and Cocoa Touch
* [madhur/android-chat-starter](https://github.com/madhur/android-chat-starter) - A starter project for Android chat application
* [JuliaLang/utf8proc](https://github.com/JuliaLang/utf8proc) - a clean C library for processing UTF-8 Unicode data
* [google/capsicum-linux](https://github.com/google/capsicum-linux) - Linux kernel with Capsicum support
* [cinder/Cinder-Kinect](https://github.com/cinder/Cinder-Kinect) - Kinect support for Cinder
* [tyler/Bogart](https://github.com/tyler/Bogart) - It's like Sinatra... in C.
* [skeeto/interactive-c-demo](https://github.com/skeeto/interactive-c-demo) - Demonstration of interactive C programming
* [rayh/kvo-block-binding](https://github.com/rayh/kvo-block-binding) - Use blocks to observe Objective-C properties using KVO
* [Overv/OOGL](https://github.com/Overv/OOGL) - Object-oriented C++ wrapper for OpenGL.
* [xorg62/tty-clock](https://github.com/xorg62/tty-clock) - analog clock in ncurses
* [pornel/dssim](https://github.com/pornel/dssim) - DSSIM C implementation (with a Rust API)
* [fanchy/fflib](https://github.com/fanchy/fflib) - FFLib is a lightweight c++ framework.FFlib is mainly designed for game server developing. But some components in FFLib is in common use. For example socket&net module, log module, thread&lock, tools for performance & memory leak check.用于分布式程序的c++类库，封装了socket、rpc、lua、CQRS框架、算法等组件，适于SNS、WEBGAME、MMO后台程序， about C++,linux socket,lua,rpc,broker,cqrs,timer,log libary
* [guaxiao/renderer.gua](https://github.com/guaxiao/renderer.gua) - Software 3D Renderer in C++ on Windows, OSX and Linux or other popular flavors of Unix that SDL supports
* [clibs/commander](https://github.com/clibs/commander) - Commander option parser ported to C - simple API, auto-generated --help
* [igrr/esptool-ck](https://github.com/igrr/esptool-ck) - The ESP8266/ESP32 build helper tool by Christian Klippel
* [CANBus-Triple/CANBus-Triple](https://github.com/CANBus-Triple/CANBus-Triple) - CANBus Triple – The car hacking platform
* [apple/cups](https://github.com/apple/cups) - Official CUPS Sources
* [happyfish100/libfastcommon](https://github.com/happyfish100/libfastcommon) - c common functions library extracted from my open source project FastDFS. this library is very simple and stable.  functions including: string, logger, chain, hash, socket, ini file reader, base64 encode / decode, url encode / decode, fast timer, skiplist, object pool etc. detail info please see the c header files.
* [dbro/csvquote](https://github.com/dbro/csvquote) - Enables common unix utlities like cut, head, tail to work correctly with csv data containing delimiters and newlines
* [StarfruitStack/guava](https://github.com/StarfruitStack/guava) - Guava is a lightweight Python web framework written in C
* [PeterScott/murmur3](https://github.com/PeterScott/murmur3) - Murmur3 hash in C
* [coreboot/coreboot](https://github.com/coreboot/coreboot) - github mirror of coreboot.org's master repository
* [troydhanson/tpl](https://github.com/troydhanson/tpl) - tpl - a small binary serialization library for C
* [kitsune-dsu/kitsune-core](https://github.com/kitsune-dsu/kitsune-core) - Kitsune runtime, driver, ktcc, xfgen, documentation, and test suite.
* [JHUISI/charm](https://github.com/JHUISI/charm) - Charm: A Framework for Rapidly Prototyping Cryptosystems
* [Crazepony/crazepony-firmware-none](https://github.com/Crazepony/crazepony-firmware-none) - Crazepony flight control source code with no RTOS.
* [PhilZ-cwm6/philz_touch_cwm6](https://github.com/PhilZ-cwm6/philz_touch_cwm6) - PhilZ Touch (cwm based recovery)
* [cyassl/cyassl](https://github.com/cyassl/cyassl) - Please use wolfSSL now instead: https://github.com/wolfSSL/wolfssl . CyaSSL is a small, fast, portable implementation of TLS/SSL for embedded devices to the cloud.
* [coreutils/coreutils](https://github.com/coreutils/coreutils) - Upstream mirror
* [jgarzik/picocoin](https://github.com/jgarzik/picocoin) - A bitcoin library in C, SPV wallet & more.
* [gurnec/HashCheck](https://github.com/gurnec/HashCheck) - HashCheck Shell Extension for Windows with added SHA2, SHA3, and multithreading; originally from code.kliu.org
* [chmduquesne/sharebox-fs](https://github.com/chmduquesne/sharebox-fs) - C rewrite of sharebox
* [koanlogic/libu](https://github.com/koanlogic/libu) - LibU is a multiplatform utility library written in C, with APIs for handling memory allocation, networking and URI parsing, string manipulation, debugging, and logging in a very compact way, plus many other miscellaneous tasks
* [swenson/sort](https://github.com/swenson/sort) - Sorting routine implementations in "template" C
* [satellogic/canopus](https://github.com/satellogic/canopus) - Canopus framework and flight computer software for CubeBug cubesat platform
* [earthquake/chw00t](https://github.com/earthquake/chw00t) - chw00t - Unices chroot breaking tool
* [bashrc/libdeep](https://github.com/bashrc/libdeep) - A deep learning library for C/C++
* [TTimo/es_core](https://github.com/TTimo/es_core) - An experimental framework for low latency, high fps multiplayer games
* [petewarden/c_hashmap](https://github.com/petewarden/c_hashmap) - A simple string hashmap in C
* [todbot/arduino-serial](https://github.com/todbot/arduino-serial) - Example C and Java host code to talking to an arduino or other "serial" device
* [sheredom/utf8.h](https://github.com/sheredom/utf8.h) - single header utf8 string functions for C and C++
* [nil-zhang/php-beanstalk](https://github.com/nil-zhang/php-beanstalk) - A php c extension beanstalkd client, multi-server support, high performance, using libbeanstalkclient.
* [redjack/varon-t](https://github.com/redjack/varon-t) - C implementation of Disruptor queues
* [galkahana/PDF-Writer](https://github.com/galkahana/PDF-Writer) - High performance library for creating, modiyfing and parsing PDF files in C++
* [siu/minunit](https://github.com/siu/minunit) - Minimal unit testing framework for C
* [sahib/glyr](https://github.com/sahib/glyr) - Glyr is a music related metadata searchengine, both with commandline interface and C API
* [redjack/libcork](https://github.com/redjack/libcork) - A simple, easily embeddable cross-platform C library
* [neurodroid/cryptonite](https://github.com/neurodroid/cryptonite) - EncFS and TrueCrypt on Android
* [mingzhao/dm-cache](https://github.com/mingzhao/dm-cache) - Generic block-level cache utility based on Linux device mapper framework
* [mental/bloopsaphone](https://github.com/mental/bloopsaphone) - arcade sounds and chiptunes for ruby and c
* [MauriceGit/XBox_Controller_Linux_Interface](https://github.com/MauriceGit/XBox_Controller_Linux_Interface) - An interface that interacts with an XBox One controller via the usb stream. With simple methods for object or camera control (i.e. for OpenGL contexts).
* [Kurento/kms-core](https://github.com/Kurento/kms-core) - Core library of Kurento Media Server
* [dovecot/core](https://github.com/dovecot/core) - Dovecot mail server
* [arnaudbrejeon/cspec](https://github.com/arnaudbrejeon/cspec) - Behavior driven development in C
* [wbhart/Cesium3](https://github.com/wbhart/Cesium3) - Fast interpreter with macros, local type inference, LLVM backend.
* [WiringPi/WiringPi-Ruby-Legacy](https://github.com/WiringPi/WiringPi-Ruby-Legacy) - Ruby gem of the Arduino wiring-like C library WiringPi
* [PaulStoffregen/cores](https://github.com/PaulStoffregen/cores) - Teensy Core Libraries for Arduino
* [kmussel/Moment](https://github.com/kmussel/Moment) - Natural Language Date Parser Using Lex/Yacc/C
* [editorconfig/editorconfig-core-c](https://github.com/editorconfig/editorconfig-core-c) - EditorConfig core library written in C (for use by plugins supporting EditorConfig parsing)
* [graphitemaster/incbin](https://github.com/graphitemaster/incbin) - Include binary files in C/C++
* [felis/Arduino_Camera_Control](https://github.com/felis/Arduino_Camera_Control) - PTP, Camera-specific layers to work with Arduino USB Host Shield
* [jgh-/FFmpeg-for-iOS](https://github.com/jgh-/FFmpeg-for-iOS) - [C/Obj-C] FFmpeg for iOS using OpenGLES and AudioQueues instead of SDL.
* [gwik/ffmpeg-ruby](https://github.com/gwik/ffmpeg-ruby) - Ruby interface to the ffmpeg C library. It is able to extract images from videos but do not allow to encode full video.
* [Juniper/contrail-vrouter](https://github.com/Juniper/contrail-vrouter) - Contrail Virtual Router
* [josephg/librope](https://github.com/josephg/librope) - UTF-8 rope library for C
* [stubma/WiEngine](https://github.com/stubma/WiEngine) - C++ implemented, cocos2d like cross-platform game engine
* [shenfeng/tiny-web-server](https://github.com/shenfeng/tiny-web-server) - a tiny web server in C, for daily use.
* [richgel999/miniz](https://github.com/richgel999/miniz) - miniz: Single C source file zlib-replacement library, originally from code.google.com/p/miniz
* [MobileChromeApps/cordova-plugin-zip](https://github.com/MobileChromeApps/cordova-plugin-zip) - Zip plugin for Cordova apps
* [kristapsdz/acme-client](https://github.com/kristapsdz/acme-client) - secure Let's Encrypt client
* [zhemao/libds](https://github.com/zhemao/libds) - Simple, memory-safe data-structures in C.
* [vmg/crustache](https://github.com/vmg/crustache) - The templating engine which may explode right under your nose
* [lichuang/qnode](https://github.com/lichuang/qnode) - qnode(cute node) - C + Lua + Actor Model = Erlang-like system
* [cxong/cdogs-sdl](https://github.com/cxong/cdogs-sdl) - Classic overhead run-and-gun game
* [Temptin/SkypeExport](https://github.com/Temptin/SkypeExport) - Cross-platform Skype history exporter written in C++. Very fast. Spits out beautiful, completely self-contained HTML pages that don't require any extra files.
* [bl0ckeduser/new-bpf-tools](https://github.com/bl0ckeduser/new-bpf-tools) - subset-of-C compiler targeting 32-bit x86
* [BennyQBD/3DEngineCpp](https://github.com/BennyQBD/3DEngineCpp) - It's like the 3D Game Engine, except in C++
* [ObKo/stm32-cmake](https://github.com/ObKo/stm32-cmake) - CMake for stm32 developing.
* [mirek/CoreWebSocket](https://github.com/mirek/CoreWebSocket) - Web Socket Server and Client Library for iOS and OSX. Follows Core Foundation API style.
* [mid-kid/CakesForeveryWan](https://github.com/mid-kid/CakesForeveryWan) - A CFW for the 3DS.
* [jedwing/CHMLib](https://github.com/jedwing/CHMLib) - Library for reading Microsoft ITSS/CHM format files.
* [CastXML/CastXML](https://github.com/CastXML/CastXML) - C-family Abstract Syntax Tree XML Output
* [camgunz/cmp](https://github.com/camgunz/cmp) - An implementation of the MessagePack serialization format in C / msgpack.org[C]
* [mm2/Little-CMS](https://github.com/mm2/Little-CMS) - A free, open source, CMM engine. It provides fast transforms between ICC profiles.
* [limccn/Cocoa-Charts](https://github.com/limccn/Cocoa-Charts) - Open-source iPhone/iPad graph/chart framework includes line chart,stick chart,candlestick chart,pie chart,spider-web chart etc. Based on iOS graph SDK, Using native Objective-c Codes
* [WizardMac/ReadStat](https://github.com/WizardMac/ReadStat) - Command-line tool (+ C library) for converting SAS, Stata, and SPSS files
* [stevedekorte/basekit](https://github.com/stevedekorte/basekit) - C based OO portable data structure library
* [miracl/MIRACL](https://github.com/miracl/MIRACL) - MIRACL Cryptographic SDK: Multiprecision Integer and Rational Arithmetic Cryptographic Library is a C software library that is widely regarded by developers as the gold standard open source SDK for elliptic curve cryptography (ECC).
* [emptyhua/baidu_pcs_cli](https://github.com/emptyhua/baidu_pcs_cli) - 百度个人云存储API命令行工具
* [charleyw/cordova-plugin-alipay](https://github.com/charleyw/cordova-plugin-alipay) - Cordova支付宝插件，cordova alipay plugin
* [Yubico/libu2f-host](https://github.com/Yubico/libu2f-host) - Yubico Universal 2nd Factor (U2F) Host C Library
* [island-org/island](https://github.com/island-org/island) - Lightweight and low-level creative coding toolkits in C.
* [derekmolloy/boneCV](https://github.com/derekmolloy/boneCV) - Beaglebone Webcam and OpenCV Examples Repository
* [cadwallion/spinel](https://github.com/cadwallion/spinel) - A free and open source game engine using mruby and C/C++
* [styxyang/dnsmasq-chinadns](https://github.com/styxyang/dnsmasq-chinadns) - A patched version of dnsmasq which filters out some spurious IP
* [openworm/sibernetic](https://github.com/openworm/sibernetic) - This is a C++/OpenCL implementation of the PCISPH algorithm supplemented with a set of biomechanics simulations related features applied to C. elegans locomotion
* [openjudge/sandbox](https://github.com/openjudge/sandbox) - The sandbox libraries (libsandbox & pysandbox) are an open-source suite of software components for C/C++ and Python developers to create automated profiling tools and watchdog programs. The API's are designed for executing and instrumenting simple (single process) tasks, featuring policy-based behavioral auditing, resource quota, and statistics collecting.
* [NuxiNL/cloudlibc](https://github.com/NuxiNL/cloudlibc) - CloudABI's standard C library
* [a-nikolaev/curseofwar](https://github.com/a-nikolaev/curseofwar) - A Real Time Strategy game for Linux.
* [orangeduck/LuaAutoC](https://github.com/orangeduck/LuaAutoC) - Automagically use C Functions and Structs with the Lua API
* [libcheck/check](https://github.com/libcheck/check) - A unit testing framework for C
* [frobware/cmd-key-happy](https://github.com/frobware/cmd-key-happy) - Swap cmd and alt keys in Terminal
* [compiler-dept/speck](https://github.com/compiler-dept/speck) - A small unit testing framework for C
* [yotamr/traces](https://github.com/yotamr/traces) - API tracing framework for Linux C/C++ applications
* [xant/libhl](https://github.com/xant/libhl) - Simple and fast C library implementing a thread-safe API to manage hash-tables, linked lists, lock-free ring buffers and queues
* [jmcnamara/libxlsxwriter](https://github.com/jmcnamara/libxlsxwriter) - A C library for creating Excel XLSX files.
* [gdbinit/onyx-the-black-cat](https://github.com/gdbinit/onyx-the-black-cat) - Kernel extension to disable anti-debug tricks and other useful XNU "features"
* [aharren/LibComponentLogging-Core](https://github.com/aharren/LibComponentLogging-Core) - A small logging library for Objective-C applications (Mac OS X and iPhone OS/iOS) which provides conditional logging based on log levels and log components. Additionally, different logging strategies can be used, e.g. writing log messages to a file or sending them to the system log, while using the same logging interface.
* [lucasb-eyer/heatmap](https://github.com/lucasb-eyer/heatmap) - High performance C heatmap generation library. Supposed to be wrapped by higher-level languages.
* [cuckoosandbox/cuckoomon](https://github.com/cuckoosandbox/cuckoomon) - DEPRECATED - replaced with "monitor"
* [tsuraan/Jerasure](https://github.com/tsuraan/Jerasure) - Github repo for Jerasure Library - C Implementation of Reed-Solomon coding
* [ruby/curses](https://github.com/ruby/curses) - Ruby binding for curses, ncurses, and PDCurses.  Formerly part of the ruby standard library.
* [HaxeFoundation/hxcpp](https://github.com/HaxeFoundation/hxcpp) - Runtime files for c++ backend for haxe
* [bananita/MBFaker](https://github.com/bananita/MBFaker) - Objective-C fake data generator
* [wengkai/ACLLib](https://github.com/wengkai/ACLLib) - ACLLib is a bunch of C functions covers Win32API and provides simpler API to beginners for programming Windows GUI applications. It compiles with MinGW and MS Visual Studio Express
* [pyknite/catwm](https://github.com/pyknite/catwm) - catwm is a very simple tiling window manager
* [apache/incubator-mynewt-core](https://github.com/apache/incubator-mynewt-core) - Mirror of Apache MyNewt Core (Incubating)
* [anael-seghezzi/CToy](https://github.com/anael-seghezzi/CToy) - C live-coding environment
* [trailofbits/cb-multios](https://github.com/trailofbits/cb-multios) - DARPA Challenges Binaries for Linux, Windows, and OS X
* [tpoechtrager/cctools-port](https://github.com/tpoechtrager/cctools-port) - Apple cctools port for Linux, *BSD and Windows (Cygwin)
* [payden/libwebsock](https://github.com/payden/libwebsock) - C library for easy WebSockets server.
* [methodmissing/rbczmq](https://github.com/methodmissing/rbczmq) - Ruby extension that wraps the official high level ZeroMQ C API ( http://czmq.zeromq.org/ )
* [licstar/compare](https://github.com/licstar/compare) - compare embedding
* [jonmarimba/OpenCV-iOS](https://github.com/jonmarimba/OpenCV-iOS) - OpenCV Xcode project for iOS build
* [gosexy/canvas](https://github.com/gosexy/canvas) - Image manipulation library based on ImageMagick's MagickWand, for Go.
* [retuxx/tinyspline](https://github.com/retuxx/tinyspline) - ANSI C library for NURBS, B-Splines and Bézier curves with wrappers for C++11, C#, Java, Python, and Ruby
* [it4e/CHL](https://github.com/it4e/CHL) - C Hypertext Library - A library for writing web applications in C
* [happykevins/cocos2dx-ext](https://github.com/happykevins/cocos2dx-ext) - Extensions for Cocos2dx: Dynamic Font Management, HTML Widget, Powerful Asset Management...
* [H2CO3/libsprec](https://github.com/H2CO3/libsprec) - C library for speech recognition using the Google Speech API
* [cudpp/cudpp](https://github.com/cudpp/cudpp) - CUDA Data Parallel Primitives Library
* [Tangent128/luasdl2](https://github.com/Tangent128/luasdl2) - A pure C binding of SDL 2.0 for Lua 5.1, Lua 5.2, and LuaJIT.
* [mabl/ChibiOS](https://github.com/mabl/ChibiOS) - Mirror of the ChibiOS SVN repository (updated every 10 minutes)
* [hit9/todo.c](https://github.com/hit9/todo.c) - Command line lightweight todo tool with readable storage , written in C.
* [zorgnax/libtap](https://github.com/zorgnax/libtap) - Write tests in C
* [timburks/NuMongoDB](https://github.com/timburks/NuMongoDB) - An Objective-C interface to MongoDB for use with Nu
* [siddontang/libtnet](https://github.com/siddontang/libtnet) - libtnet is a tiny high performance c++ network lib, like tornado
* [pritambaral/hostapd-rtl871xdrv](https://github.com/pritambaral/hostapd-rtl871xdrv) - Hostapd driver for RTL8188{C|CU|CUS} wifi chips.
* [lthiery/SPI-Py](https://github.com/lthiery/SPI-Py) - Hardware SPI as a C Extension for Python
* [GHamrouni/Recommender](https://github.com/GHamrouni/Recommender) - A C library for product recommendations/suggestions using collaborative filtering (CF)
* [FuruyamaTakeshi/DLNA](https://github.com/FuruyamaTakeshi/DLNA) - DLNA  sample code using CyberLink Objective-C Wrapper. This sample can browse contents from DMS and play content at DMR.
* [Ruslan-B/FFmpeg.AutoGen](https://github.com/Ruslan-B/FFmpeg.AutoGen) - FFmpeg auto generated unsafe bindings for C#/.NET and Mono.
* [rampantpixels/foundation_lib](https://github.com/rampantpixels/foundation_lib) - Cross-platform public domain foundation library in C providing basic support data types and functions to write applications and games in a platform-independent fashion.
* [lc-soft/LCUI](https://github.com/lc-soft/LCUI) - A simple GUI library, it is written in C, support XML and CSS.
* [harbour/core](https://github.com/harbour/core) - Portable, xBase compatible programming language and environment
* [ginsweater/gif-h](https://github.com/ginsweater/gif-h) - Simple C++ one-header library for the creation of animated GIFs from image data.
* [burke/monkeysupport](https://github.com/burke/monkeysupport) - [abandoned] C extensions monkeypatching ActiveSupport for improved perfomance
* [sonyxperiadev/kernel-copyleft](https://github.com/sonyxperiadev/kernel-copyleft) - Copyleft archives for Xperia kernels
* [cisco-system-traffic-generator/trex-core](https://github.com/cisco-system-traffic-generator/trex-core) - trex-core site
* [zupet/LuaTinker](https://github.com/zupet/LuaTinker) - LUA to C++ Binding Library
* [cvxgrp/scs](https://github.com/cvxgrp/scs) - C package that solves convex cone problems via operator splitting
* [b-k/21st-Century-Examples](https://github.com/b-k/21st-Century-Examples) - Examples for _21st Century C_ by Ben Klemens
* [tpoindex/crobots](https://github.com/tpoindex/crobots) - CROBOTS is a programming game, for programmers (or aspiring programmers.)
* [stevedekorte/skipdb](https://github.com/stevedekorte/skipdb) - C based ordered key-value ACID DB using skiplist datastructure.
* [kuapay/iOS-QR-Code-Generator](https://github.com/kuapay/iOS-QR-Code-Generator) - This Xcode 4 project is put together as a template to create 2D QR codes within your iPhone code.
* [joewalnes/tinytest](https://github.com/joewalnes/tinytest) - A tiny unit-testing framework for C
* [jacob-carlborg/dstep](https://github.com/jacob-carlborg/dstep) - A tool for converting C and Objective-C headers to D modules
* [davidsblog/rCPU](https://github.com/davidsblog/rCPU) - Remote CPU monitoring webserver
* [gingerBill/gb](https://github.com/gingerBill/gb) - gb single-file public domain libraries for C & C++
* [encog/encog-c](https://github.com/encog/encog-c) - The Encog project for C/C++
* [cypresssemiconductorco/PSoC-4-BLE](https://github.com/cypresssemiconductorco/PSoC-4-BLE) - PSoC 4 BLE is an easy-to-use, ARM® Cortex™-M0 based, single-chip solution which integrates programmable analog front ends, programmable digital peripherals, CapSense® technology for touch-sensing, and a Bluetooth® LE (Low Energy) or Bluetooth Smart radio.
* [confluentinc/confluent-kafka-python](https://github.com/confluentinc/confluent-kafka-python) - Confluent's Apache Kafka Python client
* [clibs/list](https://github.com/clibs/list) - C doubly linked list
* [moonlight-stream/moonlight-chrome](https://github.com/moonlight-stream/moonlight-chrome) - GameStream client for Chrome
* [lqez/npk](https://github.com/lqez/npk) - neat package system written in C
* [jbaiter/jpegtran-cffi](https://github.com/jbaiter/jpegtran-cffi) - Fast, (mostly) lossless JPEG transformations with Python
* [inspirit/CaptureDevice](https://github.com/inspirit/CaptureDevice) - Adobe Air Native Extension for video capturing from cameras
* [gilbo/cork](https://github.com/gilbo/cork) - 3D Boolean / CSG Library
* [boazsegev/c-server-tools](https://github.com/boazsegev/c-server-tools) - Write network services in C using dynamic protocols such as HTTP and Websockets
* [trezor/trezor-crypto](https://github.com/trezor/trezor-crypto) - :orange_book: Heavily optimized cryptography algorithms for embedded devices.
* [jeremy-w/objc-zmq](https://github.com/jeremy-w/objc-zmq) - Objective-C binding for ZeroMQ.
* [b-k/apophenia](https://github.com/b-k/apophenia) - A C library for statistical and scientific computing
* [ali-rantakari/peg-markdown-highlight](https://github.com/ali-rantakari/peg-markdown-highlight) - C library for Markdown syntax highlighting, using a recursive-descent parser.
* [tbuktu/libntru](https://github.com/tbuktu/libntru) - C Implementation of NTRUEncrypt
* [roboterclubaachen/xpcc](https://github.com/roboterclubaachen/xpcc) - The C++ microcontroller framework xpcc
* [llvm-mirror/compiler-rt](https://github.com/llvm-mirror/compiler-rt) - Mirror of official compiler-rt git repository located at http://llvm.org/git/compiler-rt.  Updated every five minutes.
* [drh/cii](https://github.com/drh/cii) - C Interfaces and Implementations
* [celery/librabbitmq](https://github.com/celery/librabbitmq) - Python bindings to librabbitmq-c
* [Amaury/FineDB](https://github.com/Amaury/FineDB) - High-performance nosql database. Written in C, multi-threaded, based on LightningDB and nanomsg.
* [PetteriAimonen/libfixmatrix](https://github.com/PetteriAimonen/libfixmatrix) - C library for fixed point matrix, quaternion and vector calculations
* [mitghi/lfqueue](https://github.com/mitghi/lfqueue) - Simple Lock-Free Queue implemented in C
* [gentilkiwi/kekeo](https://github.com/gentilkiwi/kekeo) - A little toolbox to play with Microsoft Kerberos in C
* [fabianishere/brainfuck](https://github.com/fabianishere/brainfuck) - Brainfuck interpreter written in C.
* [samrushing/irken-compiler](https://github.com/samrushing/irken-compiler) - Irken is a statically typed variant of Scheme.  Or a lisp-like variant of ML.
* [romanbsd/fast-stemmer](https://github.com/romanbsd/fast-stemmer) - Fast Porter stemmer based on a C version of the algorithm
* [moonpolysoft/cherly](https://github.com/moonpolysoft/cherly) - Cherly (sher-lee) is an in-VM caching library for Erlang.
* [DoubleSpout/ifile](https://github.com/DoubleSpout/ifile) - High performance nodejs http/https static file handler,using c++ addon and libuv lib
* [Chadderz121/csud](https://github.com/Chadderz121/csud) - Chadderz's Simple USB Driver for Raspberry Pi
* [seanmiddleditch/libtelnet](https://github.com/seanmiddleditch/libtelnet) - Simple RFC-complient TELNET implementation as a C library.
* [martinh/libconfuse](https://github.com/martinh/libconfuse) - Small configuration file parser library for C.
* [linklayer/cantact-fw](https://github.com/linklayer/cantact-fw) - Firmware source files for the CANtact tool
* [kylemcdonald/ofxCcv](https://github.com/kylemcdonald/ofxCcv) - libccv addon for openFrameworks
* [dxjia/ffmpeg-compile-shared-library-for-android](https://github.com/dxjia/ffmpeg-compile-shared-library-for-android) - 移植ffmpeg到android，编译可用于jni调用的so库.
* [dropbox/miniutf](https://github.com/dropbox/miniutf) - A C++ library for basic Unicode manipulation.
* [malbrain/Btree-source-code](https://github.com/malbrain/Btree-source-code) - A working project for High-concurrency B-tree source code in C
* [ixty/xarch_shellcode](https://github.com/ixty/xarch_shellcode) - Cross Architecture Shellcode in C
* [imneme/pcg-c](https://github.com/imneme/pcg-c) - PCG — C Implementation
* [dvidelabs/flatcc](https://github.com/dvidelabs/flatcc) - FlatBuffers Compiler and Library in C for C
* [dmw/caffeine](https://github.com/dmw/caffeine) - C Application Framework
* [ysboss/tinyhttpd](https://github.com/ysboss/tinyhttpd) - tinyhttpd是一个超轻量型Http Server，使用C语言开发，全部代码只有502行(包括注释)，附带一个简单的Client，可以通过阅读这段代码理解一个 Http Server 的本质。
* [sheredom/json.h](https://github.com/sheredom/json.h) - json parser for C and C++
* [radareorg/r2con](https://github.com/radareorg/r2con) - Radare Congress Stuff
* [noporpoise/BitArray](https://github.com/noporpoise/BitArray) - C bit array structs and methods
* [nasa/XPlaneConnect](https://github.com/nasa/XPlaneConnect) - The X-Plane Communications Toolbox is a research tool used to interact with the X-Plane flight simulator
* [MatthewLM/cbitcoin](https://github.com/MatthewLM/cbitcoin) - A low-level bitcoin library written in standard C.
* [HIPS/Probabilistic-Backpropagation](https://github.com/HIPS/Probabilistic-Backpropagation) - Implementation in C and Theano of the method Probabilistic Backpropagation for scalable Bayesian inference in deep neural networks.
* [FRiCKLE/ngx_slowfs_cache](https://github.com/FRiCKLE/ngx_slowfs_cache) - nginx module which adds ability to cache static files.
* [processone/oneteam](https://github.com/processone/oneteam) - OneTeam XMPP multi-platform client. This is a Mozilla / XUL based platform, developed mostly in Javascript and C++ XPCOM.
* [mattt/MsgPackSerialization](https://github.com/mattt/MsgPackSerialization) - MsgPack Serialization for Objective-C
* [clibs/buffer](https://github.com/clibs/buffer) - Tiny C string library
* [vtudose/Let-s-build-a-compiler](https://github.com/vtudose/Let-s-build-a-compiler) - A C version of the Let's Build a Compiler, by Jack Crenshaw
* [monkey/duda](https://github.com/monkey/duda) - Duda I/O is an event-driven and high performant web services framework which exposes a friendly C API
* [mhroth/tinyosc](https://github.com/mhroth/tinyosc) - A minimal Open Sound Control (OSC) library written in vanilla C.
* [i-saint/DynamicPatcher](https://github.com/i-saint/DynamicPatcher) - Runtime C++ Editing
* [fi01/CVE-2015-3636](https://github.com/fi01/CVE-2015-3636) - PoC code for 32 bit Android OS
* [bwilcox-1234/ChatScript](https://github.com/bwilcox-1234/ChatScript) - Natural Language tool/dialog manager
* [0xmalloc/c-log](https://github.com/0xmalloc/c-log) - a fast ,stable and thread-safe log lib(logger) for C/C++ language
* [wenjun1055/c](https://github.com/wenjun1055/c) - C语言学习代码
* [Vidvox/hap-qt-codec](https://github.com/Vidvox/hap-qt-codec) - A QuickTime codec for Hap video
* [psychs/cocoaoniguruma](https://github.com/psychs/cocoaoniguruma) - Objective-C binding of Oniguruma regular expression engine
* [philburk/pforth](https://github.com/philburk/pforth) - Portable Forth in C
* [deep011/redis-cluster-tool](https://github.com/deep011/redis-cluster-tool) - A convenient and useful tool for redis cluster.
* [cornet/ccze](https://github.com/cornet/ccze) - ccze
* [colmap/colmap](https://github.com/colmap/colmap) - COLMAP - Structure-from-Motion and Multi-View Stereo
* [bagder/spindly](https://github.com/bagder/spindly) - a portable C library for SPDY transport (DEAD project!)
* [adobkin/libcapn](https://github.com/adobkin/libcapn) - A simple C Library for interact with the Apple Push Notification Service (APNs)
* [vjeux/jspp](https://github.com/vjeux/jspp) - C++ shaped into Javascript
* [mhogomchungu/zuluCrypt](https://github.com/mhogomchungu/zuluCrypt) - zuluCrypt is a front end to cryptsetup and tcplay and it allows easy management of encrypted block devices
* [jtauber/cleese](https://github.com/jtauber/cleese) - an operating system in Python
* [iskra/jsonx](https://github.com/iskra/jsonx) - JSONX is an Erlang library for efficient decode and encode JSON, written in C.
* [couchbase/couchbase-ruby-client](https://github.com/couchbase/couchbase-ruby-client) - Couchbase Ruby client library (official) built atop libcouchbase
* [cbuchner1/ccminer](https://github.com/cbuchner1/ccminer) - Christian Buchner's & Christian H.'s CUDA miner project
* [browndeer/coprthr](https://github.com/browndeer/coprthr) - The CO-PRocessing THReads (COPRTHR) SDK - latest release is v1.6.1 (Freewill)
* [rackerlabs/boot.rackspace.com](https://github.com/rackerlabs/boot.rackspace.com) - Multiple Operating System Installer via iPXE
* [Netsukuku/netsukuku](https://github.com/Netsukuku/netsukuku) - Revived C-code
* [menudoproblema/libemqtt](https://github.com/menudoproblema/libemqtt) - Embedded C client library for the MQTT protocol
* [matthijskooijman/arduino-lmic](https://github.com/matthijskooijman/arduino-lmic) - LoraWAN-in-C library, adapted to run under the Arduino environment
* [grahamedgecombe/nginx-ct](https://github.com/grahamedgecombe/nginx-ct) - Certificate Transparency module for nginx.
* [crosg/idCreator](https://github.com/crosg/idCreator) - 这是一个id生成器，主要为互联网的各种业务生成id（也就是数据库主键）。该id生成器生成的id主要被用来做数据路由之用。和Albianj2配合，可以快速而简单的搭建完整的分布式业务系统！
* [zsummer/zsummerX](https://github.com/zsummer/zsummerX) - zsummerX is a cross-platform C++ high performance lightweight network library. via IOCP/EPOLL/SELECT.
* [Unidata/netcdf-c](https://github.com/Unidata/netcdf-c) - Official GitHub repository for netCDF-C libraries and utilities.
* [R4stl1n/cAudio](https://github.com/R4stl1n/cAudio) - 3D Audio Engine Based on Openal
* [mainroach/crabby](https://github.com/mainroach/crabby) - A texture compression algorithm for sprite sheets that allows decompression on the GPU during rendering.
* [linux-nvme/nvme-cli](https://github.com/linux-nvme/nvme-cli) - NVMe management command line interface.
* [libtom/tomsfastmath](https://github.com/libtom/tomsfastmath) - TomsFastMath is a fast public domain, open source, large integer arithmetic library written in portable ISO C.
* [imneme/pcg-c-basic](https://github.com/imneme/pcg-c-basic) - PCG — Minimal C Implementation
* [geoffgarside/cocoagit](https://github.com/geoffgarside/cocoagit) - An Objective-C/Foundation implementation of the Git version control software.
* [xtacocorex/CHIP_IO](https://github.com/xtacocorex/CHIP_IO) - A CHIP IO library for Python
* [xlar54/Commodore-Pi](https://github.com/xlar54/Commodore-Pi) - A native Commodore 64 emulator and operating system for the Raspberry Pi
* [wolkykim/libasyncd](https://github.com/wolkykim/libasyncd) - Embeddable Event-based Asynchronous Message/HTTP Server library for C/C++
* [wernerd/ZRTPCPP](https://github.com/wernerd/ZRTPCPP) - C++ Implementation of ZRTP protocol - GNU ZRTP C++
* [troydhanson/misc](https://github.com/troydhanson/misc) - C code snippets and more
* [githole/Live-Coder](https://github.com/githole/Live-Coder) - Live Coder is a realtime GLSL editor/viewer mainly for demosceners.
* [dalerank/caesaria-game](https://github.com/dalerank/caesaria-game) - Caesar III (Open source remake)
* [clibs/flag](https://github.com/clibs/flag) - Go-style flag parsing for C
* [ANSSI-FR/AD-control-paths](https://github.com/ANSSI-FR/AD-control-paths) - Active Directory Control Paths auditing and graphing tools
* [yongboy/c_socket.io_server](https://github.com/yongboy/c_socket.io_server) - The socket.io Linux C server
* [lvzixun/Clang-Complete](https://github.com/lvzixun/Clang-Complete) - a auto complete plugin for sublimetext3
* [dianping/camel](https://github.com/dianping/camel) - camel: soft load balance(slb) middle ware - control nginx servers by portal and api.
* [dhuertas/AES](https://github.com/dhuertas/AES) - AES algorithm implementation in C
* [cyrus-and/prof](https://github.com/cyrus-and/prof) - Self-contained C/C++ profiler library for Linux
* [aminroosta/sqlite_modern_cpp](https://github.com/aminroosta/sqlite_modern_cpp) - a c++11 wrapper around sqlite library
* [agentzh/chunkin-nginx-module](https://github.com/agentzh/chunkin-nginx-module) - HTTP 1.1 chunked-encoding request body support for Nginx
* [simondlevy/BreezySLAM](https://github.com/simondlevy/BreezySLAM) - Simple, efficient, open-source package for Simultaneous Localization and Mapping in Python, Matlab,  Java, and C++
* [reprappro/RepRapFirmware](https://github.com/reprappro/RepRapFirmware) - OO C++ RepRap Firmware
* [koron/cmigemo](https://github.com/koron/cmigemo) - C/Migemo
* [forhappy/cpy-leveldb](https://github.com/forhappy/cpy-leveldb) - python bingding for leveldb using c api
* [CTurt/Cinoop](https://github.com/CTurt/Cinoop) - Multiplatform Game Boy emulator
* [chneukirchen/cwm](https://github.com/chneukirchen/cwm) - portable version of OpenBSD's cwm(1) window manager
* [yomoncada/C-Language](https://github.com/yomoncada/C-Language) - First steps of my C Language programing.
* [SpenceKonde/ATTinyCore](https://github.com/SpenceKonde/ATTinyCore) - Arduino core for ATtiny 1634, 828, x313, x4, x41, x5, x61, x7 and x8
* [shawnclovie/cocos2dx-LuaProxy](https://github.com/shawnclovie/cocos2dx-LuaProxy) - LuaProxy for cocos2d-x, include CocosBuilder support for lua, and other cocos2d-extension support for lua, and easy to use function.
* [orlp/ed25519](https://github.com/orlp/ed25519) - Portable C implementation of Ed25519, a high-speed high-security public-key signature system.
* [jalvesaq/colorout](https://github.com/jalvesaq/colorout) - Colorize R output on terminal emulators
* [fiveruns/memcache-client](https://github.com/fiveruns/memcache-client) - Seattle.rb's memcache-client 1.5.0 with fixes
* [BigZaphod/AStar](https://github.com/BigZaphod/AStar) - C Implementation of the A* Pathfinding Algorithm
* [bg111/asterisk-chan-dongle](https://github.com/bg111/asterisk-chan-dongle) - Automatically exported from code.google.com/p/asterisk-chan-dongle
* [teachop/FlexCAN_Library](https://github.com/teachop/FlexCAN_Library) - Arduino library for CAN on Teensy 3.1
* [MatzeB/cparser](https://github.com/MatzeB/cparser) - C99 parser and frontend for libfirm
* [kklis/proxy](https://github.com/kklis/proxy) - TCP proxy in ANSI C
* [jtsiomb/kdtree](https://github.com/jtsiomb/kdtree) - A simple C library for working with KD-Trees
* [hdm/juniper-cve-2015-7755](https://github.com/hdm/juniper-cve-2015-7755) - Notes, binaries, and related information from analysis of the CVE-2015-7755 & CVE-2015-7756 issues within Juniper ScreenOS
* [ctz/cifra](https://github.com/ctz/cifra) - A collection of cryptographic primitives targeted at embedded use.
* [CristianHenzel/ClipIt](https://github.com/CristianHenzel/ClipIt) - ClipIt clipboard manager for GTK+
* [cloudflare/lua-resty-json](https://github.com/cloudflare/lua-resty-json) - json lib for lua and C
* [ccpalettes/the-c-programming-language-second-edition-solutions](https://github.com/ccpalettes/the-c-programming-language-second-edition-solutions) - Solutions for all exercises in the book "The C Programming Language - Second Edition"(referred to as K&R, after its authors' initials) by Brian W. Kernighan and Dennis M. Ritchie.
* [willemt/cbuffer](https://github.com/willemt/cbuffer) - A circular buffer written in C using Posix calls to create a contiguously mapped memory space. BSD Licensed.
* [theck01/offbrand_lib](https://github.com/theck01/offbrand_lib) - A collecton of generic reference counted data structures, tools to create compatible C style classes, and demo applications
* [PaulStoffregen/teensy_loader_cli](https://github.com/PaulStoffregen/teensy_loader_cli) - Command line Teensy Loader
* [iafonov/multipart-parser-c](https://github.com/iafonov/multipart-parser-c) - Http multipart parser implemented in C
* [beoran/chipmunk](https://github.com/beoran/chipmunk) - Bindings to Chipmunk 5.3.4 with extra features for use with Ruby 1.8.x and 1.9.x. Version 5.4.3.4 released on rubygems. Just a gem install chipmunk should work, even on windows! -- Developers wanted to take over this project!!!
* [zfogg/ascii-chat](https://github.com/zfogg/ascii-chat) - ASCII video chat.
* [xonce/CSpider](https://github.com/xonce/CSpider) - A scalable and convenient crawler framework in C:).
* [x893/CMSIS-DAP](https://github.com/x893/CMSIS-DAP) - STM32 port for CMSIS-DAP with additional serial (CDC) support
* [willemt/pearldb](https://github.com/willemt/pearldb) - A Lightweight Durable HTTP Key-Value Pair Database in C
* [retme7/CVE-2014-4322_poc](https://github.com/retme7/CVE-2014-4322_poc) - Gain privileges:system -> root,as a part of  https://github.com/retme7/CVE-2014-7911_poc
* [LnxPrgr3/crossfeed](https://github.com/LnxPrgr3/crossfeed) - Headphone crossfeed filter
* [lennylxx/leetcode](https://github.com/lennylxx/leetcode) - Pure C solution for LeetCode
* [itkz/librtmp](https://github.com/itkz/librtmp) - RTMP server and client written by C
* [Cotix/cReddit](https://github.com/Cotix/cReddit) - CLI Reddit client written in C. Oh, crossplatform too!
* [zsummer/breeze](https://github.com/zsummer/breeze) - 一个C++的轻量级的分布式服务器引擎, 架构思想为一切皆service.
* [jaseg/matelight](https://github.com/jaseg/matelight) - Show text and gifs on mate crates. Uses C code orchestrated from Python via ctypes.
* [ideawu/c1000k](https://github.com/ideawu/c1000k) - A tool to test if you system supports 1 million connections(c1000k)
* [hackedteam/core-linux](https://github.com/hackedteam/core-linux) - RCS Agent for Linux
* [digidotcom/xbee_ansic_library](https://github.com/digidotcom/xbee_ansic_library) - A collection of portable ANSI C code for communicating with Digi International's XBee wireless radio modules in API mode.
* [simonyiszk/csdr](https://github.com/simonyiszk/csdr) - A simple DSP library and command-line tool for Software Defined Radio.
* [naemon/naemon-core](https://github.com/naemon/naemon-core) - Networks, Applications and Event Monitor
* [mono/libgdiplus](https://github.com/mono/libgdiplus) - C-based implementation of the GDI+ API
* [mikewest/nginx-static-etags](https://github.com/mikewest/nginx-static-etags) - Nginx doesn't generate etags for static content.  I'd like it to.  Let's see if I can remember some C from college.
* [learnopengles/airhockey](https://github.com/learnopengles/airhockey) - Repository for "Developing a Simple Game of Air Hockey Using C++ and OpenGL ES 2 for Android, iOS, and the Web", located at http://www.learnopengles.com/developing-a-simple-game-of-air-hockey-using-c-and-opengl-es-2-for-android-ios-and-the-web/
* [hyPiRion/c-rrb](https://github.com/hyPiRion/c-rrb) - RRB-tree implemented as a library in C.
* [hrydgard/native](https://github.com/hrydgard/native) - NOTE: No longer used in PPSSPP! Various C++ utility code: OpenGL ES, JSON, etc, portable to Android.
* [haiwen/ccnet](https://github.com/haiwen/ccnet) - Ccnet is a framework for writing networked applications in C.
* [h2non/semver.c](https://github.com/h2non/semver.c) - semver parser written in ANSI C
* [crash-utility/crash](https://github.com/crash-utility/crash) - Linux kernel crash utility
* [ceph/ceph-client](https://github.com/ceph/ceph-client) - Ceph kernel client
* [tsuna/contextswitch](https://github.com/tsuna/contextswitch) - Little micro-benchmark for Linux to test the cost of context switching and system calls
* [supertunaman/cdl](https://github.com/supertunaman/cdl) - Chicken Dance License! The official IANAL license.
* [obgm/libcoap](https://github.com/obgm/libcoap) - A CoAP (RFC 7252) implementation in C
* [nst/BatteryChart](https://github.com/nst/BatteryChart) - Drawing iPhone Battery Charge / Discharge
* [mzhaom/trunk](https://github.com/mzhaom/trunk) - Make bazel an out of box solution for C++/Java developers
* [libav/c99-to-c89](https://github.com/libav/c99-to-c89) - Tool to convert C99 code to MSVC-compatible C89
* [cloudflare/lua-upstream-cache-nginx-module](https://github.com/cloudflare/lua-upstream-cache-nginx-module) - Nginx module for ngx_lua to provide Lua API to inspect upstream http cache meta-data
* [y123456yz/Reading-and-comprehense-linux-Kernel-network-protocol-stack](https://github.com/y123456yz/Reading-and-comprehense-linux-Kernel-network-protocol-stack) - linux内核网络协议栈源码阅读分析注释--带详尽中文分析注释以及相关流程分析调用注释，对理解分析内核协议栈源码很有帮助
* [rxi/vec](https://github.com/rxi/vec) - A type-safe dynamic array implementation for C
* [pdpdds/CGSF](https://github.com/pdpdds/CGSF) - Online Game Server Platform
* [jimenezrick/patch-AuthenticAMD](https://github.com/jimenezrick/patch-AuthenticAMD) - Utility to patch binaries generated by the Intel C++ Compiler to get the maximum performance on AMD CPUs
* [frodosens/fsnet](https://github.com/frodosens/fsnet) - 一个c+ruby支持分布式部署开源的网络游戏库
* [corporateshark/Android-NDK-Game-Development-Cookbook](https://github.com/corporateshark/Android-NDK-Game-Development-Cookbook) - Android NDK Game Development Cookbook
* [zhicheng/db](https://github.com/zhicheng/db) - A New DBM in Pure C
* [Zeex/sampgdk](https://github.com/Zeex/sampgdk) - Writing SA-MP gamemodes in C/C++
* [wahern/cqueues](https://github.com/wahern/cqueues) - Continuation Queues: Embeddable asynchronous networking, threading, and notification framework for Lua on Unix.
* [timwr/CVE-2014-3153](https://github.com/timwr/CVE-2014-3153) - CVE-2014-3153 aka towelroot
* [smistad/GPU-Marching-Cubes](https://github.com/smistad/GPU-Marching-Cubes) - A GPU implementation of the Marching Cubes algorithm for extracting surfaces from volumes using OpenCL and OpenGL
* [regehr/ub-canaries](https://github.com/regehr/ub-canaries) - collection of C/C++ programs that try to get compilers to exploit undefined behavior
* [pjanouch/sensei-raw-ctl](https://github.com/pjanouch/sensei-raw-ctl) - SteelSeries Sensei Raw configuration tool
* [OKCoin/rest](https://github.com/OKCoin/rest) - OKCoin Rest Api客户端示例 目前只提供C++、C# 、Java、PHP、Python
* [jtsiomb/c11threads](https://github.com/jtsiomb/c11threads) - Trivial C11 threads.h implementation over POSIX threads.
* [Fazecast/jSerialComm](https://github.com/Fazecast/jSerialComm) - Platform-independent serial port access for Java
* [dake/openVP](https://github.com/dake/openVP) - Voice Print Recognition in C language.
* [commonsguy/cw-andtuning](https://github.com/commonsguy/cw-andtuning) - Samples from _Tuning Android Applications_
* [breckinloggins/ngtemplate](https://github.com/breckinloggins/ngtemplate) - ngtemplate - A template engine written in C designed to be syntax-compatible with Google CTemplate
* [WhisperSystems/curve25519-java](https://github.com/WhisperSystems/curve25519-java) - Pure Java and JNI backed Curve25519 implementation.
* [radiofreejohn/cfastread](https://github.com/radiofreejohn/cfastread) - Implementation of the Spritz reading method for command line files
* [QuentinPerez/42-toolkit](https://github.com/QuentinPerez/42-toolkit) - :seedling: Useful structs written in C
* [preshing/CompareIntegerMaps](https://github.com/preshing/CompareIntegerMaps) - Generates benchmark data for two different data structures, then renders some graphs.
* [openslide/openslide](https://github.com/openslide/openslide) - C library for reading virtual slide images
* [ileben/ShivaVG](https://github.com/ileben/ShivaVG) - OpenGL based ANSI C implementation of the OpenVG standard.
* [Hypsurus/ftpmap](https://github.com/Hypsurus/ftpmap) - [deprecated] FTP scanner, and take-over tool in C
* [cjac/cmusphinx](https://github.com/cjac/cmusphinx) - CMU Sphinx - Speech Recognition Toolkit
* [chrismoos/hash-ring](https://github.com/chrismoos/hash-ring) - C hash ring library
* [Rinnegatamante/rinCheat](https://github.com/Rinnegatamante/rinCheat) - Multifunction plugin for PSVITA.
* [iTyran/SushiCrush](https://github.com/iTyran/SushiCrush) - SushiCrush
* [google/cronutils](https://github.com/google/cronutils) - utilities to assist running batch processing jobs
* [arachsys/containers](https://github.com/arachsys/containers) - Lightweight containers using Linux user namespaces
* [rpm-software-management/hawkey](https://github.com/rpm-software-management/hawkey) - This is hawkey, library providing simplified C and Python API to libsolv. Hawkey project is obsoleted.
* [rockdaboot/mget](https://github.com/rockdaboot/mget) - Multithreaded metalink/file/website downloader (like Wget) and C library
* [keenlabs/KeenClient-iOS](https://github.com/keenlabs/KeenClient-iOS) - Official iOS client for the Keen IO API. Build analytics features directly into your iOS apps.
* [jbuchbinder/statsd-c](https://github.com/jbuchbinder/statsd-c) - C port of Etsy's statsd
* [grrrwaaa/maxcpp](https://github.com/grrrwaaa/maxcpp) - C++ templates for Max/MSP objects
* [clibs/hash](https://github.com/clibs/hash) - C hash implementation based on khash
* [ApertureLabsLtd/ChronIC](https://github.com/ApertureLabsLtd/ChronIC) - A wearable Sub-GHz RF hacking tool
* [adob/print-stmt](https://github.com/adob/print-stmt) - Convenient print statement for C++
* [taf2/libebb](https://github.com/taf2/libebb) - a lightweight high-performance HTTP server library for C
* [reagent/http](https://github.com/reagent/http) - Simple HTTP client in C
* [orangeduck/tgc](https://github.com/orangeduck/tgc) - A Tiny Garbage Collector for C
* [MakerLabMe/STM32_Arduino_Cores](https://github.com/MakerLabMe/STM32_Arduino_Cores) - STM M3 ARM Cores for Arduino IDE.Makes Arduino IDE supports stm32f103.
* [emilk/wfc](https://github.com/emilk/wfc) - A C++ port of Wave Function Collapse Tiling
* [cahirwpz/amigaos-cross-toolchain](https://github.com/cahirwpz/amigaos-cross-toolchain) - AmigaOS cross compiler for Linux / MacOSX / Windows
* [ButterflyTV/LibRtmp-Client-for-Android](https://github.com/ButterflyTV/LibRtmp-Client-for-Android) - It is probably the smallest(~60KB) rtmp client for android. It calls librtmp functions over JNI interface
* [wc-duck/dbgtools](https://github.com/wc-duck/dbgtools) - Small collection of debug-related drop-in c/c++-utils
* [skvadrik/re2c](https://github.com/skvadrik/re2c) - lexer generator for C/C++
* [rofl0r/libulz](https://github.com/rofl0r/libulz) - a collection of useful functions and data structures to create C apps faster. focus on simplicity, ability to statically link and minimal binary size.
* [rg3/bcrypt](https://github.com/rg3/bcrypt) - bcrypt password hash C library
* [realtalk/cve-2013-2094](https://github.com/realtalk/cve-2013-2094) - original cve-2013-2094 exploit and a rewritten version for educational purposes
* [randrew/layout](https://github.com/randrew/layout) - Library for calculating 2D UI layouts using stacking boxes. Compiles as C99 or C++. Two files.
* [radfordneal/LDPC-codes](https://github.com/radfordneal/LDPC-codes) - Software for Low Density Parity Check codes
* [nikki93/cgame](https://github.com/nikki93/cgame) - some ideas involving games and C
* [KitSprout/QCopterFlightControl](https://github.com/KitSprout/QCopterFlightControl) - 飛控板 FlightController，使用 STM32F405R
* [dxjia/ffmpeg-commands-executor-library](https://github.com/dxjia/ffmpeg-commands-executor-library) - execute ffmpeg commands through a jni shared library.
* [ConsoleKit2/ConsoleKit2](https://github.com/ConsoleKit2/ConsoleKit2) - ConsoleKit2 is a framework for defining and tracking users, login sessions, and seats.
* [andreafabrizi/prism](https://github.com/andreafabrizi/prism) - PRISM is an user space stealth reverse shell backdoor, written in pure C.
* [amd/Chromium-WebCL](https://github.com/amd/Chromium-WebCL) - WebCL implementation for Chromium
* [shannah/Java-Objective-C-Bridge](https://github.com/shannah/Java-Objective-C-Bridge) - A thin bridge that allows for two-way communication from Java to Objective-C.
* [liyuming1978/NativeLibCompression](https://github.com/liyuming1978/NativeLibCompression) - The native library compression sdk is given to solve the apk size problem. It is easy to integrate and will get max 50% size decreasing. Not only sdk, a Java tool for package is provided to convert normal apk to compressed apk.  MIT Licence, you can use any where
* [hmng/jsonrpc-c](https://github.com/hmng/jsonrpc-c) - JSON-RPC in C (server only for now)
* [greiman/ChibiOS-Arduino](https://github.com/greiman/ChibiOS-Arduino) - ChibiOS/RT 3.0.3 for Arduino AVR, Due, and Teensy 3.x
* [ccore/ccore](https://github.com/ccore/ccore) - A cross platform low level game development library
* [boazsegev/iodine](https://github.com/boazsegev/iodine) - Iodine - HTTP / Websocket Server & EventMachine alternative for Ruby MRI - a kqueue/epoll C extension
* [kframework/c-semantics](https://github.com/kframework/c-semantics) - Semantics of C in K
* [HdrHistogram/HdrHistogram_c](https://github.com/HdrHistogram/HdrHistogram_c) - C port of the HdrHistogram
* [gallir/concurrencia](https://github.com/gallir/concurrencia) - Códigos fuente del libro "Principios y algoritmos de concurrencia"
* [eclipse/paho.mqtt.c](https://github.com/eclipse/paho.mqtt.c) - paho.mqtt.c
* [catalinii/minisatip](https://github.com/catalinii/minisatip) - minisatip is an SATIP server for linux using local DVB-S2, DVB-C, DVB-T or ATSC cards
* [baruch/libwire](https://github.com/baruch/libwire) - User space threading (aka coroutines) library for C resembling GoLang and goroutines
* [anrieff/libcpuid](https://github.com/anrieff/libcpuid) - a small C library for x86 CPU detection and feature extraction
* [agl/ctgrind](https://github.com/agl/ctgrind) - Checking that functions are constant time with Valgrind
* [tronkko/dirent](https://github.com/tronkko/dirent) - C/C++ library for retrieving information on files and directories
* [r0nk/corvus](https://github.com/r0nk/corvus) - Genetic BF programming
* [njh/mqtt-sn-tools](https://github.com/njh/mqtt-sn-tools) - Command line tools written in C for the MQTT-SN (MQTT For Sensor Networks) protocol
* [mikebmcl/N3888_RefImpl](https://github.com/mikebmcl/N3888_RefImpl) - Reference Implementations of ISO C++ P0267
* [jvirkki/libbloom](https://github.com/jvirkki/libbloom) - A simple and small bloom filter implementation in plain C.
* [clMathLibraries/clRNG](https://github.com/clMathLibraries/clRNG) - an OpenCL based software library containing random number generation functions
* [alanwoolley/CorsixTH-Android](https://github.com/alanwoolley/CorsixTH-Android) - Port of CorsixTH to Android
* [zarya/esp8266_i2c_driver](https://github.com/zarya/esp8266_i2c_driver) - ESP8266 I2C Driver
* [wez/lemon-php](https://github.com/wez/lemon-php) - A PHP parser generator, based on the lemon parser generator tool. lemon-php requires a C compiler to build, and this will generate pure-PHP parsers.
* [rsta2/uspi](https://github.com/rsta2/uspi) - A bare metal USB driver for Raspberry Pi written in C
* [radif/SIPHON-SIP-Client-that-actually-compiles](https://github.com/radif/SIPHON-SIP-Client-that-actually-compiles) - SIPHON SIP VOIP Client that actually compiles and runs on ios5 non-jailbroken phones. Works on the device and simulator! (GPL). Here is the original repository: http://code.google.com/p/siphon/
* [linyiqun/Redis-Code](https://github.com/linyiqun/Redis-Code) - redis键值数据库源码分析
* [falkTX/Cadence](https://github.com/falkTX/Cadence) - Collection of tools useful for audio production
* [coocox/cox](https://github.com/coocox/cox) - CoX is an peripherals library with a unified standard interface specially for ARM Cortex M.
* [chitika/cberl](https://github.com/chitika/cberl) - NIF based Erlang bindings for Couchbase
* [asamy/ksm](https://github.com/asamy/ksm) - A really simple and lightweight x64 hypervisor written in C for Windows (Intel processors, >= Haswell only).  Supports vmfunc, EPTP switching and ept violation handling via IDT in guest ("IDT shadowing").
* [01org/intel-cmt-cat](https://github.com/01org/intel-cmt-cat) - User space software for Intel(R) Resource Director Technology
* [roundsheep/rpp](https://github.com/roundsheep/rpp) - RPP is a new programming language combined with C++ and LISP
* [replay/ngx_http_consistent_hash](https://github.com/replay/ngx_http_consistent_hash) - a module which enables the nginx to use the same consistent hashing distribution for memcache servers as the php memcache module
* [lemire/clhash](https://github.com/lemire/clhash) - C library implementing the ridiculously fast CLHash  hashing function
* [kohsuke/com4j](https://github.com/kohsuke/com4j) - Type-safe Java/COM binding
* [jjgod/vim-cocoa](https://github.com/jjgod/vim-cocoa) - A compact Cocoa port for Vim.
* [jackmitch/libsoc](https://github.com/jackmitch/libsoc) - libsoc: C library for interfacing with common SoC peripherals through generic kernel interfaces
* [guillermocalvo/exceptions4c](https://github.com/guillermocalvo/exceptions4c) - :bomb: An exception handling framework for C
* [geertj/cgreenlet](https://github.com/geertj/cgreenlet) - Coroutines for C/C++
* [edorfaus/TEMPered](https://github.com/edorfaus/TEMPered) - C library and program for reading the TEMPer family of thermometer and hygrometer devices.
* [stevedekorte/garbagecollector](https://github.com/stevedekorte/garbagecollector) - Incrementall garbage collector library in C for use by high level language implementions.
* [Quarx2k/android_device_moto_jordan-common](https://github.com/Quarx2k/android_device_moto_jordan-common) - common repo for MB520/MB525/MB526/
* [MauriceGit/Cloth_Simulation](https://github.com/MauriceGit/Cloth_Simulation) - Cloth-Visualization via particle-simulation.
* [LuaDist/toluapp](https://github.com/LuaDist/toluapp) - tolua++ is an extension of toLua, a tool to integrate C/Cpp code with Lua
* [fredrik-johansson/arb](https://github.com/fredrik-johansson/arb) - C library for arbitrary-precision interval arithmetic
* [bellbind/node-v4l2camera](https://github.com/bellbind/node-v4l2camera) - node module for capturing an image from USB(UVC) webcam on linux.
* [AVbin/AVbin](https://github.com/AVbin/AVbin) - AVbin is a C library that provides a thin, cross-platform wrapper around Libav’s video- and audio-decoding functionality, providing long-term binary compatibility for applications and languages that need it.  See also: Pyglet, a python media framework that makes extensive use of AVbin.
* [yuyuyu101/C-Buffered-tree](https://github.com/yuyuyu101/C-Buffered-tree) - A buffered-tree implemented in dictionary type and more
* [torch/tds](https://github.com/torch/tds) - Torch C data structures
* [swatkat/twitcurl](https://github.com/swatkat/twitcurl) - twitcurl is a pure C++ library for twitter APIs.
* [RoaringBitmap/CRoaring](https://github.com/RoaringBitmap/CRoaring) - Roaring bitmaps in C (and C++)
* [redbrain/cython-book](https://github.com/redbrain/cython-book) - Learning Cython packtpub.com code examples.
* [pkrumins/node-base64](https://github.com/pkrumins/node-base64) - A base64 encoding and decoding C++ module for node.js that actually works! (node now has it's own base64 encoding, see docs!)
* [niklasfrykholm/nflibs](https://github.com/niklasfrykholm/nflibs) - A collection of interoperable minimalistic C libraries
* [mcandre/qc](https://github.com/mcandre/qc) - qc - A C port of the QuickCheck unit test framework
* [lyjdamzwf/chaos](https://github.com/lyjdamzwf/chaos) - c++ 网络事件库
* [Lupus/libevfibers](https://github.com/Lupus/libevfibers) - Small C fiber library that uses libev based event loop and libcoro based coroutine context switching.
* [LuaDist/tcc](https://github.com/LuaDist/tcc) - Small but fast C compiler.  Supports ANSI C, most of the new ISO C99 standard, and many GNUC extensions, including inline assembly.
* [Lua-cURL/Lua-cURLv3](https://github.com/Lua-cURL/Lua-cURLv3) - Lua binding to libcurl
* [lqs/crabdb](https://github.com/lqs/crabdb) - CrabDB - a fast, flexible and space-effective database.
* [FliPPeh/cNBT](https://github.com/FliPPeh/cNBT) - An NBT file parser and manipulator library
* [emeau/itrace](https://github.com/emeau/itrace) - hook objc_msgSend to trace Objective-C method callz
* [cloudyourcar/minmea](https://github.com/cloudyourcar/minmea) - a lightweight GPS NMEA 0183 parser library in pure C
* [clawoo/AsteroidsCocos2D-x](https://github.com/clawoo/AsteroidsCocos2D-x) - An Asteroids game implemented in Cocos2D-x
* [chaoslawful/tcc](https://github.com/chaoslawful/tcc) - track of Tiny C Compiler
* [Cairo-Dock/cairo-dock-core](https://github.com/Cairo-Dock/cairo-dock-core) - Core part of Cairo-Dock project.
* [ansilove/ansilove](https://github.com/ansilove/ansilove) - ANSi / ASCII art to PNG converter in C
* [anoek/android-cairo](https://github.com/anoek/android-cairo) - Android NDK build files to build libcairo
* [tang3w/CocoaSugar](https://github.com/tang3w/CocoaSugar) - Some Cocoa Touch improvements can make developing apps easier
* [ryd/chaosvpn](https://github.com/ryd/chaosvpn) - Config generator for chaos vpn
* [pebble-examples/cards-example](https://github.com/pebble-examples/cards-example) - Pebble Draw Commands example with a cards based app
* [nickdesaulniers/bf_interpreter_jit_compiler](https://github.com/nickdesaulniers/bf_interpreter_jit_compiler) - Teach myself about interpreters, JITs, and compilers using the Brainfuck language as the toy language
* [jeroenooms/curl](https://github.com/jeroenooms/curl) - An R connection interface to libcurl.
* [jduck/challack](https://github.com/jduck/challack) - Proof-of-concept exploit code for CVE-2016-5696
* [andygock/avr-uart](https://github.com/andygock/avr-uart) - AVR UART C Library
* [toymachine/libredis](https://github.com/toymachine/libredis) - A C based general low-level PHP extension and client library for Redis, focusing on performance, generality and efficient parallel communication with multiple Redis servers. As a bonus, a  Ketama Consistent Hashing implementation is provided as well.
* [TimAimee/-android-source-code](https://github.com/TimAimee/-android-source-code) - 这是我自己在学习安卓期间，在网上积累下来的源码 ，欢迎交流学习，很多源码已经不能提供具体出处，对作者抱歉，如果有发现自己的代码可以发邮件给我，我会立刻标注上的。
* [tarequeh/DES](https://github.com/tarequeh/DES) - Implementation of Data Encryption Standard (DES) in C
* [swift-nav/libswiftnav](https://github.com/swift-nav/libswiftnav) - A portable C library implementing GNSS related functions and algorithms.
* [rcr/rirc](https://github.com/rcr/rirc) - A terminal IRC client in C
* [netmail-open/wjelement](https://github.com/netmail-open/wjelement) - advanced, flexible JSON manipulation in C
* [InfiniteSearchSpace/PyCl-Convergence](https://github.com/InfiniteSearchSpace/PyCl-Convergence) - Python/OpenCl Cellular Automata design & manipulation tool
* [daveho/EasySandbox](https://github.com/daveho/EasySandbox) - really simple sandboxing of untrusted C programs using Linux SECCOMP
* [beaups/SamsungCID](https://github.com/beaups/SamsungCID) - Change the CID in Samsung eMMC
* [anoek/ex-sdl-cairo-freetype-harfbuzz](https://github.com/anoek/ex-sdl-cairo-freetype-harfbuzz) - Example code which uses SDL, cairo, freetype, and harfbuzz to do ttf/otf text layout and rendering
* [amahule/CoolReader](https://github.com/amahule/CoolReader) - An Android based open e-book reader
* [adamcaudill/ccsrch](https://github.com/adamcaudill/ccsrch) - Cross-platform credit card (PAN) search tool for security assessments
* [verement/cellminer](https://github.com/verement/cellminer) - Bitcoin miner for the Cell Broadband Engine Architecture
* [stevestreza/CrashReporter](https://github.com/stevestreza/CrashReporter) - Send iOS crash reports by email
* [Stanko/ThinkPad-Fan-Control](https://github.com/Stanko/ThinkPad-Fan-Control) - App for managing fan speeds on ThinkPad laptops on Linux
* [sshirokov/csgtool](https://github.com/sshirokov/csgtool) - 3D CSG Tool
* [simplegeo/libgeohash](https://github.com/simplegeo/libgeohash) - A pure C implementation of the Geohash algorithm.
* [sharelatex/clsi-sharelatex](https://github.com/sharelatex/clsi-sharelatex) - A web api for compiling LaTeX documents in the cloud
* [petermichaux/royal-scheme](https://github.com/petermichaux/royal-scheme) - Royal Scheme will eventually grow to be a real, usable, embeddable Scheme implemented in ANSI C.
* [okbob/plpgsql_check](https://github.com/okbob/plpgsql_check) - plpgsql_check is next generation of plpgsql_lint. It allows to check source code by explicit call plpgsql_check_function.
* [microbuilder/LPC1343CodeBase](https://github.com/microbuilder/LPC1343CodeBase) - Generic GCC-based library for the ARM Cortex-M3 LPC1343
* [lucasjones/cpuminer-multi](https://github.com/lucasjones/cpuminer-multi) - Multi-algo CPUMiner & Reference Cryptonote Miner (JSON-RPC 2.0)
* [L1L1/cardpeek](https://github.com/L1L1/cardpeek) - Automatically exported from code.google.com/p/cardpeek
* [isislab/CSAW-CTF-2016-Quals](https://github.com/isislab/CSAW-CTF-2016-Quals) - Repo for CSAW CTF 2016 Quals challenges
* [dizballanze/hashtable](https://github.com/dizballanze/hashtable) - Async hash table server in C
* [Cpasjuste/CtrBootManager](https://github.com/Cpasjuste/CtrBootManager) - A 3ds "bootloader" like app
* [ARM-software/CMSIS_5](https://github.com/ARM-software/CMSIS_5) - CMSIS Version 5 Development Repository
* [vrogier/ocilib](https://github.com/vrogier/ocilib) - OCILIB (C and C++ Drivers for Oracle) - Open source C and C++ library for accessing Oracle databases
* [redxu/sihook](https://github.com/redxu/sihook) - source insight 3.X tabs plugin in c language
* [mate-desktop/caja](https://github.com/mate-desktop/caja) - Caja, the file manager for the MATE desktop
* [kdeforche/wt](https://github.com/kdeforche/wt) - Wt, C++ Web Toolkit
* [mbedmicro/CMSIS-DAP](https://github.com/mbedmicro/CMSIS-DAP) - Interface Firmware providing USB CMSIS-DAP for debugging, USB MSD for programming, USB Serial for communication.
* [Screetsec/TheFatRat](https://github.com/Screetsec/TheFatRat) - Easy tool for generate backdoor with msfvenom ( part of metasploit framework ) and program compiles a C program with a meterpreter reverse_tcp payload In it that can then be executed on a windows host Program to create a C program after it is compiled that will bypass most AV ( Antivirus )
* [rweichler/cylinder](https://github.com/rweichler/cylinder) - iOS homescreen page transitions in Lua
* [phalcon/cphalcon](https://github.com/phalcon/cphalcon) - Web framework delivered as a C-extension for PHP
* [DanielWaterworth/Raphters](https://github.com/DanielWaterworth/Raphters) - [DEPRECATED] A web framework for C.
* [cgdb/cgdb](https://github.com/cgdb/cgdb) - Console front-end to the GNU debugger
* [canboat/canboat](https://github.com/canboat/canboat) - CAN Boat provides NMEA 2000 and NMEA 0183 utilities. It contains a NMEA 2000 PGN decoder, can read and write N2K messages.
* [QCopter/QCopterFlightControl](https://github.com/QCopter/QCopterFlightControl) - 飛控板 FlightController，使用 STM32F446R
* [billhsu/cashew](https://github.com/billhsu/cashew) - Freestyle 3D sketching app.
* [microbuilder/LPC810_CodeBase](https://github.com/microbuilder/LPC810_CodeBase) - Open source code base for the ARM Cortex M0+ LPC810 family from NXP
* [MacRuby/ControlTower](https://github.com/MacRuby/ControlTower) - Rack-based Web Application Server for MacRuby
* [spark/core-common-lib](https://github.com/spark/core-common-lib) - Common library for projects that use the Spark Core with the CC3000
* [nickbjohnson4224/rhombus](https://github.com/nickbjohnson4224/rhombus) - a hobby operating system written in C
* [wesleyd/charade](https://github.com/wesleyd/charade) - Ssh-agent clone for cygwin that proxies to pageant
* [openfaux/openfaux-client](https://github.com/openfaux/openfaux-client) - Browser add-on for encrypting and masking internet traffic.
* [metadave/erln8](https://github.com/metadave/erln8) - A sneaky Erlang version manager, v1 (C version)
* [m0wfo/cups](https://github.com/m0wfo/cups) - Ruby bridge to CUPS API
* [efelix/lua-cjson](https://github.com/efelix/lua-cjson) - Fast JSON parsing and encoding support for Lua
* [DarthMike/indielib-crossplatform](https://github.com/DarthMike/indielib-crossplatform) - Project to port IndieLib to other platforms aside from Windows and DirectX. Main focus is OpenGL ES 2.0 for mobile iOS operating system, and OpenGL desktop
* [couchbaselabs/couchstore](https://github.com/couchbaselabs/couchstore) - couchbase storage file library
* [welefen/SetCard](https://github.com/welefen/SetCard) - a brain & puzzle game by cocos2d-html5
* [vivekannan/calc](https://github.com/vivekannan/calc) - Simple command-line based calculator.
* [ottypes/libot](https://github.com/ottypes/libot) - A minimal C library for operational transform
* [Lua-cURL/Lua-cURLv2](https://github.com/Lua-cURL/Lua-cURLv2) - Lua-cURL is aiming for a full-fledged libcurl binding (easy/multi/share interface) to the functionality of Lua
* [lpabon/cmockery2](https://github.com/lpabon/cmockery2) - Reviving cmockery unit test framework from Google
* [kev009/craftd](https://github.com/kev009/craftd) - kev009 development repo.  Canonical repo @ craftd/craftd (see project URL)
* [jrfoell/campfire-libpurple](https://github.com/jrfoell/campfire-libpurple) - A Campfire protocol plugin for libpurple (Pidgin)
* [joyent/illumos-kvm-cmd](https://github.com/joyent/illumos-kvm-cmd) - qemu-kvm for illumos-kvm
* [dogriffiths/HeadFirstC](https://github.com/dogriffiths/HeadFirstC) - Source code for the book Head First C, by O'Reilly Media
* [Yalir/sfeMovie](https://github.com/Yalir/sfeMovie) - sfeMovie is a simple C++ library that lets you play movies in SFML based applications. It relies on FFmpeg to read medias and remains consistent with SFML's naming conventions. Forum at http://sfemovie.yalir.org/forum/
* [stephenmathieson/describe.h](https://github.com/stephenmathieson/describe.h) - Simple BDD describe test thingy for C
* [remis-thoughts/native-hdfs-fuse](https://github.com/remis-thoughts/native-hdfs-fuse) - C HDFS FUSE implementation, no libhdfs
* [nrj/objective-curl](https://github.com/nrj/objective-curl) - Curl bindings for Objective-C.
* [kev009/cii](https://github.com/kev009/cii) - libcii ported to Autotools/libtool - D. R. Hanson's C Interfaces and Implementations
* [jalvesaq/VimCom](https://github.com/jalvesaq/VimCom) - *Deprecated* package used to intermediate the communication between Vim and R
* [ivansafrin/CS3113](https://github.com/ivansafrin/CS3113) - NYU CS3113 [Intro To Game Programming]
* [ipa320/cob_extern](https://github.com/ipa320/cob_extern) - The cob_extern stack contains third party libraries needed for operating Care-O-bot. The packages are downloaded from the manufactorers website and not changed in any way.
* [chaelim/HAMT](https://github.com/chaelim/HAMT) - Hash Array Mapped Trie (C++ Templates)
* [TheWeatherChannel/dClass](https://github.com/TheWeatherChannel/dClass) - Device Classification Engine
* [taogogo/geohash-php-extention](https://github.com/taogogo/geohash-php-extention) - a php extension for geohash,geohash is writen in c,very fast to convert geohash and coord.(一个转换经纬度和geohash的PHP扩展)
* [sch3m4/libntoh](https://github.com/sch3m4/libntoh) - User-friendly C Library to perform TCP streams reassembly and IPv4/6 defragmentation
* [paulfitz/coopy](https://github.com/paulfitz/coopy) - distributed spreadsheets with intelligent merges
* [ndreynolds/flathead](https://github.com/ndreynolds/flathead) - A toy JavaScript interpreter written in C
* [jstasiak/asterisk-chan-dongle](https://github.com/jstasiak/asterisk-chan-dongle) - Mirror of SVN-based "asterisk's huawei 3g dongle channel driver" project with my Asterisk 10 and 11 compatibility patches (asterisk10 and asterisk11 branches)
* [abael/amysql](https://github.com/abael/amysql) - High performance( 2.5 times to MySQLDb ) Python  Mysql Driver,   using Python native socket layer.  pure C implemented.
* [sbinet/go-clang](https://github.com/sbinet/go-clang) - CGo bindings to the C-api of libclang.
* [saghul/pycares](https://github.com/saghul/pycares) - Python interface for c-ares
* [pkrumins/bithacks.h](https://github.com/pkrumins/bithacks.h) - bithacks.h is a C header file containing useful bit manipulation macros
* [ntpeters/SimpleLogger](https://github.com/ntpeters/SimpleLogger) - Basic logger for C and C++ projects
* [indrajithi/Audio-Visualizer](https://github.com/indrajithi/Audio-Visualizer) - Audio Visualizer in C++ using OpenGL
* [facebook/css-layout](https://github.com/facebook/css-layout) - A subset of CSS (specifically flex-box) re-implemented as a stand alone project for use primarily on mobile. Used by react-native
* [smackers/smack](https://github.com/smackers/smack) - SMACK: A Bounded Software Verifier for C Programs
* [haskell-crypto/cryptonite](https://github.com/haskell-crypto/cryptonite) - lowlevel set of cryptographic primitives for haskell
* [lcastelli/chdb](https://github.com/lcastelli/chdb) - A fast read-only memory mapped hash-table for PHP
* [Kalroth/cgminer-3.7.2-kalroth](https://github.com/Kalroth/cgminer-3.7.2-kalroth) - Kalroth's personal cgminer 3.7.2 branch
* [brong/cyrus-imapd](https://github.com/brong/cyrus-imapd) - My git clone of the Cyrus CVS repository
* [binchewer/power_fixer](https://github.com/binchewer/power_fixer) - OSX command line utility that attempts to restore pre-Mavericks power button behavior. Written in C.
* [Yubico/yubico-c-client](https://github.com/Yubico/yubico-c-client) - Yubico C client library
* [valr/cbatticon](https://github.com/valr/cbatticon) - A lightweight and fast battery icon that sits in your system tray
* [pgbovine/opt-cpp-backend](https://github.com/pgbovine/opt-cpp-backend) - C and C++ visualizer backend for Online Python Tutor
* [freaklabs/chibiArduino](https://github.com/freaklabs/chibiArduino) - A lightweight 802.15.4 wireless protocol stack for Arduino
* [eriksvedang/Carp](https://github.com/eriksvedang/Carp) - a statically typed lisp, without a GC, for high performance applications
* [ansiboy/ChiTuStore](https://github.com/ansiboy/ChiTuStore) - 开源的电商前端混合 APP
* [opencomputeproject/OCP-Networking-Project-Community-Contributions](https://github.com/opencomputeproject/OCP-Networking-Project-Community-Contributions) - WARNING: This repository will hold software contributions that are being worked on collaboratively by the OCP Networking Community. Code in this repository has not yet been approved and accepted by the OCP Incubation Committee.  Software in this repository should be not be used on production machines and should be treated as you would any Alpha/Beta release or any software that is in development.
* [juanmirocks/Levenshtein-MySQL-UDF](https://github.com/juanmirocks/Levenshtein-MySQL-UDF) - General Levenshtein algorithm and k-bounded levenshtein distance in linear time and constant space. Implementation in C as a MySQL UDF
* [cockpit-project/cockpit](https://github.com/cockpit-project/cockpit) - Cockpit, a user interface for Linux servers
* [mongodb/mongo-c-driver-legacy](https://github.com/mongodb/mongo-c-driver-legacy) - C Driver for MongoDB
* [bitcoin/secp256k1](https://github.com/bitcoin/secp256k1) - Optimized C library for EC operations on curve secp256k1
* [olevole/cbsd](https://github.com/olevole/cbsd) - Yet one more wrapper around FreeBSD jail and bhyve. For more information please visit website
* [jrosdahl/ccache](https://github.com/jrosdahl/ccache) - ccache - a fast compiler cache
* [pimoroni/unicorn-hat](https://github.com/pimoroni/unicorn-hat) - C library, C example and Python wrapper for driving ws2812 pixels from the Raspberry Pi
* [TheErk/CMake-tutorial](https://github.com/TheErk/CMake-tutorial) - CMake tutorial: beamer presentation and sample code
* [axoltl/HubCap](https://github.com/axoltl/HubCap) - ChromeCast HubCap exploit
* [xobs/ax2xx-code](https://github.com/xobs/ax2xx-code) - Some code for the AX211 or AX215 8051-based CPU
* [xnko/libapi](https://github.com/xnko/libapi) - libapi is a cross platform high performance io library written in c. It provides ability to write event driven servers and applications with continous code
* [RJ/playdar](https://github.com/RJ/playdar) - Abandoned C++ codebase, see playdar-core repo!
* [robotpy/robotpy-crio](https://github.com/robotpy/robotpy-crio) - Obsolete. Python 3 port for cRIO for use in the FIRST Robotics Competition (FRC)
* [robertdavidgraham/cve-2015-5477](https://github.com/robertdavidgraham/cve-2015-5477) - PoC exploit for CVE-2015-5477 BIND9 TKEY assertion failure
* [orangeduck/json2c](https://github.com/orangeduck/json2c) - Convert JSON to C data literals
* [Ramblurr/PietCreator](https://github.com/Ramblurr/PietCreator) - GUI for developing and debugging programs written in the Piet language
* [varnish/libvmod-cookie](https://github.com/varnish/libvmod-cookie) - A Varnish module for simpler use of the cookie header.
* [pixelnerve/BlockOpenNI](https://github.com/pixelnerve/BlockOpenNI) - A c++ wrapper for OpenNI.
* [osxfuse/fuse](https://github.com/osxfuse/fuse) - C-based FUSE for OS X API
* [jwr/msp430_usi_i2c](https://github.com/jwr/msp430_usi_i2c) - I2C for the MSP430 using the USI module
* [jssjr/collectd-write_graphite](https://github.com/jssjr/collectd-write_graphite) - Graphite output plugin for collectd
* [bvdberg/ctest](https://github.com/bvdberg/ctest) - ctest is a unit test framework for software written in C.
* [acg/lwpb](https://github.com/acg/lwpb) - Lightweight Protocol Buffers for C and Python
* [dmage/co2mon](https://github.com/dmage/co2mon) - CLI for MasterKit CO2 Monitor
* [cybergarage/mupnp](https://github.com/cybergarage/mupnp) - mUPnP for C is a development package for UPnP™ developers. CyberLink controls these protocols automatically, and supports to create your devices and control points quickly.
* [chokepoint/CryptHook](https://github.com/chokepoint/CryptHook) - TCP/UDP symmetric encryption tunnel wrapper
* [RandyGaul/AsciiEngine](https://github.com/RandyGaul/AsciiEngine) - Game engine written in C to create Ascii art games within the Windows console.
* [LemonCake/JsCoreEngineiOS](https://github.com/LemonCake/JsCoreEngineiOS) - Singleton wrapper class to process javascript in the background via JavascriptCore.
* [HalosGhost/shaman](https://github.com/HalosGhost/shaman) - A small, native C library and utility to fetch weather
* [syuhari/cocos2dx_recipe](https://github.com/syuhari/cocos2dx_recipe) - Cocos2d-x 開発のレシピのサンプルコード
* [ryanb/rmov](https://github.com/ryanb/rmov) - Ruby wrapper for the QuickTime C API.
* [ramonza/libcoro](https://github.com/ramonza/libcoro) - Lightweight C coroutines (derived from http://software.schmorp.de/pkg/libcoro.html)
* [mischasan/aho-corasick](https://github.com/mischasan/aho-corasick) - A-C implementation in "C". Tight-packed (interleaved) state-transition matrix -- as fast as it gets, as small as it gets.
* [microbuilder/LPC1114CodeBase](https://github.com/microbuilder/LPC1114CodeBase) - Open Source SW Library for NXP's LPC1114 ARM Cortex M0 MCU
* [lyosha/ctags-go](https://github.com/lyosha/ctags-go) - Go support for exuberant ctags
* [jwerle/progress.c](https://github.com/jwerle/progress.c) - Progress display lib for c
* [hibara/AttacheCase](https://github.com/hibara/AttacheCase) - file/folder encryption software for Windows ( C++Builder2010 Project Files )
* [geon/gloss](https://github.com/geon/gloss) - A bidirectional path tracer written in C.
* [ellzey/c_code_puzzles](https://github.com/ellzey/c_code_puzzles) - A random set of C specific bugs and brainteasers, most of which were found (and never reported LULZ) in real software. The names have been changed to protect the innocent(?)
* [Microsoft/WinObjC](https://github.com/Microsoft/WinObjC) - Objective-C for Windows
* [bagder/curl](https://github.com/bagder/curl) - Curl is a tool and libcurl is a library for transferring data with URL syntax, supporting FTP, FTPS, HTTP, HTTPS, GOPHER, TFTP, SCP, SFTP, TELNET, DICT, LDAP, LDAPS, FILE, IMAP, SMTP, POP3, RTSP and RTMP. libcurl offers a myriad of powerful features
* [cesanta/mongoose](https://github.com/cesanta/mongoose) - Embedded web server for C/C++
* [litehelpers/Cordova-sqlite-storage](https://github.com/litehelpers/Cordova-sqlite-storage) - A Cordova/PhoneGap plugin to open and use sqlite databases on Android/iOS/Windows Universal(8.1)/Amazon Fire-OS/WP(7/8) with HTML5/Web SQL API
* [luna/luna](https://github.com/luna/luna) - luna programming language - a small, elegant VM implemented in C
* [simtr/The-Powder-Toy](https://github.com/simtr/The-Powder-Toy) - Written in C++ and using SDL, The Powder Toy is a desktop version of the classic 'falling sand' physics sandbox, it simulates air pressure and velocity as well as heat.
* [couchbase/couchbase-lite-android](https://github.com/couchbase/couchbase-lite-android) - Lightweight, embedded, syncable NoSQL database engine for Android.
* [kellabyte/Haywire](https://github.com/kellabyte/Haywire) - Haywire is an asynchronous HTTP server framework written in C that's built using the event loop based libuv platform layer that node.js is built on top of.
* [riolet/nope.c](https://github.com/riolet/nope.c) - nope.c is a C language-based software platform for scalable server-side and networking applications. Think node.js for C programmers.
* [evan/memcached](https://github.com/evan/memcached) - A Ruby interface to the libmemcached C client
* [lukeredpath/libPusher](https://github.com/lukeredpath/libPusher) - An Objective-C interface to Pusher (pusherapp.com)
* [fletcher/MultiMarkdown-4](https://github.com/fletcher/MultiMarkdown-4) - C implementation of MultiMarkdown; almost complete rewrite of MMD 3 (which was aka "peg-multimarkdown").
* [bagder/c-ares](https://github.com/bagder/c-ares) - c-ares is a C library for asynchronous DNS requests
* [cesanta/smart.js](https://github.com/cesanta/smart.js) - Embedded Javascript engine for C/C++ with networking, file, database and device interfaces
* [vurtun/zahnrad](https://github.com/vurtun/zahnrad) - A small ANSI C gui toolkit
* [fileability/chocolat-public](https://github.com/fileability/chocolat-public) - Public bug tracker for the private chocolat project
* [couchbase/Android-Couchbase](https://github.com/couchbase/Android-Couchbase) - The android build for humans.
* [mirek/YAML.framework](https://github.com/mirek/YAML.framework) - Proper YAML support for Objective-C. Based on recommended libyaml.
* [monitoringartist/Zabbix-Docker-Monitoring](https://github.com/monitoringartist/Zabbix-Docker-Monitoring) - :whale: Monitoring of Docker containers (LXC/systemd Docker supported) - Zabbix template and Zabbix C module
* [torvalds/linux](https://github.com/torvalds/linux) - Linux kernel source tree
* [antirez/redis](https://github.com/antirez/redis) - Redis is an in-memory database that persists on disk. The data model is key-value, but many different kind of values are supported: Strings, Lists, Sets, Sorted Sets, Hashes, HyperLogLogs, Bitmaps.
* [git/git](https://github.com/git/git) - Git Source Code Mirror - This is a publish-only repository and all pull requests are ignored. Please follow Documentation/SubmittingPatches procedure for any of your improvements.
* [kripken/emscripten](https://github.com/kripken/emscripten) - Emscripten: An LLVM-to-JavaScript Compiler
* [irungentoo/toxcore](https://github.com/irungentoo/toxcore) - The future of online communications.
* [julycoding/The-Art-Of-Programming-By-July](https://github.com/julycoding/The-Art-Of-Programming-By-July) - 此为《编程之法：面试和算法心得》一书2014年6月老版本的原型，最新完整纸质版于2015年9月上市！
* [ggreer/the_silver_searcher](https://github.com/ggreer/the_silver_searcher) - A code-searching tool similar to ack, but faster.
* [php/php-src](https://github.com/php/php-src) - The PHP Interpreter
* [wg/wrk](https://github.com/wg/wrk) - Modern HTTP benchmarking tool
* [stedolan/jq](https://github.com/stedolan/jq) - Command-line JSON processor
* [libgit2/libgit2](https://github.com/libgit2/libgit2) - The Library
* [b4winckler/macvim](https://github.com/b4winckler/macvim) - Vim - the text editor - for Mac OS X
* [h2o/h2o](https://github.com/h2o/h2o) - H2O - the optimized HTTP/1, HTTP/2 server
* [sdegutis/mjolnir](https://github.com/sdegutis/mjolnir) - Lightweight automation and productivity app for OS X
* [okamstudio/godot](https://github.com/okamstudio/godot) - Godot Game Engine
* [twitter/twemproxy](https://github.com/twitter/twemproxy) - A fast, light-weight proxy for memcached and redis
* [octalmage/robotjs](https://github.com/octalmage/robotjs) - Node.js Desktop Automation.
* [memcached/memcached](https://github.com/memcached/memcached) - memcached development tree
* [antirez/disque](https://github.com/antirez/disque) - Disque is a distributed message broker
* [robertdavidgraham/masscan](https://github.com/robertdavidgraham/masscan) - TCP port scanner, spews SYN packets asynchronously, scanning entire Internet in under 5 minutes.
* [mozilla/firefox-ios](https://github.com/mozilla/firefox-ios) - Firefox for iOS
* [matz/streem](https://github.com/matz/streem) - prototype of stream based programming language
* [joyent/libuv](https://github.com/joyent/libuv) - Go to
* [coolwanglu/vim.js](https://github.com/coolwanglu/vim.js) - JavaScript port of Vim
* [alibaba/tengine](https://github.com/alibaba/tengine) - A distribution of Nginx with some advanced features
* [haiwen/seafile](https://github.com/haiwen/seafile) - Open source cloud storage with file encryption and group sharing, and emphasis on reliability and high performance.
* [mruby/mruby](https://github.com/mruby/mruby) - Lightweight Ruby
* [vmg/redcarpet](https://github.com/vmg/redcarpet) - The safe Markdown parser, reloaded.
* [facebook/watchman](https://github.com/facebook/watchman) - Watches files and records, or triggers actions, when they change.
* [yyuu/pyenv](https://github.com/yyuu/pyenv) - Simple Python version management
* [DrKLO/Telegram](https://github.com/DrKLO/Telegram) - Telegram for Android source
* [wishstudio/flinux](https://github.com/wishstudio/flinux) - Foreign LINUX - Run unmodified Linux applications inside Windows.
* [fastos/fastsocket](https://github.com/fastos/fastsocket) - Fastsocket is a highly scalable socket and its underlying networking implementation of Linux kernel. With the straight linear scalability, Fastsocket can provide extremely good performance in multicore machines. In addition, it is very easy to use and maintain. As a result, it has been deployed in the production environment of SINA.
* [lpereira/lwan](https://github.com/lpereira/lwan) - Experimental, scalable, high performance HTTP server
* [tmux/tmux](https://github.com/tmux/tmux) - tmux source code
* [cloudwu/skynet](https://github.com/cloudwu/skynet) - A lightweight online game framework
* [kr/beanstalkd](https://github.com/kr/beanstalkd) - Beanstalk is a simple, fast work queue.
* [Xfennec/progress](https://github.com/Xfennec/progress) - Linux tool to show progress for cp, rm, dd, ...
* [mofarrell/p2pvc](https://github.com/mofarrell/p2pvc) - A point to point color terminal video chat.
* [FFmpeg/FFmpeg](https://github.com/FFmpeg/FFmpeg) - mirror of git://source.ffmpeg.org/ffmpeg.git
* [jonas/tig](https://github.com/jonas/tig) - Text-mode interface for git
* [swoole/swoole-src](https://github.com/swoole/swoole-src) - Asynchronous & concurrent & distributed networking framework for PHP.
* [philipl/pifs](https://github.com/philipl/pifs) - πfs - the data-free filesystem!
* [joyent/http-parser](https://github.com/joyent/http-parser) - http request/response parser for c
* [nanomsg/nanomsg](https://github.com/nanomsg/nanomsg) - nanomsg library
* [libuv/libuv](https://github.com/libuv/libuv) - Cross-platform asychronous I/O
* [mpv-player/mpv](https://github.com/mpv-player/mpv) - Video player based on MPlayer/mplayer2
* [numpy/numpy](https://github.com/numpy/numpy) - Numpy main repository
* [micropython/micropython](https://github.com/micropython/micropython) - MicroPython - a lean and efficient Python implementation for microcontrollers and constrained systems
* [arut/nginx-rtmp-module](https://github.com/arut/nginx-rtmp-module) - NGINX-based Media Streaming Server
* [OpenKinect/libfreenect](https://github.com/OpenKinect/libfreenect) - Drivers and libraries for the Xbox Kinect device on WIndows, Linux, and OS X
* [awslabs/s2n](https://github.com/awslabs/s2n) - s2n : an implementation of the TLS/SSL protocols
* [visit1985/mdp](https://github.com/visit1985/mdp) - A command-line based markdown presentation tool.
* [SoftEtherVPN/SoftEtherVPN](https://github.com/SoftEtherVPN/SoftEtherVPN) - A Free Cross-platform Multi-protocol VPN Software, developed by SoftEther VPN Project at University of Tsukuba, Japan.
* [abrasive/shairport](https://github.com/abrasive/shairport) - Airtunes emulator! Shairport is no longer maintained.
* [laverdet/node-fibers](https://github.com/laverdet/node-fibers) - Fiber/coroutine support for v8 and node.
* [jedisct1/libsodium](https://github.com/jedisct1/libsodium) - A modern and easy-to-use crypto library.
* [synergy/synergy](https://github.com/synergy/synergy) - Share one mouse and keyboard between multiple computers on your desk.
* [Bilibili/ijkplayer](https://github.com/Bilibili/ijkplayer) - Android/iOS video player based on FFmpeg n2.7, with MediaCodec, VideoToolbox support.
* [jp9000/OBS](https://github.com/jp9000/OBS) - Open Broadcaster Software
* [shadowsocks/shadowsocks-android](https://github.com/shadowsocks/shadowsocks-android) - A Shadowsocks client for Android
* [kivy/python-for-android](https://github.com/kivy/python-for-android) - Turn your Python application into an Android APK - Build your own python and extension
* [allinurl/goaccess](https://github.com/allinurl/goaccess) - GoAccess is an open source real-time web log analyzer and interactive viewer that runs in a terminal in *nix systems.
* [probablycorey/wax](https://github.com/probablycorey/wax) - Wax is a framework that lets you write native iPhone apps in Lua.
* [mozilla/mozjpeg](https://github.com/mozilla/mozjpeg) - Improved JPEG encoder.
* [cloudius-systems/osv](https://github.com/cloudius-systems/osv) - OSv, a new operating system for the cloud.
* [buaazp/zimg](https://github.com/buaazp/zimg) - A lightweight and high performance image storage and processing system.
* [nginx/nginx-releases](https://github.com/nginx/nginx-releases) - * NOTE: This repository has been retired *. Complete (unofficial) history of nginx releases.  Please note that this repository is unofficial and pull requests have no chance of being merged. The proper way to submit changes to nginx is via the nginx development mailing list, see http://nginx.org/en/docs/contributing_changes.html.
* [nelhage/reptyr](https://github.com/nelhage/reptyr) - Reparent a running program to a new terminal
* [postgres/postgres](https://github.com/postgres/postgres) - Mirror of the official PostgreSQL GIT repository. Note that this is just a *mirror* - we don't work with pull requests on github. To contribute, please see http://wiki.postgresql.org/wiki/Submitting_a_Patch
* [msysgit/msysgit](https://github.com/msysgit/msysgit) - msysGit has been superseded by Git for Windows 2.x
* [keendreams/keen](https://github.com/keendreams/keen) - Keen Dreams on Greenlight!
* [vysheng/tg](https://github.com/vysheng/tg) - telegram-cli
* [krakjoe/pthreads](https://github.com/krakjoe/pthreads) - Threading for PHP - Share Nothing, Do Everything :)
* [google/ios-webkit-debug-proxy](https://github.com/google/ios-webkit-debug-proxy) - A DevTools proxy (WebKit Remote Debugging Protocol) for iOS devices (Safari Remote Web Inspector).
* [radare/radare2](https://github.com/radare/radare2) - unix-like reverse engineering framework and commandline tools
* [toland/qlmarkdown](https://github.com/toland/qlmarkdown) - QuickLook generator for Markdown files.
* [libgit2/rugged](https://github.com/libgit2/rugged) - ruby bindings to libgit2
* [zfsonlinux/zfs](https://github.com/zfsonlinux/zfs) - Native ZFS for Linux
* [mist64/xhyve](https://github.com/mist64/xhyve) - xhyve, a lightweight OS X virtualization solution
* [nicolasff/webdis](https://github.com/nicolasff/webdis) - A Redis HTTP interface with JSON output
* [linuxmint/Cinnamon](https://github.com/linuxmint/Cinnamon) - A Linux Desktop featuring a traditional layout, built from modern technology and introducing brand new innovative features.
* [RMerl/asuswrt-merlin](https://github.com/RMerl/asuswrt-merlin) - Enhanced version of Asus's router firmware (Asuswrt)
* [maciejczyzewski/retter](https://github.com/maciejczyzewski/retter) - A collection of hash functions, ciphers, tools, libraries, and materials related to cryptography. :closed_lock_with_key:
* [jp9000/obs-studio](https://github.com/jp9000/obs-studio) - OBS
* [huangz1990/annotated_redis_source](https://github.com/huangz1990/annotated_redis_source) - 带有详细注释的 Redis 2.6 源码
* [glfw/glfw](https://github.com/glfw/glfw) - A multi-platform library for OpenGL, window and input
* [id-Software/Quake-III-Arena](https://github.com/id-Software/Quake-III-Arena) - Quake III Arena GPL Source Release
* [robotmedia/RMStore](https://github.com/robotmedia/RMStore) - A lightweight iOS library for In-App Purchases
* [stevedekorte/io](https://github.com/stevedekorte/io) - Io programming language
* [zmap/zmap](https://github.com/zmap/zmap) - ZMap Internet Scanner
* [MarlinFirmware/Marlin](https://github.com/MarlinFirmware/Marlin) - Reprap FW with look ahead. SDcard and LCD support. It works on Gen6, Ultimaker, RAMPS and Sanguinololu
* [google/eddystone](https://github.com/google/eddystone) - Specification for Eddystone, an open beacon format from Google
* [bumptech/stud](https://github.com/bumptech/stud) - The Scalable TLS Unwrapping Daemon
* [ZipArchive/ZipArchive](https://github.com/ZipArchive/ZipArchive) - ZipArchive is a simple utility class for zipping and unzipping files on iOS and Mac.
* [freebsd/freebsd](https://github.com/freebsd/freebsd) - FreeBSD src tree
* [facebook/flashcache](https://github.com/facebook/flashcache) - A general purpose, write-back block cache for Linux.
* [ryanmjacobs/c](https://github.com/ryanmjacobs/c) - Compile and execute C "scripts" in one go!
* [Qihoo360/Atlas](https://github.com/Qihoo360/Atlas) - A high-performance and stable proxy for MySQL
* [wandenberg/nginx-push-stream-module](https://github.com/wandenberg/nginx-push-stream-module) - A pure stream http push technology for your Nginx setup. Comet made easy and really scalable.
* [id-Software/DOOM](https://github.com/id-Software/DOOM) - DOOM Open Source Release
* [glock45/iOS-Hierarchy-Viewer](https://github.com/glock45/iOS-Hierarchy-Viewer) - iOS Hierarchy viewer - View and Coredata debugging made easy
* [lxc/lxc](https://github.com/lxc/lxc) - LXC - Linux Containers
* [nodemcu/nodemcu-firmware](https://github.com/nodemcu/nodemcu-firmware) - lua based interactive firmware for mcu like esp8266
* [offensive-security/exploit-database](https://github.com/offensive-security/exploit-database) - The official Exploit Database repository
* [mongrel2/mongrel2](https://github.com/mongrel2/mongrel2) - The Mongrel2 Web Server Project
* [cuber/ngx_http_google_filter_module](https://github.com/cuber/ngx_http_google_filter_module) - Nginx Module for Google Mirror
* [WhisperSystems/Signal-iOS](https://github.com/WhisperSystems/Signal-iOS) - Free, world-wide, private messaging and phone calls for iPhone.
* [sqlcipher/sqlcipher](https://github.com/sqlcipher/sqlcipher) - SQLCipher is an SQLite extension that provides 256 bit AES encryption of database files.
* [shoes/shoes](https://github.com/shoes/shoes) - a tiny graphical app kit for ruby
* [ChrisJohnsen/tmux-MacOSX-pasteboard](https://github.com/ChrisJohnsen/tmux-MacOSX-pasteboard) - Notes and workarounds for accessing the Mac OS X pasteboard in tmux sessions. Note: The pu branch (“Proposed Updates”) may be rewound without notice.
* [yusugomori/DeepLearning](https://github.com/yusugomori/DeepLearning) - Deep Learning (Python, C/C++, Java, Scala, Go)
* [session-replay-tools/tcpcopy](https://github.com/session-replay-tools/tcpcopy) - An online request replication tool, also a tcp stream replay tool, fit for real testing, performance testing, stability testing, stress testing, load testing, smoke testing, etc
* [PromyLOPh/pianobar](https://github.com/PromyLOPh/pianobar) - Console-based pandora.com player
* [huangz1990/redis-3.0-annotated](https://github.com/huangz1990/redis-3.0-annotated) - 带有详细注释的 Redis 3.0 代码（annotated Redis 3.0 source code）。
* [ohler55/oj](https://github.com/ohler55/oj) - Optimized JSON
* [unbit/uwsgi](https://github.com/unbit/uwsgi) - uWSGI application server container
* [antirez/linenoise](https://github.com/antirez/linenoise) - A small self-contained alternative to readline and libedit
* [mbebenita/Broadway](https://github.com/mbebenita/Broadway) - A JavaScript H.264 decoder.
* [ejoy/ejoy2d](https://github.com/ejoy/ejoy2d) - A 2D Graphics Engine for Mobile Game
* [nviennot/tmate](https://github.com/nviennot/tmate) - Instant Terminal Sharing
* [c9s/Pux](https://github.com/c9s/Pux) - A High Performance PHP Router. PHP Router re-design
* [klange/toaruos](https://github.com/klange/toaruos) - Hobby kernel + userspace, built mostly from scratch.
* [phoboslab/jsmpeg-vnc](https://github.com/phoboslab/jsmpeg-vnc) - A low latency, high framerate screen sharing server for Windows and client for browsers
* [OpenRCT2/OpenRCT2](https://github.com/OpenRCT2/OpenRCT2) - An open source re-implementation of Roller Coaster Tycoon 2.
* [clowwindy/ShadowVPN](https://github.com/clowwindy/ShadowVPN) - Removed according to regulations.
* [pmwkaa/sophia](https://github.com/pmwkaa/sophia) - modern emeddable key-value database
* [pbatard/rufus](https://github.com/pbatard/rufus) - The Reliable USB Formatting Utility
* [gentilkiwi/mimikatz](https://github.com/gentilkiwi/mimikatz) - A little tool to play with Windows security
* [vim/vim](https://github.com/vim/vim) - The official Vim repository
* [videolan/vlc](https://github.com/videolan/vlc) - VLC media player - All pull requests are ignored, please follow https://wiki.videolan.org/Sending_Patches_VLC/
* [FreeRDP/FreeRDP](https://github.com/FreeRDP/FreeRDP) - FreeRDP is a free remote desktop protocol client
* [ffi/ffi](https://github.com/ffi/ffi) - Ruby FFI
* [apache/httpd](https://github.com/apache/httpd) - Mirror of Apache HTTP Server
* [twitter/fatcache](https://github.com/twitter/fatcache) - Memcache on SSD
* [yarrick/iodine](https://github.com/yarrick/iodine) - Official git repo for iodine dns tunnel
* [jonls/redshift](https://github.com/jonls/redshift) - Redshift adjusts the color temperature of your screen according to your surroundings. This may help your eyes hurt less if you are working in front of the screen at night.
* [rhomobile/rhodes](https://github.com/rhomobile/rhodes) - The Rhodes framework is a platform for building locally executing, device-optimized mobile applications for all major smartphone devices.
* [seL4/seL4](https://github.com/seL4/seL4) - The seL4 microkernel
* [aerospike/aerospike-server](https://github.com/aerospike/aerospike-server) - Aerospike Database Server – flash-optimized, in-memory, nosql database
* [alibaba/tsar](https://github.com/alibaba/tsar) - Taobao System Activity Reporter
* [tmm1/perftools.rb](https://github.com/tmm1/perftools.rb) - gperftools for ruby code
* [pornel/pngquant](https://github.com/pornel/pngquant) - Lossy PNG compressor — pngquant command and libimagequant library
* [GarageGames/Torque2D](https://github.com/GarageGames/Torque2D) - MIT Licensed Open Source version of Torque 2D from GarageGames
* [kennytm/iphone-private-frameworks](https://github.com/kennytm/iphone-private-frameworks) - Headers for private frameworks or undocumented interfaces of iPhoneOS 3.x or before (4.x is not supported yet).
* [Netflix/dynomite](https://github.com/Netflix/dynomite) - A generic dynamo implementation for different k-v storage engines
* [tcurdt/iProxy](https://github.com/tcurdt/iProxy) - Let's you connect your laptop to the iPhone to surf the web.
* [id-Software/Quake](https://github.com/id-Software/Quake) - Quake GPL Source Release
* [slact/nginx_http_push_module](https://github.com/slact/nginx_http_push_module) - Turn NGiNX into an adept HTTP push server.
* [irssi/irssi](https://github.com/irssi/irssi) - The client of the future
* [htacg/tidy-html5](https://github.com/htacg/tidy-html5) - The granddaddy of HTML tools, with support for modern standards
* [joyent/smartos-live](https://github.com/joyent/smartos-live) - For more information, please see http://smartos.org/  For any questions that aren't answered there, please join the SmartOS discussion list: http://smartos.org/smartos-mailing-list/
* [memononen/nanovg](https://github.com/memononen/nanovg) - Antialiased 2D vector drawing library on top of OpenGL for UI and visualizations.
* [mattn/go-sqlite3](https://github.com/mattn/go-sqlite3) - sqlite3 driver for go that using database/sql
* [hexchat/hexchat](https://github.com/hexchat/hexchat) - GTK+ IRC client -
* [LubosD/darling](https://github.com/LubosD/darling) - Darwin/OS X emulation layer for Linux
* [citusdata/pg_shard](https://github.com/citusdata/pg_shard) - PostgreSQL extension to scale out real-time reads and writes. Check out the mailing list at https://groups.google.com/group/pg_shard-users or read the docs at http://citusdata.com/docs/pg-shard
* [DNSPod/dnspod-sr](https://github.com/DNSPod/dnspod-sr) - A faster recursive dns server from DNSPod
* [RPISEC/MBE](https://github.com/RPISEC/MBE) - Course materials for Modern Binary Exploitation by RPISEC
* [rmtheis/tess-two](https://github.com/rmtheis/tess-two) - Fork of Tesseract Tools for Android.
* [baskerville/bspwm](https://github.com/baskerville/bspwm) - A tiling window manager based on binary space partitioning
* [madeye/gaeproxy](https://github.com/madeye/gaeproxy) - GAEProxy for Android
* [facebook/fishhook](https://github.com/facebook/fishhook) - A library that enables dynamically rebinding symbols in Mach-O binaries running on iOS.
* [yaoweibin/nginx_tcp_proxy_module](https://github.com/yaoweibin/nginx_tcp_proxy_module) - add the feature of tcp proxy with nginx, with health check and status monitor
* [rmagick-temp/rmagick](https://github.com/rmagick-temp/rmagick) - An interface to the ImageMagick and GraphicsMagick image processing libraries.
* [defuse/swatd](https://github.com/defuse/swatd) - Run a script when one or more sensors fail.
* [ging/licode](https://github.com/ging/licode) - Open Source Communication Provider based on WebRTC and Cloud technologies
* [codahale/bcrypt-ruby](https://github.com/codahale/bcrypt-ruby) - bcrypt-ruby is a Ruby binding for the OpenBSD bcrypt() password hashing algorithm, allowing you to easily store a secure hash of your users' passwords.
* [mamedev/mame](https://github.com/mamedev/mame) - MAME - Multiple Arcade Machine Emulator
* [jedisct1/dnscrypt-proxy](https://github.com/jedisct1/dnscrypt-proxy) - A tool for securing communications between a client and a DNS resolver
* [raspberrypi/userland](https://github.com/raspberrypi/userland) - Source code for ARM side libraries for interfacing to Raspberry Pi GPU.
* [seppo0010/rlite](https://github.com/seppo0010/rlite) - self-contained, serverless, zero-configuration, transactional redis-compatible database engine. rlite is to Redis what SQLite is to SQL.
* [github/brubeck](https://github.com/github/brubeck) - A Statsd-compatible metrics aggregator
* [ashima/webgl-noise](https://github.com/ashima/webgl-noise) - Procedural Noise Shader Routines compatible with WebGL
* [Uncodin/bypass](https://github.com/Uncodin/bypass) - Skip the HTML, Bypass takes markdown and renders it directly on Android and iOS.
* [EtchedPixels/FUZIX](https://github.com/EtchedPixels/FUZIX) - FuzixOS: Because Small Is Beautiful
* [tmk/tmk_keyboard](https://github.com/tmk/tmk_keyboard) - keyboard controller firmware for Atmel AVR USB family
* [munificent/wren](https://github.com/munificent/wren) - The Wren Programming Language
* [ardagnir/athame](https://github.com/ardagnir/athame) - Full vim for readline (bash, gdb, python, etc)
* [libretro/RetroArch](https://github.com/libretro/RetroArch) - Reference frontend for the libretro API. Cross-platform entertainment system.
* [Softmotions/ejdb](https://github.com/Softmotions/ejdb) - EJDB — Embedded JSON Database engine
* [davidfstr/rdiscount](https://github.com/davidfstr/rdiscount) - Discount (For Ruby) Implementation of John Gruber's Markdown
* [libgit2/pygit2](https://github.com/libgit2/pygit2) - Python bindings for libgit2
* [cuberite/cuberite](https://github.com/cuberite/cuberite) - A performant C++ Minecraft compatible game server
* [bitly/dablooms](https://github.com/bitly/dablooms) - scaling, counting, bloom filter library
* [erikfrey/bashreduce](https://github.com/erikfrey/bashreduce) - mapreduce in bash
* [centaurean/density](https://github.com/centaurean/density) - Superfast compression library
* [twitter/twemcache](https://github.com/twitter/twemcache) - Twemcache is the Twitter Memcached
* [libimobiledevice/libimobiledevice](https://github.com/libimobiledevice/libimobiledevice) - A cross-platform protocol library to communicate with iOS devices
* [mpc-hc/mpc-hc](https://github.com/mpc-hc/mpc-hc) - MPC-HC's main repository.  For support use our Trac: https://trac.mpc-hc.org/
* [xiehuc/pidgin-lwqq](https://github.com/xiehuc/pidgin-lwqq) - a pidgin plugin based on lwqq, a excellent safe useful library for webqq protocol
* [vk-com/kphp-kdb](https://github.com/vk-com/kphp-kdb) - VK-KittenPHP/DB/Engine suite
* [tmm1/rblineprof](https://github.com/tmm1/rblineprof) - line-profiler for ruby
* [mdirolf/nginx-gridfs](https://github.com/mdirolf/nginx-gridfs) - Nginx module for serving files from MongoDB's GridFS
* [cundong/SmartAppUpdates](https://github.com/cundong/SmartAppUpdates) - Android应用增量更新
* [SpiderLabs/ModSecurity](https://github.com/SpiderLabs/ModSecurity) - ModSecurity is an open source, cross platform web application firewall (WAF) engine for Apache, IIS and Nginx that is developed by Trustwave's SpiderLabs. It has a robust event-based programming language which provides protection from a range of attacks against web applications and allows for HTTP traffic monitoring, logging and real-time analysis. With over 10,000 deployments world-wide, ModSecurity is the most widely deployed WAF in existence.
* [EricssonResearch/openwebrtc](https://github.com/EricssonResearch/openwebrtc) - A mobile-first WebRTC client framework for building native apps
* [ossec/ossec-hids](https://github.com/ossec/ossec-hids) - OSSEC is an Open Source Host-based Intrusion Detection System that performs log analysis, file integrity checking, policy monitoring, rootkit detection, real-time alerting and active response.
* [rofl0r/proxychains-ng](https://github.com/rofl0r/proxychains-ng) - proxychains ng (new generation) - a preloader which hooks calls to sockets in dynamically linked programs and redirects it through one or more socks/http proxies. continuation of the unmaintained proxychains project.
* [texane/stlink](https://github.com/texane/stlink) - stm32 discovery line linux programmer
* [Qihoo360/phptrace](https://github.com/Qihoo360/phptrace) - A tracing and troubleshooting tool for PHP scripts.
* [glyptodon/guacamole-server](https://github.com/glyptodon/guacamole-server) - The server-side, native components that form the Guacamole proxy.
* [tj/histo](https://github.com/tj/histo) - beautiful charts in the terminal for static or streaming data
* [Cyan4973/lz4](https://github.com/Cyan4973/lz4) - Extremely Fast Compression algorithm
* [nsf/termbox](https://github.com/nsf/termbox) - Library for writing text-based user interfaces
* [plusvic/yara](https://github.com/plusvic/yara) - The pattern matching swiss knife
* [facebook/fb-adb](https://github.com/facebook/fb-adb) - A better shell for Android devices
* [geany/geany](https://github.com/geany/geany) - A fast and lightweight IDE
* [fontforge/fontforge](https://github.com/fontforge/fontforge) - Free (libre) font editor for Windows, Mac OS X and GNU+Linux
* [EyalAr/lwip](https://github.com/EyalAr/lwip) - Light Weight Image Processor for NodeJS
* [stefanesser/dumpdecrypted](https://github.com/stefanesser/dumpdecrypted) - Dumps decrypted mach-o files from encrypted iPhone applications from memory to disk. This tool is necessary for security researchers to be able to look under the hood of encryption.
* [spotify/sparkey](https://github.com/spotify/sparkey) - Simple constant key/value storage library, for read-heavy systems with infrequent large bulk inserts.
* [pipelinedb/pipelinedb](https://github.com/pipelinedb/pipelinedb) - The Streaming SQL Database
* [Tox/toxic](https://github.com/Tox/toxic) - CLI Tox client
* [LuaDist/lua](https://github.com/LuaDist/lua) - The Lua programming language with CMake based build
* [charliesome/jsos](https://github.com/charliesome/jsos) - An operating system written in JavaScript
* [iMoreApps/ffmpeg-avplayer-for-ios](https://github.com/iMoreApps/ffmpeg-avplayer-for-ios) - A tiny but powerful video player framework for iOS developers.
* [kripken/BananaBread](https://github.com/kripken/BananaBread) - BananaBread is a C++ 3D game engine that runs on the web using JavaScript+WebGL+HTML
* [i3/i3](https://github.com/i3/i3) - A better tiling and dynamic window manager
* [Cyan4973/zstd](https://github.com/Cyan4973/zstd) - Zstandard - Fast and efficient compression algorithm
* [SOHUDBA/SOHU-DBProxy](https://github.com/SOHUDBA/SOHU-DBProxy) - 搜狐公司强大的数据库中间件
* [havlenapetr/FFMpeg](https://github.com/havlenapetr/FFMpeg) - this is port of ffmpeg for android (this is app, but in future i will do android lib from it and then system will be able to convert videos automatically)
* [OculusVR/RiftDK1](https://github.com/OculusVR/RiftDK1) - Firmware, Schematics, and Mechanicals for the Oculus Rift Development Kit 1
* [naelstrof/maim](https://github.com/naelstrof/maim) - maim (make image) takes screenshots of your desktop. It has options to take only a region, and relies on slop to query for regions. maim is supposed to be an improved scrot.
* [rebol/rebol](https://github.com/rebol/rebol) - Source code for the Rebol interpreter
* [alols/xcape](https://github.com/alols/xcape) - Linux utility to configure modifier keys to act as other keys when pressed and released on their own.
* [gluster/glusterfs](https://github.com/gluster/glusterfs) - Gluster Filesystem - (this is only a public mirror)
* [jlamarche/iOS-OpenGLES-Stuff](https://github.com/jlamarche/iOS-OpenGLES-Stuff) - Various scripts, utils, and code examples for OpenGL ES programming for iOS
* [notsecure/uTox](https://github.com/notsecure/uTox) - Lightweight Tox client
* [cloudwu/mptun](https://github.com/cloudwu/mptun) - Multi-path Tunnel
* [ice799/memprof](https://github.com/ice799/memprof) - A Ruby gem for memory profiling
* [uzbl/uzbl](https://github.com/uzbl/uzbl) - A web browser that adheres to the unix philosophy.
* [robertdavidgraham/heartleech](https://github.com/robertdavidgraham/heartleech) - Demonstrates the "heartbleed" problem using full OpenSSL stack
* [BohuTANG/nessDB](https://github.com/BohuTANG/nessDB) - A very fast transactional key-value, embedded database storage engine.
* [coolstar/RecordMyScreen](https://github.com/coolstar/RecordMyScreen) - Record the display even on non-jailbroken iPhones.
* [mdaines/viz.js](https://github.com/mdaines/viz.js) - A hack to put GraphViz on the web.
* [OpenVPN/openvpn](https://github.com/OpenVPN/openvpn) - OpenVPN  is  an open source VPN daemon
* [krakjoe/phpdbg](https://github.com/krakjoe/phpdbg) - The Interactive PHP Debugger
* [varnish/hitch](https://github.com/varnish/hitch) - A scalable TLS proxy.
* [wiredtiger/wiredtiger](https://github.com/wiredtiger/wiredtiger) - WiredTiger's source tree
* [google/upb](https://github.com/google/upb) - small, fast parsers for the 21st century
* [fileability/Ingredients](https://github.com/fileability/Ingredients) - A Cocoa documentation viewer.
* [yrutschle/sslh](https://github.com/yrutschle/sslh) - Applicative Protocol Multiplexer (e.g. share SSH and HTTPS on the same port)
* [tarantool/tarantool](https://github.com/tarantool/tarantool) - Get your data in RAM. Get compute close to data. Enjoy the performance.
* [jwiegley/git-scripts](https://github.com/jwiegley/git-scripts) - A bunch of random scripts I've either written, downloaded or clipped from #git.
* [siemens/jailhouse](https://github.com/siemens/jailhouse) - Linux-based partitioning hypervisor
* [jcupitt/libvips](https://github.com/jcupitt/libvips) - A fast image processing library with low memory needs.
* [cisco/thor](https://github.com/cisco/thor) - Thor Video Codec
* [msanders/autopy](https://github.com/msanders/autopy) - A simple, cross-platform GUI automation toolkit for Python.
* [dtrace4linux/linux](https://github.com/dtrace4linux/linux) - dtrace for linux - kernel driver and userland tools
* [vlfeat/vlfeat](https://github.com/vlfeat/vlfeat) - An open library of computer vision algorithms
* [sumatrapdfreader/sumatrapdf](https://github.com/sumatrapdfreader/sumatrapdf) - SumatraPDF reader
* [darktable-org/darktable](https://github.com/darktable-org/darktable) - darktable main repository
* [kevinlawler/kona](https://github.com/kevinlawler/kona) - Open-source implementation of the K programming language
* [adoxa/ansicon](https://github.com/adoxa/ansicon) - Process ANSI escape sequences for Windows console programs.
* [mattconnolly/ZipArchive](https://github.com/mattconnolly/ZipArchive) - zip archive processing for Cocoa - iPhone and OS X
* [moyix/panda](https://github.com/moyix/panda) - Platform for Architecture-Neutral Dynamic Analysis
* [i-rinat/freshplayerplugin](https://github.com/i-rinat/freshplayerplugin) - ppapi2npapi compatibility layer
* [urbit/urbit](https://github.com/urbit/urbit) - an operating function
* [hishamhm/htop](https://github.com/hishamhm/htop) - htop is an interactive text-mode process viewer for Linux. It aims to be a better 'top'.
* [python-greenlet/greenlet](https://github.com/python-greenlet/greenlet) - Lightweight in-process concurrent programming
* [nmathewson/Libevent](https://github.com/nmathewson/Libevent) - Nick's public libevent repository.  The official repository is at         git://levent.git.sourceforge.net/gitroot/levent/libevent
* [openvswitch/ovs](https://github.com/openvswitch/ovs) - Open vSwitch
* [Teaonly/android-eye](https://github.com/Teaonly/android-eye) - Change your android phone to surveillance camera
* [irtimmer/moonlight-embedded](https://github.com/irtimmer/moonlight-embedded) - Gamestream client for embedded systems
* [vstakhov/libucl](https://github.com/vstakhov/libucl) - Universal configuration library parser
* [qemu/qemu](https://github.com/qemu/qemu) - Official QEMU mirror
* [antirez/dump1090](https://github.com/antirez/dump1090) - Dump1090 is a simple Mode S decoder for RTLSDR devices
* [appunite/AndroidFFmpeg](https://github.com/appunite/AndroidFFmpeg) - FFmpeg build for android random architectures with example jni
* [patjak/bcwc_pcie](https://github.com/patjak/bcwc_pcie) - Reverse engineered Linux driver for the Broadcom 1570 PCIe webcam
* [douban/beansdb](https://github.com/douban/beansdb) - Yet anonther distributed key-value storage system from Douban Inc.
* [HunterHillegas/iOS-BetaBuilder](https://github.com/HunterHillegas/iOS-BetaBuilder) - MacOS X tool designed to simplify creating and distributing beta releases of iOS apps.
* [notro/fbtft](https://github.com/notro/fbtft) - Linux Framebuffer drivers for small TFT LCD display modules
* [gamelinux/passivedns](https://github.com/gamelinux/passivedns) - A network sniffer that logs all DNS server replies for use in a passive DNS setup
* [c9s/r3](https://github.com/c9s/r3) - libr3 is a high-performance path dispatching library. It compiles your route paths into a prefix tree (trie). By using the constructed prefix trie in the start-up time, you may dispatch your routes with efficiency
* [systemd/systemd](https://github.com/systemd/systemd) - systemd upstream
* [signal11/hidapi](https://github.com/signal11/hidapi) - A Simple library for communicating with USB and Bluetooth HID devices on Linux, Mac, and Windows.
* [ofTheo/ofxKinect](https://github.com/ofTheo/ofxKinect) - legacy openFrameworks wrapper for the xbox kinect (OF pre-0.8.0+ only) - ofxKinect is now included and is being maintained in OF releases
* [vmg/houdini](https://github.com/vmg/houdini) - The Escapist
* [droe/sslsplit](https://github.com/droe/sslsplit) - Transparent and scalable SSL/TLS interception
* [espruino/Espruino](https://github.com/espruino/Espruino) - The Espruino JavaScript interpreter - Official Repo
* [sleuthkit/sleuthkit](https://github.com/sleuthkit/sleuthkit) - The Sleuth Kit® (TSK) is a library and collection of command line digital forensics tools that allow you to investigate volume and file system data. The library can be incorporated into larger digital forensics tools and the command line tools can be directly used to find evidence.
* [karthick18/inception](https://github.com/karthick18/inception) - Inception movie explained programmatically
* [stefanhafeneger/PushMeBaby](https://github.com/stefanhafeneger/PushMeBaby) - iOS Push Notification Debug App
* [hpricot/hpricot](https://github.com/hpricot/hpricot) - Hpricot has ended. Please consider an alternative like nokogiri.
* [nikhilm/uvbook](https://github.com/nikhilm/uvbook) - An Introduction to libuv
* [jbangert/trapcc](https://github.com/jbangert/trapcc) - Computing with traps
* [acassen/keepalived](https://github.com/acassen/keepalived) - Keepalived
* [tiancaiamao/go-internals](https://github.com/tiancaiamao/go-internals) - dig into implemention of the go programming language
* [weechat/weechat](https://github.com/weechat/weechat) - The extensible chat client.
* [machinezone/tcpkali](https://github.com/machinezone/tcpkali) - Fast multi-core TCP and WebSockets load generator.
* [zsh-users/zsh](https://github.com/zsh-users/zsh) - Mirror of the Z shell source code repository.
* [saghul/pyuv](https://github.com/saghul/pyuv) - Python interface for libuv
* [mbedmicro/mbed](https://github.com/mbedmicro/mbed) - mbed libraries and tools
* [ktap/ktap](https://github.com/ktap/ktap) - A lightweight script-based dynamic tracing tool for Linux
* [brianmario/escape_utils](https://github.com/brianmario/escape_utils) - Faster string escaping routines for your ruby apps
* [RIOT-OS/RIOT](https://github.com/RIOT-OS/RIOT) - RIOT -  The friendly OS for IoT
* [Ettercap/ettercap](https://github.com/Ettercap/ettercap) - Ettercap Project
* [vanhauser-thc/thc-hydra](https://github.com/vanhauser-thc/thc-hydra) - hydra
* [robertdavidgraham/robdns](https://github.com/robertdavidgraham/robdns) - A fast DNS server based on C10M principles
* [psankar/simplefs](https://github.com/psankar/simplefs) - A simple, kernel-space, on-disk filesystem from the scratch
* [libpd/libpd](https://github.com/libpd/libpd) - Pure Data embeddable audio synthesis library
* [johnkerl/miller](https://github.com/johnkerl/miller) - Miller is like sed, awk, cut, join, and sort for name-indexed data such as CSV
* [id-Software/Quake-2](https://github.com/id-Software/Quake-2) - Quake 2 GPL Source Release
* [darkk/redsocks](https://github.com/darkk/redsocks) - transparent redirector of any TCP connection to proxy
* [rentzsch/markdownlive](https://github.com/rentzsch/markdownlive) - Purpose-built Markdown Editor for Mac OS X with Live Preview
* [knopwob/dunst](https://github.com/knopwob/dunst) - lightweight and customizable notification daemon
* [tmm1/pygments.rb](https://github.com/tmm1/pygments.rb) - pygments syntax highlighting in ruby
* [mtoyoda/sl](https://github.com/mtoyoda/sl) - SL(1): Cure your bad habit of mistyping
* [kohler/gifsicle](https://github.com/kohler/gifsicle) - Gifsicle is a suite of programs for manipulating GIF images and animations.
* [applidium/Vim](https://github.com/applidium/Vim) - Port of the Vim text editor to the iOS
* [douglascrockford/JSMin](https://github.com/douglascrockford/JSMin) - JavaScript Minification Filter
* [minix3/minix](https://github.com/minix3/minix) - MINIX 3 (mirror)
* [jklmnn/imagejs](https://github.com/jklmnn/imagejs) - Small tool to package javascript into a valid image file.
* [mmin18/WaxPatch](https://github.com/mmin18/WaxPatch) - Dynamically load a lua script to change the behavior of your iOS application.
* [jech/polipo](https://github.com/jech/polipo) - The Polipo caching HTTP proxy
* [TouchCode/TouchXML](https://github.com/TouchCode/TouchXML) - Official "clone" of TouchXML from TouchCode
* [x0r1/jellyfish](https://github.com/x0r1/jellyfish) - GPU rootkit PoC by Team Jellyfish
* [paparazzi/paparazzi](https://github.com/paparazzi/paparazzi) - Paparazzi is a free and open-source hardware and software project for unmanned (air) vehicles. This is the main software repository.
* [kripken/lua.vm.js](https://github.com/kripken/lua.vm.js) - The Lua VM, on the Web
* [cloudozer/ling](https://github.com/cloudozer/ling) - Erlang on Xen
* [bonzini/qboot](https://github.com/bonzini/qboot) - Minimal x86 firmware for booting Linux kernels
* [alibaba/LVS](https://github.com/alibaba/LVS) - A distribution of Linux Virtual Server with some advanced features. It introduces a new packet forwarding method - FULLNAT other than NAT/Tunneling/DirectRouting, and defense mechanism against synflooding attack - SYNPROXY.
* [ZBar/ZBar](https://github.com/ZBar/ZBar) - Clone of the mercurial repository http://zbar.hg.sourceforge.net:8000/hgroot/zbar/zbar
* [toland/patron](https://github.com/toland/patron) - Ruby HTTP client based on libcurl
* [libgit2/php-git](https://github.com/libgit2/php-git) - PHP bindings for libgit2
* [sheepdog/sheepdog](https://github.com/sheepdog/sheepdog) - Distributed Storage System for QEMU
* [mrrrgn/simple-rootkit](https://github.com/mrrrgn/simple-rootkit) - A simple attack against gcc and Python via kernel module, with highly detailed comments.
* [klange/nyancat](https://github.com/klange/nyancat) - Nyancat in your terminal, rendered through ANSI escape sequences. This is the source for the Debian package `nyancat`.
* [bwalex/tc-play](https://github.com/bwalex/tc-play) - Free and simple TrueCrypt Implementation based on dm-crypt
* [djcb/mu](https://github.com/djcb/mu) - maildir indexer/searcher + emacs mail client + guile bindings
* [sufficientlysecure/ad-away](https://github.com/sufficientlysecure/ad-away) - AdAway is an open source ad blocker for Android using the hosts file.
* [matsumoto-r/ngx_mruby](https://github.com/matsumoto-r/ngx_mruby) - ngx_mruby - A Fast and Memory-Efficient Web Server Extension Mechanism Using Scripting Language mruby for nginx
* [sickill/stderred](https://github.com/sickill/stderred) - stderr in red
* [perl11/potion](https://github.com/perl11/potion) - _why the lucky stiff's little language (the official repo... until _why returns)
* [0intro/plan9](https://github.com/0intro/plan9) - Plan 9 from Bell Labs
* [axiak/pybloomfiltermmap](https://github.com/axiak/pybloomfiltermmap) - Fast Python Bloom Filter using Mmap
* [Rdatatable/data.table](https://github.com/Rdatatable/data.table) - R's data.table package extends data.frame. More info:
* [openzfsonosx/zfs](https://github.com/openzfsonosx/zfs) - OpenZFS on OS X
* [Olde-Skuul/doom3do](https://github.com/Olde-Skuul/doom3do) - The complete archive for DOOM for the 3DO
* [hyperic/sigar](https://github.com/hyperic/sigar) - System Information Gatherer And Reporter
* [TeamWin/Team-Win-Recovery-Project](https://github.com/TeamWin/Team-Win-Recovery-Project) - Core recovery files for the Team Win Recovery Project (T.W.R.P)
* [HarveyHunt/howm](https://github.com/HarveyHunt/howm) - A lightweight, X11 tiling window manager that behaves like vim
* [answer-huang/dSYMTools](https://github.com/answer-huang/dSYMTools) - dSYM analyze
* [awesomeWM/awesome](https://github.com/awesomeWM/awesome) - awesome window manager
* [MiCode/Xiaomi_Kernel_OpenSource](https://github.com/MiCode/Xiaomi_Kernel_OpenSource) - Xiaomi kernel OpenSource：cancro-kk-oss(contain MI 3W, MI 3C, MI 4 series, MI NOTE), armani-jb-oss(H1S), dior-kk-oss(HM-NOTE-LTE), ferrari-l-oss(Xiaomi 4i)
* [sass/sassc](https://github.com/sass/sassc) - libsass command line driver
* [haad/proxychains](https://github.com/haad/proxychains) - proxychains - a tool that forces any TCP connection made by any given application to follow through proxy like TOR or any other SOCKS4, SOCKS5 or HTTP(S) proxy.  Supported auth-types: "user/pass" for SOCKS4/5, "basic" for HTTP.
* [atgreen/libffi](https://github.com/atgreen/libffi) - A portable foreign-function interface library.
* [krakjoe/apcu](https://github.com/krakjoe/apcu) - APCu - APC User Cache
* [brho/plan9](https://github.com/brho/plan9) - UC Berkeley release of Plan 9 under the GPLv2
* [magnumripper/JohnTheRipper](https://github.com/magnumripper/JohnTheRipper) - Jumbo patches for John the Ripper. The "bleeding-jumbo" branch (default) is based on 1.8.0-Jumbo-1. The "master" branch is just a copy of Solar's core (aka "john proper", as in non-Jumbo) CVS repo.
* [simpl/ngx_devel_kit](https://github.com/simpl/ngx_devel_kit) - Nginx Development Kit - an Nginx module that adds additional generic tools that module developers can use in their own modules
* [martanne/vis](https://github.com/martanne/vis) - a vim like text editor
* [oneoo/alilua](https://github.com/oneoo/alilua) - epoll/kqueue+lua based web server
* [dlundquist/sniproxy](https://github.com/dlundquist/sniproxy) - Proxies incoming HTTP and TLS connections based on the hostname contained in the initial request of the TCP session.
* [boothj5/profanity](https://github.com/boothj5/profanity) - Ncurses based XMPP client
* [LemonBoy/bar](https://github.com/LemonBoy/bar) - A featherweight, lemon-scented, bar based on xcb
* [ohler55/ox](https://github.com/ohler55/ox) - Ruby Optimized XML Parser
* [FFTW/fftw3](https://github.com/FFTW/fftw3) - This is the official repository for the FFTW Fourier transform library, version 3.x
* [FauxFaux/PuTTYTray](https://github.com/FauxFaux/PuTTYTray) - A continuation of Barry Haanstra (haanstra.eu)'s PuTTYTray
* [lsalzman/enet](https://github.com/lsalzman/enet) - ENet reliable UDP networking library
* [Phildo/pixQL](https://github.com/Phildo/pixQL) - SQL for image processing
* [ConradIrwin/showterm](https://github.com/ConradIrwin/showterm) - The rubygem to upload to http://showterm.io
* [slash-lang/slash](https://github.com/slash-lang/slash) - A new language for the web
* [fukuchi/libqrencode](https://github.com/fukuchi/libqrencode) - QR Code encoding library
* [freebsd/pkg](https://github.com/freebsd/pkg) - Package management tool for FreeBSD. Help at #pkgng on Freenode or pkg@FreeBSD.org
* [google/latency-benchmark](https://github.com/google/latency-benchmark) - Tests web browser input latency and jank
* [mattgodbolt/zindex](https://github.com/mattgodbolt/zindex) - Create an index on a compressed text file
* [2ndQuadrant/repmgr](https://github.com/2ndQuadrant/repmgr) - PostgreSQL Replication Manager
* [ARMmbed/mbedtls](https://github.com/ARMmbed/mbedtls) - An open source, portable, easy to use, readable and flexible SSL library
* [bither/bither-android-lib](https://github.com/bither/bither-android-lib) - Bither Android Library
* [neilalexander/sigmavpn](https://github.com/neilalexander/sigmavpn) - Light-weight, secure and modular VPN solution
* [crosslife/OpenBird](https://github.com/crosslife/OpenBird) - Flappy Bird written in cocos2dx
* [quantcast/qfs](https://github.com/quantcast/qfs) - Quantcast File System
* [openresty/redis2-nginx-module](https://github.com/openresty/redis2-nginx-module) - Nginx upstream module for the Redis 2.0 protocol
* [madler/zlib](https://github.com/madler/zlib) - A massively spiffy yet delicately unobtrusive compression library.
* [oNaiPs/droidVncServer](https://github.com/oNaiPs/droidVncServer) - VNC server for Android devices.
* [confluentinc/bottledwater-pg](https://github.com/confluentinc/bottledwater-pg) - Change data capture from PostgreSQL into Kafka
* [antirez/smaz](https://github.com/antirez/smaz) - Small strings compression library
* [gittup/tup](https://github.com/gittup/tup) - Tup is a file-based build system.
* [madeye/proxydroid](https://github.com/madeye/proxydroid) - Global Proxy for Android
* [id-Software/DOOM-iOS](https://github.com/id-Software/DOOM-iOS) - DOOM Classic for iOS Source Release
* [vkholodkov/nginx-upload-module](https://github.com/vkholodkov/nginx-upload-module) - A module for nginx web server for handling file uploads using multipart/form-data encoding (RFC 1867).
* [macournoyer/tinyrb](https://github.com/macournoyer/tinyrb) - The tiny and fast (subset of) Ruby VM that loves you like you are
* [SirCmpwn/sway](https://github.com/SirCmpwn/sway) - i3-compatible window manager for Wayland (WIP)
* [tsgates/mbox](https://github.com/tsgates/mbox) - A lightweight sandbox tool for non-root users
* [libarchive/libarchive](https://github.com/libarchive/libarchive) - Multi-format archive and compression library
* [alonho/pytrace](https://github.com/alonho/pytrace) - pytrace is a fast python tracer. it records function calls, arguments and return values. can be used for debugging and profiling.
* [mopemope/meinheld](https://github.com/mopemope/meinheld) - meinheld is a high performance asynchronous WSGI Web Server (based on picoev)
* [ldc-developers/ldc](https://github.com/ldc-developers/ldc) - The LLVM-based D compiler.
* [warmcat/libwebsockets](https://github.com/warmcat/libwebsockets) - canonical libwebsockets.org websocket library
* [nanorc/nanorc](https://github.com/nanorc/nanorc) - Improved syntax highlighting for GNU nano
* [AlexDenisov/iActiveRecord](https://github.com/AlexDenisov/iActiveRecord) - ActiveRecord for iOS without CoreData, only SQLite
* [ghughes/fruitstrap](https://github.com/ghughes/fruitstrap) - Install and debug iPhone apps from the command line, without using Xcode
* [dorimanx/exfat-nofuse](https://github.com/dorimanx/exfat-nofuse) - Android ARM Linux non-fuse read/write kernel driver for exFat and VFat Android file systems
* [Cyan4973/xxHash](https://github.com/Cyan4973/xxHash) - Extremely fast non-cryptographic hash algorithm
* [shaunlebron/blinky](https://github.com/shaunlebron/blinky) - Exploring peripheral vision in games (using Quake)
* [nigels-com/glew](https://github.com/nigels-com/glew) - The OpenGL Extension Wrangler Library
* [daoluan/decode-memcached](https://github.com/daoluan/decode-memcached) - memcached 源码剖析注释
* [samdmarshall/SDMMobileDevice](https://github.com/samdmarshall/SDMMobileDevice) - MobileDevice Implementation
* [psgroove/psgroove](https://github.com/psgroove/psgroove) - PSGroove
* [msgpack/msgpack-ruby](https://github.com/msgpack/msgpack-ruby) - MessagePack implementation for Ruby / msgpack.org[Ruby]
* [AOP-PHP/AOP](https://github.com/AOP-PHP/AOP) - AOP in PHP
* [mariadb-corporation/MaxScale](https://github.com/mariadb-corporation/MaxScale) - A content aware, plug-able proxy server.           Discuss @: maxscale@googlegroups.com
* [WiringPi/WiringPi](https://github.com/WiringPi/WiringPi) - Gordon's Arduino wiring-like WiringPi Library for the Raspberry Pi
* [DaveDavenport/rofi](https://github.com/DaveDavenport/rofi) - Rofi: A window switcher, run dialog and dmenu replacement
* [darwin-on-arm/xnu](https://github.com/darwin-on-arm/xnu) - Porting the Darwin kernel to the AArch64/ARMv7/ARMv6-A architectures.
* [rflynn/imgmin](https://github.com/rflynn/imgmin) - Lossy image optimization
* [lwfinger/rtl8188eu](https://github.com/lwfinger/rtl8188eu) - Repository for stand-alone RTL8188EU driver.
* [libharu/libharu](https://github.com/libharu/libharu) - libharu - free PDF library
* [muennich/sxiv](https://github.com/muennich/sxiv) - Simple X Image Viewer
* [laruence/yac](https://github.com/laruence/yac) - A fast shared memory user data cache for PHP
* [ellzey/libevhtp](https://github.com/ellzey/libevhtp) - A more flexible replacement for libevent's http API.
* [happyfish100/fastdfs](https://github.com/happyfish100/fastdfs) - FastDFS is an open source high performance distributed file system (DFS). It's major functions include: file storing, file syncing and file accessing, and design for high capacity and load balance.
* [geocommons/geocoder](https://github.com/geocommons/geocoder) - Modular Street Address Geocoder
* [douglascrockford/DEC64](https://github.com/douglascrockford/DEC64) - Decimal floating point
* [pfq/PFQ](https://github.com/pfq/PFQ) - Functional Networking Framework for Multi-Core Architectures
* [danielfrg/word2vec](https://github.com/danielfrg/word2vec) - Python interface to Google word2vec
* [crmulliner/adbi](https://github.com/crmulliner/adbi) - Android Dynamic Binary Instrumentation Toolkit
* [RT-Thread/rt-thread](https://github.com/RT-Thread/rt-thread) - RT-Thread is an open source real-time operating system for embedded devices from China.
* [indutny/bud](https://github.com/indutny/bud) - Bud - The TLS Terminator
* [cherokee/webserver](https://github.com/cherokee/webserver) - Cherokee Web Server
* [st3fan/ios-openssl](https://github.com/st3fan/ios-openssl) - Port of OpenSSL for iOS
* [planetbeing/iphonelinux](https://github.com/planetbeing/iphonelinux) - Port Linux to the iPhone
* [SamyPesse/devos](https://github.com/SamyPesse/devos) - (Very) basic UNIX-like operating system built when I was younger
* [rxi/lovedos](https://github.com/rxi/lovedos) - A framework for making 2D DOS games in Lua
* [feeley/gambit](https://github.com/feeley/gambit) - Gambit is an efficient implementation of the Scheme programming language.
* [urbit/archaeology](https://github.com/urbit/archaeology) - An Operating Function
* [parrot/parrot](https://github.com/parrot/parrot) - Parrot Virtual Machine
* [zenovich/runkit](https://github.com/zenovich/runkit) - Runkit that works!
* [carlosgs/Cyclone-PCB-Factory](https://github.com/carlosgs/Cyclone-PCB-Factory) - Cyclone (Circuit Cloner) is a CNC mill intended for PCB manufacturing.
* [Visgean/Zeus](https://github.com/Visgean/Zeus) - NOT MY CODE! Zeus trojan horse - leaked in 2011, I am not the author, I have created this repo to simplify access to those who want to study it.
* [bitly/simplehttp](https://github.com/bitly/simplehttp) - a family of libraries and daemons for building scalable web infrastructure
* [emgram769/lighthouse](https://github.com/emgram769/lighthouse) - A simple scriptable popup dialog to run on X.
* [elua/elua](https://github.com/elua/elua) - eLua Project on GitHub
* [snavely/bundler_sfm](https://github.com/snavely/bundler_sfm) - Bundler Structure from Motion Toolkit
* [FreeRDP/Remmina](https://github.com/FreeRDP/Remmina) - The GTK+ Remmina Remote Desktop Client
* [chelyaev/ffmpeg-tutorial](https://github.com/chelyaev/ffmpeg-tutorial) - A set of tutorials that demonstrates how to write a video player based on FFmpeg
* [benblazak/ergodox-firmware](https://github.com/benblazak/ergodox-firmware) - firmware for the ergoDOX keyboard
* [Microsoft/Windows-driver-samples](https://github.com/Microsoft/Windows-driver-samples) - This repo contains driver samples prepared for use with Microsoft Visual Studio and the Windows Driver Kit (WDK). It contains both Universal Windows Driver and desktop-only driver samples.
* [McNopper/OpenGL](https://github.com/McNopper/OpenGL) - OpenGL 3 and 4 with GLSL
* [vmg/rinku](https://github.com/vmg/rinku) - Autolinking. Ruby. Yes, that's pretty much it.
* [halfninja/android-ffmpeg-x264](https://github.com/halfninja/android-ffmpeg-x264) - INACTIVE, UNSUPPORTED - Android Videokit - basic FFMPEG+X264 build for Android. Pull requests gratefully accepted.
* [priitj/whitedb](https://github.com/priitj/whitedb) - WhiteDB memory database
* [papplampe/virgo](https://github.com/papplampe/virgo) - Virtual desktops for Windows
* [jyr/MNPP](https://github.com/jyr/MNPP) - Mac + Nginx + Percona + PHP a high performance web server in a one-click installer
* [GNOME/gimp](https://github.com/GNOME/gimp) - GIMP
* [tj/watch](https://github.com/tj/watch) - watch(1) periodically executes the given command - useful for auto-testing, auto-building, auto-anything
* [rougier/freetype-gl](https://github.com/rougier/freetype-gl) - OpenGL text using one vertex buffer, one texture and FreeType
* [micronucleus/micronucleus](https://github.com/micronucleus/micronucleus) - ATTiny usb bootloader with a strong emphasis on bootloader compactness.
* [Hexxeh/rpi-firmware](https://github.com/Hexxeh/rpi-firmware) - Firmware files for the Raspberry Pi
* [seanooi/iOS-WebP](https://github.com/seanooi/iOS-WebP) - Google's WebP image format decoder and encoder for iOS
* [dynup/kpatch](https://github.com/dynup/kpatch) - kpatch - dynamic kernel patching
* [libopencm3/libopencm3](https://github.com/libopencm3/libopencm3) - Open Source ARM cortex m microcontroller library
* [lefcha/imapfilter](https://github.com/lefcha/imapfilter) - IMAP mail filtering utility
* [php-memcached-dev/php-memcached](https://github.com/php-memcached-dev/php-memcached) - memcached extension based on libmemcached library
* [igraph/igraph](https://github.com/igraph/igraph) - Library for the analysis of networks
* [monome/libmonome](https://github.com/monome/libmonome) - makes writing applications for Monomes easy.
* [michaeltyson/TPCircularBuffer](https://github.com/michaeltyson/TPCircularBuffer) - A simple, fast circular buffer implementation
* [stefanesser/suhosin](https://github.com/stefanesser/suhosin) - Suhosin Extension
* [mkoppanen/php-zmq](https://github.com/mkoppanen/php-zmq) - ZeroMQ for PHP
* [thunisoft/unispim](https://github.com/thunisoft/unispim) - 华宇拼音输入法核心源码(source code of unispim)
* [puffnfresh/toggle-osx-shadows](https://github.com/puffnfresh/toggle-osx-shadows) - Tiny tool to toggle window shadows on OS X
* [moonlight-stream/moonlight-pc](https://github.com/moonlight-stream/moonlight-pc) - GameStream client for Windows/OS X/Linux
* [bsdphk/Ntimed](https://github.com/bsdphk/Ntimed) - Network time synchronization software, NTPD replacement.
* [antirez/shapeme](https://github.com/antirez/shapeme) - Evolve images using simulated annealing
* [jbush001/NyuziProcessor](https://github.com/jbush001/NyuziProcessor) - GPGPU processor core, implemented in SystemVerilog.
* [mkottman/AndroLua](https://github.com/mkottman/AndroLua) - Lua and LuaJava ported to Android
* [session-replay-tools/tcpburn](https://github.com/session-replay-tools/tcpburn) - The most powerful tool for stress testing of Internet server applications
* [offensive-security/kali-nethunter](https://github.com/offensive-security/kali-nethunter) - Kali Linux NetHunter
* [celluloid/nio4r](https://github.com/celluloid/nio4r) - New IO for Ruby
* [snooda/net-speeder](https://github.com/snooda/net-speeder) - net-speeder 在高延迟不稳定链路上优化单线程下载速度
* [meetecho/janus-gateway](https://github.com/meetecho/janus-gateway) - Janus WebRTC Gateway
* [oggy/looksee](https://github.com/oggy/looksee) - Supercharged method introspection in IRB
* [PrimeSense/Sensor](https://github.com/PrimeSense/Sensor) - PrimeSensor Modules for OpenNI
* [lericson/pylibmc](https://github.com/lericson/pylibmc) - A Python wrapper around the libmemcached interface from TangentOrg.
* [eatnumber1/goal](https://github.com/eatnumber1/goal) - g()()()()('al') → "gooooal"
* [traviscross/mtr](https://github.com/traviscross/mtr) - Official repository for mtr, a network diagnostic tool
* [arjun024/mkernel](https://github.com/arjun024/mkernel) - a minimalistic kernel
* [GrahamDumpleton/mod_wsgi](https://github.com/GrahamDumpleton/mod_wsgi) - Source code for Apache/mod_wsgi.
* [FreeRADIUS/freeradius-server](https://github.com/FreeRADIUS/freeradius-server) - The FreeRADIUS Server.  RADIUS, DHCP, and VMPS.
* [wiire/pixiewps](https://github.com/wiire/pixiewps) - An offline WPS bruteforce utility
* [stephane/libmodbus](https://github.com/stephane/libmodbus) - A Modbus library for Linux, Mac OS X, FreeBSD, QNX and Windows
* [masterzen/nginx-upload-progress-module](https://github.com/masterzen/nginx-upload-progress-module) - Nginx module implementing an upload progress system, that monitors RFC1867 POST uploads as they are transmitted to upstream servers.
* [jasonmc/forked-daapd](https://github.com/jasonmc/forked-daapd) - A re-write of the firefly media server (mt-daapd). It's released under GPLv2+. Please note that this git repository is a mirror of the official one at git://git.debian.org/~jblache/forked-daapd.git
* [chokepoint/azazel](https://github.com/chokepoint/azazel) - Azazel is a userland rootkit based off of the original LD_PRELOAD technique from Jynx rootkit.  It is more robust and has additional features, and focuses heavily around anti-debugging and anti-detection.
* [Cyan4973/FiniteStateEntropy](https://github.com/Cyan4973/FiniteStateEntropy) - New generation entropy coder
* [shinh/maloader](https://github.com/shinh/maloader) - mach-o loader for linux
* [samyk/pwnat](https://github.com/samyk/pwnat) - pwnat punches holes in firewalls and NATs allowing any numbers of clients behind NATs to directly connect to a server behind a different NAT with no 3rd party, port forwarding, DMZ or spoofing involved
* [OpenSC/OpenSC](https://github.com/OpenSC/OpenSC) - Open source smart card tools and middleware. PKCS#11/MiniDriver/Tokend
* [aggregateknowledge/postgresql-hll](https://github.com/aggregateknowledge/postgresql-hll) - PostgreSQL extension adding HyperLogLog data structures as a native data type
* [illumos/illumos-gate](https://github.com/illumos/illumos-gate) - Community developed and maintained version of the OS/Net consolidation
* [guardianproject/libsqlfs](https://github.com/guardianproject/libsqlfs) - a library that implements a POSIX style filesystem on top of an SQLite database
* [LuaDist/luajit](https://github.com/LuaDist/luajit) - LuaJIT is JIT compiler for the Lua language.
* [jabberd2/jabberd2](https://github.com/jabberd2/jabberd2) - JabberD XMPP Server
* [etolabo/kumofs](https://github.com/etolabo/kumofs) - kumofs is a scalable and highly available distributed key-value store.
* [ellson/graphviz](https://github.com/ellson/graphviz) - Graph Visualization Tools
* [tjko/jpegoptim](https://github.com/tjko/jpegoptim) - jpegoptim - utility to optimize/compress JPEG files
* [netsniff-ng/netsniff-ng](https://github.com/netsniff-ng/netsniff-ng) - A Swiss army knife for your daily Linux network plumbing.
* [libressl-portable/portable](https://github.com/libressl-portable/portable) - LibreSSL Portable itself. This includes the build scaffold and compatibility layer that builds portable LibreSSL from the OpenBSD source code.
* [thoughtbot/pick](https://github.com/thoughtbot/pick) - fuzzy select anything.
* [tenderlove/psych](https://github.com/tenderlove/psych) - A libyaml wrapper for Ruby
* [fcitx/fcitx](https://github.com/fcitx/fcitx) - A Flexible Input Method Framework
* [google/snappy-start](https://github.com/google/snappy-start) - Tool for launching a Linux process from a snapshot
* [yasm/yasm](https://github.com/yasm/yasm) - Yasm Assembler mainline development tree
* [openlink/virtuoso-opensource](https://github.com/openlink/virtuoso-opensource) - Virtuoso is a scalable cross-platform server that combines Relational, Graph, and Document Data Management with Web Application Server and Web Services Platform functionality.
* [libav/libav](https://github.com/libav/libav) - Libav github mirror, clone of git://git.libav.org/libav
* [vivien/i3blocks](https://github.com/vivien/i3blocks) - A flexible scheduler for i3bar
* [laruence/yaconf](https://github.com/laruence/yaconf) - A PHP Persistent Configurations Container
* [Gnucash/gnucash](https://github.com/Gnucash/gnucash) - Public Mirror of code.gnucash.org/gnucash
* [damellis/attiny](https://github.com/damellis/attiny) - ATtiny microcontroller support for the Arduino IDE
* [sgminer-dev/sgminer](https://github.com/sgminer-dev/sgminer) - Scrypt GPU miner
* [groonga/groonga](https://github.com/groonga/groonga) - An embeddable fulltext search engine. Groonga is the successor project to Senna.
* [aardappel/lobster](https://github.com/aardappel/lobster) - The Lobster Programming Language
* [rentzsch/mach_inject](https://github.com/rentzsch/mach_inject) - interprocess code injection for Mac OS X
* [jwilberding/bcp](https://github.com/jwilberding/bcp) - Broadcast Copy
* [jcloudpub/speedy](https://github.com/jcloudpub/speedy) - a distributed docker image storage
* [b4winckler/vim](https://github.com/b4winckler/vim) - Mirror of the Vim Mercurial repository
* [openresty/echo-nginx-module](https://github.com/openresty/echo-nginx-module) - An Nginx module for bringing the power of "echo", "sleep", "time" and more to Nginx's config file
* [garrynewman/GWEN](https://github.com/garrynewman/GWEN) - GWEN - GUI Without Extravagant Nonsense
* [f9micro/f9-kernel](https://github.com/f9micro/f9-kernel) - An efficient and secure microkernel built for ARM Cortex-M cores, inspired by L4
* [cbsheng/tinyhttpd](https://github.com/cbsheng/tinyhttpd) - tinyhttpd的详细注释版，十分适合入门者学习的一个项目
* [reicast/reicast-emulator](https://github.com/reicast/reicast-emulator) - Reicast is a multiplatform Sega Dreamcast emulator
* [karelzak/mutt-kz](https://github.com/karelzak/mutt-kz) - mutt with notmuch support and another improvements...
* [stepmania/stepmania](https://github.com/stepmania/stepmania) - Advanced rhythm game for Windows, Linux and OS X. Designed for both home and arcade use.
* [fancycode/MemoryModule](https://github.com/fancycode/MemoryModule) - Library to load a DLL from memory.
* [eaccelerator/eaccelerator](https://github.com/eaccelerator/eaccelerator) - eAccelerator PHP opcode cache
* [obdev/v-usb](https://github.com/obdev/v-usb) - A Firmware-Only USB implementation for Atmel's AVR Microcontrollers
* [michaeldv/pit](https://github.com/michaeldv/pit) - The project manager from hell (integrates with Git)
* [FSX/misaka](https://github.com/FSX/misaka) - A Python binding for Hoedown.
* [yarrick/pingfs](https://github.com/yarrick/pingfs) - Stores your data in ICMP ping packets
* [mreiferson/php-wkhtmltox](https://github.com/mreiferson/php-wkhtmltox) - PHP bindings for libwkhtmltox
* [mariusae/heapster](https://github.com/mariusae/heapster) - production heap profiling for the JVM.  compatible with google-perftools.
* [facebook/liblogfaf](https://github.com/facebook/liblogfaf) - A library that logs messages using non-blocking UDP datagrams.
* [binaryage/asepsis](https://github.com/binaryage/asepsis) - a solution for .DS_Store pollution
* [rsms/sol](https://github.com/rsms/sol) - A sunny little virtual machine
* [dvorka/hstr](https://github.com/dvorka/hstr) - Bash and Zsh shell history suggest box - easily view, navigate, search and manage your command history.
* [FRiCKLE/ngx_postgres](https://github.com/FRiCKLE/ngx_postgres) - upstream module that allows nginx to communicate directly with PostgreSQL database.
* [libtom/libtomcrypt](https://github.com/libtom/libtomcrypt) - LibTomCrypt is a fairly comprehensive, modular and portable cryptographic toolkit that provides developers with a vast array of well known published block ciphers, one-way hash functions, chaining modes, pseudo-random number generators, public key cryptography and a plethora of other routines.
* [gnosek/nginx-upstream-fair](https://github.com/gnosek/nginx-upstream-fair) - The fair load balancer module for nginx
* [mubix/post-exploitation](https://github.com/mubix/post-exploitation) - Post Exploitation Collection
* [zeromq/zyre](https://github.com/zeromq/zyre) - Zyre - an open-source framework for proximity-based peer-to-peer applications
* [tuanpmt/esp_mqtt](https://github.com/tuanpmt/esp_mqtt) -  MQTT client library for ESP8266 Soc
* [SS-archive/salt-states](https://github.com/SS-archive/salt-states) - Collection of salt state files for use and testing
* [Dead2/zlib-ng](https://github.com/Dead2/zlib-ng) - zlib for the "next generation" systems. Drop-In replacement with some serious optimizations.
* [rwos/gti](https://github.com/rwos/gti) - a git launcher :-)
* [mgba-emu/mgba](https://github.com/mgba-emu/mgba) - mGBA Game Boy Advance Emulator
* [id-Software/Wolf3D-iOS](https://github.com/id-Software/Wolf3D-iOS) - Wolfenstein 3D for iOS Source Release
* [jcdutton/libbeauty](https://github.com/jcdutton/libbeauty) - Decompiler and Reverse Engineering tool
* [fnordware/AdobeWebM](https://github.com/fnordware/AdobeWebM) - WebM plug-ins for Adobe programs
* [fanglingsu/vimb](https://github.com/fanglingsu/vimb) - Vimb - the vim like browser is a webkit based web browser that behaves like the vimperator plugin for the firefox and usage paradigms from the great editor vim. The goal of vimb is to build a completely keyboard-driven, efficient and pleasurable browsing-experience.
* [limpkin/mooltipass](https://github.com/limpkin/mooltipass) - Github repository dedicated to the mooltipass project
* [zaphire/Monocle-Engine](https://github.com/zaphire/Monocle-Engine) - Open source game engine for lush 2D. Inspired by Aquaria, FlashPunk and Unity.
* [pepe2k/u-boot_mod](https://github.com/pepe2k/u-boot_mod) - U-Boot 1.1.4 modification for routers
* [chameco/Solid](https://github.com/chameco/Solid) - A minimalist interpreted language, with a clean object model and a tiny VM.
* [jpountz/lz4-java](https://github.com/jpountz/lz4-java) - LZ4 compression for Java
* [unbit/spockfs](https://github.com/unbit/spockfs) - SpockFS is an HTTP based network filesystem
* [robm/dzen](https://github.com/robm/dzen) - Dzen is a general purpose messaging, notification and menuing program for X11.
* [citusdata/postgres_vectorization_test](https://github.com/citusdata/postgres_vectorization_test) - Vectorized executor to speed up PostgreSQL
* [PaulBatchelor/Soundpipe](https://github.com/PaulBatchelor/Soundpipe) - A lightweight music DSP library.
* [antirez/load81](https://github.com/antirez/load81) - SDL based Lua programming environment for kids similar to Codea
* [Laurelai/decompile-dump](https://github.com/Laurelai/decompile-dump) - Partial stuxnet source decompiled with hexrays, if anyone has better decompile tools feel free to contribute better versions.
* [zebrafishlabs/nginx-statsd](https://github.com/zebrafishlabs/nginx-statsd) - An nginx module for sending stats to statsd.
* [giltene/wrk2](https://github.com/giltene/wrk2) - A constant throughput, correct latency recording variant of wrk
* [angband/angband](https://github.com/angband/angband) - Official Git repository for Angband
* [vmt/udis86](https://github.com/vmt/udis86) - Disassembler Library for x86 and x86-64
* [projectNe10/Ne10](https://github.com/projectNe10/Ne10) - An open optimized software library project for the ARM® Architecture
* [adrianlopezroche/fdupes](https://github.com/adrianlopezroche/fdupes) - FDUPES is a program for identifying or deleting duplicate files residing within specified directories.
* [twitter/jvmgcprof](https://github.com/twitter/jvmgcprof) - A simple utility for profile allocation and garbage collection activity in the JVM
* [openwrt-mirror/openwrt](https://github.com/openwrt-mirror/openwrt) - Mirror of the OpenWRT repository
* [libusb/libusb](https://github.com/libusb/libusb) - A cross-platform library to access USB devices
* [dbalmain/ferret](https://github.com/dbalmain/ferret) - Ferret: the extensible information retrieval library for ruby.
* [baiduwearable/duband](https://github.com/baiduwearable/duband) - duband1.0 对应的公版版本为 1.0
* [jcline/fuse-google-drive](https://github.com/jcline/fuse-google-drive) - A fuse filesystem wrapper for Google Drive.
* [LuaJIT/LuaJIT](https://github.com/LuaJIT/LuaJIT) - Mirror of the LuaJIT git repository
* [BinaryAnalysisPlatform/qira](https://github.com/BinaryAnalysisPlatform/qira) - QEMU Interactive Runtime Analyser
* [synthetos/TinyG](https://github.com/synthetos/TinyG) - Affordable Industrial Grade Motion Control
* [dhoerl/PhotoScrollerNetwork](https://github.com/dhoerl/PhotoScrollerNetwork) - Awesomely fast enhanced version of Apple's PhotoScroller, also pulls images from network.
* [atomicobject/heatshrink](https://github.com/atomicobject/heatshrink) - data compression library for embedded/real-time systems
* [moonlight-stream/moonlight-android](https://github.com/moonlight-stream/moonlight-android) - GameStream client for Android
* [mindboards/ev3sources](https://github.com/mindboards/ev3sources) - LEGO MINDSTORMS EV3 source code
* [AeroQuad/AeroQuad](https://github.com/AeroQuad/AeroQuad) - AeroQuad Flight Software
* [linuxmint/nemo](https://github.com/linuxmint/nemo) - File browser for Cinnamon
* [Lejdborg/NMSSH](https://github.com/Lejdborg/NMSSH) - NMSSH is an Objective-C wrapper for libssh2, with a sweet API.
* [planetbeing/xpwn](https://github.com/planetbeing/xpwn) - A cross-platform custom NOR firmware loader and custom IPSW generator for the iPhone
* [baskerville/sxhkd](https://github.com/baskerville/sxhkd) - Simple X hotkey daemon
* [stec-inc/EnhanceIO](https://github.com/stec-inc/EnhanceIO) - EnhanceIO Open Source for Linux
* [raspberrypi/maynard](https://github.com/raspberrypi/maynard) - Desktop environment for Wayland
* [ko1/allocation_tracer](https://github.com/ko1/allocation_tracer) - Add ObjectSpace::AllocationTracer module.
* [hoytech/vmtouch](https://github.com/hoytech/vmtouch) - Portable file system cache diagnostics and control
* [robwhess/opensift](https://github.com/robwhess/opensift) - Open-Source SIFT Library
* [augustl/halt](https://github.com/augustl/halt) - OS where everything is immutable! (Experimental)
* [ClusterLabs/pacemaker](https://github.com/ClusterLabs/pacemaker) - Pacemaker is an advanced, scalable High-Availability cluster resource manager
* [x2on/libssh2-for-iOS](https://github.com/x2on/libssh2-for-iOS) - A script for compiling libssh2 for iOS Devices (iPhone, iPad, iPod Touch). The example app can connect to an server with SSH and execute commands.
* [x0r1/Demon](https://github.com/x0r1/Demon) - GPU keylogger PoC by Team Jellyfish
* [pgRouting/pgrouting](https://github.com/pgRouting/pgrouting) - Repository contains pgRouting library. Development branch is "develop", stable branch is "master"
* [ntruchsess/arduino_uip](https://github.com/ntruchsess/arduino_uip) - UIPEthernet: A plugin-replacement of the stock Arduino Ethernet library for ENC28J60 shields and breakout boards. Full support for persistent (streaming) TCP-connections and UDP (Client and Server each), ARP, ICMP, DHCP and DNS. Build around Adam Dunkels uIP Stack.
* [Yubico/yubico-pam](https://github.com/Yubico/yubico-pam) - Yubico Pluggable Authentication Module (PAM)
* [symisc/vedis](https://github.com/symisc/vedis) - An Embedded Implementation of Redis
* [juuso/keychaindump](https://github.com/juuso/keychaindump) - A proof-of-concept tool for reading OS X keychain passwords
* [ThomasAdam/tmux](https://github.com/ThomasAdam/tmux) - Clone of the tmux Git repository.  The master branch contains the latest unreleased code. There are topic branches which may be subject to rebasing, so don't base changes off them.  DO NOT SEND me pull-requests, send patches to tmux-users mailing list instead.
* [NVIDIAGameWorks/OpenGLSamples](https://github.com/NVIDIAGameWorks/OpenGLSamples) - Cross-platform OpenGL and OpenGL ES samples (for Windows, Android, and Linux)
* [AyrA/ExcelStuff](https://github.com/AyrA/ExcelStuff) - Various Tools in Excel
* [zardus/preeny](https://github.com/zardus/preeny) - Some helpful preload libraries for pwning stuff.
* [majn/telegram-purple](https://github.com/majn/telegram-purple) - Adds support for Telegram to Pidgin, Adium, Finch and other Libpurple based messengers.
* [bluesmoon/pngtocss](https://github.com/bluesmoon/pngtocss) - Read in a gradient from a png file and spit out CSS for it
* [multiwii/baseflight](https://github.com/multiwii/baseflight) - 32 bit fork of the MultiWii RC flight controller firmware
* [jgeboski/purple-facebook](https://github.com/jgeboski/purple-facebook) - Facebook protocol plugin for libpurple
* [cmusphinx/pocketsphinx](https://github.com/cmusphinx/pocketsphinx) - PocketSphinx is a lightweight speech recognition engine, specifically tuned for handheld and mobile devices, though it works equally well on the desktop
* [MoSync/MoSync](https://github.com/MoSync/MoSync) - Cross-Platform SDK for mobile phones
* [guilleiguaran/xv6](https://github.com/guilleiguaran/xv6) - mirror of the source code of the Xv6 operating system
* [git-mirror/nginx](https://github.com/git-mirror/nginx) - A mirror of the nginx SVN repository.
* [multipath-tcp/mptcp](https://github.com/multipath-tcp/mptcp) - Linux Kernel implementation of MultiPath TCP
* [mchck/mchck](https://github.com/mchck/mchck) - MC HCK, the small and cheap microcontroller board!
* [jordansissel/xdotool](https://github.com/jordansissel/xdotool) - fake keyboard/mouse input, window management, and more
* [OpenNI/OpenNI2](https://github.com/OpenNI/OpenNI2) - OpenNI2
* [Byzantium/Byzantium](https://github.com/Byzantium/Byzantium) - Configs and code for Project Byzantium.
* [marforic/imagemagick_lib_iphone](https://github.com/marforic/imagemagick_lib_iphone) - Scripts and instructions to compile ImageMagick as a static library to use in any iOS project
* [flori/amatch](https://github.com/flori/amatch) - Approximate String Matching library
* [MidnightCommander/mc](https://github.com/MidnightCommander/mc) - Midnight Commander's repository
* [selkhateeb/hardlink](https://github.com/selkhateeb/hardlink) - a simple command-line utility that implements hardlinks on Mac OsX
* [mackyle/sqlite](https://github.com/mackyle/sqlite) - Unofficial git mirror of SQLite sources (see link for build instructions)
* [comex/frash](https://github.com/comex/frash) - yeah I'm getting tired of the long description
* [FRiCKLE/ngx_zeromq](https://github.com/FRiCKLE/ngx_zeromq) - ZeroMQ transport for nginx
* [kholia/dedrop](https://github.com/kholia/dedrop) - Looking inside the (Drop) box. Security Analysis of Dropbox. Updated WOOT '13 paper and other goodies.
* [Airblader/i3](https://github.com/Airblader/i3) - i3-gaps – i3 with more features
* [torch/DEPRECEATED-torch7-distro](https://github.com/torch/DEPRECEATED-torch7-distro) - Torch7: state-of-the-art machine learning algorithms
* [rentzsch/mach_star](https://github.com/rentzsch/mach_star) - code injection and function overriding for Mac OS X
* [UWNetworksLab/arrakis](https://github.com/UWNetworksLab/arrakis) - Arrakis public repository.
* [haproxy/haproxy](https://github.com/haproxy/haproxy) - Mirror of haproxy repository
* [wdas/ptex](https://github.com/wdas/ptex) - Per-Face Texture Mapping for Production Rendering
* [seastorm/PuttyRider](https://github.com/seastorm/PuttyRider) - Hijack Putty sessions in order to sniff conversation and inject Linux commands.
* [sackmotion/motion](https://github.com/sackmotion/motion) - Motion, a software motion detector
* [sevenler/Uninstall_Statics](https://github.com/sevenler/Uninstall_Statics) - Android 统计 应用 自身被 卸载 Android Statistics application is uninstalled
* [gsliepen/tinc](https://github.com/gsliepen/tinc) - a VPN daemon
* [oetiker/rrdtool-1.x](https://github.com/oetiker/rrdtool-1.x) - RRDtool 1.x - Round Robin Database
* [lwfinger/rtlwifi_new](https://github.com/lwfinger/rtlwifi_new) - A repo for the newest Realtek rtlwifi codes.
* [linux-test-project/ltp](https://github.com/linux-test-project/ltp) - Linux Test Project
* [liamoc/learn-you-an-agda](https://github.com/liamoc/learn-you-an-agda) - Learn you an Agda (and achieve enlightenment)
* [FrictionalGames/HPL1Engine](https://github.com/FrictionalGames/HPL1Engine) - A real time 3D engine.
* [micahpearlman/MonkVG](https://github.com/micahpearlman/MonkVG) - MonkVG is an OpenVG 1.1 like vector graphics API implementation optimized for game use currently using an OpenGL ES backend that should be compatible with any HW that supports OpenGL ES 2.0 which includes most iOS and Android devices.
* [hzeller/gmrender-resurrect](https://github.com/hzeller/gmrender-resurrect) - Resource efficient UPnP/DLNA renderer, optimal for Raspberry Pi, CuBox or a general MediaServer. Fork of GMediaRenderer to add some features to make it usable.
* [bitrig/bitrig](https://github.com/bitrig/bitrig) - Bitrig base system repository.
* [tailhook/zerogw](https://github.com/tailhook/zerogw) - A fast HTTP/WebSocket to zeromq gateway
* [gentoo/eudev](https://github.com/gentoo/eudev) - Repository for eudev development
* [tmm1/gctools](https://github.com/tmm1/gctools) - profiler/logger/oobgc for rgengc in ruby 2.1
* [devsisters/libquic](https://github.com/devsisters/libquic) - QUIC, a multiplexed stream transport over UDP
* [adafruit/adafruit-beaglebone-io-python](https://github.com/adafruit/adafruit-beaglebone-io-python) - Adafruit's BeagleBone IO Python Library
* [zeromq/rbzmq](https://github.com/zeromq/rbzmq) - Ruby binding for 0MQ
* [xxorde/librekinect](https://github.com/xxorde/librekinect) - Depth data from a kinect sensor! Small and fast kernel driver. Also for embedded devices like the raspberry pi!
* [the-tcpdump-group/tcpdump](https://github.com/the-tcpdump-group/tcpdump) - the TCPdump network dissector
* [the-tcpdump-group/libpcap](https://github.com/the-tcpdump-group/libpcap) - the LIBpcap interface to various kernel packet capture mechanism
* [phadej/igbinary](https://github.com/phadej/igbinary) - Igbinary is a drop in replacement for the standard php serializer.  Check https://github.com/igbinary/igbinary for the freshest version
* [jkramer/shell-fm](https://github.com/jkramer/shell-fm) - Lightweight console-based radio player for Last.FM radio streams.
* [strazzere/android-unpacker](https://github.com/strazzere/android-unpacker) - Android Unpacker presented at Defcon 22: Android Hacker Protection Level 0
* [robertdavidgraham/isowall](https://github.com/robertdavidgraham/isowall) - This is a mini-firewall that completely isolates a target device from the local network.
* [revolutionary/zergRush](https://github.com/revolutionary/zergRush) - Android 2.2 / 2.3 local root
* [pyca/pynacl](https://github.com/pyca/pynacl) - Python binding to the Networking and Cryptography (NaCl) library
* [kmike/datrie](https://github.com/kmike/datrie) - Fast, efficiently stored Trie for Python. Uses libdatrie.
* [zfsonlinux/spl](https://github.com/zfsonlinux/spl) - Solaris Porting Layer
* [snielsen/DeathToDSStore](https://github.com/snielsen/DeathToDSStore) - .DS_Store is an abomination and must be stopped.
* [pornel/giflossy](https://github.com/pornel/giflossy) - Lossy GIF compressor
* [Learn-Algorithm/Learn-Algorithm](https://github.com/Learn-Algorithm/Learn-Algorithm) - 拖延症患者学习算法小分队
* [a0rtega/pafish](https://github.com/a0rtega/pafish) - Pafish is a demonstration tool that employs several techniques to detect sandboxes and analysis environments in the same way as malware families do.
* [Blosc/bcolz](https://github.com/Blosc/bcolz) - A columnar data container that can be compressed.
* [osxfuse/sshfs](https://github.com/osxfuse/sshfs) - File system based on the SSH File Transfer Protocol
* [neutrinolabs/xrdp](https://github.com/neutrinolabs/xrdp) - xrdp: an open source RDP server
* [lua/lua](https://github.com/lua/lua) - Unofficial git history of Lua releases
* [ioerror/tlsdate](https://github.com/ioerror/tlsdate) - secure parasitic rdate replacement
* [gkaindl/ambi-tv](https://github.com/gkaindl/ambi-tv) - a flexible ambilight clone for embedded linux
* [cloudwu/sproto](https://github.com/cloudwu/sproto) - Yet another protocol library like google protocol buffers , but simple and fast.
* [studio-ousia/mprpc](https://github.com/studio-ousia/mprpc) - A fast MessagePack RPC library
* [matricks/teeworlds](https://github.com/matricks/teeworlds) - A retro multiplayer shooter
* [immobiliare/sfs](https://github.com/immobiliare/sfs) - Asynchronous Filesystem Replication
* [ghosert/VimProject](https://github.com/ghosert/VimProject) - All about my vim projects
* [djhworld/gomeboycolor](https://github.com/djhworld/gomeboycolor) - Gameboy Color emulator
* [thlorenz/learnuv](https://github.com/thlorenz/learnuv) - Learn uv for fun and profit, a self guided workshop to the library that powers Node.js.
* [reorg/pg_repack](https://github.com/reorg/pg_repack) - Reorganize tables in PostgreSQL databases with minimal locks
* [guokr/gkseg](https://github.com/guokr/gkseg) - Yet another Chinese word segmentation package based on character-based tagging heuristics and CRF algorithm
* [rathena/rathena](https://github.com/rathena/rathena) - rAthena is an open-source cross-platform MMORPG server.
* [mist64/hvdos](https://github.com/mist64/hvdos) - hvdos, a simple DOS emulator based on the OS X Hypervisor.framework
* [lh3/bwa](https://github.com/lh3/bwa) - Burrow-Wheeler Aligner for pairwise alignment between DNA sequences
* [gameoverhack/ofxOpenNI](https://github.com/gameoverhack/ofxOpenNI) - Wrapper for OpenNI, NITE and SensorKinect
* [xbmc/android](https://github.com/xbmc/android) - OBSOLETE Android port. Now merged into mainline!
* [swetland/dcpu16](https://github.com/swetland/dcpu16) - Virtual Machine and Assembler for Notch's DCPU-16 Architecture
* [servalproject/batphone](https://github.com/servalproject/batphone) - The Serval Mesh app for Android.  EXPERIMENTAL SOFTWARE.
* [openresty/sregex](https://github.com/openresty/sregex) - A non-backtracking NFA/DFA-based Perl-compatible regex engine matching on large data streams
* [naev/naev](https://github.com/naev/naev) - Naev is a 2d action/rpg space game that combines elements from the action, rpg and simulation genres.
* [martinezjavier/ldd3](https://github.com/martinezjavier/ldd3) - Linux Device Drivers 3 examples updated to work in recent kernels
* [davisp/python-spidermonkey](https://github.com/davisp/python-spidermonkey) - Python/JavaScript bridge module, making use of Mozilla's spidermonkey JavaScript implementation.
* [rafael-santiago/pig](https://github.com/rafael-santiago/pig) - A Linux packet crafting tool
* [postgis/postgis](https://github.com/postgis/postgis) - PostGIS spatial database extension to PostgreSQL
* [performancecopilot/pcp](https://github.com/performancecopilot/pcp) - Performance Co-Pilot
* [bwhite/hadoopy](https://github.com/bwhite/hadoopy) - Python MapReduce library written in Cython. Visit us in #hadoopy on freenode.  See the link below for documentation and tutorials.
* [versatica/OverSIP](https://github.com/versatica/OverSIP) - OverSIP: the SIP framework you dreamed about
* [openresty/drizzle-nginx-module](https://github.com/openresty/drizzle-nginx-module) - an nginx upstream module that talks to mysql and drizzle by libdrizzle
* [monkey/monkey](https://github.com/monkey/monkey) - Monkey HTTP Server
* [keenerd/jshon](https://github.com/keenerd/jshon) - Jshon is a JSON parser designed for maximum convenience within the shell.
* [benhoyt/scandir](https://github.com/benhoyt/scandir) - Better directory iterator and faster os.walk(), now in the Python 3.5 stdlib
* [carljv/Will_it_Python](https://github.com/carljv/Will_it_Python) - Translating R Data Analyses to Python
* [JakSprats/Alchemy-Database](https://github.com/JakSprats/Alchemy-Database) - Hybrid Relational-Database/NOSQL-Datastore
* [ericfischer/datamaps](https://github.com/ericfischer/datamaps) - Indexes points and lines and generates map tiles to display them
* [jedisct1/Pincaster](https://github.com/jedisct1/Pincaster) - A fast persistent nosql database with a HTTP/JSON interface, not only for geographical data.
* [moinakg/pcompress](https://github.com/moinakg/pcompress) - A Parallelized Data Deduplication and Compression utility
* [x86-64/frozen](https://github.com/x86-64/frozen) - Data management and processing library
* [citusdata/mongo_fdw](https://github.com/citusdata/mongo_fdw) - PostgreSQL foreign data wrapper for MongoDB
* [danomatika/ofxPd](https://github.com/danomatika/ofxPd) - (maintained) a Pure Data addon for OpenFrameworks using libpd
* [franckverrot/holycorn](https://github.com/franckverrot/holycorn) - PostgreSQL multi-purpose Ruby data wrapper
* [clarkgrubb/data-tools](https://github.com/clarkgrubb/data-tools) - File format conversion tools
* [amadvance/snapraid](https://github.com/amadvance/snapraid) - A backup program for disk arrays. It stores parity information of your data and it recovers from up to six disk failures
* [naftaliharris/lazysort](https://github.com/naftaliharris/lazysort) - A partially and lazily sorted list data structure for Python
* [johnj/llds](https://github.com/johnj/llds) - Low-Level Data Structure - efficient data structures, and fast data access in the 2.6/3.0 kernel
* [lh3/bioawk](https://github.com/lh3/bioawk) - BWK awk modified for biological data
* [Cr4sh/WindowsRegistryRootkit](https://github.com/Cr4sh/WindowsRegistryRootkit) - Kernel rootkit, that lives inside the Windows registry values data
* [EnterpriseDB/mysql_fdw](https://github.com/EnterpriseDB/mysql_fdw) - PostgreSQL foreign data wrapper for MySQL
* [reverbrain/eblob](https://github.com/reverbrain/eblob) - Eblob is an append-only low-level IO library, which saves data in blob files. Created as low-level backend for elliptics
* [mjording/ttyrec](https://github.com/mjording/ttyrec) - ttyrec is a tty recorder. Recorded data can be played back with the included ttyplay command. ttyrec is just a derivative of script command for recording timing information with microsecond accuracy as well. It can record emacs -nw, vi, lynx, or any programs running on tty.
* [siganakis/tny](https://github.com/siganakis/tny) - Tiny data structures that pack a punch!
* [xjdrew/lua-zset](https://github.com/xjdrew/lua-zset) - lua data structure same as redis sorted set
* [searchdaimon/enterprise-search](https://github.com/searchdaimon/enterprise-search) - An open source search engine for corporate data and websites.
* [citusdata/json_fdw](https://github.com/citusdata/json_fdw) - PostgreSQL extension which implements a Foreign Data Wrapper (FDW) for JSON files.
* [opendp/dpdk-odp](https://github.com/opendp/dpdk-odp) - Open data plane on dpdk, TCP/IP stack for dpdk.
* [ebassi/graphene](https://github.com/ebassi/graphene) - A thin layer of graphic data types
* [dpage/redis_fdw](https://github.com/dpage/redis_fdw) - A PostgreSQL foreign data wrapper for Redis
* [danomatika/PdParty](https://github.com/danomatika/PdParty) - (work-in-progress) Run your Pure Data patches on iOS with native GUIs emulated
* [fluent/nginx-fluentd-module](https://github.com/fluent/nginx-fluentd-module) - Nginx module for Fluentd data collector
* [ericfischer/geotools](https://github.com/ericfischer/geotools) - Tools for working with geographic data
* [drotiro/postpic](https://github.com/drotiro/postpic) - PostPic is an extension for the open source dbms PostgreSQL that enables image processing inside the database, like PostGIS does for spatial data. It adds the new 'image' type to the SQL, and several functions to process images and to extract their attributes.
* [rfk/tnetstring](https://github.com/rfk/tnetstring) - data serialization using typed netstrings
* [mysqludf/lib_mysqludf_json](https://github.com/mysqludf/lib_mysqludf_json) - A UDF library of functions to map relational data to the JSON format.
* [cloudwu/lua-db](https://github.com/cloudwu/lua-db) - A database shared data among multi-states .
* [pod2g/sendrawpdu](https://github.com/pod2g/sendrawpdu) - CLI tool to send raw SMS PDU data to the iPhone 4 baseband
* [dawnbreaks/mysql2redis](https://github.com/dawnbreaks/mysql2redis) -    A high performance mysql udf  to sync the newly modified/inserted data from mysql to redis cache.
* [applidium/ADZipURLProtocol](https://github.com/applidium/ADZipURLProtocol) - Open static website or access data from a zip archive
* [IlyaGrebnov/libbsc](https://github.com/IlyaGrebnov/libbsc) - High performance block-sorting data compression library
* [rentzsch/stressdrive](https://github.com/rentzsch/stressdrive) - tool to completely fill a drive with random data and ensure it can be entirely correctly read back
* [fluent/fluent-bit](https://github.com/fluent/fluent-bit) - Data Collector for IoT & Embedded Linux
* [ComputerNerd/ov7670-no-ram-arduino-uno](https://github.com/ComputerNerd/ov7670-no-ram-arduino-uno) - Allows you to use a non fifo ov7670 on the arudino uno without external spi ram like other examples. Sends the data to UART.
* [openyou/libomron](https://github.com/openyou/libomron) - Libraries for accessing data from Omron medical devices
* [Broadcom-Switch/of-dpa](https://github.com/Broadcom-Switch/of-dpa) - OpenFlow Data Plane Abstraction
* [pramsey/pgsql-ogr-fdw](https://github.com/pramsey/pgsql-ogr-fdw) - PostgreSQL foreign data wrapper for OGR
* [krieger-od/whdd](https://github.com/krieger-od/whdd) - HDD diagnostic and data recovery tool for Linux
* [v3l0c1r4pt0r/delz](https://github.com/v3l0c1r4pt0r/delz) - Polish vehicle registration certificate data decompression tool
* [cmatsuoka/libxmp](https://github.com/cmatsuoka/libxmp) - Libxmp is a library that renders module files to PCM data.
* [mozilla-services/lua_sandbox](https://github.com/mozilla-services/lua_sandbox) - Generic Lua sandbox for dynamic data analysis
* [laurenz/oracle_fdw](https://github.com/laurenz/oracle_fdw) - PostgreSQL extension that provides a Foreign Data Wrapper for easy and efficient access to Oracle databases, including pushdown of WHERE conditions as well as comprehensive EXPLAIN and ANALYZE support.
* [bahbka/pebble-my-data](https://github.com/bahbka/pebble-my-data) - Pebble watches application to show only your own data, prepared on your own server.
* [snaga/xlogdump](https://github.com/snaga/xlogdump) - A tool for extracting data from the PostgreSQL's write ahead logs.
* [MeetMe/dump_fdw](https://github.com/MeetMe/dump_fdw) - Foreign Data Wrapper for Postgres Dump Files
* [pd-l2ork/pd](https://github.com/pd-l2ork/pd) - L2Ork version of Pure-Data real-time digital signal processing language developed and maintained at DISIS, Virginia Tech
* [nec-postgres/tdeforpg](https://github.com/nec-postgres/tdeforpg) - PostgreSQL Transparent Data Encryption tool development
* [fmela/libdict](https://github.com/fmela/libdict) - C library of key-value data structures with an object-oriented interface.
* [cloudwu/atomdict](https://github.com/cloudwu/atomdict) - A data structure for data exchange between multi lua states.
* [davidreynolds/algorithms](https://github.com/davidreynolds/algorithms) - A repository of assorted algorithms and data structures.
* [atks/vt](https://github.com/atks/vt) - A tool set for short variant discovery in genetic sequence data.
* [shadeslayer/libnice](https://github.com/shadeslayer/libnice) - Libnice is an implementation of the IETF's Interactive Connectivity Establishment (ICE) standard (RFC 5245) and the Session Traversal Utilities for NAT (STUN) standard (RFC 5389).  It provides a GLib-based library, libnice and a Glib-free library, libstun as well as GStreamer elements.  ICE is useful for applications that want to establish peer-to-peer UDP data streams. It automates the process of traversing NATs and provides security against some attacks. It also allows applications to create reliable streams using a TCP over UDP layer.  Existing standards that use ICE include Session Initiation Protocol (SIP) and XMPP Jingle.
* [urcu/userspace-rcu](https://github.com/urcu/userspace-rcu) - This repo is a mirror of the official lttng-tools git found at git://git.lttng.org/userspace-rcu.git. liburcu is a LGPLv2.1 userspace RCU (read-copy-update) library. This data synchronization library provides read-side access which scales linearly with the number of cores.
* [ggasoftware/indigo](https://github.com/ggasoftware/indigo) - Indigo: a cheminformatics toolkit. Bingo: RDBMS data cartridge for Oracle, MS SQL Server, and PostgreSQL
* [pure-data/pure-data](https://github.com/pure-data/pure-data) - Pure Data - tracking Miller's SourceForge git repository (also used by libpd)
* [dcjones/quip](https://github.com/dcjones/quip) - Compressing next-generation sequencing data with extreme prejudice.
* [Parsely/python-pds](https://github.com/Parsely/python-pds) - Toy Implementation of Probabilistic Data Structures in Python (PyData 2013)
* [BurntSushi/clibs](https://github.com/BurntSushi/clibs) - A smattering of miscellaneous C libraries. Includes sane argument parsing, a thread-safe multi-producer/multi-consumer queue, and implementation of common data structures (hashmaps, vectors and linked lists).
* [ricardo-rendoncepeda/mtl2opengl](https://github.com/ricardo-rendoncepeda/mtl2opengl) - A perl script for converting .obj and .mtl data files into arrays compatible with OpenGL ES on iOS devices
* [google/ktsan](https://github.com/google/ktsan) - ThreadSanitizer for Linux kernel, a fast data race detector
* [gdbinit/ExtractMachO](https://github.com/gdbinit/ExtractMachO) - IDA plugin to extract Mach-O binaries located in the disassembly or data
* [alibaba/tsar2db](https://github.com/alibaba/tsar2db) - used to store tsar data to mysql
* [raspofabs/dodsrc](https://github.com/raspofabs/dodsrc) - Source for the Data-Oriented Design book
* [pikelang/Pike](https://github.com/pikelang/Pike) - Pike is a dynamic programming language with a syntax similar to Java and C. It is simple to learn, does not require long compilation passes and has powerful built-in data types allowing simple and really fast data manipulation.
* [jackeylu/mysql2redis](https://github.com/jackeylu/mysql2redis) - A UDF(user defined functions) plugin for MySQL, which can be used for pushing data to Redis
* [davidcranor/Thinner-Client](https://github.com/davidcranor/Thinner-Client) - This project implements an STM32F based thin client which can send and receive data over serial, read a PS/2 keyboard, and display the contents of a 480x240 framebuffer on an NTSC television.
* [richarddurbin/pbwt](https://github.com/richarddurbin/pbwt) - Implementation of Positional Burrows-Wheeler Transform for genetic data
* [bryansum/pdlib](https://github.com/bryansum/pdlib) - An open source port of Pure Data to the iPhone
* [stephenrkell/liballocs](https://github.com/stephenrkell/liballocs) - Runtime and toolchain for whole-program monitoring of allocations and their data types
* [residuum/PuRestJson](https://github.com/residuum/PuRestJson) - PuREST JSON is a library for connecting Puredata (Pd) to HTTP services  and encoding and decoding JSON data.
* [GeoffMontee/tds_fdw](https://github.com/GeoffMontee/tds_fdw) - A PostgreSQL foreign data wrapper to connect to TDS databases (Sybase and Microsoft SQL Server)
* [xstevens/decoderbufs](https://github.com/xstevens/decoderbufs) - A PostgreSQL logical decoder output plugin to deliver data as Protocol Buffers
* [xcir/libvmod-parsereq](https://github.com/xcir/libvmod-parsereq) - parsing post,get,cookie data
* [reverbrain/smack](https://github.com/reverbrain/smack) - Low-level IO storage which packs data into sorted (zlib/bzip2/snappy compressed) blobs
* [paulasmuth/fyrehose](https://github.com/paulasmuth/fyrehose) - message broker for JSON data streams
* [nuko-yokohama/neo4j_fdw](https://github.com/nuko-yokohama/neo4j_fdw) - Graph Database Foreign Data Wrapper for PostgreSQL
* [steven-schronk/C-Data-Structures](https://github.com/steven-schronk/C-Data-Structures) - Collection of basic data structures in C.
* [snaga/monetdb_fdw](https://github.com/snaga/monetdb_fdw) - monetdb_fdw - PostgreSQL Foreign Data Wrapper for MonetDB
* [scrapinghub/mdr](https://github.com/scrapinghub/mdr) - A python library detect and extract listing data from HTML page.
* [libical/libical](https://github.com/libical/libical) - Libical is an Open Source implementation of the iCalendar protocols and protocol data units.
* [jstjohn/SimSeq](https://github.com/jstjohn/SimSeq) - An illumina paired-end and mate-pair short read simulator. This project attempts to model as many of the quirks that exist in Illumina data as possible. Some of these quirks include the potential for chimeric reads, and non-biotinylated fragment pull down in mate-pair libraries . Additionally the program provides the ability to model both site and base specific error, and scripts are provided to train this error model on real datasets. My hope in creating this program is to generate as realistic data as possible to assist in assessing the accuracy of genome assembly tools.
* [jimstudt/ook-decoder](https://github.com/jimstudt/ook-decoder) - Ook-decoder reads On-Off Keying radio data commonly used in the 433MHz ISM bands using a software defined radio (SDR).
* [jamplus/jamplus](https://github.com/jamplus/jamplus) - Jamplus is a generic code and data build system derived from the original Perforce version of Jam
* [Maxime2/dataparksearch](https://github.com/Maxime2/dataparksearch) - An open source, feature rich search engine.
* [trink/hindsight](https://github.com/trink/hindsight) - Hindsight - light weight data processing skeleton
* [stuffmatic/kowalski](https://github.com/stuffmatic/kowalski) - A data driven, portable, high level audio API for games and other interactive applications (currently being refactored, not quite useable yet).
* [pn2200/g3data](https://github.com/pn2200/g3data) - Grab graph data, a program for extracting data from graphs
* [jpr5/ngrep](https://github.com/jpr5/ngrep) - ngrep strives to provide most of GNU grep's common features, applying them to the network layer. ngrep is a pcap-aware tool that will allow you to specify extended regular expressions to match against data payloads of packets.
* [fomy/destor](https://github.com/fomy/destor) - An experimental platform for chunk-level data deduplication. Key words: DDFS, Sparse Index, Extreme Binning, SiLo, Sample Index, BLC; CBR, CFL, CAP, HAR; ASM, OPT; GC, Cumulus
* [danghvu/mod_dumpost](https://github.com/danghvu/mod_dumpost) - Small and lightweight Apache module to log POST data of a HTTP request
* [res0nat0r/tsunami-udp](https://github.com/res0nat0r/tsunami-udp) -  A fast user-space file transfer protocol that uses TCP control and UDP data for transfer over very high speed long distance networks (≥ 1 Gbps and even 10 GE), designed to provide more throughput than possible with TCP over the same networks.
* [LPD-EPFL/ASCYLIB](https://github.com/LPD-EPFL/ASCYLIB) - ASCYLIB is a concurrent-search data-structure library with over 30 implementantions of linked lists, hash tables, skip lists, and binary search trees.
* [tvondra/pg_check](https://github.com/tvondra/pg_check) - a tool to verify integrity of PostgreSQL data files
* [larsbrinkhoff/httptunnel](https://github.com/larsbrinkhoff/httptunnel) - Creates a bidirectional virtual data path tunnelled in HTTP requests.
* [falconindy/expac](https://github.com/falconindy/expac) - alpm data extraction utility
* [CICM/CicmWrapper](https://github.com/CICM/CicmWrapper) - A C/TK library that aims to facilitate the creation of objects for Pure Data
* [umitanuki/s3_fdw](https://github.com/umitanuki/s3_fdw) - foreign-data wrapper for Amazon S3
* [suhetao/stm32f4_mpu9250](https://github.com/suhetao/stm32f4_mpu9250) - Access the data of 3-axis magnetometer and DMP from MPU9250 with SPI interface, All data fusion via EKF/UKF/CKF/SRCKF algorithm
* [nicolasff/river](https://github.com/nicolasff/river) - A simple “comet” server in C, streaming data to web clients
* [bovine/datapipe](https://github.com/bovine/datapipe) - Network TCP port forwarding
* [atris/JDBC_FDW](https://github.com/atris/JDBC_FDW) - FDW that wraps JDBC for PostgreSQL.It can be used to connect and fetch data from any data source that supports JDBC
* [korczis/foremost](https://github.com/korczis/foremost) - Foremost is a console program to recover files based on their headers, footers, and internal data structures. This process is commonly referred to as data carving. Foremost can work on image files, such as those generated by dd, Safeback, Encase, etc, or directly on a drive. The headers and footers can be specified by a configuration file or you can use command line switches to specify built-in file types. These built-in types look at the data structures of a given file format allowing for a more reliable and faster recovery.  Originally developed by the United States Air Force Office of Special Investigations and The Center for Information Systems Security Studies and Research , foremost has been opened to the general public. We welcome any comments, suggestions, patches, or feedback you have on this program. Please direct all correspondence to namikus@users.sf.net.
* [kev009/Concurrency-Kit](https://github.com/kev009/Concurrency-Kit) - Concurrency primitives and lock-less data structures
* [ge-ne/bibtool](https://github.com/ge-ne/bibtool) - BibTool is a tool for manipulating BibTeX data bases. BibTeX provides a mean to integrate citations into LaTeX documents. BibTool allows the manipulation of BibTeX files which goes beyond the possibilities -- and intentions -- of BibTeX.
* [fuzxxl/memf](https://github.com/fuzxxl/memf) - Portable scanf/printf-like functions to marshal binary data
* [ethz-asl/asctec_mav_framework](https://github.com/ethz-asl/asctec_mav_framework) - Framework for data aquisition and position control to be used with the highlevel processor of Ascending Technologies helicopters
* [dminor/skip-quadtree](https://github.com/dminor/skip-quadtree) - Implementation of the skip quadtree and compressed quadtree data structures.
* [cornetp/eagle-owl](https://github.com/cornetp/eagle-owl) - Data acquisition from an OWL CM160 +USB device on linux platforms
* [comex/data](https://github.com/comex/data) - the green eyed monster
* [chadwickbureau/chadwick](https://github.com/chadwickbureau/chadwick) - Chadwick tools for manipulating baseball data
* [agordon/datamash](https://github.com/agordon/datamash) - mirror of GNU Datamash
* [Frans-Willem/LEDMatrixHUB75](https://github.com/Frans-Willem/LEDMatrixHUB75) - Driver for a LED Matrix of 9 32x16 RGB HUB75 panels, using an STM32F4 Discovery board as low-level driver, and an Atheros AR9331 based WiFi router running OpenWRT as Art-Net data receiver.
* [torbensko/Kinect-to-Maya-motion-capture](https://github.com/torbensko/Kinect-to-Maya-motion-capture) - A set of scripts to help you capture the Kinect's motion capture data in Maya
* [paulasmuth/libsmatrix](https://github.com/paulasmuth/libsmatrix) - thread-safe sparse matrix data structure
* [jourlin/WebCrawler](https://github.com/jourlin/WebCrawler) - An academic open source and open data web crawler
* [fileability/self-ml](https://github.com/fileability/self-ml) - A human data language
* [bcopeland/em_misc](https://github.com/bcopeland/em_misc) - external memory data structure playground
* [pflarr/dns_parse](https://github.com/pflarr/dns_parse) - A fast parser for DNS pcap data.
* [ntamas/plfit](https://github.com/ntamas/plfit) - Fitting power-law distributions to empirical data, according to the method of Clauset, Shalizi and Newman
* [luarpro/BitmapDataQRCodeScanner](https://github.com/luarpro/BitmapDataQRCodeScanner) - Flash AIR Native Extension:  QRCode reader/decoder which accept BitmapData, therefore you can design your own scanner UI, adding overlay image, without launch  fullscreen native Camera UI
* [jllodra/ncdump-json](https://github.com/jllodra/ncdump-json) - Modified ncdump to output data in json format
* [bodgit/graphite-amqp-tools](https://github.com/bodgit/graphite-amqp-tools) - A set of tools for getting Graphite data in and out of AMQP message brokers
* [matteobertozzi/carthage](https://github.com/matteobertozzi/carthage) - Pure C Data Structure and Utils
* [guedes/ldap_fdw](https://github.com/guedes/ldap_fdw) - A LDAP Foreign Data Wrapper for PostgreSQL
* [dbohdan/s2png](https://github.com/dbohdan/s2png) - Store data of any kind inside PNG images.
* [LuaDist/lpack](https://github.com/LuaDist/lpack) - A library for packing and unpacking binary data. The library adds two functions to the string library: pack and unpack.
* [wertarbyte/tiny-gps](https://github.com/wertarbyte/tiny-gps) - read NMEA data from serial GPS receiver (and sonar and optical sensor)  and offer it as I2C slave using ATTiny
* [uci-cbcl/EXTREME](https://github.com/uci-cbcl/EXTREME) - An online EM implementation of the MEME model for fast motif discovery in large ChIP-Seq and DNase-Seq Footprinting data
* [tnm/vulcan](https://github.com/tnm/vulcan) - Generate test data for Redis
* [theunamedguy/market-sim](https://github.com/theunamedguy/market-sim) - A retro stock-trading game utilizing live market data
* [rnorris/viking](https://github.com/rnorris/viking) - Viking is a free/open source program to manage GPS data (including GPX and KML files). You can import and plot tracks, routes and waypoints, show OpenStreetMaps (OSM), Bing Aerial and other maps, generate Mapnik maps, geotag images, make new tracks, routes and waypoints, see real-time GPS position, etc.  It is written mostly in C with the GTK+ 2 toolkit and some C++.
* [qianshanhai/fastwiki](https://github.com/qianshanhai/fastwiki) - Fast offline data reader
* [linkedin/datacl](https://github.com/linkedin/datacl) - A collection of efficient utilities for a data scientist.
* [jberthold/packman](https://github.com/jberthold/packman) - Evaluation-orthogonal serialisation of Haskell data, as a library
* [davidar/c-hashtable](https://github.com/davidar/c-hashtable) - Git mirror of the hash table data structure in C by Christopher Clark
* [NordicSemiconductor/nrf51-ble-app-temp](https://github.com/NordicSemiconductor/nrf51-ble-app-temp) - Project for the nRF51822 that can send data to the nRF Temp smartphone apps.
* [MinnPost/minnpost-nice-ride](https://github.com/MinnPost/minnpost-nice-ride) - Nice Ride data analysis
* [CSB5/lofreq](https://github.com/CSB5/lofreq) - LoFreq Star: Sensitive variant calling from sequencing data
* [BlockoS/arduino-dataflash](https://github.com/BlockoS/arduino-dataflash) - Support for Atmel Dataflash for the Arduino
* [smira/memcached_functions_mysql](https://github.com/smira/memcached_functions_mysql) - Memcached functions for MySQL as UDF, tailored for usage in replication and pushing data to MemcacheQ
* [s-u/iotools](https://github.com/s-u/iotools) - High-performance I/O tools to run distributed R jobs seamlessly on Hadoop and handle chunk-wise data processing
* [petropavel13/pg_rrule](https://github.com/petropavel13/pg_rrule) - RRULE data type for PostgreSQL
* [kafka399/TwsMongo](https://github.com/kafka399/TwsMongo) - TwsMongo is an example of integration between Mongodb and InteractiveBrokers.com API v.9.66 written in C++. The goal of this application to save high frequency data in Mongodb database.
* [ircmaxell/php-ndata](https://github.com/ircmaxell/php-ndata) - NData PECL extension for dealing with native data types
* [edoko/AIR-Kernel_ICS](https://github.com/edoko/AIR-Kernel_ICS) - AIR Kernel for ICS (r_data / edoko)
* [debrouxl/tilp](https://github.com/debrouxl/tilp) - TILP (formerly GtkTiLink) can transfer data between Texas Instruments scientific calculators and a computer. It works with all link cables (parallel, serial, Black/Gray/Silver/Direct Link) and it supports the TI-Z80 series (73..86), the TI-68k series (89, 92+, V200, 89T) and the Nspire series (Nspire Clickpad / Touchpad / CX, both CAS and non-CAS)
* [codeman38/zvbi2raw](https://github.com/codeman38/zvbi2raw) - A quick-and-dirty tool for capturing vertical blanking interval data using libzvbi
* [brendangregg/Dump2PNG](https://github.com/brendangregg/Dump2PNG) - Visualize file data as a PNG
* [aidenbell/getdents](https://github.com/aidenbell/getdents) - Simple tool for listing large (millions) numbers of files on Linux systems without causing memory issues. Useful for shell scripting large data stores.
* [GNOME/tracker](https://github.com/GNOME/tracker) - Tracker is a semantic data storage for desktop and mobile devices.
* [thomasbhatia/nwEPC---EPC-SAE-Gateway](https://github.com/thomasbhatia/nwEPC---EPC-SAE-Gateway) - nwEPC is a free and open source framework software implementation of SAE/EPC Serving Gateway or SGW and Packet Data Network Gateway or PGW, which is sometimes referred as SAE-Gateway as well.
* [kineme/KinectTools](https://github.com/kineme/KinectTools) - Quartz Composer plugin that retrieves color and depth image data from the Xbox Kinect.
* [karrenberg/wfvopencl](https://github.com/karrenberg/wfvopencl) - IMPORTANT NOTICE: This implementation is long outdated. The latest wfvopencl will be made publicly available with the new libwfv implementation. WFVOpenCL is an OpenCL driver for CPUs on the basis of LLVM. This driver employs Whole-Function Vectorization (WFV) in addition to multi-threading to fully exploit the available data-parallelism by executing as many kernel instances in parallel as possible.
* [erimatnor/libckit](https://github.com/erimatnor/libckit) - A kit of C-based utilities and data structures.
* [dutc/generators](https://github.com/dutc/generators) - Generators for Stream Data Processing, or Generator Showcase Showdown
* [damiannz/ofxPd_damians](https://github.com/damiannz/ofxPd_damians) - Pure Data addon for openFrameworks
* [breckinloggins/libuseful](https://github.com/breckinloggins/libuseful) - A collection of useful data structures, algorithms, and utilities for C programming
* [arjun024/hide-data-in-ptr](https://github.com/arjun024/hide-data-in-ptr) - how to hide data inside pointers
* [ZhengYang/odbc_fdw](https://github.com/ZhengYang/odbc_fdw) - PostgreSQL Foreign-data Wrapper for ODBC
* [Unidata/gempak](https://github.com/Unidata/gempak) - Analysis, display, and product generation package for meteorological data.
* [DanielWaterworth/Butterfly](https://github.com/DanielWaterworth/Butterfly) - [DEPRECATED] Butterfly is a C library that implements a very simple 'dynamic' data-type. It could be used, for example, to manipulate JSON data from C. It is distributed under LGPL.
* [Blei-Lab/lda-c](https://github.com/Blei-Lab/lda-c) - This is a C implementation of variational EM for latent Dirichlet allocation (LDA), a topic model for text or other discrete data.
* [toddtreece/lib_mysqludf_mongodb](https://github.com/toddtreece/lib_mysqludf_mongodb) - MySQL UDF for inserting data into MongoDB
* [thegenemyers/DEXTRACTOR](https://github.com/thegenemyers/DEXTRACTOR) - Bax File Decoder and Data Compressor
* [thegenemyers/DAZZ_DB](https://github.com/thegenemyers/DAZZ_DB) - The Dazzler Data Base
* [npmccallum/deo](https://github.com/npmccallum/deo) - A service for binding data to networks
* [marekweb/datastructs-c](https://github.com/marekweb/datastructs-c) - Arraylist and Hashtable implementation in C
* [magnuskarlsson/SDLogger](https://github.com/magnuskarlsson/SDLogger) - Open Hardware Data Logger
* [magellannh/rtl-wx](https://github.com/magellannh/rtl-wx) - RTL-Wx logs data from 433Mhz wireless sensors using an RTL-SDR dongle.  The Wiki has some screenshots of the results
* [kevsmith/erlz](https://github.com/kevsmith/erlz) - Erlang wrapper for the fastlz (LZO-like) data compression library
* [emrainey/OpenCL-Environment](https://github.com/emrainey/OpenCL-Environment) - A series of utilities aimed at making OpenCL easier to use. Includes clCompiler which generates both binary outputs and precompiled headers which can be used in conjunction with clEnvironment. clQuery allows you to print all known information about a OpenCL data type. clPid, clYUV clImgFilter are all examples of how to use the utilities to create a compile time kernel make it a dependency in you makefiles and then use the clEnvironment to call your kernel.
* [dfm/acor](https://github.com/dfm/acor) - Estimate the autocorrelation time of time-series data very quickly
* [colindean/optar](https://github.com/colindean/optar) - OPTical ARchiver - highly compressed 2D barcode for paper or film archiving of digital data
* [biomood/LuaSerial](https://github.com/biomood/LuaSerial) - A Lua library in C for sending/receving data from Arduino
* [bianster/mysqlfs](https://github.com/bianster/mysqlfs) - MySQLfs is Linux userspace filesystem which stores data in a MySQL database. It uses FUSE to interface with the kernel.
* [armbrustlab/SEAStAR](https://github.com/armbrustlab/SEAStAR) - SEAStAR is a package of tools supporting the construction of complete analysis pipelines for next-generation (Illumina®, SOLiD™) sequencing data generated from environmental samples.
* [RoXXoR/ws2812](https://github.com/RoXXoR/ws2812) - ws2812/ws2811 led driver library for msp430, uses SPI and unique transport data encoding
* [vmayoral/bb_mpu9150](https://github.com/vmayoral/bb_mpu9150) - BeagleBone ROS package that publishes the Invensense MPU-9150 data into a Topic.
* [troydhanson/kvspool](https://github.com/troydhanson/kvspool) - A library to support streaming data applications
* [smithlabcode/methpipe](https://github.com/smithlabcode/methpipe) - A pipeline for analyzing DNA methylation data from bisulfite sequencing.
* [robmccoll/graphdb-testing](https://github.com/robmccoll/graphdb-testing) - Benchmarking various graph databases, engines, datastructures, and data stores.
* [raghavan291/Lazy-Deduplication](https://github.com/raghavan291/Lazy-Deduplication) - Data deduplication, data reduction, capacity optimized storage - is a specialized data compression technique for eliminating redundant data in the storage file system. It is often designed to make network backups to disk faster and more economical. It removes redundant data segments to compress data into a highly compact form and makes it economical to store backups on disk drive instead of tape drive. The technique identifies unique chunks of data, or byte patterns and stores them during the time of analysis. The chunks of new data are hashed and compared with the existing hashes of the other chunks to determine if there is a match. This project is aimed at creating a data deduplication file system which performs post-processing (lazy) analysis on the data stored into the file system
* [qayshp/TestDisk](https://github.com/qayshp/TestDisk) - TestDisk is powerful free data recovery software!
* [innoying/iOS-DataProtection](https://github.com/innoying/iOS-DataProtection) - Tools to manipulate and use iOS data protection features.
* [greghaynes/Afproto](https://github.com/greghaynes/Afproto) - Serial data framing protocol
* [gleu/sqlite_fdw](https://github.com/gleu/sqlite_fdw) - Foreign Data Wrapper for sqlite
* [fontforge/libuninameslist](https://github.com/fontforge/libuninameslist) - A library with a large (sparse) array mapping each unicode code point to the annotation data for it provided in http://www.unicode.org/Public/UNIDATA/NamesList.txt
* [caisonglu/cachemaster](https://github.com/caisonglu/cachemaster) - Cachemaster is similar to VMTOUCH, but with more functions. Such as kick page cache, warmup/readahead data, lock data in mem, stat page cache, stat page cache in realtime mode, by file or directory~ Personally, I think the most usefule function is real-time-statistic of page cache. You can see the page cache thrashing when kernel do page reclaiming.
* [brg-liuwei/ngx_kafka_module](https://github.com/brg-liuwei/ngx_kafka_module) - nginx kafka module, send post log data to kafka cluster
* [IreneKnapp/modern-data](https://github.com/IreneKnapp/modern-data) - A self-describing binary data format for dependently-typed object graphs.
* [wouterverweirder/AIR-Sudden-Motion-Sensor-Extension](https://github.com/wouterverweirder/AIR-Sudden-Motion-Sensor-Extension) - Native Extension for Adobe AIR, exposing the sudden motion sensor data of mac portables in your AIR application
* [winnukem/racehound](https://github.com/winnukem/racehound) - Data race detector for Linux kernel modules
* [teletautala/fullypwnd](https://github.com/teletautala/fullypwnd) - This program is designed to identify operating system and running services and find exploits for those services and attempt to connect.  I wanted that when the program finishes it's scan there was a way to report, annotate and clarify data.
* [samop/Polar-Flowlink-linux](https://github.com/samop/Polar-Flowlink-linux) - Development of interface for Polar FT60 HRM for Linux. It was tested with FT80 and it didn't work, due to different command set. I will need physical access to the watch to be able to devise a solution for other HRMs. Simple one page web interface that can be run on local machine and mimics polarpersonaltrainer is also included (see screenshot) but needs lots of polishing. Please note it is a work in progress. This early version pulls down all data except for weekly training program.
* [rfjakob/cshatag](https://github.com/rfjakob/cshatag) - Detect silent data corruption under Linux using checksums in extended attributes
* [kiyo-masui/bitshuffle](https://github.com/kiyo-masui/bitshuffle) - Filter for improving compression of typed binary data.
* [jamezilla/ats](https://github.com/jamezilla/ats) - ATS is a spectral modeling system based on a sinusoidal plus critical-band noise decomposition. Psychoacoustic processing informs the system's sinusoidal tracking and noise modeling algorithms. Perceptual Audio Coding (PAC) techniques such as Signal-to-Mask Ratio (SMR) evaluation are used to achieve perceptually accurate sinusoidal tracking. SMR values are also used as a psychoacoustic metric to determine the perceptual relevance of partials during analysis data postprocessing. The system's noise component is modeled using Bark-scale frequency warping and sub-band noise energy evaluation. Noise energy at the sub-bands is then distributed on a frame-by-frame basis among the partials resulting in a compact hybrid representation based on noise modulated sinusoidal trajectories.
* [cnlohr/wificompositer](https://github.com/cnlohr/wificompositer) - Various tools I used to collect and composite data from a wifi device into an image.
* [caisah/Sedgewick-algorithms-in-c-exercises-and-examples](https://github.com/caisah/Sedgewick-algorithms-in-c-exercises-and-examples) - Examples and exercises from Algorithms in C, Parts 1-4: Fundamentals, Data Structures, Sorting, Searching by Robert Sedgewick book
* [CVLearner/Mixture-of-Gaussians](https://github.com/CVLearner/Mixture-of-Gaussians) - Fit a Gaussian mixture model given a set of data
* [xaberus/nih](https://github.com/xaberus/nih) - libnih, the library interactive data dumper will be based upon
* [woodrow/cidr-report_analysis](https://github.com/woodrow/cidr-report_analysis) - Data processing & analysis tools to replicate the CIDR Report and study Internet route aggregation.
* [vsbuffalo/seqqs](https://github.com/vsbuffalo/seqqs) - seqqs is a C program/library for gathering quality statistics from sequencing data
* [vijay03/optfs](https://github.com/vijay03/optfs) - The Optimistic File System (OptFS) is a Linux ext4 variant that implements Optimistic Crash Consistency, a new approach to crash consistency in journaling file systems. OptFS improves performance for many workloads, sometimes by an order of magnitude. OptFS provides strong consistency, equivalent to data journaling mode of ext4.
* [tfoldi/fuse-tableaufs](https://github.com/tfoldi/fuse-tableaufs) - User-space filesystem for Tableau Server for accessing workbooks and data sources as files.
* [stripydog/kplex](https://github.com/stripydog/kplex) - kplex marine data multiplexer
* [sptim/mp3hash](https://github.com/sptim/mp3hash) - Command line tool to calculate the hash of the music data in mp3 files (without id3v1 & id3v2 metadata). Useful to find dupes with e.g. different genre names.
* [philwieland/openrail](https://github.com/philwieland/openrail) - Open Rail Data Processing
* [mit-carbon/Flat-Combining](https://github.com/mit-carbon/Flat-Combining) - Traditional data-structure designs, whether lock-based or lock-free, provide parallelism via fine grained synchronization among threads. Flat Combining is a new, efficient synchronization paradigm based on coarse locking.
* [mil/foo-wm](https://github.com/mil/foo-wm) - A minimal window manager that organizes windows in a tree data structure, provides a socket to send commands to, and nothing more.
* [lneto/luadata](https://github.com/lneto/luadata) - Lua data library
* [kozyraki/phoenix](https://github.com/kozyraki/phoenix) - an API and runtime environment for data processing with MapReduce for shared-memory multi-core & multiprocessor systems.
* [knossos-project/knossos](https://github.com/knossos-project/knossos) - KNOSSOS is a software tool for the visualization and annotation of 3D image data and was developed for the rapid reconstruction of neural morphology and connectivity.
* [kehribar/xmega_ov7670](https://github.com/kehribar/xmega_ov7670) - OV7670 image sensor data capture with Atxmega32E5 without using external FIFO
* [jpiper/pyDNase](https://github.com/jpiper/pyDNase) - Python module for the easy handling and analysis of DNase-seq data
* [jknotzke/GoldenEmbed](https://github.com/jknotzke/GoldenEmbed) - Embedded Firmware for the Sparkfun Logomatic V2 which will log ANT+ data
* [happyfish100/fastdht](https://github.com/happyfish100/fastdht) - FastDHT is a high performance distributed hash table (DHT) which based key value pairs. It can store mass key value pairs such as filename mapping, session data and user related data.
* [graphitemaster/libintrusive](https://github.com/graphitemaster/libintrusive) - Intrusive data structures for C
* [emacsattic/doxymacs](https://github.com/emacsattic/doxymacs) - Code to efficiently read/write XML data with Elisp --- IN ATTIC BECAUSE: import problems
* [davidh-ssec/polar2grid](https://github.com/davidh-ssec/polar2grid) - Tools for reading, remapping, and writing satellite instrument data.
* [darthstroyer/005tools](https://github.com/darthstroyer/005tools) - Open-source software for extracting save data from Nintendo DS, DSi and 3DS game cards
* [credativ/informix_fdw](https://github.com/credativ/informix_fdw) - Foreign Data Wrapper for Informix Databases
* [chriso/bitset](https://github.com/chriso/bitset) - A compressed bitset with supporting data structures and algorithms
* [chrisforbes/libaof](https://github.com/chrisforbes/libaof) - Age Of Empires Data Format Parsers
* [astro/collectd](https://github.com/astro/collectd) - Some personal modifications to collectd, the kick-ass data collector
* [alexanderchuranov/Metaresc](https://github.com/alexanderchuranov/Metaresc) - META data and RESource library for  C language
* [XVilka/cparse](https://github.com/XVilka/cparse) - Parser of C-syntax data definitions, C-syntax function definitions
* [MartinMittring/dcraw_exif](https://github.com/MartinMittring/dcraw_exif) - dcraw (Camera RAW format processor) from Dave Coffin with updates, additionally maintain exif data for using it with Agisoft PhotoScan
* [LongSoft/FD44Copier](https://github.com/LongSoft/FD44Copier) - Utility to copy BIOS data from one ASUS BIOS image file to another
* [JeffreyRacine/R-Package-np](https://github.com/JeffreyRacine/R-Package-np) - R package np (Nonparametric Kernel Smoothing Methods for Mixed Data Types)
* [BungeeProject/bungee](https://github.com/BungeeProject/bungee) - Big Unstructured Data Analytics
* [xerpi/libsicksaxis](https://github.com/xerpi/libsicksaxis) - SickSaxis is a C library that lets you connect a Sixaxis or a DualShock3 to the Wii and read its data. It also lets you turn on and off the controller LEDs, enable or disable the rumble and get and set the controllers' bluetooth MAC address.
* [vi/fdlinecombine](https://github.com/vi/fdlinecombine) - Read multiple fds and print data to stdout linewise.
* [valotrading/tick](https://github.com/valotrading/tick) - Tick, a market data tool.
* [sciguy14/MSP430-Wireless-Weather-Station](https://github.com/sciguy14/MSP430-Wireless-Weather-Station) - A Remote MSP430 monitors temperature, light, and humidity and sends the data to a local UART-USB MSP430.  A processing script graphs the data in real time on a computer.
* [pseudomuto/c-data-structures](https://github.com/pseudomuto/c-data-structures) - A simple library of data structures for C
* [peterburk/stackoverflowlocal](https://github.com/peterburk/stackoverflowlocal) - Scripts for locally hosting and searching a compressed StackOverflow data dump
* [lioncash/ExtractData](https://github.com/lioncash/ExtractData) - An extraction tool for visual novels. Originally developed by Yuu.
* [kfish/libfishsound](https://github.com/kfish/libfishsound) - A simple programming interface for decoding and encoding audio data using Xiph.org codecs (FLAC, Speex and Vorbis)
* [infofarmer/hashtypes](https://github.com/infofarmer/hashtypes) - sha1, md5 and other data types for PostgreSQL
* [hyPiRion/roulette-tree](https://github.com/hyPiRion/roulette-tree) - Data structure for efficient fitness-proportionate selection.
* [hroptatyr/uterus](https://github.com/hroptatyr/uterus) - universal tick encoder library to efficiently transport huge amounts of tick data
* [hpc/scr](https://github.com/hpc/scr) - SCR caches checkpoint data in storage on the compute nodes of a Linux cluster to provide a fast, scalable checkpoint / restart capability for MPI codes.
* [freshcode/MFMathLib](https://github.com/freshcode/MFMathLib) - A mathematical library providing basic math operations on data types from 8-bits to 1024-bits with overflow/underflow tracking.
* [freefoote/gpscorrelate](https://github.com/freefoote/gpscorrelate) - Abandoned C program to match GPS tracks to photographs, and store the matches in the EXIF data in the photographs.
* [coolwanglu/quantile-alg](https://github.com/coolwanglu/quantile-alg) - Algorithms for finding quantiles of a data stream
* [bjoernknafla/peak](https://github.com/bjoernknafla/peak) - Parallelism exploration assembly kit. C toolkit to experiment with task- and data-parallelism.
* [DanAnkers/garmin-ant-downloader](https://github.com/DanAnkers/garmin-ant-downloader) - Clone of and updates to "gant", a tool for downloading data off certain Garmin Edge and Forerunner devices.  "garmin-ant-downloader" is the name given to this project by Debian and Ubuntu
* [51Degrees/Device-Detection](https://github.com/51Degrees/Device-Detection) - THE Fastest and most Accurate device detection for C / PHP / Perl / Python and Node.js - professionally maintained device data
* [umitanuki/tinyint-postgresql](https://github.com/umitanuki/tinyint-postgresql) - A tiny int implementation as a data type of PostgreSQL
* [ufo-kit/ufo-core](https://github.com/ufo-kit/ufo-core) - GLib-based framework for GPU-based data processing
* [sdiehl/pycraig](https://github.com/sdiehl/pycraig) - Python library for scraping data from Craigslist
* [rustyrussell/bitcoin-iterate](https://github.com/rustyrussell/bitcoin-iterate) - Simple fast iterator to extract data from bitcoind's blockchain files.
* [ruslin/data_share](https://github.com/ruslin/data_share) - 个人一般数据、文件
* [rpetrich/untrackerd](https://github.com/rpetrich/untrackerd) - Continuously clean up locationd's history data
* [psobot/ipsumcrypt](https://github.com/psobot/ipsumcrypt) - A small C program to embed binary data into the whitespace between words.
* [pkmital/StickFigureOSC](https://github.com/pkmital/StickFigureOSC) - Streams PrimeSense NITE's Skeleton Data via OSC (XCode Project)
* [niftylight/niftyled](https://github.com/niftylight/niftyled) - library designed to provide an abstract interface for LED/lighting hardware to easily control it using pixel data.
* [mrrrgn/tcp2d](https://github.com/mrrrgn/tcp2d) - A utility to produce data sets for machine learning and statistical analysis from tcp streams.
* [mfragkoulis/PiCO_QL](https://github.com/mfragkoulis/PiCO_QL) - SQL query interface to C++ collections and C data structures. Also configurable as a loadable Linux kernel module and an extension to Valgrind tools.
* [memo/ofxMSAInterpolator](https://github.com/memo/ofxMSAInterpolator) - C++ openFrameworks addon with a set of template classes for doing various types of interpolations on data with any number of dimensions. You can feed the system an arbitrary number of data, then resample at any resolution, or ask for the value at any percentage along the data. Input data can be floats (for 1D splines, Vec2f (for 2D splines), Vec3f (for 3D splines), or even matrices, or custom data types (e.g. biped pose). Demo at www.memo.tv/msainterpolator
* [matildah/fastcat](https://github.com/matildah/fastcat) - netcat-like thing that uses the linux syscall splice(2) to avoid overhead from copying data from kernelspace/userspace
* [marcelloceschia/chan-datacard](https://github.com/marcelloceschia/chan-datacard) - clone of https://code.google.com/p/asterisk-chan-dongle/ with asterisk 11 branch
* [kroki/XProbes](https://github.com/kroki/XProbes) - Explicit probes (XProbes) - static user space probes with natural data access.
* [jwise/ndfslave](https://github.com/jwise/ndfslave) - Tools to pull data off of a NAND flash chip using a Digilent Nexys-2 board.
* [hhetter/smbtatools](https://github.com/hhetter/smbtatools) - Tools to query the SMB traffic analyzer data base
* [heewa/pipestats](https://github.com/heewa/pipestats) - Stats about data being piped.
* [gnemoug/data_structure](https://github.com/gnemoug/data_structure) - 关于各种数据结构和算法的一些收录
* [ericmandel/funtools](https://github.com/ericmandel/funtools) - A "minimal buy-in" FITS library and utility package for astronomical data analysis
* [crass/lessfs](https://github.com/crass/lessfs) - lessfs - An inline data deduplicating filesystem
* [chucknthem/Data-structures-algorithms](https://github.com/chucknthem/Data-structures-algorithms) - Collection of Data structures, algorithms and interesting bits of code.
* [careermonk/DataStructuresAndAlgorithmsMadeEasy](https://github.com/careermonk/DataStructuresAndAlgorithmsMadeEasy) - Data Structures And Algorithms Made Easy
* [bwlewis/lazy.frame](https://github.com/bwlewis/lazy.frame) - Lazy person's file-backed data frame
* [bauerca/gridfloat](https://github.com/bauerca/gridfloat) - Slice and dice USGS elevation data from the command line.
* [autosportlabs/RaceCapture-Pro_firmware](https://github.com/autosportlabs/RaceCapture-Pro_firmware) - Firmware for RaceCapture-Pro Data Acquisition, control and Telemetry system for motorsports
* [argv0/nbds](https://github.com/argv0/nbds) - C implementations of several scalable non-blocking data structures for x86 and x86-64.
* [StefanKarpinski/odb](https://github.com/StefanKarpinski/odb) - ODB: On-Disk Binary Data Tool
* [NDN-Routing/NDNLP](https://github.com/NDN-Routing/NDNLP) - Named Data Networking Link Protocol
* [MDSplus/mdsplus](https://github.com/MDSplus/mdsplus) - The MDSplus data management system
* [Frans-Willem/EspLightNode](https://github.com/Frans-Willem/EspLightNode) - ESP8266 firmware to receive lighting data over TPM2, Art-Net and drive a WS2801 addressable LED strip.
* [ComputerNerd/ov7670-simple](https://github.com/ComputerNerd/ov7670-simple) - This is a simple sample code of the ov7670 on the arduino uno sends data over serial.
* [ComputerNerd/RawCamera-data-converter](https://github.com/ComputerNerd/RawCamera-data-converter) - This program was made to convert raw data from the ov7670 to a png file. It may also work with other cameras.
* [AC-2015-Sem2/DSA-lab](https://github.com/AC-2015-Sem2/DSA-lab) - Data Structures and Algorithms lab repository
* [xiao70/X70FSD](https://github.com/xiao70/X70FSD) - Windows file system filter drivers(minifilter) to encrypt, compress, or otherwise modify file-based data require some of the most complex kernel software developed for Windows.
* [sustrik/msg_control](https://github.com/sustrik/msg_control) - Helper functions for dealing with socket ancillary data
* [sp4cerat/RLE-based-Voxel-Raycasting](https://github.com/sp4cerat/RLE-based-Voxel-Raycasting) - CUDA based Voxel Raycasting - Paper: Efficient, High-Quality, GPU-Based Visualization of Voxelized Surface Data
* [scottransom/psrfits2psrfits](https://github.com/scottransom/psrfits2psrfits) - Convert 16-bit PSRFITS search-mode data to 4- or 8-bit PSRFITS data
* [rxin/db-benchmarks](https://github.com/rxin/db-benchmarks) - Collection of some database benchmarks, along with tools to parallelize the data generation.
* [phlowy/splunk-phlow](https://github.com/phlowy/splunk-phlow) - This is an application for consuming netflow v5,7,9 data using NFDUMP, iNotify, Binary-ASCII coverter, and Splunk!
* [mogenson/USBTempLogger](https://github.com/mogenson/USBTempLogger) - A two component USB temperature data logger made from a PIC16F1455
* [markjasonanderson/wiegand-linux](https://github.com/markjasonanderson/wiegand-linux) - Linux driver for reading wiegand data from GPIO. Tested  for ARM 9G20 (linux stamp)
* [lp/puredis](https://github.com/lp/puredis) - Pure-Data Redis External
* [locasto/libdisorder](https://github.com/locasto/libdisorder) - A simple C library for entropy measurement of byte streams and other data.
* [lh3/naivepca](https://github.com/lh3/naivepca) - Naive PCA for genotype data
* [lgfischer/dcel](https://github.com/lgfischer/dcel) - A DCEL implementation, described in details in http://leonardofischer.com/dcel-data-structure-c-plus-plus-implementation/
* [justjkk/gtfs2pgrouting](https://github.com/justjkk/gtfs2pgrouting) - Import GTFS data into Postgresql database for use by pgrouting
* [jonstewart/foremost](https://github.com/jonstewart/foremost) - Foremost is a console program to recover files based on their headers, footers, and internal data structures. c.f., http://foremost.sourceforge.net/
* [jobovy/extreme-deconvolution](https://github.com/jobovy/extreme-deconvolution) - Density estimation using Gaussian mixtures in the presence of noisy, heterogeneous and incomplete data
* [jeromekelleher/msprime](https://github.com/jeromekelleher/msprime) - A reimplementation of Hudson's classical ms simulator for modern data sets.
* [iunderstand/SWE](https://github.com/iunderstand/SWE) - SWE Toolkit. Learning Semantic Word Embeddings based on Ordinal Knowledge Constraints. A general framework to incorporate semantic knowledge into the popular data-driven learning process of word vectors. Applications including word similarity, sentence completion, etc. ACL-2015 long paper, Beijing, China
* [infincia/Cardrand](https://github.com/infincia/Cardrand) - This is a simple demonstration of two things, pulling random entropy out of a hardware smart card, and feeding that data into the Linux kernel pool using an ioctl call. Makes it possible for any Linux system to have a real hardware random number generator
* [franckverrot/git_fdw](https://github.com/franckverrot/git_fdw) - PostgreSQL Git Foreign Data Wrapper
* [derpston/linux-rpi-audi-dis](https://github.com/derpston/linux-rpi-audi-dis) - Linux kernel module for sending data to the DIS LCD in an Audi car from a Raspberry Pi.
* [demorest/psrfits_utils](https://github.com/demorest/psrfits_utils) - Utility library for working with search- and fold-mode PSRFITS pulsar data files.
* [demerphq/Data-Undump](https://github.com/demerphq/Data-Undump) - Perl extension for securely and quickly deserializing simple Data::Dumper dumps
* [conghui/algorithms-in-c](https://github.com/conghui/algorithms-in-c) - Exercise of the book Algorithms In C, Part 1-4, Fundamentals, Data Strcuture, Sorting, Searching, written by  Robert Sedgewick
* [cbgbt/DataStructures](https://github.com/cbgbt/DataStructures) - A data structures library written in C.
* [bsmulders/CaptureTheData](https://github.com/bsmulders/CaptureTheData) - Vehicle data logging, parsing and analysis using C, PHP, JavaScript (Ext JS 4)
* [bonemurmurer/simplebonjour](https://github.com/bonemurmurer/simplebonjour) - pure-data external providing simple bonjour service name discovery and port resolution
* [baiwei0427/PIAS](https://github.com/baiwei0427/PIAS) - Information-Agnostic Flow Scheduling for Commodity Data Centers
* [ajrisi/fsm](https://github.com/ajrisi/fsm) - A finite state machine engine in C - used as a parser for complex data structures
* [RhysU/ESIO](https://github.com/RhysU/ESIO) - The ExaScale IO (ESIO) library provides simple, high throughput input and output of structured data sets using parallel HDF5. ESIO is designed to support reading and writing turbulence simulation restart files within C, C++, and modern Fortran applications.
* [JohnWong/android-chirp](https://github.com/JohnWong/android-chirp) - Broadcast data by sound on android like Chirp
* [GNOME/libgda](https://github.com/GNOME/libgda) - Libgda is a (relatively small) database access library:
* [AerialX/djmax-dongletools](https://github.com/AerialX/djmax-dongletools) - DJMax Trilogy Save Data Manager
* [wezm/open2300](https://github.com/wezm/open2300) - Open2300 is a package of software tools that reads (and writes) data from a Lacrosse WS23xx Weather Stations. This repo is an import of the official SVN repo with some additions.
* [wdlindmeier/Interferometer-Watch](https://github.com/wdlindmeier/Interferometer-Watch) - A data visualization to observe the state of LIGO machines
* [vdloo/Beacontalk](https://github.com/vdloo/Beacontalk) - Peer to peer chat-program that sends data over Wi-Fi without associations.
* [sphde/sphde](https://github.com/sphde/sphde) - Shared Persistent Heap Data Environment
* [skopjehacklab/MeteoKutija](https://github.com/skopjehacklab/MeteoKutija) - The MeteoBox (MeteoKutija) is a cheap device that collects a set of meteorological data and publishes it to a central database.
* [sebnow/data_structures](https://github.com/sebnow/data_structures) - A collection of data structures, written in C.
* [razpeitia/data-structures](https://github.com/razpeitia/data-structures) - Stack, Queue, Binary Tree
* [pchote/falloutviewer](https://github.com/pchote/falloutviewer) - A tool for viewing and extracting files from Fallout 2 data archives
* [otto-de/trackrdrd](https://github.com/otto-de/trackrdrd) - The Tracking Log Reader demon reads from the shared memory log of a running instance of Varnish, aggregates data logged in a specific format for requests and ESI subrequests, and forwards the data to a messaging system (such as ActiveMQ or Kafka).
* [oap/ekf-angles](https://github.com/oap/ekf-angles) - Extended Kalman Filter for Accelerometer and Gyro data
* [nitrogenlogic/kinradar](https://github.com/nitrogenlogic/kinradar) - Displays a pseudocolor ASCII-art radar-like view of Kinect depth data.
* [mmb/vmod_dgram](https://github.com/mmb/vmod_dgram) - Varnish VMOD to send data over UDP from VCL.
* [mlaurijsse/linux-mpu9150](https://github.com/mlaurijsse/linux-mpu9150) - 9-axis data fusion for Linux-based systems using the InvenSense MPU-9150 IMU
* [mbykov/diglossa.data](https://github.com/mbykov/diglossa.data) - texts for diglossa.org
* [mback2k/wireshark-amf](https://github.com/mback2k/wireshark-amf) - Wireshark dissector for the Action Message Format data protocol and representation
* [maximeh/tesla](https://github.com/maximeh/tesla) - Grab data from an OWL-CM160 and generate graph using RRD
* [maciejczyzewski/hashbase](https://github.com/maciejczyzewski/hashbase) - A fast, efficient on-disk/in-memory database with many different kind of data structures. :floppy_disk:
* [louiswins/RB-Tree](https://github.com/louiswins/RB-Tree) - An implementation of the Red-Black Tree data structure.
* [laijs/userspace-rcu](https://github.com/laijs/userspace-rcu) - Laijs-maintained  Userspace-RCU tree for concurrent data struct(cds) changes
* [kronihias/espeak](https://github.com/kronihias/espeak) - pure data external to synthesize text to an array with espeak library
* [jwmatthys/kalman-pd](https://github.com/jwmatthys/kalman-pd) - Simple control rate Kalman filter for Pure Data
* [jlapeyre/PDL-IO-Matlab](https://github.com/jlapeyre/PDL-IO-Matlab) - Reading and writing matlab format data files for the perl data language.
* [hvdieren/swan](https://github.com/hvdieren/swan) - Data-flow driven work-stealing scheduler
* [hcarty/ocaml-hdf](https://github.com/hcarty/ocaml-hdf) - Library for reading/writing HDF4 data and reading NetCDF data
* [hackingtype1/cgm-pebble](https://github.com/hackingtype1/cgm-pebble) - pebble watch-face or app to display cgm data
* [gibranfp/Sampled-MinHashing](https://github.com/gibranfp/Sampled-MinHashing) - MinHash-based clustering for binary and weighted dyadic data (e.g. bag of words).
* [ghostrong/algorithm](https://github.com/ghostrong/algorithm) - Data Structure and Algorithms
* [gamefreak/Athena](https://github.com/gamefreak/Athena) - Data editor for Xsera, Antares, and Ares
* [fredrikbk/libpack](https://github.com/fredrikbk/libpack) - Library that packs/serializes or unpacks/deserializes user-defined data layouts. The data layouts are specified using datatypes similar to MPI Datatypes. The library compiles the datatypes into efficient vectorized pack/unpack code at commit time using an LLVM-based online compiler.
* [foool/Z-code](https://github.com/foool/Z-code) - A family of XOR erasure codes with optimal repair bandwidth for a single data node failure
* [etmc/lemon](https://github.com/etmc/lemon) - Lemon is an MPI parallel I/O library that is intended to allow for efficient parallel I/O of both binary and metadata on massively parallel architectures. Data is stored in the SciDAC Lattice QCD Interchange Message Encapsulation format, that allows for storing large blocks of binary data and corresponding metadata in the same file.
* [esden/ppm_to_spektrum_encoder](https://github.com/esden/ppm_to_spektrum_encoder) - An atmega based board converting standard servo data to spektrum satellite serial protocol for use with Paparazzi
* [demorest/guppi_daq](https://github.com/demorest/guppi_daq) - Data acquisition software primarily for the GUPPI pulsar backend.
* [debrouxl/tilp-libticables](https://github.com/debrouxl/tilp-libticables) - TILP (formerly GtkTiLink) can transfer data between Texas Instruments scientific calculators and a computer. It works with all link cables (parallel, serial, Black/Gray/Silver/Direct Link) and it supports the TI-Z80 series (73..86), the TI-68k series (89, 92+, V200, 89T) and the Nspire series (Nspire Clickpad / Touchpad / CX, both CAS and non-CAS)
* [dcshi/Mysync](https://github.com/dcshi/Mysync) - Mysync is an MySQL binlog Parser. With it, you can sync mysql data to any other servers, such as redis, mc, sphinx and so on
* [chneukirchen/rdd](https://github.com/chneukirchen/rdd) - random data dumper
* [chadjoan/C-Survival-Kit](https://github.com/chadjoan/C-Survival-Kit) - A set of useful functions, data structures, and macros aimed at allowing more expressive and reliable C code.  Portability targets are OpenVMS and Linux.
* [canonizer/libgpuvm](https://github.com/canonizer/libgpuvm) - library which simplifies host-GPU data transfer using userspace pagefault handling
* [blucia0a/CTraps-gcc](https://github.com/blucia0a/CTraps-gcc) - Last Writer Slicing: data provenance tracking for concurrent program debugging & analysis
* [blodow/realtime_urdf_filter](https://github.com/blodow/realtime_urdf_filter) - ROS package that can filter geometry defined in URDF models from Kinect depth images. Can also preprocess data for the OpenNI tracker, to remove backgrounds, robots etc.
* [billvb/cfe](https://github.com/billvb/cfe) - This framework is used as the basis for the flight software for satellite data systems and instruments, but can be used on other embedded systems.
* [ashwinraghav/Parallel_Open_SSL](https://github.com/ashwinraghav/Parallel_Open_SSL) - Use your idle GPU to encrypt your data. Give your CPU some breathing time!
* [asanchez1987/jobcomp-elasticsearch](https://github.com/asanchez1987/jobcomp-elasticsearch) - SLURM jobcomp plugin to index data into an elasticsearch server
* [anza/metar](https://github.com/anza/metar) - METAR data fetcher and parser
* [alessio9008/Thingsquare-Contiki-O.S-Porting-STM32F4-Discovery](https://github.com/alessio9008/Thingsquare-Contiki-O.S-Porting-STM32F4-Discovery) - We have ported the Contiki Operating System to STM32F4 platform (http://www.st.com/stm32f4-discovery). We started with the work that was already done on an evaluation board based on STM32L1 platform (STEVAL-IKR001V1, http://www.st.com/web/en/catalog/tools/PF253893). The original project, called "Mist", was created by Thingsquare using Spirit1 radio transceiver (STEVAL-IKR001V8D, http://www.st.com/web/en/catalog/tools/FM116/SC1075/PF258319). We converted the system calls from the original platform to the target platform. We have adapted Spirit1 radio driver in order to work properly on STM32F4. Then, we created a Wireless Sensor Network and collected several communication and performance data.  I worked on it with Daniele Saitta.  To manage the entire work, we used IAR Embedded Workbench (http://www.iar.com/en/products/iar-embedded-workbench/arm/).
* [addy689/DataStructuresLab](https://github.com/addy689/DataStructuresLab) - Graph Traversal (BFS & DFS), Single Source Shortest Path, Minimum Spanning Tree, RB Trees, B-Trees
* [ZSShen/C-Common-Data-Structures](https://github.com/ZSShen/C-Common-Data-Structures) - Uniform C APIs for data structure manipulation
* [XenonofArcticus/DynamicTrack](https://github.com/XenonofArcticus/DynamicTrack) - Access sources of dynamically-updated data about discrete entities like GPSes, INSes, ADS-B sources.
* [TPSully/SRTM2STL](https://github.com/TPSully/SRTM2STL) - Create STL files from SRTM data for the purpose of creating 3D relief maps.
* [SCIInstitute/fluorender](https://github.com/SCIInstitute/fluorender) - FluoRender is an interactive rendering tool for confocal microscopy data visualization.
* [RobertABT/heightmap](https://github.com/RobertABT/heightmap) - OS data to STL for a 3d printer (Work in Progress)
* [Remi-C/Pointcloud_in_db](https://github.com/Remi-C/Pointcloud_in_db) - This is a short project using  www.postgis.net , and www.github.com/pramsey/pointcloud  to store efficentlly large point clouds in a www.postgresql.org data base
* [GROX13/BitTorrent](https://github.com/GROX13/BitTorrent) - BitTorrent is a protocol for the practice of peer-to-peer file sharing that is used to distribute large amounts of data over the Internet. BitTorrent is one of the most common protocols for transferring large files, and peer-to-peer networks have been estimated to collectively account for approximately 43% to 70% of all Internet traffic (depending on geographical location) as of February 2009. In November 2004, BitTorrent was responsible for 35% of all Internet traffic. As of February 2013, BitTorrent was responsible for 3.35% of all worldwide bandwidth, more than half of the 6% of total bandwidth dedicated to file sharing.
* [Cthutu/Krull](https://github.com/Cthutu/Krull) - Data definition language
* [CGNS/CGNS](https://github.com/CGNS/CGNS) - The CFD General Notation System (CGNS) provides a standard for recording and recovering computer data associated with the numerical solution of fluid dynamics equations.
* [winton/redis_parse](https://github.com/winton/redis_parse) - Reads huge amounts of pipe-delimited data from Redis, filters it, and returns counts by occurence
* [wellsie1116/Darxen](https://github.com/wellsie1116/Darxen) - Downloader, parser, and renderer for NEXRAD data
* [wankdanker/node-unixodbc-isql-json](https://github.com/wankdanker/node-unixodbc-isql-json) - A hacky solution for querying ODBC data sources (including MS SQL) with nodejs.
* [vndmtrx/libadt](https://github.com/vndmtrx/libadt) - :vertical_traffic_light:libadt - an abstract data types library
* [ufjf-dcc/dsgraph](https://github.com/ufjf-dcc/dsgraph) - DSGraph is an C/C++ library for visualizing data structures.
* [tsznxx/wLib](https://github.com/tsznxx/wLib) - Python Modules for High-throughput Sequencing Data Analysis
* [takev/mod_okioki](https://github.com/takev/mod_okioki) - An apache module that offers a RESTful data service with a PostgresQL server.
* [suprgyabhushan/Data-Structures-And-Algorithms](https://github.com/suprgyabhushan/Data-Structures-And-Algorithms) - All my codes done in the Course DSA during the second semester at IIIT Bangalore
* [sounos/hidbase](https://github.com/sounos/hidbase) - Distributed Data Storage System
* [sipcapture/hepipe](https://github.com/sipcapture/hepipe) - HEP-PIPE: Pipe arbitrary data (logs, events, cdrs, etc) to HEP server (HOMER)
* [siddhant3s/cs215](https://github.com/siddhant3s/cs215) - My Third Semester, Data Structure Lab programs
* [sean-/postgresql-varint](https://github.com/sean-/postgresql-varint) - Data type for PostgreSQL that encodes integers using variable width encoding in order to save space
* [sdroege/snippets](https://github.com/sdroege/snippets) - Some algorithms and data structures
* [samuellab/InterProcess](https://github.com/samuellab/InterProcess) - A compact C library to share data between processes on Windows. Fast. Simple
* [rjsikarwar/gpu_compression](https://github.com/rjsikarwar/gpu_compression) - Nine Light weight Schemes to Compress and Decompress the data of Database Using GPU and also a planer
* [richox/comprox](https://github.com/richox/comprox) - An experimental lossless data compression program with high compression ratio.
* [r-medina/ll](https://github.com/r-medina/ll) - Thread safe linked list data structure for C
* [popoffka/i3lock](https://github.com/popoffka/i3lock) - i3lock is a simple screen locker like slock. This repo contains a patched version of i3lock which displays additional data on the lock screen, such as current time (like this: http://nn.lv/3y1s).
* [pforemski/libpjf](https://github.com/pforemski/libpjf) - A C library of data structures with tools (based on libasn)
* [pd-projects/pd-double](https://github.com/pd-projects/pd-double) - a dev fork of pure-data.git for working on 64-bit double-precision support
* [ossc-db/pg_bulkload](https://github.com/ossc-db/pg_bulkload) - High speed data loading utility for PostgreSQL
* [osdba/qpipe](https://github.com/osdba/qpipe) - Across the network of pipe tools, data sent through a pipe to another host, providing a reliable transmission function.
* [noporpoise/seq_file](https://github.com/noporpoise/seq_file) - Library for Reading Bioinformatic Sequence Data in C
* [nebneuron/clique-top](https://github.com/nebneuron/clique-top) - Topological data analysis tools for cross correlation matrices
* [ncbi/osiris](https://github.com/ncbi/osiris) - OSIRIS is a public domain quality assurance software package that facilitates the assessment of multiplex short tandem repeat (STR) DNA profiles based on laboratory-specific protocols.  OSIRIS evaluates the raw electrophoresis data contained in .fsa or .hid files using an independently derived mathematically-based sizing algorithm.  OSIRIS currently supports ABI capillary analytical platforms and numerous commercially available marker kits including all CODIS-compliant kits as well as those favored by biomedical laboratories.
* [nathanleclaire/algorithms_and_data_structures](https://github.com/nathanleclaire/algorithms_and_data_structures) - Want to learn more fundamentals of Comp Sci and get some practice writing C, C++, and Java.
* [mw55309/c_fast5](https://github.com/mw55309/c_fast5) - C code to extract data from fast5 files
* [muvarov/daq-odp](https://github.com/muvarov/daq-odp) - OpenDataPlane.org (ODP) Data Acquisition module for Snort.
* [mozilla-services/lua_circular_buffer](https://github.com/mozilla-services/lua_circular_buffer) - Sliding window time series data storage and analysis.
* [mikedlowis/data-structures](https://github.com/mikedlowis/data-structures) - A collection of data structures implemented in C to be included in multiple projects.
* [miezuit/php-base85](https://github.com/miezuit/php-base85) - A PHP extension to encode/decode data with base85.
* [messense/data-structure-learning](https://github.com/messense/data-structure-learning) - 数据结构学习，作业代码
* [mattfoster/matlab-interpolation-toolkit](https://github.com/mattfoster/matlab-interpolation-toolkit) - A matlab toolkit for interpolating scattered data in interesting ways.
* [mariokonrad/grib](https://github.com/mariokonrad/grib) - GRIB data access
* [mar-file-system/marfs](https://github.com/mar-file-system/marfs) - MarFS provides a scalable near-POSIX file system by using one or more POSIX file systems as a scalable metadata component and one ore more data stores (object, file, etc) as a scalable data component. Our initial implementation will use GPFS file systems as the metadata component and Scality and EMC ECS ViPR object stores as the data component.
* [lgsonic/mysqlIncSync](https://github.com/lgsonic/mysqlIncSync) - A mysql incremental synchronization tool which can parse mysql row-format binlog and process the incremental data
* [leecbaker/datareftool](https://github.com/leecbaker/datareftool) - Dataref Tool for X-Plane plugin development
* [kyle-github/libplctag](https://github.com/kyle-github/libplctag) - This library provides a portable and simple API for accessing PLC data over Ethernet and serial links.
* [ksheedlo/kmdata](https://github.com/ksheedlo/kmdata) - Data structures for C programmers, by C programmers.
* [kscz/n_stress](https://github.com/kscz/n_stress) - Linux network stress tester - attempts to send and receive data over a network as fast as possible and confirm integrity of the data
* [krakjoe/SIMD](https://github.com/krakjoe/SIMD) - Simple Instructions, Multiple Data
* [kljensen/Gemoda](https://github.com/kljensen/Gemoda) - A generic motif discovery algorithm for sequential data
* [kbranigan/pow](https://github.com/kbranigan/pow) - C datastore/cache for MySQL data
* [k7f/PureData](https://github.com/k7f/PureData) - branching clone of git://pure-data.git.sourceforge.net/gitroot/pure-data/pure-data
* [jmasters/gbt-pipeline](https://github.com/jmasters/gbt-pipeline) - The Green Bank Telescope data analysis pipeline
* [jkff/scrunch](https://github.com/jkff/scrunch) - Stream cruncher - data stream algorithms
* [jcw/vlerq](https://github.com/jcw/vlerq) - Vlerq is an experiment in column-wise data, persistence, and scripting
* [japeq/bencode-tools](https://github.com/japeq/bencode-tools) - bencode-tools is a collection of tools for manipulating bencoded data.
* [ibarwick/firebird_fdw](https://github.com/ibarwick/firebird_fdw) - A PostgreSQL foreign data wrapper (FDW) for Firebird
* [hughsie/appdata-tools](https://github.com/hughsie/appdata-tools) - Application data website
* [hroptatyr/glod](https://github.com/hroptatyr/glod) - Grokking lots of data
* [guomeizhou/data_structure](https://github.com/guomeizhou/data_structure) - 数据结构
* [gokhankici/orc_fdw](https://github.com/gokhankici/orc_fdw) - PostgreSQL extension which implements a Foreign Data Wrapper (FDW) for ORC files.
* [gnudennis/ds_c](https://github.com/gnudennis/ds_c) - Data Structure In C
* [garthz/pdwiringPi](https://github.com/garthz/pdwiringPi) - Pure Data (pd) external for hardware I/O on a Raspberry Pi using wiringPi.
* [fygrave/moloch_zmq](https://github.com/fygrave/moloch_zmq) - ZMQ data explort plugin for Moloch
* [fmahnke/orxCraft](https://github.com/fmahnke/orxCraft) - Experimental data configuration editor for the Orx/Scroll game engine. C++
* [federicomenaquintero/evolution-data-server](https://github.com/federicomenaquintero/evolution-data-server) - Full history of evolution-data-server
* [elvismt/slope](https://github.com/elvismt/slope) - A library to create charts from raw data using cairo. Can be shown in GtkDrawingArea
* [eeertekin/bbcp](https://github.com/eeertekin/bbcp) - Securely and quickly copy data from source to target.
* [edussx/database](https://github.com/edussx/database) - B+tree database
* [easydatawarehousing/easy2oracle](https://github.com/easydatawarehousing/easy2oracle) - Easy-To-Oracle is a data integration tool. It can pull data from databases like Microsoft SQL Server, MySQL, Sybase, SQLite, Presto (Hadoop) and Excel directly into your Oracle 10g/11g/12c database
* [eam/libcrange](https://github.com/eam/libcrange) - Range parsing library for managing sets of hostnames, ips, clusters, roles and other operational data.
* [dolaameng/pysax](https://github.com/dolaameng/pysax) - python implementation of SAX (Symbolic Aggregate Approximation) for time series data
* [deactivated/collectd-write-zmq](https://github.com/deactivated/collectd-write-zmq) - a collectd plugin that writes data via zeromq
* [darkstalker/dbc_browser](https://github.com/darkstalker/dbc_browser) - quick and dirty web DBC browser for WoW spell data
* [chergert/egg-fmt](https://github.com/chergert/egg-fmt) - stdout formatting of data in csv, shell tables, etc
* [chadjoan/sleep-waffle](https://github.com/chadjoan/sleep-waffle) - A reimplementation of the Zeo Raw Data Library with less restrictive (Boost) licensing and written in C with a non-threaded polling-event model.  And a silly name.
* [calvinwilliams/tcpdaemon](https://github.com/calvinwilliams/tcpdaemon) - Tcpdaemon is similar to the xinetd TCP daemon, which is under the particular process model of TCP connection management, docking with the customer communication data protocol layer and application processing module on runtime or compile linking, construct TCP server quickly.
* [caius/fio](https://github.com/caius/fio) - Mirror of git://brick.kernel.dk/data/git/fio.git
* [bryansum/ijam](https://github.com/bryansum/ijam) - A collaborative music application for the iPhone utilizing Pure Data.
* [bl0b/tinyap](https://github.com/bl0b/tinyap) - One build to parse them all. A GLR-like parsing engine where the grammar is actually data. And you can augment the grammar at runtime. Also provides a framework to walk the resulting ASTs. C API and commandline frontend available.
* [bigclean/structure](https://github.com/bigclean/structure) - Several languages of data structure practice
* [beave/nfdump-1.6.10p1-sagan](https://github.com/beave/nfdump-1.6.10p1-sagan) - Modified version of Nfdump which allows Sagan to analyze netflow data in real time
* [atduskgreg/Head-Puppet](https://github.com/atduskgreg/Head-Puppet) - Open Frameworks app for distorting a 3D model of my head based on Kinect skeleton tracking data over OSC
* [arnimarj/py-pointless](https://github.com/arnimarj/py-pointless) - A fast and efficient read-only relocatable data structure for JSON like data, with C and Python APIs
* [armink/EasyDataManager](https://github.com/armink/EasyDataManager) - A c language advanced framework of data manager. Support static data and dynamic data. Supply easy and simple interface for app.
* [alexbirkett/GPSBabel](https://github.com/alexbirkett/GPSBabel) - Free software for GPS data conversion and transfer
* [alandekok/recli](https://github.com/alandekok/recli) - A re-imagined CLI.  Customizable syntax, help, permissions, data types.
* [ZhengYang/dc_fdw](https://github.com/ZhengYang/dc_fdw) - PostgreSQL - Document Collection Foreign-data Wrapper (works with 9.1 to 9.3)
* [NDN-Routing/NLSR0.0](https://github.com/NDN-Routing/NLSR0.0) - Named Data Link State Routing
* [LeechanX/data_struct_and_algorithms_using_C](https://github.com/LeechanX/data_struct_and_algorithms_using_C) - 所有基础数据结构和算法的纯C语言实现，如各自排序、链表、栈、队列、各种树以及应用、图算法、字符串匹配算法、回溯、并查集等，献丑了
* [Krakonos/cutils](https://github.com/Krakonos/cutils) - C utilities and data structures
* [Kevincav/Radix-Sort](https://github.com/Kevincav/Radix-Sort) - Radix Sort with different data types.
* [CAIDA/corsaro](https://github.com/CAIDA/corsaro) - Corsaro is a software suite for performing large-scale analysis of trace data. It was specifically designed to be used with passive traces captured by darknets, but the overall structure is generic enough to be used with any type of passive trace data.
* [BuildItNow/BIN_LuaBind](https://github.com/BuildItNow/BIN_LuaBind) - BIN_LuaBind是一个和luabind、tolua++类似的库，提供了简洁的C/C++到lua的绑定机制，但与之不同的是BIN_LuaBind比他们更安全：lua层不在直接依赖于C/C++层指针，避免野指针引起宕机。除此之外，BIN_LuaBind对Lua提供了对lua_state,user data和table的抽象类，在C++端能方便的操作lua
* [BlackLight/fkmeans](https://github.com/BlackLight/fkmeans) - A tiny library in C for managing kmeans clusterization algorithm over arbitrary data sets, both by manually specifying the number k of clusters and computing it automatically using Schwarz criterion
* [BlackBears/CCFNumberPickerView](https://github.com/BlackBears/CCFNumberPickerView) - A scaled, slick slider-type view for numerical data entry on iOS devices
* [Akira-Hayasaka/ofxOnsetDetection](https://github.com/Akira-Hayasaka/ofxOnsetDetection) - Audio onset detection addon using ofSoundGetSpectrum (or any frequency-domain data. e.g. FFT on the input audio)
* [AaronJackson/sage-in-c](https://github.com/AaronJackson/sage-in-c) - Simple library written in C for accessing invoices and company data created by Sage Accounts 50.
* [zhi1ong/bms-da](https://github.com/zhi1ong/bms-da) - Data acquisition by arduino (upload sensor data)
* [yuya-takeyama/hashtable_dump](https://github.com/yuya-takeyama/hashtable_dump) - A Zend Extension to dump HashTable data structure on Zend Engine.
* [yurovsky/swo-tracer](https://github.com/yurovsky/swo-tracer) - ARM SWO trace data listener/parser
* [yarikoptic/NiPy-OLD](https://github.com/yarikoptic/NiPy-OLD) - Analysis of structural and functional neuroimaging data in Python (yet not stabilized -- fork on your risk)
* [xianhuawei/datax](https://github.com/xianhuawei/datax) - http://code.taobao.org/p/datax/wiki/index/
* [webglearth/gdaldem_web](https://github.com/webglearth/gdaldem_web) - Utility for encoding elevation data (DEM) for use on the web (with WebGL Earth). Elevation value is encoded into RGB.
* [vi/chaoticfs](https://github.com/vi/chaoticfs) - Encrypting FUSE filesystem with "false bottom" allowing exposing the data only partially
* [vhmth/Lego-Box](https://github.com/vhmth/Lego-Box) - Write up all the data structures!
* [verzhak/sfire](https://github.com/verzhak/sfire) - Quantum GIS plugin for mapping of burnt forest areas using Landsat 5 data sets
* [v92/libiorouter](https://github.com/v92/libiorouter) - libiorouter is LD_PRELOAD library for caching data and metadata requests from backend directory to local directory transparently to application.
* [ubixum/UXN1212_firmware](https://github.com/ubixum/UXN1212_firmware) - Firmware for the Ubixum UXN1212 USB data acquisition board
* [tyler-cromwell/Data-structs](https://github.com/tyler-cromwell/Data-structs) - A collection of Data Structures that I have implemented to make the construction of some of my other programs/projects easier
* [tokuhirom/shirokaned](https://github.com/tokuhirom/shirokaned) - simple cache server for small binary data, feed contents with http protocol, master-master support.
* [tianyaqu/mongodb-in-financial-market](https://github.com/tianyaqu/mongodb-in-financial-market) - mongodb solution for financial market data
* [theKeithD/thmj3g-tools](https://github.com/theKeithD/thmj3g-tools) - Collection of tools to unpack and repack data used by the D.N.A.Softwares doujin game, Touhou Unreal Mahjong 3rd Generation.
* [tedluo/rs485](https://github.com/tedluo/rs485) - This is a simple drive for rs485 to translate data between two arm 6410 openboard
* [teamBICYCLE/libdatac](https://github.com/teamBICYCLE/libdatac) - a collection of data library
* [tailhook/objpath](https://github.com/tailhook/objpath) - A library that allows to traverse data structures by path
* [tai/ruby-p-for-c](https://github.com/tai/ruby-p-for-c) - Data dumper macro for C, which dumps content of any data/structure/expression without prior knowledge of actual format. Works just like "p" or "pp" in Ruby.
* [svanderburg/libamivideo](https://github.com/svanderburg/libamivideo) - Conversion library for Amiga planar graphics data and EHB, HAM screen modes
* [strands-project/data_compression](https://github.com/strands-project/data_compression) - Video encoding for 8 bit RGB images, 16 bit grayscale depth images and possibly more.
* [starnight/simple-data-structure](https://github.com/starnight/simple-data-structure) - Simple Data Structure library
* [ssfrr/HearThereOSC](https://github.com/ssfrr/HearThereOSC) - A small program to receive some IMU orientation data from the HearThere Head Tracker
* [slim-curve/slim-curve](https://github.com/slim-curve/slim-curve) - SLIM Curve: a package for exponential curve fitting of combined spectral lifetime image data
* [shuLhan/vos](https://github.com/shuLhan/vos) - Vos is a program to process formatted data, i.e. CSV data. Vos is designed to process a large input file, a file where their size is larger than the size of memory, and can be tuned to adapt with your machine environment.
* [semmerson/NOAAPORT](https://github.com/semmerson/NOAAPORT) - The Unidata NOAAPORT package captures broadcast UDP packets from a DVB-S or DVB-S2 receiver listening to the NOAAPORT satellite broadcast, creates data-products from the UDP packets, and inserts those data-products into an LDM product-queue.
* [scytulip/nrf51-back-rec](https://github.com/scytulip/nrf51-back-rec) - NRF51822 Firmware for Background Data Recording
* [samdeane/xcode-unicode-formatter](https://github.com/samdeane/xcode-unicode-formatter) - Xcode data view plugin for formatting 16-bit and 32-bit unicode strings
* [redBorder/n2kafka](https://github.com/redBorder/n2kafka) - Tool that listen on a given port and throw all data received to a kafka topic
* [rdub/smallfile](https://github.com/rdub/smallfile) - Security tool to create a large number of small (FS blocksize or less) files full of random data, in an effort to sanitize filesystem freespace and journal.
* [rajatkhanduja/Benchmarks](https://github.com/rajatkhanduja/Benchmarks) - Some programs to test the performance of two (or more) methods to achieve the same thing. It could be two (or more) data structures or two (or more) algorithms to solve the same problem
* [rainkid/dataserv](https://github.com/rainkid/dataserv) - dataserv
* [qris/iptables](https://github.com/qris/iptables) - Modified iptables binary for firewall data gathering via JSON
* [pkmital/pkmColorBlobTracker](https://github.com/pkmital/pkmColorBlobTracker) - track overhead using color and map tracked points to a new geometry using a homography transformation and calibration routine - some example test videos are provided in the bin/data directory of an overhead capture.  The tracking transformation is useful for when you need a defined metric space of your tracking parameters, or need to account for different user heights in tracking their paths in a space.
* [pi8027/libdatastruct](https://github.com/pi8027/libdatastruct) - libdatastruct is an ANSI C library for abstract data types.
* [php/pecl-database-pdo_user](https://github.com/php/pecl-database-pdo_user) - Userspace driver for PDO
* [pcdavid/data-structures](https://github.com/pcdavid/data-structures) - Sample implementations of classical data structures in C.
* [paulreimer/ofxWebUI-poco](https://github.com/paulreimer/ofxWebUI-poco) - A jquery-mobile web page which generates HTML5 form controls (from a protobuf-gwt generated description file) for exchanging protocol buffer-encoded data with an openFrameworks app.
* [olofsj/Whichway](https://github.com/olofsj/Whichway) - C library for flexible (bike, foot, car) routing in road networks from Openstreetmap data.
* [olofsj/GLMap](https://github.com/olofsj/GLMap) - An OpenGL ES 2.0 renderer for Openstreetmap data
* [odus/odus](https://github.com/odus/odus) - ODUS, a PHP module to improve performance/data size of serialization/unserialization.
* [noporpoise/madcrowlib](https://github.com/noporpoise/madcrowlib) - Common C data structure macros
* [nohbdy/libtorchlight2](https://github.com/nohbdy/libtorchlight2) - Library and tools for extracting data from the PAK archives used in the game 'Torchlight 2'
* [nightscout/cgm-pebble-splitscreen](https://github.com/nightscout/cgm-pebble-splitscreen) - Pebble app to view data from two nightscout servers .
* [nicknassar/cosby](https://github.com/nicknassar/cosby) - A TI99/4a data cassette interface software modem and practical example of signal processing with the infamous FFT
* [nashvail/Data-Structures](https://github.com/nashvail/Data-Structures) - Includes implementation of common data structures along with specific algorithmic operations.
* [n1ckfg/recKinect](https://github.com/n1ckfg/recKinect) - Utility for recording raw Kinect data; much faster than Processing but binary output must be remapped
* [msettles/rSFFreader](https://github.com/msettles/rSFFreader) - R packages for flow gram based sequence data Roche 454 and Ion Torrent
* [mrnugget/data_structures](https://github.com/mrnugget/data_structures) - Implementations of common data structures in C
* [mmadry/st-hmp](https://github.com/mmadry/st-hmp) - Implementation of the Spatio-Temporal Hierarchical Matching Pursuit (ST-HMP) descriptor presented in the paper: M. Madry, L. Bo, D. Kragic, D. Fox, "ST-HMP: Unsupervised Spatio-Temporal Feature Learning for Tactile Data". In ICRA, 2014 (Download: http://www.nada.kth.se/~madry/publications/madry2014ICRA.pdf).
* [mlongob/Linux-Kernel-Hack](https://github.com/mlongob/Linux-Kernel-Hack) - Minimal Hacks to the Linux Kernel to gather data about machine utilization
* [mlin/ocaml-bgzf](https://github.com/mlin/ocaml-bgzf) - OCaml library for BGZF, a gunzip-compatible format allowing random access to the uncompressed data
* [mklong/libngx](https://github.com/mklong/libngx) - static library about nginx core data structure include array,buf,hash,list,queue ,tree,string and memory pool
* [mist64/pucrunch](https://github.com/mist64/pucrunch) - pucrunch, an Optimizing Hybrid LZ77 RLE Data Compression Program for C64/C128/VIC-20/Plus4
* [mikelhernaez/qvz](https://github.com/mikelhernaez/qvz) - A Lossy compressor for Quality Scores in Genomic Data
* [mgp/redis-types](https://github.com/mgp/redis-types) - Library of the Redis data types
* [mchochlov/Gnucash](https://github.com/mchochlov/Gnucash) - Data model unit testing - GSoC 2011
* [mbrazeau/Morphy](https://github.com/mbrazeau/Morphy) - Phylogenetic analysis of morphological data
* [mbornet-hl/hl](https://github.com/mbornet-hl/hl) - Highlight (colorize) text data using regular expressions
* [mattlgroff/TWRP2.5_F2FS_QCOM](https://github.com/mattlgroff/TWRP2.5_F2FS_QCOM) - TWRP2.5 android_bootable_recovery for Moto X, Qualcomm based with F2FS filesystem for /data/
* [mattjr/structured](https://github.com/mattjr/structured) - Tools for the Generation and Visualization of Large-scale Three-dimensional Reconstructions from Image Data.
* [mattbornski/cdf](https://github.com/mattbornski/cdf) - A Python package which handles files in NASA Common Data Format
* [makefu/skytraq-datalogger](https://github.com/makefu/skytraq-datalogger) - configuration and download tool for GPS data loggers based on Skytraq Venus 5 and 6 chipsets
* [lyda/tz](https://github.com/lyda/tz) - Historical archive of the zoneinfo project.  Generated from the original data with the tz-history-scripts.
* [ljmocic/PJISP](https://github.com/ljmocic/PJISP) - Programming Languages and Data Structures
* [liuluheng/levmu](https://github.com/liuluheng/levmu) - Based on redis protocol, storing data in leveldb, using muduo for communication
* [liuliu/ndqi](https://github.com/liuliu/ndqi) - Non-structural Data Query Interface
* [libertyernie/goombasav](https://github.com/libertyernie/goombasav) - Extract/replace Game Boy SRAM data stored in Goomba/Goomba Color SRAM
* [leecarraher/CardinalityShiftClustering](https://github.com/leecarraher/CardinalityShiftClustering) - MOVED -- https://github.com/wilseypa/rphash -- Ongoing research into communication minimizing parallel data clustering for an LSH accelerated random projection mean-shift algorithm.
* [kronihias/smpte-](https://github.com/kronihias/smpte-) - Pure Data/Max (flext) external for generating or decoding ltc audio timecode.
* [kevinbirch/kanabo](https://github.com/kevinbirch/kanabo) - query JSON/YAML data with JSONPath
* [jvirtanen/dada](https://github.com/jvirtanen/dada) - Generate tabular text data
* [jvimal/perfiso_10g](https://github.com/jvimal/perfiso_10g) - Network Performance Isolation for Data Centres.   WIP: stay tuned!
* [jtramm/GraphMC](https://github.com/jtramm/GraphMC) - An OpenMC statepoint file reader and data visualization suite
* [jsvennevid/filearchive](https://github.com/jsvennevid/filearchive) - File archive library allowing for easy creation and access to data stored inside a container through a simple API.
* [jpmens/mqtt-chronos](https://github.com/jpmens/mqtt-chronos) - Periodically submit time/date-related data to an MQTT broker
* [jenswilly/AVR-enc28j60-pachube](https://github.com/jenswilly/AVR-enc28j60-pachube) - AVR Libc-based project for ATmega328/-168 sending data to Pachube using an ENC28J60 with the Tuxgraphics TCP library.
* [irvined1982/loguino](https://github.com/irvined1982/loguino) - Logiuno, an arduino based data aquisition tool
* [hroptatyr/gandalf](https://github.com/hroptatyr/gandalf) - serve time series from rolled-out text data, part of the army of unserding services
* [hp09d/SAE-Baja-Data-Acquisition](https://github.com/hp09d/SAE-Baja-Data-Acquisition) - Senior Design project year 2014-2015
* [hoxnox/rawsock_recv_example](https://github.com/hoxnox/rawsock_recv_example) - SOCK_RAW IPPROTO_UDP socket data transmission example
* [horchi/linux-p4d](https://github.com/horchi/linux-p4d) - Deamon which fetch sensor data of the 'Lambdatronic s3200' and store to a MySQL database
* [heimir-sverrisson/jdbc2_fdw](https://github.com/heimir-sverrisson/jdbc2_fdw) - JDBC Foreign Data Wrapper for PostgreSQL
* [harnold/generic-c](https://github.com/harnold/generic-c) - A library of generic data structures and algorithms for C, in the spirit of the STL
* [haf/System.Data.SQLite](https://github.com/haf/System.Data.SQLite) - A mirror to the official https://system.data.sqlite.org site which uses Fossil for their SCM, and configured to be buildable on mono.
* [hacatu/haclib](https://github.com/hacatu/haclib) - A utility library providing data types C should have been made with such as vectors and sequences, mostly as macros.
* [grundprinzip/bitcompressedvector](https://github.com/grundprinzip/bitcompressedvector) - Provide a container for integral data types that applies light-weight bit compression
* [gleicon/leveldb_engine](https://github.com/gleicon/leveldb_engine) - memcached leveldb engine - stores data on leveldb
* [ggounot/BnfData](https://github.com/ggounot/BnfData) - Android Application: Auteurs et œuvres
* [ggobi/ggobi](https://github.com/ggobi/ggobi) - High dimensional data vis
* [fritz0705/libf](https://github.com/fritz0705/libf) - Library to make programming simpler and cleaner (and slower, because I was too lazy to implement usable data structures)
* [freels/ruby_trie](https://github.com/freels/ruby_trie) - Native C implementation of a trie data structure.
* [foldedtoad/PebblePointer](https://github.com/foldedtoad/PebblePointer) - Sending Pebble Watch accelerometer data to an Android app -- See wiki
* [fictorial/logstore](https://github.com/fictorial/logstore) - experimental data storage engine for arbitrary data for POSIX systems with spinning hard disks
* [farsightsec/dnstable](https://github.com/farsightsec/dnstable) - encoding format, library, and utilities for passive DNS data
* [esheldon/meds](https://github.com/esheldon/meds) - Python and C libraries to work with Multi Epoch Data Structures
* [eos-org/datastructures](https://github.com/eos-org/datastructures) - PHP extensions for classes supporting common datastructures
* [energinet/datalogger-client](https://github.com/energinet/datalogger-client) - Energinet Datalogger
* [elliotwoods/ARDrone-GStreamer-test](https://github.com/elliotwoods/ARDrone-GStreamer-test) - Test of reading video data from ARDrone using GStreamer (cross-platform code, win32 project)
* [einsteinx2/libSub](https://github.com/einsteinx2/libSub) - Internal library used by iSub, encapsulates the data model and audio engine. Licensed under the GPL3.
* [draco2003/freebsd-database-riak](https://github.com/draco2003/freebsd-database-riak) - FreeBSD port for riak support
* [domoran/DriveDOORS](https://github.com/domoran/DriveDOORS) - An efficient data Interface to IBM Rational DOORS
* [debrouxl/tilp-linkguide](https://github.com/debrouxl/tilp-linkguide) - TILP (formerly GtkTiLink) can transfer data between Texas Instruments scientific calculators and a computer. It works with all link cables (parallel, serial, Black/Gray/Silver/Direct Link) and it supports the TI-Z80 series (73..86), the TI-68k series (89, 92+, V200, 89T) and the Nspire series (Nspire Clickpad / Touchpad / CX, both CAS and non-CAS)
* [czarrar/cwas-paper](https://github.com/czarrar/cwas-paper) - Scripts to analyze data and generate figures for the CWAS paper
* [corks/corc.ds](https://github.com/corks/corc.ds) - A data structure library written in C.
* [codinghead/nmea-module](https://github.com/codinghead/nmea-module) - Module to enable decoding of NMEA data from GPS receivers.
* [chutsu/cog](https://github.com/chutsu/cog) - C common library containing common data structures, sorting algorithms and utility functions
* [chenlonggang/Adaptive-CSA](https://github.com/chenlonggang/Adaptive-CSA) - Adaptive CSA, is data-aware,can select the best coding-method for each block
* [cdkamat/hammerspace](https://github.com/cdkamat/hammerspace) - Senior Year (BE Computer Engg.) Undergraduate project - Data Deduplication for the TUX 3 Linux File System
* [caomaocao/micro-camera](https://github.com/caomaocao/micro-camera) - The mircocamera driven by a STM32 chip and its PC client. The microcamera captures a photo and then converts it to JPEG or BMP formet.     Finally , the camera sent image  data to PC by 485 serial-ports
* [bruceg/sqldjbdns](https://github.com/bruceg/sqldjbdns) - An authoritative DNS server that pulls its data directly from a set of SQL tables
* [brandenburg/sched-trace-tools](https://github.com/brandenburg/sched-trace-tools) - Some tools for working with LITMUS^RT sched_trace data.
* [bpudream/pat](https://github.com/bpudream/pat) - Data Structure (中国大学MOOC-陈越、何钦铭-数据结构)
* [borland667/btier](https://github.com/borland667/btier) - Btier is a tiered storage that automatically moves frequently accessible data to fast(er) device.
* [blitz/xplot](https://github.com/blitz/xplot) - Plot tcptrace data
* [blacksmithlabs/NetworkRecorder](https://github.com/blacksmithlabs/NetworkRecorder) - An app to record targeted network traffic data of other apps using iptables.
* [bgamari/data-logger](https://github.com/bgamari/data-logger) - An autonomous data logging firmware for the MC HCK development board
* [bendmorris/pybioclim](https://github.com/bendmorris/pybioclim) - A Python interface to BIOCLIM climate data. Data files included in package.
* [barankurtulusozan/Algorithms-and-Data-Structures](https://github.com/barankurtulusozan/Algorithms-and-Data-Structures) - Introduction To Algorithms and Data Structures
* [baiwei0427/XPath](https://github.com/baiwei0427/XPath) - Explicit Path Control in Commodity Data Centers
* [baina/biyifei](https://github.com/baina/biyifei) - The general flight data cloud acceleration system design
* [avilleret/laser_drawer](https://github.com/avilleret/laser_drawer) - laser_driver is a pure-data patch to control a Laser projector with a sound card
* [atmatthewat/mdc-encode-decode](https://github.com/atmatthewat/mdc-encode-decode) - Software modem for a specific data burst format
* [atduskgreg/Leg-Visualization](https://github.com/atduskgreg/Leg-Visualization) - OF app to visualize leg movement data from Biomechanics and Motor Control of Human Movement by David A. Winter
* [aspotton/xonotic-data-patches](https://github.com/aspotton/xonotic-data-patches) - A clone of xonotic-data plus additional branches
* [aseveryn/NLPIR-2013](https://github.com/aseveryn/NLPIR-2013) - Source code and data used in the NLPIR course (Sprint, 2013)
* [as0ler/iphone-dataprotection](https://github.com/as0ler/iphone-dataprotection) - Some useful tools for a iOS Forensics.
* [andrewstone/AbqData](https://github.com/andrewstone/AbqData) - Tools to read ABQ Open Data Initiative city gov data
* [alessio9008/PLC-to-STM32F4-communication-through-PC-as-gateway](https://github.com/alessio9008/PLC-to-STM32F4-communication-through-PC-as-gateway) - This project has been made using the STM32F4 accelerometer and a Siemens S7-300 unit. The microcontroller is programmed to send data to a PC by using a serial-port communication; these data are read from a C# program that forward them to the PLC memory. Then, the PLC unit, that recognizes the microcontroller position, moves a mechanical arm.
* [aimxhaisse/des](https://github.com/aimxhaisse/des) - C implementation of Data Encryption Standard
* [ai-ku/scode](https://github.com/ai-ku/scode) - Sphere embedding (s-code) is a variation of Euclidean embedding of co-occurence data (code).
* [adnanozsoy/CUDA_Compression](https://github.com/adnanozsoy/CUDA_Compression) - A GPU-based LZSS compression algorithm, highly tuned for NVIDIA GPGPUs and for streaming data, leveraging the respective strengths of CPUs and GPUs together.
* [adenine/ofxFFT_to_OSC](https://github.com/adenine/ofxFFT_to_OSC) - This is an app which uses ofxFFT to then send out OSC data relating to the music being interpreted.
* [a4tunado/mll](https://github.com/a4tunado/mll) - Library used for studying machine learning course at Yandex Data Analysis School.
* [Whiteknight/ParrotStore](https://github.com/Whiteknight/ParrotStore) - Storage and data persistance for Parrot VM
* [UniversalPrimer/flv-analyzer](https://github.com/UniversalPrimer/flv-analyzer) - Loads an FLV file into sane C data structures and outputs fields as human readable
* [TauLabs/overo-datalogger](https://github.com/TauLabs/overo-datalogger) - The code that runs on the Overo to provide a datalogger
* [Tarsnap/kivaloo](https://github.com/Tarsnap/kivaloo) - Kivaloo is a collection of utilities which together form a data store associating keys of up to 255 bytes with values of up to 255 bytes.
* [Suor/postgresql-json](https://github.com/Suor/postgresql-json) - Extract data from PostgreSQL JSON fields.
* [SabinT/ffmpeg-rgb-video](https://github.com/SabinT/ffmpeg-rgb-video) - A simple utility that makes it straightforward to create videos from raw RGB data. No need to learn the details of ffmpeg.
* [RNCryptor/RNCryptor-C](https://github.com/RNCryptor/RNCryptor-C) - C implementation of Rob Napier's RNCryptor data format specification
* [Piro77/arib2ass](https://github.com/Piro77/arib2ass) - arib caption data to ass subtilte file
* [Novax/chan_datacard-huawei-e150](https://github.com/Novax/chan_datacard-huawei-e150) - Patch chan_datacard
* [NarrativeTeam/exifyay](https://github.com/NarrativeTeam/exifyay) - Python module for reading and writing Exif data, backed by time-tested C libraries.
* [NCrashed/bzip2](https://github.com/NCrashed/bzip2) - Bindings for bzip2 library, a freely available, patent free, high-quality data compressor.
* [LongSoft/AddrInfo](https://github.com/LongSoft/AddrInfo) - Utility to find addresses of different data structures in ASUS BIOS image files and to store them in INI-formated file
* [Lajnold/falloc](https://github.com/Lajnold/falloc) - falloc creates files of a user-specified size. It uses the posix_fallocate syscall for allocating the right size directly, instead of copying data like the commonly used dd tool does (which, in my opinion, feels like a hack).
* [Katharine/httpebble-counter-demo](https://github.com/Katharine/httpebble-counter-demo) - Trivial demo of httpebble's persistent data capabilities
* [IvanMalison/grid](https://github.com/IvanMalison/grid) - A distributed system that allows users to submit executables and data to a compute cluster.  Can withstand multiple failures without losing data.
* [Incarnation-p-lee/libds](https://github.com/Incarnation-p-lee/libds) - unified data structure implementation lib of C
* [GNOME/evolution-data-server](https://github.com/GNOME/evolution-data-server) - evolution-data-server
* [ErikDubbelboer/c-pack](https://github.com/ErikDubbelboer/c-pack) - Simple data packing/unpacking in C
* [EdisonChendi/data_structure](https://github.com/EdisonChendi/data_structure) - 打好基础吧少年
* [Bob--Lee/P-Trie-Bloom-Filter](https://github.com/Bob--Lee/P-Trie-Bloom-Filter) - It's a way to solve a big data problem with P-Trie and Bloom-Filter
* [AdysTech/raspy-weather](https://github.com/AdysTech/raspy-weather) - A set of C libraries to gather Temperature and Humidity data from generic DHT11 sensor, store it in a round-robin database and show it in a PHP page.
* [AbsoluteTiger/krproject](https://github.com/AbsoluteTiger/krproject) - a real-time streaming data analysis system.
* [zwdzwd/biscuit](https://github.com/zwdzwd/biscuit) - a little tool for bisulfite data
* [zammitjames/dataparksearch](https://github.com/zammitjames/dataparksearch) - Full featured web search engine
* [yuriks/SHView](https://github.com/yuriks/SHView) - Spherical Harmonics data viewer
* [yurial/tread](https://github.com/yurial/tread) - read file, exit at no data when timed out
* [youngsterxyf/Data-Structures-and-Algorithms](https://github.com/youngsterxyf/Data-Structures-and-Algorithms) - simple implementation of some data structures and algorithms
* [yl790/algorithms-and-data-structures](https://github.com/yl790/algorithms-and-data-structures) - for future reference
* [yixuan/fdaplus](https://github.com/yixuan/fdaplus) - Enhancement of the 'fda' package for functional data analysis
* [yaderbh/dstruct](https://github.com/yaderbh/dstruct) - An object oriented implementation of data structures for PHP
* [xyjax/sdd2json](https://github.com/xyjax/sdd2json) - EVE static data dump to JSON exporter
* [xwang149/Dsim](https://github.com/xwang149/Dsim) - Data transfer simulator
* [xurenlu/ngx_mem_backend_module](https://github.com/xurenlu/ngx_mem_backend_module) - simple nginx module to fetch data from memcached and echo data;
* [xeniaqian94/Reliable-Data-Transfer-3.0-Protocol-Networking](https://github.com/xeniaqian94/Reliable-Data-Transfer-3.0-Protocol-Networking) - Project of COMP 3234, Computer and Communication Networks
* [xavier-chen/simplep2p](https://github.com/xavier-chen/simplep2p) - Test NAT Traversal after using pjnath to see if we can send data to peer
* [xant/XML-TinyXML](https://github.com/xant/XML-TinyXML) - minimal perl-xs module to handle XML data
* [wtangiit/awesim](https://github.com/wtangiit/awesim) - event-driven simulator for data aware distributed workflow system
* [wizzard/libtprint](https://github.com/wizzard/libtprint) - TPrint is a simple C library to print ASCII tabular data.
* [wilseypa/odroidNetworking](https://github.com/wilseypa/odroidNetworking) - Data/code/notes relating to our studies with low latency networking and big.LITTLE task assignment on the odroid platform
* [wikrsh/hello_fdw](https://github.com/wikrsh/hello_fdw) - Hello world program for PostgreSQL's foreign data wrapper(FDW)
* [wasabiz/xrope](https://github.com/wasabiz/xrope) - rope data structure
* [vvv/under.c](https://github.com/vvv/under.c) - DER data decoder/encoder
* [vpereira/pcapreader](https://github.com/vpereira/pcapreader) - saving pcap data on mongodb//tests with and without capped collections
* [voola/play](https://github.com/voola/play) - Play back plain text data over a network (e.g. stock data)
* [vmayoral/freeDDS](https://github.com/vmayoral/freeDDS) - An open source Data Distribution Service (DDS) for embedded devices implemented for ROS
* [vdrolia/speed_hash](https://github.com/vdrolia/speed_hash) - Hash a lot of data as fast as you can
* [uranushiko/Yeelink](https://github.com/uranushiko/Yeelink) - My project used to send data to Yeelink.
* [twogood/dynamite](https://github.com/twogood/dynamite) - PKWARE Data Compression decompressor tool and library
* [tristanheaven/asteroids](https://github.com/tristanheaven/asteroids) - Asteroid taxonomic classification using light curve data
* [traviskaufman/MaxCurl](https://github.com/traviskaufman/MaxCurl) - Data retrieval client for MaxMSP
* [tomxue/spi](https://github.com/tomxue/spi) - to show to make SPI data transfer under Linux
* [todace/G-CVSNT](https://github.com/todace/G-CVSNT) - G-CVSNT Gaijin (and Gamedev) CVSNT version - modified for large amounts of binary data (typically for gamedev)
* [tnightingale/DTE](https://github.com/tnightingale/DTE) - Dumb Terminal Emulator - Data Comm, COMP 3980
* [tiancaiamao/datastruct](https://github.com/tiancaiamao/datastruct) - some useful data struct piece of code
* [tbeu/ExternData](https://github.com/tbeu/ExternData) - :page_facing_up: Modelica library for reading data from INI, JSON, XML and Excel XLS files
* [tallsam/DAFWAWeatherWatch](https://github.com/tallsam/DAFWAWeatherWatch) - Pebble watch face using dafwa weather api data.
* [suzukiplan/Touhou-VGS-MML-data](https://github.com/suzukiplan/Touhou-VGS-MML-data) - 東方BGM on VGSのMMLデータ公開＆サポート用のレポジトリです
* [sunny256/xz](https://github.com/sunny256/xz) - XZ Utils provide a general-purpose data compression library and command line tools.
* [stellarscience/xdm](https://github.com/stellarscience/xdm) - An Extensible Data Model
* [srijs/udp-stats-redis-adapter](https://github.com/srijs/udp-stats-redis-adapter) - Small performant frontend to redis, receiving minimal statistics data via udp messaging.
* [smtlaissezfaire/c_type_sizes](https://github.com/smtlaissezfaire/c_type_sizes) - show the sizes of C data types
* [shtrom/xkeyboard-config](https://github.com/shtrom/xkeyboard-config) - Mirror of FreeDesktop.org's XKB data with local branches
* [shiziwen/nagios-status2txt](https://github.com/shiziwen/nagios-status2txt) - nagios enhancement to get service data as plain text
* [seth/rdict](https://github.com/seth/rdict) - R dictionary data type
* [seth/crio](https://github.com/seth/crio) - Prototype R package providing C-level utils for streaming data processing
* [scottellis/snapx](https://github.com/scottellis/snapx) - Stream data from a v4l2 camera and periodically save image. Testing app.
* [scallopedllama/nerorip](https://github.com/scallopedllama/nerorip) - Rips data out of nero archives
* [ryandotsmith/queue_lkls](https://github.com/ryandotsmith/queue_lkls) - A lock-free, non-blocking queue data structure.
* [rubenspessoa/LocData-P1](https://github.com/rubenspessoa/LocData-P1) - Projeto de Programação 1.
* [rgantt/compsci.c](https://github.com/rgantt/compsci.c) - data structures, algorithms, and musings in C
* [rahpaere/dc](https://github.com/rahpaere/dc) - Power grid data collector.
* [radarsat1/plhm](https://github.com/radarsat1/plhm) - A library and command-line front-end for acquiring data from Polhemus motion tracking devices.
* [r03ert0/CoactivationMap.app](https://github.com/r03ert0/CoactivationMap.app) - Interactive viewer for the Brain Coactivation Map data
* [questor/ringbuffer](https://github.com/questor/ringbuffer) - simple ringbuffer with possibility to get all data and/or only updates
* [qubodup/freedink-data](https://github.com/qubodup/freedink-data) - freedink-data sound additions. see http://www.freedink.org/ (not my project)
* [qiq/Czech-morphology](https://github.com/qiq/Czech-morphology) - Czech morphology library, using data files compatible with PDT 2.0
* [q3k/gm_datapack](https://github.com/q3k/gm_datapack) - A binary Lua module for Garry's Mod to tell when a datapack is created.
* [plashchynski/str2hex](https://github.com/plashchynski/str2hex) - Data formats convertion utility
* [pkieltyka/stash](https://github.com/pkieltyka/stash) - Steganography application that hides data within a bitmap image
* [pgmreddy/datastructures](https://github.com/pgmreddy/datastructures) - Arrays started
* [perfaram/xLine](https://github.com/perfaram/xLine) - Getting OSX hardware data/params through command line
* [pcostesi/c-data-structures](https://github.com/pcostesi/c-data-structures) - Simple Data Structures
* [orangejulius/cs_fundamentals](https://github.com/orangejulius/cs_fundamentals) - simple implementations of common data structures/algorithms
* [opencb/hpg-variant](https://github.com/opencb/hpg-variant) - A complete suite of tools to work with genomic variation data, from VCF tools to variant profiling or genomic statistics
* [openantz/antz](https://github.com/openantz/antz) - immersive data visualization
* [olso4539/HSDMPi](https://github.com/olso4539/HSDMPi) - High Speed Data Monitor for Raspberry Pi
* [ngwese/AF_MacTypeUtil](https://github.com/ngwese/AF_MacTypeUtil) - Utility functions for interacting with Mac OS X Carbon data types.
* [neiljpeterson/Data-Structures-II-Assignments-COSC-3100](https://github.com/neiljpeterson/Data-Structures-II-Assignments-COSC-3100) - Just a repo for me to share homework with classmates. Nothing interesting here.
* [natehardison/data-structures](https://github.com/natehardison/data-structures) - A bunch of data structure implementations, just for fun.
* [naraing/dsLib](https://github.com/naraing/dsLib) - An algorithm library with core data-sttructures and common algortihm implementations on those data structures
* [napsy/libhelper](https://github.com/napsy/libhelper) - General functions and data structures for C
* [mstiehr-dev/data_dedup](https://github.com/mstiehr-dev/data_dedup) - designed to store a lot of (likely redundant) data for backup purpose. Restore specific files as well.
* [mrkn/ruby-odbc](https://github.com/mrkn/ruby-odbc) - Extension library to use ODBC data sources from Ruby.
* [moc-/datastructure](https://github.com/moc-/datastructure) - exercise of datastructure
* [mnacos/pg51g](https://github.com/mnacos/pg51g) - a data diff toolkit for PostgreSQL
* [minusinf/opengl_dataviewer](https://github.com/minusinf/opengl_dataviewer) - A simple OpenGL xyzw dataviewer
* [mgalloy/ridl](https://github.com/mgalloy/ridl) - Really Interactive Data Language
* [mcxiaoke/dsaac](https://github.com/mcxiaoke/dsaac) - Learn Data Structures and Algorithm Analysis in C
* [mclap/tdsproxy](https://github.com/mclap/tdsproxy) - tabular data stream (TDS) proxy server
* [madnoda/stm32f4-glcd-logger](https://github.com/madnoda/stm32f4-glcd-logger) - Data Logger with LCD
* [lp/pdtest](https://github.com/lp/pdtest) - Pure Data testing external
* [ljianhui/Data-Structure](https://github.com/ljianhui/Data-Structure) - 这个库的内容大多为数据结构及其具体实现代码，还包含一些基本的算法！
* [livioso/datastructures-in-C](https://github.com/livioso/datastructures-in-C) - Implementation of a some data structures in C for educational purposes. For example featuring a trie implementation in C (inspired by DAS84 "a bit of C") or a XOR linked list.
* [lip6-lisp/data-plane](https://github.com/lip6-lisp/data-plane) - OpenLISP data plane
* [lidaof/methylQA](https://github.com/lidaof/methylQA) - methylation sequence data quality assessment tool
* [lbrito1/cstuff](https://github.com/lbrito1/cstuff) - Algorithms & data structures in C
* [kurtisthompson/Algorithms](https://github.com/kurtisthompson/Algorithms) - Random assortment of Interesting data structures and/or algorithms and academic work
* [krutin/psoc_data_acquisition](https://github.com/krutin/psoc_data_acquisition) - Data Acquisition using usbuart of Cypress PSoC. Developed using Tinychip Axios 1.0
* [kronihias/dbap](https://github.com/kronihias/dbap) - Distance Based Amplitude Panning externals for Pure Data
* [kinect-team-3/unifying-sensor-api](https://github.com/kinect-team-3/unifying-sensor-api) - Sensor API for data transport
* [kehribar/usbSerial_benchmark](https://github.com/kehribar/usbSerial_benchmark) - Usb serial data transfer speed calculator & integrity checker
* [kbranigan/tubes](https://github.com/kbranigan/tubes) - A series of programs intended for manipulating and handling various data
* [kaitanie/ruby-cernlib](https://github.com/kaitanie/ruby-cernlib) - Ruby interface to the legacy CERNLIB data analysis libraries
* [jrudolph/java-direct-data-store](https://github.com/jrudolph/java-direct-data-store) - An experiment to dump Java objects into a memory-mapped data store accessible without (de)serialization
* [jrd730/WordFinder](https://github.com/jrd730/WordFinder) - a data structure that specializes in rapidly finding valid anagrams of strings
* [jpmens/powerdns-datacheck](https://github.com/jpmens/powerdns-datacheck) - MySQL UDF to check data in PowerDNS tables
* [joshdk/libmap](https://github.com/joshdk/libmap) - A map (data structure) library written in c
* [jknotzke/GoldenEmbedGPS](https://github.com/jknotzke/GoldenEmbedGPS) - Embedded Firmware for the Sparkfun Package Tracker which will log ANT+ data
* [jdp/ephemeron](https://github.com/jdp/ephemeron) - where transient data makes itself useful
* [jbenjore/Internals-GraphArenas](https://github.com/jbenjore/Internals-GraphArenas) - Chart a map of where perl locates data
* [jbenjore/Clone-Data](https://github.com/jbenjore/Clone-Data) - Simple and fast data cloning
* [jb55/hearthstone-cardxml](https://github.com/jb55/hearthstone-cardxml) - Hearthstone xml card data extractor
* [jasonmaclafferty/String](https://github.com/jasonmaclafferty/String) - A dynamic string data type implementation for C.
* [jarun/dslib](https://github.com/jarun/dslib) - A library of handy data structures
* [jaimz/core_ds](https://github.com/jaimz/core_ds) - Simple C data structure library
* [isti757/DataNetwork](https://github.com/isti757/DataNetwork) - Data network project. This was a project at Saarland University of the Course Data Networks. The project implements some ideas of OSI protocol stack. The code runs using the CNET network simulator  (http://www.csse.uwa.edu.au/cnet/), however the project is easily separable and can run on real networks as well.  Please see the design folder for tex file and generate a pdf with the entire desciption of the project.  The project is written in C and is portable.
* [io7m/coreland-lua-ada-load](https://github.com/io7m/coreland-lua-ada-load) - Load data from Lua into Ada data structures
* [imankulov/wav2rtp](https://github.com/imankulov/wav2rtp) - wav2rtp is a simple tool intended to convert speech data from wav files to RTP data stream
* [igorsobreira/iclib](https://github.com/igorsobreira/iclib) - Library with useful C data structures
* [ifsnop/reader_network](https://github.com/ifsnop/reader_network) - A package of utilities to record and work with multicast radar data in ASTERIX format. (radar as in air navigation surveillance).
* [iem-projects/pd-iemrtp](https://github.com/iem-projects/pd-iemrtp) - RTP support for Pure Data
* [hyPiRion/persistencia](https://github.com/hyPiRion/persistencia) - Repository with implementations to understand persistent data structures.
* [huzelin/etdb](https://github.com/huzelin/etdb) - etdb is an in-memory database that persists on disk, The data model is key-value, but range query is supported on keys and many different kind of values are supported: set list hashtable sptial-data
* [hpc/dtcmp](https://github.com/hpc/dtcmp) - Datatype Compare (DTCMP) Library for sorting and ranking distributed data using MPI
* [hdevalence/wordgen](https://github.com/hdevalence/wordgen) - let's play with google ngrams data
* [happypeter/tata](https://github.com/happypeter/tata) - tinylion data
* [hach-que/configd](https://github.com/hach-que/configd) - Generates configuration files in /etc based on YAML data and XSLT transformations.
* [h5md/VMD-h5mdplugin](https://github.com/h5md/VMD-h5mdplugin) - This plugin enables VMD to display data stored in h5 files that are structured according to the H5MD specifications (http://nongnu.org/h5md/)
* [guodong/dbd](https://github.com/guodong/dbd) - Distributed block device, used for cloud computing environment or big data storage base.
* [grizzlin/sylvanas](https://github.com/grizzlin/sylvanas) - Data Aggregation Girl.
* [gogotanc/DataStructures](https://github.com/gogotanc/DataStructures) - Data Structures and Algorithm Analysis in C
* [fw42/nfportscan](https://github.com/fw42/nfportscan) - Tool for analyzing Cisco netflow data in order to automatically detect portscans
* [fubarwrangler/datastruct](https://github.com/fubarwrangler/datastruct) - A silly project to code some data structures to help brush up on my C
* [franko/regress-pro](https://github.com/franko/regress-pro) - Spectroscopic Ellipsometry and Reflectometry data analysis
* [flightcrank/ratio-boost](https://github.com/flightcrank/ratio-boost) - This program spoofs or fakes the amount of data torrent clients report to private torrent trackers in order to maintain a good ratio of data uploads to downloads, which they require.
* [ext/datapack](https://github.com/ext/datapack) - Testing compression and storage of data inside executable
* [exosite-garage/arduino_http_post](https://github.com/exosite-garage/arduino_http_post) - Demo of Arduino hardware sending data to the cloud.  It is a simple web based monitoring example for Arduino - really easy to put values captured by Arduino online .
* [energinet/datalogger-server](https://github.com/energinet/datalogger-server) - rpserver.cgi
* [dtb/algorithms-and-data-structures](https://github.com/dtb/algorithms-and-data-structures) - Wherein I fill in the gaps in my programming knowledge
* [dpryan79/MethIndelRealigner](https://github.com/dpryan79/MethIndelRealigner) - A local realigner around InDels for MethylSeq data
* [dpfau/quagga](https://github.com/dpfau/quagga) - Library for automated ROI extraction from calcium imaging data
* [douzzer/megaqueue](https://github.com/douzzer/megaqueue) - lightweight high performance streaming data kernel
* [dhbikoff/Generic-C-Library](https://github.com/dhbikoff/Generic-C-Library) - A library of generic data structures in C
* [dgvncsz0f/lift](https://github.com/dgvncsz0f/lift) - Implementation of some data structures in C
* [dewoods/greenplum-json-formatter](https://github.com/dewoods/greenplum-json-formatter) - Greenplum extension for reading and writing JSON data
* [deepwater82/bismark_data_transmit](https://github.com/deepwater82/bismark_data_transmit) - data transmit using cURL
* [dasuxullebt/tddp](https://github.com/dasuxullebt/tddp) - Trivial Data Deduplication
* [darksideofthemoo/redis-histogram](https://github.com/darksideofthemoo/redis-histogram) - Histogram data type for redis
* [cstavish/c_data_structs](https://github.com/cstavish/c_data_structs) - singly/doubly linked list and hash table implementations...more to come
* [conch/disco](https://github.com/conch/disco) - Automatic perspective DIStortion COrrection using accelerometer data
* [coins11/data-structures-and-algorithms](https://github.com/coins11/data-structures-and-algorithms) - Data Structures and Algorithms
* [coderaven/B-Tree](https://github.com/coderaven/B-Tree) - B-Tree Implementation in C. A project in Data Structures.
* [codeprepper/data-structures](https://github.com/codeprepper/data-structures) - arrays, linked lists, stacks and queues
* [cni/pdr](https://github.com/cni/pdr) - CNI Peripheral Data Reader (PDR)
* [clibs/dumpasn1](https://github.com/clibs/dumpasn1) - Display the contents of ASN.1 encoded data
* [clarkds/Benchmark-Results](https://github.com/clarkds/Benchmark-Results) - this is benchmarking data for arm cortex A8 and A9's
* [citiususc/BigBWA](https://github.com/citiususc/BigBWA) - Approaching the Burrows-Wheeler Aligner to Big Data Technologies
* [chronomex/1600bpi-tape](https://github.com/chronomex/1600bpi-tape) - Tool to recover data from analog recordings of 1970s data tape
* [chneukirchen/rs](https://github.com/chneukirchen/rs) - rs(1) — reshape a data array (from OpenBSD)
* [chmduquesne/xmppipe](https://github.com/chmduquesne/xmppipe) - This program allows to pipe data through an xmpp tunnel
* [chenkovsky/ngram](https://github.com/chenkovsky/ngram) - efficient data structure for storing ngram.
* [cengek/CKDatastruct](https://github.com/cengek/CKDatastruct) - The using of data structure in C from our class
* [bingmann/disk-filltest](https://github.com/bingmann/disk-filltest) - Simple program to detect bad disks by filling them with random data.
* [beave/barnyard2-extra](https://github.com/beave/barnyard2-extra) - Barnyard2 with "Extra Data" support and other enhancements.
* [bcmpinc/dagdb](https://github.com/bcmpinc/dagdb) - small database for storing semi-structured data
* [baupetit/VisuScaterredData](https://github.com/baupetit/VisuScaterredData) - projet de visualisation
* [ashinkarov/trie](https://github.com/ashinkarov/trie) - Simple implementation of trie data structure in C
* [asadzia/Algorithms-and-Data-Structures](https://github.com/asadzia/Algorithms-and-Data-Structures) - A list of implementations of various algorithms and data structures.
* [anjos/arithmetic_coding](https://github.com/anjos/arithmetic_coding) - Library to perform arithmetic coding and decoding of text or binary data
* [angelortega/mpdm](https://github.com/angelortega/mpdm) - Minimum Profit Data Manager
* [anatoo/cons](https://github.com/anatoo/cons) - This PHP Extension import cons cell data structure from scheme.
* [amaurigabriel/CAD](https://github.com/amaurigabriel/CAD) -  C Algorithms and Data-structures
* [alonbl/pkcs11-data](https://github.com/alonbl/pkcs11-data) - PKCS#11 data object manipulator
* [alibashir/pacmonstr](https://github.com/alibashir/pacmonstr) - Tandem Repeat Detection for Long Read Sequence Data
* [alexanderb14/cCollections](https://github.com/alexanderb14/cCollections) - lightweight dynamic data structures for C
* [alawrence/c_LibExifModule](https://github.com/alawrence/c_LibExifModule) - C++ framework module that wraps libexif to pull out EXIF data.
* [aaronstanton/sualft](https://github.com/aaronstanton/sualft) - reconstruction of irregularly sampled seismic data using the Anti-Leakage Fourier Transform (ALFT)
* [a3linux/nagios-amq-perf](https://github.com/a3linux/nagios-amq-perf) - Nagiso fork patched to support post performance data to ActiveMQ
* [YaroslavLitvinov/Distributed-Sort](https://github.com/YaroslavLitvinov/Distributed-Sort) - Sort data in several processes simultaneously and using zeromq for interprocess communications.
* [Xsoda/struct](https://github.com/Xsoda/struct) - pack and unpack packet data like python struct module.
* [WeatherGod/BWx](https://github.com/WeatherGod/BWx) - Assorted utilities for dealing with weather related data
* [UECIDE/UECIDE_data](https://github.com/UECIDE/UECIDE_data) - Cores, boards and compilers for UECIDE
* [Treevs/algs-and-data-structures](https://github.com/Treevs/algs-and-data-structures) - I need practice in C, algorithms, and data structures, so why not kills 3 birds with one stone?
* [TravisWhitaker/FermiShell](https://github.com/TravisWhitaker/FermiShell) - Retrieve, compare, calculate, analyze, graph, simulate, and experiment with chemical data.
* [Teyras/flowly](https://github.com/Teyras/flowly) - An sFlow data analyzer focused on realtime processing
* [TerryC78/CMU_15213_DataLab](https://github.com/TerryC78/CMU_15213_DataLab) - CMU 15-213 Introduction to Computer Systems
* [Soryusan/Ranking_Algorithm](https://github.com/Soryusan/Ranking_Algorithm) - Ranking algorithm data collector/cruncher
* [Shouqun/geolocation](https://github.com/Shouqun/geolocation) - A python API for get geo location with current WiFi AP data
* [ShabbyX/shDS](https://github.com/ShabbyX/shDS) - Common Data Structures for C
* [RicardoCorralC/rccPyDataLondon2015](https://github.com/RicardoCorralC/rccPyDataLondon2015) - rccPyDataLondon2015
* [OpenSecurityResearch/iclass_dump](https://github.com/OpenSecurityResearch/iclass_dump) - Tools to pull data from HID iClass readers
* [MattNolanLab/Ramsden_MEC](https://github.com/MattNolanLab/Ramsden_MEC) - Registration pipeline for Allen Brain Atlas data
* [MagerValp/AsmHeap](https://github.com/MagerValp/AsmHeap) - Heap data structure in 6502 assembler
* [JulienPalard/Mine](https://github.com/JulienPalard/Mine) - Little data miner
* [JohnDMcMaster/uvscada](https://github.com/JohnDMcMaster/uvscada) - UVNet data acquisition (DAQ).  For doing process control or other monitoring.
* [Jahor/osm-tools](https://github.com/Jahor/osm-tools) - Tools to operate OpenStreetMap data
* [HapCoderWei/DataStructure](https://github.com/HapCoderWei/DataStructure) - 我自己写的数据结构与算法练习程序, 仅做备忘
* [GuillaumeHolley/BloomFilterTrie](https://github.com/GuillaumeHolley/BloomFilterTrie) - A data structure for pan-genome storage
* [FoxelSA/libfastcal](https://github.com/FoxelSA/libfastcal) - Fast calibration data access
* [FedoraScientific/scientific_spin_tests](https://github.com/FedoraScientific/scientific_spin_tests) - Test scripts and data for Fedora Scientific Spin
* [ClickerMonkey/CDSL](https://github.com/ClickerMonkey/CDSL) - A data structure library written in C
* [Akash91/CoSQL](https://github.com/Akash91/CoSQL) - A Co-Relational Key-Value Data Store
* [Achoulos/Data-Structures](https://github.com/Achoulos/Data-Structures) - Implementation of Data Structures and Sorts in C
* [2ndQuadrant/pglog](https://github.com/2ndQuadrant/pglog) - PostgreSQL logger foreign data wrapper
* [2ion/libqueue](https://github.com/2ion/libqueue) - C library providing persistent, named data storage queues
* [2hanson/DecisionTree](https://github.com/2hanson/DecisionTree) - Data Mining
* [20centaurifux/datatypes](https://github.com/20centaurifux/datatypes) - A collection of various datatypes in C (linked lists, stack, queue, red-black tree and hash table).
* [imatix/zguide](https://github.com/imatix/zguide) - Learning and Using ØMQ
* [D-Programming-Language/dmd](https://github.com/D-Programming-Language/dmd) - dmd D Programming Language compiler
* [clowwindy/ChinaDNS](https://github.com/clowwindy/ChinaDNS) - Protect yourself against DNS poisoning in China.
* [tatsuhiro-t/nghttp2](https://github.com/tatsuhiro-t/nghttp2) - nghttp2 - HTTP/2 C Library
* [Chris911/iStats](https://github.com/Chris911/iStats) - Ruby gem for your mac stats
* [holmium/dnsforwarder](https://github.com/holmium/dnsforwarder) - A dnsforwarder designed for anti-spoofing
* [code-mancers/rbkit](https://github.com/code-mancers/rbkit) - A new profiler for Ruby. With a GUI
* [sektioneins/SUIDGuard](https://github.com/sektioneins/SUIDGuard) - SUIDGuard - a TrustedBSD Kernel Extension that adds mitigations to protect SUID/SGID processes a bit more
* [HandBrake/HandBrake](https://github.com/HandBrake/HandBrake) - Readonly Mirror of the offical HandBrake svn repository.
* [pangweiwei/slua](https://github.com/pangweiwei/slua) - Fastest Unity lua binding via static code generating.
* [moai/moai-beta](https://github.com/moai/moai-beta) - WARNING: This repository has been deprecated. Please update and submit all pull requests to moai-dev
* [comex/substitute](https://github.com/comex/substitute) - A free runtime modification library.
* [alexbw/Netflix-Prize](https://github.com/alexbw/Netflix-Prize) - The code I used to get in the top #150 in the Netflix Prize
* [xelerance/Openswan](https://github.com/xelerance/Openswan) - Openswan
* [cloudflare/keyless](https://github.com/cloudflare/keyless) - CloudFlare's Keyless SSL Server Reference Implementation
* [vurtun/gui](https://github.com/vurtun/gui) - A lightweight ANSI C imgui toolkit
* [tilgovi/couchdb-lounge](https://github.com/tilgovi/couchdb-lounge) - The Lounge is a proxy-based partitioning/clustering framework for CouchDB
* [atheme/charybdis](https://github.com/atheme/charybdis) - an extremely scalable ircd with some cooperation with the ratbox and ircu guys
* [hanzz/libtransport](https://github.com/hanzz/libtransport) - Create C++ transports easily
* [andymcd/cmd-key-happy](https://github.com/andymcd/cmd-key-happy) - Swap cmd and alt keys in Terminal
* [cuckoobox/cuckoomon](https://github.com/cuckoobox/cuckoomon) - Cuckoo Sandbox Monitor Component
* [fjz13/Cocos2d-x-ParticleEditor-for-Windows](https://github.com/fjz13/Cocos2d-x-ParticleEditor-for-Windows) - A FREE WINDOWS cocos2d particle editor Upgraded to Cocos2dx 2.12，and support saving texture into plist。  Welcome any suggestions,or join me.  Jack Fu(傅建钊） fjz13@live.cn QQ:2722937652  http://weibo.com/u/1847201447
* [openj/core](https://github.com/openj/core) - there are failing tests.  please find any bugs you may have introduced, fix and submit.
* [mbeddr/mbeddr.core](https://github.com/mbeddr/mbeddr.core) - The mbeddr core. An extensible C
* [jaredly/codetalker](https://github.com/jaredly/codetalker) - A succinct, pythonic parser + translator solution
* [couchbase/libcouchbase](https://github.com/couchbase/libcouchbase) - The couchbase client for C.
* [kanoi/cgminer-binaries](https://github.com/kanoi/cgminer-binaries) - cgminer binary downloads for AntMiner, Fedora 18 x86_64, RPi ARM_32, Xubuntu 11.04 x86_64
* [project-imas/security-check](https://github.com/project-imas/security-check) - Application level, attached debug detect and jailbreak checking
* [eweitnauer/minstreamer](https://github.com/eweitnauer/minstreamer) - Simple audio (n to n) and video (1 to n) streaming in C using libgstreamer.
* [jangaraj/Zabbix-Docker-Monitoring](https://github.com/jangaraj/Zabbix-Docker-Monitoring) - :whale: Monitoring of Docker containers (LXC/systemd Docker supported) - Zabbix template and Zabbix C module
* [carlj/CJAMacros](https://github.com/carlj/CJAMacros) - Macro collection for daily usage
* [LinkLayer/cantact-fw](https://github.com/LinkLayer/cantact-fw) - Firmware source files for the CANtact tool
* [CertiVox/MIRACL](https://github.com/CertiVox/MIRACL) - MIRACL Cryptographic SDK: Multiprecision Integer and Rational Arithmetic Cryptographic Library is a C software library that is widely regarded by developers as the gold standard open source SDK for elliptic curve cryptography (ECC).
* [defuse/crackstation-hashdb](https://github.com/defuse/crackstation-hashdb) - CrackStation.net's Lookup Table Implementation.
* [amitdev/lru-dict](https://github.com/amitdev/lru-dict) - A C extension of a python dict-like LRU container.
* [shantzu/ClipIt](https://github.com/shantzu/ClipIt) - ClipIt clipboard manager for GTK+
* [telehash/telehash-c](https://github.com/telehash/telehash-c) - telehash tools library in c
* [brianmario/bzip2-ruby](https://github.com/brianmario/bzip2-ruby) - Original libbz2 ruby C bindings from Guy Decoux, with some new love
* [karelia/CurlHandle](https://github.com/karelia/CurlHandle) - Cocoa Class wrapping libcurl
* [kavu/cocoa-go](https://github.com/kavu/cocoa-go) - A simple PoC example of calling Go from Cocoa and vice versa.
* [asynclabs/WiShield_user_contrib](https://github.com/asynclabs/WiShield_user_contrib) - WiShield library with user contributed features
* [okws/sfslite](https://github.com/okws/sfslite) - SFSlite C++ development libraries
* [conformal/cyphertite](https://github.com/conformal/cyphertite) - A high-security scalable solution for online backups.
* [algernon/libmongo-client](https://github.com/algernon/libmongo-client) - An obsolete library. Don't use it in new projects.
* [KFire-Android/kernel_omap_otter-common](https://github.com/KFire-Android/kernel_omap_otter-common) - TI Kernel Code - Amazon Kindle Fire (otter)
* [pozorvlak/libtap](https://github.com/pozorvlak/libtap) - Testing library for C, implementing the Test Anything Protocol. Written by Nik Clayton.
* [matianfu/FUNK](https://github.com/matianfu/FUNK) - a c continuation library inspired by Adam Dunkel's ProtoThread.
* [lubyk/lubyk](https://github.com/lubyk/lubyk) - Open source patcher for multimedia projects: glue all this midi, DMX, neural networks, opengl stuff into a fast C++ core with Lua scriptable objects.
* [lawrancej/CompilerKit](https://github.com/lawrancej/CompilerKit) - Compiler construction library in C.
* [dajobe/flickcurl](https://github.com/dajobe/flickcurl) - Flickr C API library
* [zeevt/csnappy](https://github.com/zeevt/csnappy) - Google snappy in C for Linux Kernel
* [mirek/CoreSQLite3](https://github.com/mirek/CoreSQLite3) - Core SQLite3 for iOS and OSX. Fast. Clean. Powerful...
* [matteobertozzi/blog-code](https://github.com/matteobertozzi/blog-code) - Blog Code
* [kmcallister/embedded-breakpoints](https://github.com/kmcallister/embedded-breakpoints) - Embed GDB breakpoints in C source code
* [dougbradbury/cslim](https://github.com/dougbradbury/cslim) - Fitnesse Slim implementation in C
* [diwu/CCB-X-Reader](https://github.com/diwu/CCB-X-Reader) - This C++ class helps processing CocosBuilder(ccb) files for your Cocos2d-X project.
* [cybergarage/mupnpc](https://github.com/cybergarage/mupnpc) - mUPnP for C is a development package for UPnP™ developers. CyberLink controls these protocols automatically, and supports to create your devices and control points quickly.
* [crocodella/MongooseWrapper](https://github.com/crocodella/MongooseWrapper) - An Objective-C Mongoose wrapper emulating Java servlets
* [TOTBWF/SteamCurses](https://github.com/TOTBWF/SteamCurses) - A Basic NCurses Client for Steam
* [LippiOuYang/WebBench](https://github.com/LippiOuYang/WebBench) - Webbench是一个在linux下使用的非常简单的网站压测工具。它使用fork()模拟多个客户端同时访问我们设定的URL，测试网站在压力下工作的性能，最多可以模拟3万个并发连接去测试网站的负载能力。Webbench使用C语言编写, 代码实在太简洁，源码加起来不到600行。
* [iafonov/cosmonaut](https://github.com/iafonov/cosmonaut) - Fast web server & micro framework implemented in C. Just for fun.
* [evanmiller/ProjCL](https://github.com/evanmiller/ProjCL) - Crazy-fast map projections and geodesic calculations
* [C0deH4cker/SimpleGameEngine](https://github.com/C0deH4cker/SimpleGameEngine) - Simple C++ game engine influenced by XNA
* [timperrett/Mac-SoapClient](https://github.com/timperrett/Mac-SoapClient) - 10.7 Compatible version of this: http://code.google.com/p/mac-soapclient/
* [rothlab/chromozoom](https://github.com/rothlab/chromozoom) - ChromoZoom is a fast, fluid web-based genome browser
* [robrix/RXPreprocessing](https://github.com/robrix/RXPreprocessing) - A variety of utilities for the C preprocessor.
* [oneoo/alilua-coevent-module](https://github.com/oneoo/alilua-coevent-module) - epoll base coroutine module
* [lkarsten/libvmod-cookie](https://github.com/lkarsten/libvmod-cookie) - A Varnish module for simpler use of the cookie header.
* [fusijie/Airplane_3.0](https://github.com/fusijie/Airplane_3.0) - Wechat Airplane C++ version, powered by Cocos2d-x 3.0 stable version.
* [cvmfs/cvmfs](https://github.com/cvmfs/cvmfs) - The CernVM File System
* [b4n/ctags](https://github.com/b4n/ctags) - Git mirror of Exuberant CTags SVN (http://ctags.sourceforge.net/), with additional feature branches
* [Zeex/samp-plugin-crashdetect](https://github.com/Zeex/samp-plugin-crashdetect) - CrashDetect plugin for SA-MP server
* [ThomasHabets/monotonic_clock](https://github.com/ThomasHabets/monotonic_clock) - Portable C library for getting monotonic time
* [BrunoAlexandreMendesMartins/CleverModels](https://github.com/BrunoAlexandreMendesMartins/CleverModels) - Tool to generate POJO´s Model Classes from JSON Feed structures
* [Akagi201/learning-cmake](https://github.com/Akagi201/learning-cmake) - learning cmake
* [tglman/orientdb-c](https://github.com/tglman/orientdb-c) - The C client of  OrientDB
* [septag/darkhammer](https://github.com/septag/darkhammer) - darkHAMMER is a lightweight, open-source, multiplatform game engine. written in C (C99) language, supports python and C# bindings and lua scripts. Runs on windows and linux
* [olibc/olibc](https://github.com/olibc/olibc) - Another C Library optimized for Embedded Linux
* [jmcejuela/Levenshtein-MySQL-UDF](https://github.com/jmcejuela/Levenshtein-MySQL-UDF) - General Levenshtein algorithm and k-bounded levenshtein distance in linear time and constant space. Implementation in C as a MySQL UDF
* [jashmenn/apriori](https://github.com/jashmenn/apriori) - A ruby/c extension to Christian Borgelt's apriori item-set implementation
* [itod/panthro](https://github.com/itod/panthro) - A implementation of XPath 3.0 in Objective-C/Cocoa
* [evanmiller/nginx_circle_gif](https://github.com/evanmiller/nginx_circle_gif) - Serve 68,000 round corners per second
* [drvink/epanos](https://github.com/drvink/epanos) - ElectroPaint Automatic No-source Object reaSsembler (a MIPS to C decompiler)
* [akitaonrails/ObjC_Rubyfication](https://github.com/akitaonrails/ObjC_Rubyfication) - Attempt to make Objective-C more like Ruby
* [aerospike/aerospike-client-c](https://github.com/aerospike/aerospike-client-c) - Aerospike C Client
* [Chronic-Dev/cyanide](https://github.com/Chronic-Dev/cyanide) - iBoot/iBSS Payload Development Toolkit
* [wbhart/comb](https://github.com/wbhart/comb) - Combinators in C
* [roysjosh/xbee-comm](https://github.com/roysjosh/xbee-comm) - XBee communication libraries and utilities
* [remicollet/pecl-json-c](https://github.com/remicollet/pecl-json-c) - JSON-C wrapper
* [olajep/rpi-cecd](https://github.com/olajep/rpi-cecd) - Temporary remote control HDMI-CEC hack for OpenElec on Raspberry Pi
* [microbuilder/LPC11U_LPC13U_CodeBase](https://github.com/microbuilder/LPC11U_LPC13U_CodeBase) - Open source code base for ARM Cortex M3 LPC1347 or Cortex M0 LPC11U37/LPC11U24 MCUs
* [graphitemaster/gmqcc](https://github.com/graphitemaster/gmqcc) - An Improved Quake C Compiler
* [freshplanet/ANE-Chartboost](https://github.com/freshplanet/ANE-Chartboost) - Air Native Extension for Chartboost (iOS + Android)
* [felipec/msn-pecan](https://github.com/felipec/msn-pecan) - MSN Messenger library in C
* [dcreager/libpush](https://github.com/dcreager/libpush) - An arrow-based parser combinator library for C
* [cocos2d/cocos2d-frame](https://github.com/cocos2d/cocos2d-frame) - Player and "stub" for cocos2d
* [akissa/php-couchdb](https://github.com/akissa/php-couchdb) - PHP extension for CouchDB
* [WoozleWrangler/ControlPad](https://github.com/WoozleWrangler/ControlPad) - iPhone Controller app for SNES (HD)
* [xaionaro/clsync](https://github.com/xaionaro/clsync) - file live sync daemon based on inotify/kqueue/bsm (Linux, FreeBSD), written in GNU C
* [kazuho/picogc](https://github.com/kazuho/picogc) - a tiny, portable, precise, mark-and-sweep GC in C++
* [jwerle/fs.c](https://github.com/jwerle/fs.c) - File system API much like Node's fs module
* [ibc/em-udns](https://github.com/ibc/em-udns) - An async DNS resolver for EventMachine based on udns C library
* [gbishop/cython-hidapi](https://github.com/gbishop/cython-hidapi) - Python wrapper for the hidapi (not active, use one of the forks)
* [gallir/concurrencia_source_samples](https://github.com/gallir/concurrencia_source_samples) - Códigos fuente del libro "Principios y algoritmos de concurrencia"
* [dhoerl/htmlcxx](https://github.com/dhoerl/htmlcxx) - a simple non-validating css1 and html parser written in C++ tuned for iOS and Mac
* [creaceed/CeedMath](https://github.com/creaceed/CeedMath) - Computer graphics math library for Mac & iOS
* [cooperative-computing-lab/cctools](https://github.com/cooperative-computing-lab/cctools) - The Cooperative Computing Tools (cctools) enable large scale distributed computations to harness hundreds to thousands of machines from clusters, clouds, and grids.
* [arrbee/diff-match-patch-c](https://github.com/arrbee/diff-match-patch-c) - C language port of google-diff-match-patch library
* [antelopeusersgroup/antelope_contrib](https://github.com/antelopeusersgroup/antelope_contrib) - Contributed code for the Antelope Environmental Monitoring System from BRTT, Inc. (http://www.brtt.com)
* [ThomasAdam/tmux-cvs-archived](https://github.com/ThomasAdam/tmux-cvs-archived) - Git version of tmux (updated hourly from sourceforge CVS) -- NOW ARCHIVED!  DO NOT USE THIS!
* [ShadauxCat/CATSFC](https://github.com/ShadauxCat/CATSFC) - Super Nintendo/Super Famicom emulator for the DSTWO
* [8devices/carambola2](https://github.com/8devices/carambola2) - Carambola 2 - an AR9331/SoC based PCB
* [vincentbernat/bootstrap.c](https://github.com/vincentbernat/bootstrap.c) - Boilerplate for small C projects (autotools)
* [rentzsch/MagicHat](https://github.com/rentzsch/MagicHat) - Objective-C Binary Documentation Tool. Think classdump with a hyperlinked GUI.
* [rabbitmq/rabbitmq-c](https://github.com/rabbitmq/rabbitmq-c) - The official rabbitmq-c sources have moved to:
* [lincomatic/Colorduino](https://github.com/lincomatic/Colorduino) - Colorduino Interface Library for Arduino
* [libamqp/libamqp](https://github.com/libamqp/libamqp) - libamqp is a C client for the AMQP 1.0 protocol
* [SteveMaddison/cabrio](https://github.com/SteveMaddison/cabrio) - Free open source emulator front end for arcade cabinets.
* [zfsrogue/zfs-crypto](https://github.com/zfsrogue/zfs-crypto) - ZFS On Linux with crypto patches
* [varnish/libvmod-curl](https://github.com/varnish/libvmod-curl) - cURL bindings for Varnish through the Varnish Module interface
* [orangeduck/ptest](https://github.com/orangeduck/ptest) - DRY Microtesting Framework for C
* [ocaml-bytes/ocamlcc](https://github.com/ocaml-bytes/ocamlcc) - OCaml bytecode to C compiler
* [jduck/canhazaxs](https://github.com/jduck/canhazaxs) - A tool for enumerating the access to entries in the file system of an Android device.
* [goj/coreutils](https://github.com/goj/coreutils) - fork of GNU coreutils package
* [fanf2/unifdef](https://github.com/fanf2/unifdef) - selectively remove C preprocessor conditionals
* [fanchy/FFRPC](https://github.com/fanchy/FFRPC) - ffrpc is a C++ lib for encapsulating socket option. it is easy to complete asynchronous communication between different process
* [bkrpub/EngineRoom](https://github.com/bkrpub/EngineRoom) - EngineRoom is a toolkit addressing basic, recurring needs when using C based languages.  The most prominent (and mature) component is LogPoints,  a logging facility designed to provide comfort to developers working on applications of all sizes. EngineRoom is primarily targeted at Objective-C developers on Mac OS X and iOS with some support for C on GNU/Linux and Solaris.
* [bfulgham/WinCairoRequirements](https://github.com/bfulgham/WinCairoRequirements) - Source archive of the build requirements for the WinCairo port of WebKit
* [Voluntarynet/Crypt](https://github.com/Voluntarynet/Crypt) - OSX app for drag and drop encryption
* [CObjectSystem/COS](https://github.com/CObjectSystem/COS) - C Object System
* [tadasv/csv_parser](https://github.com/tadasv/csv_parser) - Callback based (SAX like) CSV Parser for C
* [reeze/php-ext-embed](https://github.com/reeze/php-ext-embed) - Write your PHP extension with C and PHP!
* [pjotrp/biolib](https://github.com/pjotrp/biolib) - BioLib brings together a set of opensource libraries written in C/C++ and makes them available for all Bio* languages
* [pbrady/fastcache](https://github.com/pbrady/fastcache) - C implementation of Python 3 lru_cache
* [openglbook/openglbook.com](https://github.com/openglbook/openglbook.com) - The source code for http://openglbook.com/
* [nitrogenlogic/cliserver](https://github.com/nitrogenlogic/cliserver) - A sample libevent-based network socket server that presents a simple command line interface to multiple connecting clients.
* [mattsta/crcspeed](https://github.com/mattsta/crcspeed) - This make CRC be fast.  Included implementations: CRC-64-Jones and CRC-16-CCITT
* [jakogut/tinyflock](https://github.com/jakogut/tinyflock) - A simple, high-performance, threaded, and interactive flocking demo written in C with GLFW.
* [gparmer/Composite](https://github.com/gparmer/Composite) - A component-based OS
* [epico/libibuspinyin-compat](https://github.com/epico/libibuspinyin-compat) - compatible files for ibus-pinyin and libpinyin integration.
* [dave-andersen/cudapts](https://github.com/dave-andersen/cudapts) - An Nvidia-based miner for the Protoshares (PTS) cryptocurrency
* [clear-code/cutter](https://github.com/clear-code/cutter) - An easy to write and debug unit testing framework for C and C++.
* [bjoernknafla/amp](https://github.com/bjoernknafla/amp) - C portable low-level assemblies for parallelism and threading
* [ansilove/AnsiLove-C](https://github.com/ansilove/AnsiLove-C) - ANSi / ASCII art to PNG converter in C
* [Noirello/PyLDAP](https://github.com/Noirello/PyLDAP) - Python 3.x module for LDAP,  using libldap2 and winldap C libraries.
