/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.ui.image;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.j3d.ui.CapturedImageObserver;

public class JPEGImageObserver
implements CapturedImageObserver {
    private boolean hasFired = false;
    private boolean captureNextFrame = false;
    private String filename;

    public void setCaptureNextFrame() {
        if (this.hasFired) {
            throw new IllegalStateException("Image capture already occurred");
        }
        this.captureNextFrame = true;
    }

    public void setFilename(String string) throws IllegalStateException {
        if (this.hasFired) {
            throw new IllegalStateException("Image capture already occurred");
        }
        this.filename = string;
    }

    public void canvasImageCaptured(BufferedImage bufferedImage) {
        if (this.hasFired || !this.captureNextFrame) {
            return;
        }
        if (this.filename == null) {
            throw new IllegalStateException("The filename is not set");
        }
        try {
            File file = new File(this.filename);
            File file2 = file.getParentFile();
            file2.mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
            JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
            jPEGEncodeParam.setQuality(0.9f, false);
            jPEGImageEncoder.setJPEGEncodeParam(jPEGEncodeParam);
            jPEGImageEncoder.encode(bufferedImage);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("I/O exception writing JPEG image! " + iOException);
            iOException.printStackTrace();
        }
        this.hasFired = true;
    }
}

