/*=========================================================================

  Program:   Visualization Toolkit
  Module:    TestAxesTransformWidget.cxx

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
//
// Test for the vtkImageCroppingRegionsWidget.
//

// First include the required header files for the VTK classes we are using.
#include "vtkActor.h"
#include "vtkCommand.h"
#include "vtkDebugLeaks.h"
#include "vtkExtractVOI.h"
#include "vtkImageActor.h"
#include "vtkImageCroppingRegionsWidget.h"
#include "vtkImageData.h"
#include "vtkImageMapper3D.h"
#include "vtkInteractorStyleTrackballCamera.h"
#include "vtkRegressionTestImage.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkRenderer.h"
#include "vtkSmartPointer.h"
#include "vtkSmartVolumeMapper.h"
#include "vtkTestUtilities.h"
#include "vtkVolume.h"
#include "vtkVolume16Reader.h"
#include "vtkVolumeProperty.h"

const char TestImageCroppingRegionsWidgetLog[] =
"# StreamVersion 1\n"
"EnterEvent 299 65 0 0 0 0 0\n"
"MouseMoveEvent 299 65 0 0 0 0 0\n"
"MouseMoveEvent 294 68 0 0 0 0 0\n"
"MouseMoveEvent 287 72 0 0 0 0 0\n"
"MouseMoveEvent 280 76 0 0 0 0 0\n"
"MouseMoveEvent 274 78 0 0 0 0 0\n"
"MouseMoveEvent 267 81 0 0 0 0 0\n"
"MouseMoveEvent 259 84 0 0 0 0 0\n"
"MouseMoveEvent 251 87 0 0 0 0 0\n"
"MouseMoveEvent 243 90 0 0 0 0 0\n"
"MouseMoveEvent 233 92 0 0 0 0 0\n"
"MouseMoveEvent 225 93 0 0 0 0 0\n"
"MouseMoveEvent 217 94 0 0 0 0 0\n"
"MouseMoveEvent 209 95 0 0 0 0 0\n"
"MouseMoveEvent 203 96 0 0 0 0 0\n"
"MouseMoveEvent 198 96 0 0 0 0 0\n"
"MouseMoveEvent 193 96 0 0 0 0 0\n"
"MouseMoveEvent 188 96 0 0 0 0 0\n"
"MouseMoveEvent 183 96 0 0 0 0 0\n"
"MouseMoveEvent 177 96 0 0 0 0 0\n"
"MouseMoveEvent 171 96 0 0 0 0 0\n"
"MouseMoveEvent 165 96 0 0 0 0 0\n"
"MouseMoveEvent 159 96 0 0 0 0 0\n"
"MouseMoveEvent 154 96 0 0 0 0 0\n"
"MouseMoveEvent 148 96 0 0 0 0 0\n"
"MouseMoveEvent 144 96 0 0 0 0 0\n"
"MouseMoveEvent 141 96 0 0 0 0 0\n"
"MouseMoveEvent 136 96 0 0 0 0 0\n"
"MouseMoveEvent 131 96 0 0 0 0 0\n"
"MouseMoveEvent 125 97 0 0 0 0 0\n"
"MouseMoveEvent 119 98 0 0 0 0 0\n"
"MouseMoveEvent 113 99 0 0 0 0 0\n"
"MouseMoveEvent 106 100 0 0 0 0 0\n"
"MouseMoveEvent 100 101 0 0 0 0 0\n"
"MouseMoveEvent 94 103 0 0 0 0 0\n"
"MouseMoveEvent 89 104 0 0 0 0 0\n"
"MouseMoveEvent 84 106 0 0 0 0 0\n"
"MouseMoveEvent 80 107 0 0 0 0 0\n"
"MouseMoveEvent 76 107 0 0 0 0 0\n"
"MouseMoveEvent 73 107 0 0 0 0 0\n"
"MouseMoveEvent 71 107 0 0 0 0 0\n"
"MouseMoveEvent 70 107 0 0 0 0 0\n"
"MouseMoveEvent 68 107 0 0 0 0 0\n"
"MouseMoveEvent 66 107 0 0 0 0 0\n"
"MouseMoveEvent 63 107 0 0 0 0 0\n"
"MouseMoveEvent 60 107 0 0 0 0 0\n"
"MouseMoveEvent 58 107 0 0 0 0 0\n"
"MouseMoveEvent 55 107 0 0 0 0 0\n"
"MouseMoveEvent 54 108 0 0 0 0 0\n"
"MouseMoveEvent 52 109 0 0 0 0 0\n"
"MouseMoveEvent 51 110 0 0 0 0 0\n"
"MouseMoveEvent 50 111 0 0 0 0 0\n"
"MouseMoveEvent 49 111 0 0 0 0 0\n"
"MouseMoveEvent 48 112 0 0 0 0 0\n"
"MouseMoveEvent 47 114 0 0 0 0 0\n"
"MouseMoveEvent 46 115 0 0 0 0 0\n"
"MouseMoveEvent 46 116 0 0 0 0 0\n"
"MouseMoveEvent 45 118 0 0 0 0 0\n"
"MouseMoveEvent 44 119 0 0 0 0 0\n"
"MouseMoveEvent 44 120 0 0 0 0 0\n"
"MouseMoveEvent 44 122 0 0 0 0 0\n"
"MouseMoveEvent 44 124 0 0 0 0 0\n"
"MouseMoveEvent 44 125 0 0 0 0 0\n"
"MouseMoveEvent 44 127 0 0 0 0 0\n"
"MouseMoveEvent 44 128 0 0 0 0 0\n"
"MouseMoveEvent 44 129 0 0 0 0 0\n"
"MouseMoveEvent 44 130 0 0 0 0 0\n"
"MouseMoveEvent 44 131 0 0 0 0 0\n"
"MouseMoveEvent 44 132 0 0 0 0 0\n"
"MouseMoveEvent 45 131 0 0 0 0 0\n"
"MouseMoveEvent 46 129 0 0 0 0 0\n"
"MouseMoveEvent 46 128 0 0 0 0 0\n"
"MouseMoveEvent 46 126 0 0 0 0 0\n"
"MouseMoveEvent 47 124 0 0 0 0 0\n"
"MouseMoveEvent 47 123 0 0 0 0 0\n"
"MouseMoveEvent 48 121 0 0 0 0 0\n"
"MouseMoveEvent 47 120 0 0 0 0 0\n"
"MouseMoveEvent 46 120 0 0 0 0 0\n"
"MouseMoveEvent 45 121 0 0 0 0 0\n"
"LeftButtonPressEvent 45 121 0 0 0 0 0\n"
"RenderEvent 45 121 0 0 0 0 0\n"
"MouseMoveEvent 45 122 0 0 0 0 0\n"
"RenderEvent 45 122 0 0 0 0 0\n"
"MouseMoveEvent 45 123 0 0 0 0 0\n"
"RenderEvent 45 123 0 0 0 0 0\n"
"MouseMoveEvent 46 125 0 0 0 0 0\n"
"RenderEvent 46 125 0 0 0 0 0\n"
"MouseMoveEvent 47 126 0 0 0 0 0\n"
"RenderEvent 47 126 0 0 0 0 0\n"
"MouseMoveEvent 48 127 0 0 0 0 0\n"
"RenderEvent 48 127 0 0 0 0 0\n"
"MouseMoveEvent 49 129 0 0 0 0 0\n"
"RenderEvent 49 129 0 0 0 0 0\n"
"MouseMoveEvent 50 130 0 0 0 0 0\n"
"RenderEvent 50 130 0 0 0 0 0\n"
"MouseMoveEvent 51 131 0 0 0 0 0\n"
"RenderEvent 51 131 0 0 0 0 0\n"
"MouseMoveEvent 52 132 0 0 0 0 0\n"
"RenderEvent 52 132 0 0 0 0 0\n"
"MouseMoveEvent 53 133 0 0 0 0 0\n"
"RenderEvent 53 133 0 0 0 0 0\n"
"MouseMoveEvent 54 134 0 0 0 0 0\n"
"RenderEvent 54 134 0 0 0 0 0\n"
"MouseMoveEvent 55 135 0 0 0 0 0\n"
"RenderEvent 55 135 0 0 0 0 0\n"
"MouseMoveEvent 56 135 0 0 0 0 0\n"
"RenderEvent 56 135 0 0 0 0 0\n"
"MouseMoveEvent 57 136 0 0 0 0 0\n"
"RenderEvent 57 136 0 0 0 0 0\n"
"MouseMoveEvent 58 137 0 0 0 0 0\n"
"RenderEvent 58 137 0 0 0 0 0\n"
"MouseMoveEvent 59 138 0 0 0 0 0\n"
"RenderEvent 59 138 0 0 0 0 0\n"
"MouseMoveEvent 60 139 0 0 0 0 0\n"
"RenderEvent 60 139 0 0 0 0 0\n"
"MouseMoveEvent 61 141 0 0 0 0 0\n"
"RenderEvent 61 141 0 0 0 0 0\n"
"MouseMoveEvent 62 142 0 0 0 0 0\n"
"RenderEvent 62 142 0 0 0 0 0\n"
"MouseMoveEvent 62 143 0 0 0 0 0\n"
"RenderEvent 62 143 0 0 0 0 0\n"
"MouseMoveEvent 63 144 0 0 0 0 0\n"
"RenderEvent 63 144 0 0 0 0 0\n"
"MouseMoveEvent 64 145 0 0 0 0 0\n"
"RenderEvent 64 145 0 0 0 0 0\n"
"MouseMoveEvent 65 146 0 0 0 0 0\n"
"RenderEvent 65 146 0 0 0 0 0\n"
"MouseMoveEvent 66 148 0 0 0 0 0\n"
"RenderEvent 66 148 0 0 0 0 0\n"
"MouseMoveEvent 67 149 0 0 0 0 0\n"
"RenderEvent 67 149 0 0 0 0 0\n"
"MouseMoveEvent 67 150 0 0 0 0 0\n"
"RenderEvent 67 150 0 0 0 0 0\n"
"MouseMoveEvent 68 151 0 0 0 0 0\n"
"RenderEvent 68 151 0 0 0 0 0\n"
"MouseMoveEvent 69 152 0 0 0 0 0\n"
"RenderEvent 69 152 0 0 0 0 0\n"
"MouseMoveEvent 70 153 0 0 0 0 0\n"
"RenderEvent 70 153 0 0 0 0 0\n"
"MouseMoveEvent 71 154 0 0 0 0 0\n"
"RenderEvent 71 154 0 0 0 0 0\n"
"MouseMoveEvent 72 155 0 0 0 0 0\n"
"RenderEvent 72 155 0 0 0 0 0\n"
"MouseMoveEvent 73 156 0 0 0 0 0\n"
"RenderEvent 73 156 0 0 0 0 0\n"
"MouseMoveEvent 74 157 0 0 0 0 0\n"
"RenderEvent 74 157 0 0 0 0 0\n"
"MouseMoveEvent 75 158 0 0 0 0 0\n"
"RenderEvent 75 158 0 0 0 0 0\n"
"MouseMoveEvent 76 159 0 0 0 0 0\n"
"RenderEvent 76 159 0 0 0 0 0\n"
"MouseMoveEvent 77 160 0 0 0 0 0\n"
"RenderEvent 77 160 0 0 0 0 0\n"
"MouseMoveEvent 78 161 0 0 0 0 0\n"
"RenderEvent 78 161 0 0 0 0 0\n"
"MouseMoveEvent 79 162 0 0 0 0 0\n"
"RenderEvent 79 162 0 0 0 0 0\n"
"MouseMoveEvent 80 163 0 0 0 0 0\n"
"RenderEvent 80 163 0 0 0 0 0\n"
"MouseMoveEvent 81 164 0 0 0 0 0\n"
"RenderEvent 81 164 0 0 0 0 0\n"
"MouseMoveEvent 82 165 0 0 0 0 0\n"
"RenderEvent 82 165 0 0 0 0 0\n"
"MouseMoveEvent 83 166 0 0 0 0 0\n"
"RenderEvent 83 166 0 0 0 0 0\n"
"MouseMoveEvent 84 167 0 0 0 0 0\n"
"RenderEvent 84 167 0 0 0 0 0\n"
"MouseMoveEvent 85 168 0 0 0 0 0\n"
"RenderEvent 85 168 0 0 0 0 0\n"
"MouseMoveEvent 86 169 0 0 0 0 0\n"
"RenderEvent 86 169 0 0 0 0 0\n"
"MouseMoveEvent 86 170 0 0 0 0 0\n"
"RenderEvent 86 170 0 0 0 0 0\n"
"MouseMoveEvent 87 171 0 0 0 0 0\n"
"RenderEvent 87 171 0 0 0 0 0\n"
"MouseMoveEvent 88 172 0 0 0 0 0\n"
"RenderEvent 88 172 0 0 0 0 0\n"
"MouseMoveEvent 89 173 0 0 0 0 0\n"
"RenderEvent 89 173 0 0 0 0 0\n"
"MouseMoveEvent 90 174 0 0 0 0 0\n"
"RenderEvent 90 174 0 0 0 0 0\n"
"MouseMoveEvent 91 175 0 0 0 0 0\n"
"RenderEvent 91 175 0 0 0 0 0\n"
"MouseMoveEvent 92 176 0 0 0 0 0\n"
"RenderEvent 92 176 0 0 0 0 0\n"
"MouseMoveEvent 93 177 0 0 0 0 0\n"
"RenderEvent 93 177 0 0 0 0 0\n"
"MouseMoveEvent 94 177 0 0 0 0 0\n"
"RenderEvent 94 177 0 0 0 0 0\n"
"MouseMoveEvent 95 178 0 0 0 0 0\n"
"RenderEvent 95 178 0 0 0 0 0\n"
"MouseMoveEvent 96 179 0 0 0 0 0\n"
"RenderEvent 96 179 0 0 0 0 0\n"
"MouseMoveEvent 97 180 0 0 0 0 0\n"
"RenderEvent 97 180 0 0 0 0 0\n"
"MouseMoveEvent 98 180 0 0 0 0 0\n"
"RenderEvent 98 180 0 0 0 0 0\n"
"LeftButtonReleaseEvent 98 180 0 0 0 0 0\n"
"RenderEvent 98 180 0 0 0 0 0\n"
"MouseMoveEvent 95 177 0 0 0 0 0\n"
"MouseMoveEvent 94 173 0 0 0 0 0\n"
"MouseMoveEvent 92 170 0 0 0 0 0\n"
"MouseMoveEvent 91 166 0 0 0 0 0\n"
"MouseMoveEvent 89 163 0 0 0 0 0\n"
"MouseMoveEvent 88 159 0 0 0 0 0\n"
"MouseMoveEvent 86 156 0 0 0 0 0\n"
"MouseMoveEvent 83 152 0 0 0 0 0\n"
"MouseMoveEvent 81 149 0 0 0 0 0\n"
"MouseMoveEvent 77 145 0 0 0 0 0\n"
"MouseMoveEvent 75 142 0 0 0 0 0\n"
"MouseMoveEvent 72 139 0 0 0 0 0\n"
"MouseMoveEvent 70 137 0 0 0 0 0\n"
"MouseMoveEvent 68 135 0 0 0 0 0\n"
"MouseMoveEvent 67 134 0 0 0 0 0\n"
"MouseMoveEvent 65 132 0 0 0 0 0\n"
"MouseMoveEvent 63 130 0 0 0 0 0\n"
"MouseMoveEvent 61 128 0 0 0 0 0\n"
"MouseMoveEvent 59 126 0 0 0 0 0\n"
"MouseMoveEvent 55 123 0 0 0 0 0\n"
"MouseMoveEvent 51 121 0 0 0 0 0\n"
"MouseMoveEvent 47 119 0 0 0 0 0\n"
"MouseMoveEvent 42 116 0 0 0 0 0\n"
"MouseMoveEvent 37 113 0 0 0 0 0\n"
"MouseMoveEvent 32 111 0 0 0 0 0\n"
"MouseMoveEvent 28 109 0 0 0 0 0\n"
"MouseMoveEvent 23 107 0 0 0 0 0\n"
"MouseMoveEvent 19 105 0 0 0 0 0\n"
"MouseMoveEvent 17 104 0 0 0 0 0\n"
"MouseMoveEvent 15 102 0 0 0 0 0\n"
"MouseMoveEvent 16 102 0 0 0 0 0\n"
"MouseMoveEvent 17 102 0 0 0 0 0\n"
"MouseMoveEvent 18 102 0 0 0 0 0\n"
"MouseMoveEvent 19 102 0 0 0 0 0\n"
"MouseMoveEvent 20 101 0 0 0 0 0\n"
"MouseMoveEvent 21 101 0 0 0 0 0\n"
"MouseMoveEvent 22 100 0 0 0 0 0\n"
"MouseMoveEvent 23 99 0 0 0 0 0\n"
"MouseMoveEvent 23 98 0 0 0 0 0\n"
"LeftButtonPressEvent 23 98 0 0 0 0 0\n"
"RenderEvent 23 98 0 0 0 0 0\n"
"MouseMoveEvent 24 97 0 0 0 0 0\n"
"MouseMoveEvent 25 97 0 0 0 0 0\n"
"MouseMoveEvent 26 98 0 0 0 0 0\n"
"RenderEvent 26 98 0 0 0 0 0\n"
"MouseMoveEvent 26 99 0 0 0 0 0\n"
"RenderEvent 26 99 0 0 0 0 0\n"
"MouseMoveEvent 29 102 0 0 0 0 0\n"
"RenderEvent 29 102 0 0 0 0 0\n"
"MouseMoveEvent 31 105 0 0 0 0 0\n"
"RenderEvent 31 105 0 0 0 0 0\n"
"MouseMoveEvent 33 108 0 0 0 0 0\n"
"RenderEvent 33 108 0 0 0 0 0\n"
"MouseMoveEvent 34 111 0 0 0 0 0\n"
"RenderEvent 34 111 0 0 0 0 0\n"
"MouseMoveEvent 36 113 0 0 0 0 0\n"
"RenderEvent 36 113 0 0 0 0 0\n"
"MouseMoveEvent 37 115 0 0 0 0 0\n"
"RenderEvent 37 115 0 0 0 0 0\n"
"MouseMoveEvent 38 116 0 0 0 0 0\n"
"RenderEvent 38 116 0 0 0 0 0\n"
"MouseMoveEvent 38 117 0 0 0 0 0\n"
"RenderEvent 38 117 0 0 0 0 0\n"
"MouseMoveEvent 39 119 0 0 0 0 0\n"
"RenderEvent 39 119 0 0 0 0 0\n"
"MouseMoveEvent 40 120 0 0 0 0 0\n"
"RenderEvent 40 120 0 0 0 0 0\n"
"MouseMoveEvent 40 121 0 0 0 0 0\n"
"RenderEvent 40 121 0 0 0 0 0\n"
"MouseMoveEvent 41 122 0 0 0 0 0\n"
"RenderEvent 41 122 0 0 0 0 0\n"
"MouseMoveEvent 42 123 0 0 0 0 0\n"
"RenderEvent 42 123 0 0 0 0 0\n"
"MouseMoveEvent 42 125 0 0 0 0 0\n"
"RenderEvent 42 125 0 0 0 0 0\n"
"MouseMoveEvent 43 126 0 0 0 0 0\n"
"RenderEvent 43 126 0 0 0 0 0\n"
"MouseMoveEvent 44 128 0 0 0 0 0\n"
"RenderEvent 44 128 0 0 0 0 0\n"
"MouseMoveEvent 44 129 0 0 0 0 0\n"
"RenderEvent 44 129 0 0 0 0 0\n"
"MouseMoveEvent 45 130 0 0 0 0 0\n"
"RenderEvent 45 130 0 0 0 0 0\n"
"MouseMoveEvent 45 131 0 0 0 0 0\n"
"RenderEvent 45 131 0 0 0 0 0\n"
"MouseMoveEvent 45 132 0 0 0 0 0\n"
"RenderEvent 45 132 0 0 0 0 0\n"
"MouseMoveEvent 46 133 0 0 0 0 0\n"
"RenderEvent 46 133 0 0 0 0 0\n"
"MouseMoveEvent 46 134 0 0 0 0 0\n"
"RenderEvent 46 134 0 0 0 0 0\n"
"MouseMoveEvent 46 135 0 0 0 0 0\n"
"RenderEvent 46 135 0 0 0 0 0\n"
"MouseMoveEvent 47 136 0 0 0 0 0\n"
"RenderEvent 47 136 0 0 0 0 0\n"
"MouseMoveEvent 48 137 0 0 0 0 0\n"
"RenderEvent 48 137 0 0 0 0 0\n"
"MouseMoveEvent 48 138 0 0 0 0 0\n"
"RenderEvent 48 138 0 0 0 0 0\n"
"MouseMoveEvent 48 139 0 0 0 0 0\n"
"RenderEvent 48 139 0 0 0 0 0\n"
"MouseMoveEvent 49 141 0 0 0 0 0\n"
"RenderEvent 49 141 0 0 0 0 0\n"
"MouseMoveEvent 50 143 0 0 0 0 0\n"
"RenderEvent 50 143 0 0 0 0 0\n"
"MouseMoveEvent 50 144 0 0 0 0 0\n"
"RenderEvent 50 144 0 0 0 0 0\n"
"LeftButtonReleaseEvent 50 144 0 0 0 0 0\n"
"RenderEvent 50 144 0 0 0 0 0\n"
"MouseMoveEvent 49 145 0 0 0 0 0\n"
"MouseMoveEvent 48 146 0 0 0 0 0\n"
"MouseMoveEvent 48 147 0 0 0 0 0\n"
"MouseMoveEvent 47 148 0 0 0 0 0\n"
"MouseMoveEvent 47 149 0 0 0 0 0\n"
"MouseMoveEvent 47 150 0 0 0 0 0\n"
"MouseMoveEvent 47 152 0 0 0 0 0\n"
"MouseMoveEvent 46 153 0 0 0 0 0\n"
"MouseMoveEvent 45 155 0 0 0 0 0\n"
"MouseMoveEvent 44 157 0 0 0 0 0\n"
"MouseMoveEvent 44 159 0 0 0 0 0\n"
"MouseMoveEvent 43 161 0 0 0 0 0\n"
"MouseMoveEvent 43 162 0 0 0 0 0\n"
"MouseMoveEvent 42 163 0 0 0 0 0\n"
"MouseMoveEvent 42 164 0 0 0 0 0\n"
"MouseMoveEvent 41 165 0 0 0 0 0\n"
"MouseMoveEvent 41 166 0 0 0 0 0\n"
"MouseMoveEvent 40 167 0 0 0 0 0\n"
"MouseMoveEvent 39 168 0 0 0 0 0\n"
"MouseMoveEvent 38 169 0 0 0 0 0\n"
"MouseMoveEvent 38 170 0 0 0 0 0\n"
"MouseMoveEvent 38 171 0 0 0 0 0\n"
"MouseMoveEvent 37 172 0 0 0 0 0\n"
"MouseMoveEvent 37 173 0 0 0 0 0\n"
"MouseMoveEvent 37 174 0 0 0 0 0\n"
"MouseMoveEvent 37 175 0 0 0 0 0\n"
"MouseMoveEvent 37 176 0 0 0 0 0\n"
"MouseMoveEvent 38 178 0 0 0 0 0\n"
"MouseMoveEvent 39 179 0 0 0 0 0\n"
"MouseMoveEvent 41 179 0 0 0 0 0\n"
"MouseMoveEvent 42 179 0 0 0 0 0\n"
"MouseMoveEvent 43 180 0 0 0 0 0\n"
"MouseMoveEvent 44 180 0 0 0 0 0\n"
"MouseMoveEvent 45 180 0 0 0 0 0\n"
"MouseMoveEvent 46 180 0 0 0 0 0\n"
"MouseMoveEvent 45 180 0 0 0 0 0\n"
"MouseMoveEvent 44 180 0 0 0 0 0\n"
"LeftButtonPressEvent 44 180 0 0 0 0 0\n"
"RenderEvent 44 180 0 0 0 0 0\n"
"MouseMoveEvent 43 181 0 0 0 0 0\n"
"RenderEvent 43 181 0 0 0 0 0\n"
"MouseMoveEvent 43 182 0 0 0 0 0\n"
"RenderEvent 43 182 0 0 0 0 0\n"
"MouseMoveEvent 43 184 0 0 0 0 0\n"
"RenderEvent 43 184 0 0 0 0 0\n"
"MouseMoveEvent 43 185 0 0 0 0 0\n"
"RenderEvent 43 185 0 0 0 0 0\n"
"MouseMoveEvent 43 186 0 0 0 0 0\n"
"RenderEvent 43 186 0 0 0 0 0\n"
"MouseMoveEvent 43 187 0 0 0 0 0\n"
"RenderEvent 43 187 0 0 0 0 0\n"
"MouseMoveEvent 43 188 0 0 0 0 0\n"
"RenderEvent 43 188 0 0 0 0 0\n"
"MouseMoveEvent 43 189 0 0 0 0 0\n"
"RenderEvent 43 189 0 0 0 0 0\n"
"MouseMoveEvent 43 190 0 0 0 0 0\n"
"RenderEvent 43 190 0 0 0 0 0\n"
"MouseMoveEvent 43 191 0 0 0 0 0\n"
"RenderEvent 43 191 0 0 0 0 0\n"
"MouseMoveEvent 43 192 0 0 0 0 0\n"
"RenderEvent 43 192 0 0 0 0 0\n"
"MouseMoveEvent 43 193 0 0 0 0 0\n"
"RenderEvent 43 193 0 0 0 0 0\n"
"LeftButtonReleaseEvent 43 193 0 0 0 0 0\n"
"RenderEvent 43 193 0 0 0 0 0\n"
"MouseMoveEvent 43 190 0 0 0 0 0\n"
"MouseMoveEvent 43 187 0 0 0 0 0\n"
"MouseMoveEvent 43 183 0 0 0 0 0\n"
"MouseMoveEvent 43 179 0 0 0 0 0\n"
"MouseMoveEvent 43 175 0 0 0 0 0\n"
"MouseMoveEvent 43 171 0 0 0 0 0\n"
"MouseMoveEvent 43 166 0 0 0 0 0\n"
"MouseMoveEvent 43 161 0 0 0 0 0\n"
"MouseMoveEvent 43 157 0 0 0 0 0\n"
"MouseMoveEvent 44 152 0 0 0 0 0\n"
"MouseMoveEvent 47 147 0 0 0 0 0\n"
"MouseMoveEvent 50 143 0 0 0 0 0\n"
"MouseMoveEvent 52 140 0 0 0 0 0\n"
"MouseMoveEvent 54 138 0 0 0 0 0\n"
"MouseMoveEvent 55 137 0 0 0 0 0\n"
"MouseMoveEvent 57 135 0 0 0 0 0\n"
"MouseMoveEvent 58 135 0 0 0 0 0\n"
"MouseMoveEvent 59 135 0 0 0 0 0\n"
"MouseMoveEvent 60 135 0 0 0 0 0\n"
"MouseMoveEvent 61 136 0 0 0 0 0\n"
"MouseMoveEvent 62 138 0 0 0 0 0\n"
"MouseMoveEvent 62 139 0 0 0 0 0\n"
"MouseMoveEvent 62 140 0 0 0 0 0\n"
"MouseMoveEvent 62 141 0 0 0 0 0\n"
"MouseMoveEvent 62 142 0 0 0 0 0\n"
"MouseMoveEvent 62 143 0 0 0 0 0\n"
"MouseMoveEvent 62 144 0 0 0 0 0\n"
"MouseMoveEvent 63 146 0 0 0 0 0\n"
"LeftButtonPressEvent 63 146 0 0 0 0 0\n"
"RenderEvent 63 146 0 0 0 0 0\n"
"MouseMoveEvent 63 145 0 0 0 0 0\n"
"RenderEvent 63 145 0 0 0 0 0\n"
"MouseMoveEvent 63 144 0 0 0 0 0\n"
"RenderEvent 63 144 0 0 0 0 0\n"
"MouseMoveEvent 63 142 0 0 0 0 0\n"
"RenderEvent 63 142 0 0 0 0 0\n"
"MouseMoveEvent 63 140 0 0 0 0 0\n"
"RenderEvent 63 140 0 0 0 0 0\n"
"MouseMoveEvent 63 138 0 0 0 0 0\n"
"RenderEvent 63 138 0 0 0 0 0\n"
"MouseMoveEvent 63 135 0 0 0 0 0\n"
"RenderEvent 63 135 0 0 0 0 0\n"
"MouseMoveEvent 63 134 0 0 0 0 0\n"
"RenderEvent 63 134 0 0 0 0 0\n"
"MouseMoveEvent 63 133 0 0 0 0 0\n"
"RenderEvent 63 133 0 0 0 0 0\n"
"MouseMoveEvent 63 130 0 0 0 0 0\n"
"RenderEvent 63 130 0 0 0 0 0\n"
"MouseMoveEvent 63 128 0 0 0 0 0\n"
"RenderEvent 63 128 0 0 0 0 0\n"
"MouseMoveEvent 63 127 0 0 0 0 0\n"
"RenderEvent 63 127 0 0 0 0 0\n"
"MouseMoveEvent 63 125 0 0 0 0 0\n"
"RenderEvent 63 125 0 0 0 0 0\n"
"MouseMoveEvent 63 123 0 0 0 0 0\n"
"RenderEvent 63 123 0 0 0 0 0\n"
"MouseMoveEvent 63 121 0 0 0 0 0\n"
"RenderEvent 63 121 0 0 0 0 0\n"
"MouseMoveEvent 63 118 0 0 0 0 0\n"
"RenderEvent 63 118 0 0 0 0 0\n"
"MouseMoveEvent 63 117 0 0 0 0 0\n"
"RenderEvent 63 117 0 0 0 0 0\n"
"MouseMoveEvent 63 116 0 0 0 0 0\n"
"RenderEvent 63 116 0 0 0 0 0\n"
"MouseMoveEvent 63 115 0 0 0 0 0\n"
"RenderEvent 63 115 0 0 0 0 0\n"
"MouseMoveEvent 64 114 0 0 0 0 0\n"
"RenderEvent 64 114 0 0 0 0 0\n"
"MouseMoveEvent 65 114 0 0 0 0 0\n"
"RenderEvent 65 114 0 0 0 0 0\n"
"LeftButtonReleaseEvent 65 114 0 0 0 0 0\n"
"RenderEvent 65 114 0 0 0 0 0\n"
"MouseMoveEvent 70 118 0 0 0 0 0\n"
"MouseMoveEvent 71 119 0 0 0 0 0\n"
"MouseMoveEvent 72 121 0 0 0 0 0\n"
"MouseMoveEvent 73 122 0 0 0 0 0\n"
"MouseMoveEvent 74 124 0 0 0 0 0\n"
"MouseMoveEvent 75 125 0 0 0 0 0\n"
"MouseMoveEvent 76 128 0 0 0 0 0\n"
"MouseMoveEvent 78 130 0 0 0 0 0\n"
"MouseMoveEvent 79 132 0 0 0 0 0\n"
"MouseMoveEvent 80 134 0 0 0 0 0\n"
"MouseMoveEvent 81 136 0 0 0 0 0\n"
"MouseMoveEvent 82 138 0 0 0 0 0\n"
"MouseMoveEvent 83 140 0 0 0 0 0\n"
"MouseMoveEvent 84 142 0 0 0 0 0\n"
"MouseMoveEvent 85 143 0 0 0 0 0\n"
"MouseMoveEvent 85 144 0 0 0 0 0\n"
"MouseMoveEvent 86 145 0 0 0 0 0\n"
"MouseMoveEvent 86 146 0 0 0 0 0\n"
"MouseMoveEvent 87 148 0 0 0 0 0\n"
"MouseMoveEvent 87 149 0 0 0 0 0\n"
"MouseMoveEvent 87 150 0 0 0 0 0\n"
"MouseMoveEvent 88 151 0 0 0 0 0\n"
"MouseMoveEvent 88 152 0 0 0 0 0\n"
"MouseMoveEvent 89 153 0 0 0 0 0\n"
"MouseMoveEvent 89 154 0 0 0 0 0\n"
"MouseMoveEvent 90 155 0 0 0 0 0\n"
"MouseMoveEvent 90 156 0 0 0 0 0\n"
"MouseMoveEvent 91 157 0 0 0 0 0\n"
"MouseMoveEvent 91 158 0 0 0 0 0\n"
"MouseMoveEvent 92 159 0 0 0 0 0\n"
"MouseMoveEvent 93 160 0 0 0 0 0\n"
"MouseMoveEvent 94 160 0 0 0 0 0\n"
"MouseMoveEvent 95 160 0 0 0 0 0\n"
"MouseMoveEvent 96 160 0 0 0 0 0\n"
"MouseMoveEvent 97 160 0 0 0 0 0\n"
"LeftButtonPressEvent 97 160 0 0 0 0 0\n"
"RenderEvent 97 160 0 0 0 0 0\n"
"MouseMoveEvent 96 160 0 0 0 0 0\n"
"RenderEvent 96 160 0 0 0 0 0\n"
"MouseMoveEvent 95 160 0 0 0 0 0\n"
"RenderEvent 95 160 0 0 0 0 0\n"
"MouseMoveEvent 94 160 0 0 0 0 0\n"
"RenderEvent 94 160 0 0 0 0 0\n"
"MouseMoveEvent 92 160 0 0 0 0 0\n"
"RenderEvent 92 160 0 0 0 0 0\n"
"MouseMoveEvent 91 160 0 0 0 0 0\n"
"RenderEvent 91 160 0 0 0 0 0\n"
"MouseMoveEvent 90 160 0 0 0 0 0\n"
"RenderEvent 90 160 0 0 0 0 0\n"
"MouseMoveEvent 89 160 0 0 0 0 0\n"
"RenderEvent 89 160 0 0 0 0 0\n"
"MouseMoveEvent 88 160 0 0 0 0 0\n"
"RenderEvent 88 160 0 0 0 0 0\n"
"MouseMoveEvent 87 160 0 0 0 0 0\n"
"RenderEvent 87 160 0 0 0 0 0\n"
"MouseMoveEvent 86 160 0 0 0 0 0\n"
"RenderEvent 86 160 0 0 0 0 0\n"
"MouseMoveEvent 84 160 0 0 0 0 0\n"
"RenderEvent 84 160 0 0 0 0 0\n"
"MouseMoveEvent 83 160 0 0 0 0 0\n"
"RenderEvent 83 160 0 0 0 0 0\n"
"MouseMoveEvent 82 160 0 0 0 0 0\n"
"RenderEvent 82 160 0 0 0 0 0\n"
"MouseMoveEvent 81 160 0 0 0 0 0\n"
"RenderEvent 81 160 0 0 0 0 0\n"
"MouseMoveEvent 80 160 0 0 0 0 0\n"
"RenderEvent 80 160 0 0 0 0 0\n"
"MouseMoveEvent 79 161 0 0 0 0 0\n"
"RenderEvent 79 161 0 0 0 0 0\n"
"LeftButtonReleaseEvent 79 161 0 0 0 0 0\n"
"RenderEvent 79 161 0 0 0 0 0\n"
"MouseMoveEvent 78 160 0 0 0 0 0\n"
"MouseMoveEvent 77 160 0 0 0 0 0\n"
"MouseMoveEvent 76 159 0 0 0 0 0\n"
"MouseMoveEvent 75 158 0 0 0 0 0\n"
"MouseMoveEvent 74 158 0 0 0 0 0\n"
"MouseMoveEvent 73 158 0 0 0 0 0\n"
"MouseMoveEvent 72 158 0 0 0 0 0\n"
"MouseMoveEvent 71 158 0 0 0 0 0\n"
"MouseMoveEvent 70 158 0 0 0 0 0\n"
"MouseMoveEvent 69 158 0 0 0 0 0\n"
"MouseMoveEvent 68 158 0 0 0 0 0\n"
"MouseMoveEvent 67 158 0 0 0 0 0\n"
"MouseMoveEvent 65 159 0 0 0 0 0\n"
"MouseMoveEvent 64 159 0 0 0 0 0\n"
"MouseMoveEvent 63 159 0 0 0 0 0\n"
"MouseMoveEvent 62 160 0 0 0 0 0\n"
"MouseMoveEvent 61 160 0 0 0 0 0\n"
"MouseMoveEvent 60 160 0 0 0 0 0\n"
"MouseMoveEvent 59 160 0 0 0 0 0\n"
"MouseMoveEvent 58 160 0 0 0 0 0\n"
"MouseMoveEvent 57 160 0 0 0 0 0\n"
"MouseMoveEvent 56 160 0 0 0 0 0\n"
"MouseMoveEvent 55 160 0 0 0 0 0\n"
"MouseMoveEvent 54 161 0 0 0 0 0\n"
"MouseMoveEvent 53 162 0 0 0 0 0\n"
"MouseMoveEvent 52 163 0 0 0 0 0\n"
"MouseMoveEvent 53 164 0 0 0 0 0\n"
"MouseMoveEvent 52 164 0 0 0 0 0\n"
"LeftButtonPressEvent 52 164 0 0 0 0 0\n"
"RenderEvent 52 164 0 0 0 0 0\n"
"MouseMoveEvent 53 164 0 0 0 0 0\n"
"RenderEvent 53 164 0 0 0 0 0\n"
"MouseMoveEvent 55 164 0 0 0 0 0\n"
"RenderEvent 55 164 0 0 0 0 0\n"
"MouseMoveEvent 56 164 0 0 0 0 0\n"
"RenderEvent 56 164 0 0 0 0 0\n"
"MouseMoveEvent 57 164 0 0 0 0 0\n"
"RenderEvent 57 164 0 0 0 0 0\n"
"MouseMoveEvent 58 164 0 0 0 0 0\n"
"RenderEvent 58 164 0 0 0 0 0\n"
"MouseMoveEvent 59 164 0 0 0 0 0\n"
"RenderEvent 59 164 0 0 0 0 0\n"
"MouseMoveEvent 60 164 0 0 0 0 0\n"
"RenderEvent 60 164 0 0 0 0 0\n"
"MouseMoveEvent 61 164 0 0 0 0 0\n"
"RenderEvent 61 164 0 0 0 0 0\n"
"MouseMoveEvent 62 164 0 0 0 0 0\n"
"RenderEvent 62 164 0 0 0 0 0\n"
"MouseMoveEvent 63 164 0 0 0 0 0\n"
"RenderEvent 63 164 0 0 0 0 0\n"
"MouseMoveEvent 64 164 0 0 0 0 0\n"
"RenderEvent 64 164 0 0 0 0 0\n"
"MouseMoveEvent 65 164 0 0 0 0 0\n"
"RenderEvent 65 164 0 0 0 0 0\n"
"MouseMoveEvent 66 164 0 0 0 0 0\n"
"RenderEvent 66 164 0 0 0 0 0\n"
"LeftButtonReleaseEvent 66 164 0 0 0 0 0\n"
"RenderEvent 66 164 0 0 0 0 0\n"
"MouseMoveEvent 67 165 0 0 0 0 0\n"
"MouseMoveEvent 68 165 0 0 0 0 0\n"
"MouseMoveEvent 69 165 0 0 0 0 0\n"
"MouseMoveEvent 70 166 0 0 0 0 0\n"
"MouseMoveEvent 71 167 0 0 0 0 0\n"
"MouseMoveEvent 72 168 0 0 0 0 0\n"
"MouseMoveEvent 73 169 0 0 0 0 0\n"
"MouseMoveEvent 75 170 0 0 0 0 0\n"
"MouseMoveEvent 79 172 0 0 0 0 0\n"
"MouseMoveEvent 81 173 0 0 0 0 0\n"
"MouseMoveEvent 82 174 0 0 0 0 0\n"
"MouseMoveEvent 83 175 0 0 0 0 0\n"
"MouseMoveEvent 84 175 0 0 0 0 0\n"
"MouseMoveEvent 85 176 0 0 0 0 0\n"
"MouseMoveEvent 85 177 0 0 0 0 0\n"
"MouseMoveEvent 85 178 0 0 0 0 0\n"
"MouseMoveEvent 85 179 0 0 0 0 0\n"
"MouseMoveEvent 84 180 0 0 0 0 0\n"
"MouseMoveEvent 83 180 0 0 0 0 0\n"
"MouseMoveEvent 82 180 0 0 0 0 0\n"
"MouseMoveEvent 81 179 0 0 0 0 0\n"
"MouseMoveEvent 80 179 0 0 0 0 0\n"
"LeftButtonPressEvent 80 179 0 0 0 0 0\n"
"RenderEvent 80 179 0 0 0 0 0\n"
"MouseMoveEvent 81 179 0 0 0 0 0\n"
"RenderEvent 81 179 0 0 0 0 0\n"
"MouseMoveEvent 82 179 0 0 0 0 0\n"
"RenderEvent 82 179 0 0 0 0 0\n"
"MouseMoveEvent 84 179 0 0 0 0 0\n"
"RenderEvent 84 179 0 0 0 0 0\n"
"MouseMoveEvent 85 179 0 0 0 0 0\n"
"RenderEvent 85 179 0 0 0 0 0\n"
"MouseMoveEvent 86 179 0 0 0 0 0\n"
"RenderEvent 86 179 0 0 0 0 0\n"
"MouseMoveEvent 87 179 0 0 0 0 0\n"
"RenderEvent 87 179 0 0 0 0 0\n"
"MouseMoveEvent 88 179 0 0 0 0 0\n"
"RenderEvent 88 179 0 0 0 0 0\n"
"MouseMoveEvent 89 179 0 0 0 0 0\n"
"RenderEvent 89 179 0 0 0 0 0\n"
"MouseMoveEvent 90 179 0 0 0 0 0\n"
"RenderEvent 90 179 0 0 0 0 0\n"
"MouseMoveEvent 91 179 0 0 0 0 0\n"
"RenderEvent 91 179 0 0 0 0 0\n"
"MouseMoveEvent 92 179 0 0 0 0 0\n"
"RenderEvent 92 179 0 0 0 0 0\n"
"MouseMoveEvent 93 179 0 0 0 0 0\n"
"RenderEvent 93 179 0 0 0 0 0\n"
"MouseMoveEvent 94 179 0 0 0 0 0\n"
"RenderEvent 94 179 0 0 0 0 0\n"
"MouseMoveEvent 95 179 0 0 0 0 0\n"
"RenderEvent 95 179 0 0 0 0 0\n"
"MouseMoveEvent 96 179 0 0 0 0 0\n"
"RenderEvent 96 179 0 0 0 0 0\n"
"MouseMoveEvent 97 179 0 0 0 0 0\n"
"RenderEvent 97 179 0 0 0 0 0\n"
"MouseMoveEvent 98 179 0 0 0 0 0\n"
"RenderEvent 98 179 0 0 0 0 0\n"
"MouseMoveEvent 99 179 0 0 0 0 0\n"
"RenderEvent 99 179 0 0 0 0 0\n"
"MouseMoveEvent 100 179 0 0 0 0 0\n"
"RenderEvent 100 179 0 0 0 0 0\n"
"MouseMoveEvent 101 179 0 0 0 0 0\n"
"RenderEvent 101 179 0 0 0 0 0\n"
"MouseMoveEvent 102 179 0 0 0 0 0\n"
"RenderEvent 102 179 0 0 0 0 0\n"
"MouseMoveEvent 103 179 0 0 0 0 0\n"
"RenderEvent 103 179 0 0 0 0 0\n"
"MouseMoveEvent 104 179 0 0 0 0 0\n"
"RenderEvent 104 179 0 0 0 0 0\n"
"MouseMoveEvent 105 179 0 0 0 0 0\n"
"RenderEvent 105 179 0 0 0 0 0\n"
"MouseMoveEvent 106 179 0 0 0 0 0\n"
"RenderEvent 106 179 0 0 0 0 0\n"
"MouseMoveEvent 107 179 0 0 0 0 0\n"
"RenderEvent 107 179 0 0 0 0 0\n"
"MouseMoveEvent 108 179 0 0 0 0 0\n"
"RenderEvent 108 179 0 0 0 0 0\n"
"MouseMoveEvent 109 179 0 0 0 0 0\n"
"RenderEvent 109 179 0 0 0 0 0\n"
"MouseMoveEvent 110 179 0 0 0 0 0\n"
"RenderEvent 110 179 0 0 0 0 0\n"
"MouseMoveEvent 111 179 0 0 0 0 0\n"
"RenderEvent 111 179 0 0 0 0 0\n"
"MouseMoveEvent 112 179 0 0 0 0 0\n"
"RenderEvent 112 179 0 0 0 0 0\n"
"MouseMoveEvent 113 179 0 0 0 0 0\n"
"RenderEvent 113 179 0 0 0 0 0\n"
"MouseMoveEvent 114 179 0 0 0 0 0\n"
"RenderEvent 114 179 0 0 0 0 0\n"
"MouseMoveEvent 115 179 0 0 0 0 0\n"
"RenderEvent 115 179 0 0 0 0 0\n"
"MouseMoveEvent 116 179 0 0 0 0 0\n"
"RenderEvent 116 179 0 0 0 0 0\n"
"MouseMoveEvent 117 179 0 0 0 0 0\n"
"RenderEvent 117 179 0 0 0 0 0\n"
"LeftButtonReleaseEvent 117 179 0 0 0 0 0\n"
"RenderEvent 117 179 0 0 0 0 0\n"
"MouseMoveEvent 116 178 0 0 0 0 0\n"
"MouseMoveEvent 115 177 0 0 0 0 0\n"
"MouseMoveEvent 114 177 0 0 0 0 0\n"
"MouseMoveEvent 111 176 0 0 0 0 0\n"
"MouseMoveEvent 110 175 0 0 0 0 0\n"
"MouseMoveEvent 109 174 0 0 0 0 0\n"
"MouseMoveEvent 107 173 0 0 0 0 0\n"
"MouseMoveEvent 106 172 0 0 0 0 0\n"
"MouseMoveEvent 105 172 0 0 0 0 0\n"
"MouseMoveEvent 103 171 0 0 0 0 0\n"
"MouseMoveEvent 102 171 0 0 0 0 0\n"
"MouseMoveEvent 101 170 0 0 0 0 0\n"
"MouseMoveEvent 100 170 0 0 0 0 0\n"
"MouseMoveEvent 98 169 0 0 0 0 0\n"
"MouseMoveEvent 97 169 0 0 0 0 0\n"
"MouseMoveEvent 96 168 0 0 0 0 0\n"
"MouseMoveEvent 95 168 0 0 0 0 0\n"
"MouseMoveEvent 94 168 0 0 0 0 0\n"
"MouseMoveEvent 93 168 0 0 0 0 0\n"
"MouseMoveEvent 92 168 0 0 0 0 0\n"
"MouseMoveEvent 91 168 0 0 0 0 0\n"
"MouseMoveEvent 90 168 0 0 0 0 0\n"
"MouseMoveEvent 89 169 0 0 0 0 0\n"
"MouseMoveEvent 88 169 0 0 0 0 0\n"
"MouseMoveEvent 87 169 0 0 0 0 0\n"
"MouseMoveEvent 86 169 0 0 0 0 0\n"
"MouseMoveEvent 85 169 0 0 0 0 0\n"
"MouseMoveEvent 84 169 0 0 0 0 0\n"
"MouseMoveEvent 83 169 0 0 0 0 0\n"
"MouseMoveEvent 82 168 0 0 0 0 0\n"
"MouseMoveEvent 81 168 0 0 0 0 0\n"
"MouseMoveEvent 80 167 0 0 0 0 0\n"
"MouseMoveEvent 79 164 0 0 0 0 0\n"
"MouseMoveEvent 79 162 0 0 0 0 0\n"
"MouseMoveEvent 79 159 0 0 0 0 0\n"
"MouseMoveEvent 78 156 0 0 0 0 0\n"
"MouseMoveEvent 78 153 0 0 0 0 0\n"
"MouseMoveEvent 78 151 0 0 0 0 0\n"
"MouseMoveEvent 78 150 0 0 0 0 0\n"
"MouseMoveEvent 78 147 0 0 0 0 0\n"
"MouseMoveEvent 78 146 0 0 0 0 0\n"
"MouseMoveEvent 78 145 0 0 0 0 0\n"
"MouseMoveEvent 78 143 0 0 0 0 0\n"
"MouseMoveEvent 78 142 0 0 0 0 0\n"
"MouseMoveEvent 78 140 0 0 0 0 0\n"
"MouseMoveEvent 78 139 0 0 0 0 0\n"
"MouseMoveEvent 78 136 0 0 0 0 0\n"
"MouseMoveEvent 78 135 0 0 0 0 0\n"
"MouseMoveEvent 78 132 0 0 0 0 0\n"
"MouseMoveEvent 78 131 0 0 0 0 0\n"
"MouseMoveEvent 78 130 0 0 0 0 0\n"
"MouseMoveEvent 78 129 0 0 0 0 0\n"
"MouseMoveEvent 78 128 0 0 0 0 0\n"
"MouseMoveEvent 78 127 0 0 0 0 0\n"
"MouseMoveEvent 78 126 0 0 0 0 0\n"
"MouseMoveEvent 79 125 0 0 0 0 0\n"
"MouseMoveEvent 79 124 0 0 0 0 0\n"
"MouseMoveEvent 79 123 0 0 0 0 0\n"
"MouseMoveEvent 80 122 0 0 0 0 0\n"
"MouseMoveEvent 80 121 0 0 0 0 0\n"
"MouseMoveEvent 80 120 0 0 0 0 0\n"
"MouseMoveEvent 80 119 0 0 0 0 0\n"
"MouseMoveEvent 81 118 0 0 0 0 0\n"
"MouseMoveEvent 81 117 0 0 0 0 0\n"
"MouseMoveEvent 81 116 0 0 0 0 0\n"
"MouseMoveEvent 82 115 0 0 0 0 0\n"
"MouseMoveEvent 83 114 0 0 0 0 0\n"
"MouseMoveEvent 83 113 0 0 0 0 0\n"
"MouseMoveEvent 84 112 0 0 0 0 0\n"
"LeftButtonPressEvent 84 112 0 0 0 0 0\n"
"RenderEvent 84 112 0 0 0 0 0\n"
"MouseMoveEvent 84 113 0 0 0 0 0\n"
"RenderEvent 84 113 0 0 0 0 0\n"
"MouseMoveEvent 84 114 0 0 0 0 0\n"
"RenderEvent 84 114 0 0 0 0 0\n"
"MouseMoveEvent 84 116 0 0 0 0 0\n"
"RenderEvent 84 116 0 0 0 0 0\n"
"MouseMoveEvent 84 121 0 0 0 0 0\n"
"RenderEvent 84 121 0 0 0 0 0\n"
"MouseMoveEvent 84 122 0 0 0 0 0\n"
"RenderEvent 84 122 0 0 0 0 0\n"
"MouseMoveEvent 84 127 0 0 0 0 0\n"
"RenderEvent 84 127 0 0 0 0 0\n"
"MouseMoveEvent 84 128 0 0 0 0 0\n"
"RenderEvent 84 128 0 0 0 0 0\n"
"MouseMoveEvent 84 129 0 0 0 0 0\n"
"RenderEvent 84 129 0 0 0 0 0\n"
"MouseMoveEvent 84 130 0 0 0 0 0\n"
"RenderEvent 84 130 0 0 0 0 0\n"
"MouseMoveEvent 84 133 0 0 0 0 0\n"
"RenderEvent 84 133 0 0 0 0 0\n"
"MouseMoveEvent 84 134 0 0 0 0 0\n"
"RenderEvent 84 134 0 0 0 0 0\n"
"MouseMoveEvent 84 135 0 0 0 0 0\n"
"RenderEvent 84 135 0 0 0 0 0\n"
"MouseMoveEvent 84 136 0 0 0 0 0\n"
"RenderEvent 84 136 0 0 0 0 0\n"
"MouseMoveEvent 84 137 0 0 0 0 0\n"
"RenderEvent 84 137 0 0 0 0 0\n"
"MouseMoveEvent 84 138 0 0 0 0 0\n"
"RenderEvent 84 138 0 0 0 0 0\n"
"MouseMoveEvent 84 139 0 0 0 0 0\n"
"RenderEvent 84 139 0 0 0 0 0\n"
"MouseMoveEvent 84 140 0 0 0 0 0\n"
"RenderEvent 84 140 0 0 0 0 0\n"
"MouseMoveEvent 85 142 0 0 0 0 0\n"
"RenderEvent 85 142 0 0 0 0 0\n"
"MouseMoveEvent 85 143 0 0 0 0 0\n"
"RenderEvent 85 143 0 0 0 0 0\n"
"MouseMoveEvent 85 144 0 0 0 0 0\n"
"RenderEvent 85 144 0 0 0 0 0\n"
"MouseMoveEvent 85 145 0 0 0 0 0\n"
"RenderEvent 85 145 0 0 0 0 0\n"
"LeftButtonReleaseEvent 85 145 0 0 0 0 0\n"
"RenderEvent 85 145 0 0 0 0 0\n"
"MouseMoveEvent 85 146 0 0 0 0 0\n"
"MouseMoveEvent 85 147 0 0 0 0 0\n"
"MouseMoveEvent 85 148 0 0 0 0 0\n"
"MouseMoveEvent 84 149 0 0 0 0 0\n"
"MouseMoveEvent 83 150 0 0 0 0 0\n"
"MouseMoveEvent 83 151 0 0 0 0 0\n"
"MouseMoveEvent 82 153 0 0 0 0 0\n"
"MouseMoveEvent 82 154 0 0 0 0 0\n"
"MouseMoveEvent 82 155 0 0 0 0 0\n"
"MouseMoveEvent 81 156 0 0 0 0 0\n"
"MouseMoveEvent 81 157 0 0 0 0 0\n"
"MouseMoveEvent 80 159 0 0 0 0 0\n"
"MouseMoveEvent 80 160 0 0 0 0 0\n"
"MouseMoveEvent 80 161 0 0 0 0 0\n"
"MouseMoveEvent 80 162 0 0 0 0 0\n"
"MouseMoveEvent 79 164 0 0 0 0 0\n"
"MouseMoveEvent 79 165 0 0 0 0 0\n"
"MouseMoveEvent 79 166 0 0 0 0 0\n"
"MouseMoveEvent 78 167 0 0 0 0 0\n"
"MouseMoveEvent 77 168 0 0 0 0 0\n"
"MouseMoveEvent 76 168 0 0 0 0 0\n"
"MouseMoveEvent 75 168 0 0 0 0 0\n"
"MouseMoveEvent 73 169 0 0 0 0 0\n"
"MouseMoveEvent 72 169 0 0 0 0 0\n"
"MouseMoveEvent 71 169 0 0 0 0 0\n"
"MouseMoveEvent 70 169 0 0 0 0 0\n"
"MouseMoveEvent 69 169 0 0 0 0 0\n"
"MouseMoveEvent 68 169 0 0 0 0 0\n"
"MouseMoveEvent 67 169 0 0 0 0 0\n"
"LeftButtonPressEvent 67 169 0 0 0 0 0\n"
"RenderEvent 67 169 0 0 0 0 0\n"
"MouseMoveEvent 66 169 0 0 0 0 0\n"
"RenderEvent 66 169 0 0 0 0 0\n"
"MouseMoveEvent 65 169 0 0 0 0 0\n"
"RenderEvent 65 169 0 0 0 0 0\n"
"MouseMoveEvent 63 169 0 0 0 0 0\n"
"RenderEvent 63 169 0 0 0 0 0\n"
"MouseMoveEvent 60 169 0 0 0 0 0\n"
"RenderEvent 60 169 0 0 0 0 0\n"
"MouseMoveEvent 59 169 0 0 0 0 0\n"
"RenderEvent 59 169 0 0 0 0 0\n"
"MouseMoveEvent 58 169 0 0 0 0 0\n"
"RenderEvent 58 169 0 0 0 0 0\n"
"MouseMoveEvent 57 169 0 0 0 0 0\n"
"RenderEvent 57 169 0 0 0 0 0\n"
"MouseMoveEvent 56 169 0 0 0 0 0\n"
"RenderEvent 56 169 0 0 0 0 0\n"
"MouseMoveEvent 55 169 0 0 0 0 0\n"
"RenderEvent 55 169 0 0 0 0 0\n"
"MouseMoveEvent 54 169 0 0 0 0 0\n"
"RenderEvent 54 169 0 0 0 0 0\n"
"MouseMoveEvent 53 169 0 0 0 0 0\n"
"RenderEvent 53 169 0 0 0 0 0\n"
"MouseMoveEvent 51 169 0 0 0 0 0\n"
"RenderEvent 51 169 0 0 0 0 0\n"
"MouseMoveEvent 48 169 0 0 0 0 0\n"
"RenderEvent 48 169 0 0 0 0 0\n"
"MouseMoveEvent 47 169 0 0 0 0 0\n"
"RenderEvent 47 169 0 0 0 0 0\n"
"LeftButtonReleaseEvent 47 169 0 0 0 0 0\n"
"RenderEvent 47 169 0 0 0 0 0\n"
"MouseMoveEvent 48 169 0 0 0 0 0\n"
"MouseMoveEvent 49 169 0 0 0 0 0\n"
"MouseMoveEvent 51 169 0 0 0 0 0\n"
"MouseMoveEvent 53 170 0 0 0 0 0\n"
"MouseMoveEvent 55 171 0 0 0 0 0\n"
"MouseMoveEvent 56 171 0 0 0 0 0\n"
"MouseMoveEvent 58 172 0 0 0 0 0\n"
"MouseMoveEvent 60 173 0 0 0 0 0\n"
"MouseMoveEvent 61 174 0 0 0 0 0\n"
"MouseMoveEvent 62 174 0 0 0 0 0\n"
"MouseMoveEvent 63 174 0 0 0 0 0\n"
"MouseMoveEvent 64 175 0 0 0 0 0\n"
"MouseMoveEvent 65 176 0 0 0 0 0\n"
"MouseMoveEvent 66 176 0 0 0 0 0\n"
"MouseMoveEvent 67 176 0 0 0 0 0\n"
"MouseMoveEvent 68 177 0 0 0 0 0\n"
"MouseMoveEvent 69 178 0 0 0 0 0\n"
"MouseMoveEvent 70 179 0 0 0 0 0\n"
"MouseMoveEvent 71 180 0 0 0 0 0\n"
"MouseMoveEvent 71 181 0 0 0 0 0\n"
"MouseMoveEvent 71 183 0 0 0 0 0\n"
"MouseMoveEvent 71 184 0 0 0 0 0\n"
"MouseMoveEvent 71 185 0 0 0 0 0\n"
"MouseMoveEvent 71 186 0 0 0 0 0\n"
"MouseMoveEvent 71 187 0 0 0 0 0\n"
"MouseMoveEvent 71 188 0 0 0 0 0\n"
"MouseMoveEvent 72 189 0 0 0 0 0\n"
"MouseMoveEvent 72 190 0 0 0 0 0\n"
"MouseMoveEvent 72 191 0 0 0 0 0\n"
"MouseMoveEvent 72 192 0 0 0 0 0\n"
"LeftButtonPressEvent 72 192 0 0 0 0 0\n"
"RenderEvent 72 192 0 0 0 0 0\n"
"MouseMoveEvent 72 191 0 0 0 0 0\n"
"RenderEvent 72 191 0 0 0 0 0\n"
"MouseMoveEvent 72 190 0 0 0 0 0\n"
"RenderEvent 72 190 0 0 0 0 0\n"
"MouseMoveEvent 72 189 0 0 0 0 0\n"
"RenderEvent 72 189 0 0 0 0 0\n"
"MouseMoveEvent 72 188 0 0 0 0 0\n"
"RenderEvent 72 188 0 0 0 0 0\n"
"MouseMoveEvent 72 187 0 0 0 0 0\n"
"RenderEvent 72 187 0 0 0 0 0\n"
"MouseMoveEvent 72 186 0 0 0 0 0\n"
"RenderEvent 72 186 0 0 0 0 0\n"
"MouseMoveEvent 72 185 0 0 0 0 0\n"
"RenderEvent 72 185 0 0 0 0 0\n"
"LeftButtonReleaseEvent 72 185 0 0 0 0 0\n"
"RenderEvent 72 185 0 0 0 0 0\n"
"MouseMoveEvent 73 182 0 0 0 0 0\n"
"MouseMoveEvent 74 181 0 0 0 0 0\n"
"MouseMoveEvent 75 178 0 0 0 0 0\n"
"MouseMoveEvent 76 176 0 0 0 0 0\n"
"MouseMoveEvent 77 174 0 0 0 0 0\n"
"MouseMoveEvent 78 172 0 0 0 0 0\n"
"MouseMoveEvent 79 171 0 0 0 0 0\n"
"MouseMoveEvent 80 170 0 0 0 0 0\n"
"MouseMoveEvent 81 169 0 0 0 0 0\n"
"MouseMoveEvent 82 169 0 0 0 0 0\n"
"MouseMoveEvent 83 168 0 0 0 0 0\n"
"MouseMoveEvent 84 168 0 0 0 0 0\n"
"MouseMoveEvent 86 167 0 0 0 0 0\n"
"MouseMoveEvent 88 166 0 0 0 0 0\n"
"MouseMoveEvent 90 165 0 0 0 0 0\n"
"MouseMoveEvent 92 164 0 0 0 0 0\n"
"MouseMoveEvent 94 164 0 0 0 0 0\n"
"MouseMoveEvent 95 163 0 0 0 0 0\n"
"MouseMoveEvent 96 163 0 0 0 0 0\n"
"MouseMoveEvent 97 163 0 0 0 0 0\n"
"MouseMoveEvent 98 162 0 0 0 0 0\n"
"MouseMoveEvent 99 162 0 0 0 0 0\n"
"MouseMoveEvent 100 162 0 0 0 0 0\n"
"MouseMoveEvent 101 162 0 0 0 0 0\n"
"MouseMoveEvent 102 162 0 0 0 0 0\n"
"MouseMoveEvent 103 162 0 0 0 0 0\n"
"MouseMoveEvent 104 162 0 0 0 0 0\n"
"MouseMoveEvent 105 163 0 0 0 0 0\n"
"MouseMoveEvent 105 164 0 0 0 0 0\n"
"MouseMoveEvent 105 165 0 0 0 0 0\n"
"MouseMoveEvent 105 166 0 0 0 0 0\n"
"MouseMoveEvent 105 167 0 0 0 0 0\n"
"MouseMoveEvent 106 168 0 0 0 0 0\n"
"MouseMoveEvent 107 169 0 0 0 0 0\n"
"MouseMoveEvent 108 169 0 0 0 0 0\n"
"MouseMoveEvent 109 170 0 0 0 0 0\n"
"MouseMoveEvent 110 170 0 0 0 0 0\n"
"MouseMoveEvent 111 170 0 0 0 0 0\n"
"MouseMoveEvent 112 170 0 0 0 0 0\n"
"MouseMoveEvent 113 170 0 0 0 0 0\n"
"MouseMoveEvent 114 170 0 0 0 0 0\n"
"MouseMoveEvent 115 171 0 0 0 0 0\n"
"LeftButtonPressEvent 115 171 0 0 0 0 0\n"
"RenderEvent 115 171 0 0 0 0 0\n"
"MouseMoveEvent 114 171 0 0 0 0 0\n"
"RenderEvent 114 171 0 0 0 0 0\n"
"MouseMoveEvent 113 171 0 0 0 0 0\n"
"RenderEvent 113 171 0 0 0 0 0\n"
"MouseMoveEvent 111 170 0 0 0 0 0\n"
"RenderEvent 111 170 0 0 0 0 0\n"
"MouseMoveEvent 109 170 0 0 0 0 0\n"
"RenderEvent 109 170 0 0 0 0 0\n"
"MouseMoveEvent 108 170 0 0 0 0 0\n"
"RenderEvent 108 170 0 0 0 0 0\n"
"MouseMoveEvent 106 170 0 0 0 0 0\n"
"RenderEvent 106 170 0 0 0 0 0\n"
"MouseMoveEvent 105 170 0 0 0 0 0\n"
"RenderEvent 105 170 0 0 0 0 0\n"
"MouseMoveEvent 104 170 0 0 0 0 0\n"
"RenderEvent 104 170 0 0 0 0 0\n"
"MouseMoveEvent 103 170 0 0 0 0 0\n"
"RenderEvent 103 170 0 0 0 0 0\n"
"MouseMoveEvent 102 170 0 0 0 0 0\n"
"RenderEvent 102 170 0 0 0 0 0\n"
"MouseMoveEvent 101 170 0 0 0 0 0\n"
"RenderEvent 101 170 0 0 0 0 0\n"
"MouseMoveEvent 100 170 0 0 0 0 0\n"
"RenderEvent 100 170 0 0 0 0 0\n"
"MouseMoveEvent 99 170 0 0 0 0 0\n"
"RenderEvent 99 170 0 0 0 0 0\n"
"MouseMoveEvent 98 170 0 0 0 0 0\n"
"RenderEvent 98 170 0 0 0 0 0\n"
"MouseMoveEvent 97 170 0 0 0 0 0\n"
"RenderEvent 97 170 0 0 0 0 0\n"
"MouseMoveEvent 96 170 0 0 0 0 0\n"
"RenderEvent 96 170 0 0 0 0 0\n"
"MouseMoveEvent 95 170 0 0 0 0 0\n"
"RenderEvent 95 170 0 0 0 0 0\n"
"MouseMoveEvent 94 170 0 0 0 0 0\n"
"RenderEvent 94 170 0 0 0 0 0\n"
"MouseMoveEvent 93 170 0 0 0 0 0\n"
"RenderEvent 93 170 0 0 0 0 0\n"
"MouseMoveEvent 92 170 0 0 0 0 0\n"
"RenderEvent 92 170 0 0 0 0 0\n"
"MouseMoveEvent 91 170 0 0 0 0 0\n"
"RenderEvent 91 170 0 0 0 0 0\n"
"MouseMoveEvent 89 170 0 0 0 0 0\n"
"RenderEvent 89 170 0 0 0 0 0\n"
"MouseMoveEvent 88 170 0 0 0 0 0\n"
"RenderEvent 88 170 0 0 0 0 0\n"
"MouseMoveEvent 87 170 0 0 0 0 0\n"
"RenderEvent 87 170 0 0 0 0 0\n"
"LeftButtonReleaseEvent 87 170 0 0 0 0 0\n"
"RenderEvent 87 170 0 0 0 0 0\n"
"MouseMoveEvent 86 169 0 0 0 0 0\n"
"MouseMoveEvent 85 168 0 0 0 0 0\n"
"MouseMoveEvent 84 166 0 0 0 0 0\n"
"MouseMoveEvent 84 163 0 0 0 0 0\n"
"MouseMoveEvent 84 162 0 0 0 0 0\n"
"MouseMoveEvent 84 159 0 0 0 0 0\n"
"MouseMoveEvent 83 156 0 0 0 0 0\n"
"MouseMoveEvent 82 154 0 0 0 0 0\n"
"MouseMoveEvent 81 150 0 0 0 0 0\n"
"MouseMoveEvent 80 148 0 0 0 0 0\n"
"MouseMoveEvent 79 145 0 0 0 0 0\n"
"MouseMoveEvent 78 142 0 0 0 0 0\n"
"MouseMoveEvent 77 140 0 0 0 0 0\n"
"MouseMoveEvent 76 138 0 0 0 0 0\n"
"MouseMoveEvent 74 134 0 0 0 0 0\n"
"MouseMoveEvent 74 133 0 0 0 0 0\n"
"MouseMoveEvent 73 131 0 0 0 0 0\n"
"MouseMoveEvent 73 128 0 0 0 0 0\n"
"MouseMoveEvent 72 126 0 0 0 0 0\n"
"MouseMoveEvent 72 125 0 0 0 0 0\n"
"MouseMoveEvent 72 124 0 0 0 0 0\n"
"MouseMoveEvent 72 123 0 0 0 0 0\n"
"MouseMoveEvent 72 122 0 0 0 0 0\n"
"MouseMoveEvent 72 121 0 0 0 0 0\n"
"MouseMoveEvent 72 120 0 0 0 0 0\n"
"MouseMoveEvent 73 119 0 0 0 0 0\n"
"MouseMoveEvent 74 118 0 0 0 0 0\n"
"MouseMoveEvent 75 118 0 0 0 0 0\n"
"MouseMoveEvent 76 118 0 0 0 0 0\n"
"MouseMoveEvent 77 117 0 0 0 0 0\n"
"MouseMoveEvent 79 116 0 0 0 0 0\n"
"MouseMoveEvent 81 115 0 0 0 0 0\n"
"MouseMoveEvent 82 115 0 0 0 0 0\n"
"MouseMoveEvent 83 114 0 0 0 0 0\n"
"MouseMoveEvent 84 114 0 0 0 0 0\n"
"MouseMoveEvent 85 114 0 0 0 0 0\n"
"MouseMoveEvent 86 114 0 0 0 0 0\n"
"MouseMoveEvent 87 114 0 0 0 0 0\n"
"MouseMoveEvent 88 115 0 0 0 0 0\n"
"MouseMoveEvent 89 116 0 0 0 0 0\n"
"MouseMoveEvent 89 117 0 0 0 0 0\n"
"MouseMoveEvent 90 119 0 0 0 0 0\n"
"MouseMoveEvent 90 121 0 0 0 0 0\n"
"MouseMoveEvent 90 124 0 0 0 0 0\n"
"MouseMoveEvent 90 126 0 0 0 0 0\n"
"MouseMoveEvent 90 128 0 0 0 0 0\n"
"MouseMoveEvent 90 130 0 0 0 0 0\n"
"MouseMoveEvent 90 132 0 0 0 0 0\n"
"MouseMoveEvent 90 134 0 0 0 0 0\n"
"MouseMoveEvent 90 136 0 0 0 0 0\n"
"MouseMoveEvent 90 138 0 0 0 0 0\n"
"MouseMoveEvent 90 139 0 0 0 0 0\n"
"MouseMoveEvent 89 141 0 0 0 0 0\n"
"MouseMoveEvent 89 143 0 0 0 0 0\n"
"MouseMoveEvent 89 145 0 0 0 0 0\n"
"MouseMoveEvent 89 146 0 0 0 0 0\n"
"MouseMoveEvent 89 148 0 0 0 0 0\n"
"MouseMoveEvent 89 149 0 0 0 0 0\n"
"MouseMoveEvent 89 151 0 0 0 0 0\n"
"MouseMoveEvent 89 152 0 0 0 0 0\n"
"MouseMoveEvent 89 153 0 0 0 0 0\n"
"MouseMoveEvent 89 154 0 0 0 0 0\n"
"MouseMoveEvent 89 155 0 0 0 0 0\n"
"MouseMoveEvent 89 156 0 0 0 0 0\n"
"MouseMoveEvent 89 157 0 0 0 0 0\n"
"MouseMoveEvent 90 159 0 0 0 0 0\n"
"MouseMoveEvent 89 160 0 0 0 0 0\n"
"MouseMoveEvent 88 160 0 0 0 0 0\n"
"MouseMoveEvent 87 160 0 0 0 0 0\n"
"MouseMoveEvent 86 161 0 0 0 0 0\n"
"LeftButtonPressEvent 86 161 0 0 0 0 0\n"
"RenderEvent 86 161 0 0 0 0 0\n"
"MouseMoveEvent 85 161 0 0 0 0 0\n"
"RenderEvent 85 161 0 0 0 0 0\n"
"MouseMoveEvent 83 161 0 0 0 0 0\n"
"RenderEvent 83 161 0 0 0 0 0\n"
"MouseMoveEvent 82 161 0 0 0 0 0\n"
"RenderEvent 82 161 0 0 0 0 0\n"
"MouseMoveEvent 81 161 0 0 0 0 0\n"
"RenderEvent 81 161 0 0 0 0 0\n"
"MouseMoveEvent 80 161 0 0 0 0 0\n"
"RenderEvent 80 161 0 0 0 0 0\n"
"MouseMoveEvent 79 161 0 0 0 0 0\n"
"RenderEvent 79 161 0 0 0 0 0\n"
"LeftButtonReleaseEvent 79 161 0 0 0 0 0\n"
"RenderEvent 79 161 0 0 0 0 0\n"
"MouseMoveEvent 77 161 0 0 0 0 0\n"
"MouseMoveEvent 76 162 0 0 0 0 0\n"
"MouseMoveEvent 75 162 0 0 0 0 0\n"
"MouseMoveEvent 74 162 0 0 0 0 0\n"
"MouseMoveEvent 73 163 0 0 0 0 0\n"
"MouseMoveEvent 72 163 0 0 0 0 0\n"
"MouseMoveEvent 70 164 0 0 0 0 0\n"
"MouseMoveEvent 69 164 0 0 0 0 0\n"
"MouseMoveEvent 68 164 0 0 0 0 0\n"
"MouseMoveEvent 67 164 0 0 0 0 0\n"
"MouseMoveEvent 65 165 0 0 0 0 0\n"
"MouseMoveEvent 62 165 0 0 0 0 0\n"
"MouseMoveEvent 61 165 0 0 0 0 0\n"
"MouseMoveEvent 60 165 0 0 0 0 0\n"
"MouseMoveEvent 59 165 0 0 0 0 0\n"
"MouseMoveEvent 58 166 0 0 0 0 0\n"
"MouseMoveEvent 57 166 0 0 0 0 0\n"
"MouseMoveEvent 56 166 0 0 0 0 0\n"
"MouseMoveEvent 55 166 0 0 0 0 0\n"
"MouseMoveEvent 54 167 0 0 0 0 0\n"
"MouseMoveEvent 53 167 0 0 0 0 0\n"
"MouseMoveEvent 51 167 0 0 0 0 0\n"
"MouseMoveEvent 49 167 0 0 0 0 0\n"
"MouseMoveEvent 48 168 0 0 0 0 0\n"
"MouseMoveEvent 47 168 0 0 0 0 0\n"
"MouseMoveEvent 45 169 0 0 0 0 0\n"
"MouseMoveEvent 45 170 0 0 0 0 0\n"
"MouseMoveEvent 45 171 0 0 0 0 0\n"
"MouseMoveEvent 46 172 0 0 0 0 0\n"
"MouseMoveEvent 47 172 0 0 0 0 0\n"
"MouseMoveEvent 48 172 0 0 0 0 0\n"
"MouseMoveEvent 49 172 0 0 0 0 0\n"
"MouseMoveEvent 51 171 0 0 0 0 0\n"
"MouseMoveEvent 52 170 0 0 0 0 0\n"
"MouseMoveEvent 53 169 0 0 0 0 0\n"
"MouseMoveEvent 54 167 0 0 0 0 0\n"
"MouseMoveEvent 56 165 0 0 0 0 0\n"
"MouseMoveEvent 57 163 0 0 0 0 0\n"
"MouseMoveEvent 58 160 0 0 0 0 0\n"
"MouseMoveEvent 59 159 0 0 0 0 0\n"
"MouseMoveEvent 60 157 0 0 0 0 0\n"
"MouseMoveEvent 61 155 0 0 0 0 0\n"
"MouseMoveEvent 62 154 0 0 0 0 0\n"
"MouseMoveEvent 63 152 0 0 0 0 0\n"
"MouseMoveEvent 65 150 0 0 0 0 0\n"
"MouseMoveEvent 66 149 0 0 0 0 0\n"
"MouseMoveEvent 67 148 0 0 0 0 0\n"
"MouseMoveEvent 68 147 0 0 0 0 0\n"
"LeftButtonPressEvent 68 147 0 0 0 0 0\n"
"RenderEvent 68 147 0 0 0 0 0\n"
"MouseMoveEvent 67 148 0 0 0 0 0\n"
"RenderEvent 67 148 0 0 0 0 0\n"
"MouseMoveEvent 66 149 0 0 0 0 0\n"
"RenderEvent 66 149 0 0 0 0 0\n"
"MouseMoveEvent 65 150 0 0 0 0 0\n"
"RenderEvent 65 150 0 0 0 0 0\n"
"MouseMoveEvent 64 151 0 0 0 0 0\n"
"RenderEvent 64 151 0 0 0 0 0\n"
"MouseMoveEvent 64 152 0 0 0 0 0\n"
"RenderEvent 64 152 0 0 0 0 0\n"
"MouseMoveEvent 64 153 0 0 0 0 0\n"
"RenderEvent 64 153 0 0 0 0 0\n"
"MouseMoveEvent 64 154 0 0 0 0 0\n"
"RenderEvent 64 154 0 0 0 0 0\n"
"MouseMoveEvent 64 155 0 0 0 0 0\n"
"RenderEvent 64 155 0 0 0 0 0\n"
"MouseMoveEvent 64 156 0 0 0 0 0\n"
"RenderEvent 64 156 0 0 0 0 0\n"
"MouseMoveEvent 63 157 0 0 0 0 0\n"
"RenderEvent 63 157 0 0 0 0 0\n"
"MouseMoveEvent 63 158 0 0 0 0 0\n"
"RenderEvent 63 158 0 0 0 0 0\n"
"MouseMoveEvent 63 159 0 0 0 0 0\n"
"RenderEvent 63 159 0 0 0 0 0\n"
"MouseMoveEvent 63 160 0 0 0 0 0\n"
"RenderEvent 63 160 0 0 0 0 0\n"
"MouseMoveEvent 63 161 0 0 0 0 0\n"
"RenderEvent 63 161 0 0 0 0 0\n"
"MouseMoveEvent 63 162 0 0 0 0 0\n"
"RenderEvent 63 162 0 0 0 0 0\n"
"MouseMoveEvent 62 163 0 0 0 0 0\n"
"RenderEvent 62 163 0 0 0 0 0\n"
"MouseMoveEvent 62 164 0 0 0 0 0\n"
"RenderEvent 62 164 0 0 0 0 0\n"
"MouseMoveEvent 62 165 0 0 0 0 0\n"
"RenderEvent 62 165 0 0 0 0 0\n"
"LeftButtonReleaseEvent 62 165 0 0 0 0 0\n"
"RenderEvent 62 165 0 0 0 0 0\n"
"MouseMoveEvent 63 166 0 0 0 0 0\n"
"MouseMoveEvent 64 166 0 0 0 0 0\n"
"MouseMoveEvent 66 165 0 0 0 0 0\n"
"MouseMoveEvent 67 165 0 0 0 0 0\n"
"MouseMoveEvent 69 164 0 0 0 0 0\n"
"MouseMoveEvent 71 164 0 0 0 0 0\n"
"MouseMoveEvent 72 163 0 0 0 0 0\n"
"MouseMoveEvent 73 163 0 0 0 0 0\n"
"MouseMoveEvent 74 163 0 0 0 0 0\n"
"MouseMoveEvent 75 163 0 0 0 0 0\n"
"MouseMoveEvent 76 163 0 0 0 0 0\n"
"LeftButtonPressEvent 76 163 0 0 0 0 0\n"
"RenderEvent 76 163 0 0 0 0 0\n"
"MouseMoveEvent 75 163 0 0 0 0 0\n"
"RenderEvent 75 163 0 0 0 0 0\n"
"MouseMoveEvent 74 164 0 0 0 0 0\n"
"RenderEvent 74 164 0 0 0 0 0\n"
"MouseMoveEvent 73 164 0 0 0 0 0\n"
"RenderEvent 73 164 0 0 0 0 0\n"
"MouseMoveEvent 72 164 0 0 0 0 0\n"
"RenderEvent 72 164 0 0 0 0 0\n"
"MouseMoveEvent 71 164 0 0 0 0 0\n"
"RenderEvent 71 164 0 0 0 0 0\n"
"MouseMoveEvent 70 164 0 0 0 0 0\n"
"RenderEvent 70 164 0 0 0 0 0\n"
"MouseMoveEvent 69 164 0 0 0 0 0\n"
"RenderEvent 69 164 0 0 0 0 0\n"
"MouseMoveEvent 68 164 0 0 0 0 0\n"
"RenderEvent 68 164 0 0 0 0 0\n"
"MouseMoveEvent 67 164 0 0 0 0 0\n"
"RenderEvent 67 164 0 0 0 0 0\n"
"LeftButtonReleaseEvent 67 164 0 0 0 0 0\n"
"RenderEvent 67 164 0 0 0 0 0\n"
"MouseMoveEvent 66 163 0 0 0 0 0\n"
"MouseMoveEvent 66 162 0 0 0 0 0\n"
"MouseMoveEvent 66 161 0 0 0 0 0\n"
"MouseMoveEvent 66 160 0 0 0 0 0\n"
"MouseMoveEvent 66 159 0 0 0 0 0\n"
"MouseMoveEvent 67 157 0 0 0 0 0\n"
"MouseMoveEvent 68 155 0 0 0 0 0\n"
"MouseMoveEvent 68 154 0 0 0 0 0\n"
"MouseMoveEvent 70 151 0 0 0 0 0\n"
"MouseMoveEvent 71 148 0 0 0 0 0\n"
"MouseMoveEvent 72 146 0 0 0 0 0\n"
"MouseMoveEvent 73 143 0 0 0 0 0\n"
"MouseMoveEvent 75 137 0 0 0 0 0\n"
"MouseMoveEvent 79 131 0 0 0 0 0\n"
"MouseMoveEvent 84 124 0 0 0 0 0\n"
"MouseMoveEvent 89 118 0 0 0 0 0\n"
"MouseMoveEvent 95 111 0 0 0 0 0\n"
"MouseMoveEvent 101 105 0 0 0 0 0\n"
"MouseMoveEvent 107 99 0 0 0 0 0\n"
"MouseMoveEvent 112 94 0 0 0 0 0\n"
"MouseMoveEvent 118 89 0 0 0 0 0\n"
"MouseMoveEvent 124 84 0 0 0 0 0\n"
"MouseMoveEvent 127 81 0 0 0 0 0\n"
"MouseMoveEvent 131 77 0 0 0 0 0\n"
"MouseMoveEvent 135 73 0 0 0 0 0\n"
"MouseMoveEvent 138 70 0 0 0 0 0\n"
"MouseMoveEvent 140 67 0 0 0 0 0\n"
"MouseMoveEvent 142 64 0 0 0 0 0\n"
"MouseMoveEvent 144 61 0 0 0 0 0\n"
"MouseMoveEvent 145 57 0 0 0 0 0\n"
"MouseMoveEvent 146 54 0 0 0 0 0\n"
"MouseMoveEvent 147 51 0 0 0 0 0\n"
"MouseMoveEvent 148 48 0 0 0 0 0\n"
"MouseMoveEvent 149 44 0 0 0 0 0\n"
"MouseMoveEvent 150 41 0 0 0 0 0\n"
"MouseMoveEvent 151 38 0 0 0 0 0\n"
"MouseMoveEvent 151 37 0 0 0 0 0\n"
"MouseMoveEvent 152 36 0 0 0 0 0\n"
"MouseMoveEvent 152 35 0 0 0 0 0\n"
"MouseMoveEvent 152 34 0 0 0 0 0\n"
"MouseMoveEvent 152 33 0 0 0 0 0\n"
"MouseMoveEvent 151 32 0 0 0 0 0\n"
"MouseMoveEvent 150 31 0 0 0 0 0\n"
"MouseMoveEvent 149 30 0 0 0 0 0\n"
"MouseMoveEvent 148 30 0 0 0 0 0\n"
"MouseMoveEvent 147 30 0 0 0 0 0\n"
"MouseMoveEvent 146 30 0 0 0 0 0\n"
"MouseMoveEvent 144 30 0 0 0 0 0\n"
"MouseMoveEvent 143 29 0 0 0 0 0\n"
"MouseMoveEvent 142 29 0 0 0 0 0\n"
"MouseMoveEvent 141 29 0 0 0 0 0\n"
"MouseMoveEvent 140 30 0 0 0 0 0\n"
"MouseMoveEvent 139 31 0 0 0 0 0\n"
"MouseMoveEvent 138 32 0 0 0 0 0\n"
"MouseMoveEvent 136 33 0 0 0 0 0\n"
"MouseMoveEvent 132 35 0 0 0 0 0\n"
"MouseMoveEvent 128 36 0 0 0 0 0\n"
"MouseMoveEvent 128 35 0 0 0 0 0\n"
"MouseMoveEvent 129 34 0 0 0 0 0\n"
"MouseMoveEvent 131 34 0 0 0 0 0\n"
"MouseMoveEvent 132 34 0 0 0 0 0\n"
"MouseMoveEvent 133 34 0 0 0 0 0\n"
"MouseMoveEvent 135 34 0 0 0 0 0\n"
"MouseMoveEvent 136 34 0 0 0 0 0\n"
"MouseMoveEvent 139 34 0 0 0 0 0\n"
"MouseMoveEvent 141 34 0 0 0 0 0\n"
"MouseMoveEvent 143 34 0 0 0 0 0\n"
"MouseMoveEvent 146 34 0 0 0 0 0\n"
"MouseMoveEvent 149 34 0 0 0 0 0\n"
"MouseMoveEvent 151 34 0 0 0 0 0\n"
"MouseMoveEvent 154 34 0 0 0 0 0\n"
"MouseMoveEvent 157 34 0 0 0 0 0\n"
"MouseMoveEvent 159 34 0 0 0 0 0\n"
"MouseMoveEvent 161 34 0 0 0 0 0\n"
"MouseMoveEvent 162 34 0 0 0 0 0\n"
"MouseMoveEvent 164 34 0 0 0 0 0\n"
"MouseMoveEvent 166 34 0 0 0 0 0\n"
"MouseMoveEvent 168 34 0 0 0 0 0\n"
"MouseMoveEvent 169 34 0 0 0 0 0\n"
"MouseMoveEvent 170 34 0 0 0 0 0\n"
"MouseMoveEvent 171 34 0 0 0 0 0\n"
"MouseMoveEvent 172 34 0 0 0 0 0\n"
"MouseMoveEvent 173 34 0 0 0 0 0\n"
"MouseMoveEvent 174 34 0 0 0 0 0\n"
"MouseMoveEvent 175 34 0 0 0 0 0\n"
"MouseMoveEvent 176 34 0 0 0 0 0\n"
"MouseMoveEvent 177 34 0 0 0 0 0\n"
"MouseMoveEvent 180 34 0 0 0 0 0\n"
"MouseMoveEvent 181 34 0 0 0 0 0\n"
"MouseMoveEvent 183 34 0 0 0 0 0\n"
"MouseMoveEvent 185 34 0 0 0 0 0\n"
"MouseMoveEvent 188 34 0 0 0 0 0\n"
"MouseMoveEvent 192 34 0 0 0 0 0\n"
"MouseMoveEvent 195 34 0 0 0 0 0\n"
"MouseMoveEvent 198 33 0 0 0 0 0\n"
"MouseMoveEvent 201 33 0 0 0 0 0\n"
"MouseMoveEvent 204 33 0 0 0 0 0\n"
"MouseMoveEvent 206 32 0 0 0 0 0\n"
"MouseMoveEvent 208 32 0 0 0 0 0\n"
"MouseMoveEvent 209 32 0 0 0 0 0\n"
"MouseMoveEvent 211 31 0 0 0 0 0\n"
"MouseMoveEvent 213 34 0 0 0 0 0\n"
"MouseMoveEvent 215 36 0 0 0 0 0\n"
"MouseMoveEvent 217 38 0 0 0 0 0\n"
"MouseMoveEvent 221 41 0 0 0 0 0\n"
"MouseMoveEvent 224 45 0 0 0 0 0\n"
"MouseMoveEvent 228 50 0 0 0 0 0\n"
"MouseMoveEvent 232 56 0 0 0 0 0\n"
"MouseMoveEvent 235 62 0 0 0 0 0\n"
"MouseMoveEvent 238 69 0 0 0 0 0\n"
"MouseMoveEvent 241 76 0 0 0 0 0\n"
"MouseMoveEvent 244 83 0 0 0 0 0\n"
"MouseMoveEvent 246 90 0 0 0 0 0\n"
"MouseMoveEvent 249 97 0 0 0 0 0\n"
"MouseMoveEvent 251 103 0 0 0 0 0\n"
"MouseMoveEvent 253 110 0 0 0 0 0\n"
"MouseMoveEvent 254 116 0 0 0 0 0\n"
"MouseMoveEvent 257 123 0 0 0 0 0\n"
"MouseMoveEvent 258 130 0 0 0 0 0\n"
"MouseMoveEvent 260 137 0 0 0 0 0\n"
"MouseMoveEvent 261 144 0 0 0 0 0\n"
"MouseMoveEvent 262 150 0 0 0 0 0\n"
"MouseMoveEvent 263 157 0 0 0 0 0\n"
"MouseMoveEvent 264 164 0 0 0 0 0\n"
"MouseMoveEvent 265 171 0 0 0 0 0\n"
"MouseMoveEvent 266 176 0 0 0 0 0\n"
"MouseMoveEvent 267 182 0 0 0 0 0\n"
"MouseMoveEvent 267 187 0 0 0 0 0\n"
"MouseMoveEvent 268 193 0 0 0 0 0\n"
"MouseMoveEvent 268 200 0 0 0 0 0\n"
"MouseMoveEvent 268 205 0 0 0 0 0\n"
"MouseMoveEvent 268 211 0 0 0 0 0\n"
"MouseMoveEvent 268 217 0 0 0 0 0\n"
"MouseMoveEvent 268 223 0 0 0 0 0\n"
"MouseMoveEvent 268 229 0 0 0 0 0\n"
"MouseMoveEvent 268 235 0 0 0 0 0\n"
"MouseMoveEvent 268 241 0 0 0 0 0\n"
"MouseMoveEvent 268 245 0 0 0 0 0\n"
"MouseMoveEvent 268 249 0 0 0 0 0\n"
"MouseMoveEvent 269 252 0 0 0 0 0\n"
"MouseMoveEvent 269 255 0 0 0 0 0\n"
"MouseMoveEvent 270 257 0 0 0 0 0\n"
"MouseMoveEvent 270 259 0 0 0 0 0\n"
"MouseMoveEvent 271 261 0 0 0 0 0\n"
"MouseMoveEvent 271 263 0 0 0 0 0\n"
"MouseMoveEvent 271 264 0 0 0 0 0\n"
"MouseMoveEvent 272 266 0 0 0 0 0\n"
"MouseMoveEvent 272 267 0 0 0 0 0\n"
"MouseMoveEvent 272 268 0 0 0 0 0\n"
"MouseMoveEvent 272 269 0 0 0 0 0\n"
"MouseMoveEvent 272 270 0 0 0 0 0\n"
"MouseMoveEvent 272 271 0 0 0 0 0\n"
"MouseMoveEvent 273 272 0 0 0 0 0\n"
"MouseMoveEvent 273 273 0 0 0 0 0\n"
"MouseMoveEvent 273 274 0 0 0 0 0\n"
"MouseMoveEvent 273 277 0 0 0 0 0\n"
"MouseMoveEvent 274 279 0 0 0 0 0\n"
"MouseMoveEvent 275 282 0 0 0 0 0\n"
"MouseMoveEvent 276 285 0 0 0 0 0\n"
"MouseMoveEvent 276 287 0 0 0 0 0\n"
"MouseMoveEvent 277 289 0 0 0 0 0\n"
"MouseMoveEvent 278 291 0 0 0 0 0\n"
"MouseMoveEvent 278 292 0 0 0 0 0\n"
"MouseMoveEvent 278 294 0 0 0 0 0\n"
"MouseMoveEvent 279 295 0 0 0 0 0\n"
"MouseMoveEvent 280 298 0 0 0 0 0\n"
"LeaveEvent 280 300 0 0 0 0 0\n"
"ExitEvent 280 300 0 0 0 0 0\n"
"EnterEvent 289 298 0 0 0 0 0\n"
"MouseMoveEvent 289 298 0 0 0 0 0\n"
"MouseMoveEvent 289 294 0 0 0 0 0\n"
"MouseMoveEvent 290 290 0 0 0 0 0\n"
"MouseMoveEvent 291 287 0 0 0 0 0\n"
"MouseMoveEvent 292 284 0 0 0 0 0\n"
"MouseMoveEvent 293 281 0 0 0 0 0\n"
"MouseMoveEvent 293 278 0 0 0 0 0\n"
"MouseMoveEvent 295 274 0 0 0 0 0\n"
"MouseMoveEvent 296 269 0 0 0 0 0\n"
"MouseMoveEvent 298 264 0 0 0 0 0\n"
"LeaveEvent 300 258 0 0 0 0 0\n"
;

//----------------------------------------------------------------------------
class vtkImageCroppingRegionsWidgetCallback : public vtkCommand
{
public:
  static vtkImageCroppingRegionsWidgetCallback *New()
  {
    return new vtkImageCroppingRegionsWidgetCallback;
  }

  void Execute( vtkObject *caller, unsigned long vtkNotUsed( event ),
    void* vtkNotUsed(callData) )
  {
    vtkImageCroppingRegionsWidget* self =
      reinterpret_cast< vtkImageCroppingRegionsWidget* >( caller );
    if(!self)
    {
      return;
    }

    double* pp = Widget->GetPlanePositions();
    extractVOI->SetVOI(
      static_cast<int>(pp[0]/spacing[0]),
      static_cast<int>(pp[1]/spacing[0]),
      static_cast<int>(pp[2]/spacing[1]),
      static_cast<int>(pp[3]/spacing[1]),
      static_cast<int>(pp[4]/spacing[2]),
      static_cast<int>(pp[5]/spacing[2]) );
    extractVOI->Update();
    ren->ResetCamera();
  }

  vtkImageCroppingRegionsWidget* Widget;
  vtkExtractVOI* extractVOI;
  double* spacing;
  vtkRenderer* ren;
};

//----------------------------------------------------------------------------
int TestImageCroppingRegionsWidget( int argc, char *argv[] )
{
  char* fname = vtkTestUtilities::ExpandDataFileName(argc, argv, "Data/headsq/quarter");

  double spacing[] = { 3.2, 3.2, 1.5 };
  vtkSmartPointer<vtkVolume16Reader> v16 =
    vtkSmartPointer<vtkVolume16Reader>::New();
  v16->SetDataDimensions(64,64);
  v16->SetDataByteOrderToLittleEndian();
  v16->SetImageRange( 42, 43);
  v16->SetDataSpacing( spacing );
  v16->SetFilePrefix( fname );
  v16->SetDataMask( 0x7fff);
  v16->Update();

  vtkSmartPointer<vtkImageData> im = v16->GetOutput();

  delete[] fname;

  // Create the RenderWindow, Renderer and both Actors
  double leftViewPort[4] = {0.0, 0.0, 0.5, 1.0};
  double rightViewPort[4] = {0.5, 0.0, 1.0, 1.0};

  vtkSmartPointer<vtkRenderer> leftRenderer =
    vtkSmartPointer<vtkRenderer>::New();
  vtkSmartPointer<vtkRenderer> rightRenderer =
    vtkSmartPointer<vtkRenderer>::New();
  vtkSmartPointer<vtkRenderWindow> renWin =
    vtkSmartPointer<vtkRenderWindow>::New();
  renWin->SetSize(300, 300);
  renWin->SetMultiSamples(0);
  renWin->AddRenderer(leftRenderer);
  leftRenderer->SetViewport(leftViewPort);
  leftRenderer->SetBackground(0.1, 0.2, 0.4);
  renWin->AddRenderer(rightRenderer);
  rightRenderer->SetViewport(rightViewPort);
  rightRenderer->SetBackground(0.4, 0.5, 0.6);

  vtkSmartPointer<vtkRenderWindowInteractor> iren =
    vtkSmartPointer<vtkRenderWindowInteractor>::New();
  iren->SetRenderWindow(renWin);

  vtkSmartPointer<vtkInteractorStyleTrackballCamera> style =
    vtkSmartPointer<vtkInteractorStyleTrackballCamera>::New();
  iren->SetInteractorStyle(style);

  // Create a test pipeline
  //
  vtkSmartPointer<vtkSmartVolumeMapper> mapper =
    vtkSmartPointer<vtkSmartVolumeMapper>::New();
  mapper->SetBlendModeToComposite();
  mapper->SetInputData(im);

  vtkSmartPointer<vtkVolumeProperty> volumeProperty =
    vtkSmartPointer<vtkVolumeProperty>::New();
  volumeProperty->ShadeOff();
  volumeProperty->SetInterpolationType(VTK_LINEAR_INTERPOLATION);

  vtkSmartPointer<vtkVolume> volume =
    vtkSmartPointer<vtkVolume>::New();
  volume->SetMapper(mapper);
  volume->SetProperty(volumeProperty);

  double pos[] = { 0,40,0,50,0,0 };

  vtkSmartPointer<vtkExtractVOI> extractVOI =
    vtkSmartPointer<vtkExtractVOI>::New();
  extractVOI->SetInputConnection(v16->GetOutputPort());
  extractVOI->SetVOI(
    static_cast<int>(pos[0]/spacing[0]),
    static_cast<int>(pos[1]/spacing[0]),
    static_cast<int>(pos[2]/spacing[1]),
    static_cast<int>(pos[3]/spacing[1]),
    static_cast<int>(pos[4]/spacing[2]),
    static_cast<int>(pos[5]/spacing[2]) );

  // Create the widget
  vtkSmartPointer<vtkImageCroppingRegionsWidget> widget =
    vtkSmartPointer<vtkImageCroppingRegionsWidget>::New();
  widget->SetInputConnection(v16->GetOutputPort());
  widget->SetInteractor(iren);
  widget->SetVolumeMapper(mapper);
  widget->SetDefaultRenderer(leftRenderer);
  widget->SetSliceOrientationToXY();
  widget->SetPlanePositions(pos);
  widget->SetLine1Color(1,0,0);
  widget->SetLine2Color(0,1,0.1);
  widget->SetLine3Color(0,0.1,1);
  widget->SetLine4Color(1,1,0.1);
  widget->SetCroppingRegionFlags( 4 );

  vtkSmartPointer<vtkImageCroppingRegionsWidgetCallback> cbk =
    vtkSmartPointer<vtkImageCroppingRegionsWidgetCallback>::New();
  cbk->Widget = widget;
  cbk->extractVOI = extractVOI;
  cbk->spacing = spacing;
  cbk->ren = rightRenderer;
  widget->AddObserver( vtkImageCroppingRegionsWidget::CroppingPlanesPositionChangedEvent, cbk );

  // Print the widget
  widget->Print(cout);

  vtkSmartPointer<vtkImageActor> extractedActor =
    vtkSmartPointer<vtkImageActor>::New();
  extractedActor->GetMapper()->SetInputConnection(
    extractVOI->GetOutputPort());
  extractedActor->PickableOff();

  // Add the actors to the renderer, set the background and size
  leftRenderer->AddViewProp(volume);
  rightRenderer->AddActor(extractedActor);

  // render the image
  //
  widget->On();
  renWin->Render();
  leftRenderer->ResetCamera();
  rightRenderer->ResetCamera();
  iren->Initialize();

  return vtkTesting::InteractorEventLoop(
    argc, argv, iren, TestImageCroppingRegionsWidgetLog );
}
