<?php

final class PhabricatorCalendarExportNameTransaction
  extends PhabricatorCalendarExportTransactionType {

  const TRANSACTIONTYPE = 'calendar.export.name';

  public function generateOldValue($object) {
    return $object->getName();
  }

  public function applyInternalEffects($object, $value) {
    $object->setName($value);
  }

  public function getTitle() {
    return pht(
      '%s renamed this export from %s to %s.',
      $this->renderAuthor(),
      $this->renderOldValue(),
      $this->renderNewValue());
  }

  public function validateTransactions($object, array $xactions) {
    $errors = array();

    if ($this->isEmptyTextTransaction($object->getName(), $xactions)) {
      $errors[] = $this->newRequiredError(
        pht('Calendar exports must have a name.'));
    }

    return $errors;
  }

}
