# - Find OpenSSL crypto library
# Find OpenSSL crypto includes and library
#
#  OPENSSLCRYPTO_INCLUDE_DIR - OpenSSL include directory
#  OPENSSLCRYPTO_LIBRARIES   - OpenSSL crypto libraries
#  OPENSSLCRYPTO_FOUND       - True if OpenSSL crypto library was found


IF (OPENSSLCRYPTO_LIBRARIES)
   # Already in cache, be silent.
   SET(OPENSSLCRYPTO_FIND_QUIETLY TRUE)
ENDIF (OPENSSLCRYPTO_LIBRARIES)

FIND_PATH(OPENSSLCRYPTO_INCLUDE_DIR openssl/ssl.h)

IF(WIN32 AND MSVC)
   SET(OPENSSLCRYPTO_NAMES libeay32MD eay libeay32)
ELSE(WIN32 AND MSVC)
   SET(OPENSSLCRYPTO_NAMES crypto eay libeay32 libeay32MD)
ENDIF(WIN32 AND MSVC)

FIND_LIBRARY(OPENSSLCRYPTO_LIBRARY NAMES ${OPENSSLCRYPTO_NAMES} )

# Handle the QUIETLY and REQUIRED arguments and set OPENSSLCRYPTO_FOUND to
# TRUE if all listed variables are TRUE.
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(OpenSSLCrypto DEFAULT_MSG OPENSSLCRYPTO_LIBRARY OPENSSLCRYPTO_INCLUDE_DIR)

IF(OPENSSLCRYPTO_FOUND)
  SET( OPENSSLCRYPTO_LIBRARIES ${OPENSSLCRYPTO_LIBRARY} )
ELSE(OPENSSLCRYPTO_FOUND)
  SET( OPENSSLCRYPTO_LIBRARIES )
ENDIF(OPENSSLCRYPTO_FOUND)

MARK_AS_ADVANCED( OPENSSLCRYPTO_LIBRARY OPENSSLCRYPTO_INCLUDE_DIR )
