% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markdown.R
\name{macros}
\alias{macros}
\alias{Biocpkg}
\alias{Biocbook}
\alias{Biocannopkg}
\alias{Biocexptpkg}
\alias{CRANpkg}
\alias{Rpackage}
\alias{Githubpkg}
\title{Link to packages on Bioconductor, CRAN and GitHub}
\usage{
Biocpkg(pkg, vignette = NULL, label = NULL)

Biocbook(pkg, label = NULL)

Biocannopkg(pkg)

Biocexptpkg(pkg)

CRANpkg(pkg)

Rpackage(pkg)

Githubpkg(repo, pkg)
}
\arguments{
\item{pkg}{character(1), package name}

\item{vignette}{character(1), basename of vignette link, including
html or pdf extension, e.g., "work-0-intro.html".}

\item{label}{character(1) label used to identify the package or
vignette. If \code{NULL}, defaults to \code{pkg}.}

\item{repo}{Repository address in the format username/repo[/subdir]}
}
\value{
Markdown-formatted character vector containing a
    hyperlinked package name. If \code{vignette != NULL}, the
    address of the specified vignette is returned.
}
\description{
Functions for adding links to Bioconductor, CRAN and GitHub packages into R
Markdown documents.
}
\details{
Use \code{Biocpkg} for Bioconductor software, annotation,
experiment data, and workflow packages. When \code{vignette=NULL},
the function automatically includes a link to the package landing
page, the version of which depends on the current Bioconductor
version (i.e. if run in a devel environment, it will point towards
the devel landing page; otherwise it will point to the release
landing page).

Use \code{Biocbook} for Bioconductor webbooks. This will create a
link to the index page of the book rather than to the landing page
of the package used for the book's deployment.

Use \code{CRANpkg} for R packages available on CRAN. The function
automatically includes a link to the master CRAN landing page.

Use \code{Githubpkg} for R packages available on GitHub. The \code{repo}
should include the repository address in the format username/repo[/subdir].
If \code{package} is missing, the package name is assumed to be equal the
repository name and is extracted from \code{repo}.

For R packages which are not available on Bioconductor, CRAN or GitHub, use
\code{Rpackage}.
}
\examples{


## link to a Bioconductor software package
Biocpkg("IRanges")

## link to a Bioconductor annotation package
Biocpkg("org.Mm.eg.db")

## link to a Bioconductor experiment data package
Biocpkg("affydata")

## link to a Bioconductor workflow
Biocpkg("simpleSingleCell")
Biocpkg(
    "simpleSingleCell",
    vignette = "work-0-intro.html",
    label = "Episode 1: analyzing scRNA-seq data with R/Bioconductor"
)

## link to a CRAN package
CRANpkg("data.table")

## link to an R package on GitHub
Githubpkg("rstudio/rmarkdown")

}
\author{
Andrzej Oleś <andrzej.oles@embl.de>, 2014-2015
}
