% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFactors.R
\name{plotFactorScatter}
\alias{plotFactorScatter}
\title{Scatterplot of two latent factors}
\usage{
plotFactorScatter(object, factors, color_by = NULL, shape_by = NULL,
  name_color = "", name_shape = "", dot_size = 1.5, dot_alpha = 1,
  showMissing = TRUE)
}
\arguments{
\item{object}{a trained \code{\link{MOFAmodel}} object.}

\item{factors}{a vector of length two with the factors to plot.
Factors can be specified either as a characters using the factor names,
 or as numeric with the index of the factors}

\item{color_by}{specifies groups or values used to color the samples. 
This can be either 
a character giving the name of a feature present in the training data, 
a character giving the same of a covariate (only if using \code{\link{MultiAssayExperiment}} as input), 
or a vector of the same length as the number of samples specifying
 discrete groups or continuous numeric values.}

\item{shape_by}{specifies groups or values used to shape the samples. 
This can be either
a character giving the name of a feature present in the training data, 
a character giving the same of a covariate (only if using \code{\link{MultiAssayExperiment}} as input), 
or a vector of the same length as the number of samples specifying discrete groups.}

\item{name_color}{name for color legend.}

\item{name_shape}{name for shape legend.}

\item{dot_size}{dot size (default is 1.5).}

\item{dot_alpha}{dot transparency (default is 1.0, no transparency).}

\item{showMissing}{logical indicating whether to include samples for which
\code{shape_by} or \code{color_by} is missing.}
}
\value{
Returns a \code{ggplot2} object
}
\description{
Scatterplot of the values of two latent factors.
}
\details{
One of the first steps for the annotation of factors is to
 visualise and group/color them using known covariates such as phenotypic or clinical data.
This method generates a single scatterplot for the combination of two latent factors.
Similar functions are \code{\link{plotFactorScatters}} for doing multiple scatter plots and 
\code{\link{plotFactorBeeswarm}} for doing Beeswarm plots for single factors.
}
\examples{
# Example on the CLL data
filepath <- system.file("extdata", "CLL_model.hdf5", package = "MOFAdata")
MOFA_CLL <- loadModel(filepath)
plotFactorScatter(MOFA_CLL, factors=1:2)
plotFactorScatter(MOFA_CLL, factors=1:2, color_by= "IGHV", shape_by="trisomy12", showMissing=FALSE)

# Example on the scMT data
filepath <- system.file("extdata", "scMT_model.hdf5", package = "MOFAdata")
MOFA_scMT <- loadModel(filepath)
plotFactorScatter(MOFA_scMT, factors=c(1,3))
}
