% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/502-readPDB.R
\name{readPDB}
\alias{readPDB}
\title{Read Protein Sequences in PDB Format}
\usage{
readPDB(file = system.file("protseq/4HHB.pdb", package = "Rcpi"))
}
\arguments{
\item{file}{The name of the file which the sequences in PDB format are
to be read from. If it does not contain an absolute or
relative path, the file name is relative to the current
working directory, \code{\link{getwd}}.
The default here is to read the \code{4HHB.PDB} file which
is present in the \code{protseq} directory of the Rcpi package.}
}
\value{
A character vector, representing the amino acid sequence
of the single-letter code.
}
\description{
Read Protein Sequences in PDB Format
}
\details{
This function reads protein sequences in PDB (Protein Data Bank) format,
and return the amino acid sequences represented by single-letter code.
}
\examples{
Seq4HHB = readPDB(system.file('protseq/4HHB.pdb', package = 'Rcpi'))
Seq4HHB
}
\references{
Protein Data Bank Contents Guide: Atomic Coordinate Entry Format Description,
Version 3.30. Accessed 2013-06-26.
\url{https://files.wwpdb.org/pub/pdb/doc/format_descriptions/Format_v33_Letter.pdf}
}
\seealso{
See \code{\link{readFASTA}} for reading protein sequences
in FASTA format.
}
