% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bingroup-tidiers.R
\name{tidy.binWidth}
\alias{tidy.binWidth}
\alias{binwidth_tidiers}
\title{Tidy a(n) binWidth object}
\usage{
\method{tidy}{binWidth}(x, ...)
}
\arguments{
\item{x}{A \code{\link[binGroup:binWidth]{binGroup::binWidth()}} object.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{

if (requireNamespace("binGroup", quietly = TRUE)) {

library(binGroup)
library(dplyr)
library(ggplot2)

bw <- binWidth(100, .1)
bw
tidy(bw)

}

}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[binGroup:binWidth]{binGroup::binWidth()}}

Other bingroup tidiers: 
\code{\link{glance.binDesign}()},
\code{\link{tidy.binDesign}()}
}
\concept{bingroup tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{alternative}{Alternative hypothesis (character).}
  \item{ci.width}{Expected width of confidence interval.}
  \item{p}{True proportion.}
  \item{n}{Total sample size}

}
