% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_node_position.R
\name{set_node_position}
\alias{set_node_position}
\title{Apply a layout position to a single node}
\usage{
set_node_position(graph, node, x, y, use_labels = FALSE)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{node}{A single-length vector containing either a node ID value
(integer) or a node label (character) for which position information should
be applied.}

\item{x}{The x coordinate to set for the node.}

\item{y}{The y coordinate to set for the node.}

\item{use_labels}{An option to use a node \code{label} value in \code{node}. Note that
this is only possible if all nodes have distinct \code{label} values set and
none exist as an NA value.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
Apply position information for a single node. This is done by setting the \code{x}
and \code{y} attrs for a node \code{id} or node \code{label} supplied in \code{node}. When
rendering the graph, nodes with attribute values set for \code{x} and \code{y} will be
fixed to those positions on the graph canvas.
}
\examples{
# Create a simple graph with 4 nodes
graph <-
  create_graph() \%>\%
  add_node(label = "one") \%>\%
  add_node(label = "two") \%>\%
  add_node(label = "three") \%>\%
  add_node(label = "four")

# Add position information to each of
# the graph's nodes
graph <-
  graph \%>\%
  set_node_position(
    node = 1,
    x = 1, y = 1) \%>\%
  set_node_position(
    node = 2,
    x = 2, y = 2) \%>\%
  set_node_position(
    node = 3,
    x = 3, y = 3) \%>\%
  set_node_position(
    node = 4,
    x = 4, y = 4)

# View the graph's node data frame to
# verify that the `x` and `y` node
# attributes are available and set to
# the values provided
graph \%>\% get_node_df()

# The same function can modify the data
# in the `x` and `y` attributes
graph <-
  graph \%>\%
  set_node_position(
    node = 1,
    x = 1, y = 4) \%>\%
  set_node_position(
    node = 2,
    x = 3, y = 3) \%>\%
  set_node_position(
    node = 3,
    x = 3, y = 2) \%>\%
  set_node_position(
    node = 4,
    x = 4, y = 1)

# View the graph's node data frame
graph \%>\% get_node_df()

# Position changes can also be made by
# supplying a node `label` value (and setting
# `use_labels` to TRUE). For this to work,
# all `label` values in the graph's ndf must
# be unique and non-NA
graph <-
  graph \%>\%
  set_node_position(
    node = "one",
    x = 1, y = 1,
    use_labels = TRUE) \%>\%
  set_node_position(
    node = "two",
    x = 2, y = 2,
    use_labels = TRUE)

# View the graph's node data frame
graph \%>\% get_node_df()

}
\seealso{
Other node creation and removal: 
\code{\link{add_n_node_clones}()},
\code{\link{add_n_nodes}()},
\code{\link{add_n_nodes_ws}()},
\code{\link{add_node}()},
\code{\link{add_node_clones_ws}()},
\code{\link{add_node_df}()},
\code{\link{add_nodes_from_df_cols}()},
\code{\link{add_nodes_from_table}()},
\code{\link{colorize_node_attrs}()},
\code{\link{copy_node_attrs}()},
\code{\link{create_node_df}()},
\code{\link{delete_node}()},
\code{\link{delete_nodes_ws}()},
\code{\link{drop_node_attrs}()},
\code{\link{join_node_attrs}()},
\code{\link{layout_nodes_w_string}()},
\code{\link{mutate_node_attrs}()},
\code{\link{mutate_node_attrs_ws}()},
\code{\link{node_data}()},
\code{\link{recode_node_attrs}()},
\code{\link{rename_node_attrs}()},
\code{\link{rescale_node_attrs}()},
\code{\link{set_node_attr_to_display}()},
\code{\link{set_node_attr_w_fcn}()},
\code{\link{set_node_attrs}()},
\code{\link{set_node_attrs_ws}()}
}
\concept{node creation and removal}
