% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_stat_chisq.R
\name{chisq_to_phi}
\alias{chisq_to_phi}
\alias{chisq_to_cohens_w}
\alias{chisq_to_cramers_v}
\alias{chisq_to_tschuprows_t}
\alias{chisq_to_fei}
\alias{chisq_to_pearsons_c}
\alias{phi_to_chisq}
\title{Convert \eqn{\chi^2} to \eqn{\phi} and Other Correlation-like Effect Sizes}
\usage{
chisq_to_phi(
  chisq,
  n,
  nrow = 2,
  ncol = 2,
  adjust = TRUE,
  ci = 0.95,
  alternative = "greater",
  ...
)

chisq_to_cohens_w(
  chisq,
  n,
  nrow,
  ncol,
  p,
  ci = 0.95,
  alternative = "greater",
  ...
)

chisq_to_cramers_v(
  chisq,
  n,
  nrow,
  ncol,
  adjust = TRUE,
  ci = 0.95,
  alternative = "greater",
  ...
)

chisq_to_tschuprows_t(
  chisq,
  n,
  nrow,
  ncol,
  adjust = TRUE,
  ci = 0.95,
  alternative = "greater",
  ...
)

chisq_to_fei(chisq, n, nrow, ncol, p, ci = 0.95, alternative = "greater", ...)

chisq_to_pearsons_c(
  chisq,
  n,
  nrow,
  ncol,
  ci = 0.95,
  alternative = "greater",
  ...
)

phi_to_chisq(phi, n, ...)
}
\arguments{
\item{chisq}{The \eqn{\chi^2} (chi-square) statistic.}

\item{n}{Total sample size.}

\item{nrow, ncol}{The number of rows/columns in the contingency table.}

\item{adjust}{Should the effect size be corrected for small-sample bias?
Defaults to \code{TRUE}; Advisable for small samples and large tables.}

\item{ci}{Confidence Interval (CI) level}

\item{alternative}{a character string specifying the alternative hypothesis;
Controls the type of CI returned: \code{"greater"} (default) or \code{"less"}
(one-sided CI), or \code{"two.sided"} (two-sided CI). Partial matching is
allowed (e.g., \code{"g"}, \code{"l"}, \code{"two"}...). See \emph{One-Sided CIs} in
\link{effectsize_CIs}.}

\item{...}{Arguments passed to or from other methods.}

\item{p}{Vector of expected values. See \code{\link[stats:chisq.test]{stats::chisq.test()}}.}

\item{phi}{The \eqn{\phi} (phi) statistic.}
}
\value{
A data frame with the effect size(s), and confidence interval(s). See
\code{\link[=cramers_v]{cramers_v()}}.
}
\description{
Convert between \eqn{\chi^2} (chi-square), \eqn{\phi} (phi), Cramer's
\eqn{V}, Tschuprow's \eqn{T}, Cohen's \eqn{w},
\ifelse{latex}{\eqn{Fei}}{פ (Fei)} and Pearson's \eqn{C} for contingency
tables or goodness of fit.
}
\details{
These functions use the following formulas:

\deqn{\phi = w = \sqrt{\chi^2 / n}}{phi = w = sqrt(\frac{\chi^2}{n})}
\ifelse{latex}{
\deqn{\textrm{Cramer's } V = \phi / \sqrt{\min(\textit{nrow}, \textit{ncol}) - 1}}
}{
\deqn{\textrm{Cramer's } V = \phi / \sqrt{\min(\textit{nrow}, \textit{ncol}) - 1}}{Cramer's V = \phi / sqrt(min(nrow, ncol) - 1)}
}

\ifelse{latex}{
\deqn{\textrm{Tschuprow's } T = \phi / \sqrt[4]{(\textit{nrow} - 1) \times (\textit{ncol} - 1)}}
}{
\deqn{\textrm{Tschuprow's } T = \phi / \sqrt[4]{(\textit{nrow} - 1) \times (\textit{ncol} - 1)}}{Tschuprow's T = \phi / sqrt(sqrt((nrow-1) * (ncol-1)))}
}

\ifelse{latex}{
\deqn{\textit{Fei} = \phi / \sqrt{[1 / \min(p_E)] - 1}}
}{
\deqn{פ = \phi / \sqrt{[1 / \min(p_E)] - 1}}{פ = w / sqrt(1 / min(p_E) - 1))}
}
Where \eqn{p_E} are the expected probabilities.

\deqn{\textrm{Pearson's } C = \sqrt{\chi^2 / (\chi^2 + n)}}{Pearson's C = sqrt(\chi^2 / (\chi^2 + n))}

For versions adjusted for small-sample bias of \eqn{\phi}, \eqn{V}, and \eqn{T},
see \href{https://en.wikipedia.org/wiki/Cram\%C3\%A9r\%27s_V#Bias_correction}{Bergsma, 2013}.
}
\section{Confidence (Compatibility) Intervals (CIs)}{
Unless stated otherwise, confidence (compatibility) intervals (CIs) are
estimated using the noncentrality parameter method (also called the "pivot
method"). This method finds the noncentrality parameter ("\emph{ncp}") of a
noncentral \emph{t}, \emph{F}, or \eqn{\chi^2} distribution that places the observed
\emph{t}, \emph{F}, or \eqn{\chi^2} test statistic at the desired probability point of
the distribution. For example, if the observed \emph{t} statistic is 2.0, with 50
degrees of freedom, for which cumulative noncentral \emph{t} distribution is \emph{t} =
2.0 the .025 quantile (answer: the noncentral \emph{t} distribution with \emph{ncp} =
.04)? After estimating these confidence bounds on the \emph{ncp}, they are
converted into the effect size metric to obtain a confidence interval for the
effect size (Steiger, 2004).
\cr\cr
For additional details on estimation and troubleshooting, see \link{effectsize_CIs}.
}

\section{CIs and Significance Tests}{
"Confidence intervals on measures of effect size convey all the information
in a hypothesis test, and more." (Steiger, 2004). Confidence (compatibility)
intervals and p values are complementary summaries of parameter uncertainty
given the observed data. A dichotomous hypothesis test could be performed
with either a CI or a p value. The 100 (1 - \eqn{\alpha})\% confidence
interval contains all of the parameter values for which \emph{p} > \eqn{\alpha}
for the current data and model. For example, a 95\% confidence interval
contains all of the values for which p > .05.
\cr\cr
Note that a confidence interval including 0 \emph{does not} indicate that the null
(no effect) is true. Rather, it suggests that the observed data together with
the model and its assumptions combined do not provided clear evidence against
a parameter value of 0 (same as with any other value in the interval), with
the level of this evidence defined by the chosen \eqn{\alpha} level (Rafi &
Greenland, 2020; Schweder & Hjort, 2016; Xie & Singh, 2013). To infer no
effect, additional judgments about what parameter values are "close enough"
to 0 to be negligible are needed ("equivalence testing"; Bauer & Kiesser,
1996).
}

\section{Plotting with \code{see}}{

The \code{see} package contains relevant plotting functions. See the \href{https://easystats.github.io/see/articles/effectsize.html}{plotting vignette in the \code{see} package}.
}

\examples{

data("Music_preferences")

# chisq.test(Music_preferences)
#>
#> 	Pearson's Chi-squared test
#>
#> data:  Music_preferences
#> X-squared = 95.508, df = 6, p-value < 2.2e-16
#>

chisq_to_cohens_w(95.508,
  n = sum(Music_preferences),
  nrow = nrow(Music_preferences),
  ncol = ncol(Music_preferences)
)




data("Smoking_FASD")

# chisq.test(Smoking_FASD, p = c(0.015, 0.010, 0.975))
#>
#> 	Chi-squared test for given probabilities
#>
#> data:  Smoking_FASD
#> X-squared = 7.8521, df = 2, p-value = 0.01972

chisq_to_fei(
  7.8521,
  n = sum(Smoking_FASD),
  nrow = 1,
  ncol = 3,
  p = c(0.015, 0.010, 0.975)
)

}
\references{
\itemize{
\item Cohen, J. (1988). Statistical power analysis for the behavioral sciences (2nd Ed.). New York: Routledge.
\item Cumming, G., & Finch, S. (2001). A primer on the understanding, use, and
calculation of confidence intervals that are based on central and noncentral
distributions. Educational and Psychological Measurement, 61(4), 532-574.
\item Ben-Shachar, M.S., Patil, I., Thériault, R., Wiernik, B.M., Lüdecke, D.
(2023). Phi, Fei, Fo, Fum: Effect Sizes for Categorical Data That Use the
Chi‑Squared Statistic. Mathematics, 11, 1982. \doi{10.3390/math11091982}
\item Bergsma, W. (2013). A bias-correction for Cramer's V and Tschuprow's T.
Journal of the Korean Statistical Society, 42(3), 323-328.
\item Johnston, J. E., Berry, K. J., & Mielke Jr, P. W. (2006). Measures of
effect size for chi-squared and likelihood-ratio goodness-of-fit tests.
Perceptual and motor skills, 103(2), 412-414.
\item Rosenberg, M. S. (2010). A generalized formula for converting chi-square
tests to effect sizes for meta-analysis. PloS one, 5(4), e10059.
}
}
\seealso{
\code{\link[=phi]{phi()}} for more details.

Other effect size from test statistic: 
\code{\link{F_to_eta2}()},
\code{\link{t_to_d}()}
}
\concept{effect size from test statistic}
