% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formats.R
\name{suffix}
\alias{suffix}
\title{Formattable object with suffix}
\usage{
suffix(x, suffix = "", sep = "", ..., na.text = NULL)
}
\arguments{
\item{x}{an object}

\item{suffix}{a character vector put behind each non-missing
value in \code{x} as being formatted.}

\item{sep}{separator}

\item{...}{additional parameter passed to \code{formattable}.}

\item{na.text}{text for missing values in \code{x}.}
}
\description{
Formattable object with suffix
}
\examples{
suffix(1:10, "px")
suffix(1:10, ifelse(1:10 >= 2, "units", "unit"), sep = " ")
suffix(c(1:10, NA), "km/h", na.text = "(missing)")
suffix(percent(c(0.1, 0.25)), "*")
}
