source("incl/start.R")

options(future.debug = FALSE)

message("*** withRestart() and muffling ...")

## https://github.com/HenrikBengtsson/future/issues/485
fcn <- function(...) {
  withRestarts({
    cond <- simpleCondition("boom")
    class(cond) <- c("not_me", class(cond))
    signalCondition(cond)
    "success"
  }, muffleSomething = function() {
    message("Condition muffled")
    "weird"
  })
}

message(" - conditions = NULL")
## Disabling relaying conditions works
f <- future(fcn(), conditions = NULL)
v <- value(f)
message("RESULT: ", v)
stopifnot(v == "success")

message(" - split = TRUE")
## Splitting output works
f <- future(fcn(), split = TRUE)
v <- value(f)
message("RESULT: ", v)
stopifnot(v == "success")

message(" - muffleInclude = '^$'")
f <- future(fcn(), conditions = structure("condition", muffleInclude = "^$"))
v <- value(f)
message("RESULT: ", v)
stopifnot(v == "success")

message(" - FIXME")
## FIXME: Ignoring specific condition class 'not_me' does not work
f <- future(fcn(), conditions = structure("condition", exclude = "not_me"))
v <- value(f)
message("RESULT: ", v)
## stopifnot(v == "success")


message("*** withRestart() and muffling ... DONE")

source("incl/end.R")
