% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2ld.R
\name{LDkl}
\alias{LDkl}
\title{LD statistics for two multiallelic markers}
\usage{
LDkl(n1 = 2, n2 = 2, h, n, optrho = 2, verbose = FALSE)
}
\arguments{
\item{n1}{number of alleles at marker 1.}

\item{n2}{number of alleles at marker 2.}

\item{h}{a vector of haplotype frequencies.}

\item{n}{number of haplotypes.}

\item{optrho}{type of contingency table association, 0=Pearson, 1=Tschuprow, 2=Cramer (default).}

\item{verbose}{detailed output of individual statistics.}
}
\value{
The returned value is a list containing:
\itemize{
\item n1 the number of alleles at marker 1.
\item n2 the number of alleles at marker 2.
\item h the haplotype frequency vector.
\item n the number of haplotypes.
\item Dp D'.
\item VarDp variance of D'.
\item Dijtable table of Dij.
\item VarDijtable table of variances for Dij.
\item Dmaxtable table of Dmax.
\item Dijptable table of Dij'.
\item VarDijptable table of variances for Dij'.
\item X2table table of Chi-squares (based on Dij).
\item ptable table of p values.
\item x2 the Chi-squared statistic.
\item seX2 the standard error of x2/n.
\item rho the measure of association.
\item seR the standard error of rho.
\item optrho the method for calculating rho.
\item klinfo the Kullback-Leibler information.
}
}
\description{
LD statistics for two multiallelic loci. For two diallelic makers,
the familiar \eqn{r^2}{r^2} has standard error seX2.
}
\note{
adapted from 2ld.c.
}
\examples{
\dontrun{
# two examples in the C program 2LD:
# two SNPs as in 2by2.dat
# this can be compared with output from LD22

h <- c(0.442356,0.291532,0.245794,0.020319)
n <- 481*2
t <- LDkl(2,2,h,n)
t

# two multiallelic markers as in kbyl.dat
# the two-locus haplotype vector is in file "kbyl.dat"
# The data is now available from 2ld in Haplotype-Analysis

filespec <- system.file("kbyl.dat")
h <- scan(filespec,skip=1)
t <- LDkl(9,5,h,213*2,verbose=TRUE)
}

}
\references{
\insertRef{bishop75}{gap}

\insertRef{cramer46}{gap}

\insertRef{zapata01}{gap}

\insertRef{zhao04}{gap}
}
\seealso{
\code{\link{LD22}}
}
\author{
Jing Hua Zhao
}
\keyword{models}
