% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ipFamily}
\alias{ipFamily}
\title{Check whether an address is IPv4 or IPv6}
\usage{
ipFamily(ip)
}
\arguments{
\item{ip}{A single string representing an IP address.}
}
\value{
For IPv4 addresses, \code{4}; for IPv6 addresses, \code{6}. If the address is
neither, \code{-1}.
}
\description{
Given an IP address, this checks whether it is an IPv4 or IPv6 address.
}
\examples{
ipFamily("127.0.0.1")   # 4
ipFamily("500.0.0.500") # -1
ipFamily("500.0.0.500") # -1

ipFamily("::")          # 6
ipFamily("::1")         # 6
ipFamily("fe80::1ff:fe23:4567:890a") # 6
}
