% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/httpuv.R
\name{startServer}
\alias{startServer}
\alias{startPipeServer}
\title{Create an HTTP/WebSocket server}
\usage{
startServer(host, port, app, quiet = FALSE)

startPipeServer(name, mask, app, quiet = FALSE)
}
\arguments{
\item{host}{A string that is a valid IPv4 address that is owned by this
server, or \code{"0.0.0.0"} to listen on all IP addresses.}

\item{port}{A number or integer that indicates the server port that should be
listened on. Note that on most Unix-like systems including Linux and macOS,
port numbers smaller than 1024 require root privileges.}

\item{app}{A collection of functions that define your application. See
Details.}

\item{quiet}{If \code{TRUE}, suppress error messages from starting app.}

\item{name}{A string that indicates the path for the domain socket (on
Unix-like systems) or the name of the named pipe (on Windows).}

\item{mask}{If non-\code{NULL} and non-negative, this numeric value is used
to temporarily modify the process's umask while the domain socket is being
created. To ensure that only root can access the domain socket, use
\code{strtoi("777", 8)}; or to allow owner and group read/write access, use
\code{strtoi("117", 8)}. If the value is \code{NULL} then the process's
umask is left unchanged. (This parameter has no effect on Windows.)}
}
\value{
A handle for this server that can be passed to
\code{\link{stopServer}} to shut the server down.

A \code{\link{WebServer}} or \code{\link{PipeServer}} object.
}
\description{
Creates an HTTP/WebSocket server on the specified host and port.
}
\details{
\code{startServer} binds the specified port and listens for
connections on an thread running in the background. This background thread
handles the I/O, and when it receives a HTTP request, it will schedule a
call to the user-defined R functions in \code{app} to handle the request.
This scheduling is done with \code{\link[later]{later}()}. When the R call
stack is empty -- in other words, when an interactive R session is sitting
idle at the command prompt -- R will automatically run the scheduled calls.
However, if the call stack is not empty -- if R is evaluating other R code
-- then the callbacks will not execute until either the call stack is
empty, or the \code{\link[later]{run_now}()} function is called. This
function tells R to execute any callbacks that have been scheduled by
\code{\link[later]{later}()}. The \code{\link{service}()} function is
essentially a wrapper for \code{\link[later]{run_now}()}.

In older versions of httpuv (1.3.5 and below), it did not use a background
thread for I/O, and when this function was called, it did not accept
connections immediately. It was necessary to call \code{\link{service}}
repeatedly in order to actually accept and handle connections.

If the port cannot be bound (most likely due to permissions or because it
is already bound), an error is raised.

The application can also specify paths on the filesystem which will be
served from the background thread, without invoking \code{$call()} or
\code{$onHeaders()}. Files served this way will be only use a C++ code,
which is faster than going through R, and will not be blocked when R code
is executing. This can greatly improve performance when serving static
assets.

The \code{app} parameter is where your application logic will be provided
to the server. This can be a list, environment, or reference class that
contains the following methods and fields:

\describe{
\item{\code{call(req)}}{Process the given HTTP request, and return an
HTTP response (see Response Values). This method should be implemented in
accordance with the
\href{https://github.com/jeffreyhorner/Rook/blob/a5e45f751/README.md}{Rook}
specification. Note that httpuv augments \code{req} with an additional
item, \code{req$HEADERS}, which is a named character vector of request
headers.}
\item{\code{onHeaders(req)}}{Optional. Similar to \code{call}, but occurs
when headers are received. Return \code{NULL} to continue normal
processing of the request, or a Rook response to send that response,
stop processing the request, and ask the client to close the connection.
(This can be used to implement upload size limits, for example.)}
\item{\code{onWSOpen(ws)}}{Called back when a WebSocket connection is established.
The given object can be used to be notified when a message is received from
the client, to send messages to the client, etc. See \code{\link{WebSocket}}.}
\item{\code{staticPaths}}{
A named list of paths that will be served without invoking
\code{call()} or \code{onHeaders}. The name of each one is the URL
path, and the value is either a string referring to a local path, or an
object created by the \code{\link{staticPath}} function.
}
\item{\code{staticPathOptions}}{
A set of default options to use when serving static paths. If
not set or \code{NULL}, then it will use the result from calling
\code{\link{staticPathOptions}()} with no arguments.
}
}

The \code{startPipeServer} variant can be used instead of
\code{startServer} to listen on a Unix domain socket or named pipe rather
than a TCP socket (this is not common).
}
\section{Response Values}{


The \code{call} function is expected to return a list containing the
following, which are converted to an HTTP response and sent to the client:

\describe{
\item{\code{status}}{A numeric HTTP status code, e.g. \code{200} or
\code{404L}.}

\item{\code{headers}}{A named list of HTTP headers and their values, as
strings. This can also be missing, an empty list, or \code{NULL}, in which
case no headers (other than the \code{Date} and \code{Content-Length}
headers, as required) will be added.}

\item{\code{body}}{A string (or \code{raw} vector) to be sent as the body
of the HTTP response. This can also be omitted or set to \code{NULL} to
avoid sending any body, which is useful for HTTP \code{1xx}, \code{204},
and \code{304} responses, as well as responses to \code{HEAD} requests.}
}
}

\examples{
\dontrun{
# A very basic application
s <- startServer("0.0.0.0", 5000,
  list(
    call = function(req) {
      list(
        status = 200L,
        headers = list(
          'Content-Type' = 'text/html'
        ),
        body = "Hello world!"
      )
    }
  )
)

s$stop()


# An application that serves static assets at the URL paths /assets and /lib
s <- startServer("0.0.0.0", 5000,
  list(
    call = function(req) {
      list(
        status = 200L,
        headers = list(
          'Content-Type' = 'text/html'
        ),
        body = "Hello world!"
      )
    },
    staticPaths = list(
      "/assets" = "content/assets/",
      "/lib" = staticPath(
        "content/lib",
        indexhtml = FALSE
      ),
      # This subdirectory of /lib should always be handled by the R code path
      "/lib/dynamic" = excludeStaticPath()
    ),
    staticPathOptions = staticPathOptions(
      indexhtml = TRUE
    )
  )
)

s$stop()
}
}
\seealso{
\code{\link{stopServer}}, \code{\link{runServer}},
\code{\link{listServers}}, \code{\link{stopAllServers}}.
}
