% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractFDAFeaturesMethods.R
\name{extractFDAWavelets}
\alias{extractFDAWavelets}
\title{Discrete Wavelet transform features.}
\usage{
extractFDAWavelets(filter = "la8", boundary = "periodic")
}
\arguments{
\item{filter}{(\code{character(1)})\cr
Specifies which filter should be used.
Must be one of \code{d}|\code{la}|\code{bl}|\code{c} followed by an even
number for the level of the filter.
The level of the filter needs to be smaller or equal then the time-series length.
For more information and acceptable filters see \code{help(wt.filter)}.
Defaults to \code{la8}.}

\item{boundary}{(\code{character(1)})\cr
Boundary to be used.
\dQuote{periodic} assumes circular time series,
for \dQuote{reflection} the series is extended to twice its length.
Default is \dQuote{periodic}.}
}
\value{
(\link{data.frame}).
}
\description{
The function extracts discrete wavelet transform coefficients from the raw
functional data.
See \link[wavelets:dwt]{wavelets::dwt} for more information.
}
\seealso{
Other fda_featextractor: 
\code{\link{extractFDABsignal}()},
\code{\link{extractFDADTWKernel}()},
\code{\link{extractFDAFPCA}()},
\code{\link{extractFDAFourier}()},
\code{\link{extractFDAMultiResFeatures}()},
\code{\link{extractFDATsfeatures}()}
}
\concept{fda_featextractor}
