% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFunctionalFeatures.R
\name{getFunctionalFeatures}
\alias{getFunctionalFeatures}
\alias{getFunctionalFeatures.Task}
\alias{getFunctionalFeatures.data.frame}
\title{Get only functional features from a task or a data.frame.}
\usage{
getFunctionalFeatures(object, subset = NULL, features, recode.target = "no")

\method{getFunctionalFeatures}{Task}(object, subset = NULL, features, recode.target = "no")

\method{getFunctionalFeatures}{data.frame}(object, subset = NULL, features, recode.target = "no")
}
\arguments{
\item{object}{(\link{Task}/\link{data.frame})\cr
Object to check on.}

\item{subset}{(\link{integer} | \link{logical} | \code{NULL})\cr
Selected cases. Either a logical or an index vector.
By default \code{NULL} if all observations are used.}

\item{features}{(\link{character} | \link{integer} | \link{logical})\cr
Vector of selected inputs. You can either pass a character vector with the
feature names, a vector of indices, or a logical vector.\cr
In case of an index vector each element denotes the position of the feature
name returned by \link{getTaskFeatureNames}.\cr
Note that the target feature is always included in the
resulting task, you should not pass it here.
Default is to use all features.}

\item{recode.target}{(\code{character(1)})\cr
Should target classes be recoded? Supported are binary and multilabel classification and survival.
Possible values for binary classification are \dQuote{01}, \dQuote{-1+1} and \dQuote{drop.levels}.
In the two latter cases the target vector is converted into a numeric vector.
The positive class is coded as \dQuote{+1} and the negative class either as \dQuote{0} or \dQuote{-1}.
\dQuote{drop.levels} will remove empty factor levels in the target column.
In the multilabel case the logical targets can be converted to factors with \dQuote{multilabel.factor}.
For survival, you may choose to recode the survival times to \dQuote{left}, \dQuote{right} or \dQuote{interval2} censored times
using \dQuote{lcens}, \dQuote{rcens} or \dQuote{icens}, respectively.
See \link[survival:Surv]{survival::Surv} for the format specification.
Default for both binary classification and survival is \dQuote{no} (do nothing).}
}
\value{
Returns a \code{data.frame} containing only the functional features.
}
\description{
The parameters \dQuote{subset}, \dQuote{features}, and \dQuote{recode.target}
are ignored for the data.frame method.
}
