% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeSmallFactorLevels.R
\name{mergeSmallFactorLevels}
\alias{mergeSmallFactorLevels}
\title{Merges small levels of factors into new level.}
\usage{
mergeSmallFactorLevels(
  task,
  cols = NULL,
  min.perc = 0.01,
  new.level = ".merged"
)
}
\arguments{
\item{task}{(\link{Task})\cr
The task.}

\item{cols}{(\link{character})
Which columns to convert.
Default is all factor and character columns.}

\item{min.perc}{(\code{numeric(1)})\cr
The smallest levels of a factor are merged until their combined proportion
w.r.t. the length of the factor exceeds \code{min.perc}.
Must be between 0 and 1.
Default is 0.01.}

\item{new.level}{(\code{character(1)})\cr
New name of merged level.
Default is \dQuote{.merged}}
}
\value{
\code{Task}, where merged levels are combined into a new level of name \code{new.level}.
}
\description{
Merges factor levels that occur only infrequently into combined levels with a higher frequency.
}
\seealso{
Other eda_and_preprocess: 
\code{\link{capLargeValues}()},
\code{\link{createDummyFeatures}()},
\code{\link{dropFeatures}()},
\code{\link{normalizeFeatures}()},
\code{\link{removeConstantFeatures}()},
\code{\link{summarizeColumns}()},
\code{\link{summarizeLevels}()}
}
\concept{eda_and_preprocess}
