

test_that("group2NA() returns the data untouched if vars don't exist", {
  
  data(mtcars)
  expect_equivalent(group2NA(mtcars), mtcars)
  
})

test_that("group2NA() handles simple group var", {
  
  # TODO: are there cases where we wouldn't want to sort by group?
  data(mtcars)
  m <- group2NA(mtcars, "vs")
  expect_true(nrow(m) == 33)
  expect_equivalent(
    as.numeric(m[19, ]),
    c(NA, NA, NA, NA, NA, NA, NA, 0, NA, NA, NA)
  )
  
})

test_that("group2NA() yields the correct result", {
  
  # Yes, this is a saved result 
  # dput(group2NA(mtcars, "vs", "cyl", "id"))
  res <- structure(list(
    mpg = c(26, NA, 22.8, 24.4, 22.8, 32.4, 30.4, 
            33.9, 21.5, 27.3, 30.4, 21.4, 21, 21, 19.7, NA, 21.4, 18.1, 19.2, 
            17.8, 18.7, 14.3, 16.4, 17.3, 15.2, 10.4, 10.4, 14.7, 15.5, 15.2, 
            13.3, 19.2, 15.8, 15), 
    cyl = c(4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
            4, 4, 6, 6, 6, 6, 6, 6, 6, 6, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
            8, 8, 8), 
    disp = c(120.3, NA, 108, 146.7, 140.8, 78.7, 75.7, 
             71.1, 120.1, 79, 95.1, 121, 160, 160, 145, NA, 258, 225, 167.6, 
             167.6, 360, 360, 275.8, 275.8, 275.8, 472, 460, 440, 318, 304, 
             350, 400, 351, 301), 
    hp = c(91, NA, 93, 62, 95, 66, 52, 65, 97, 
           66, 113, 109, 110, 110, 175, NA, 110, 105, 123, 123, 175, 245, 
           180, 180, 180, 205, 215, 230, 150, 150, 245, 175, 264, 335), 
    drat = c(4.43, NA, 3.85, 3.69, 3.92, 4.08, 4.93, 4.22, 3.7, 
             4.08, 3.77, 4.11, 3.9, 3.9, 3.62, NA, 3.08, 2.76, 3.92, 3.92, 
             3.15, 3.21, 3.07, 3.07, 3.07, 2.93, 3, 3.23, 2.76, 3.15, 
             3.73, 3.08, 4.22, 3.54), 
    wt = c(2.14, NA, 2.32, 3.19, 3.15, 
           2.2, 1.615, 1.835, 2.465, 1.935, 1.513, 2.78, 2.62, 2.875, 
           2.77, NA, 3.215, 3.46, 3.44, 3.44, 3.44, 3.57, 4.07, 3.73, 
           3.78, 5.25, 5.424, 5.345, 3.52, 3.435, 3.84, 3.845, 3.17, 
           3.57), 
    qsec = c(16.7, NA, 18.61, 20, 22.9, 19.47, 18.52, 
             19.9, 20.01, 18.9, 16.9, 18.6, 16.46, 17.02, 15.5, NA, 19.44, 
             20.22, 18.3, 18.9, 17.02, 15.84, 17.4, 17.6, 18, 17.98, 17.82, 
             17.42, 16.87, 17.3, 15.41, 17.05, 14.5, 14.6), 
    vs = c(0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 
           0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0), 
    am = c(1, NA, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, NA, 0, 0, 0, 0, 0, 
           0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1), 
    gear = c(5, NA, 4, 4, 4, 4, 4, 4, 3, 4, 5, 4, 4, 4, 5, NA, 3, 3, 4, 4, 3, 3, 
             3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 5, 5), 
    carb = c(2, NA, 1, 2, 2, 1, 2, 1, 1, 1, 2, 2, 4, 4, 6, NA, 1, 1, 4, 4, 2, 4, 
             3, 3, 3, 4, 4, 4, 2, 2, 4, 2, 4, 8), 
    id = c(27L, NA, 3L, 8L, 9L, 18L, 19L, 20L, 21L, 26L, 28L, 32L, 1L, 2L, 30L, 
           NA, 4L, 6L, 10L, 11L, 5L, 7L, 12L, 13L, 14L, 15L, 16L, 17L, 22L, 
           23L, 24L, 25L, 29L, 31L)), 
    .Names = c("mpg", "cyl", "disp", "hp", "drat", "wt", "qsec", "vs", "am", "gear", "carb", "id"), 
    class = "data.frame", 
    row.names = c(NA, 34L))
  
  data(mtcars)
  m <- transform(mtcars, id = seq_len(nrow(mtcars)))
  expect_equivalent(
    group2NA(m, "vs", "cyl", "id"), res
  )
  
})
