% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serializer.R
\name{as_attachment}
\alias{as_attachment}
\title{Return an attachment response}
\usage{
as_attachment(value, filename = NULL)
}
\arguments{
\item{value}{Response value to be saved}

\item{filename}{File name to use when saving the attachment.
If no \code{filename} is provided, the \code{value} will be treated as a regular attachment}
}
\value{
Object with class \code{"plumber_attachment"}
}
\description{
This will set the appropriate fields in the \code{Content-Disposition} header value.
To make sure the attachment is used, be sure your serializer eventually calls \code{serializer_headers}
}
\examples{
\dontrun{
# plumber.R

#' @get /data
#' @serializer csv
function() {
  # will cause the file to be saved as `iris.csv`, not `data` or `data.csv`
  as_attachment(iris, "iris.csv")
}
}
}
