% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_format.R
\name{default_output_format}
\alias{default_output_format}
\title{Determine the default output format for an R Markdown document}
\usage{
default_output_format(input, output_yaml = NULL)
}
\arguments{
\item{input}{Input file (Rmd or plain markdown)}

\item{output_yaml}{Paths to YAML files specifying output formats and their
configurations. The first existing one is used. If none are found, then
the function searches YAML files specified to the \code{output_yaml} top-level
parameter in the YAML front matter, _output.yml or _output.yaml, and then uses
the first existing one.}
}
\value{
A named list with a \code{name} value containing the format
  name and an \code{options} value that is a list containing all the options
  for the format and their values. An option's default value will be returned
  if the option isn't set explicitly in the document.
}
\description{
Read the YAML metadata (and any common output YAML file) for the
document and return the output format that will be generated by
a call to \code{\link{render}}.
}
\details{
This function is useful for front-end tools that require additional
knowledge of the output to be produced by \code{\link{render}} (e.g. to
customize the preview experience).
}
