test_that("Encoding is preserved", {
  ctx <- v8()
  ctx$eval("function I(x){return x;}")
  str_native <- enc2native("\u00C0\u00CB\u00D0")
  str_utf <- enc2utf8("\u00C0\u00CB\u00D0")
  str_sushi <- "\u5BFF\u53F8"
  expect_equal(ctx$call('I', str_native), str_utf)
  expect_equal(ctx$call('I', str_utf), str_utf)
  expect_equal(ctx$call('I', str_sushi), str_sushi)
  ctx$assign('x1', str_native)
  ctx$assign('x2', str_utf)
  ctx$assign('x3', str_sushi)
  expect_equal(ctx$get('x1'), str_utf)
  expect_equal(ctx$get('x2'), str_utf)
  expect_equal(ctx$get('x3'), str_sushi)
  expect_equal(ctx$eval('x1'), str_utf)
  expect_equal(ctx$eval('x2'), str_utf)
  expect_equal(ctx$eval('x3'), str_sushi)
})
