// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2020 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from BulkConfiguration.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.bulkcfg {
  public class BulkConfiguration_1_0_1 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("bulkcfg.BulkConfiguration:1.0.1", null);

    public BulkConfiguration_1_0_1(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public BulkConfiguration_1_0_1(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new BulkConfiguration_1_0_1 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new BulkConfiguration_1_0_1(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public enum Status {
      UNKNOWN,
      UPLOAD_FAILED,
      RESTORE_PENDING,
      RESTORE_OK,
      RESTORE_FAILED,
    }

    public class GetStatusResult {
      public Com.Raritan.Idl.bulkcfg.BulkConfiguration_1_0_1.Status status;
      public System.DateTime timeStamp;
    }

    public GetStatusResult getStatus() {
      JsonObject _parameters = null;
      var _result = RpcCall("getStatus", _parameters);
      var _ret = new GetStatusResult();
      _ret.status = (Com.Raritan.Idl.bulkcfg.BulkConfiguration_1_0_1.Status)(int)_result["status"];
      _ret.timeStamp = new System.DateTime(_result["timeStamp"]);
      return _ret;
    }

    public AsyncRequest getStatus(AsyncRpcResponse<GetStatusResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getStatus(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getStatus(AsyncRpcResponse<GetStatusResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getStatus", _parameters,
        _result => {
          try {
            var _ret = new GetStatusResult();
            _ret.status = (Com.Raritan.Idl.bulkcfg.BulkConfiguration_1_0_1.Status)(int)_result["status"];
            _ret.timeStamp = new System.DateTime(_result["timeStamp"]);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public enum FilterType {
      WHITELIST,
      BLACKLIST,
    }

    public class Filter : ICloneable {
      public object Clone() {
        Filter copy = new Filter();
        copy.name = this.name;
        copy.displayName = this.displayName;
        copy.noOverride = this.noOverride;
        copy.bulkOnly = this.bulkOnly;
        copy.ruleSpecs = this.ruleSpecs;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["name"] = this.name;
        json["displayName"] = this.displayName;
        json["noOverride"] = this.noOverride;
        json["bulkOnly"] = this.bulkOnly;
        json["ruleSpecs"] = new JsonArray(this.ruleSpecs.Select(
          _value => (JsonValue)(_value)));
        return json;
      }

      public static Filter Decode(LightJson.JsonObject json, Agent agent) {
        Filter inst = new Filter();
        inst.name = (string)json["name"];
        inst.displayName = (string)json["displayName"];
        inst.noOverride = (bool)json["noOverride"];
        inst.bulkOnly = (bool)json["bulkOnly"];
        inst.ruleSpecs = new System.Collections.Generic.List<string>(json["ruleSpecs"].AsJsonArray.Select(
          _value => (string)_value));
        return inst;
      }

      public string name = "";
      public string displayName = "";
      public bool noOverride = false;
      public bool bulkOnly = false;
      public System.Collections.Generic.IEnumerable<string> ruleSpecs = new System.Collections.Generic.List<string>();
    }

    public class FilterProfile : ICloneable {
      public object Clone() {
        FilterProfile copy = new FilterProfile();
        copy.name = this.name;
        copy.description = this.description;
        copy.filterNameToTypeMap = this.filterNameToTypeMap;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["name"] = this.name;
        json["description"] = this.description;
        json["filterNameToTypeMap"] = new JsonArray(this.filterNameToTypeMap.Select(_entry => (JsonValue) new JsonObject(new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, LightJson.JsonValue>> {
          new System.Collections.Generic.KeyValuePair<string, JsonValue>("key", _entry.Key),
          new System.Collections.Generic.KeyValuePair<string, JsonValue>("value", (int)_entry.Value)
        })));
        return json;
      }

      public static FilterProfile Decode(LightJson.JsonObject json, Agent agent) {
        FilterProfile inst = new FilterProfile();
        inst.name = (string)json["name"];
        inst.description = (string)json["description"];
        inst.filterNameToTypeMap = DictionaryHelper.Create(json["filterNameToTypeMap"].AsJsonArray.Select(
          _value => new System.Collections.Generic.KeyValuePair<string, Com.Raritan.Idl.bulkcfg.BulkConfiguration_1_0_1.FilterType>(_value["key"], (Com.Raritan.Idl.bulkcfg.BulkConfiguration_1_0_1.FilterType)(int)_value["value"])));
        return inst;
      }

      public string name = "";
      public string description = "";
      public System.Collections.Generic.IDictionary<string, Com.Raritan.Idl.bulkcfg.BulkConfiguration_1_0_1.FilterType> filterNameToTypeMap = new System.Collections.Generic.Dictionary<string, Com.Raritan.Idl.bulkcfg.BulkConfiguration_1_0_1.FilterType>();
    }

    public const int SUCCESS = 0;

    public const int ERR_FILTER_NAME_UNKNOWN = 1;

    public const int ERR_FILTER_TYPE_READONLY = 2;

    public const int ERR_PROFILE_ALREADY_EXISTS = 3;

    public const int ERR_PROFILE_DOES_NOT_EXIST = 4;

    public const int ERR_PROFILE_IS_DEFAULT = 5;

    public const int ERR_PROFILE_IS_BUILTIN = 6;

    public const int ERR_PROFILE_NAME_TOO_LONG = 7;

    public const int ERR_PROFILE_NAME_INVALID = 8;

    public const int ERR_PROFILE_TOO_MANY = 9;

    public class GetFiltersResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.bulkcfg.BulkConfiguration_1_0_1.Filter> _ret_;
    }

    public GetFiltersResult getFilters() {
      JsonObject _parameters = null;
      var _result = RpcCall("getFilters", _parameters);
      var _ret = new GetFiltersResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.bulkcfg.BulkConfiguration_1_0_1.Filter>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.bulkcfg.BulkConfiguration_1_0_1.Filter.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getFilters(AsyncRpcResponse<GetFiltersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getFilters(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getFilters(AsyncRpcResponse<GetFiltersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getFilters", _parameters,
        _result => {
          try {
            var _ret = new GetFiltersResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.bulkcfg.BulkConfiguration_1_0_1.Filter>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.bulkcfg.BulkConfiguration_1_0_1.Filter.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetFilterProfilesResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.bulkcfg.BulkConfiguration_1_0_1.FilterProfile> _ret_;
    }

    public GetFilterProfilesResult getFilterProfiles() {
      JsonObject _parameters = null;
      var _result = RpcCall("getFilterProfiles", _parameters);
      var _ret = new GetFilterProfilesResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.bulkcfg.BulkConfiguration_1_0_1.FilterProfile>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.bulkcfg.BulkConfiguration_1_0_1.FilterProfile.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getFilterProfiles(AsyncRpcResponse<GetFilterProfilesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getFilterProfiles(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getFilterProfiles(AsyncRpcResponse<GetFilterProfilesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getFilterProfiles", _parameters,
        _result => {
          try {
            var _ret = new GetFilterProfilesResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.bulkcfg.BulkConfiguration_1_0_1.FilterProfile>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.bulkcfg.BulkConfiguration_1_0_1.FilterProfile.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class AddFilterProfileResult {
      public int _ret_;
    }

    public AddFilterProfileResult addFilterProfile(Com.Raritan.Idl.bulkcfg.BulkConfiguration_1_0_1.FilterProfile profile) {
      var _parameters = new LightJson.JsonObject();
      _parameters["profile"] = profile.Encode();

      var _result = RpcCall("addFilterProfile", _parameters);
      var _ret = new AddFilterProfileResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest addFilterProfile(Com.Raritan.Idl.bulkcfg.BulkConfiguration_1_0_1.FilterProfile profile, AsyncRpcResponse<AddFilterProfileResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return addFilterProfile(profile, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest addFilterProfile(Com.Raritan.Idl.bulkcfg.BulkConfiguration_1_0_1.FilterProfile profile, AsyncRpcResponse<AddFilterProfileResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["profile"] = profile.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("addFilterProfile", _parameters,
        _result => {
          try {
            var _ret = new AddFilterProfileResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ModifyFilterProfileResult {
      public int _ret_;
    }

    public ModifyFilterProfileResult modifyFilterProfile(Com.Raritan.Idl.bulkcfg.BulkConfiguration_1_0_1.FilterProfile profile) {
      var _parameters = new LightJson.JsonObject();
      _parameters["profile"] = profile.Encode();

      var _result = RpcCall("modifyFilterProfile", _parameters);
      var _ret = new ModifyFilterProfileResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest modifyFilterProfile(Com.Raritan.Idl.bulkcfg.BulkConfiguration_1_0_1.FilterProfile profile, AsyncRpcResponse<ModifyFilterProfileResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return modifyFilterProfile(profile, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest modifyFilterProfile(Com.Raritan.Idl.bulkcfg.BulkConfiguration_1_0_1.FilterProfile profile, AsyncRpcResponse<ModifyFilterProfileResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["profile"] = profile.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("modifyFilterProfile", _parameters,
        _result => {
          try {
            var _ret = new ModifyFilterProfileResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class DeleteFilterProfileResult {
      public int _ret_;
    }

    public DeleteFilterProfileResult deleteFilterProfile(string profileName) {
      var _parameters = new LightJson.JsonObject();
      _parameters["profileName"] = profileName;

      var _result = RpcCall("deleteFilterProfile", _parameters);
      var _ret = new DeleteFilterProfileResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest deleteFilterProfile(string profileName, AsyncRpcResponse<DeleteFilterProfileResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return deleteFilterProfile(profileName, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest deleteFilterProfile(string profileName, AsyncRpcResponse<DeleteFilterProfileResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["profileName"] = profileName;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("deleteFilterProfile", _parameters,
        _result => {
          try {
            var _ret = new DeleteFilterProfileResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetDefaultFilterProfileNameResult {
      public string _ret_;
    }

    public GetDefaultFilterProfileNameResult getDefaultFilterProfileName() {
      JsonObject _parameters = null;
      var _result = RpcCall("getDefaultFilterProfileName", _parameters);
      var _ret = new GetDefaultFilterProfileNameResult();
      _ret._ret_ = (string)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest getDefaultFilterProfileName(AsyncRpcResponse<GetDefaultFilterProfileNameResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getDefaultFilterProfileName(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getDefaultFilterProfileName(AsyncRpcResponse<GetDefaultFilterProfileNameResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getDefaultFilterProfileName", _parameters,
        _result => {
          try {
            var _ret = new GetDefaultFilterProfileNameResult();
            _ret._ret_ = (string)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SelectDefaultFilterProfileResult {
      public int _ret_;
    }

    public SelectDefaultFilterProfileResult selectDefaultFilterProfile(string profileName) {
      var _parameters = new LightJson.JsonObject();
      _parameters["profileName"] = profileName;

      var _result = RpcCall("selectDefaultFilterProfile", _parameters);
      var _ret = new SelectDefaultFilterProfileResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest selectDefaultFilterProfile(string profileName, AsyncRpcResponse<SelectDefaultFilterProfileResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return selectDefaultFilterProfile(profileName, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest selectDefaultFilterProfile(string profileName, AsyncRpcResponse<SelectDefaultFilterProfileResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["profileName"] = profileName;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("selectDefaultFilterProfile", _parameters,
        _result => {
          try {
            var _ret = new SelectDefaultFilterProfileResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
