/*
 * Decompiled with CFR 0.152.
 */
package adql.query;

import adql.db.DBColumn;
import adql.parser.ADQLParser;
import adql.parser.feature.LanguageFeature;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.ADQLSet;
import adql.query.ClauseADQL;
import adql.query.ClauseOffset;
import adql.query.SetOperationType;
import adql.query.TextPosition;
import java.util.NoSuchElementException;

public class SetOperation
extends ADQLSet {
    private ADQLSet leftSet;
    private SetOperationType operation;
    private boolean withDuplicates = false;
    private ADQLSet rightSet;

    public SetOperation(ADQLSet leftSet, SetOperationType operation, ADQLSet rightSet) {
        this(null, leftSet, operation, rightSet);
    }

    public SetOperation(ADQLParser.ADQLVersion version, ADQLSet leftSet, SetOperationType operation, ADQLSet rightSet) {
        super(version);
        this.setLeftSet(leftSet);
        this.setOperation(operation);
        this.setRightSet(rightSet);
        this.setPosition(new TextPosition(leftSet.getPosition(), rightSet.getPosition()));
    }

    public SetOperation(SetOperation toCopy) throws Exception {
        super(toCopy);
        this.leftSet = (ADQLSet)toCopy.leftSet.getCopy();
        this.operation = toCopy.operation;
        this.rightSet = (ADQLSet)toCopy.rightSet.getCopy();
        this.position = toCopy.position == null ? null : new TextPosition(toCopy.position);
    }

    @Override
    public String getName() {
        return this.operation.toString();
    }

    public ADQLSet getLeftSet() {
        return this.leftSet;
    }

    public void setLeftSet(ADQLSet newLeftSet) throws NullPointerException, UnsupportedOperationException {
        if (newLeftSet == null) {
            throw new NullPointerException("Impossible to update a SetOperation with a left set equals to NULL!");
        }
        this.leftSet = newLeftSet;
        this.position = null;
    }

    public SetOperationType getOperation() {
        return this.operation;
    }

    public void setOperation(SetOperationType newOperation) {
        if (newOperation != null) {
            this.operation = newOperation;
        }
    }

    public final boolean isWithDuplicates() {
        return this.withDuplicates;
    }

    public final void setWithDuplicates(boolean withDuplicates) {
        this.withDuplicates = withDuplicates;
    }

    public ADQLSet getRightSet() {
        return this.rightSet;
    }

    public void setRightSet(ADQLSet newRightSet) throws NullPointerException, UnsupportedOperationException {
        if (newRightSet == null) {
            throw new NullPointerException("Impossible to update a SetOperation with a right set equals to NULL!");
        }
        this.rightSet = newRightSet;
        this.position = null;
    }

    @Override
    public boolean hasLimit() {
        return false;
    }

    @Override
    public int getLimit() {
        return -1;
    }

    @Override
    public void setNoLimit() {
    }

    @Override
    public void setLimit(int limit) {
    }

    @Override
    public DBColumn[] getResultingColumns() {
        return this.leftSet.getResultingColumns();
    }

    @Override
    public LanguageFeature getFeatureDescription() {
        return this.operation.getFeatureDescription();
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new SetOperation(this);
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private int index = -1;
            private ADQLObject currentClause = null;

            @Override
            public ADQLObject next() {
                ++this.index;
                switch (this.index) {
                    case 0: {
                        this.currentClause = SetOperation.this.with;
                        break;
                    }
                    case 1: {
                        this.currentClause = SetOperation.this.leftSet;
                        break;
                    }
                    case 2: {
                        this.currentClause = SetOperation.this.rightSet;
                        break;
                    }
                    case 3: {
                        this.currentClause = SetOperation.this.orderBy;
                        break;
                    }
                    case 4: {
                        this.currentClause = null;
                        return SetOperation.this.offset;
                    }
                    default: {
                        throw new NoSuchElementException();
                    }
                }
                return this.currentClause;
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < 5;
            }

            @Override
            public void replace(ADQLObject replacer) throws UnsupportedOperationException, IllegalStateException {
                if (this.index <= -1) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called!");
                }
                if (replacer == null) {
                    this.remove();
                } else {
                    switch (this.index) {
                        case 0: {
                            if (replacer instanceof ClauseADQL) {
                                SetOperation.this.with = (ClauseADQL)replacer;
                                break;
                            }
                            throw new UnsupportedOperationException("Impossible to replace a ClauseADQL (" + SetOperation.this.with.toADQL() + ") by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ")!");
                        }
                        case 1: {
                            if (replacer instanceof ADQLSet) {
                                SetOperation.this.leftSet = (ADQLSet)replacer;
                                break;
                            }
                            throw new UnsupportedOperationException("Impossible to replace an ADQLSet (" + SetOperation.this.leftSet.toADQL() + ") by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ")!");
                        }
                        case 2: {
                            if (replacer instanceof ADQLSet) {
                                SetOperation.this.rightSet = (ADQLSet)replacer;
                                break;
                            }
                            throw new UnsupportedOperationException("Impossible to replace a ADQLSet (" + SetOperation.this.rightSet.toADQL() + ") by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ")!");
                        }
                        case 3: {
                            if (replacer instanceof ClauseADQL) {
                                SetOperation.this.orderBy = (ClauseADQL)replacer;
                                break;
                            }
                            throw new UnsupportedOperationException("Impossible to replace a ClauseADQL (" + SetOperation.this.orderBy.toADQL() + ") by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ")!");
                        }
                        case 4: {
                            if (replacer instanceof ClauseOffset) {
                                SetOperation.this.offset = (ClauseOffset)replacer;
                                break;
                            }
                            throw new UnsupportedOperationException("Impossible to replace a ClauseOffset (" + SetOperation.this.offset.toADQL() + ") by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ")!");
                        }
                    }
                    SetOperation.this.position = null;
                }
            }

            @Override
            public void remove() {
                if (this.index <= -1) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called!");
                }
                if (this.index == 1 || this.index == 2) {
                    throw new UnsupportedOperationException("Impossible to remove the " + (this.index == 1 ? "left" : "right") + " set from a set operation!");
                }
                if (this.index == 4) {
                    SetOperation.this.offset = null;
                    SetOperation.this.position = null;
                } else {
                    if (this.currentClause != null) {
                        ((ClauseADQL)this.currentClause).clear();
                    }
                    SetOperation.this.position = null;
                }
            }
        };
    }

    @Override
    public String toADQL() {
        boolean extendedSetExp;
        StringBuffer adql = new StringBuffer();
        adql.append('(');
        if (!this.with.isEmpty()) {
            adql.append(this.with.toADQL()).append('\n');
        }
        boolean bl = extendedSetExp = !this.leftSet.with.isEmpty() || !this.leftSet.orderBy.isEmpty() || this.leftSet.offset != null;
        if (extendedSetExp) {
            adql.append('(');
        }
        adql.append(this.leftSet.toADQL());
        if (extendedSetExp) {
            adql.append(')');
        }
        adql.append('\n').append(this.operation.toADQL());
        if (this.withDuplicates) {
            adql.append(" ALL");
        }
        adql.append('\n');
        boolean bl2 = extendedSetExp = !this.rightSet.with.isEmpty() || !this.rightSet.orderBy.isEmpty() || this.rightSet.offset != null;
        if (extendedSetExp) {
            adql.append('(');
        }
        adql.append(this.rightSet.toADQL());
        if (extendedSetExp) {
            adql.append(')');
        }
        if (!this.orderBy.isEmpty()) {
            adql.append('\n').append(this.orderBy.toADQL());
        }
        if (this.offset != null) {
            adql.append('\n').append(this.offset.toADQL());
        }
        return adql.append(')').toString();
    }
}

