/*
 * Decompiled with CFR 0.152.
 */
package adql.parser.grammar;

import adql.db.DBType;
import adql.parser.ADQLParser;
import adql.parser.ADQLQueryFactory;
import adql.parser.IdentifierItems;
import adql.parser.grammar.ADQLGrammar;
import adql.parser.grammar.ADQLGrammar201Constants;
import adql.parser.grammar.ADQLGrammar201TokenManager;
import adql.parser.grammar.ADQLGrammarBase;
import adql.parser.grammar.ParseException;
import adql.parser.grammar.SimpleCharStream;
import adql.parser.grammar.Token;
import adql.parser.grammar.TokenMgrError;
import adql.query.ADQLList;
import adql.query.ADQLOrder;
import adql.query.ADQLQuery;
import adql.query.ADQLSet;
import adql.query.ClauseADQL;
import adql.query.ClauseConstraints;
import adql.query.ClauseOffset;
import adql.query.ClauseSelect;
import adql.query.SelectAllColumns;
import adql.query.SelectItem;
import adql.query.SetOperation;
import adql.query.SetOperationType;
import adql.query.TextPosition;
import adql.query.WithItem;
import adql.query.constraint.ADQLConstraint;
import adql.query.constraint.Between;
import adql.query.constraint.Comparison;
import adql.query.constraint.ComparisonOperator;
import adql.query.constraint.In;
import adql.query.constraint.NotConstraint;
import adql.query.from.ADQLJoin;
import adql.query.from.FromContent;
import adql.query.operand.ADQLColumn;
import adql.query.operand.ADQLOperand;
import adql.query.operand.Concatenation;
import adql.query.operand.NegativeOperand;
import adql.query.operand.NullValue;
import adql.query.operand.NumericConstant;
import adql.query.operand.Operation;
import adql.query.operand.OperationType;
import adql.query.operand.StringConstant;
import adql.query.operand.WrappedOperand;
import adql.query.operand.function.ADQLFunction;
import adql.query.operand.function.InUnitFunction;
import adql.query.operand.function.MathFunction;
import adql.query.operand.function.MathFunctionType;
import adql.query.operand.function.SQLFunction;
import adql.query.operand.function.SQLFunctionType;
import adql.query.operand.function.UserDefinedFunction;
import adql.query.operand.function.cast.CastFunction;
import adql.query.operand.function.cast.CustomTargetType;
import adql.query.operand.function.cast.StandardTargetType;
import adql.query.operand.function.cast.TargetType;
import adql.query.operand.function.conditional.CoalesceFunction;
import adql.query.operand.function.geometry.BoxFunction;
import adql.query.operand.function.geometry.CentroidFunction;
import adql.query.operand.function.geometry.CircleFunction;
import adql.query.operand.function.geometry.DistanceFunction;
import adql.query.operand.function.geometry.ExtractCoordSys;
import adql.query.operand.function.geometry.GeometryFunction;
import adql.query.operand.function.geometry.PointFunction;
import adql.query.operand.function.geometry.PolygonFunction;
import adql.query.operand.function.string.LowerFunction;
import adql.query.operand.function.string.UpperFunction;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class ADQLGrammar201
extends ADQLGrammarBase
implements ADQLGrammar201Constants {
    public static final ADQLParser.ADQLVersion VERSION = ADQLParser.ADQLVersion.V2_1;
    public ADQLGrammar201TokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[125];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private final JJCalls[] jj_2_rtns = new JJCalls[32];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private static final LookaheadSuccess jj_ls;
    private List<int[]> jj_expentries;
    private int[] jj_expentry;
    private int jj_kind;
    private int[] jj_lasttokens;
    private int jj_endpos;
    private boolean trace_enabled;
    private int trace_indent;

    @Override
    public final ADQLParser.ADQLVersion getVersion() {
        return VERSION;
    }

    @Override
    public final boolean isEOF(Token token) {
        return token != null && token.kind == 0;
    }

    @Override
    public final boolean isEOQ(Token token) {
        return token != null && token.kind == 7;
    }

    @Override
    public final boolean isRegularIdentifierCandidate(Token token) {
        return token != null && token.kind == 114;
    }

    @Override
    public final boolean isSQLReservedWord(Token token) {
        return token != null && token.kind == 2;
    }

    @Override
    public final boolean isLeftPar(Token token) {
        return token != null && token.kind == 3;
    }

    @Override
    public final ADQLGrammar.Tokenizer getTokenizer(final String expr) throws NullPointerException {
        if (expr == null) {
            throw new NullPointerException("Missing ADQL expression to tokenize!");
        }
        return new ADQLGrammar.Tokenizer(){
            private final ADQLGrammar201TokenManager tokenManager;
            private boolean eof;
            {
                this.tokenManager = new ADQLGrammar201TokenManager(new SimpleCharStream(new ByteArrayInputStream(expr.getBytes())));
                this.eof = false;
            }

            @Override
            public Token nextToken() {
                if (this.eof) {
                    return null;
                }
                Token tok = this.tokenManager.getNextToken();
                this.eof = tok.kind == 0;
                return tok;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ADQLSet Query() throws ParseException {
        this.trace_call("Query");
        try {
            ADQLSet q = null;
            ClauseADQL<WithItem> with = null;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 47: {
                    with = this.With();
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                }
            }
            q = this.QueryExpression();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 0: {
                    this.jj_consume_token(0);
                    break;
                }
                case 7: {
                    this.jj_consume_token(7);
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (with != null) {
                TextPosition setPosition = q.getPosition();
                q.setWith(with);
                q.setPosition(new TextPosition(with.getPosition(), setPosition));
            }
            ADQLSet aDQLSet = q;
            return aDQLSet;
        }
        finally {
            this.trace_return("Query");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ADQLSet QueryExpression() throws ParseException {
        this.trace_call("QueryExpression");
        try {
            TextPosition endPos = null;
            ADQLSet set = this.SetExpression();
            TextPosition initPos = set.getPosition();
            endPos = set.getPosition();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 51: {
                    ClauseADQL<ADQLOrder> orderBy = this.OrderBy();
                    set.setOrderBy(orderBy);
                    endPos = orderBy.getPosition();
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 54: {
                    ClauseOffset offset = this.Offset();
                    set.setOffset(offset);
                    endPos = offset.getPosition();
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                }
            }
            set.setPosition(new TextPosition(initPos, endPos));
            ADQLSet aDQLSet = set;
            return aDQLSet;
        }
        finally {
            this.trace_return("QueryExpression");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ADQLSet SetExpression() throws ParseException {
        this.trace_call("SetExpression");
        try {
            ADQLSet set1 = null;
            ADQLSet set2 = null;
            Token setOp = null;
            Token quantifier = null;
            set1 = this.SetTerm();
            block15: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 9: 
                    case 11: {
                        break;
                    }
                    default: {
                        this.jj_la1[4] = this.jj_gen;
                        break block15;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 9: {
                        setOp = this.jj_consume_token(9);
                        break;
                    }
                    case 11: {
                        setOp = this.jj_consume_token(11);
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 23: {
                        quantifier = this.jj_consume_token(23);
                        break;
                    }
                    default: {
                        this.jj_la1[6] = this.jj_gen;
                    }
                }
                set2 = this.SetTerm();
                try {
                    SetOperation set = this.queryFactory.createSetOperation(VERSION, set1, SetOperationType.valueOf(setOp.image.toUpperCase()), set2);
                    set.setWithDuplicates(quantifier != null && quantifier.image.equalsIgnoreCase("ALL"));
                    set1 = set;
                }
                catch (Exception ex) {
                    throw this.generateParseException(ex);
                }
            }
            ADQLSet aDQLSet = set1;
            return aDQLSet;
        }
        finally {
            this.trace_return("SetExpression");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ADQLSet SetTerm() throws ParseException {
        this.trace_call("SetTerm");
        try {
            ADQLSet set1 = null;
            ADQLSet set2 = null;
            Token quantifier = null;
            set1 = this.SetFactor();
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 10: {
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                        break block11;
                    }
                }
                this.jj_consume_token(10);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 23: {
                        quantifier = this.jj_consume_token(23);
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                    }
                }
                set2 = this.SetFactor();
                try {
                    SetOperation set = this.queryFactory.createSetOperation(VERSION, set1, SetOperationType.INTERSECT, set2);
                    set.setWithDuplicates(quantifier != null && quantifier.image.equalsIgnoreCase("ALL"));
                    set1 = set;
                }
                catch (Exception ex) {
                    throw this.generateParseException(ex);
                }
            }
            ADQLSet aDQLSet = set1;
            return aDQLSet;
        }
        finally {
            this.trace_return("SetTerm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ADQLSet SetFactor() throws ParseException {
        this.trace_call("SetFactor");
        try {
            ADQLSet set = null;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 22: {
                    set = this.SimpleQueryExpression();
                    break;
                }
                case 3: {
                    set = this.SubQueryExpression();
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ADQLSet aDQLSet = set;
            return aDQLSet;
        }
        finally {
            this.trace_return("SetFactor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ADQLQuery SimpleQueryExpression() throws ParseException {
        this.trace_call("SimpleQueryExpression");
        try {
            TextPosition endPos = null;
            ClauseSelect select = null;
            try {
                this.query = this.queryFactory.createQuery(VERSION);
                this.stackQuery.push(this.query);
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
            select = this.Select();
            this.query.setSelect(select);
            FromContent from = this.From();
            this.query.setFrom(from);
            endPos = from.getPosition();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 36: {
                    ClauseConstraints where = this.Where();
                    this.query.setWhere(where);
                    endPos = where.getPosition();
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 49: {
                    ClauseADQL<ADQLOperand> groupBy = this.GroupBy();
                    this.query.setGroupBy(groupBy);
                    endPos = groupBy.getPosition();
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 50: {
                    ClauseConstraints having = this.Having();
                    this.query.setHaving(having);
                    endPos = having.getPosition();
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                }
            }
            this.query.setPosition(new TextPosition(select.getPosition(), endPos));
            ADQLQuery previousQuery = (ADQLQuery)this.stackQuery.pop();
            this.query = this.stackQuery.isEmpty() ? null : (ADQLQuery)this.stackQuery.peek();
            ADQLQuery aDQLQuery = previousQuery;
            return aDQLQuery;
        }
        finally {
            this.trace_return("SimpleQueryExpression");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ADQLSet SubQueryExpression() throws ParseException {
        this.trace_call("SubQueryExpression");
        try {
            ADQLSet q = null;
            Token start = this.jj_consume_token(3);
            q = this.QueryExpression();
            Token end = this.jj_consume_token(4);
            q.setPosition(new TextPosition(start, end));
            ADQLSet aDQLSet = q;
            return aDQLSet;
        }
        finally {
            this.trace_return("SubQueryExpression");
        }
    }

    public final ClauseADQL<WithItem> With() throws ParseException {
        this.trace_call("With");
        try {
            ClauseADQL<WithItem> withClause = new ClauseADQL<WithItem>("WITH");
            try {
                Token start = this.jj_consume_token(47);
                IdentifierItems.IdentifierItem id = this.Identifier();
                this.jj_consume_token(26);
                this.jj_consume_token(3);
                ADQLSet query = this.QueryExpression();
                Token end = this.jj_consume_token(4);
                WithItem withItem = this.queryFactory.createWithItem(id, query);
                withItem.setPosition(new TextPosition(id.position, new TextPosition(end)));
                withClause.add(withItem);
                block9: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 6: {
                            break;
                        }
                        default: {
                            this.jj_la1[13] = this.jj_gen;
                            break block9;
                        }
                    }
                    this.jj_consume_token(6);
                    id = this.Identifier();
                    this.jj_consume_token(26);
                    this.jj_consume_token(3);
                    query = this.QueryExpression();
                    end = this.jj_consume_token(4);
                    withItem = this.queryFactory.createWithItem(id, query);
                    withItem.setPosition(new TextPosition(id.position, new TextPosition(end)));
                    withClause.add(withItem);
                }
                withClause.setPosition(new TextPosition(start, end));
                ClauseADQL<WithItem> clauseADQL = withClause;
                return clauseADQL;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("With");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ClauseSelect Select() throws ParseException {
        this.trace_call("Select");
        try {
            ClauseSelect select = new ClauseSelect();
            SelectItem item = null;
            Token t = null;
            Token start = this.jj_consume_token(22);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 23: {
                    t = this.jj_consume_token(23);
                    select.setDistinctColumns(t.image.equalsIgnoreCase("DISTINCT"));
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 24: {
                    this.jj_consume_token(24);
                    t = this.jj_consume_token(109);
                    try {
                        select.setLimit(Integer.parseInt(t.image));
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        throw new ParseException("[l." + t.beginLine + ";c." + t.beginColumn + "] The TOP limit (\"" + t.image + "\") isn't a regular unsigned integer !");
                    }
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                }
            }
            item = this.SelectItem();
            select.add(item);
            block14: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 6: {
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                        break block14;
                    }
                }
                this.jj_consume_token(6);
                item = this.SelectItem();
                select.add(item);
            }
            TextPosition lastItemPos = ((SelectItem)select.get(select.size() - 1)).getPosition();
            select.setPosition(new TextPosition(start.beginLine, start.beginColumn, lastItemPos.endLine, lastItemPos.endColumn));
            ClauseSelect clauseSelect = select;
            return clauseSelect;
        }
        finally {
            this.trace_return("Select");
        }
    }

    /*
     * Unable to fully structure code
     */
    public final SelectItem SelectItem() throws ParseException {
        this.trace_call("SelectItem");
        identifiers = new IdentifierItems(true);
        firstID = null;
        id = null;
        label = null;
        op = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 14: {
                starToken = this.jj_consume_token(14);
                item = new SelectAllColumns(this.query);
                item.setPosition(new TextPosition(starToken));
                var8_11 = item;
                return var8_11;
            }
        }
        this.jj_la1[21] = this.jj_gen;
        if (this.jj_2_1(7)) {
            id = this.Identifier();
            this.jj_consume_token(5);
            identifiers.append(id);
            firstID = id;
            block9 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 113: 
                case 114: {
                    id = this.Identifier();
                    this.jj_consume_token(5);
                    identifiers.append(id);
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 113: 
                        case 114: {
                            id = this.Identifier();
                            this.jj_consume_token(5);
                            identifiers.append(id);
                            break block9;
                        }
                    }
                    this.jj_la1[17] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                }
            }
            starToken = this.jj_consume_token(14);
            try {
                table = this.queryFactory.createTable(identifiers, null);
                table.setPosition(new TextPosition(firstID.position, id.position));
                item = new SelectAllColumns(table);
                item.setPosition(new TextPosition(firstID.position, new TextPosition(starToken)));
                var9_16 = item;
                return var9_16;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        ** switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk)
lbl-1000:
        // 1 sources

        {
            case 3: 
            case 12: 
            case 13: 
            case 41: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 113: 
            case 114: {
                op = this.ValueExpression();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 26: 
                    case 113: 
                    case 114: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 26: {
                                this.jj_consume_token(26);
                                break;
                            }
                            default: {
                                this.jj_la1[19] = this.jj_gen;
                            }
                        }
                        label = this.Identifier();
                        break block15;
                    }
                }
                this.jj_la1[20] = this.jj_gen;
                break;
            }
lbl65:
            // 1 sources

            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        try {
            item = this.queryFactory.createSelectItem(op, label == null ? null : label.identifier);
            if (label != null) {
                item.setCaseSensitive(label.caseSensitivity);
                item.setPosition(new TextPosition(op.getPosition(), label.position));
            } else {
                item.setPosition(new TextPosition(op.getPosition()));
            }
            ex = item;
            return ex;
        }
        catch (Exception ex) {
            throw this.generateParseException(ex);
        }
        finally {
            this.trace_return("SelectItem");
        }
    }

    @Override
    public final FromContent From() throws ParseException {
        this.trace_call("From");
        try {
            FromContent content = null;
            FromContent content2 = null;
            try {
                Object startPos;
                this.jj_consume_token(25);
                content = this.TableRef();
                block9: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 6: {
                            break;
                        }
                        default: {
                            this.jj_la1[23] = this.jj_gen;
                            break block9;
                        }
                    }
                    this.jj_consume_token(6);
                    content2 = this.TableRef();
                    startPos = content.getPosition();
                    TextPosition endPos = content2.getPosition();
                    content = this.queryFactory.createJoin(ADQLQueryFactory.JoinType.CROSS, content, content2);
                    content.setPosition(new TextPosition((TextPosition)startPos, endPos));
                }
                startPos = content;
                return startPos;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("From");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ClauseConstraints Where() throws ParseException {
        this.trace_call("Where");
        try {
            ClauseConstraints where = new ClauseConstraints("WHERE");
            Token start = this.jj_consume_token(36);
            this.ConditionsList(where);
            TextPosition endPosition = where.getPosition();
            where.setPosition(new TextPosition(start.beginLine, start.beginColumn, endPosition.endLine, endPosition.endColumn));
            ClauseConstraints clauseConstraints = where;
            return clauseConstraints;
        }
        finally {
            this.trace_return("Where");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ClauseADQL<ADQLOperand> GroupBy() throws ParseException {
        this.trace_call("GroupBy");
        try {
            ClauseADQL<ADQLOperand> groupBy = new ClauseADQL<ADQLOperand>("GROUP BY");
            ADQLOperand item = null;
            Token start = this.jj_consume_token(49);
            this.jj_consume_token(48);
            item = this.ValueExpression();
            groupBy.add(item);
            block6: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 6: {
                        break;
                    }
                    default: {
                        this.jj_la1[24] = this.jj_gen;
                        break block6;
                    }
                }
                this.jj_consume_token(6);
                item = this.ValueExpression();
                groupBy.add(item);
            }
            groupBy.setPosition(new TextPosition(new TextPosition(start), item.getPosition()));
            ClauseADQL<ADQLOperand> clauseADQL = groupBy;
            return clauseADQL;
        }
        finally {
            this.trace_return("GroupBy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ClauseConstraints Having() throws ParseException {
        this.trace_call("Having");
        try {
            ClauseConstraints having = new ClauseConstraints("HAVING");
            Token start = this.jj_consume_token(50);
            this.ConditionsList(having);
            TextPosition endPosition = having.getPosition();
            having.setPosition(new TextPosition(start.beginLine, start.beginColumn, endPosition.endLine, endPosition.endColumn));
            ClauseConstraints clauseConstraints = having;
            return clauseConstraints;
        }
        finally {
            this.trace_return("Having");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ClauseADQL<ADQLOrder> OrderBy() throws ParseException {
        this.trace_call("OrderBy");
        try {
            ClauseADQL<ADQLOrder> orderBy = new ClauseADQL<ADQLOrder>("ORDER BY");
            ADQLOrder order = null;
            Token start = this.jj_consume_token(51);
            this.jj_consume_token(48);
            order = this.OrderItem();
            orderBy.add(order);
            block6: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 6: {
                        break;
                    }
                    default: {
                        this.jj_la1[25] = this.jj_gen;
                        break block6;
                    }
                }
                this.jj_consume_token(6);
                order = this.OrderItem();
                orderBy.add(order);
            }
            orderBy.setPosition(new TextPosition(start, this.token));
            ClauseADQL<ADQLOrder> clauseADQL = orderBy;
            return clauseADQL;
        }
        finally {
            this.trace_return("OrderBy");
        }
    }

    /*
     * Exception decompiling
     */
    public final ClauseOffset Offset() throws ParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final IdentifierItems.IdentifierItem Identifier() throws ParseException {
        this.trace_call("Identifier");
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 114: {
                    Token t = this.jj_consume_token(114);
                    this.testRegularIdentifier(t);
                    IdentifierItems.IdentifierItem identifierItem = new IdentifierItems.IdentifierItem(t, false);
                    return identifierItem;
                }
                case 113: {
                    Token t = this.jj_consume_token(113);
                    IdentifierItems.IdentifierItem identifierItem = new IdentifierItems.IdentifierItem(t, true);
                    return identifierItem;
                }
            }
            this.jj_la1[26] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        finally {
            this.trace_return("Identifier");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IdentifierItems TableName() throws ParseException {
        this.trace_call("TableName");
        try {
            IdentifierItems identifiers = new IdentifierItems(true);
            IdentifierItems.IdentifierItem id = null;
            id = this.Identifier();
            identifiers.append(id);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    this.jj_consume_token(5);
                    id = this.Identifier();
                    identifiers.append(id);
                    break;
                }
                default: {
                    this.jj_la1[27] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    this.jj_consume_token(5);
                    id = this.Identifier();
                    identifiers.append(id);
                    break;
                }
                default: {
                    this.jj_la1[28] = this.jj_gen;
                }
            }
            IdentifierItems identifierItems = identifiers;
            return identifierItems;
        }
        finally {
            this.trace_return("TableName");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IdentifierItems ColumnName() throws ParseException {
        this.trace_call("ColumnName");
        try {
            IdentifierItems table = null;
            IdentifierItems identifiers = new IdentifierItems(false);
            IdentifierItems.IdentifierItem id = this.Identifier();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    this.jj_consume_token(5);
                    table = this.TableName();
                    break;
                }
                default: {
                    this.jj_la1[29] = this.jj_gen;
                }
            }
            identifiers.append(id);
            if (table != null) {
                for (int i = 0; i < table.size(); ++i) {
                    identifiers.append(table.get(i));
                }
            }
            IdentifierItems identifierItems = identifiers;
            return identifierItems;
        }
        finally {
            this.trace_return("ColumnName");
        }
    }

    public final ADQLColumn Column() throws ParseException {
        this.trace_call("Column");
        try {
            IdentifierItems identifiers = this.ColumnName();
            try {
                ADQLColumn aDQLColumn = this.queryFactory.createColumn(identifiers);
                return aDQLColumn;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("Column");
        }
    }

    public final ADQLOrder OrderItem() throws ParseException {
        this.trace_call("OrderItem");
        try {
            ADQLOperand expr = null;
            Token ind = null;
            Token desc = null;
            expr = this.ValueExpression();
            if (expr instanceof NumericConstant && this.token.kind == 109) {
                ind = this.token;
            }
            block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 52: 
                case 53: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 52: {
                            this.jj_consume_token(52);
                            break block3;
                        }
                        case 53: {
                            desc = this.jj_consume_token(53);
                            break block3;
                        }
                    }
                    this.jj_la1[30] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[31] = this.jj_gen;
                }
            }
            try {
                ADQLOrder order = null;
                if (ind != null) {
                    order = this.queryFactory.createOrder(Integer.parseInt(ind.image), desc != null);
                    order.getColumnReference().setPosition(new TextPosition(ind));
                    if (desc == null) {
                        order.setPosition(new TextPosition(ind));
                    } else {
                        order.setPosition(new TextPosition(ind, desc));
                    }
                } else {
                    order = this.queryFactory.createOrder(expr, desc != null);
                    if (desc == null) {
                        order.setPosition(expr.getPosition());
                    } else {
                        order.setPosition(new TextPosition(expr.getPosition(), new TextPosition(desc)));
                    }
                }
                ADQLOrder aDQLOrder = order;
                return aDQLOrder;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("OrderItem");
        }
    }

    public final FromContent SimpleTableRef() throws ParseException {
        this.trace_call("SimpleTableRef");
        try {
            FromContent content;
            block28: {
                IdentifierItems.IdentifierItem alias = null;
                IdentifierItems identifiers = null;
                ADQLSet subQuery = null;
                content = null;
                try {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 113: 
                        case 114: {
                            identifiers = this.TableName();
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 26: 
                                case 113: 
                                case 114: {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                        case 26: {
                                            this.jj_consume_token(26);
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[32] = this.jj_gen;
                                        }
                                    }
                                    alias = this.Identifier();
                                    break;
                                }
                                default: {
                                    this.jj_la1[33] = this.jj_gen;
                                }
                            }
                            content = this.queryFactory.createTable(identifiers, alias);
                            if (alias == null) {
                                content.setPosition(new TextPosition(identifiers.get((int)0).position, identifiers.get((int)(identifiers.size() - 1)).position));
                            } else {
                                content.setPosition(new TextPosition(identifiers.get((int)0).position, alias.position));
                            }
                            FromContent fromContent = content;
                            return fromContent;
                        }
                    }
                    this.jj_la1[35] = this.jj_gen;
                    if (!this.jj_2_2(2)) break block28;
                }
                catch (Exception ex) {
                    throw this.generateParseException(ex);
                }
                subQuery = this.SubQueryExpression();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 26: {
                        this.jj_consume_token(26);
                        break;
                    }
                    default: {
                        this.jj_la1[34] = this.jj_gen;
                    }
                }
                alias = this.Identifier();
                content = this.queryFactory.createTable(subQuery, alias);
                if (alias == null) {
                    content.setPosition(new TextPosition(subQuery.getPosition()));
                } else {
                    content.setPosition(new TextPosition(subQuery.getPosition(), alias.position));
                }
                FromContent fromContent = content;
                return fromContent;
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 3: {
                    Token start = this.jj_consume_token(3);
                    content = this.JoinedTable();
                    Token end = this.jj_consume_token(4);
                    content.setPosition(new TextPosition(start, end));
                    FromContent fromContent = content;
                    return fromContent;
                }
            }
            this.jj_la1[36] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        finally {
            this.trace_return("SimpleTableRef");
        }
    }

    public final FromContent TableRef() throws ParseException {
        this.trace_call("TableRef");
        try {
            FromContent content = this.SimpleTableRef();
            while (this.jj_2_3(2)) {
                content = this.JoinSpecification(content);
            }
            FromContent fromContent = content;
            return fromContent;
        }
        finally {
            this.trace_return("TableRef");
        }
    }

    public final FromContent JoinedTable() throws ParseException {
        this.trace_call("JoinedTable");
        try {
            FromContent content = this.SimpleTableRef();
            block6: while (true) {
                content = this.JoinSpecification(content);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 27: 
                    case 28: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: {
                        continue block6;
                    }
                }
                break;
            }
            this.jj_la1[37] = this.jj_gen;
            FromContent fromContent = content;
            return fromContent;
        }
        finally {
            this.trace_return("JoinedTable");
        }
    }

    /*
     * Exception decompiling
     */
    public final ADQLJoin JoinSpecification(FromContent leftTable) throws ParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 8[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final StringConstant String() throws ParseException {
        this.trace_call("String");
        try {
            Token t;
            Token start = null;
            String str = "";
            block9: while (true) {
                t = this.jj_consume_token(106);
                str = str + t.image.substring(1, t.image.length() - 1).replaceAll("''", "'");
                if (start == null) {
                    start = t;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 106: {
                        continue block9;
                    }
                }
                break;
            }
            this.jj_la1[49] = this.jj_gen;
            try {
                StringConstant cst = this.queryFactory.createStringConstant(str);
                cst.setPosition(new TextPosition(start, t));
                StringConstant stringConstant = cst;
                return stringConstant;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("String");
        }
    }

    public final NumericConstant UnsignedNumeric() throws ParseException {
        this.trace_call("UnsignedNumeric");
        try {
            Token t;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 107: {
                    t = this.jj_consume_token(107);
                    break;
                }
                case 108: {
                    t = this.jj_consume_token(108);
                    break;
                }
                case 109: {
                    t = this.jj_consume_token(109);
                    break;
                }
                default: {
                    this.jj_la1[50] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            try {
                NumericConstant cst = this.queryFactory.createNumericConstant(t.image);
                cst.setPosition(new TextPosition(t));
                NumericConstant numericConstant = cst;
                return numericConstant;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("UnsignedNumeric");
        }
    }

    public final NumericConstant UnsignedFloat() throws ParseException {
        this.trace_call("UnsignedFloat");
        try {
            Token t;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 109: {
                    t = this.jj_consume_token(109);
                    break;
                }
                case 108: {
                    t = this.jj_consume_token(108);
                    break;
                }
                default: {
                    this.jj_la1[51] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            try {
                NumericConstant cst = this.queryFactory.createNumericConstant(t.image);
                cst.setPosition(new TextPosition(t));
                NumericConstant numericConstant = cst;
                return numericConstant;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("UnsignedFloat");
        }
    }

    public final NumericConstant SignedInteger() throws ParseException {
        this.trace_call("SignedInteger");
        try {
            Token sign = null;
            block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 12: 
                case 13: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 12: {
                            sign = this.jj_consume_token(12);
                            break block3;
                        }
                        case 13: {
                            sign = this.jj_consume_token(13);
                            break block3;
                        }
                    }
                    this.jj_la1[52] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[53] = this.jj_gen;
                }
            }
            Token number = this.jj_consume_token(109);
            try {
                NumericConstant cst;
                if (sign == null) {
                    cst = this.queryFactory.createNumericConstant(number.image);
                    cst.setPosition(new TextPosition(number));
                } else {
                    cst = this.queryFactory.createNumericConstant(sign.image + number.image);
                    cst.setPosition(new TextPosition(sign, number));
                }
                NumericConstant numericConstant = cst;
                return numericConstant;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("SignedInteger");
        }
    }

    public final ADQLOperand NumericValueExpressionPrimary() throws ParseException {
        this.trace_call("NumericValueExpressionPrimary");
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 41: {
                    Token left = this.jj_consume_token(41);
                    NullValue op = this.queryFactory.createNullValue();
                    op.setPosition(new TextPosition(left));
                    NullValue nullValue = op;
                    return nullValue;
                }
                case 107: 
                case 108: 
                case 109: {
                    NumericConstant op;
                    NumericConstant numericConstant = op = this.UnsignedNumeric();
                    return numericConstant;
                }
                case 113: 
                case 114: {
                    ADQLColumn column = this.Column();
                    column.setExpectedType('N');
                    ADQLColumn aDQLColumn = column;
                    return aDQLColumn;
                }
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: {
                    SQLFunction op;
                    SQLFunction sQLFunction = op = this.SqlFunction();
                    return sQLFunction;
                }
                case 3: {
                    Token left = this.jj_consume_token(3);
                    ADQLOperand op = this.NumericExpression();
                    Token right = this.jj_consume_token(4);
                    WrappedOperand wop = this.queryFactory.createWrappedOperand(op);
                    wop.setPosition(new TextPosition(left, right));
                    WrappedOperand wrappedOperand = wop;
                    return wrappedOperand;
                }
            }
            try {
                this.jj_la1[54] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("NumericValueExpressionPrimary");
        }
    }

    public final ADQLOperand StringValueExpressionPrimary() throws ParseException {
        this.trace_call("StringValueExpressionPrimary");
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 41: {
                    Token left = this.jj_consume_token(41);
                    NullValue op = this.queryFactory.createNullValue();
                    op.setPosition(new TextPosition(left));
                    NullValue nullValue = op;
                    return nullValue;
                }
                case 106: {
                    StringConstant expr;
                    StringConstant stringConstant = expr = this.String();
                    return stringConstant;
                }
                case 107: 
                case 108: 
                case 109: {
                    NumericConstant op;
                    NumericConstant numericConstant = op = this.UnsignedNumeric();
                    return numericConstant;
                }
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: {
                    SQLFunction op;
                    SQLFunction sQLFunction = op = this.SqlFunction();
                    return sQLFunction;
                }
                case 113: 
                case 114: {
                    ADQLColumn column = this.Column();
                    column.setExpectedType('*');
                    ADQLColumn aDQLColumn = column;
                    return aDQLColumn;
                }
                case 3: {
                    Token left = this.jj_consume_token(3);
                    ADQLOperand op = this.ValueExpression();
                    Token right = this.jj_consume_token(4);
                    WrappedOperand wop = this.queryFactory.createWrappedOperand(op);
                    wop.setPosition(new TextPosition(left, right));
                    WrappedOperand wrappedOperand = wop;
                    return wrappedOperand;
                }
            }
            try {
                this.jj_la1[55] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("StringValueExpressionPrimary");
        }
    }

    public final ADQLOperand ValueExpression() throws ParseException {
        this.trace_call("ValueExpression");
        try {
            ADQLOperand valueExpr = null;
            try {
                if (this.jj_2_4(Integer.MAX_VALUE)) {
                    valueExpr = this.NumericExpression();
                } else if (this.jj_2_5(Integer.MAX_VALUE)) {
                    valueExpr = this.StringExpression();
                } else if (this.jj_2_6(Integer.MAX_VALUE)) {
                    Token left = this.jj_consume_token(3);
                    valueExpr = this.ValueExpression();
                    Token right = this.jj_consume_token(4);
                    valueExpr = this.queryFactory.createWrappedOperand(valueExpr);
                    ((WrappedOperand)valueExpr).setPosition(new TextPosition(left, right));
                } else if (this.jj_2_7(Integer.MAX_VALUE)) {
                    valueExpr = this.UserDefinedFunction();
                } else if (this.jj_2_8(Integer.MAX_VALUE)) {
                    valueExpr = this.CastFunction('?');
                } else if (this.jj_2_9(Integer.MAX_VALUE)) {
                    valueExpr = this.ConditionalFunction();
                } else if (this.jj_2_10(2)) {
                    valueExpr = this.GeometryValueFunction();
                } else if (this.jj_2_11(Integer.MAX_VALUE)) {
                    valueExpr = this.Column();
                } else if (this.jj_2_12(Integer.MAX_VALUE)) {
                    valueExpr = this.StringFactor();
                } else if (this.jj_2_13(3)) {
                    valueExpr = this.Factor();
                } else if (this.jj_2_14(2)) {
                    valueExpr = this.NumericFunction();
                } else {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 113: 
                        case 114: {
                            valueExpr = this.Column();
                            break;
                        }
                        default: {
                            this.jj_la1[56] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                ADQLOperand aDQLOperand = valueExpr;
                return aDQLOperand;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("ValueExpression");
        }
    }

    public final ADQLOperand NumericExpression() throws ParseException {
        this.trace_call("NumericExpression");
        try {
            Token sign = null;
            ADQLOperand rightOp = null;
            ADQLOperand leftOp = this.NumericTerm();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 12: 
                case 13: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 12: {
                            sign = this.jj_consume_token(12);
                            break;
                        }
                        case 13: {
                            sign = this.jj_consume_token(13);
                            break;
                        }
                        default: {
                            this.jj_la1[57] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    rightOp = this.NumericExpression();
                    break;
                }
                default: {
                    this.jj_la1[58] = this.jj_gen;
                }
            }
            if (sign == null) {
                ADQLOperand aDQLOperand = leftOp;
                return aDQLOperand;
            }
            Operation operation = this.queryFactory.createOperation(leftOp, OperationType.getOperator(sign.image), rightOp);
            operation.setPosition(new TextPosition(leftOp.getPosition(), rightOp.getPosition()));
            Operation operation2 = operation;
            return operation2;
        }
        finally {
            this.trace_return("NumericExpression");
        }
    }

    public final ADQLOperand NumericTerm() throws ParseException {
        this.trace_call("NumericTerm");
        try {
            Token sign = null;
            ADQLOperand rightOp = null;
            ADQLOperand leftOp = this.Factor();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 14: 
                case 15: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 14: {
                            sign = this.jj_consume_token(14);
                            break;
                        }
                        case 15: {
                            sign = this.jj_consume_token(15);
                            break;
                        }
                        default: {
                            this.jj_la1[59] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    rightOp = this.NumericTerm();
                    break;
                }
                default: {
                    this.jj_la1[60] = this.jj_gen;
                }
            }
            if (sign == null) {
                ADQLOperand aDQLOperand = leftOp;
                return aDQLOperand;
            }
            Operation operation = this.queryFactory.createOperation(leftOp, OperationType.getOperator(sign.image), rightOp);
            operation.setPosition(new TextPosition(leftOp.getPosition(), rightOp.getPosition()));
            Operation operation2 = operation;
            return operation2;
        }
        finally {
            this.trace_return("NumericTerm");
        }
    }

    public final ADQLOperand Factor() throws ParseException {
        this.trace_call("Factor");
        try {
            ADQLOperand op;
            Token minusSign = null;
            Object bitNot = null;
            block4 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 12: 
                case 13: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 12: {
                            this.jj_consume_token(12);
                            break block4;
                        }
                        case 13: {
                            minusSign = this.jj_consume_token(13);
                            break block4;
                        }
                    }
                    this.jj_la1[61] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[62] = this.jj_gen;
                }
            }
            if (this.jj_2_15(2)) {
                op = this.NumericFunction();
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 3: 
                    case 41: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 113: 
                    case 114: {
                        op = this.NumericValueExpressionPrimary();
                        break;
                    }
                    default: {
                        this.jj_la1[63] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            try {
                if (minusSign != null) {
                    NegativeOperand negativeOp = this.queryFactory.createNegativeOperand(op);
                    negativeOp.setPosition(new TextPosition(new TextPosition(minusSign), op.getPosition()));
                    NegativeOperand negativeOperand = negativeOp;
                    return negativeOperand;
                }
                ADQLFunction negativeOp = op;
                return negativeOp;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("Factor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ADQLOperand StringExpression() throws ParseException {
        this.trace_call("StringExpression");
        try {
            ADQLOperand rightOp = null;
            ADQLOperand leftOp = this.StringFactor();
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 8: {
                        break;
                    }
                    default: {
                        this.jj_la1[64] = this.jj_gen;
                        break block8;
                    }
                }
                this.jj_consume_token(8);
                rightOp = this.StringFactor();
                if (!(leftOp instanceof Concatenation)) {
                    try {
                        ADQLOperand temp = leftOp;
                        leftOp = this.queryFactory.createConcatenation();
                        ((Concatenation)leftOp).add(temp);
                    }
                    catch (Exception ex) {
                        throw this.generateParseException(ex);
                    }
                }
                ((Concatenation)leftOp).add(rightOp);
            }
            if (leftOp instanceof Concatenation) {
                Concatenation concat = (Concatenation)leftOp;
                concat.setPosition(new TextPosition(((ADQLOperand)concat.get(0)).getPosition(), ((ADQLOperand)concat.get(concat.size() - 1)).getPosition()));
            } else if (leftOp instanceof ADQLColumn) {
                ((ADQLColumn)leftOp).setExpectedType('S');
            }
            ADQLOperand aDQLOperand = leftOp;
            return aDQLOperand;
        }
        finally {
            this.trace_return("StringExpression");
        }
    }

    public final ADQLOperand StringFactor() throws ParseException {
        this.trace_call("StringFactor");
        try {
            ADQLOperand op;
            block1 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 71: {
                    op = this.ExtractCoordSys();
                    break;
                }
                case 76: {
                    op = this.LowerFunction();
                    break;
                }
                case 77: {
                    op = this.UpperFunction();
                    break;
                }
                case 73: {
                    op = this.StringCastFunction();
                    break;
                }
                default: {
                    this.jj_la1[65] = this.jj_gen;
                    if (this.jj_2_16(2)) {
                        op = this.UserDefinedFunction();
                        ((UserDefinedFunction)op).setExpectedType('S');
                        break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 3: 
                        case 41: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 106: 
                        case 107: 
                        case 108: 
                        case 109: 
                        case 113: 
                        case 114: {
                            op = this.StringValueExpressionPrimary();
                            break block1;
                        }
                    }
                    this.jj_la1[66] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ADQLFunction aDQLFunction = op;
            return aDQLFunction;
        }
        finally {
            this.trace_return("StringFactor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GeometryFunction.GeometryValue<GeometryFunction> GeometryExpression() throws ParseException {
        this.trace_call("GeometryExpression");
        try {
            ADQLColumn col = null;
            UserDefinedFunction udf = null;
            CastFunction cf = null;
            GeometryFunction gf = null;
            block4 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: {
                    gf = this.GeometryValueFunction();
                    break;
                }
                case 73: {
                    cf = this.GeometricCastFunction();
                    break;
                }
                default: {
                    this.jj_la1[67] = this.jj_gen;
                    if (this.jj_2_17(2)) {
                        udf = this.UserDefinedFunction();
                        break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 113: 
                        case 114: {
                            col = this.Column();
                            break block4;
                        }
                    }
                    this.jj_la1[68] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (col != null) {
                col.setExpectedType('G');
                GeometryFunction.GeometryValue<GeometryFunction> geometryValue = new GeometryFunction.GeometryValue<GeometryFunction>(col);
                return geometryValue;
            }
            if (udf != null) {
                udf.setExpectedType('G');
                GeometryFunction.GeometryValue<GeometryFunction> geometryValue = new GeometryFunction.GeometryValue<GeometryFunction>(udf);
                return geometryValue;
            }
            if (cf != null) {
                udf.setExpectedType('G');
                GeometryFunction.GeometryValue<GeometryFunction> geometryValue = new GeometryFunction.GeometryValue<GeometryFunction>(cf);
                return geometryValue;
            }
            GeometryFunction.GeometryValue<GeometryFunction> geometryValue = new GeometryFunction.GeometryValue<GeometryFunction>(gf);
            return geometryValue;
        }
        finally {
            this.trace_return("GeometryExpression");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ClauseConstraints ConditionsList(ClauseConstraints clause) throws ParseException {
        this.trace_call("ConditionsList");
        try {
            block25: {
                ADQLConstraint constraint = null;
                Token op = null;
                boolean notOp = false;
                try {
                    TextPosition oldPos;
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 39: {
                            op = this.jj_consume_token(39);
                            notOp = true;
                            break;
                        }
                        default: {
                            this.jj_la1[69] = this.jj_gen;
                        }
                    }
                    constraint = this.Constraint();
                    if (notOp) {
                        oldPos = constraint.getPosition();
                        constraint = this.queryFactory.createNot(constraint);
                        ((NotConstraint)constraint).setPosition(new TextPosition(op.beginLine, op.beginColumn, oldPos.endLine, oldPos.endColumn));
                    }
                    notOp = false;
                    if (clause instanceof ADQLConstraint) {
                        clause.add(constraint);
                    } else {
                        clause.add(constraint);
                    }
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 37: 
                            case 38: {
                                break;
                            }
                            default: {
                                this.jj_la1[70] = this.jj_gen;
                                break block25;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 37: {
                                op = this.jj_consume_token(37);
                                break;
                            }
                            case 38: {
                                op = this.jj_consume_token(38);
                                break;
                            }
                            default: {
                                this.jj_la1[71] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 39: {
                                this.jj_consume_token(39);
                                notOp = true;
                                break;
                            }
                            default: {
                                this.jj_la1[72] = this.jj_gen;
                            }
                        }
                        constraint = this.Constraint();
                        if (notOp) {
                            oldPos = constraint.getPosition();
                            constraint = this.queryFactory.createNot(constraint);
                            ((NotConstraint)constraint).setPosition(new TextPosition(op.beginLine, op.beginColumn, oldPos.endLine, oldPos.endColumn));
                        }
                        notOp = false;
                        if (clause instanceof ADQLConstraint) {
                            clause.add(op.image, constraint);
                            continue;
                        }
                        clause.add(op.image, constraint);
                    }
                }
                catch (Exception ex) {
                    throw this.generateParseException(ex);
                }
            }
            if (!clause.isEmpty()) {
                TextPosition start = ((ADQLConstraint)clause.get(0)).getPosition();
                TextPosition end = ((ADQLConstraint)clause.get(clause.size() - 1)).getPosition();
                clause.setPosition(new TextPosition(start, end));
            }
            ClauseConstraints clauseConstraints = clause;
            return clauseConstraints;
        }
        finally {
            this.trace_return("ConditionsList");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ADQLConstraint Constraint() throws ParseException {
        this.trace_call("Constraint");
        try {
            ADQLConstraint constraint = null;
            if (this.jj_2_18(Integer.MAX_VALUE)) {
                Token start = this.jj_consume_token(3);
                try {
                    constraint = this.queryFactory.createGroupOfConstraints();
                }
                catch (Exception ex) {
                    throw this.generateParseException(ex);
                }
                this.ConditionsList((ClauseConstraints)((Object)constraint));
                Token end = this.jj_consume_token(4);
                ((ADQLList)((Object)constraint)).setPosition(new TextPosition(start, end));
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 3: 
                    case 12: 
                    case 13: 
                    case 41: 
                    case 46: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 113: 
                    case 114: {
                        constraint = this.Predicate();
                        break;
                    }
                    default: {
                        this.jj_la1[73] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            ADQLConstraint aDQLConstraint = constraint;
            return aDQLConstraint;
        }
        finally {
            this.trace_return("Constraint");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final ADQLConstraint Predicate() throws ParseException {
        this.trace_call("Predicate");
        try {
            block34: {
                q = null;
                column = null;
                strExpr1 = null;
                strExpr2 = null;
                notToken = null;
                constraint /* !! */  = null;
                try {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 46: {
                            start = this.jj_consume_token(46);
                            q = this.SubQueryExpression();
                            e = this.queryFactory.createExists(q);
                            e.setPosition(new TextPosition(start.beginLine, start.beginColumn, q.getPosition().endLine, q.getPosition().endColumn));
                            var11_14 = e;
                            return var11_14;
                        }
                    }
                    this.jj_la1[79] = this.jj_gen;
                    if (!this.jj_2_20(0x7FFFFFFF)) break block34;
                }
                catch (Exception ex) {
                    throw this.generateParseException(ex);
                }
                column = this.Column();
                this.jj_consume_token(40);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 39: {
                        notToken = this.jj_consume_token(39);
                        break;
                    }
                    default: {
                        this.jj_la1[74] = this.jj_gen;
                    }
                }
                end = this.jj_consume_token(41);
                in = this.queryFactory.createIsNull(notToken != null, column);
                in.setPosition(new TextPosition(column.getPosition().beginLine, column.getPosition().beginColumn, end.endLine, end.endColumn < 0 ? -1 : end.endColumn + 1));
                var11_15 = in;
                return var11_15;
            }
            if (this.jj_2_21(0x7FFFFFFF)) {
                strExpr1 = this.StringExpression();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 39: {
                        notToken = this.jj_consume_token(39);
                        break;
                    }
                    default: {
                        this.jj_la1[75] = this.jj_gen;
                    }
                }
                this.jj_consume_token(43);
                strExpr2 = this.StringExpression();
                comp = this.queryFactory.createComparison(strExpr1, notToken == null ? ComparisonOperator.LIKE : ComparisonOperator.NOTLIKE, strExpr2);
                comp.setPosition(new TextPosition(strExpr1.getPosition(), strExpr2.getPosition()));
                var11_16 = comp;
                return var11_16;
            }
            if (this.jj_2_22(0x7FFFFFFF)) {
                strExpr1 = this.StringExpression();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 39: {
                        notToken = this.jj_consume_token(39);
                        break;
                    }
                    default: {
                        this.jj_la1[76] = this.jj_gen;
                    }
                }
                this.jj_consume_token(44);
                strExpr2 = this.StringExpression();
                comp = this.queryFactory.createComparison(strExpr1, notToken == null ? ComparisonOperator.ILIKE : ComparisonOperator.NOTILIKE, strExpr2);
                comp.setPosition(new TextPosition(strExpr1.getPosition(), strExpr2.getPosition()));
                var11_17 = comp;
                return var11_17;
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 3: 
                case 12: 
                case 13: 
                case 41: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 113: 
                case 114: {
                    op = this.ValueExpression();
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: {
                            constraint /* !! */  = this.ComparisonEnd(op);
                            ** break;
                        }
                    }
                    this.jj_la1[77] = this.jj_gen;
                    if (this.jj_2_19(2)) {
                        constraint /* !! */  = this.BetweenEnd(op);
                        ** break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 39: 
                        case 45: {
                            constraint /* !! */  = this.InEnd(op);
                            ** break;
                        }
                    }
                    this.jj_la1[78] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[80] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
lbl93:
            // 3 sources

            var10_13 = constraint /* !! */ ;
            return var10_13;
        }
        finally {
            this.trace_return("Predicate");
        }
    }

    public final Comparison ComparisonEnd(ADQLOperand leftOp) throws ParseException {
        this.trace_call("ComparisonEnd");
        try {
            Token comp;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 16: {
                    comp = this.jj_consume_token(16);
                    break;
                }
                case 17: {
                    comp = this.jj_consume_token(17);
                    break;
                }
                case 18: {
                    comp = this.jj_consume_token(18);
                    break;
                }
                case 19: {
                    comp = this.jj_consume_token(19);
                    break;
                }
                case 20: {
                    comp = this.jj_consume_token(20);
                    break;
                }
                case 21: {
                    comp = this.jj_consume_token(21);
                    break;
                }
                default: {
                    this.jj_la1[81] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ADQLOperand rightOp = this.ValueExpression();
            try {
                Comparison comparison = this.queryFactory.createComparison(leftOp, ComparisonOperator.getOperator(comp.image), rightOp);
                comparison.setPosition(new TextPosition(leftOp.getPosition(), rightOp.getPosition()));
                Comparison comparison2 = comparison;
                return comparison2;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("ComparisonEnd");
        }
    }

    public final Between BetweenEnd(ADQLOperand leftOp) throws ParseException {
        this.trace_call("BetweenEnd");
        try {
            Token notToken = null;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 39: {
                    notToken = this.jj_consume_token(39);
                    break;
                }
                default: {
                    this.jj_la1[82] = this.jj_gen;
                }
            }
            Token start = this.jj_consume_token(42);
            ADQLOperand min = this.ValueExpression();
            this.jj_consume_token(37);
            ADQLOperand max = this.ValueExpression();
            try {
                Between bet = this.queryFactory.createBetween(notToken != null, leftOp, min, max);
                if (notToken != null) {
                    start = notToken;
                }
                bet.setPosition(new TextPosition(start.beginLine, start.beginColumn, max.getPosition().endLine, max.getPosition().endColumn));
                Between between = bet;
                return between;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("BetweenEnd");
        }
    }

    public final In InEnd(ADQLOperand leftOp) throws ParseException {
        this.trace_call("InEnd");
        try {
            Token not = null;
            ADQLSet q = null;
            Vector<ADQLOperand> items = new Vector<ADQLOperand>();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 39: {
                    not = this.jj_consume_token(39);
                    break;
                }
                default: {
                    this.jj_la1[83] = this.jj_gen;
                }
            }
            Token start = this.jj_consume_token(45);
            if (this.jj_2_23(2)) {
                q = this.SubQueryExpression();
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 3: {
                        this.jj_consume_token(3);
                        ADQLOperand item = this.ValueExpression();
                        items.add(item);
                        block15: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 6: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[84] = this.jj_gen;
                                    break block15;
                                }
                            }
                            this.jj_consume_token(6);
                            item = this.ValueExpression();
                            items.add(item);
                        }
                        this.jj_consume_token(4);
                        break;
                    }
                    default: {
                        this.jj_la1[85] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            try {
                In in;
                Token token = start = not != null ? not : start;
                if (q != null) {
                    in = this.queryFactory.createIn(leftOp, q, not != null);
                    in.setPosition(new TextPosition(start.beginLine, start.beginColumn, q.getPosition().endLine, q.getPosition().endColumn));
                } else {
                    ADQLOperand[] list = new ADQLOperand[items.size()];
                    int i = 0;
                    for (ADQLOperand op : items) {
                        list[i++] = op;
                    }
                    in = this.queryFactory.createIn(leftOp, list, not != null);
                    in.setPosition(new TextPosition(start.beginLine, start.beginColumn, list[list.length - 1].getPosition().endLine, list[list.length - 1].getPosition().endColumn));
                }
                In in2 = in;
                return in2;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("InEnd");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SQLFunction SqlFunction() throws ParseException {
        this.trace_call("SqlFunction");
        try {
            Token all = null;
            Token distinct = null;
            ADQLOperand op = null;
            SQLFunction funct = null;
            try {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 59: {
                        Token fct = this.jj_consume_token(59);
                        this.jj_consume_token(3);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 23: {
                                distinct = this.jj_consume_token(23);
                                break;
                            }
                            default: {
                                this.jj_la1[86] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 14: {
                                all = this.jj_consume_token(14);
                                break;
                            }
                            case 3: 
                            case 12: 
                            case 13: 
                            case 41: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 63: 
                            case 64: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 76: 
                            case 77: 
                            case 78: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 90: 
                            case 91: 
                            case 92: 
                            case 93: 
                            case 94: 
                            case 95: 
                            case 96: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 106: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 113: 
                            case 114: {
                                op = this.ValueExpression();
                                break;
                            }
                            default: {
                                this.jj_la1[87] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        Token end = this.jj_consume_token(4);
                        funct = this.queryFactory.createSQLFunction(all != null ? SQLFunctionType.COUNT_ALL : SQLFunctionType.COUNT, op, distinct != null && distinct.image.equalsIgnoreCase("distinct"));
                        funct.setPosition(new TextPosition(fct, end));
                        break;
                    }
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: {
                        Token fct;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 55: {
                                fct = this.jj_consume_token(55);
                                break;
                            }
                            case 56: {
                                fct = this.jj_consume_token(56);
                                break;
                            }
                            case 57: {
                                fct = this.jj_consume_token(57);
                                break;
                            }
                            case 58: {
                                fct = this.jj_consume_token(58);
                                break;
                            }
                            default: {
                                this.jj_la1[88] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.jj_consume_token(3);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 23: {
                                distinct = this.jj_consume_token(23);
                                break;
                            }
                            default: {
                                this.jj_la1[89] = this.jj_gen;
                            }
                        }
                        op = this.ValueExpression();
                        Token end = this.jj_consume_token(4);
                        funct = this.queryFactory.createSQLFunction(SQLFunctionType.valueOf(fct.image.toUpperCase()), op, distinct != null && distinct.image.equalsIgnoreCase("distinct"));
                        funct.setPosition(new TextPosition(fct, end));
                        break;
                    }
                    default: {
                        this.jj_la1[90] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
            SQLFunction sQLFunction = funct;
            return sQLFunction;
        }
        finally {
            this.trace_return("SqlFunction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ADQLOperand[] Coordinates() throws ParseException {
        this.trace_call("Coordinates");
        try {
            ADQLOperand op1 = this.NumericExpression();
            this.jj_consume_token(6);
            ADQLOperand op2 = this.NumericExpression();
            ADQLOperand[] aDQLOperandArray = new ADQLOperand[]{op1, op2};
            return aDQLOperandArray;
        }
        finally {
            this.trace_return("Coordinates");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GeometryFunction GeometryFunction() throws ParseException {
        this.trace_call("GeometryFunction");
        try {
            Token fct = null;
            Token end = null;
            GeometryFunction gf = null;
            PointFunction p1 = null;
            Object p2 = null;
            ADQLColumn col1 = null;
            Object col2 = null;
            try {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 66: 
                    case 67: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 66: {
                                fct = this.jj_consume_token(66);
                                break;
                            }
                            case 67: {
                                fct = this.jj_consume_token(67);
                                break;
                            }
                            default: {
                                this.jj_la1[91] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.jj_consume_token(3);
                        GeometryFunction.GeometryValue<GeometryFunction> gvf1 = this.GeometryExpression();
                        this.jj_consume_token(6);
                        GeometryFunction.GeometryValue<GeometryFunction> gvf2 = this.GeometryExpression();
                        end = this.jj_consume_token(4);
                        if (fct.image.equalsIgnoreCase("contains")) {
                            gf = this.queryFactory.createContains(gvf1, gvf2);
                            break;
                        }
                        gf = this.queryFactory.createIntersects(gvf1, gvf2);
                        break;
                    }
                    case 68: {
                        fct = this.jj_consume_token(68);
                        this.jj_consume_token(3);
                        GeometryFunction.GeometryValue<GeometryFunction> gvf1 = this.GeometryExpression();
                        end = this.jj_consume_token(4);
                        gf = this.queryFactory.createArea(gvf1);
                        break;
                    }
                    case 69: {
                        fct = this.jj_consume_token(69);
                        this.jj_consume_token(3);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 63: {
                                p1 = this.Point();
                                gf = this.queryFactory.createCoord1(p1);
                                break;
                            }
                            case 113: 
                            case 114: {
                                col1 = this.Column();
                                col1.setExpectedType('G');
                                gf = this.queryFactory.createCoord1(col1);
                                break;
                            }
                            default: {
                                this.jj_la1[92] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 70: {
                        fct = this.jj_consume_token(70);
                        this.jj_consume_token(3);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 63: {
                                p1 = this.Point();
                                gf = this.queryFactory.createCoord2(p1);
                                break;
                            }
                            case 113: 
                            case 114: {
                                col1 = this.Column();
                                col1.setExpectedType('G');
                                gf = this.queryFactory.createCoord2(col1);
                                break;
                            }
                            default: {
                                this.jj_la1[93] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 72: {
                        gf = this.DistanceFunction();
                        break;
                    }
                    default: {
                        this.jj_la1[94] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
            if (fct != null) {
                gf.setPosition(new TextPosition(fct, end));
            }
            DistanceFunction distanceFunction = gf;
            return distanceFunction;
        }
        finally {
            this.trace_return("GeometryFunction");
        }
    }

    public final DistanceFunction DistanceFunction() throws ParseException {
        this.trace_call("DistanceFunction");
        try {
            Token fct = null;
            Token end = null;
            try {
                DistanceFunction gf;
                if (this.jj_2_24(Integer.MAX_VALUE)) {
                    gf = this.DistanceFunction2();
                } else {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 72: {
                            fct = this.jj_consume_token(72);
                            this.jj_consume_token(3);
                            ADQLOperand lon = this.NumericExpression();
                            this.jj_consume_token(6);
                            ADQLOperand lat = this.NumericExpression();
                            GeometryFunction.GeometryValue<GeometryFunction> gvp1 = new GeometryFunction.GeometryValue<GeometryFunction>(this.queryFactory.createPoint(null, lon, lat));
                            this.jj_consume_token(6);
                            lon = this.NumericExpression();
                            this.jj_consume_token(6);
                            lat = this.NumericExpression();
                            GeometryFunction.GeometryValue<GeometryFunction> gvp2 = new GeometryFunction.GeometryValue<GeometryFunction>(this.queryFactory.createPoint(null, lon, lat));
                            end = this.jj_consume_token(4);
                            gf = this.queryFactory.createDistance(gvp1, gvp2);
                            gf.setPosition(new TextPosition(fct, end));
                            break;
                        }
                        default: {
                            this.jj_la1[95] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                DistanceFunction distanceFunction = gf;
                return distanceFunction;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("DistanceFunction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GeometryFunction.GeometryValue<GeometryFunction> PointValue() throws ParseException {
        this.trace_call("PointValue");
        try {
            GeometryFunction p = null;
            ADQLColumn col = null;
            UserDefinedFunction udf = null;
            block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 63: {
                    p = this.Point();
                    break;
                }
                case 61: {
                    p = this.Centroid();
                    break;
                }
                default: {
                    this.jj_la1[96] = this.jj_gen;
                    if (this.jj_2_25(2)) {
                        udf = this.UserDefinedFunction();
                        break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 113: 
                        case 114: {
                            col = this.Column();
                            break block3;
                        }
                    }
                    this.jj_la1[97] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (p != null) {
                GeometryFunction.GeometryValue<GeometryFunction> geometryValue = new GeometryFunction.GeometryValue<GeometryFunction>(p);
                return geometryValue;
            }
            if (udf != null) {
                udf.setExpectedType('G');
                GeometryFunction.GeometryValue<GeometryFunction> geometryValue = new GeometryFunction.GeometryValue<GeometryFunction>(udf);
                return geometryValue;
            }
            col.setExpectedType('G');
            GeometryFunction.GeometryValue<GeometryFunction> geometryValue = new GeometryFunction.GeometryValue<GeometryFunction>(col);
            return geometryValue;
        }
        finally {
            this.trace_return("PointValue");
        }
    }

    public final DistanceFunction DistanceFunction2() throws ParseException {
        this.trace_call("DistanceFunction2");
        try {
            Token fct = null;
            Token end = null;
            Object p1 = null;
            Object p2 = null;
            Object col1 = null;
            Object col2 = null;
            Object udf1 = null;
            Object udf2 = null;
            try {
                fct = this.jj_consume_token(72);
                this.jj_consume_token(3);
                GeometryFunction.GeometryValue<GeometryFunction> gvp1 = this.PointValue();
                this.jj_consume_token(6);
                GeometryFunction.GeometryValue<GeometryFunction> gvp2 = this.PointValue();
                end = this.jj_consume_token(4);
                DistanceFunction gf = this.queryFactory.createDistance(gvp1, gvp2);
                gf.setPosition(new TextPosition(fct, end));
                DistanceFunction distanceFunction = gf;
                return distanceFunction;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("DistanceFunction2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ADQLOperand CoordinateSystem() throws ParseException {
        this.trace_call("CoordinateSystem");
        try {
            ADQLOperand coordSys = null;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 41: {
                    Token tok = this.jj_consume_token(41);
                    coordSys = this.queryFactory.createNullValue();
                    ((NullValue)coordSys).setPosition(new TextPosition(tok));
                    break;
                }
                case 106: {
                    coordSys = this.String();
                    break;
                }
                default: {
                    this.jj_la1[98] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            StringConstant stringConstant = coordSys;
            return stringConstant;
        }
        finally {
            this.trace_return("CoordinateSystem");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GeometryFunction GeometryValueFunction() throws ParseException {
        this.trace_call("GeometryValueFunction");
        try {
            Token fct = null;
            Token end = null;
            Object coords = null;
            ADQLOperand op = null;
            Object gvf = null;
            Object gvp = null;
            GeometryFunction gf = null;
            try {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 60: {
                        gf = this.Box();
                        break;
                    }
                    case 61: {
                        gf = this.Centroid();
                        break;
                    }
                    case 62: {
                        gf = this.Circle();
                        break;
                    }
                    case 63: {
                        gf = this.Point();
                        break;
                    }
                    case 64: {
                        gf = this.Polygon();
                        break;
                    }
                    case 65: {
                        fct = this.jj_consume_token(65);
                        this.jj_consume_token(3);
                        op = this.StringExpression();
                        end = this.jj_consume_token(4);
                        gf = this.queryFactory.createRegion(op);
                        gf.setPosition(new TextPosition(fct, end));
                        break;
                    }
                    default: {
                        this.jj_la1[99] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
            GeometryFunction geometryFunction = gf;
            return geometryFunction;
        }
        finally {
            this.trace_return("GeometryValueFunction");
        }
    }

    public final GeometryFunction Box() throws ParseException {
        this.trace_call("Box");
        try {
            GeometryFunction gf;
            if (this.jj_2_26(Integer.MAX_VALUE)) {
                gf = this.BoxWithPoint();
            } else if (this.jj_2_27(Integer.MAX_VALUE)) {
                gf = this.BoxWithCoordsAndNoCoordSys();
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 60: {
                        gf = this.BoxWithCoordsAndCoordSys();
                        break;
                    }
                    default: {
                        this.jj_la1[100] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            GeometryFunction geometryFunction = gf;
            return geometryFunction;
        }
        finally {
            this.trace_return("Box");
        }
    }

    public final GeometryFunction BoxWithPoint() throws ParseException {
        this.trace_call("BoxWithPoint");
        try {
            Token fct = null;
            Token end = null;
            ADQLOperand coordSys = null;
            GeometryFunction.GeometryValue<GeometryFunction> center = null;
            fct = this.jj_consume_token(60);
            this.jj_consume_token(3);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 41: 
                case 106: {
                    coordSys = this.CoordinateSystem();
                    this.jj_consume_token(6);
                    break;
                }
                default: {
                    this.jj_la1[101] = this.jj_gen;
                }
            }
            center = this.PointValue();
            this.jj_consume_token(6);
            ADQLOperand width = this.NumericExpression();
            this.jj_consume_token(6);
            ADQLOperand height = this.NumericExpression();
            end = this.jj_consume_token(4);
            try {
                BoxFunction gf = this.queryFactory.createBox(coordSys, center, width, height);
                gf.setPosition(new TextPosition(fct, end));
                BoxFunction boxFunction = gf;
                return boxFunction;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("BoxWithPoint");
        }
    }

    public final GeometryFunction BoxWithCoordsAndCoordSys() throws ParseException {
        this.trace_call("BoxWithCoordsAndCoordSys");
        try {
            Token fct = null;
            Token end = null;
            ADQLOperand coordSys = null;
            ADQLOperand[] coords = null;
            fct = this.jj_consume_token(60);
            this.jj_consume_token(3);
            coordSys = this.CoordinateSystem();
            this.jj_consume_token(6);
            coords = this.Coordinates();
            this.jj_consume_token(6);
            ADQLOperand width = this.NumericExpression();
            this.jj_consume_token(6);
            ADQLOperand height = this.NumericExpression();
            end = this.jj_consume_token(4);
            try {
                BoxFunction gf = this.queryFactory.createBox(coordSys, coords[0], coords[1], width, height);
                gf.setPosition(new TextPosition(fct, end));
                BoxFunction boxFunction = gf;
                return boxFunction;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("BoxWithCoordsAndCoordSys");
        }
    }

    public final GeometryFunction BoxWithCoordsAndNoCoordSys() throws ParseException {
        this.trace_call("BoxWithCoordsAndNoCoordSys");
        try {
            Token fct = null;
            Token end = null;
            ADQLOperand[] coords = null;
            fct = this.jj_consume_token(60);
            this.jj_consume_token(3);
            coords = this.Coordinates();
            this.jj_consume_token(6);
            ADQLOperand width = this.NumericExpression();
            this.jj_consume_token(6);
            ADQLOperand height = this.NumericExpression();
            end = this.jj_consume_token(4);
            try {
                BoxFunction gf = this.queryFactory.createBox(null, coords[0], coords[1], width, height);
                gf.setPosition(new TextPosition(fct, end));
                BoxFunction boxFunction = gf;
                return boxFunction;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("BoxWithCoordsAndNoCoordSys");
        }
    }

    public final GeometryFunction Circle() throws ParseException {
        this.trace_call("Circle");
        try {
            GeometryFunction gf;
            if (this.jj_2_28(Integer.MAX_VALUE)) {
                gf = this.CircleWithPoint();
            } else if (this.jj_2_29(Integer.MAX_VALUE)) {
                gf = this.CircleWithCoordsAndNoCoordSys();
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 62: {
                        gf = this.CircleWithCoordsAndCoordSys();
                        break;
                    }
                    default: {
                        this.jj_la1[102] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            GeometryFunction geometryFunction = gf;
            return geometryFunction;
        }
        finally {
            this.trace_return("Circle");
        }
    }

    public final GeometryFunction CircleWithPoint() throws ParseException {
        this.trace_call("CircleWithPoint");
        try {
            Token fct = null;
            Token end = null;
            ADQLOperand coordSys = null;
            GeometryFunction.GeometryValue<GeometryFunction> center = null;
            fct = this.jj_consume_token(62);
            this.jj_consume_token(3);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 41: 
                case 106: {
                    coordSys = this.CoordinateSystem();
                    this.jj_consume_token(6);
                    break;
                }
                default: {
                    this.jj_la1[103] = this.jj_gen;
                }
            }
            center = this.PointValue();
            this.jj_consume_token(6);
            ADQLOperand width = this.NumericExpression();
            end = this.jj_consume_token(4);
            try {
                CircleFunction gf = this.queryFactory.createCircle(coordSys, center, width);
                gf.setPosition(new TextPosition(fct, end));
                CircleFunction circleFunction = gf;
                return circleFunction;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("CircleWithPoint");
        }
    }

    public final GeometryFunction CircleWithCoordsAndCoordSys() throws ParseException {
        this.trace_call("CircleWithCoordsAndCoordSys");
        try {
            Token fct = null;
            Token end = null;
            ADQLOperand coordSys = null;
            ADQLOperand[] coords = null;
            fct = this.jj_consume_token(62);
            this.jj_consume_token(3);
            coordSys = this.CoordinateSystem();
            this.jj_consume_token(6);
            coords = this.Coordinates();
            this.jj_consume_token(6);
            ADQLOperand width = this.NumericExpression();
            end = this.jj_consume_token(4);
            try {
                CircleFunction gf = this.queryFactory.createCircle(coordSys, coords[0], coords[1], width);
                gf.setPosition(new TextPosition(fct, end));
                CircleFunction circleFunction = gf;
                return circleFunction;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("CircleWithCoordsAndCoordSys");
        }
    }

    public final GeometryFunction CircleWithCoordsAndNoCoordSys() throws ParseException {
        this.trace_call("CircleWithCoordsAndNoCoordSys");
        try {
            Token fct = null;
            Token end = null;
            ADQLOperand[] coords = null;
            fct = this.jj_consume_token(62);
            this.jj_consume_token(3);
            coords = this.Coordinates();
            this.jj_consume_token(6);
            ADQLOperand width = this.NumericExpression();
            end = this.jj_consume_token(4);
            try {
                CircleFunction gf = this.queryFactory.createCircle(null, coords[0], coords[1], width);
                gf.setPosition(new TextPosition(fct, end));
                CircleFunction circleFunction = gf;
                return circleFunction;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("CircleWithCoordsAndNoCoordSys");
        }
    }

    public final CentroidFunction Centroid() throws ParseException {
        this.trace_call("Centroid");
        try {
            Token fct = null;
            Token end = null;
            GeometryFunction.GeometryValue<GeometryFunction> gvf = null;
            fct = this.jj_consume_token(61);
            this.jj_consume_token(3);
            gvf = this.GeometryExpression();
            end = this.jj_consume_token(4);
            try {
                CentroidFunction cf = this.queryFactory.createCentroid(gvf);
                cf.setPosition(new TextPosition(fct, end));
                CentroidFunction centroidFunction = cf;
                return centroidFunction;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("Centroid");
        }
    }

    public final PointFunction Point() throws ParseException {
        this.trace_call("Point");
        try {
            PointFunction pf;
            if (this.jj_2_30(Integer.MAX_VALUE)) {
                pf = this.PointWithoutCoordSys();
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 63: {
                        pf = this.PointWithCoordSys();
                        break;
                    }
                    default: {
                        this.jj_la1[104] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            PointFunction pointFunction = pf;
            return pointFunction;
        }
        finally {
            this.trace_return("Point");
        }
    }

    public final PointFunction PointWithoutCoordSys() throws ParseException {
        this.trace_call("PointWithoutCoordSys");
        try {
            Token start = this.jj_consume_token(63);
            this.jj_consume_token(3);
            ADQLOperand[] coords = this.Coordinates();
            Token end = this.jj_consume_token(4);
            try {
                PointFunction pf = this.queryFactory.createPoint(null, coords[0], coords[1]);
                pf.setPosition(new TextPosition(start, end));
                PointFunction pointFunction = pf;
                return pointFunction;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("PointWithoutCoordSys");
        }
    }

    public final PointFunction PointWithCoordSys() throws ParseException {
        this.trace_call("PointWithCoordSys");
        try {
            ADQLOperand coordSys = null;
            Token start = this.jj_consume_token(63);
            this.jj_consume_token(3);
            coordSys = this.CoordinateSystem();
            this.jj_consume_token(6);
            ADQLOperand[] coords = this.Coordinates();
            Token end = this.jj_consume_token(4);
            try {
                PointFunction pf = this.queryFactory.createPoint(coordSys, coords[0], coords[1]);
                pf.setPosition(new TextPosition(start, end));
                PointFunction pointFunction = pf;
                return pointFunction;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("PointWithCoordSys");
        }
    }

    public final GeometryFunction Polygon() throws ParseException {
        this.trace_call("Polygon");
        try {
            GeometryFunction gf;
            if (this.jj_2_31(Integer.MAX_VALUE)) {
                gf = this.PolygonWithPoints();
            } else if (this.jj_2_32(Integer.MAX_VALUE)) {
                gf = this.PolygonWithCoordsAndNoCoordSys();
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 64: {
                        gf = this.PolygonWithCoordsAndCoordSys();
                        break;
                    }
                    default: {
                        this.jj_la1[105] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            GeometryFunction geometryFunction = gf;
            return geometryFunction;
        }
        finally {
            this.trace_return("Polygon");
        }
    }

    public final GeometryFunction PolygonWithPoints() throws ParseException {
        this.trace_call("PolygonWithPoints");
        try {
            Token fct = null;
            Token end = null;
            ADQLOperand coordSys = null;
            fct = this.jj_consume_token(64);
            this.jj_consume_token(3);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 41: 
                case 106: {
                    coordSys = this.CoordinateSystem();
                    this.jj_consume_token(6);
                    break;
                }
                default: {
                    this.jj_la1[106] = this.jj_gen;
                }
            }
            Vector<GeometryFunction.GeometryValue<GeometryFunction>> vCoords = new Vector<GeometryFunction.GeometryValue<GeometryFunction>>();
            GeometryFunction.GeometryValue<GeometryFunction> tmp = this.PointValue();
            vCoords.add(tmp);
            this.jj_consume_token(6);
            tmp = this.PointValue();
            vCoords.add(tmp);
            this.jj_consume_token(6);
            tmp = this.PointValue();
            vCoords.add(tmp);
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 6: {
                        break;
                    }
                    default: {
                        this.jj_la1[107] = this.jj_gen;
                        break block12;
                    }
                }
                this.jj_consume_token(6);
                tmp = this.PointValue();
                vCoords.add(tmp);
            }
            end = this.jj_consume_token(4);
            try {
                PolygonFunction gf = this.queryFactory.createPolygon(coordSys, vCoords);
                gf.setPosition(new TextPosition(fct, end));
                PolygonFunction polygonFunction = gf;
                return polygonFunction;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("PolygonWithPoints");
        }
    }

    public final GeometryFunction PolygonWithCoordsAndCoordSys() throws ParseException {
        this.trace_call("PolygonWithCoordsAndCoordSys");
        try {
            Token fct = null;
            Token end = null;
            ADQLOperand coordSys = null;
            fct = this.jj_consume_token(64);
            this.jj_consume_token(3);
            coordSys = this.CoordinateSystem();
            this.jj_consume_token(6);
            Vector<ADQLOperand> vCoords = new Vector<ADQLOperand>();
            ADQLOperand[] tmp = this.Coordinates();
            vCoords.add(tmp[0]);
            vCoords.add(tmp[1]);
            this.jj_consume_token(6);
            tmp = this.Coordinates();
            vCoords.add(tmp[0]);
            vCoords.add(tmp[1]);
            this.jj_consume_token(6);
            tmp = this.Coordinates();
            vCoords.add(tmp[0]);
            vCoords.add(tmp[1]);
            block9: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 6: {
                        break;
                    }
                    default: {
                        this.jj_la1[108] = this.jj_gen;
                        break block9;
                    }
                }
                this.jj_consume_token(6);
                tmp = this.Coordinates();
                vCoords.add(tmp[0]);
                vCoords.add(tmp[1]);
            }
            end = this.jj_consume_token(4);
            try {
                PolygonFunction gf = this.queryFactory.createPolygon(coordSys, vCoords);
                gf.setPosition(new TextPosition(fct, end));
                PolygonFunction polygonFunction = gf;
                return polygonFunction;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("PolygonWithCoordsAndCoordSys");
        }
    }

    public final GeometryFunction PolygonWithCoordsAndNoCoordSys() throws ParseException {
        this.trace_call("PolygonWithCoordsAndNoCoordSys");
        try {
            Token fct = null;
            Token end = null;
            fct = this.jj_consume_token(64);
            this.jj_consume_token(3);
            Vector<ADQLOperand> vCoords = new Vector<ADQLOperand>();
            ADQLOperand[] tmp = this.Coordinates();
            vCoords.add(tmp[0]);
            vCoords.add(tmp[1]);
            this.jj_consume_token(6);
            tmp = this.Coordinates();
            vCoords.add(tmp[0]);
            vCoords.add(tmp[1]);
            this.jj_consume_token(6);
            tmp = this.Coordinates();
            vCoords.add(tmp[0]);
            vCoords.add(tmp[1]);
            block9: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 6: {
                        break;
                    }
                    default: {
                        this.jj_la1[109] = this.jj_gen;
                        break block9;
                    }
                }
                this.jj_consume_token(6);
                tmp = this.Coordinates();
                vCoords.add(tmp[0]);
                vCoords.add(tmp[1]);
            }
            end = this.jj_consume_token(4);
            try {
                PolygonFunction gf = this.queryFactory.createPolygon(null, vCoords);
                gf.setPosition(new TextPosition(fct, end));
                PolygonFunction polygonFunction = gf;
                return polygonFunction;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("PolygonWithCoordsAndNoCoordSys");
        }
    }

    public final GeometryFunction ExtractCoordSys() throws ParseException {
        this.trace_call("ExtractCoordSys");
        try {
            Token start = this.jj_consume_token(71);
            this.jj_consume_token(3);
            GeometryFunction.GeometryValue<GeometryFunction> gvf = this.GeometryExpression();
            Token end = this.jj_consume_token(4);
            try {
                ExtractCoordSys gf = this.queryFactory.createExtractCoordSys(gvf);
                gf.setPosition(new TextPosition(start, end));
                ExtractCoordSys extractCoordSys = gf;
                return extractCoordSys;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("ExtractCoordSys");
        }
    }

    public final LowerFunction LowerFunction() throws ParseException {
        this.trace_call("LowerFunction");
        try {
            Token start = this.jj_consume_token(76);
            this.jj_consume_token(3);
            ADQLOperand str = this.StringExpression();
            Token end = this.jj_consume_token(4);
            try {
                LowerFunction lf = this.queryFactory.createLowerFunction(str);
                lf.setPosition(new TextPosition(start, end));
                LowerFunction lowerFunction = lf;
                return lowerFunction;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("LowerFunction");
        }
    }

    public final UpperFunction UpperFunction() throws ParseException {
        this.trace_call("UpperFunction");
        try {
            Token start = this.jj_consume_token(77);
            this.jj_consume_token(3);
            ADQLOperand str = this.StringExpression();
            Token end = this.jj_consume_token(4);
            try {
                UpperFunction lf = this.queryFactory.createUpperFunction(str);
                lf.setPosition(new TextPosition(start, end));
                UpperFunction upperFunction = lf;
                return upperFunction;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("UpperFunction");
        }
    }

    public final ADQLFunction NumericFunction() throws ParseException {
        this.trace_call("NumericFunction");
        try {
            ADQLFunction fct;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: {
                    fct = this.MathFunction();
                    break;
                }
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: {
                    fct = this.TrigFunction();
                    break;
                }
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 72: {
                    fct = this.GeometryFunction();
                    break;
                }
                case 101: {
                    fct = this.InUnitFunction();
                    break;
                }
                case 73: {
                    fct = this.NumericCastFunction();
                    break;
                }
                case 114: {
                    fct = this.UserDefinedFunction();
                    ((UserDefinedFunction)fct).setExpectedType('N');
                    break;
                }
                default: {
                    this.jj_la1[110] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ADQLFunction aDQLFunction = fct;
            return aDQLFunction;
        }
        finally {
            this.trace_return("NumericFunction");
        }
    }

    public final InUnitFunction InUnitFunction() throws ParseException {
        this.trace_call("InUnitFunction");
        try {
            Token start = this.jj_consume_token(101);
            this.jj_consume_token(3);
            ADQLOperand value = this.NumericExpression();
            this.jj_consume_token(6);
            ADQLOperand destUnit = this.StringExpression();
            Token end = this.jj_consume_token(4);
            try {
                InUnitFunction fct = this.queryFactory.createInUnitFunction(value, destUnit);
                fct.setPosition(new TextPosition(start, end));
                InUnitFunction inUnitFunction = fct;
                return inUnitFunction;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("InUnitFunction");
        }
    }

    public final MathFunction MathFunction() throws ParseException {
        this.trace_call("MathFunction");
        try {
            Token fct = null;
            ADQLOperand param1 = null;
            ADQLOperand param2 = null;
            Object integerValue = null;
            try {
                Token end;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 78: {
                        fct = this.jj_consume_token(78);
                        this.jj_consume_token(3);
                        param1 = this.NumericExpression();
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 79: {
                        fct = this.jj_consume_token(79);
                        this.jj_consume_token(3);
                        param1 = this.NumericExpression();
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 80: {
                        fct = this.jj_consume_token(80);
                        this.jj_consume_token(3);
                        param1 = this.NumericExpression();
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 81: {
                        fct = this.jj_consume_token(81);
                        this.jj_consume_token(3);
                        param1 = this.NumericExpression();
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 82: {
                        fct = this.jj_consume_token(82);
                        this.jj_consume_token(3);
                        param1 = this.NumericExpression();
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 83: {
                        fct = this.jj_consume_token(83);
                        this.jj_consume_token(3);
                        param1 = this.NumericExpression();
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 84: {
                        fct = this.jj_consume_token(84);
                        this.jj_consume_token(3);
                        param1 = this.NumericExpression();
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 85: {
                        fct = this.jj_consume_token(85);
                        this.jj_consume_token(3);
                        param1 = this.NumericExpression();
                        this.jj_consume_token(6);
                        param2 = this.NumericExpression();
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 86: {
                        fct = this.jj_consume_token(86);
                        this.jj_consume_token(3);
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 87: {
                        fct = this.jj_consume_token(87);
                        this.jj_consume_token(3);
                        param1 = this.NumericExpression();
                        this.jj_consume_token(6);
                        param2 = this.NumericExpression();
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 88: {
                        fct = this.jj_consume_token(88);
                        this.jj_consume_token(3);
                        param1 = this.NumericExpression();
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 89: {
                        fct = this.jj_consume_token(89);
                        this.jj_consume_token(3);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 3: 
                            case 12: 
                            case 13: 
                            case 41: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 72: 
                            case 73: 
                            case 78: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 90: 
                            case 91: 
                            case 92: 
                            case 93: 
                            case 94: 
                            case 95: 
                            case 96: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 113: 
                            case 114: {
                                param1 = this.NumericExpression();
                                break;
                            }
                            default: {
                                this.jj_la1[111] = this.jj_gen;
                            }
                        }
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 90: {
                        fct = this.jj_consume_token(90);
                        this.jj_consume_token(3);
                        param1 = this.NumericExpression();
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 6: {
                                this.jj_consume_token(6);
                                param2 = this.SignedInteger();
                                break;
                            }
                            default: {
                                this.jj_la1[112] = this.jj_gen;
                            }
                        }
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 91: {
                        fct = this.jj_consume_token(91);
                        this.jj_consume_token(3);
                        param1 = this.NumericExpression();
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 92: {
                        fct = this.jj_consume_token(92);
                        this.jj_consume_token(3);
                        param1 = this.NumericExpression();
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 6: {
                                this.jj_consume_token(6);
                                param2 = this.SignedInteger();
                                break;
                            }
                            default: {
                                this.jj_la1[113] = this.jj_gen;
                            }
                        }
                        end = this.jj_consume_token(4);
                        break;
                    }
                    default: {
                        this.jj_la1[114] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                MathFunction mf = this.queryFactory.createMathFunction(MathFunctionType.valueOf(fct.image.toUpperCase()), param1, param2);
                mf.setPosition(new TextPosition(fct, end));
                MathFunction mathFunction = mf;
                return mathFunction;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("MathFunction");
        }
    }

    public final MathFunction TrigFunction() throws ParseException {
        this.trace_call("TrigFunction");
        try {
            Token end;
            Token fct = null;
            ADQLOperand param1 = null;
            ADQLOperand param2 = null;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 93: {
                    fct = this.jj_consume_token(93);
                    this.jj_consume_token(3);
                    param1 = this.NumericExpression();
                    end = this.jj_consume_token(4);
                    break;
                }
                case 94: {
                    fct = this.jj_consume_token(94);
                    this.jj_consume_token(3);
                    param1 = this.NumericExpression();
                    end = this.jj_consume_token(4);
                    break;
                }
                case 95: {
                    fct = this.jj_consume_token(95);
                    this.jj_consume_token(3);
                    param1 = this.NumericExpression();
                    end = this.jj_consume_token(4);
                    break;
                }
                case 96: {
                    fct = this.jj_consume_token(96);
                    this.jj_consume_token(3);
                    param1 = this.NumericExpression();
                    this.jj_consume_token(6);
                    param2 = this.NumericExpression();
                    end = this.jj_consume_token(4);
                    break;
                }
                case 97: {
                    fct = this.jj_consume_token(97);
                    this.jj_consume_token(3);
                    param1 = this.NumericExpression();
                    end = this.jj_consume_token(4);
                    break;
                }
                case 98: {
                    fct = this.jj_consume_token(98);
                    this.jj_consume_token(3);
                    param1 = this.NumericExpression();
                    end = this.jj_consume_token(4);
                    break;
                }
                case 99: {
                    fct = this.jj_consume_token(99);
                    this.jj_consume_token(3);
                    param1 = this.NumericExpression();
                    end = this.jj_consume_token(4);
                    break;
                }
                case 100: {
                    fct = this.jj_consume_token(100);
                    this.jj_consume_token(3);
                    param1 = this.NumericExpression();
                    end = this.jj_consume_token(4);
                    break;
                }
                default: {
                    this.jj_la1[115] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            try {
                MathFunction mf = this.queryFactory.createMathFunction(MathFunctionType.valueOf(fct.image.toUpperCase()), param1, param2);
                mf.setPosition(new TextPosition(fct, end));
                MathFunction mathFunction = mf;
                return mathFunction;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("TrigFunction");
        }
    }

    public final CastFunction NumericCastFunction() throws ParseException {
        this.trace_call("NumericCastFunction");
        try {
            CastFunction fct = this.CastFunction('N');
            fct.setExpectedType('N');
            CastFunction castFunction = fct;
            return castFunction;
        }
        finally {
            this.trace_return("NumericCastFunction");
        }
    }

    public final CastFunction StringCastFunction() throws ParseException {
        this.trace_call("StringCastFunction");
        try {
            CastFunction fct = this.CastFunction('S');
            fct.setExpectedType('S');
            CastFunction castFunction = fct;
            return castFunction;
        }
        finally {
            this.trace_return("StringCastFunction");
        }
    }

    public final CastFunction GeometricCastFunction() throws ParseException {
        this.trace_call("GeometricCastFunction");
        try {
            CastFunction fct = this.CastFunction('G');
            fct.setExpectedType('G');
            CastFunction castFunction = fct;
            return castFunction;
        }
        finally {
            this.trace_return("GeometricCastFunction");
        }
    }

    public final CastFunction CastFunction(char expectedType) throws ParseException {
        this.trace_call("CastFunction");
        try {
            Object typeSize = null;
            ADQLOperand value = null;
            Token fct = this.jj_consume_token(73);
            this.jj_consume_token(3);
            value = this.ValueExpression();
            this.jj_consume_token(26);
            TargetType type = this.CastDatatype(expectedType);
            Token end = this.jj_consume_token(4);
            try {
                CastFunction cast = this.queryFactory.createCastFunction(value, type);
                cast.setPosition(new TextPosition(fct, end));
                CastFunction castFunction = cast;
                return castFunction;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("CastFunction");
        }
    }

    public final TargetType CastDatatype(char expectedType) throws ParseException {
        this.trace_call("CastDatatype");
        try {
            Token typeName;
            Token typeLength = null;
            Token start = null;
            Token end = null;
            String customName = null;
            ArrayList<ADQLOperand> customParams = new ArrayList<ADQLOperand>();
            block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 62: 
                case 63: 
                case 64: 
                case 75: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 75: {
                            typeName = this.jj_consume_token(75);
                            break block3;
                        }
                        case 63: {
                            typeName = this.jj_consume_token(63);
                            break block3;
                        }
                        case 62: {
                            typeName = this.jj_consume_token(62);
                            break block3;
                        }
                        case 64: {
                            typeName = this.jj_consume_token(64);
                            break block3;
                        }
                    }
                    this.jj_la1[116] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                case 74: {
                    typeName = this.jj_consume_token(74);
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 3: {
                            this.jj_consume_token(3);
                            typeLength = this.jj_consume_token(109);
                            end = this.jj_consume_token(4);
                            break block3;
                        }
                    }
                    this.jj_la1[117] = this.jj_gen;
                    break;
                }
                case 114: {
                    start = this.jj_consume_token(114);
                    customName = start.image;
                    typeName = start;
                    block34: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 114: {
                                break;
                            }
                            default: {
                                this.jj_la1[118] = this.jj_gen;
                                break block34;
                            }
                        }
                        typeName = this.jj_consume_token(114);
                        customName = customName + " " + typeName.image;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 3: {
                            this.jj_consume_token(3);
                            ADQLOperand param = this.ValueExpression();
                            customParams.add(param);
                            block35: while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 6: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[119] = this.jj_gen;
                                        break block35;
                                    }
                                }
                                this.jj_consume_token(6);
                                param = this.ValueExpression();
                                customParams.add(param);
                            }
                            end = this.jj_consume_token(4);
                            break block3;
                        }
                    }
                    this.jj_la1[120] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[121] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            try {
                TargetType type = customName != null ? new CustomTargetType(customName, customParams.toArray(new ADQLOperand[customParams.size()])) : new StandardTargetType(typeName.image, typeLength == null ? -1 : Integer.parseInt(typeLength.image));
                if (end != null) {
                    type.setPosition(new TextPosition(start != null ? start : typeName, end));
                } else {
                    type.setPosition(new TextPosition(start != null ? start : typeName));
                }
                String typeNameStr = customName == null ? typeName.image : customName;
                switch (expectedType) {
                    case 'N': 
                    case 'n': {
                        if (type.isNumeric()) break;
                        StringBuilder buf = new StringBuilder("Encountered: \"");
                        buf.append(typeNameStr).append("\"!");
                        buf.append(" Was expecting one numeric datatype among: ");
                        boolean first = true;
                        for (DBType.DBDatatype d : StandardTargetType.getNumericDatatypes()) {
                            if (!first) {
                                buf.append(", ");
                            }
                            buf.append('\"').append(d == DBType.DBDatatype.DOUBLE ? "DOUBLE PRECISION" : d.toString()).append('\"');
                            first = false;
                        }
                        buf.append('.');
                        throw new ParseException(buf.toString(), type.getPosition());
                    }
                    case 'S': 
                    case 's': {
                        if (type.isString()) break;
                        StringBuilder buf = new StringBuilder("Encountered: \"");
                        buf.append(typeNameStr).append("\"!");
                        buf.append(" Was expecting one character datatype among: ");
                        boolean first = true;
                        for (DBType.DBDatatype d : StandardTargetType.getStringDatatypes()) {
                            if (!first) {
                                buf.append(", ");
                            }
                            buf.append('\"').append(d.toString()).append('\"');
                            first = false;
                        }
                        buf.append('.');
                        throw new ParseException(buf.toString(), type.getPosition());
                    }
                    case 'G': 
                    case 'g': {
                        if (type.isGeometry()) break;
                        StringBuilder buf = new StringBuilder("Encountered: \"");
                        buf.append(typeNameStr).append("\"!");
                        buf.append(" Was expecting one geometric datatype among: ");
                        boolean first = true;
                        for (DBType.DBDatatype d : StandardTargetType.getGeometricDatatypes()) {
                            if (!first) {
                                buf.append(", ");
                            }
                            buf.append('\"').append(d.toString()).append('\"');
                            first = false;
                        }
                        buf.append('.');
                        throw new ParseException(buf.toString(), type.getPosition());
                    }
                }
                TargetType targetType = type;
                return targetType;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("CastDatatype");
        }
    }

    public final ADQLOperand ConditionalFunction() throws ParseException {
        this.trace_call("ConditionalFunction");
        try {
            ArrayList<ADQLOperand> operands = new ArrayList<ADQLOperand>(3);
            Token fct = this.jj_consume_token(102);
            this.jj_consume_token(3);
            ADQLOperand op = this.ValueExpression();
            operands.add(op);
            block9: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 6: {
                        break;
                    }
                    default: {
                        this.jj_la1[122] = this.jj_gen;
                        break block9;
                    }
                }
                this.jj_consume_token(6);
                op = this.ValueExpression();
                operands.add(op);
            }
            Token end = this.jj_consume_token(4);
            try {
                CoalesceFunction coalesce = this.queryFactory.createCoalesceFunction(operands);
                coalesce.setPosition(new TextPosition(fct, end));
                CoalesceFunction coalesceFunction = coalesce;
                return coalesceFunction;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("ConditionalFunction");
        }
    }

    /*
     * Exception decompiling
     */
    public final UserDefinedFunction UserDefinedFunction() throws ParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_30();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(29, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_31();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(30, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_32();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(31, xla);
        }
    }

    private boolean jj_3R_Box_1520_13_130() {
        return this.jj_3R_BoxWithCoordsAndNoCoordSys_1565_9_40();
    }

    private boolean jj_3R_Box_1523_9_131() {
        return this.jj_3R_BoxWithCoordsAndCoordSys_1547_9_201();
    }

    private boolean jj_3R_Identifier_751_9_22() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_Identifier_752_17_46()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_Identifier_758_17_47()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_Box_1516_9_90() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_Box_1517_17_129()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_Box_1520_13_130()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_Box_1523_9_131()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_GeometryValueFunction_1502_19_58() {
        if (this.jj_scan_token(65)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_StringExpression_1116_9_37()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_GeometryValueFunction_1496_19_57() {
        return this.jj_3R_Polygon_1696_9_94();
    }

    private boolean jj_3R_GeometryValueFunction_1493_19_56() {
        return this.jj_3R_Point_1658_9_93();
    }

    private boolean jj_3R_Offset_733_9_248() {
        if (this.jj_scan_token(54)) {
            return true;
        }
        return this.jj_scan_token(109);
    }

    private boolean jj_3R_GeometryValueFunction_1490_19_55() {
        return this.jj_3R_Circle_1582_9_92();
    }

    private boolean jj_3R_GeometryValueFunction_1487_19_54() {
        return this.jj_3R_Centroid_1645_9_91();
    }

    private boolean jj_3R_OrderBy_725_11_255() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_OrderItem_806_9_254();
    }

    private boolean jj_3R_GeometryValueFunction_1484_18_53() {
        return this.jj_3R_Box_1516_9_90();
    }

    private boolean jj_3R_OrderBy_724_9_247() {
        Token xsp;
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_3R_OrderItem_806_9_254()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_OrderBy_725_11_255());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_GeometryFunction_1398_102_235() {
        return this.jj_3R_Column_795_9_30();
    }

    private boolean jj_3R_GeometryFunction_1397_102_233() {
        return this.jj_3R_Column_795_9_30();
    }

    private boolean jj_3R_Having_715_9_271() {
        if (this.jj_scan_token(50)) {
            return true;
        }
        return this.jj_3R_ConditionsList_1180_9_102();
    }

    private boolean jj_3R_GeometryValueFunction_1481_9_29() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_GeometryValueFunction_1484_18_53()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_GeometryValueFunction_1487_19_54()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_GeometryValueFunction_1490_19_55()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_GeometryValueFunction_1493_19_56()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_GeometryValueFunction_1496_19_57()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_GeometryValueFunction_1502_19_58()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_CoordinateSystem_1475_11_184() {
        return this.jj_3R_String_924_9_31();
    }

    private boolean jj_3R_GroupBy_707_11_274() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_ValueExpression_1032_9_71();
    }

    private boolean jj_3R_GroupBy_706_9_270() {
        Token xsp;
        if (this.jj_scan_token(49)) {
            return true;
        }
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_3R_ValueExpression_1032_9_71()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_GroupBy_707_11_274());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_CoordinateSystem_1473_9_116() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_CoordinateSystem_1474_7_183()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_CoordinateSystem_1475_11_184()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_CoordinateSystem_1474_7_183() {
        return this.jj_scan_token(41);
    }

    private boolean jj_3R_Where_697_9_269() {
        if (this.jj_scan_token(36)) {
            return true;
        }
        return this.jj_3R_ConditionsList_1180_9_102();
    }

    private boolean jj_3R_SelectItem_662_39_275() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(26)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_Identifier_751_9_22();
    }

    private boolean jj_3R_From_683_18_268() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_TableRef_871_9_267();
    }

    private boolean jj_3R_DistanceFunction2_1456_9_38() {
        if (this.jj_scan_token(72)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_PointValue_1438_9_73()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_PointValue_1438_9_73()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_From_681_9_259() {
        Token xsp;
        if (this.jj_scan_token(25)) {
            return true;
        }
        if (this.jj_3R_TableRef_871_9_267()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_From_683_18_268());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_PointValue_1441_11_115() {
        return this.jj_3R_Column_795_9_30();
    }

    private boolean jj_3R_SelectItem_643_41_48() {
        if (this.jj_3R_Identifier_751_9_22()) {
            return true;
        }
        return this.jj_scan_token(5);
    }

    private boolean jj_3_25() {
        return this.jj_3R_UserDefinedFunction_2035_9_34();
    }

    private boolean jj_3R_PointValue_1439_11_114() {
        return this.jj_3R_Centroid_1645_9_91();
    }

    private boolean jj_3R_PointValue_1438_11_113() {
        return this.jj_3R_Point_1658_9_93();
    }

    private boolean jj_3R_GeometryFunction_1398_51_234() {
        return this.jj_3R_Point_1658_9_93();
    }

    private boolean jj_3R_GeometryFunction_1397_51_232() {
        return this.jj_3R_Point_1658_9_93();
    }

    private boolean jj_3R_SqlFunction_1357_91_236() {
        return this.jj_3R_ValueExpression_1032_9_71();
    }

    private boolean jj_3R_PointValue_1438_9_73() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_PointValue_1438_11_113()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_PointValue_1439_11_114()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_25()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_PointValue_1441_11_115()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_SelectItem_662_17_273() {
        if (this.jj_3R_ValueExpression_1032_9_71()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SelectItem_662_39_275()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_DistanceFunction_1419_25_223() {
        if (this.jj_scan_token(72)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3_24() {
        return this.jj_3R_DistanceFunction2_1456_9_38();
    }

    private boolean jj_3R_SelectItem_641_33_23() {
        if (this.jj_3R_Identifier_751_9_22()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SelectItem_643_41_48()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_DistanceFunction_1415_18_222() {
        return this.jj_3R_DistanceFunction2_1456_9_38();
    }

    private boolean jj_3R_GeometryFunction_1399_25_173() {
        return this.jj_3R_DistanceFunction_1413_9_209();
    }

    private boolean jj_3R_GeometryFunction_1398_25_172() {
        if (this.jj_scan_token(70)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_GeometryFunction_1398_51_234()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_GeometryFunction_1398_102_235()) {
                return true;
            }
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_GeometryFunction_1397_25_171() {
        if (this.jj_scan_token(69)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_GeometryFunction_1397_51_232()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_GeometryFunction_1397_102_233()) {
                return true;
            }
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_DistanceFunction_1413_9_209() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_DistanceFunction_1415_18_222()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_DistanceFunction_1419_25_223()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_GeometryFunction_1396_25_170() {
        if (this.jj_scan_token(68)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_GeometryExpression_1155_9_193()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_SelectItem_630_17_272() {
        return this.jj_scan_token(14);
    }

    private boolean jj_3_1() {
        if (this.jj_3R_Identifier_751_9_22()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SelectItem_641_33_23()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(14);
    }

    private boolean jj_3R_GeometryFunction_1388_25_169() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(66)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(67)) {
                return true;
            }
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_GeometryExpression_1155_9_193()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_GeometryExpression_1155_9_193()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_SelectItem_629_9_265() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SelectItem_630_17_272()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_1()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_SelectItem_662_17_273()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_Select_620_10_266() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_SelectItem_629_9_265();
    }

    private boolean jj_3R_GeometryFunction_1385_9_99() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_GeometryFunction_1388_25_169()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_GeometryFunction_1396_25_170()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_GeometryFunction_1397_25_171()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_GeometryFunction_1398_25_172()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_GeometryFunction_1399_25_173()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_InEnd_1327_66_250() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_ValueExpression_1032_9_71();
    }

    private boolean jj_3R_Coordinates_1380_9_76() {
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_NumericExpression_1063_9_75();
    }

    private boolean jj_3R_SqlFunction_1363_25_221() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(55)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(56)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(57)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(58)) {
                        return true;
                    }
                }
            }
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(23)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_ValueExpression_1032_9_71()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_Select_609_10_264() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        return this.jj_scan_token(109);
    }

    private boolean jj_3R_Select_608_10_263() {
        return this.jj_scan_token(23);
    }

    private boolean jj_3R_Select_607_9_240() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_Select_608_10_263()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_Select_609_10_264()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_SelectItem_629_9_265()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_Select_620_10_266());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_SqlFunction_1357_25_220() {
        if (this.jj_scan_token(59)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(23)) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(14)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_SqlFunction_1357_91_236()) {
                return true;
            }
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_SqlFunction_1355_9_208() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SqlFunction_1357_25_220()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_SqlFunction_1363_25_221()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_UserDefinedFunction_2035_96_219() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_ValueExpression_1032_9_71();
    }

    private boolean jj_3R_SubQueryExpression_574_9_24() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_QueryExpression_491_9_49()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_InEnd_1327_11_239() {
        Token xsp;
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_ValueExpression_1032_9_71()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_InEnd_1327_66_250());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(4);
    }

    private boolean jj_3_23() {
        return this.jj_3R_SubQueryExpression_574_9_24();
    }

    private boolean jj_3R_SimpleQueryExpression_557_10_262() {
        return this.jj_3R_Having_715_9_271();
    }

    private boolean jj_3R_InEnd_1325_9_225() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(39)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(45)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_23()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_InEnd_1327_11_239()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_SimpleQueryExpression_556_10_261() {
        return this.jj_3R_GroupBy_706_9_270();
    }

    private boolean jj_3R_SimpleQueryExpression_555_10_260() {
        return this.jj_3R_Where_697_9_269();
    }

    private boolean jj_3R_UserDefinedFunction_2035_56_194() {
        Token xsp;
        if (this.jj_3R_ValueExpression_1032_9_71()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_UserDefinedFunction_2035_96_219());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_SetFactor_538_17_214() {
        return this.jj_3R_SubQueryExpression_574_9_24();
    }

    private boolean jj_3R_SetFactor_536_17_213() {
        return this.jj_3R_SimpleQueryExpression_544_9_226();
    }

    private boolean jj_3R_SimpleQueryExpression_544_9_226() {
        if (this.jj_3R_Select_607_9_240()) {
            return true;
        }
        if (this.jj_3R_From_681_9_259()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SimpleQueryExpression_555_10_260()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_SimpleQueryExpression_556_10_261()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_SimpleQueryExpression_557_10_262()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_BetweenEnd_1311_9_36() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(39)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(42)) {
            return true;
        }
        if (this.jj_3R_ValueExpression_1032_9_71()) {
            return true;
        }
        if (this.jj_scan_token(37)) {
            return true;
        }
        return this.jj_3R_ValueExpression_1032_9_71();
    }

    private boolean jj_3R_Predicate_1287_27_212() {
        return this.jj_3R_InEnd_1325_9_225();
    }

    private boolean jj_3_19() {
        return this.jj_3R_BetweenEnd_1311_9_36();
    }

    private boolean jj_3R_SetFactor_535_9_186() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SetFactor_536_17_213()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_SetFactor_538_17_214()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_Predicate_1283_25_211() {
        return this.jj_3R_ComparisonEnd_1298_9_224();
    }

    private boolean jj_3R_ComparisonEnd_1298_9_224() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(16)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(17)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(18)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(19)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(20)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(21)) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return this.jj_3R_ValueExpression_1032_9_71();
    }

    private boolean jj_3_22() {
        if (this.jj_3R_StringExpression_1116_9_37()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(39)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(44);
    }

    private boolean jj_3R_Predicate_1281_19_181() {
        if (this.jj_3R_ValueExpression_1032_9_71()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_Predicate_1283_25_211()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_19()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_Predicate_1287_27_212()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_SetTerm_520_11_253() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(23)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_SetFactor_535_9_186();
    }

    private boolean jj_3_21() {
        if (this.jj_3R_StringExpression_1116_9_37()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(39)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(43);
    }

    private boolean jj_3R_SetTerm_518_9_119() {
        Token xsp;
        if (this.jj_3R_SetFactor_535_9_186()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_SetTerm_520_11_253());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_Predicate_1274_19_180() {
        if (this.jj_3R_StringExpression_1116_9_37()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(39)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(44)) {
            return true;
        }
        return this.jj_3R_StringExpression_1116_9_37();
    }

    private boolean jj_3_20() {
        if (this.jj_3R_Column_795_9_30()) {
            return true;
        }
        return this.jj_scan_token(40);
    }

    private boolean jj_3R_Predicate_1266_19_179() {
        if (this.jj_3R_StringExpression_1116_9_37()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(39)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(43)) {
            return true;
        }
        return this.jj_3R_StringExpression_1116_9_37();
    }

    private boolean jj_3R_SetExpression_503_11_246() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(9)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(11)) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(23)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_SetTerm_518_9_119();
    }

    private boolean jj_3R_SetExpression_501_9_81() {
        Token xsp;
        if (this.jj_3R_SetTerm_518_9_119()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_SetExpression_503_11_246());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_Predicate_1258_19_178() {
        if (this.jj_3R_Column_795_9_30()) {
            return true;
        }
        if (this.jj_scan_token(40)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(39)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(41);
    }

    private boolean jj_3R_UserDefinedFunction_2035_9_34() {
        if (this.jj_scan_token(114)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_UserDefinedFunction_2035_56_194()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_QueryExpression_493_10_238() {
        return this.jj_3R_Offset_733_9_248();
    }

    private boolean jj_3R_QueryExpression_492_10_237() {
        return this.jj_3R_OrderBy_724_9_247();
    }

    private boolean jj_3R_Predicate_1250_19_177() {
        if (this.jj_scan_token(46)) {
            return true;
        }
        return this.jj_3R_SubQueryExpression_574_9_24();
    }

    private boolean jj_3R_QueryExpression_491_9_49() {
        if (this.jj_3R_SetExpression_501_9_81()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_QueryExpression_492_10_237()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_QueryExpression_493_10_238()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_Constraint_1241_18_70() {
        return this.jj_3R_Predicate_1247_9_103();
    }

    private boolean jj_3R_ConditionalFunction_2017_7_249() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_ValueExpression_1032_9_71();
    }

    private boolean jj_3R_Predicate_1247_9_103() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_Predicate_1250_19_177()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_Predicate_1258_19_178()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_Predicate_1266_19_179()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_Predicate_1274_19_180()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_Predicate_1281_19_181()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_ConditionalFunction_2015_5_182() {
        Token xsp;
        if (this.jj_scan_token(102)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_ValueExpression_1032_9_71()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_ConditionalFunction_2017_7_249());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(4);
    }

    private boolean jj_3_18() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(39)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_Constraint_1228_9_35();
    }

    private boolean jj_3R_Constraint_1228_10_69() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_ConditionsList_1180_9_102()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_Constraint_1228_9_35() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_Constraint_1228_10_69()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_Constraint_1241_18_70()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_ConditionsList_1198_26_210() {
        return this.jj_scan_token(39);
    }

    private boolean jj_3R_CastDatatype_1928_62_243() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_scan_token(109)) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_ConditionsList_1197_25_176() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(37)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(38)) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_ConditionsList_1198_26_210()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_Constraint_1228_9_35();
    }

    private boolean jj_3R_CastDatatype_1934_34_252() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_ValueExpression_1032_9_71();
    }

    private boolean jj_3R_ConditionsList_1181_18_175() {
        return this.jj_scan_token(39);
    }

    private boolean jj_3R_CastDatatype_1932_26_245() {
        Token xsp;
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_ValueExpression_1032_9_71()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_CastDatatype_1934_34_252());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_CastDatatype_1931_26_244() {
        return this.jj_scan_token(114);
    }

    private boolean jj_3R_ConditionsList_1180_9_102() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_ConditionsList_1181_18_175()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_Constraint_1228_9_35()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_ConditionsList_1197_25_176());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_CastDatatype_1930_25_230() {
        Token xsp;
        if (this.jj_scan_token(114)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_CastDatatype_1931_26_244());
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_CastDatatype_1932_26_245()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_CastDatatype_1928_25_229() {
        if (this.jj_scan_token(74)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_CastDatatype_1928_62_243()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_CastDatatype_1926_25_228() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(75)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(63)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(62)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(64)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_GeometryExpression_1159_19_217() {
        return this.jj_3R_Column_795_9_30();
    }

    private boolean jj_3_17() {
        return this.jj_3R_UserDefinedFunction_2035_9_34();
    }

    private boolean jj_3R_GeometryExpression_1157_19_216() {
        return this.jj_3R_GeometricCastFunction_1904_9_227();
    }

    private boolean jj_3R_GeometryExpression_1156_19_215() {
        return this.jj_3R_GeometryValueFunction_1481_9_29();
    }

    private boolean jj_3R_CastDatatype_1925_9_218() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_CastDatatype_1926_25_228()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_CastDatatype_1928_25_229()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_CastDatatype_1930_25_230()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_GeometryExpression_1155_9_193() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_GeometryExpression_1156_19_215()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_GeometryExpression_1157_19_216()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_17()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_GeometryExpression_1159_19_217()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_StringFactor_1150_11_89() {
        return this.jj_3R_StringValueExpressionPrimary_1012_9_128();
    }

    private boolean jj_3_16() {
        return this.jj_3R_UserDefinedFunction_2035_9_34();
    }

    private boolean jj_3R_StringFactor_1148_11_88() {
        return this.jj_3R_StringCastFunction_1896_9_127();
    }

    private boolean jj_3R_MathFunction_1852_74_242() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_SignedInteger_975_9_251();
    }

    private boolean jj_3R_StringFactor_1147_11_87() {
        return this.jj_3R_UpperFunction_1798_9_126();
    }

    private boolean jj_3R_StringFactor_1146_11_86() {
        return this.jj_3R_LowerFunction_1785_9_125();
    }

    private boolean jj_3R_StringFactor_1145_10_85() {
        return this.jj_3R_ExtractCoordSys_1768_9_124();
    }

    private boolean jj_3R_StringFactor_1145_9_52() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_StringFactor_1145_10_85()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_StringFactor_1146_11_86()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_StringFactor_1147_11_87()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_StringFactor_1148_11_88()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_16()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_StringFactor_1150_11_89()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_CastFunction_1912_9_174() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_ValueExpression_1032_9_71()) {
            return true;
        }
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_3R_CastDatatype_1925_9_218()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_MathFunction_1850_71_241() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_SignedInteger_975_9_251();
    }

    private boolean jj_3R_Factor_1099_54_62() {
        return this.jj_3R_NumericValueExpressionPrimary_994_9_96();
    }

    private boolean jj_3R_GeometricCastFunction_1904_9_227() {
        return this.jj_3R_CastFunction_1912_9_174();
    }

    private boolean jj_3R_StringCastFunction_1896_9_127() {
        return this.jj_3R_CastFunction_1912_9_174();
    }

    private boolean jj_3R_StringExpression_1118_17_72() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_3R_StringFactor_1145_9_52();
    }

    private boolean jj_3R_NumericCastFunction_1888_9_101() {
        return this.jj_3R_CastFunction_1912_9_174();
    }

    private boolean jj_3R_StringExpression_1116_9_37() {
        Token xsp;
        if (this.jj_3R_StringFactor_1145_9_52()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_StringExpression_1118_17_72());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_MathFunction_1849_43_231() {
        return this.jj_3R_NumericExpression_1063_9_75();
    }

    private boolean jj_3_15() {
        return this.jj_3R_NumericFunction_1814_9_33();
    }

    private boolean jj_3R_Factor_1098_18_61() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(12)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(13)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_TrigFunction_1871_11_168() {
        if (this.jj_scan_token(100)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_TrigFunction_1870_11_167() {
        if (this.jj_scan_token(99)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_TrigFunction_1869_11_166() {
        if (this.jj_scan_token(98)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_TrigFunction_1868_11_165() {
        if (this.jj_scan_token(97)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_TrigFunction_1867_11_164() {
        if (this.jj_scan_token(96)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_TrigFunction_1866_11_163() {
        if (this.jj_scan_token(95)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_TrigFunction_1865_11_162() {
        if (this.jj_scan_token(94)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_NumericTerm_1080_27_185() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(14)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(15)) {
                return true;
            }
        }
        return this.jj_3R_NumericTerm_1080_9_117();
    }

    private boolean jj_3R_TrigFunction_1864_10_161() {
        if (this.jj_scan_token(93)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_Factor_1097_9_32() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_Factor_1098_18_61()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_15()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_Factor_1099_54_62()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_TrigFunction_1864_9_98() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_TrigFunction_1864_10_161()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_TrigFunction_1865_11_162()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_TrigFunction_1866_11_163()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_TrigFunction_1867_11_164()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_TrigFunction_1868_11_165()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_TrigFunction_1869_11_166()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_TrigFunction_1870_11_167()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_TrigFunction_1871_11_168()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_MathFunction_1852_19_160() {
        if (this.jj_scan_token(92)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_MathFunction_1852_74_242()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_MathFunction_1851_19_159() {
        if (this.jj_scan_token(91)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_MathFunction_1850_19_158() {
        if (this.jj_scan_token(90)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_MathFunction_1850_71_241()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_MathFunction_1849_19_157() {
        if (this.jj_scan_token(89)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_MathFunction_1849_43_231()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_MathFunction_1848_19_156() {
        if (this.jj_scan_token(88)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_MathFunction_1847_19_155() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_MathFunction_1846_19_154() {
        if (this.jj_scan_token(86)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_MathFunction_1845_19_153() {
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_null_1034_62_28() {
        if (this.jj_3R_StringFactor_1145_9_52()) {
            return true;
        }
        return this.jj_scan_token(8);
    }

    private boolean jj_3R_MathFunction_1844_19_152() {
        if (this.jj_scan_token(84)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_NumericExpression_1063_32_118() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(12)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(13)) {
                return true;
            }
        }
        return this.jj_3R_NumericExpression_1063_9_75();
    }

    private boolean jj_3R_MathFunction_1843_19_151() {
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_MathFunction_1842_19_150() {
        if (this.jj_scan_token(82)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_MathFunction_1841_19_149() {
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_MathFunction_1840_19_148() {
        if (this.jj_scan_token(80)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_MathFunction_1839_19_147() {
        if (this.jj_scan_token(79)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_NumericTerm_1080_9_117() {
        if (this.jj_3R_Factor_1097_9_32()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_NumericTerm_1080_27_185()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_MathFunction_1838_18_146() {
        if (this.jj_scan_token(78)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_null_1033_47_27() {
        if (this.jj_3R_Factor_1097_9_32()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(12)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(13)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(14)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(15)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_MathFunction_1837_9_97() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_MathFunction_1838_18_146()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_MathFunction_1839_19_147()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_MathFunction_1840_19_148()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_MathFunction_1841_19_149()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_MathFunction_1842_19_150()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_MathFunction_1843_19_151()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_MathFunction_1844_19_152()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_MathFunction_1845_19_153()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_MathFunction_1846_19_154()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_MathFunction_1847_19_155()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_MathFunction_1848_19_156()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_MathFunction_1849_19_157()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_MathFunction_1850_19_158()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3R_MathFunction_1851_19_159()) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_3R_MathFunction_1852_19_160()) {
                                                                    return true;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_ValueExpression_1055_19_112() {
        return this.jj_3R_Column_795_9_30();
    }

    private boolean jj_3R_NumericExpression_1063_9_75() {
        if (this.jj_3R_NumericTerm_1080_9_117()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_NumericExpression_1063_32_118()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_12() {
        return this.jj_3R_String_924_9_31();
    }

    private boolean jj_3_14() {
        return this.jj_3R_NumericFunction_1814_9_33();
    }

    private boolean jj_3_11() {
        return this.jj_3R_Column_795_9_30();
    }

    private boolean jj_3_9() {
        if (this.jj_scan_token(102)) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3_8() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_InUnitFunction_1824_9_100() {
        if (this.jj_scan_token(101)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_StringExpression_1116_9_37()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3_7() {
        if (this.jj_scan_token(114)) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3_6() {
        return this.jj_scan_token(3);
    }

    private boolean jj_3_5() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(71)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(76)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(77)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_null_1034_62_28()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_NumericFunction_1819_11_68() {
        return this.jj_3R_UserDefinedFunction_2035_9_34();
    }

    private boolean jj_3R_NumericFunction_1818_11_67() {
        return this.jj_3R_NumericCastFunction_1888_9_101();
    }

    private boolean jj_3_4() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_null_1033_28_26()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_null_1033_47_27()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_13() {
        return this.jj_3R_Factor_1097_9_32();
    }

    private boolean jj_3R_null_1033_28_26() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(12)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(13)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_NumericFunction_1817_11_66() {
        return this.jj_3R_InUnitFunction_1824_9_100();
    }

    private boolean jj_3R_ValueExpression_1041_19_111() {
        return this.jj_3R_StringFactor_1145_9_52();
    }

    private boolean jj_3R_NumericFunction_1816_11_65() {
        return this.jj_3R_GeometryFunction_1385_9_99();
    }

    private boolean jj_3R_ValueExpression_1040_19_110() {
        return this.jj_3R_Column_795_9_30();
    }

    private boolean jj_3R_NumericFunction_1815_11_64() {
        return this.jj_3R_TrigFunction_1864_9_98();
    }

    private boolean jj_3_10() {
        return this.jj_3R_GeometryValueFunction_1481_9_29();
    }

    private boolean jj_3R_ValueExpression_1038_19_109() {
        return this.jj_3R_ConditionalFunction_2015_5_182();
    }

    private boolean jj_3R_NumericFunction_1814_10_63() {
        return this.jj_3R_MathFunction_1837_9_97();
    }

    private boolean jj_3R_ValueExpression_1037_19_108() {
        return this.jj_3R_CastFunction_1912_9_174();
    }

    private boolean jj_3R_NumericFunction_1814_9_33() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_NumericFunction_1814_10_63()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_NumericFunction_1815_11_64()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_NumericFunction_1816_11_65()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_NumericFunction_1817_11_66()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_NumericFunction_1818_11_67()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_NumericFunction_1819_11_68()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_ValueExpression_1036_19_107() {
        return this.jj_3R_UserDefinedFunction_2035_9_34();
    }

    private boolean jj_3R_ValueExpression_1035_19_106() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_ValueExpression_1032_9_71()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_ValueExpression_1034_19_105() {
        return this.jj_3R_StringExpression_1116_9_37();
    }

    private boolean jj_3R_ValueExpression_1033_18_104() {
        return this.jj_3R_NumericExpression_1063_9_75();
    }

    private boolean jj_3R_StringValueExpressionPrimary_1025_19_200() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_ValueExpression_1032_9_71()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_StringValueExpressionPrimary_1023_19_199() {
        return this.jj_3R_Column_795_9_30();
    }

    private boolean jj_3R_ValueExpression_1032_9_71() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_ValueExpression_1033_18_104()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_ValueExpression_1034_19_105()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_ValueExpression_1035_19_106()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_ValueExpression_1036_19_107()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_ValueExpression_1037_19_108()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_ValueExpression_1038_19_109()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_10()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_ValueExpression_1040_19_110()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_ValueExpression_1041_19_111()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3_13()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3_14()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_ValueExpression_1055_19_112()) {
                                                        return true;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_StringValueExpressionPrimary_1021_19_198() {
        return this.jj_3R_SqlFunction_1355_9_208();
    }

    private boolean jj_3R_UpperFunction_1798_9_126() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_StringExpression_1116_9_37()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_StringValueExpressionPrimary_1019_19_197() {
        return this.jj_3R_UnsignedNumeric_946_9_207();
    }

    private boolean jj_3R_StringValueExpressionPrimary_1017_19_196() {
        return this.jj_3R_String_924_9_31();
    }

    private boolean jj_3R_StringValueExpressionPrimary_1015_17_195() {
        return this.jj_scan_token(41);
    }

    private boolean jj_3R_LowerFunction_1785_9_125() {
        if (this.jj_scan_token(76)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_StringExpression_1116_9_37()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_JoinSpecification_886_140_189() {
        return this.jj_scan_token(32);
    }

    private boolean jj_3R_NumericValueExpressionPrimary_1005_19_145() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_NumericValueExpressionPrimary_1003_19_144() {
        return this.jj_3R_SqlFunction_1355_9_208();
    }

    private boolean jj_3R_StringValueExpressionPrimary_1012_9_128() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_StringValueExpressionPrimary_1015_17_195()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_StringValueExpressionPrimary_1017_19_196()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_StringValueExpressionPrimary_1019_19_197()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_StringValueExpressionPrimary_1021_19_198()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_StringValueExpressionPrimary_1023_19_199()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_StringValueExpressionPrimary_1025_19_200()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_NumericValueExpressionPrimary_1001_19_143() {
        return this.jj_3R_Column_795_9_30();
    }

    private boolean jj_3R_NumericValueExpressionPrimary_999_19_142() {
        return this.jj_3R_UnsignedNumeric_946_9_207();
    }

    private boolean jj_3R_NumericValueExpressionPrimary_997_17_141() {
        return this.jj_scan_token(41);
    }

    private boolean jj_3R_ExtractCoordSys_1768_9_124() {
        if (this.jj_scan_token(71)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_GeometryExpression_1155_9_193()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_JoinSpecification_893_114_192() {
        return this.jj_scan_token(32);
    }

    private boolean jj_3R_PolygonWithCoordsAndNoCoordSys_1754_18_80() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_Coordinates_1380_9_76();
    }

    private boolean jj_3R_NumericValueExpressionPrimary_994_9_96() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_NumericValueExpressionPrimary_997_17_141()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_NumericValueExpressionPrimary_999_19_142()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_NumericValueExpressionPrimary_1001_19_143()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_NumericValueExpressionPrimary_1003_19_144()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_NumericValueExpressionPrimary_1005_19_145()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_PolygonWithCoordsAndNoCoordSys_1749_9_45() {
        Token xsp;
        if (this.jj_scan_token(64)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_Coordinates_1380_9_76()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_Coordinates_1380_9_76()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_Coordinates_1380_9_76()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_PolygonWithCoordsAndNoCoordSys_1754_18_80());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_JoinSpecification_886_101_188() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3R_PolygonWithCoordsAndCoordSys_1735_18_258() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_Coordinates_1380_9_76();
    }

    private boolean jj_3R_SignedInteger_975_11_256() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(12)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(13)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_SignedInteger_975_9_251() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SignedInteger_975_11_256()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(109);
    }

    private boolean jj_3R_PolygonWithCoordsAndCoordSys_1729_9_204() {
        Token xsp;
        if (this.jj_scan_token(64)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_CoordinateSystem_1473_9_116()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_Coordinates_1380_9_76()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_Coordinates_1380_9_76()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_Coordinates_1380_9_76()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_PolygonWithCoordsAndCoordSys_1735_18_258());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_JoinSpecification_893_75_191() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3R_PolygonWithPoints_1715_18_79() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_PointValue_1438_9_73();
    }

    private boolean jj_3R_JoinSpecification_905_57_281() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_Identifier_751_9_22();
    }

    private boolean jj_3R_PolygonWithPoints_1710_19_78() {
        if (this.jj_3R_CoordinateSystem_1473_9_116()) {
            return true;
        }
        return this.jj_scan_token(6);
    }

    private boolean jj_3_31() {
        return this.jj_3R_PolygonWithPoints_1709_9_44();
    }

    private boolean jj_3_32() {
        return this.jj_3R_PolygonWithCoordsAndNoCoordSys_1749_9_45();
    }

    private boolean jj_3R_UnsignedNumeric_946_9_207() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(107)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(108)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(109)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_Polygon_1703_17_139() {
        return this.jj_3R_PolygonWithCoordsAndCoordSys_1729_9_204();
    }

    private boolean jj_3R_PolygonWithPoints_1709_9_44() {
        if (this.jj_scan_token(64)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_PolygonWithPoints_1710_19_78()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_PointValue_1438_9_73()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_PointValue_1438_9_73()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_PointValue_1438_9_73()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_PolygonWithPoints_1715_18_79());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_JoinSpecification_886_64_187() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3R_JoinSpecification_886_62_120() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_JoinSpecification_886_64_187()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_JoinSpecification_886_101_188()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_JoinSpecification_886_140_189()) {
                    return true;
                }
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(29)) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_Polygon_1697_17_137() {
        return this.jj_3R_PolygonWithPoints_1709_9_44();
    }

    private boolean jj_3R_Polygon_1700_13_138() {
        return this.jj_3R_PolygonWithCoordsAndNoCoordSys_1749_9_45();
    }

    private boolean jj_3R_JoinSpecification_886_52_82() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(28)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_JoinSpecification_886_62_120()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_Polygon_1696_9_94() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_Polygon_1697_17_137()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_Polygon_1700_13_138()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_Polygon_1703_17_139()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_JoinSpecification_902_33_280() {
        Token xsp;
        if (this.jj_scan_token(35)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_Identifier_751_9_22()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_JoinSpecification_905_57_281());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_String_924_10_60() {
        return this.jj_scan_token(106);
    }

    private boolean jj_3R_String_924_9_31() {
        Token xsp;
        if (this.jj_3R_String_924_10_60()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_String_924_10_60());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_JoinSpecification_893_38_190() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3R_JoinSpecification_893_36_121() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_JoinSpecification_893_38_190()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_JoinSpecification_893_75_191()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_JoinSpecification_893_114_192()) {
                    return true;
                }
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(29)) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_JoinSpecification_895_33_279() {
        if (this.jj_scan_token(34)) {
            return true;
        }
        return this.jj_3R_ConditionsList_1180_9_102();
    }

    private boolean jj_3R_PointWithCoordSys_1680_9_203() {
        if (this.jj_scan_token(63)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_CoordinateSystem_1473_9_116()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_Coordinates_1380_9_76()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_JoinSpecification_893_26_83() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(28)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_JoinSpecification_893_36_121()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_JoinSpecification_893_25_51() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_JoinSpecification_893_26_83()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_3R_SimpleTableRef_837_9_84()) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_JoinSpecification_895_33_279()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_JoinSpecification_902_33_280()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_JoinSpecification_886_25_50() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_JoinSpecification_886_52_82()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(33)) {
            return true;
        }
        return this.jj_3R_SimpleTableRef_837_9_84();
    }

    private boolean jj_3_30() {
        return this.jj_3R_PointWithoutCoordSys_1667_9_43();
    }

    private boolean jj_3R_PointWithoutCoordSys_1667_9_43() {
        if (this.jj_scan_token(63)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_Coordinates_1380_9_76()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_Point_1661_11_136() {
        return this.jj_3R_PointWithCoordSys_1680_9_203();
    }

    private boolean jj_3R_Point_1658_10_135() {
        return this.jj_3R_PointWithoutCoordSys_1667_9_43();
    }

    private boolean jj_3R_Point_1658_9_93() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_Point_1658_10_135()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_Point_1661_11_136()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_JoinSpecification_884_9_25() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_JoinSpecification_886_25_50()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_JoinSpecification_893_25_51()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_JoinedTable_878_11_278() {
        return this.jj_3R_JoinSpecification_884_9_25();
    }

    private boolean jj_3R_SimpleTableRef_839_50_276() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(26)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_Identifier_751_9_22();
    }

    private boolean jj_3R_Centroid_1645_9_91() {
        if (this.jj_scan_token(61)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_GeometryExpression_1155_9_193()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_JoinedTable_877_9_277() {
        Token xsp;
        if (this.jj_3R_SimpleTableRef_837_9_84()) {
            return true;
        }
        if (this.jj_3R_JoinedTable_878_11_278()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_JoinedTable_878_11_278());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_SimpleTableRef_859_25_123() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_JoinedTable_877_9_277()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3_3() {
        return this.jj_3R_JoinSpecification_884_9_25();
    }

    private boolean jj_3R_TableRef_871_9_267() {
        Token xsp;
        if (this.jj_3R_SimpleTableRef_837_9_84()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_3());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_CircleWithCoordsAndNoCoordSys_1629_9_42() {
        if (this.jj_scan_token(62)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_Coordinates_1380_9_76()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3_2() {
        if (this.jj_3R_SubQueryExpression_574_9_24()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(26)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_Identifier_751_9_22();
    }

    private boolean jj_3R_SimpleTableRef_839_25_122() {
        if (this.jj_3R_TableName_769_9_140()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SimpleTableRef_839_50_276()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_CircleWithCoordsAndCoordSys_1612_9_202() {
        if (this.jj_scan_token(62)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_CoordinateSystem_1473_9_116()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_Coordinates_1380_9_76()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_CircleWithPoint_1596_19_77() {
        if (this.jj_3R_CoordinateSystem_1473_9_116()) {
            return true;
        }
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_SimpleTableRef_837_9_84() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SimpleTableRef_839_25_122()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_2()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_SimpleTableRef_859_25_123()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_28() {
        return this.jj_3R_CircleWithPoint_1595_9_41();
    }

    private boolean jj_3_29() {
        return this.jj_3R_CircleWithCoordsAndNoCoordSys_1629_9_42();
    }

    private boolean jj_3R_CircleWithPoint_1595_9_41() {
        if (this.jj_scan_token(62)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_CircleWithPoint_1596_19_77()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_PointValue_1438_9_73()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_Circle_1583_17_132() {
        return this.jj_3R_CircleWithPoint_1595_9_41();
    }

    private boolean jj_3R_Circle_1586_13_133() {
        return this.jj_3R_CircleWithCoordsAndNoCoordSys_1629_9_42();
    }

    private boolean jj_3R_Circle_1589_9_134() {
        return this.jj_3R_CircleWithCoordsAndCoordSys_1612_9_202();
    }

    private boolean jj_3R_Circle_1582_9_92() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_Circle_1583_17_132()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_Circle_1586_13_133()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_Circle_1589_9_134()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_OrderItem_811_10_257() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(52)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(53)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_OrderItem_806_9_254() {
        if (this.jj_3R_ValueExpression_1032_9_71()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_OrderItem_811_10_257()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_ColumnName_783_28_95() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        return this.jj_3R_TableName_769_9_140();
    }

    private boolean jj_3R_BoxWithCoordsAndNoCoordSys_1565_9_40() {
        if (this.jj_scan_token(60)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_Coordinates_1380_9_76()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_Column_795_9_30() {
        return this.jj_3R_ColumnName_783_9_59();
    }

    private boolean jj_3R_ColumnName_783_9_59() {
        if (this.jj_3R_Identifier_751_9_22()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_ColumnName_783_28_95()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_TableName_772_18_206() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        return this.jj_3R_Identifier_751_9_22();
    }

    private boolean jj_3R_TableName_771_18_205() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        return this.jj_3R_Identifier_751_9_22();
    }

    private boolean jj_3R_BoxWithCoordsAndCoordSys_1547_9_201() {
        if (this.jj_scan_token(60)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_CoordinateSystem_1473_9_116()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_Coordinates_1380_9_76()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_BoxWithPoint_1530_19_74() {
        if (this.jj_3R_CoordinateSystem_1473_9_116()) {
            return true;
        }
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_TableName_769_9_140() {
        if (this.jj_3R_Identifier_751_9_22()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_TableName_771_18_205()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_TableName_772_18_206()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_26() {
        return this.jj_3R_BoxWithPoint_1529_9_39();
    }

    private boolean jj_3_27() {
        return this.jj_3R_BoxWithCoordsAndNoCoordSys_1565_9_40();
    }

    private boolean jj_3R_Identifier_758_17_47() {
        return this.jj_scan_token(113);
    }

    private boolean jj_3R_BoxWithPoint_1529_9_39() {
        if (this.jj_scan_token(60)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_BoxWithPoint_1530_19_74()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_PointValue_1438_9_73()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_1063_9_75()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_Identifier_752_17_46() {
        return this.jj_scan_token(114);
    }

    private boolean jj_3R_Box_1517_17_129() {
        return this.jj_3R_BoxWithPoint_1529_9_39();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 129, 0, 0, 2560, 2560, 0x800000, 1024, 0x800000, 0x400008, 0, 0, 0, 64, 0x800000, 0x1000000, 64, 0, 0, 0x4000000, 0x4000000, 16384, 12296, 64, 64, 64, 0, 32, 32, 32, 0, 0, 0x4000000, 0x4000000, 0x4000000, 0, 8, -671088640, -1073741824, 0x20000000, -805306368, -805306368, -1073741824, 0x20000000, -805306368, -805306368, 64, 0, -671088640, 0, 0, 0, 12288, 12288, 8, 8, 0, 12288, 12288, 49152, 49152, 12288, 12288, 8, 256, 0, 8, 0, 0, 0, 0, 0, 0, 12296, 0, 0, 0, 0x3F0000, 0, 0, 12296, 0x3F0000, 0, 0, 64, 8, 0x800000, 28680, 0, 0x800000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 12296, 64, 64, 0, 0, 0, 8, 0, 64, 8, 0, 64, 64, 12296};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{32768, 0, 524288, 0x400000, 0, 0, 0, 0, 0, 0, 16, 131072, 262144, 0, 0, 0, 0, 0, 0, 0, 0, 0, -8388096, 0, 0, 0, 0, 0, 0, 0, 0x300000, 0x300000, 0, 0, 0, 0, 0, 3, 1, 0, 1, 1, 1, 0, 1, 1, 0, 12, 3, 0, 0, 0, 0, 0, 260047360, 260047360, 0, 0, 0, 0, 0, 0, 0, 260047360, 0, 0, 260047360, -268435456, 0, 128, 96, 96, 128, -8371712, 128, 128, 128, 0, 8320, 16384, -8388096, 0, 128, 128, 0, 0, 0, -8388096, 0x7800000, 0, 0xF800000, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0, -1610612736, 0, 512, -268435456, 0x10000000, 512, 0x40000000, 512, Integer.MIN_VALUE, 0, 512, 0, 0, 0, 0, 260047360, 0, 0, 0, 0, -1073741824, 0, 0, 0, 0, -1073741824, 0, 0, -8388096};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -3073, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12928, 0, 515, 0, 0, 0, 0, 0, -3073, 0, 0, 0, 0, 0, 0, -3073, 0, 0, 0, 0, 0, 0, -3073, 0, 0, 0, 12, 0, 0, 380, 256, 0, 0, 0, 3, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, -15492, -15492, 0, 0, 536854528, -536870912, 2049, 0, 0, 0, 0, 3073, 0, 0, -3073};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 393216, 393216, 0, 393216, 0, 408703, 0, 0, 0, 393216, 0, 0, 0, 0, 0, 0, 393216, 0, 393216, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 14336, 12288, 0, 0, 407552, 408576, 393216, 0, 0, 0, 0, 0, 0, 407552, 0, 0, 408576, 0, 393216, 0, 0, 0, 0, 408703, 0, 0, 0, 0, 0, 0, 408703, 0, 0, 0, 0, 0, 0, 408703, 0, 0, 0, 0, 393216, 393216, 0, 0, 0, 393216, 1024, 0, 0, 1024, 0, 1024, 0, 0, 1024, 0, 0, 0, 262207, 407615, 0, 0, 0, 31, 0, 0, 262144, 0, 0, 262144, 0, 0, 408703};
    }

    public ADQLGrammar201(InputStream stream) {
        this(stream, null);
    }

    public ADQLGrammar201(InputStream stream, String encoding) {
        int i;
        this.enable_tracing();
        this.jj_expentries = new ArrayList<int[]>();
        this.jj_kind = -1;
        this.jj_lasttokens = new int[100];
        this.trace_indent = 0;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new ADQLGrammar201TokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 125; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    @Override
    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 125; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ADQLGrammar201(Reader stream) {
        int i;
        this.enable_tracing();
        this.jj_expentries = new ArrayList<int[]>();
        this.jj_kind = -1;
        this.jj_lasttokens = new int[100];
        this.trace_indent = 0;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ADQLGrammar201TokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 125; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new ADQLGrammar201TokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 125; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ADQLGrammar201(ADQLGrammar201TokenManager tm) {
        int i;
        this.enable_tracing();
        this.jj_expentries = new ArrayList<int[]>();
        this.jj_kind = -1;
        this.jj_lasttokens = new int[100];
        this.trace_indent = 0;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 125; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(ADQLGrammar201TokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 125; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            this.trace_token(this.token, "");
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        this.trace_token(this.token, " (in getNextToken)");
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[116];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 125; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) == 0) continue;
                la1tokens[96 + j] = true;
            }
        }
        for (i = 0; i < 116; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    @Override
    public final void enable_tracing() {
        this.trace_enabled = true;
    }

    @Override
    public final void disable_tracing() {
        this.trace_enabled = false;
    }

    protected void trace_call(String s) {
        if (this.trace_enabled) {
            for (int i = 0; i < this.trace_indent; ++i) {
                System.out.print(" ");
            }
            System.out.println("Call:\t" + s);
        }
        this.trace_indent += 2;
    }

    protected void trace_return(String s) {
        this.trace_indent -= 2;
        if (this.trace_enabled) {
            for (int i = 0; i < this.trace_indent; ++i) {
                System.out.print(" ");
            }
            System.out.println("Return: " + s);
        }
    }

    protected void trace_token(Token t, String where) {
        if (this.trace_enabled) {
            for (int i = 0; i < this.trace_indent; ++i) {
                System.out.print(" ");
            }
            System.out.print("Consumed token: <" + tokenImage[t.kind]);
            if (t.kind != 0 && !tokenImage[t.kind].equals("\"" + t.image + "\"")) {
                System.out.print(": \"" + TokenMgrError.addEscapes(t.image) + "\"");
            }
            System.out.println(" at line " + t.beginLine + " column " + t.beginColumn + ">" + where);
        }
    }

    protected void trace_scan(Token t1, int t2) {
        if (this.trace_enabled) {
            for (int i = 0; i < this.trace_indent; ++i) {
                System.out.print(" ");
            }
            System.out.print("Visited token: <" + tokenImage[t1.kind]);
            if (t1.kind != 0 && !tokenImage[t1.kind].equals("\"" + t1.image + "\"")) {
                System.out.print(": \"" + TokenMgrError.addEscapes(t1.image) + "\"");
            }
            System.out.println(" at line " + t1.beginLine + " column " + t1.beginColumn + ">; Expected token: <" + tokenImage[t2] + ">");
        }
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 32; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                            break;
                        }
                        case 28: {
                            this.jj_3_29();
                            break;
                        }
                        case 29: {
                            this.jj_3_30();
                            break;
                        }
                        case 30: {
                            this.jj_3_31();
                            break;
                        }
                        case 31: {
                            this.jj_3_32();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        ADQLGrammar201.jj_la1_init_0();
        ADQLGrammar201.jj_la1_init_1();
        ADQLGrammar201.jj_la1_init_2();
        ADQLGrammar201.jj_la1_init_3();
        jj_ls = new LookaheadSuccess();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

