//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift Logging API open source project
//
// Copyright (c) 2018-2019 Apple Inc. and the Swift Logging API project authors
// Licensed under Apache License v2.0
//
// See LICENSE.txt for license information
// See CONTRIBUTORS.txt for the list of Swift Logging API project authors
//
// SPDX-License-Identifier: Apache-2.0
//
//===----------------------------------------------------------------------===//
//
// LoggingTest+XCTest.swift
//
import XCTest

///
/// NOTE: This file was generated by generate_linux_tests.rb
///
/// Do NOT edit this file directly as it will be regenerated automatically when needed.
///

extension LoggingTest {
    static var allTests: [(String, (LoggingTest) -> () throws -> Void)] {
        return [
            ("testAutoclosure", testAutoclosure),
            ("testMultiplex", testMultiplex),
            ("testMultiplexLogHandlerWithVariousLogLevels", testMultiplexLogHandlerWithVariousLogLevels),
            ("testMultiplexLogHandlerNeedNotMaterializeValuesMultipleTimes", testMultiplexLogHandlerNeedNotMaterializeValuesMultipleTimes),
            ("testMultiplexLogHandlerMetadata_settingMetadataThroughToUnderlyingHandlers", testMultiplexLogHandlerMetadata_settingMetadataThroughToUnderlyingHandlers),
            ("testMultiplexLogHandlerMetadata_readingHandlerMetadata", testMultiplexLogHandlerMetadata_readingHandlerMetadata),
            ("testMultiplexMetadataProviderSet", testMultiplexMetadataProviderSet),
            ("testMultiplexMetadataProviderExtract", testMultiplexMetadataProviderExtract),
            ("testDictionaryMetadata", testDictionaryMetadata),
            ("testListMetadata", testListMetadata),
            ("testStringConvertibleMetadata", testStringConvertibleMetadata),
            ("testAutoClosuresAreNotForcedUnlessNeeded", testAutoClosuresAreNotForcedUnlessNeeded),
            ("testLocalMetadata", testLocalMetadata),
            ("testCustomFactory", testCustomFactory),
            ("testAllLogLevelsExceptCriticalCanBeBlocked", testAllLogLevelsExceptCriticalCanBeBlocked),
            ("testAllLogLevelsWork", testAllLogLevelsWork),
            ("testAllLogLevelByFunctionRefWithSource", testAllLogLevelByFunctionRefWithSource),
            ("testAllLogLevelByFunctionRefWithoutSource", testAllLogLevelByFunctionRefWithoutSource),
            ("testLogsEmittedFromSubdirectoryGetCorrectModuleInNewerSwifts", testLogsEmittedFromSubdirectoryGetCorrectModuleInNewerSwifts),
            ("testLogMessageWithStringInterpolation", testLogMessageWithStringInterpolation),
            ("testLoggingAString", testLoggingAString),
            ("testMultiplexMetadataProviderMergesInSpecifiedOrder", testMultiplexMetadataProviderMergesInSpecifiedOrder),
            ("testLoggerWithoutFactoryOverrideDefaultsToUsingLoggingSystemMetadataProvider", testLoggerWithoutFactoryOverrideDefaultsToUsingLoggingSystemMetadataProvider),
            ("testLoggerWithPredefinedLibraryMetadataProvider", testLoggerWithPredefinedLibraryMetadataProvider),
            ("testLoggerWithFactoryOverrideDefaultsToUsingLoggingSystemMetadataProvider", testLoggerWithFactoryOverrideDefaultsToUsingLoggingSystemMetadataProvider),
            ("testMultiplexerIsValue", testMultiplexerIsValue),
            ("testLoggerWithGlobalOverride", testLoggerWithGlobalOverride),
            ("testLogLevelCases", testLogLevelCases),
            ("testLogLevelOrdering", testLogLevelOrdering),
            ("testStreamLogHandlerWritesToAStream", testStreamLogHandlerWritesToAStream),
            ("testStreamLogHandlerOutputFormat", testStreamLogHandlerOutputFormat),
            ("testStreamLogHandlerOutputFormatWithMetaData", testStreamLogHandlerOutputFormatWithMetaData),
            ("testStreamLogHandlerOutputFormatWithOrderedMetadata", testStreamLogHandlerOutputFormatWithOrderedMetadata),
            ("testStreamLogHandlerWritesIncludeMetadataProviderMetadata", testStreamLogHandlerWritesIncludeMetadataProviderMetadata),
            ("testStdioOutputStreamWrite", testStdioOutputStreamWrite),
            ("testStdioOutputStreamFlush", testStdioOutputStreamFlush),
            ("testOverloadingError", testOverloadingError),
            ("testCompileInitializeStandardStreamLogHandlersWithMetadataProviders", testCompileInitializeStandardStreamLogHandlersWithMetadataProviders),
        ]
    }
}
