
[//000000001]: # (clock\_iso8601 \- Date/Time Utilities)
[//000000002]: # (Generated from file 'iso8601\.man' by tcllib/doctools with format 'markdown')
[//000000003]: # (clock\_iso8601\(n\) 0\.1 tcllib "Date/Time Utilities")

<hr> [ <a href="../../../../toc.md">Main Table Of Contents</a> &#124; <a
href="../../../toc.md">Table Of Contents</a> &#124; <a
href="../../../../index.md">Keyword Index</a> &#124; <a
href="../../../../toc0.md">Categories</a> &#124; <a
href="../../../../toc1.md">Modules</a> &#124; <a
href="../../../../toc2.md">Applications</a> ] <hr>

# NAME

clock\_iso8601 \- Parsing ISO 8601 dates/times

# <a name='toc'></a>Table Of Contents

  - [Table Of Contents](#toc)

  - [Synopsis](#synopsis)

  - [Description](#section1)

  - [Date formats](#section2)

  - [Bugs, Ideas, Feedback](#section3)

  - [Category](#category)

# <a name='synopsis'></a>SYNOPSIS

package require Tcl 8\.5  
package require clock::iso8601 ?0\.1?  

[__::clock::iso8601 parse\_date__ *date* *options\.\.\.*](#1)  
[__::clock::iso8601 parse\_time__ *time* *options\.\.\.*](#2)  

# <a name='description'></a>DESCRIPTION

This package provides functionality to parse dates and times in ISO 8601 format\.

  - <a name='1'></a>__::clock::iso8601 parse\_date__ *date* *options\.\.\.*

    This command parses an ISO8601 date string in an unknown variant and returns
    the given date/time in seconds since epoch\.

    The acceptable options are __\-base__, __\-gmt__, __\-locale__, and
    __\-timezone__ of the builtin command __clock scan__\.

  - <a name='2'></a>__::clock::iso8601 parse\_time__ *time* *options\.\.\.*

    This command parses a full ISO8601 timestamp string \(date and time\) in an
    unknown variant and returns the given time in seconds since epoch\.

    The acceptable options are __\-base__, __\-gmt__, __\-locale__, and
    __\-timezone__ of the builtin command __clock scan__\.

# <a name='section2'></a>Date formats

The commands accept the following 23 date formats:

    (year)-(month)-(day)
    (year)(month)(day)
    (year)-(day in year)
    (year)(day in year)
    (year in century)-(month)-(day)
    (year)-(month)			Day defaults to the 1st of the month
    (year in century)(month)(day)
    (year in century)-(day in year)
    (year in century)(day in year)
    --(month)-(day)			Year defaults to the current year
    --(month)(day)			Year defaults to the current year
    --(day in year)			Year defaults to the current year
    ---(day)  		        Year defaults to the current year, month to current month
    (fiscal year)-W(week)-(wday)
    (fiscal year)W(week)-(wday)
    (fiscal year in century)-W(week)-(wday)
    (fiscal year in century)W(week)(wday)
    (fiscal year)-W(week)		Weekday defaults to monday
    (fiscal year)W(week)		Weekday defaults to monday
    -W(week)-(wday)			Year defaults to current fiscal year
    -W(week)(wday)			Year defaults to current fiscal year
    (wday)				Year defaults to current fiscal year, week to current week
    (year)				Month defaults to january, day to 1st of the month

The possible parts/fields in the above, and their meanings, are:

  - year

    Year with century, 4 digits

  - month

    Month in year, 2 digits

  - day

    Day in month, 2 digits\.

  - year in century

    Year without century, 2 digits

  - day in year

    Day in year, 3 digits

  - fiscal year

    ISO 8601 fiscal year with century, 4 digits

  - fiscal year in century

    ISO 8601 fiscal year without century, 2 digits

  - week

    ISO 8601 week number

  - wday

    Week day, 1 digit, Monday \(1\) to Sunday \(7,0\)

# <a name='section3'></a>Bugs, Ideas, Feedback

This document, and the package it describes, will undoubtedly contain bugs and
other problems\. Please report such in the category *clock::iso8601* of the
[Tcllib Trackers](http://core\.tcl\.tk/tcllib/reportlist)\. Please also report
any ideas for enhancements you may have for either package and/or documentation\.

When proposing code changes, please provide *unified diffs*, i\.e the output of
__diff \-u__\.

Note further that *attachments* are strongly preferred over inlined patches\.
Attachments can be made by going to the __Edit__ form of the ticket
immediately after its creation, and then using the left\-most button in the
secondary navigation bar\.

# <a name='category'></a>CATEGORY

Text processing
