## TFSA-2021-129: Heap OOB in `ResourceScatterUpdate`

### CVE Number
CVE-2021-37655

### Impact
An attacker can trigger a read from outside of bounds of heap allocated data by
sending invalid arguments to `tf.raw_ops.ResourceScatterUpdate`:

```python
import tensorflow as tf

v = tf.Variable([b'vvv'])
tf.raw_ops.ResourceScatterUpdate(
  resource=v.handle,
  indices=[0],
  updates=['1', '2', '3', '4', '5'])
```

The
[implementation](https://github.com/tensorflow/tensorflow/blob/f24faa153ad31a4b51578f8181d3aaab77a1ddeb/tensorflow/core/kernels/resource_variable_ops.cc#L919-L923)
has an incomplete validation of the relationship between the shapes of `indices`
and `updates`: instead of checking that the shape of `indices` is a prefix of
the shape of `updates` (so that broadcasting can happen), code only checks that
the number of elements in these two tensors are in a divisibility relationship.

### Patches
We have patched the issue in GitHub commit
[01cff3f986259d661103412a20745928c727326f](https://github.com/tensorflow/tensorflow/commit/01cff3f986259d661103412a20745928c727326f).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, TensorFlow 2.4.3, and TensorFlow 2.3.4, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
