## TFSA-2021-197: Incomplete validation in `tf.summary.create_file_writer`

### CVE Number
CVE-2021-41200

### Impact
If `tf.summary.create_file_writer` is called with non-scalar arguments code crashes due to a `CHECK`-fail.

```python
import tensorflow as tf
import numpy as np
tf.summary.create_file_writer(logdir='', flush_millis=np.ones((1,2)))
```

### Patches
We have patched the issue in GitHub commit [874bda09e6702cd50bac90b453b50bcc65b2769e](https://github.com/tensorflow/tensorflow/commit/874bda09e6702cd50bac90b453b50bcc65b2769e) (merging [#51715](https://github.com/tensorflow/tensorflow/pull/51715)).

The fix will be included in TensorFlow 2.7.0. We will also cherrypick this commit on TensorFlow 2.6.1, TensorFlow 2.5.2, and TensorFlow 2.4.4, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported externally via a [GitHub issue](https://github.com/tensorflow/tensorflow/issues/46909).
