.TH TWILL 1 "16 February 2024" "Web2C @VERSION@"
.\"=====================================================================
.if n .ds MF Metafont
.if t .ds MF Metafont
.if n .ds TX TeX
.if t .ds TX \fRT\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X\fP
.ie t .ds OX \fIT\v'+0.25m'E\v'-0.25m'X\fP
.el .ds OX TeX
.\" BX definition must follow TX so BX can use TX
.if n .ds BX BibTeX
.if t .ds BX \fRB\s-2IB\s0\fP\*(TX
.\" LX definition must follow TX so LX can use TX
.if n .ds LX LaTeX
.if t .ds LX \fRL\\h'-0.36m'\\v'-0.15v'\s-2A\s0\\h'-0.15m'\\v'0.15v'\fP\*(TX
.if n .ds WB Web
.if t .ds WB W\s-2EB\s0
.\"=====================================================================
.SH NAME
twill, twill-refsort \- translate \*(WB to \*(TX with mini-indexes
.SH SYNOPSIS
.PP
\f[B]twill\f[R] [\f[B]\-x\f[R]]
\f[I]webfile\f[R][\f[B].web\f[R]]
[{\f[I]changefile\f[R][\f[B].ch\f[R]]|\f[B]\-\f[R]}
[\f[I]outfile\f[R][\f[B].tex\f[R]]]]
.PD 0
.PP
\f[B]twill-refsort\f[R] <
\f[I]reffile\f[B].ref\f[R] >
\f[I]sreffile\f[B].sref\f[R]
.PD
.\"=====================================================================
.SH DESCRIPTION
The
.B twill
program is used to create a \*(TX file for viewing a \*(WB program.
It takes appropriate care of typographic details like page
layout and the use of indentation, italics, boldface, etc., and it supplies
extensive cross-index information in the form of 'mini-indexes' for each
spread of pages and a 'master index' at the end that it gathers automatically.
.PP
The command line arguments are the same as for
.B weave
including the option:
.B \-x
says to omit the indexes, module name list, and table of contents pages.
(A
.I CONTENTS.tex
file will still be written when the \*(TX file is processed,
however, unless some macros in
.I twimac-web.tex
are redefined.)
.PP
The output \*(TX file name is formed by adding
.B .tex
to the root of the \*(WB file name.
.PP
There are several macros that probably should be redefined by
the programmer at the beginning of the \*(WB file.
It is a good idea to set \\title to the name of the program.
.PP
.B twill
is exactly like
.B weave
except that it produces better documentation, for which you must work harder.
You should run
.B twill
twice, once to prime the pump and once to get decent answers.
Moreover, you must run the output twice through \*(TX.
.PP
After
.B tex foo
you will have output that looks like final pages
except that the entries of mini-indexes won\[cq]t be alphabetized.
The first run produces a weird file called
.B foo.ref.
Say
.B twill-refsort < foo.ref > foo.sref
and then another
.B tex foo
will produce alphabetized output.
.\"=====================================================================
.SH ENVIRONMENT
The environment variable WEBINPUTS is used to search for the input files,
or the system default if WEBINPUTS is not set.  See
.BR tex (1)
for the details of the searching.
.\"=====================================================================
.SH FILES
.TP \w'@@'u+2n
.I $TEXMFMAIN/tex/plain/cweb/cwebbin/twimac-web.tex
\*(TX macros used by
.B twill
output.
.\"=====================================================================
.SH "SEE ALSO"
.BR tangle (1)
for references, authors, and other information.
