#!/bin/bash -e
AGGREGATOR_PATH=git://git.eclipse.org/gitroot/platform/eclipse.platform.releng.aggregator.git
TAG=R4_5_1

rm -rf R4_platform-aggregator-$TAG
rm -rf R4_platform-aggregator-$TAG.tar.xz

# adding --depth 1 here may result in a quicker clone, but did not work for me
git clone --depth 1 --branch $TAG  $AGGREGATOR_PATH R4_platform-aggregator-$TAG

pushd R4_platform-aggregator-$TAG

git submodule init
git submodule update

rm -rf bootstrap devutils streams scripts

# Comment this line to get a shallow clone.
find . -type d -name ".git" | xargs rm -rf

# Delete pre-built binary artifacts except some test data that cannot be generated
find . ! -path "*/JCL/*" \
   -type f -name *.jar -delete
find . -type f -name *.class -delete
find . -type f -name *.so -delete
find . -type f -name *.dll -delete
find . -type f -name *.jnilib -delete
find . -type f -name *.exe -delete
# Remove pre-compiled native launchers
rm -rf rt.equinox.binaries/org.eclipse.equinox.executable/{bin,contributed}/

#now, we keep only bundles required by Tycho
BUNDLES="../eclipse-bundles-for-tycho"
mkdir -p $BUNDLES

mv eclipse.platform.runtime/bundles/org.eclipse.core.runtime/* $BUNDLES
mv eclipse.platform.runtime/bundles/org.eclipse.core.contenttype/src/* $BUNDLES
mv eclipse.platform.runtime/bundles/org.eclipse.core.jobs/src/* $BUNDLES
mv rt.equinox.p2/bundles/org.eclipse.equinox.p2.core/* $BUNDLES
mv rt.equinox.p2/bundles/org.eclipse.equinox.p2.metadata/* $BUNDLES
mv rt.equinox.p2/bundles/org.eclipse.equinox.p2.publisher/src/* $BUNDLES
mv rt.equinox.p2/bundles/org.eclipse.equinox.p2.publisher.eclipse/* $BUNDLES
mv rt.equinox.p2/bundles/org.eclipse.equinox.p2.repository/* $BUNDLES
mv rt.equinox.p2/bundles/org.eclipse.equinox.p2.metadata.repository/* $BUNDLES
mv rt.equinox.p2/bundles/org.eclipse.equinox.p2.artifact.repository/src/* $BUNDLES
mv rt.equinox.p2/bundles/org.eclipse.equinox.p2.jarprocessor/src/* $BUNDLES
mv rt.equinox.p2/bundles/org.eclipse.equinox.simpleconfigurator/src/* $BUNDLES
mv rt.equinox.p2/bundles/org.eclipse.equinox.simpleconfigurator.manipulator/* $BUNDLES
mv rt.equinox.p2/bundles/org.eclipse.equinox.frameworkadmin/src/* $BUNDLES
mv rt.equinox.p2/bundles/org.eclipse.equinox.frameworkadmin.equinox/src/* $BUNDLES
mv rt.equinox.framework/bundles/org.eclipse.osgi.util/src/* $BUNDLES
mv rt.equinox.framework/bundles/org.eclipse.osgi/container/src/* $BUNDLES
mv rt.equinox.framework/bundles/org.eclipse.osgi/supplement/src/* $BUNDLES
mv rt.equinox.bundles/bundles/org.eclipse.equinox.preferences/src/* $BUNDLES
mv rt.equinox.bundles/bundles/org.eclipse.equinox.preferences/src/* $BUNDLES
mv rt.equinox.bundles/bundles/org.eclipse.equinox.common/src/* $BUNDLES
mv rt.equinox.bundles/bundles/org.eclipse.equinox.security/src/* $BUNDLES
mv rt.equinox.bundles/bundles/org.eclipse.equinox.app/src/* $BUNDLES
mv rt.equinox.bundles/bundles/org.eclipse.equinox.registry/src/* $BUNDLES

mv rt.equinox.framework/bundles/org.eclipse.osgi.compatibility.state/src/* $BUNDLES
mv rt.equinox.framework/bundles/org.eclipse.osgi/felix/src/* $BUNDLES

mv rt.equinox.p2/bundles/org.eclipse.equinox.p2.repository.tools/* $BUNDLES
mv rt.equinox.framework/bundles/org.eclipse.osgi/osgi/src/* $BUNDLES
mv rt.equinox.bundles/bundles/org.eclipse.equinox.app/osgi/* $BUNDLES
mv rt.equinox.framework/bundles/org.eclipse.osgi.services/src/* $BUNDLES
mv rt.equinox.p2/bundles/org.eclipse.equinox.p2.director/src/* $BUNDLES
mv rt.equinox.p2/bundles/org.eclipse.equinox.p2.engine/* $BUNDLES
mv rt.equinox.p2/bundles/org.eclipse.equinox.p2.jarprocessor/src_ant/* $BUNDLES

#$MAVEN_BIN compile              #first 1546 files 26sec

#need SteppedTimeoutLexicoHelper from sat4j 2.3.4

mv rt.equinox.p2/bundles/org.eclipse.equinox.p2.touchpoint.eclipse/src/* $BUNDLES
mv rt.equinox.p2/bundles/org.eclipse.equinox.p2.garbagecollector/src/* $BUNDLES
mv rt.equinox.p2/bundles/org.eclipse.equinox.p2.updatesite/src/* $BUNDLES
mv rt.equinox.p2/bundles/org.eclipse.equinox.p2.director.app/src/* $BUNDLES
mv eclipse.platform.team/bundles/org.eclipse.core.net/src/* $BUNDLES

#$MAVEN_BIN compile             #here 1663 files 28sec

mv eclipse.platform.swt/bundles/org.eclipse.swt/Eclipse\ SWT/common/* $BUNDLES
mv eclipse.platform.swt/bundles/org.eclipse.swt/Eclipse\ SWT/cairo/* $BUNDLES
mv eclipse.platform.swt/bundles/org.eclipse.swt/Eclipse\ SWT/gtk/* $BUNDLES
mv eclipse.platform.swt/bundles/org.eclipse.swt/Eclipse\ SWT/emulated/taskbar/* $BUNDLES
mv eclipse.platform.swt/bundles/org.eclipse.swt/Eclipse\ SWT/emulated/bidi/* $BUNDLES
mv eclipse.platform.swt/bundles/org.eclipse.swt/Eclipse\ SWT/emulated/coolbar/* $BUNDLES
mv eclipse.platform.swt/bundles/org.eclipse.swt/Eclipse\ SWT/common_j2se/* $BUNDLES
mv eclipse.platform.swt/bundles/org.eclipse.swt/Eclipse\ SWT\ Custom\ Widgets/common/* $BUNDLES
mv eclipse.platform.swt/bundles/org.eclipse.swt/Eclipse\ SWT\ Printing/common/* $BUNDLES
mv eclipse.platform.swt/bundles/org.eclipse.swt/Eclipse\ SWT\ Printing/gtk/* $BUNDLES
mv eclipse.platform.swt/bundles/org.eclipse.swt/Eclipse\ SWT\ Drag\ and\ Drop/common/* $BUNDLES
mv eclipse.platform.swt/bundles/org.eclipse.swt/Eclipse\ SWT\ Drag\ and\ Drop/gtk/* $BUNDLES
mv eclipse.platform.swt/bundles/org.eclipse.swt/Eclipse\ SWT\ PI/common/* $BUNDLES
mv eclipse.platform.swt/bundles/org.eclipse.swt/Eclipse\ SWT\ PI/common_j2se/* $BUNDLES
mv eclipse.platform.swt/bundles/org.eclipse.swt/Eclipse\ SWT\ PI/cairo/* $BUNDLES
mv eclipse.platform.swt/bundles/org.eclipse.swt/Eclipse\ SWT\ PI/gtk/* $BUNDLES
mv eclipse.platform.swt/bundles/org.eclipse.swt/Eclipse\ SWT\ Accessibility/common/* $BUNDLES
mv eclipse.platform.swt/bundles/org.eclipse.swt/Eclipse\ SWT\ Accessibility/gtk/* $BUNDLES
mv eclipse.platform.swt/bundles/org.eclipse.swt/Eclipse\ SWT\ Browser/common/* $BUNDLES
mv eclipse.platform.swt/bundles/org.eclipse.swt/Eclipse\ SWT\ Browser/gtk/* $BUNDLES
mv eclipse.platform.swt/bundles/org.eclipse.swt/Eclipse\ SWT\ Mozilla/common/* $BUNDLES
mv eclipse.platform.swt/bundles/org.eclipse.swt/Eclipse\ SWT\ Mozilla/gtk/* $BUNDLES
mv eclipse.platform.swt/bundles/org.eclipse.swt/Eclipse\ SWT\ WebKit/gtk/* $BUNDLES
mv eclipse.platform.swt/bundles/org.eclipse.swt/Eclipse\ SWT\ Program/common/* $BUNDLES
mv eclipse.platform.swt/bundles/org.eclipse.swt/Eclipse\ SWT\ Program/gtk/* $BUNDLES
mv eclipse.platform.swt/bundles/org.eclipse.swt/Eclipse\ SWT\ Program/gnome/* $BUNDLES
mv eclipse.platform.swt/bundles/org.eclipse.swt/Eclipse\ SWT\ Program/cde/* $BUNDLES

#$MAVEN_BIN compile             #here 2226 files 35sec

mv eclipse.jdt.core/org.eclipse.jdt.core/compiler/* $BUNDLES
mv eclipse.jdt.core/org.eclipse.jdt.core/batch/* $BUNDLES
mv eclipse.jdt.core/org.eclipse.jdt.core/model/* $BUNDLES
mv eclipse.jdt.core/org.eclipse.jdt.core/codeassist/* $BUNDLES
mv eclipse.jdt.core/org.eclipse.jdt.core/search/* $BUNDLES
mv eclipse.jdt.core/org.eclipse.jdt.core/dom/* $BUNDLES
mv eclipse.jdt.core/org.eclipse.jdt.core/formatter/* $BUNDLES
mv eclipse.jdt.core/org.eclipse.jdt.core/eval/* $BUNDLES
mv eclipse.platform.text/org.eclipse.text/src/* $BUNDLES
mv eclipse.platform.text/org.eclipse.text/projection/* $BUNDLES
mv eclipse.platform.text/org.eclipse.jface.text/src/* $BUNDLES
mv eclipse.platform.text/org.eclipse.jface.text/projection/* $BUNDLES
mv eclipse.platform.ui/bundles/org.eclipse.core.commands/* $BUNDLES
mv eclipse.platform.ui/bundles/org.eclipse.jface/src/* $BUNDLES
mv eclipse.platform.runtime/bundles/org.eclipse.core.expressions/src/* $BUNDLES
mv rt.equinox.bundles/bundles/org.eclipse.equinox.bidi/src/* $BUNDLES
mv eclipse.platform.resources/bundles/org.eclipse.core.resources/src/* $BUNDLES
mv eclipse.platform.resources/bundles/org.eclipse.core.filesystem/src/* $BUNDLES

popd

echo "FIXME: here I would delete $(pwd)/R4_platform-aggregator-$TAG" 
#rm -rf R4_platform-aggregator-$TAG

